// |reftest| shell-option(--enable-iterator-helpers) skip-if(!this.hasOwnProperty('Iterator')||!xulRuntime.shell) -- iterator-helpers is not enabled unconditionally, requires shell-options
// Copyright (C) 2024 Mozilla Corporation. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
esid: pending
description: |
  %Iterator.prototype%.flatMap closes the iterator and throws when mapped isn't iterable.
info: |
  Iterator Helpers proposal 2.1.5.7 1. Repeat,
    ...
    f. Let innerIterator be GetIteratorFlattenable(mapped).
    g. IfAbruptCloseIterator(innerIterator, iterated).
features:
  - iterator-helpers
includes: [sm/non262.js, sm/non262-shell.js]
flags:
  - noStrict
---*/
class InvalidIterable {
  [Symbol.iterator]() {
    return {};
  }
}

class TestIterator extends Iterator {
  next() {
    return {done: false, value: 0};
  }

  closed = false;
  return() {
    this.closed = true;
    return {done: true};
  }
}

const nonIterables = [
  new InvalidIterable(),
  undefined,
  null,
  0,
  false,
  Symbol(''),
  0n,
  {},
];

for (const value of nonIterables) {
  const iter = new TestIterator();
  const mapped = iter.flatMap(x => value);

  assert.sameValue(iter.closed, false);
  assertThrowsInstanceOf(() => mapped.next(), TypeError);
  assert.sameValue(iter.closed, true);
}


reportCompare(0, 0);
