#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Technobabylon
# send your bug reports to bugs@dotslashplay.it
###

script_version=20240915.2

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='technobabylon'
GAME_NAME='Technobabylon'

ARCHIVE_BASE_4_NAME='technobabylon_3_0_5_72309.sh'
ARCHIVE_BASE_4_MD5='42a3d460d92a5a778d009eebd7b2b867'
ARCHIVE_BASE_4_SIZE='1374766'
ARCHIVE_BASE_4_VERSION='3.0.5-gog72309'
ARCHIVE_BASE_4_URL='https://www.gog.com/game/technobabylon'

ARCHIVE_BASE_3_NAME='technobabylon_3_0_1_66582.sh'
ARCHIVE_BASE_3_MD5='6ddf6ed6e8df026f548025a90585a382'
ARCHIVE_BASE_3_SIZE='1400000'
ARCHIVE_BASE_3_VERSION='3.0.1-gog66582'

ARCHIVE_BASE_2_NAME='technobabylon_3_0_66305.sh'
ARCHIVE_BASE_2_MD5='5d522aa6349e26596e7a6e0ad3c5ff19'
ARCHIVE_BASE_2_SIZE='1400000'
ARCHIVE_BASE_2_VERSION='3.0-gog66305'

ARCHIVE_BASE_1_NAME='technobabylon_2_5a_57810.sh'
ARCHIVE_BASE_1_MD5='108abcf43ca17438717ddbad13a00f69'
ARCHIVE_BASE_1_SIZE='1400000'
ARCHIVE_BASE_1_VERSION='2.5a-gog57810'

ARCHIVE_BASE_0_NAME='technobabylon_2_1_53388.sh'
ARCHIVE_BASE_0_MD5='6bb58eccb57e2195d49266bd8798a9a1'
ARCHIVE_BASE_0_SIZE='1400000'
ARCHIVE_BASE_0_VERSION='2.1-gog53388'

## Optional icons pack
ARCHIVE_OPTIONAL_ICONS_NAME='technobabylon_icons.tar.gz'
ARCHIVE_OPTIONAL_ICONS_MD5='84a7104801c25d5e931fbdd4cc3d1916'
ARCHIVE_OPTIONAL_ICONS_URL='https://downloads.dotslashplay.it/games/technobabylon/'
CONTENT_ICONS_PATH='.'
CONTENT_ICONS_FILES='
64x64'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_MAIN_FILES='
ENGV.tmp
Music
Sounds
*.ags
*.cfg
*.exe
*.ogv
*.tra
*.vox'
CONTENT_DOC_MAIN_FILES='
licenses'

APP_MAIN_SCUMMID='ags:technobabylon'
APP_MAIN_ICON='../support/icon.png'
APP_MAIN_ICON_1='Technobabylon.exe'
APP_MAIN_ICON_0='Technobabylon.exe'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons
content_inclusion_default

# Write launchers

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
