/* Copyright © Triad National Security, LLC, and others.

   Things that didn’t seem to fit anywhere else. */

#define _GNU_SOURCE
#pragma once

#include <stdlib.h>


/** Macros **/

/* C99 does not have noreturn or _Noreturn (those are C11), but GCC, Clang,
   and hopefully others support the following extension. */
#define noreturn __attribute__ ((noreturn)) void

/* Exit codes (see also: test/common.bash, lib/build.py). */
#define EXIT_ERR_MISC 31
#define EXIT_ERR_CMD 49
#define EXIT_ERR_SQUASH 84

/* Define functions as this macro to cause a build error if someone tries to
   use them. */
#define FN_BLOCKED(...) \
        _Pragma("GCC error \"function blocked; see Contributor's Guide\"")

/* FNM_EXTMATCH is a GNU extension to support extended globs in fnmatch(3). If
   not available, define as 0 to ignore this flag. */
#ifndef HAVE_FNM_EXTMATCH
#define FNM_EXTMATCH 0
#endif


/** Types **/

#ifndef HAVE_COMPARISON_FN_T
typedef int (*comparison_fn_t) (const void *, const void *);
#endif


/** External variables **/

extern char *host_tmp;
extern char *username;


/** Function prototypes **/

void run_wait(char *cmd, char *pathx, char **args2, ...);
void username_set(void);
void version(void);
