C> \ingroup nwxc 
C> @{ 
C> 
C> \file nwxcm_c_dldf.F 
C> The nwxcm_c_dldf functional 
C> 
C> @} 
C> 
C> \ingroup nwxc_priv 
C> @{ 
C> 
C> \brief Evaluate the nwxcm_c_dldf functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& {{1}\over{\rho_\alpha^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_2} &=& {{1}\over{\sqrt{\rho_\alpha}}}\\\\ 
C>   {\it t_3} &=& {{1}\over{\rho_\alpha^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_4} &=& {{1}\over{\rho_\alpha^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_5} &=& -6.903522198342671 \times 10^{-18}\,\log 
C>    \left({{16.08197949869254}\over{5.98255043577108\,{\it t_4}
C>    +2.225569421150687\,{\it t_3}+0.8004286349993635\,{\it t_2}
C>    +0.1897004325747558\,{\it t_1}}}+1.0\right)\,
C>    \left(0.1325688999052018\,{\it t_3}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_4}+3.844746237447211\,{\it t_3}+1.644733775567609\,{
C>    \it t_2}+0.2405871291288192\,{\it t_1}}}+1.0\right)\,
C>    \left(0.1274696188700087\,{\it t_3}+1.0\right)\\\\ 
C>   {\it t_6} &=& {{1}\over{\rho_\beta^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_7} &=& {{1}\over{\sqrt{\rho_\beta}}}\\\\ 
C>   {\it t_8} &=& {{1}\over{\rho_\beta^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_9} &=& {{1}\over{\rho_\beta^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{10}} &=& -6.903522198342671 \times 10^{-18}
C>    \,\log \left({{16.08197949869254}\over{5.98255043577108\,{
C>    \it t_9}+2.225569421150687\,{\it t_8}+0.8004286349993635\,{
C>    \it t_7}+0.1897004325747558\,{\it t_6}}}+1.0\right)\,
C>    \left(0.1325688999052018\,{\it t_8}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_9}+3.844746237447211\,{\it t_8}+1.644733775567609\,{
C>    \it t_7}+0.2405871291288192\,{\it t_6}}}+1.0\right)\,
C>    \left(0.1274696188700087\,{\it t_8}+1.0\right)\\\\ 
C>   {\it t_{11}} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_{12}} &=& {{1}\over{{\it t_{11}}^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{13}} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_{14}} &=& {\it t_{13}}^4\\\\ 
C>   {\it t_{15}} &=& {{1}\over{{\it t_{11}}^4}}\\\\ 
C>   {\it t_{16}} &=& {{1}\over{{\it t_{11}}}}\\\\ 
C>   {\it t_{17}} &=& \left({\it t_{13}}\,{\it t_{16}}
C>    +1.0\right)^{{{4}\over{3}}}+\left(1.0-{\it t_{13}}\,{
C>    \it t_{16}}\right)^{{{4}\over{3}}}-2.0\\\\ 
C>   {\it t_{18}} &=& -1.923661050931536\,{\it t_{14}}\,{\it t_{15}}
C>    \,{\it t_{17}}\\\\ 
C>   {\it t_{19}} &=& {{1}\over{{\it t_{11}}^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{20}} &=& {{1}\over{\sqrt{{\it t_{11}}}}}\\\\ 
C>   {\it t_{21}} &=& {{1}\over{{\it t_{11}}^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{22}} &=& {{1}\over{\rho_\alpha^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{23}} &=& {{1}\over{\rho_\beta^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{24}} &=& {\it t_{23}}\,\sigma_{\beta\beta}+{\it t_{22}}
C>    \,\sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{25}} &=& {{1}\over{0.0031\,{\it t_{24}}+1.0}}\\\\ 
C>   {\it t_{26}} &=& {{1}\over{0.06\,{\it t_{22}}\,
C>    \sigma_{\alpha\alpha}+1.0}}\\\\ 
C>   {\it t_{27}} &=& {{1}\over{0.06\,{\it t_{23}}\,
C>    \sigma_{\beta\beta}+1.0}}\\\\ 
C>   {\it t_{28}} &=& {{1}\over{\rho_s^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{29}} &=& {{1}\over{\sqrt{\rho_s}}}\\\\ 
C>   {\it t_{30}} &=& {{1}\over{\rho_s^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{31}} &=& {{1}\over{\rho_s^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{32}} &=& {{1}\over{\rho_s^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{33}} &=& {{1}\over{0.06\,{\it t_{32}}\,\sigma_{ss}
C>    +1.0}}\\\\ 
C>   f &=& {{0.5\,{\it t_{10}}\,\rho_\beta\,\left(0.06\,{\it t_{23}}
C>    \,\sigma_{\beta\beta}\,{\it t_{27}}\,\left(0.133402758\,{
C>    \it t_{23}}\,\sigma_{\beta\beta}\,{\it t_{27}}-2.5960897\right)
C>    +1.0\right)\,\left(2.0\,\tau_\beta-{{0.25\,
C>    \sigma_{\beta\beta}}\over{\rho_\beta}}\right)}\over{\tau_\beta}}
C>    +{{0.5\,{\it t_5}\,\rho_\alpha\,\left(0.06\,{\it t_{22}}
C>    \,\sigma_{\alpha\alpha}\,{\it t_{26}}\,\left(0.133402758\,{
C>    \it t_{22}}\,\sigma_{\alpha\alpha}\,{\it t_{26}}
C>    -2.5960897\right)+1.0\right)\,\left(2.0\,\tau_\alpha-{{0.25
C>    \,\sigma_{\alpha\alpha}}\over{\rho_\alpha}}\right)}
C>    \over{\tau_\alpha}}+1.0\,\left({\it t_{11}}\,\left(
C>    -0.0598079686361971\,{\it t_{14}}\,{\it t_{15}}\,
C>    \left(0.1274696188700087\,{\it t_{12}}+1.0\right)\,{
C>    \it t_{17}}\,\log \left({{32.16395899738507}
C>    \over{11.12037486309469\,{\it t_{21}}+3.844746237447211\,{
C>    \it t_{12}}+1.644733775567609\,{\it t_{20}}+0.2405871291288192
C>    \,{\it t_{19}}}}+1.0\right)+0.01975163132168077\,
C>    \left(0.06901399211255825\,{\it t_{12}}+1.0\right)\,\left({
C>    \it t_{18}}+1.923661050931536\,{\it t_{17}}\right)
C>    \,\log \left({{29.60881320326807}\over{8.15741470348764\,{
C>    \it t_{21}}+2.247591863577616\,{\it t_{12}}+0.4300972471276643
C>    \,{\it t_{20}}+0.1911512595127337\,{\it t_{19}}}}+1.0\right)
C>    -0.0621814\,\left(0.1325688999052018\,{\it t_{12}}+1.0\right)
C>    \,\left({\it t_{18}}+1.0\right)\,\log 
C>    \left({{16.08197949869254}\over{5.98255043577108\,{\it t_{21}}
C>    +2.225569421150687\,{\it t_{12}}+0.8004286349993635\,{
C>    \it t_{20}}+0.1897004325747558\,{\it t_{19}}}}+1.0\right)\right)
C>    -{\it t_{10}}\,\rho_\beta-{\it t_5}\,\rho_\alpha\right)
C>    \,\left(0.0031\,{\it t_{24}}\,{\it t_{25}}\,\left(5.9515308
C>    -0.03459689187\,{\it t_{24}}\,{\it t_{25}}\right)+1.0\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& {{0.5\,\left(-6.903522198342671 \times 10^{-18}
C>    \,\log \left({{16.08197949869254}\over{5.98255043577108\,{
C>    \it t_{31}}+2.225569421150687\,{\it t_{30}}+0.8004286349993635
C>    \,{\it t_{29}}+0.1897004325747558\,{\it t_{28}}}}+1.0\right)
C>    \,\left(0.1325688999052018\,{\it t_{30}}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_{31}}+3.844746237447211\,{\it t_{30}}+1.644733775567609
C>    \,{\it t_{29}}+0.2405871291288192\,{\it t_{28}}}}+1.0\right)
C>    \,\left(0.1274696188700087\,{\it t_{30}}+1.0\right)\right)
C>    \,\rho_s\,\left(0.06\,{\it t_{32}}\,\sigma_{ss}\,{\it t_{33}}
C>    \,\left(0.133402758\,{\it t_{32}}\,\sigma_{ss}\,{\it t_{33}}
C>    -2.5960897\right)+1.0\right)\,\left(2.0\,\tau_s-{{0.25
C>    \,\sigma_{ss}}\over{\rho_s}}\right)}\over{\tau_s}}\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc-Ds [3]. 
C> 
C> ### References ### 
C> 
C> [1] K Pernal, R Podeszwa, K Patkowski, K Szalewicz
C>    , Phys.Rev.Lett. 103, 263201 (2009)  , DOI: 
C> <a href="https://doi.org/10.1103/PhysRevLett.103.263201 "> 
C> 10.1103/PhysRevLett.103.263201 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc-Ds, revision 27207 2015-06-23 
C> 
      subroutine nwxcm_c_dldf(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,tau,fnc,Amat,Cmat,Mmat) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,NCOL_RHO)      !< [Input] The density 
      double precision rgamma(nq,NCOL_GAMMA) !< [Input] The norm of the density 
                                             !< gradients 
      double precision tau(nq,NCOL_TAU)      !< [Input] The kinetic energy density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,NCOL_AMAT)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,NCOL_CMAT)   !< [Output] The derivative wrt rgamma 
      double precision Mmat(nq,NCOL_MMAT)   !< [Output] The derivative wrt tau 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          taua    = 0.5d0*tau(iq,T_T) 
          if (rhoa.gt.tol_rho) then 
            if (taua.gt.tol_rho) then 
              t1 = 1/rhoa**2.6666666666666666d+0
              t2 = 6.2d-3*gammaaa*t1+1.0d+0
              t3 = 1/t2
              t4 = 5.9515308d+0-6.919378374d-2*gammaaa*t1*t3
              t5 = 6.2d-3*gammaaa*t1*t3*t4+1.0d+0
              t6 = 1/rhoa**6.666666666666666d-1
              t7 = rhoa**5.0d-1
              t8 = 1/t7
              t9 = 1/rhoa**3.333333333333333d-1
              t10 = 1/rhoa**1.6666666666666666d-1
              t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.4
     1           058712912881916d-1*t6+1.1120374863094686d+1*t10
              t12 = 3.216395899738507d+1/t11+1.0d+0
              t13 = log(t12)
              t14 = 1.274696188700087d-1*t9+1.0d+0
              t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.8
     1           970043257475583d-1*t6+5.982550435771079d+0*t10
              t16 = 1.6081979498692536d+1/t15+1.0d+0
              t17 = log(t16)
              t18 = 1.3256889990520176d-1*t9+1.0d+0
              t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2
     1           *t13*t14
              t20 = -2*rhoa*t19
              t21 = 6.0d-2*gammaaa*t1+1.0d+0
              t22 = 1/t21
              t23 = 1.3340275799999998d-1*gammaaa*t1*t22-2.5960897d+0
              t24 = 6.0d-2*gammaaa*t1*t22*t23+1.0d+0
              t25 = 1/taua
              t26 = 1/rhoa
              t27 = 2.0d+0*taua-2.5d-1*gammaaa*t26
              t28 = 1.414213562373095d+0
              t29 = 7.937005259840998d-1
              t30 = 2.2255694211506874d+0*t29*t9+8.004286349993635d-1*t8
     1           /t28+1.1950378408754898d-1*t6+5.329846514438382d+0*t10
              t31 = 1.6081979498692536d+1/t30+1.0d+0
              t32 = log(t31)
              t33 = 1.3256889990520176d-1*t29*t9+1.0d+0
              t34 = 1/rhoa**1.6666666666666669d+0
              t35 = 1/t7**3
              t36 = 1/rhoa**1.3333333333333333d+0
              t37 = 1/rhoa**1.1666666666666667d+0
              t38 = 1.1102230246251565d-16*t18*(-9.970917392951799d-1*t3
     1           7-7.418564737168958d-1*t36-4.002143174996817d-1*t35-1.2
     2           64669550498372d-1*t34)/(t15**2*t16)+1.0d+0*t14*(-1.8533
     3           958105157808d+0*t37-1.2815820791490704d+0*t36-8.2236688
     4           77838045d-1*t35-1.6039141941921276d-1*t34)/(t11**2*t12)
     5           +3.0506411443514264d-19*t17*t36+1.3210398931339265d-3*t
     6           13*t36
              t39 = 3.968502629920499d-1
              t40 = gammaaa**2
              t41 = 1/t2**2
              t42 = 1/rhoa**6.333333333333333d+0
              t43 = 1/rhoa**3.6666666666666664d+0
              t44 = t20-1.243628d-1*rhoa*t32*t33
              t45 = 1/t21**2
              t46 = 1/rhoa**5.333333333333333d+0
              fnc(iq) = (1.0d+0*t5*(t20-1.243628d-1*rhoa*(1.052200055838
     1           9212d-1*t9+1.0d+0)*log(1.6081979498692536d+1/(1.7664356
     2           20181429d+0*t9+5.659885156639418d-1*t8+1.19503784087549
     3           d-1*t6+5.329846514438383d+0*t10)+1.0d+0))+1.0d+0*rhoa*t
     4           19*t24*t25*t27)*wght+fnc(iq)
              Amat(iq,D1_RA) = (1.0d+0*(2*rhoa*(1.0d+0*t33*(-7.418564737
     1           168958d-1*t36*t39-4.4415387620319857d-1*t37-4.002143174
     2           996817d-1*t35/t28**3-3.9834594695849657d-2*t34)/(t30**2
     3           *t31)+2.747773264188437d-3*t32*t36*t39)-rhoa*t38-6.2181
     4           4d-2*t32*t33+6.903522198342671d-18*t17*t18+3.1090699999
     5           999993d-2*t13*t14)*t5+t25*(5.0d-1*rhoa*t19*t27*(6.0d-2*
     6           gammaaa*t1*t22*(2.1344441279999993d-2*t40*t42*t45-3.557
     7           406879999999d-1*gammaaa*t22*t43)+9.599999999999997d-3*t
     8           23*t40*t42*t45-1.5999999999999998d-1*gammaaa*t22*t23*t4
     9           3)+5.0d-1*rhoa*t24*t27*t38+5.0d-1*t19*t24*t27)+1.0d+0*(
     :           6.2d-3*gammaaa*t1*t3*(9.225837832d-2*gammaaa*t3*t43-5.7
     ;           2001945584d-4*t40*t41*t42)-8.266666666666665d-3*gammaaa
     <           *t3*t4*t43+5.125333333333332d-5*t4*t40*t41*t42)*t44+1.2
     =           5d-1*gammaaa*t19*t24*t25*t26)*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = (t25*(5.0d-1*rhoa*t19*t27*(6.0d-2*gammaa
     1           a*t1*t22*(1.3340275799999998d-1*t1*t22-8.00416547999999
     2           8d-3*gammaaa*t45*t46)-3.6d-3*gammaaa*t23*t45*t46+6.0d-2
     3           *t1*t22*t23)-1.25d-1*t19*t24)+1.0d+0*t44*(6.2d-3*gammaa
     4           a*t1*t3*(2.14500729594d-4*gammaaa*t41*t46-3.459689187d-
     5           2*t1*t3)-1.9219999999999998d-5*gammaaa*t4*t41*t46+3.1d-
     6           3*t1*t3*t4))*wght+Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Mmat(iq,D1_TA) = (1.0d+0*rhoa*t19*t24*t25-5.0d-1*rhoa*t19*
     1           t24*t27/taua**2)*wght+Mmat(iq,D1_TA)
            else 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 2.4d-51*t1+1.0d+0
              t3 = 1/t2
              t4 = 5.336110319999999d-51*t1*t3-2.5960897d+0
              t5 = 2.4d-51*t1*t3*t4+1.0d+0
              t6 = 1/rhoa**6.666666666666666d-1
              t7 = rhoa**5.0d-1
              t8 = 1/t7
              t9 = 1/rhoa**3.333333333333333d-1
              t10 = 1/rhoa**1.6666666666666666d-1
              t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.4
     1           058712912881916d-1*t6+1.1120374863094686d+1*t10
              t12 = 3.216395899738507d+1/t11+1.0d+0
              t13 = log(t12)
              t14 = 1.274696188700087d-1*t9+1.0d+0
              t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.8
     1           970043257475583d-1*t6+5.982550435771079d+0*t10
              t16 = 1.6081979498692536d+1/t15+1.0d+0
              t17 = log(t16)
              t18 = 1.3256889990520176d-1*t9+1.0d+0
              t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2
     1           *t13*t14
              t20 = 2.4799999999999997d-52*t1+1.0d+0
              t21 = 1/t20
              t22 = -2*rhoa*t19
              t23 = 1/t7**3
              t24 = 1/rhoa**1.3333333333333333d+0
              t25 = 1/rhoa**1.1666666666666667d+0
              t26 = 1.1102230246251565d-16*t18*(-9.970917392951799d-1*t2
     1           5-7.418564737168958d-1*t24-4.002143174996817d-1*t23-1.2
     2           64669550498372d-1*t1)/(t15**2*t16)+1.0d+0*t14*(-1.85339
     3           58105157808d+0*t25-1.2815820791490704d+0*t24-8.22366887
     4           7838045d-1*t23-1.6039141941921276d-1*t1)/(t11**2*t12)+3
     5           .0506411443514264d-19*t17*t24+1.3210398931339265d-3*t13
     6           *t24
              t27 = 1/t2**2
              t28 = 1/rhoa**4.333333333333333d+0
              t29 = 1/rhoa**2.6666666666666666d+0
              t30 = 5.9515308d+0-2.7677513496d-51*t1*t21
              t31 = 1.414213562373095d+0
              t32 = 7.937005259840998d-1
              t33 = 2.2255694211506874d+0*t32*t9+8.004286349993635d-1*t8
     1           /t31+1.1950378408754898d-1*t6+5.329846514438382d+0*t10
              t34 = 1.6081979498692536d+1/t33+1.0d+0
              t35 = log(t34)
              t36 = 1.3256889990520176d-1*t32*t9+1.0d+0
              t37 = 3.968502629920499d-1
              t38 = 1/t20**2
              fnc(iq) = (1.0d+0*(2.4799999999999997d-52*t1*t21*(5.951530
     1           8d+0-2.7677513495999995d-51*t1*t21)+1.0d+0)*(t22-1.2436
     2           28d-1*rhoa*(1.0522000558389212d-1*t9+1.0d+0)*log(1.6081
     3           979498692536d+1/(1.766435620181429d+0*t9+5.659885156639
     4           418d-1*t8+1.19503784087549d-1*t6+5.329846514438383d+0*t
     5           10)+1.0d+0))+1.0d+0*rhoa*t19*t5)*wght+fnc(iq)
              Amat(iq,D1_RA) = (5.0d-1*rhoa*t26*t5+5.0d-1*t19*t5+5.0d-1*
     1           rhoa*t19*(-4.0d-51*t29*t3*t4+9.6d-102*t27*t28*t4+2.4d-5
     2           1*t1*t3*(2.134444128d-101*t27*t28-8.8935172d-51*t29*t3)
     3           )+1.0d+0*(t22-1.243628d-1*rhoa*t35*t36)*(2.479999999999
     4           9997d-52*t1*t21*(2.306459458d-51*t21*t29-5.72001945584d
     5           -103*t28*t38)+5.125333333333333d-104*t28*t30*t38-2.0666
     6           666666666667d-52*t21*t29*t30)+1.0d+0*(2.479999999999999
     7           7d-52*t1*t21*t30+1.0d+0)*(2*rhoa*(1.0d+0*t36*(-7.418564
     8           737168958d-1*t24*t37-4.002143174996817d-1*t23/t31**3-4.
     9           4415387620319857d-1*t25-3.9834594695849657d-2*t1)/(t33*
     :           *2*t34)+2.747773264188437d-3*t24*t35*t37)-6.21814d-2*t3
     ;           5*t36-rhoa*t26+6.903522198342671d-18*t17*t18+3.10906999
     <           99999993d-2*t13*t14))*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
            endif 
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          taua    = tau(iq,T_A) 
          taub    = tau(iq,T_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhoa**2.6666666666666666d+0
              t2 = 1/rhob**2.6666666666666666d+0
              t3 = gammabb*t2+gammaaa*t1
              t4 = 3.1d-3*t3+1.0d+0
              t5 = 1/t4
              t6 = 5.9515308d+0-3.459689187d-2*t3*t5
              t7 = 3.1d-3*t3*t5*t6+1.0d+0
              t8 = 1/rhoa**6.666666666666666d-1
              t9 = rhoa**5.0d-1
              t10 = 1/t9
              t11 = 1/rhoa**3.333333333333333d-1
              t12 = 1/rhoa**1.6666666666666666d-1
              t13 = 2.4058712912881916d-1*t8+1.1120374863094686d+1*t12+3
     1           .8447462374472113d+0*t11+1.644733775567609d+0*t10
              t14 = 3.216395899738507d+1/t13+1.0d+0
              t15 = log(t14)
              t16 = 1.274696188700087d-1*t11+1.0d+0
              t17 = 1.8970043257475583d-1*t8+5.982550435771079d+0*t12+2.
     1           2255694211506874d+0*t11+8.004286349993635d-1*t10
              t18 = 1.6081979498692536d+1/t17+1.0d+0
              t19 = log(t18)
              t20 = 1.3256889990520176d-1*t11+1.0d+0
              t21 = -6.903522198342671d-18*t19*t20-3.1090699999999993d-2
     1           *t15*t16
              t22 = 1/rhob**6.666666666666666d-1
              t23 = rhob**5.0d-1
              t24 = 1/t23
              t25 = 1/rhob**3.333333333333333d-1
              t26 = 1/rhob**1.6666666666666666d-1
              t27 = 1.1120374863094686d+1*t26+3.8447462374472113d+0*t25+
     1           1.644733775567609d+0*t24+2.4058712912881916d-1*t22
              t28 = 3.216395899738507d+1/t27+1.0d+0
              t29 = log(t28)
              t30 = 1.274696188700087d-1*t25+1.0d+0
              t31 = 5.982550435771079d+0*t26+2.2255694211506874d+0*t25+8
     1           .004286349993635d-1*t24+1.8970043257475583d-1*t22
              t32 = 1.6081979498692536d+1/t31+1.0d+0
              t33 = log(t32)
              t34 = 1.3256889990520176d-1*t25+1.0d+0
              t35 = -6.903522198342671d-18*t33*t34-3.1090699999999993d-2
     1           *t29*t30
              t36 = rhob+rhoa
              t37 = 1/t36**3.333333333333333d-1
              t38 = 1.3256889990520176d-1*t37+1.0d+0
              t39 = rhoa-rhob
              t40 = t39**4
              t41 = 1/t36**4
              t42 = 1/t36
              t43 = 1.0d+0-t39*t42
              t44 = t39*t42+1.0d+0
              t45 = t44**1.3333333333333333d+0+t43**1.3333333333333333d+
     1           0-2.0d+0
              t46 = -1.923661050931536d+0*t40*t41*t45
              t47 = t46+1.0d+0
              t48 = 1/t36**6.666666666666666d-1
              t49 = t36**5.0d-1
              t50 = 1/t49
              t51 = 1/t36**1.6666666666666666d-1
              t52 = 5.982550435771079d+0*t51+8.004286349993635d-1*t50+1.
     1           8970043257475583d-1*t48+2.2255694211506874d+0*t37
              t53 = 1.6081979498692536d+1/t52+1.0d+0
              t54 = log(t53)
              t55 = -6.21814d-2*t38*t47*t54
              t56 = 6.901399211255825d-2*t37+1.0d+0
              t57 = t46+1.923661050931536d+0*t45
              t58 = 8.157414703487641d+0*t51+4.3009724712766434d-1*t50+1
     1           .9115125951273373d-1*t48+2.247591863577616d+0*t37
              t59 = 2.9608813203268075d+1/t58+1.0d+0
              t60 = log(t59)
              t61 = 1.9751631321680768d-2*t56*t57*t60
              t62 = 1.274696188700087d-1*t37+1.0d+0
              t63 = 1.1120374863094686d+1*t51+1.644733775567609d+0*t50+2
     1           .4058712912881916d-1*t48+3.8447462374472113d+0*t37
              t64 = 3.216395899738507d+1/t63+1.0d+0
              t65 = log(t64)
              t66 = -5.980796863619711d-2*t40*t41*t45*t62*t65
              t67 = t36*(t66+t61+t55)-rhob*t35-rhoa*t21
              t68 = 6.0d-2*gammaaa*t1+1.0d+0
              t69 = 1/t68
              t70 = 1.3340275799999998d-1*gammaaa*t1*t69-2.5960897d+0
              t71 = 6.0d-2*gammaaa*t1*t69*t70+1.0d+0
              t72 = 1/taua
              t73 = 1/rhoa
              t74 = 2.0d+0*taua-2.5d-1*gammaaa*t73
              t75 = 6.0d-2*gammabb*t2+1.0d+0
              t76 = 1/t75
              t77 = 1.3340275799999998d-1*gammabb*t2*t76-2.5960897d+0
              t78 = 6.0d-2*gammabb*t2*t76*t77+1.0d+0
              t79 = 1/taub
              t80 = 1/rhob
              t81 = 2.0d+0*taub-2.5d-1*gammabb*t80
              t82 = 1/rhoa**1.6666666666666669d+0
              t83 = 1/t9**3
              t84 = 1/rhoa**1.3333333333333333d+0
              t85 = 1/rhoa**1.1666666666666667d+0
              t86 = 1.1102230246251565d-16*t20*(-9.970917392951799d-1*t8
     1           5-7.418564737168958d-1*t84-4.002143174996817d-1*t83-1.2
     2           64669550498372d-1*t82)/(t17**2*t18)+1.0d+0*t16*(-1.8533
     3           958105157808d+0*t85-1.2815820791490704d+0*t84-8.2236688
     4           77838045d-1*t83-1.6039141941921276d-1*t82)/(t13**2*t14)
     5           +3.0506411443514264d-19*t19*t84+1.3210398931339265d-3*t
     6           15*t84
              t87 = 1/t36**1.6666666666666669d+0
              t88 = 1/t49**3
              t89 = 1/t36**1.3333333333333333d+0
              t90 = 1/t36**1.1666666666666667d+0
              t91 = 1.0d+0*t38*t47*(-9.970917392951799d-1*t90-7.41856473
     1           7168958d-1*t89-4.002143174996817d-1*t88-1.2646695504983
     2           72d-1*t87)/(t52**2*t53)
              t92 = -5.848223622634647d-1*t56*t57*(-1.3595691172479402d+
     1           0*t90-7.491972878592053d-1*t89-2.1504862356383217d-1*t8
     2           8-1.2743417300848914d-1*t87)/(t58**2*t59)
              t93 = 1.923661050931536d+0*t40*t41*t45*t62*(-1.85339581051
     1           57808d+0*t90-1.2815820791490704d+0*t89-8.22366887783804
     2           5d-1*t88-1.6039141941921276d-1*t87)/(t63**2*t64)
              t94 = 1/t36**2
              t95 = t39*t94
              t96 = -t42
              t97 = t43**3.333333333333333d-1
              t98 = -t39*t94
              t99 = t44**3.333333333333333d-1
              t100 = 1.3333333333333333d+0*(t98+t42)*t99+1.3333333333333
     1           333d+0*(t96+t95)*t97
              t101 = -1.923661050931536d+0*t100*t40*t41
              t102 = 1/t36**5
              t103 = 7.694644203726144d+0*t102*t40*t45
              t104 = t39**3
              t105 = -7.694644203726144d+0*t104*t41*t45
              t106 = 2.747773264188437d-3*t47*t54*t89
              t107 = -4.5437964274821163d-4*t57*t60*t89
              t108 = 2.541232989148493d-3*t40*t45*t65/t36**5.33333333333
     1           3333d+0
              t109 = 2.3923187454478842d-1*t102*t40*t45*t62*t65
              t110 = 1/rhoa**3.6666666666666664d+0
              t111 = 1/t4**2
              t112 = gammaaa**2
              t113 = 1/t68**2
              t114 = 1/rhoa**6.333333333333333d+0
              t115 = 1/rhob**1.6666666666666669d+0
              t116 = 1/t23**3
              t117 = 1/rhob**1.3333333333333333d+0
              t118 = 1/rhob**1.1666666666666667d+0
              t119 = 1.1102230246251565d-16*(-9.970917392951799d-1*t118-
     1           7.418564737168958d-1*t117-4.002143174996817d-1*t116-1.2
     2           64669550498372d-1*t115)*t34/(t31**2*t32)+3.050641144351
     3           4264d-19*t117*t33+1.0d+0*(-1.8533958105157808d+0*t118-1
     4           .2815820791490704d+0*t117-8.223668877838045d-1*t116-1.6
     5           039141941921276d-1*t115)*t30/(t27**2*t28)+1.32103989313
     6           39265d-3*t117*t29
              t120 = 1.3333333333333333d+0*(t98+t96)*t99+1.3333333333333
     1           333d+0*(t95+t42)*t97
              t121 = -1.923661050931536d+0*t120*t40*t41
              t122 = 7.694644203726144d+0*t104*t41*t45
              t123 = 1/rhob**3.6666666666666664d+0
              t124 = gammabb**2
              t125 = 1/t75**2
              t126 = 1/rhob**6.333333333333333d+0
              t127 = 1/rhoa**5.333333333333333d+0
              t128 = 1/rhob**5.333333333333333d+0
              fnc(iq) = (5.0d-1*rhob*t35*t78*t79*t81+5.0d-1*rhoa*t21*t71
     1           *t72*t74+1.0d+0*t67*t7)*wght+fnc(iq)
              Amat(iq,D1_RA) = (1.0d+0*t7*(t36*(t93+t92+t91-2.3923187454
     1           478842d-1*t104*t41*t45*t62*t65-5.980796863619711d-2*t10
     2           0*t40*t41*t62*t65+1.9751631321680768d-2*(t105+t103+t101
     3           +1.923661050931536d+0*t100)*t56*t60-6.21814d-2*(t105+t1
     4           03+t101)*t38*t54+t109+t108+t107+t106)-rhoa*t86+t66+t61+
     5           t55+6.903522198342671d-18*t19*t20+3.1090699999999993d-2
     6           *t15*t16)+t72*(5.0d-1*rhoa*t71*t74*t86+5.0d-1*t21*t71*t
     7           74+5.0d-1*rhoa*t21*(-1.5999999999999998d-1*gammaaa*t110
     8           *t69*t70+9.599999999999997d-3*t112*t113*t114*t70+6.0d-2
     9           *gammaaa*t1*t69*(2.1344441279999993d-2*t112*t113*t114-3
     :           .557406879999999d-1*gammaaa*t110*t69))*t74)+1.25d-1*gam
     ;           maaa*t21*t71*t72*t73+1.0d+0*(-8.266666666666665d-3*gamm
     <           aaa*t110*t5*t6+2.562666666666666d-5*gammaaa*t110*t111*t
     =           3*t6+3.1d-3*t3*t5*(9.225837832d-2*gammaaa*t110*t5-2.860
     >           00972792d-4*gammaaa*t110*t111*t3))*t67)*wght+Amat(iq,D1
     ?           _RA)
              Amat(iq,D1_RB) = (1.0d+0*t7*(t36*(t93+t92+t91+2.3923187454
     1           478842d-1*t104*t41*t45*t62*t65-5.980796863619711d-2*t12
     2           0*t40*t41*t62*t65+1.9751631321680768d-2*(t122+t121+1.92
     3           3661050931536d+0*t120+t103)*t56*t60-6.21814d-2*(t122+t1
     4           21+t103)*t38*t54+t109+t108+t107+t106)+t66+t61+t55+6.903
     5           522198342671d-18*t33*t34+3.1090699999999993d-2*t29*t30-
     6           rhob*t119)+t79*(5.0d-1*t35*t78*t81+5.0d-1*rhob*t119*t78
     7           *t81+5.0d-1*rhob*t35*(-1.5999999999999998d-1*gammabb*t1
     8           23*t76*t77+9.599999999999997d-3*t124*t125*t126*t77+6.0d
     9           -2*gammabb*t2*t76*(2.1344441279999993d-2*t124*t125*t126
     :           -3.557406879999999d-1*gammabb*t123*t76))*t81)+1.25d-1*g
     ;           ammabb*t35*t78*t79*t80+1.0d+0*(-8.266666666666665d-3*ga
     <           mmabb*t123*t5*t6+2.562666666666666d-5*gammabb*t111*t123
     =           *t3*t6+3.1d-3*t3*t5*(9.225837832d-2*gammabb*t123*t5-2.8
     >           6000972792d-4*gammabb*t111*t123*t3))*t67)*wght+Amat(iq,
     ?           D1_RB)
              Cmat(iq,D1_GAA) = (t72*(5.0d-1*rhoa*t21*(6.0d-2*t1*t69*t70
     1           -3.6d-3*gammaaa*t113*t127*t70+6.0d-2*gammaaa*t1*t69*(1.
     2           3340275799999998d-1*t1*t69-8.004165479999998d-3*gammaaa
     3           *t113*t127))*t74-1.25d-1*t21*t71)+1.0d+0*(3.1d-3*t1*t5*
     4           t6-9.61d-6*t1*t111*t3*t6+3.1d-3*t3*t5*(1.07250364797d-4
     5           *t1*t111*t3-3.459689187d-2*t1*t5))*t67)*wght+Cmat(iq,D1
     6           _GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = (t79*(5.0d-1*rhob*t35*(6.0d-2*t2*t76*t77
     1           -3.6d-3*gammabb*t125*t128*t77+6.0d-2*gammabb*t2*t76*(1.
     2           3340275799999998d-1*t2*t76-8.004165479999998d-3*gammabb
     3           *t125*t128))*t81-1.25d-1*t35*t78)+1.0d+0*(3.1d-3*t2*t5*
     4           t6-9.61d-6*t111*t2*t3*t6+3.1d-3*t3*t5*(1.07250364797d-4
     5           *t111*t2*t3-3.459689187d-2*t2*t5))*t67)*wght+Cmat(iq,D1
     6           _GBB)
              Mmat(iq,D1_TA) = (1.0d+0*rhoa*t21*t71*t72-5.0d-1*rhoa*t21*
     1           t71*t74/taua**2)*wght+Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = (1.0d+0*rhob*t35*t78*t79-5.0d-1*rhob*t35*
     1           t78*t81/taub**2)*wght+Mmat(iq,D1_TB)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = 1/rhob**1.6666666666666669d+0
              t2 = 2.4d-51*t1+1.0d+0
              t3 = 1/t2
              t4 = 5.336110319999999d-51*t1*t3-2.5960897d+0
              t5 = 2.4d-51*t1*t3*t4+1.0d+0
              t6 = 1/rhob**6.666666666666666d-1
              t7 = rhob**5.0d-1
              t8 = 1/t7
              t9 = 1/rhob**3.333333333333333d-1
              t10 = 1/rhob**1.6666666666666666d-1
              t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.4
     1           058712912881916d-1*t6+1.1120374863094686d+1*t10
              t12 = 3.216395899738507d+1/t11+1.0d+0
              t13 = log(t12)
              t14 = 1.274696188700087d-1*t9+1.0d+0
              t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.8
     1           970043257475583d-1*t6+5.982550435771079d+0*t10
              t16 = 1.6081979498692536d+1/t15+1.0d+0
              t17 = log(t16)
              t18 = 1.3256889990520176d-1*t9+1.0d+0
              t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2
     1           *t13*t14
              t20 = 1/rhoa**2.6666666666666666d+0
              t21 = gammaaa*t20+4.0d-50*t1
              t22 = 3.1d-3*t21+1.0d+0
              t23 = 1/t22
              t24 = 5.9515308d+0-3.459689187d-2*t21*t23
              t25 = 3.1d-3*t21*t23*t24+1.0d+0
              t26 = 1/rhoa**6.666666666666666d-1
              t27 = rhoa**5.0d-1
              t28 = 1/t27
              t29 = 1/rhoa**3.333333333333333d-1
              t30 = 1/rhoa**1.6666666666666666d-1
              t31 = 1.1120374863094686d+1*t30+3.8447462374472113d+0*t29+
     1           1.644733775567609d+0*t28+2.4058712912881916d-1*t26
              t32 = 3.216395899738507d+1/t31+1.0d+0
              t33 = log(t32)
              t34 = 1.274696188700087d-1*t29+1.0d+0
              t35 = 5.982550435771079d+0*t30+2.2255694211506874d+0*t29+8
     1           .004286349993635d-1*t28+1.8970043257475583d-1*t26
              t36 = 1.6081979498692536d+1/t35+1.0d+0
              t37 = log(t36)
              t38 = 1.3256889990520176d-1*t29+1.0d+0
              t39 = -6.903522198342671d-18*t37*t38-3.1090699999999993d-2
     1           *t33*t34
              t40 = rhob+rhoa
              t41 = 1/t40**3.333333333333333d-1
              t42 = 1.3256889990520176d-1*t41+1.0d+0
              t43 = rhoa-rhob
              t44 = t43**4
              t45 = 1/t40**4
              t46 = 1/t40
              t47 = 1.0d+0-t43*t46
              t48 = t43*t46+1.0d+0
              t49 = t48**1.3333333333333333d+0+t47**1.3333333333333333d+
     1           0-2.0d+0
              t50 = -1.923661050931536d+0*t44*t45*t49
              t51 = t50+1.0d+0
              t52 = 1/t40**6.666666666666666d-1
              t53 = t40**5.0d-1
              t54 = 1/t53
              t55 = 1/t40**1.6666666666666666d-1
              t56 = 5.982550435771079d+0*t55+8.004286349993635d-1*t54+1.
     1           8970043257475583d-1*t52+2.2255694211506874d+0*t41
              t57 = 1.6081979498692536d+1/t56+1.0d+0
              t58 = log(t57)
              t59 = -6.21814d-2*t42*t51*t58
              t60 = 6.901399211255825d-2*t41+1.0d+0
              t61 = t50+1.923661050931536d+0*t49
              t62 = 8.157414703487641d+0*t55+4.3009724712766434d-1*t54+1
     1           .9115125951273373d-1*t52+2.247591863577616d+0*t41
              t63 = 2.9608813203268075d+1/t62+1.0d+0
              t64 = log(t63)
              t65 = 1.9751631321680768d-2*t60*t61*t64
              t66 = 1.274696188700087d-1*t41+1.0d+0
              t67 = 1.1120374863094686d+1*t55+1.644733775567609d+0*t54+2
     1           .4058712912881916d-1*t52+3.8447462374472113d+0*t41
              t68 = 3.216395899738507d+1/t67+1.0d+0
              t69 = log(t68)
              t70 = -5.980796863619711d-2*t44*t45*t49*t66*t69
              t71 = t40*(t70+t65+t59)-rhoa*t39-rhob*t19
              t72 = 6.0d-2*gammaaa*t20+1.0d+0
              t73 = 1/t72
              t74 = 1.3340275799999998d-1*gammaaa*t20*t73-2.5960897d+0
              t75 = 6.0d-2*gammaaa*t20*t73*t74+1.0d+0
              t76 = 1/taua
              t77 = 1/rhoa
              t78 = 2.0d+0*taua-2.5d-1*gammaaa*t77
              t79 = 1/rhoa**1.6666666666666669d+0
              t80 = 1/t27**3
              t81 = 1/rhoa**1.3333333333333333d+0
              t82 = 1/rhoa**1.1666666666666667d+0
              t83 = 1.1102230246251565d-16*t38*(-9.970917392951799d-1*t8
     1           2-7.418564737168958d-1*t81-4.002143174996817d-1*t80-1.2
     2           64669550498372d-1*t79)/(t35**2*t36)+1.0d+0*t34*(-1.8533
     3           958105157808d+0*t82-1.2815820791490704d+0*t81-8.2236688
     4           77838045d-1*t80-1.6039141941921276d-1*t79)/(t31**2*t32)
     5           +3.0506411443514264d-19*t37*t81+1.3210398931339265d-3*t
     6           33*t81
              t84 = 1/t40**1.6666666666666669d+0
              t85 = 1/t53**3
              t86 = 1/t40**1.3333333333333333d+0
              t87 = 1/t40**1.1666666666666667d+0
              t88 = 1.0d+0*t42*t51*(-9.970917392951799d-1*t87-7.41856473
     1           7168958d-1*t86-4.002143174996817d-1*t85-1.2646695504983
     2           72d-1*t84)/(t56**2*t57)
              t89 = -5.848223622634647d-1*t60*t61*(-1.3595691172479402d+
     1           0*t87-7.491972878592053d-1*t86-2.1504862356383217d-1*t8
     2           5-1.2743417300848914d-1*t84)/(t62**2*t63)
              t90 = 1.923661050931536d+0*t44*t45*t49*t66*(-1.85339581051
     1           57808d+0*t87-1.2815820791490704d+0*t86-8.22366887783804
     2           5d-1*t85-1.6039141941921276d-1*t84)/(t67**2*t68)
              t91 = 1/t40**2
              t92 = t43*t91
              t93 = -t46
              t94 = t47**3.333333333333333d-1
              t95 = -t43*t91
              t96 = t48**3.333333333333333d-1
              t97 = 1.3333333333333333d+0*(t95+t46)*t96+1.33333333333333
     1           33d+0*(t93+t92)*t94
              t98 = -1.923661050931536d+0*t44*t45*t97
              t99 = 1/t40**5
              t100 = 7.694644203726144d+0*t44*t49*t99
              t101 = t43**3
              t102 = -7.694644203726144d+0*t101*t45*t49
              t103 = 2.747773264188437d-3*t51*t58*t86
              t104 = -4.5437964274821163d-4*t61*t64*t86
              t105 = 2.541232989148493d-3*t44*t49*t69/t40**5.33333333333
     1           3333d+0
              t106 = 2.3923187454478842d-1*t44*t49*t66*t69*t99
              t107 = 1/rhoa**3.6666666666666664d+0
              t108 = 1/t22**2
              t109 = gammaaa**2
              t110 = 1/t72**2
              t111 = 1/rhoa**6.333333333333333d+0
              t112 = 1/t7**3
              t113 = 1/rhob**1.3333333333333333d+0
              t114 = 1/rhob**1.1666666666666667d+0
              t115 = 1.1102230246251565d-16*(-9.970917392951799d-1*t114-
     1           7.418564737168958d-1*t113-4.002143174996817d-1*t112-1.2
     2           64669550498372d-1*t1)*t18/(t15**2*t16)+3.05064114435142
     3           64d-19*t113*t17+1.0d+0*(-1.8533958105157808d+0*t114-1.2
     4           815820791490704d+0*t113-8.223668877838045d-1*t112-1.603
     5           9141941921276d-1*t1)*t14/(t11**2*t12)+1.321039893133926
     6           5d-3*t113*t13
              t116 = 1/t2**2
              t117 = 1/rhob**4.333333333333333d+0
              t118 = 1/rhob**2.6666666666666666d+0
              t119 = 1.3333333333333333d+0*(t95+t93)*t96+1.3333333333333
     1           333d+0*(t92+t46)*t94
              t120 = -1.923661050931536d+0*t119*t44*t45
              t121 = 7.694644203726144d+0*t101*t45*t49
              t122 = 1/rhoa**5.333333333333333d+0
              fnc(iq) = (5.0d-1*rhoa*t39*t75*t76*t78+1.0d+0*t25*t71+5.0d
     1           -1*rhob*t19*t5)*wght+fnc(iq)
              Amat(iq,D1_RA) = (1.0d+0*t25*(t40*(1.9751631321680768d-2*t
     1           60*t64*(t98+1.923661050931536d+0*t97+t102+t100)-6.21814
     2           d-2*t42*t58*(t98+t102+t100)-5.980796863619711d-2*t44*t4
     3           5*t66*t69*t97+t90+t89+t88-2.3923187454478842d-1*t101*t4
     4           5*t49*t66*t69+t106+t105+t104+t103)-rhoa*t83+t70+t65+t59
     5           +6.903522198342671d-18*t37*t38+3.1090699999999993d-2*t3
     6           3*t34)+t76*(5.0d-1*rhoa*t75*t78*t83+5.0d-1*t39*t75*t78+
     7           5.0d-1*rhoa*t39*(-1.5999999999999998d-1*gammaaa*t107*t7
     8           3*t74+9.599999999999997d-3*t109*t110*t111*t74+6.0d-2*ga
     9           mmaaa*t20*t73*(2.1344441279999993d-2*t109*t110*t111-3.5
     :           57406879999999d-1*gammaaa*t107*t73))*t78)+1.25d-1*gamma
     ;           aa*t39*t75*t76*t77+1.0d+0*(-8.266666666666665d-3*gammaa
     <           a*t107*t23*t24+2.562666666666666d-5*gammaaa*t107*t108*t
     =           21*t24+3.1d-3*t21*t23*(9.225837832d-2*gammaaa*t107*t23-
     >           2.86000972792d-4*gammaaa*t107*t108*t21))*t71)*wght+Amat
     ?           (iq,D1_RA)
              Amat(iq,D1_RB) = (1.0d+0*t25*(t40*(t90+t89+t88+2.392318745
     1           4478842d-1*t101*t45*t49*t66*t69-5.980796863619711d-2*t1
     2           19*t44*t45*t66*t69+1.9751631321680768d-2*(t121+t120+1.9
     3           23661050931536d+0*t119+t100)*t60*t64-6.21814d-2*(t121+t
     4           120+t100)*t42*t58+t106+t105+t104+t103)+t70+t65+t59+6.90
     5           3522198342671d-18*t17*t18+3.1090699999999993d-2*t13*t14
     6           -rhob*t115)+1.0d+0*(-2.0666666666666667d-52*t118*t23*t2
     7           4+6.406666666666666d-55*t108*t118*t21*t24+3.1d-3*t21*t2
     8           3*(2.306459458d-51*t118*t23-7.1500243198d-54*t108*t118*
     9           t21))*t71+5.0d-1*t19*t5+5.0d-1*rhob*t115*t5+5.0d-1*rhob
     :           *t19*(-4.0d-51*t118*t3*t4+9.6d-102*t116*t117*t4+2.4d-51
     ;           *t1*t3*(2.134444128d-101*t116*t117-8.8935172d-51*t118*t
     <           3)))*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = (t76*(5.0d-1*rhoa*t39*(6.0d-2*t20*t73*t7
     1           4-3.6d-3*gammaaa*t110*t122*t74+6.0d-2*gammaaa*t20*t73*(
     2           1.3340275799999998d-1*t20*t73-8.004165479999998d-3*gamm
     3           aaa*t110*t122))*t78-1.25d-1*t39*t75)+1.0d+0*(3.1d-3*t20
     4           *t23*t24-9.61d-6*t108*t20*t21*t24+3.1d-3*t21*t23*(1.072
     5           50364797d-4*t108*t20*t21-3.459689187d-2*t20*t23))*t71)*
     6           wght+Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = (1.0d+0*rhoa*t39*t75*t76-5.0d-1*rhoa*t39*
     1           t75*t78/taua**2)*wght+Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 2.4d-51*t1+1.0d+0
              t3 = 1/t2
              t4 = 5.336110319999999d-51*t1*t3-2.5960897d+0
              t5 = 2.4d-51*t1*t3*t4+1.0d+0
              t6 = 1/rhoa**6.666666666666666d-1
              t7 = rhoa**5.0d-1
              t8 = 1/t7
              t9 = 1/rhoa**3.333333333333333d-1
              t10 = 1/rhoa**1.6666666666666666d-1
              t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.4
     1           058712912881916d-1*t6+1.1120374863094686d+1*t10
              t12 = 3.216395899738507d+1/t11+1.0d+0
              t13 = log(t12)
              t14 = 1.274696188700087d-1*t9+1.0d+0
              t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.8
     1           970043257475583d-1*t6+5.982550435771079d+0*t10
              t16 = 1.6081979498692536d+1/t15+1.0d+0
              t17 = log(t16)
              t18 = 1.3256889990520176d-1*t9+1.0d+0
              t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2
     1           *t13*t14
              t20 = 1/rhob**2.6666666666666666d+0
              t21 = gammabb*t20+4.0d-50*t1
              t22 = 3.1d-3*t21+1.0d+0
              t23 = 1/t22
              t24 = 5.9515308d+0-3.459689187d-2*t21*t23
              t25 = 3.1d-3*t21*t23*t24+1.0d+0
              t26 = 1/rhob**6.666666666666666d-1
              t27 = rhob**5.0d-1
              t28 = 1/t27
              t29 = 1/rhob**3.333333333333333d-1
              t30 = 1/rhob**1.6666666666666666d-1
              t31 = 1.1120374863094686d+1*t30+3.8447462374472113d+0*t29+
     1           1.644733775567609d+0*t28+2.4058712912881916d-1*t26
              t32 = 3.216395899738507d+1/t31+1.0d+0
              t33 = log(t32)
              t34 = 1.274696188700087d-1*t29+1.0d+0
              t35 = 5.982550435771079d+0*t30+2.2255694211506874d+0*t29+8
     1           .004286349993635d-1*t28+1.8970043257475583d-1*t26
              t36 = 1.6081979498692536d+1/t35+1.0d+0
              t37 = log(t36)
              t38 = 1.3256889990520176d-1*t29+1.0d+0
              t39 = -6.903522198342671d-18*t37*t38-3.1090699999999993d-2
     1           *t33*t34
              t40 = rhob+rhoa
              t41 = 1/t40**3.333333333333333d-1
              t42 = 1.3256889990520176d-1*t41+1.0d+0
              t43 = rhoa-rhob
              t44 = t43**4
              t45 = 1/t40**4
              t46 = 1/t40
              t47 = 1.0d+0-t43*t46
              t48 = t43*t46+1.0d+0
              t49 = t48**1.3333333333333333d+0+t47**1.3333333333333333d+
     1           0-2.0d+0
              t50 = -1.923661050931536d+0*t44*t45*t49
              t51 = t50+1.0d+0
              t52 = 1/t40**6.666666666666666d-1
              t53 = t40**5.0d-1
              t54 = 1/t53
              t55 = 1/t40**1.6666666666666666d-1
              t56 = 5.982550435771079d+0*t55+8.004286349993635d-1*t54+1.
     1           8970043257475583d-1*t52+2.2255694211506874d+0*t41
              t57 = 1.6081979498692536d+1/t56+1.0d+0
              t58 = log(t57)
              t59 = -6.21814d-2*t42*t51*t58
              t60 = 6.901399211255825d-2*t41+1.0d+0
              t61 = t50+1.923661050931536d+0*t49
              t62 = 8.157414703487641d+0*t55+4.3009724712766434d-1*t54+1
     1           .9115125951273373d-1*t52+2.247591863577616d+0*t41
              t63 = 2.9608813203268075d+1/t62+1.0d+0
              t64 = log(t63)
              t65 = 1.9751631321680768d-2*t60*t61*t64
              t66 = 1.274696188700087d-1*t41+1.0d+0
              t67 = 1.1120374863094686d+1*t55+1.644733775567609d+0*t54+2
     1           .4058712912881916d-1*t52+3.8447462374472113d+0*t41
              t68 = 3.216395899738507d+1/t67+1.0d+0
              t69 = log(t68)
              t70 = -5.980796863619711d-2*t44*t45*t49*t66*t69
              t71 = t40*(t70+t65+t59)-rhob*t39-rhoa*t19
              t72 = 6.0d-2*gammabb*t20+1.0d+0
              t73 = 1/t72
              t74 = 1.3340275799999998d-1*gammabb*t20*t73-2.5960897d+0
              t75 = 6.0d-2*gammabb*t20*t73*t74+1.0d+0
              t76 = 1/taub
              t77 = 1/rhob
              t78 = 2.0d+0*taub-2.5d-1*gammabb*t77
              t79 = 1/t7**3
              t80 = 1/rhoa**1.3333333333333333d+0
              t81 = 1/rhoa**1.1666666666666667d+0
              t82 = 1.1102230246251565d-16*t18*(-9.970917392951799d-1*t8
     1           1-7.418564737168958d-1*t80-4.002143174996817d-1*t79-1.2
     2           64669550498372d-1*t1)/(t15**2*t16)+1.0d+0*t14*(-1.85339
     3           58105157808d+0*t81-1.2815820791490704d+0*t80-8.22366887
     4           7838045d-1*t79-1.6039141941921276d-1*t1)/(t11**2*t12)+3
     5           .0506411443514264d-19*t17*t80+1.3210398931339265d-3*t13
     6           *t80
              t83 = 1/t2**2
              t84 = 1/rhoa**4.333333333333333d+0
              t85 = 1/rhoa**2.6666666666666666d+0
              t86 = 1/t40**1.6666666666666669d+0
              t87 = 1/t53**3
              t88 = 1/t40**1.3333333333333333d+0
              t89 = 1/t40**1.1666666666666667d+0
              t90 = 1.0d+0*t42*t51*(-9.970917392951799d-1*t89-7.41856473
     1           7168958d-1*t88-4.002143174996817d-1*t87-1.2646695504983
     2           72d-1*t86)/(t56**2*t57)
              t91 = -5.848223622634647d-1*t60*t61*(-1.3595691172479402d+
     1           0*t89-7.491972878592053d-1*t88-2.1504862356383217d-1*t8
     2           7-1.2743417300848914d-1*t86)/(t62**2*t63)
              t92 = 1.923661050931536d+0*t44*t45*t49*t66*(-1.85339581051
     1           57808d+0*t89-1.2815820791490704d+0*t88-8.22366887783804
     2           5d-1*t87-1.6039141941921276d-1*t86)/(t67**2*t68)
              t93 = 1/t40**2
              t94 = t43*t93
              t95 = -t46
              t96 = t47**3.333333333333333d-1
              t97 = -t43*t93
              t98 = t48**3.333333333333333d-1
              t99 = 1.3333333333333333d+0*(t97+t46)*t98+1.33333333333333
     1           33d+0*(t95+t94)*t96
              t100 = -1.923661050931536d+0*t44*t45*t99
              t101 = 1/t40**5
              t102 = 7.694644203726144d+0*t101*t44*t49
              t103 = t43**3
              t104 = -7.694644203726144d+0*t103*t45*t49
              t105 = 2.747773264188437d-3*t51*t58*t88
              t106 = -4.5437964274821163d-4*t61*t64*t88
              t107 = 2.541232989148493d-3*t44*t49*t69/t40**5.33333333333
     1           3333d+0
              t108 = 2.3923187454478842d-1*t101*t44*t49*t66*t69
              t109 = 1/t22**2
              t110 = 1/rhob**1.6666666666666669d+0
              t111 = 1/t27**3
              t112 = 1/rhob**1.3333333333333333d+0
              t113 = 1/rhob**1.1666666666666667d+0
              t114 = 1.1102230246251565d-16*(-9.970917392951799d-1*t113-
     1           7.418564737168958d-1*t112-4.002143174996817d-1*t111-1.2
     2           64669550498372d-1*t110)*t38/(t35**2*t36)+3.050641144351
     3           4264d-19*t112*t37+1.0d+0*(-1.8533958105157808d+0*t113-1
     4           .2815820791490704d+0*t112-8.223668877838045d-1*t111-1.6
     5           039141941921276d-1*t110)*t34/(t31**2*t32)+1.32103989313
     6           39265d-3*t112*t33
              t115 = 1.3333333333333333d+0*(t97+t95)*t98+1.3333333333333
     1           333d+0*(t94+t46)*t96
              t116 = -1.923661050931536d+0*t115*t44*t45
              t117 = 7.694644203726144d+0*t103*t45*t49
              t118 = 1/rhob**3.6666666666666664d+0
              t119 = gammabb**2
              t120 = 1/t72**2
              t121 = 1/rhob**6.333333333333333d+0
              t122 = 1/rhob**5.333333333333333d+0
              fnc(iq) = (5.0d-1*rhob*t39*t75*t76*t78+1.0d+0*t25*t71+5.0d
     1           -1*rhoa*t19*t5)*wght+fnc(iq)
              Amat(iq,D1_RA) = (1.0d+0*t25*(t40*(1.9751631321680768d-2*t
     1           60*t64*(1.923661050931536d+0*t99+t104+t102+t100)-5.9807
     2           96863619711d-2*t44*t45*t66*t69*t99+t92+t91+t90-2.392318
     3           7454478842d-1*t103*t45*t49*t66*t69-6.21814d-2*(t104+t10
     4           2+t100)*t42*t58+t108+t107+t106+t105)-rhoa*t82+t70+t65+t
     5           59+6.903522198342671d-18*t17*t18+3.1090699999999993d-2*
     6           t13*t14)+5.0d-1*rhoa*t19*(2.4d-51*t1*t3*(2.134444128d-1
     7           01*t83*t84-8.8935172d-51*t3*t85)-4.0d-51*t3*t4*t85+9.6d
     8           -102*t4*t83*t84)+1.0d+0*t71*(3.1d-3*t21*t23*(2.30645945
     9           8d-51*t23*t85-7.1500243198d-54*t109*t21*t85)-2.06666666
     :           66666667d-52*t23*t24*t85+6.406666666666666d-55*t109*t21
     ;           *t24*t85)+5.0d-1*rhoa*t5*t82+5.0d-1*t19*t5)*wght+Amat(i
     <           q,D1_RA)
              Amat(iq,D1_RB) = (1.0d+0*t25*(t40*(t92+t91+t90+2.392318745
     1           4478842d-1*t103*t45*t49*t66*t69-5.980796863619711d-2*t1
     2           15*t44*t45*t66*t69+1.9751631321680768d-2*(t117+t116+1.9
     3           23661050931536d+0*t115+t102)*t60*t64-6.21814d-2*(t117+t
     4           116+t102)*t42*t58+t108+t107+t106+t105)+t70+t65+t59+6.90
     5           3522198342671d-18*t37*t38+3.1090699999999993d-2*t33*t34
     6           -rhob*t114)+t76*(5.0d-1*t39*t75*t78+5.0d-1*rhob*t114*t7
     7           5*t78+5.0d-1*rhob*t39*(-1.5999999999999998d-1*gammabb*t
     8           118*t73*t74+9.599999999999997d-3*t119*t120*t121*t74+6.0
     9           d-2*gammabb*t20*t73*(2.1344441279999993d-2*t119*t120*t1
     :           21-3.557406879999999d-1*gammabb*t118*t73))*t78)+1.25d-1
     ;           *gammabb*t39*t75*t76*t77+1.0d+0*(-8.266666666666665d-3*
     <           gammabb*t118*t23*t24+2.562666666666666d-5*gammabb*t109*
     =           t118*t21*t24+3.1d-3*t21*t23*(9.225837832d-2*gammabb*t11
     >           8*t23-2.86000972792d-4*gammabb*t109*t118*t21))*t71)*wgh
     ?           t+Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = (t76*(5.0d-1*rhob*t39*(6.0d-2*t20*t73*t7
     1           4-3.6d-3*gammabb*t120*t122*t74+6.0d-2*gammabb*t20*t73*(
     2           1.3340275799999998d-1*t20*t73-8.004165479999998d-3*gamm
     3           abb*t120*t122))*t78-1.25d-1*t39*t75)+1.0d+0*(3.1d-3*t20
     4           *t23*t24-9.61d-6*t109*t20*t21*t24+3.1d-3*t21*t23*(1.072
     5           50364797d-4*t109*t20*t21-3.459689187d-2*t20*t23))*t71)*
     6           wght+Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = (1.0d+0*rhob*t39*t75*t76-5.0d-1*rhob*t39*
     1           t75*t78/taub**2)*wght+Mmat(iq,D1_TB)
            else 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 2.4d-51*t1+1.0d+0
              t3 = 1/t2
              t4 = 5.336110319999999d-51*t1*t3-2.5960897d+0
              t5 = 2.4d-51*t1*t3*t4+1.0d+0
              t6 = 1/rhoa**6.666666666666666d-1
              t7 = rhoa**5.0d-1
              t8 = 1/t7
              t9 = 1/rhoa**3.333333333333333d-1
              t10 = 1/rhoa**1.6666666666666666d-1
              t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.4
     1           058712912881916d-1*t6+1.1120374863094686d+1*t10
              t12 = 3.216395899738507d+1/t11+1.0d+0
              t13 = log(t12)
              t14 = 1.274696188700087d-1*t9+1.0d+0
              t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.8
     1           970043257475583d-1*t6+5.982550435771079d+0*t10
              t16 = 1.6081979498692536d+1/t15+1.0d+0
              t17 = log(t16)
              t18 = 1.3256889990520176d-1*t9+1.0d+0
              t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2
     1           *t13*t14
              t20 = 1/rhob**1.6666666666666669d+0
              t21 = 2.4d-51*t20+1.0d+0
              t22 = 1/t21
              t23 = 5.336110319999999d-51*t20*t22-2.5960897d+0
              t24 = 2.4d-51*t20*t22*t23+1.0d+0
              t25 = 1/rhob**6.666666666666666d-1
              t26 = rhob**5.0d-1
              t27 = 1/t26
              t28 = 1/rhob**3.333333333333333d-1
              t29 = 1/rhob**1.6666666666666666d-1
              t30 = 1.1120374863094686d+1*t29+3.8447462374472113d+0*t28+
     1           1.644733775567609d+0*t27+2.4058712912881916d-1*t25
              t31 = 3.216395899738507d+1/t30+1.0d+0
              t32 = log(t31)
              t33 = 1.274696188700087d-1*t28+1.0d+0
              t34 = 5.982550435771079d+0*t29+2.2255694211506874d+0*t28+8
     1           .004286349993635d-1*t27+1.8970043257475583d-1*t25
              t35 = 1.6081979498692536d+1/t34+1.0d+0
              t36 = log(t35)
              t37 = 1.3256889990520176d-1*t28+1.0d+0
              t38 = -6.903522198342671d-18*t36*t37-3.1090699999999993d-2
     1           *t32*t33
              t39 = 4.0d-50*t20+4.0d-50*t1
              t40 = 3.1d-3*t39+1.0d+0
              t41 = 1/t40
              t42 = 5.9515308d+0-3.459689187d-2*t39*t41
              t43 = 3.1d-3*t39*t41*t42+1.0d+0
              t44 = rhob+rhoa
              t45 = 1/t44**3.333333333333333d-1
              t46 = 1.3256889990520176d-1*t45+1.0d+0
              t47 = rhoa-rhob
              t48 = t47**4
              t49 = 1/t44**4
              t50 = 1/t44
              t51 = 1.0d+0-t47*t50
              t52 = t47*t50+1.0d+0
              t53 = t52**1.3333333333333333d+0+t51**1.3333333333333333d+
     1           0-2.0d+0
              t54 = -1.923661050931536d+0*t48*t49*t53
              t55 = t54+1.0d+0
              t56 = 1/t44**6.666666666666666d-1
              t57 = t44**5.0d-1
              t58 = 1/t57
              t59 = 1/t44**1.6666666666666666d-1
              t60 = 5.982550435771079d+0*t59+8.004286349993635d-1*t58+1.
     1           8970043257475583d-1*t56+2.2255694211506874d+0*t45
              t61 = 1.6081979498692536d+1/t60+1.0d+0
              t62 = log(t61)
              t63 = -6.21814d-2*t46*t55*t62
              t64 = 6.901399211255825d-2*t45+1.0d+0
              t65 = t54+1.923661050931536d+0*t53
              t66 = 8.157414703487641d+0*t59+4.3009724712766434d-1*t58+1
     1           .9115125951273373d-1*t56+2.247591863577616d+0*t45
              t67 = 2.9608813203268075d+1/t66+1.0d+0
              t68 = log(t67)
              t69 = 1.9751631321680768d-2*t64*t65*t68
              t70 = 1.274696188700087d-1*t45+1.0d+0
              t71 = 1.1120374863094686d+1*t59+1.644733775567609d+0*t58+2
     1           .4058712912881916d-1*t56+3.8447462374472113d+0*t45
              t72 = 3.216395899738507d+1/t71+1.0d+0
              t73 = log(t72)
              t74 = -5.980796863619711d-2*t48*t49*t53*t70*t73
              t75 = t44*(t74+t69+t63)-rhob*t38-rhoa*t19
              t76 = 1/t7**3
              t77 = 1/rhoa**1.3333333333333333d+0
              t78 = 1/rhoa**1.1666666666666667d+0
              t79 = 1.1102230246251565d-16*t18*(-9.970917392951799d-1*t7
     1           8-7.418564737168958d-1*t77-4.002143174996817d-1*t76-1.2
     2           64669550498372d-1*t1)/(t15**2*t16)+1.0d+0*t14*(-1.85339
     3           58105157808d+0*t78-1.2815820791490704d+0*t77-8.22366887
     4           7838045d-1*t76-1.6039141941921276d-1*t1)/(t11**2*t12)+3
     5           .0506411443514264d-19*t17*t77+1.3210398931339265d-3*t13
     6           *t77
              t80 = 1/t2**2
              t81 = 1/rhoa**4.333333333333333d+0
              t82 = 1/rhoa**2.6666666666666666d+0
              t83 = 1/t44**1.6666666666666669d+0
              t84 = 1/t57**3
              t85 = 1/t44**1.3333333333333333d+0
              t86 = 1/t44**1.1666666666666667d+0
              t87 = 1.0d+0*t46*t55*(-9.970917392951799d-1*t86-7.41856473
     1           7168958d-1*t85-4.002143174996817d-1*t84-1.2646695504983
     2           72d-1*t83)/(t60**2*t61)
              t88 = -5.848223622634647d-1*t64*t65*(-1.3595691172479402d+
     1           0*t86-7.491972878592053d-1*t85-2.1504862356383217d-1*t8
     2           4-1.2743417300848914d-1*t83)/(t66**2*t67)
              t89 = 1.923661050931536d+0*t48*t49*t53*t70*(-1.85339581051
     1           57808d+0*t86-1.2815820791490704d+0*t85-8.22366887783804
     2           5d-1*t84-1.6039141941921276d-1*t83)/(t71**2*t72)
              t90 = 1/t44**2
              t91 = t47*t90
              t92 = -t50
              t93 = t51**3.333333333333333d-1
              t94 = -t47*t90
              t95 = t52**3.333333333333333d-1
              t96 = 1.3333333333333333d+0*(t94+t50)*t95+1.33333333333333
     1           33d+0*(t92+t91)*t93
              t97 = -1.923661050931536d+0*t48*t49*t96
              t98 = 1/t44**5
              t99 = 7.694644203726144d+0*t48*t53*t98
              t100 = t47**3
              t101 = -7.694644203726144d+0*t100*t49*t53
              t102 = 2.747773264188437d-3*t55*t62*t85
              t103 = -4.5437964274821163d-4*t65*t68*t85
              t104 = 2.541232989148493d-3*t48*t53*t73/t44**5.33333333333
     1           3333d+0
              t105 = 2.3923187454478842d-1*t48*t53*t70*t73*t98
              t106 = 1/t40**2
              t107 = 1/t26**3
              t108 = 1/rhob**1.3333333333333333d+0
              t109 = 1/rhob**1.1666666666666667d+0
              t110 = 1.1102230246251565d-16*(-1.264669550498372d-1*t20-9
     1           .970917392951799d-1*t109-7.418564737168958d-1*t108-4.00
     2           2143174996817d-1*t107)*t37/(t34**2*t35)+3.0506411443514
     3           264d-19*t108*t36+1.0d+0*(-1.6039141941921276d-1*t20-1.8
     4           533958105157808d+0*t109-1.2815820791490704d+0*t108-8.22
     5           3668877838045d-1*t107)*t33/(t30**2*t31)+1.3210398931339
     6           265d-3*t108*t32
              t111 = 1/t21**2
              t112 = 1/rhob**4.333333333333333d+0
              t113 = 1/rhob**2.6666666666666666d+0
              t114 = 1.3333333333333333d+0*(t94+t92)*t95+1.3333333333333
     1           333d+0*(t91+t50)*t93
              t115 = -1.923661050931536d+0*t114*t48*t49
              t116 = 7.694644203726144d+0*t100*t49*t53
              fnc(iq) = (1.0d+0*t43*t75+5.0d-1*rhoa*t19*t5+5.0d-1*rhob*t
     1           24*t38)*wght+fnc(iq)
              Amat(iq,D1_RA) = (1.0d+0*t43*(t44*(1.9751631321680768d-2*t
     1           64*t68*(t99+t97+1.923661050931536d+0*t96+t101)-6.21814d
     2           -2*t46*t62*(t99+t97+t101)-5.980796863619711d-2*t48*t49*
     3           t70*t73*t96+t89+t88+t87-2.3923187454478842d-1*t100*t49*
     4           t53*t70*t73+t105+t104+t103+t102)-rhoa*t79+t74+t69+t63+6
     5           .903522198342671d-18*t17*t18+3.1090699999999993d-2*t13*
     6           t14)+1.0d+0*t75*(3.1d-3*t39*t41*(2.306459458d-51*t41*t8
     7           2-7.1500243198d-54*t106*t39*t82)-2.0666666666666667d-52
     8           *t41*t42*t82+6.406666666666666d-55*t106*t39*t42*t82)+5.
     9           0d-1*rhoa*t19*(2.4d-51*t1*t3*(2.134444128d-101*t80*t81-
     :           8.8935172d-51*t3*t82)-4.0d-51*t3*t4*t82+9.6d-102*t4*t80
     ;           *t81)+5.0d-1*rhoa*t5*t79+5.0d-1*t19*t5)*wght+Amat(iq,D1
     <           _RA)
              Amat(iq,D1_RB) = (1.0d+0*t43*(t44*(1.9751631321680768d-2*t
     1           64*t68*(t99+t116+t115+1.923661050931536d+0*t114)-6.2181
     2           4d-2*t46*t62*(t99+t116+t115)+t89+t88+t87+2.392318745447
     3           8842d-1*t100*t49*t53*t70*t73-5.980796863619711d-2*t114*
     4           t48*t49*t70*t73+t105+t104+t103+t102)+t74+t69+t63+6.9035
     5           22198342671d-18*t36*t37+3.1090699999999993d-2*t32*t33-r
     6           hob*t110)+1.0d+0*(-2.0666666666666667d-52*t113*t41*t42+
     7           6.406666666666666d-55*t106*t113*t39*t42+3.1d-3*t39*t41*
     8           (2.306459458d-51*t113*t41-7.1500243198d-54*t106*t113*t3
     9           9))*t75+5.0d-1*t24*t38+5.0d-1*rhob*(-4.0d-51*t113*t22*t
     :           23+9.6d-102*t111*t112*t23+2.4d-51*t20*t22*(2.134444128d
     ;           -101*t111*t112-8.8935172d-51*t113*t22))*t38+5.0d-1*rhob
     <           *t110*t24)*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            endif 
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhoa**2.6666666666666666d+0
              t2 = 6.0d-2*gammaaa*t1+1.0d+0
              t3 = 1/t2
              t4 = 1.3340275799999998d-1*gammaaa*t1*t3-2.5960897d+0
              t5 = 6.0d-2*gammaaa*t1*t3*t4+1.0d+0
              t6 = 1/rhoa**6.666666666666666d-1
              t7 = rhoa**5.0d-1
              t8 = 1/t7
              t9 = 1/rhoa**3.333333333333333d-1
              t10 = 1/rhoa**1.6666666666666666d-1
              t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.4
     1           058712912881916d-1*t6+1.1120374863094686d+1*t10
              t12 = 3.216395899738507d+1/t11+1.0d+0
              t13 = log(t12)
              t14 = 1.274696188700087d-1*t9+1.0d+0
              t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.8
     1           970043257475583d-1*t6+5.982550435771079d+0*t10
              t16 = 1.6081979498692536d+1/t15+1.0d+0
              t17 = log(t16)
              t18 = 1.3256889990520176d-1*t9+1.0d+0
              t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2
     1           *t13*t14
              t20 = 1/taua
              t21 = 1/rhoa
              t22 = 2.0d+0*taua-2.5d-1*gammaaa*t21
              t23 = 1/rhoa**1.6666666666666669d+0
              t24 = 1/t7**3
              t25 = 1/rhoa**1.3333333333333333d+0
              t26 = 1/rhoa**1.1666666666666667d+0
              t27 = gammaaa**2
              t28 = 1/t2**2
              t29 = 1/rhoa**6.333333333333333d+0
              t30 = 1/rhoa**3.6666666666666664d+0
              t31 = 1/rhoa**5.333333333333333d+0
              fnc(iq) = 5.0d-1*rhoa*t19*t20*t22*t5*wght+fnc(iq)
              Amat(iq,D1_RA) = t20*(5.0d-1*rhoa*t22*(1.1102230246251565d
     1           -16*t18*(-9.970917392951799d-1*t26-7.418564737168958d-1
     2           *t25-4.002143174996817d-1*t24-1.264669550498372d-1*t23)
     3           /(t15**2*t16)+1.0d+0*t14*(-1.8533958105157808d+0*t26-1.
     4           2815820791490704d+0*t25-8.223668877838045d-1*t24-1.6039
     5           141941921276d-1*t23)/(t11**2*t12)+3.0506411443514264d-1
     6           9*t17*t25+1.3210398931339265d-3*t13*t25)*t5*wght+5.0d-1
     7           *t19*t22*t5*wght+5.0d-1*rhoa*t19*t22*(-1.59999999999999
     8           98d-1*gammaaa*t3*t30*t4+9.599999999999997d-3*t27*t28*t2
     9           9*t4+6.0d-2*gammaaa*t1*t3*(2.1344441279999993d-2*t27*t2
     :           8*t29-3.557406879999999d-1*gammaaa*t3*t30))*wght)+1.25d
     ;           -1*gammaaa*t19*t20*t21*t5*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = t20*(5.0d-1*rhoa*t19*t22*(-3.6d-3*gammaa
     1           a*t28*t31*t4+6.0d-2*t1*t3*t4+6.0d-2*gammaaa*t1*t3*(1.33
     2           40275799999998d-1*t1*t3-8.004165479999998d-3*gammaaa*t2
     3           8*t31))*wght-1.25d-1*t19*t5*wght)+Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = -5.0d-1*rhoa*t19*t22*t5*wght/taua**2+1.0d
     1           +0*rhoa*t19*t20*t5*wght+Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = 1/rhoa**2.6666666666666666d+0
              t2 = 6.0d-2*gammaaa*t1+1.0d+0
              t3 = 1/t2
              t4 = 1.3340275799999998d-1*gammaaa*t1*t3-2.5960897d+0
              t5 = 6.0d-2*gammaaa*t1*t3*t4+1.0d+0
              t6 = 1/rhoa**6.666666666666666d-1
              t7 = rhoa**5.0d-1
              t8 = 1/t7
              t9 = 1/rhoa**3.333333333333333d-1
              t10 = 1/rhoa**1.6666666666666666d-1
              t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.4
     1           058712912881916d-1*t6+1.1120374863094686d+1*t10
              t12 = 3.216395899738507d+1/t11+1.0d+0
              t13 = log(t12)
              t14 = 1.274696188700087d-1*t9+1.0d+0
              t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.8
     1           970043257475583d-1*t6+5.982550435771079d+0*t10
              t16 = 1.6081979498692536d+1/t15+1.0d+0
              t17 = log(t16)
              t18 = 1.3256889990520176d-1*t9+1.0d+0
              t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2
     1           *t13*t14
              t20 = 1/taua
              t21 = 1/rhoa
              t22 = 2.0d+0*taua-2.5d-1*gammaaa*t21
              t23 = 1/rhoa**1.6666666666666669d+0
              t24 = 1/t7**3
              t25 = 1/rhoa**1.3333333333333333d+0
              t26 = 1/rhoa**1.1666666666666667d+0
              t27 = gammaaa**2
              t28 = 1/t2**2
              t29 = 1/rhoa**6.333333333333333d+0
              t30 = 1/rhoa**3.6666666666666664d+0
              t31 = 1/rhoa**5.333333333333333d+0
              fnc(iq) = 5.0d-1*rhoa*t19*t20*t22*t5*wght+fnc(iq)
              Amat(iq,D1_RA) = t20*(5.0d-1*rhoa*t22*(1.1102230246251565d
     1           -16*t18*(-9.970917392951799d-1*t26-7.418564737168958d-1
     2           *t25-4.002143174996817d-1*t24-1.264669550498372d-1*t23)
     3           /(t15**2*t16)+1.0d+0*t14*(-1.8533958105157808d+0*t26-1.
     4           2815820791490704d+0*t25-8.223668877838045d-1*t24-1.6039
     5           141941921276d-1*t23)/(t11**2*t12)+3.0506411443514264d-1
     6           9*t17*t25+1.3210398931339265d-3*t13*t25)*t5*wght+5.0d-1
     7           *t19*t22*t5*wght+5.0d-1*rhoa*t19*t22*(-1.59999999999999
     8           98d-1*gammaaa*t3*t30*t4+9.599999999999997d-3*t27*t28*t2
     9           9*t4+6.0d-2*gammaaa*t1*t3*(2.1344441279999993d-2*t27*t2
     :           8*t29-3.557406879999999d-1*gammaaa*t3*t30))*wght)+1.25d
     ;           -1*gammaaa*t19*t20*t21*t5*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = t20*(5.0d-1*rhoa*t19*t22*(-3.6d-3*gammaa
     1           a*t28*t31*t4+6.0d-2*t1*t3*t4+6.0d-2*gammaaa*t1*t3*(1.33
     2           40275799999998d-1*t1*t3-8.004165479999998d-3*gammaaa*t2
     3           8*t31))*wght-1.25d-1*t19*t5*wght)+Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = -5.0d-1*rhoa*t19*t22*t5*wght/taua**2+1.0d
     1           +0*rhoa*t19*t20*t5*wght+Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 2.4d-51*t1+1.0d+0
              t3 = 1/t2
              t4 = 5.336110319999999d-51*t1*t3-2.5960897d+0
              t5 = 2.4d-51*t1*t3*t4+1.0d+0
              t6 = 1/rhoa**6.666666666666666d-1
              t7 = rhoa**5.0d-1
              t8 = 1/t7
              t9 = 1/rhoa**3.333333333333333d-1
              t10 = 1/rhoa**1.6666666666666666d-1
              t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.4
     1           058712912881916d-1*t6+1.1120374863094686d+1*t10
              t12 = 3.216395899738507d+1/t11+1.0d+0
              t13 = log(t12)
              t14 = 1.274696188700087d-1*t9+1.0d+0
              t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.8
     1           970043257475583d-1*t6+5.982550435771079d+0*t10
              t16 = 1.6081979498692536d+1/t15+1.0d+0
              t17 = log(t16)
              t18 = 1.3256889990520176d-1*t9+1.0d+0
              t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2
     1           *t13*t14
              t20 = 1/t7**3
              t21 = 1/rhoa**1.3333333333333333d+0
              t22 = 1/rhoa**1.1666666666666667d+0
              t23 = 1/t2**2
              t24 = 1/rhoa**4.333333333333333d+0
              t25 = 1/rhoa**2.6666666666666666d+0
              fnc(iq) = 5.0d-1*rhoa*t19*t5*wght+fnc(iq)
              Amat(iq,D1_RA) = 5.0d-1*rhoa*(1.1102230246251565d-16*t18*(
     1           -9.970917392951799d-1*t22-7.418564737168958d-1*t21-4.00
     2           2143174996817d-1*t20-1.264669550498372d-1*t1)/(t15**2*t
     3           16)+1.0d+0*t14*(-1.8533958105157808d+0*t22-1.2815820791
     4           490704d+0*t21-8.223668877838045d-1*t20-1.60391419419212
     5           76d-1*t1)/(t11**2*t12)+3.0506411443514264d-19*t17*t21+1
     6           .3210398931339265d-3*t13*t21)*t5*wght+5.0d-1*t19*t5*wgh
     7           t+5.0d-1*rhoa*t19*(-4.0d-51*t25*t3*t4+9.6d-102*t23*t24*
     8           t4+2.4d-51*t1*t3*(2.134444128d-101*t23*t24-8.8935172d-5
     9           1*t25*t3))*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            else 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 2.4d-51*t1+1.0d+0
              t3 = 1/t2
              t4 = 5.336110319999999d-51*t1*t3-2.5960897d+0
              t5 = 2.4d-51*t1*t3*t4+1.0d+0
              t6 = 1/rhoa**6.666666666666666d-1
              t7 = rhoa**5.0d-1
              t8 = 1/t7
              t9 = 1/rhoa**3.333333333333333d-1
              t10 = 1/rhoa**1.6666666666666666d-1
              t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.4
     1           058712912881916d-1*t6+1.1120374863094686d+1*t10
              t12 = 3.216395899738507d+1/t11+1.0d+0
              t13 = log(t12)
              t14 = 1.274696188700087d-1*t9+1.0d+0
              t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.8
     1           970043257475583d-1*t6+5.982550435771079d+0*t10
              t16 = 1.6081979498692536d+1/t15+1.0d+0
              t17 = log(t16)
              t18 = 1.3256889990520176d-1*t9+1.0d+0
              t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2
     1           *t13*t14
              t20 = 1/t7**3
              t21 = 1/rhoa**1.3333333333333333d+0
              t22 = 1/rhoa**1.1666666666666667d+0
              t23 = 1/t2**2
              t24 = 1/rhoa**4.333333333333333d+0
              t25 = 1/rhoa**2.6666666666666666d+0
              fnc(iq) = 5.0d-1*rhoa*t19*t5*wght+fnc(iq)
              Amat(iq,D1_RA) = 5.0d-1*rhoa*(1.1102230246251565d-16*t18*(
     1           -9.970917392951799d-1*t22-7.418564737168958d-1*t21-4.00
     2           2143174996817d-1*t20-1.264669550498372d-1*t1)/(t15**2*t
     3           16)+1.0d+0*t14*(-1.8533958105157808d+0*t22-1.2815820791
     4           490704d+0*t21-8.223668877838045d-1*t20-1.60391419419212
     5           76d-1*t1)/(t11**2*t12)+3.0506411443514264d-19*t17*t21+1
     6           .3210398931339265d-3*t13*t21)*t5*wght+5.0d-1*t19*t5*wgh
     7           t+5.0d-1*rhoa*t19*(-4.0d-51*t25*t3*t4+9.6d-102*t23*t24*
     8           t4+2.4d-51*t1*t3*(2.134444128d-101*t23*t24-8.8935172d-5
     9           1*t25*t3))*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            endif 
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhob**2.6666666666666666d+0
              t2 = 6.0d-2*gammabb*t1+1.0d+0
              t3 = 1/t2
              t4 = 1.3340275799999998d-1*gammabb*t1*t3-2.5960897d+0
              t5 = 6.0d-2*gammabb*t1*t3*t4+1.0d+0
              t6 = 1/rhob**6.666666666666666d-1
              t7 = rhob**5.0d-1
              t8 = 1/t7
              t9 = 1/rhob**3.333333333333333d-1
              t10 = 1/rhob**1.6666666666666666d-1
              t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.4
     1           058712912881916d-1*t6+1.1120374863094686d+1*t10
              t12 = 3.216395899738507d+1/t11+1.0d+0
              t13 = log(t12)
              t14 = 1.274696188700087d-1*t9+1.0d+0
              t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.8
     1           970043257475583d-1*t6+5.982550435771079d+0*t10
              t16 = 1.6081979498692536d+1/t15+1.0d+0
              t17 = log(t16)
              t18 = 1.3256889990520176d-1*t9+1.0d+0
              t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2
     1           *t13*t14
              t20 = 1/taub
              t21 = 1/rhob
              t22 = 2.0d+0*taub-2.5d-1*gammabb*t21
              t23 = 1/rhob**1.6666666666666669d+0
              t24 = 1/t7**3
              t25 = 1/rhob**1.3333333333333333d+0
              t26 = 1/rhob**1.1666666666666667d+0
              t27 = gammabb**2
              t28 = 1/t2**2
              t29 = 1/rhob**6.333333333333333d+0
              t30 = 1/rhob**3.6666666666666664d+0
              t31 = 1/rhob**5.333333333333333d+0
              fnc(iq) = 5.0d-1*rhob*t19*t20*t22*t5*wght+fnc(iq)
              Amat(iq,D1_RB) = t20*(5.0d-1*rhob*t22*(1.1102230246251565d
     1           -16*t18*(-9.970917392951799d-1*t26-7.418564737168958d-1
     2           *t25-4.002143174996817d-1*t24-1.264669550498372d-1*t23)
     3           /(t15**2*t16)+1.0d+0*t14*(-1.8533958105157808d+0*t26-1.
     4           2815820791490704d+0*t25-8.223668877838045d-1*t24-1.6039
     5           141941921276d-1*t23)/(t11**2*t12)+3.0506411443514264d-1
     6           9*t17*t25+1.3210398931339265d-3*t13*t25)*t5*wght+5.0d-1
     7           *t19*t22*t5*wght+5.0d-1*rhob*t19*t22*(-1.59999999999999
     8           98d-1*gammabb*t3*t30*t4+9.599999999999997d-3*t27*t28*t2
     9           9*t4+6.0d-2*gammabb*t1*t3*(2.1344441279999993d-2*t27*t2
     :           8*t29-3.557406879999999d-1*gammabb*t3*t30))*wght)+1.25d
     ;           -1*gammabb*t19*t20*t21*t5*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = t20*(5.0d-1*rhob*t19*t22*(-3.6d-3*gammab
     1           b*t28*t31*t4+6.0d-2*t1*t3*t4+6.0d-2*gammabb*t1*t3*(1.33
     2           40275799999998d-1*t1*t3-8.004165479999998d-3*gammabb*t2
     3           8*t31))*wght-1.25d-1*t19*t5*wght)+Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = -5.0d-1*rhob*t19*t22*t5*wght/taub**2+1.0d
     1           +0*rhob*t19*t20*t5*wght+Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = 1/rhob**1.6666666666666669d+0
              t2 = 2.4d-51*t1+1.0d+0
              t3 = 1/t2
              t4 = 5.336110319999999d-51*t1*t3-2.5960897d+0
              t5 = 2.4d-51*t1*t3*t4+1.0d+0
              t6 = 1/rhob**6.666666666666666d-1
              t7 = rhob**5.0d-1
              t8 = 1/t7
              t9 = 1/rhob**3.333333333333333d-1
              t10 = 1/rhob**1.6666666666666666d-1
              t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.4
     1           058712912881916d-1*t6+1.1120374863094686d+1*t10
              t12 = 3.216395899738507d+1/t11+1.0d+0
              t13 = log(t12)
              t14 = 1.274696188700087d-1*t9+1.0d+0
              t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.8
     1           970043257475583d-1*t6+5.982550435771079d+0*t10
              t16 = 1.6081979498692536d+1/t15+1.0d+0
              t17 = log(t16)
              t18 = 1.3256889990520176d-1*t9+1.0d+0
              t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2
     1           *t13*t14
              t20 = 1/t7**3
              t21 = 1/rhob**1.3333333333333333d+0
              t22 = 1/rhob**1.1666666666666667d+0
              t23 = 1/t2**2
              t24 = 1/rhob**4.333333333333333d+0
              t25 = 1/rhob**2.6666666666666666d+0
              fnc(iq) = 5.0d-1*rhob*t19*t5*wght+fnc(iq)
              Amat(iq,D1_RB) = 5.0d-1*rhob*(1.1102230246251565d-16*t18*(
     1           -9.970917392951799d-1*t22-7.418564737168958d-1*t21-4.00
     2           2143174996817d-1*t20-1.264669550498372d-1*t1)/(t15**2*t
     3           16)+1.0d+0*t14*(-1.8533958105157808d+0*t22-1.2815820791
     4           490704d+0*t21-8.223668877838045d-1*t20-1.60391419419212
     5           76d-1*t1)/(t11**2*t12)+3.0506411443514264d-19*t17*t21+1
     6           .3210398931339265d-3*t13*t21)*t5*wght+5.0d-1*t19*t5*wgh
     7           t+5.0d-1*rhob*t19*(-4.0d-51*t25*t3*t4+9.6d-102*t23*t24*
     8           t4+2.4d-51*t1*t3*(2.134444128d-101*t23*t24-8.8935172d-5
     9           1*t25*t3))*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhob**2.6666666666666666d+0
              t2 = 6.0d-2*gammabb*t1+1.0d+0
              t3 = 1/t2
              t4 = 1.3340275799999998d-1*gammabb*t1*t3-2.5960897d+0
              t5 = 6.0d-2*gammabb*t1*t3*t4+1.0d+0
              t6 = 1/rhob**6.666666666666666d-1
              t7 = rhob**5.0d-1
              t8 = 1/t7
              t9 = 1/rhob**3.333333333333333d-1
              t10 = 1/rhob**1.6666666666666666d-1
              t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.4
     1           058712912881916d-1*t6+1.1120374863094686d+1*t10
              t12 = 3.216395899738507d+1/t11+1.0d+0
              t13 = log(t12)
              t14 = 1.274696188700087d-1*t9+1.0d+0
              t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.8
     1           970043257475583d-1*t6+5.982550435771079d+0*t10
              t16 = 1.6081979498692536d+1/t15+1.0d+0
              t17 = log(t16)
              t18 = 1.3256889990520176d-1*t9+1.0d+0
              t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2
     1           *t13*t14
              t20 = 1/taub
              t21 = 1/rhob
              t22 = 2.0d+0*taub-2.5d-1*gammabb*t21
              t23 = 1/rhob**1.6666666666666669d+0
              t24 = 1/t7**3
              t25 = 1/rhob**1.3333333333333333d+0
              t26 = 1/rhob**1.1666666666666667d+0
              t27 = gammabb**2
              t28 = 1/t2**2
              t29 = 1/rhob**6.333333333333333d+0
              t30 = 1/rhob**3.6666666666666664d+0
              t31 = 1/rhob**5.333333333333333d+0
              fnc(iq) = 5.0d-1*rhob*t19*t20*t22*t5*wght+fnc(iq)
              Amat(iq,D1_RB) = t20*(5.0d-1*rhob*t22*(1.1102230246251565d
     1           -16*t18*(-9.970917392951799d-1*t26-7.418564737168958d-1
     2           *t25-4.002143174996817d-1*t24-1.264669550498372d-1*t23)
     3           /(t15**2*t16)+1.0d+0*t14*(-1.8533958105157808d+0*t26-1.
     4           2815820791490704d+0*t25-8.223668877838045d-1*t24-1.6039
     5           141941921276d-1*t23)/(t11**2*t12)+3.0506411443514264d-1
     6           9*t17*t25+1.3210398931339265d-3*t13*t25)*t5*wght+5.0d-1
     7           *t19*t22*t5*wght+5.0d-1*rhob*t19*t22*(-1.59999999999999
     8           98d-1*gammabb*t3*t30*t4+9.599999999999997d-3*t27*t28*t2
     9           9*t4+6.0d-2*gammabb*t1*t3*(2.1344441279999993d-2*t27*t2
     :           8*t29-3.557406879999999d-1*gammabb*t3*t30))*wght)+1.25d
     ;           -1*gammabb*t19*t20*t21*t5*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = t20*(5.0d-1*rhob*t19*t22*(-3.6d-3*gammab
     1           b*t28*t31*t4+6.0d-2*t1*t3*t4+6.0d-2*gammabb*t1*t3*(1.33
     2           40275799999998d-1*t1*t3-8.004165479999998d-3*gammabb*t2
     3           8*t31))*wght-1.25d-1*t19*t5*wght)+Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = -5.0d-1*rhob*t19*t22*t5*wght/taub**2+1.0d
     1           +0*rhob*t19*t20*t5*wght+Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
            else 
              t1 = 1/rhob**1.6666666666666669d+0
              t2 = 2.4d-51*t1+1.0d+0
              t3 = 1/t2
              t4 = 5.336110319999999d-51*t1*t3-2.5960897d+0
              t5 = 2.4d-51*t1*t3*t4+1.0d+0
              t6 = 1/rhob**6.666666666666666d-1
              t7 = rhob**5.0d-1
              t8 = 1/t7
              t9 = 1/rhob**3.333333333333333d-1
              t10 = 1/rhob**1.6666666666666666d-1
              t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.4
     1           058712912881916d-1*t6+1.1120374863094686d+1*t10
              t12 = 3.216395899738507d+1/t11+1.0d+0
              t13 = log(t12)
              t14 = 1.274696188700087d-1*t9+1.0d+0
              t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.8
     1           970043257475583d-1*t6+5.982550435771079d+0*t10
              t16 = 1.6081979498692536d+1/t15+1.0d+0
              t17 = log(t16)
              t18 = 1.3256889990520176d-1*t9+1.0d+0
              t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2
     1           *t13*t14
              t20 = 1/t7**3
              t21 = 1/rhob**1.3333333333333333d+0
              t22 = 1/rhob**1.1666666666666667d+0
              t23 = 1/t2**2
              t24 = 1/rhob**4.333333333333333d+0
              t25 = 1/rhob**2.6666666666666666d+0
              fnc(iq) = 5.0d-1*rhob*t19*t5*wght+fnc(iq)
              Amat(iq,D1_RB) = 5.0d-1*rhob*(1.1102230246251565d-16*t18*(
     1           -9.970917392951799d-1*t22-7.418564737168958d-1*t21-4.00
     2           2143174996817d-1*t20-1.264669550498372d-1*t1)/(t15**2*t
     3           16)+1.0d+0*t14*(-1.8533958105157808d+0*t22-1.2815820791
     4           490704d+0*t21-8.223668877838045d-1*t20-1.60391419419212
     5           76d-1*t1)/(t11**2*t12)+3.0506411443514264d-19*t17*t21+1
     6           .3210398931339265d-3*t13*t21)*t5*wght+5.0d-1*t19*t5*wgh
     7           t+5.0d-1*rhob*t19*(-4.0d-51*t25*t3*t4+9.6d-102*t23*t24*
     8           t4+2.4d-51*t1*t3*(2.134444128d-101*t23*t24-8.8935172d-5
     9           1*t25*t3))*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
            endif 
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_c_dldf functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& {{1}\over{\rho_\alpha^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_2} &=& {{1}\over{\sqrt{\rho_\alpha}}}\\\\ 
C>   {\it t_3} &=& {{1}\over{\rho_\alpha^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_4} &=& {{1}\over{\rho_\alpha^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_5} &=& -6.903522198342671 \times 10^{-18}\,\log 
C>    \left({{16.08197949869254}\over{5.98255043577108\,{\it t_4}
C>    +2.225569421150687\,{\it t_3}+0.8004286349993635\,{\it t_2}
C>    +0.1897004325747558\,{\it t_1}}}+1.0\right)\,
C>    \left(0.1325688999052018\,{\it t_3}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_4}+3.844746237447211\,{\it t_3}+1.644733775567609\,{
C>    \it t_2}+0.2405871291288192\,{\it t_1}}}+1.0\right)\,
C>    \left(0.1274696188700087\,{\it t_3}+1.0\right)\\\\ 
C>   {\it t_6} &=& {{1}\over{\rho_\beta^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_7} &=& {{1}\over{\sqrt{\rho_\beta}}}\\\\ 
C>   {\it t_8} &=& {{1}\over{\rho_\beta^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_9} &=& {{1}\over{\rho_\beta^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{10}} &=& -6.903522198342671 \times 10^{-18}
C>    \,\log \left({{16.08197949869254}\over{5.98255043577108\,{
C>    \it t_9}+2.225569421150687\,{\it t_8}+0.8004286349993635\,{
C>    \it t_7}+0.1897004325747558\,{\it t_6}}}+1.0\right)\,
C>    \left(0.1325688999052018\,{\it t_8}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_9}+3.844746237447211\,{\it t_8}+1.644733775567609\,{
C>    \it t_7}+0.2405871291288192\,{\it t_6}}}+1.0\right)\,
C>    \left(0.1274696188700087\,{\it t_8}+1.0\right)\\\\ 
C>   {\it t_{11}} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_{12}} &=& {{1}\over{{\it t_{11}}^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{13}} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_{14}} &=& {\it t_{13}}^4\\\\ 
C>   {\it t_{15}} &=& {{1}\over{{\it t_{11}}^4}}\\\\ 
C>   {\it t_{16}} &=& {{1}\over{{\it t_{11}}}}\\\\ 
C>   {\it t_{17}} &=& \left({\it t_{13}}\,{\it t_{16}}
C>    +1.0\right)^{{{4}\over{3}}}+\left(1.0-{\it t_{13}}\,{
C>    \it t_{16}}\right)^{{{4}\over{3}}}-2.0\\\\ 
C>   {\it t_{18}} &=& -1.923661050931536\,{\it t_{14}}\,{\it t_{15}}
C>    \,{\it t_{17}}\\\\ 
C>   {\it t_{19}} &=& {{1}\over{{\it t_{11}}^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{20}} &=& {{1}\over{\sqrt{{\it t_{11}}}}}\\\\ 
C>   {\it t_{21}} &=& {{1}\over{{\it t_{11}}^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{22}} &=& {{1}\over{\rho_\alpha^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{23}} &=& {{1}\over{\rho_\beta^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{24}} &=& {\it t_{23}}\,\sigma_{\beta\beta}+{\it t_{22}}
C>    \,\sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{25}} &=& {{1}\over{0.0031\,{\it t_{24}}+1.0}}\\\\ 
C>   {\it t_{26}} &=& {{1}\over{0.06\,{\it t_{22}}\,
C>    \sigma_{\alpha\alpha}+1.0}}\\\\ 
C>   {\it t_{27}} &=& {{1}\over{0.06\,{\it t_{23}}\,
C>    \sigma_{\beta\beta}+1.0}}\\\\ 
C>   {\it t_{28}} &=& {{1}\over{\rho_s^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{29}} &=& {{1}\over{\sqrt{\rho_s}}}\\\\ 
C>   {\it t_{30}} &=& {{1}\over{\rho_s^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{31}} &=& {{1}\over{\rho_s^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{32}} &=& {{1}\over{\rho_s^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{33}} &=& {{1}\over{0.06\,{\it t_{32}}\,\sigma_{ss}
C>    +1.0}}\\\\ 
C>   f &=& {{0.5\,{\it t_{10}}\,\rho_\beta\,\left(0.06\,{\it t_{23}}
C>    \,\sigma_{\beta\beta}\,{\it t_{27}}\,\left(0.133402758\,{
C>    \it t_{23}}\,\sigma_{\beta\beta}\,{\it t_{27}}-2.5960897\right)
C>    +1.0\right)\,\left(2.0\,\tau_\beta-{{0.25\,
C>    \sigma_{\beta\beta}}\over{\rho_\beta}}\right)}\over{\tau_\beta}}
C>    +{{0.5\,{\it t_5}\,\rho_\alpha\,\left(0.06\,{\it t_{22}}
C>    \,\sigma_{\alpha\alpha}\,{\it t_{26}}\,\left(0.133402758\,{
C>    \it t_{22}}\,\sigma_{\alpha\alpha}\,{\it t_{26}}
C>    -2.5960897\right)+1.0\right)\,\left(2.0\,\tau_\alpha-{{0.25
C>    \,\sigma_{\alpha\alpha}}\over{\rho_\alpha}}\right)}
C>    \over{\tau_\alpha}}+1.0\,\left({\it t_{11}}\,\left(
C>    -0.0598079686361971\,{\it t_{14}}\,{\it t_{15}}\,
C>    \left(0.1274696188700087\,{\it t_{12}}+1.0\right)\,{
C>    \it t_{17}}\,\log \left({{32.16395899738507}
C>    \over{11.12037486309469\,{\it t_{21}}+3.844746237447211\,{
C>    \it t_{12}}+1.644733775567609\,{\it t_{20}}+0.2405871291288192
C>    \,{\it t_{19}}}}+1.0\right)+0.01975163132168077\,
C>    \left(0.06901399211255825\,{\it t_{12}}+1.0\right)\,\left({
C>    \it t_{18}}+1.923661050931536\,{\it t_{17}}\right)
C>    \,\log \left({{29.60881320326807}\over{8.15741470348764\,{
C>    \it t_{21}}+2.247591863577616\,{\it t_{12}}+0.4300972471276643
C>    \,{\it t_{20}}+0.1911512595127337\,{\it t_{19}}}}+1.0\right)
C>    -0.0621814\,\left(0.1325688999052018\,{\it t_{12}}+1.0\right)
C>    \,\left({\it t_{18}}+1.0\right)\,\log 
C>    \left({{16.08197949869254}\over{5.98255043577108\,{\it t_{21}}
C>    +2.225569421150687\,{\it t_{12}}+0.8004286349993635\,{
C>    \it t_{20}}+0.1897004325747558\,{\it t_{19}}}}+1.0\right)\right)
C>    -{\it t_{10}}\,\rho_\beta-{\it t_5}\,\rho_\alpha\right)
C>    \,\left(0.0031\,{\it t_{24}}\,{\it t_{25}}\,\left(5.9515308
C>    -0.03459689187\,{\it t_{24}}\,{\it t_{25}}\right)+1.0\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& {{0.5\,\left(-6.903522198342671 \times 10^{-18}
C>    \,\log \left({{16.08197949869254}\over{5.98255043577108\,{
C>    \it t_{31}}+2.225569421150687\,{\it t_{30}}+0.8004286349993635
C>    \,{\it t_{29}}+0.1897004325747558\,{\it t_{28}}}}+1.0\right)
C>    \,\left(0.1325688999052018\,{\it t_{30}}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_{31}}+3.844746237447211\,{\it t_{30}}+1.644733775567609
C>    \,{\it t_{29}}+0.2405871291288192\,{\it t_{28}}}}+1.0\right)
C>    \,\left(0.1274696188700087\,{\it t_{30}}+1.0\right)\right)
C>    \,\rho_s\,\left(0.06\,{\it t_{32}}\,\sigma_{ss}\,{\it t_{33}}
C>    \,\left(0.133402758\,{\it t_{32}}\,\sigma_{ss}\,{\it t_{33}}
C>    -2.5960897\right)+1.0\right)\,\left(2.0\,\tau_s-{{0.25
C>    \,\sigma_{ss}}\over{\rho_s}}\right)}\over{\tau_s}}\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc-Ds [3]. 
C> 
C> ### References ### 
C> 
C> [1] K Pernal, R Podeszwa, K Patkowski, K Szalewicz
C>    , Phys.Rev.Lett. 103, 263201 (2009)  , DOI: 
C> <a href="https://doi.org/10.1103/PhysRevLett.103.263201 "> 
C> 10.1103/PhysRevLett.103.263201 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc-Ds, revision 27207 2015-06-23 
C> 
      subroutine nwxcm_c_dldf_d2(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,tau,fnc,Amat,Amat2,Cmat,Cmat2,Mmat,Mmat2) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,NCOL_RHO)      !< [Input] The density 
      double precision rgamma(nq,NCOL_GAMMA) !< [Input] The norm of the density 
                                             !< gradients 
      double precision tau(nq,NCOL_TAU)      !< [Input] The kinetic energy density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,NCOL_AMAT)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,NCOL_CMAT)   !< [Output] The derivative wrt rgamma 
      double precision Mmat(nq,NCOL_MMAT)   !< [Output] The derivative wrt tau 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,NCOL_AMAT2)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,NCOL_CMAT2)  !< [Output] The 2nd derivative wrt rgamma 
                                             !< and possibly rho 
      double precision Mmat2(nq,NCOL_MMAT2)  !< [Output] The 2nd derivative wrt tau 
                                             !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          taua    = 0.5d0*tau(iq,T_T) 
          if (rhoa.gt.tol_rho) then 
            if (taua.gt.tol_rho) then 
              t1 = 1/rhoa**2.6666666666666666d+0
              t2 = 6.2d-3*gammaaa*t1+1.0d+0
              t3 = 1/t2
              t4 = 5.9515308d+0-6.919378374d-2*gammaaa*t1*t3
              t5 = 6.2d-3*gammaaa*t1*t3*t4+1.0d+0
              t6 = 1/rhoa**6.666666666666666d-1
              t7 = rhoa**5.0d-1
              t8 = 1/t7
              t9 = 1/rhoa**3.333333333333333d-1
              t10 = 1/rhoa**1.6666666666666666d-1
              t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.4
     1           058712912881916d-1*t6+1.1120374863094686d+1*t10
              t12 = 3.216395899738507d+1/t11+1.0d+0
              t13 = log(t12)
              t14 = 1.274696188700087d-1*t9+1.0d+0
              t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.8
     1           970043257475583d-1*t6+5.982550435771079d+0*t10
              t16 = 1.6081979498692536d+1/t15+1.0d+0
              t17 = log(t16)
              t18 = 1.3256889990520176d-1*t9+1.0d+0
              t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2
     1           *t13*t14
              t20 = -2*rhoa*t19
              t21 = 6.0d-2*gammaaa*t1+1.0d+0
              t22 = 1/t21
              t23 = 1.3340275799999998d-1*gammaaa*t1*t22-2.5960897d+0
              t24 = 6.0d-2*gammaaa*t1*t22*t23+1.0d+0
              t25 = 1/taua
              t26 = 1/rhoa
              t27 = 2.0d+0*taua-2.5d-1*gammaaa*t26
              t28 = 6.299605249474366d-1
              t29 = 1.414213562373095d+0
              t30 = 1/t29
              t31 = 7.937005259840998d-1
              t32 = 8.908987181403393d-1
              t33 = 2.2255694211506874d+0*t31*t9+8.004286349993635d-1*t3
     1           0*t8+1.8970043257475583d-1*t28*t6+5.982550435771079d+0*
     2           t10*t32
              t34 = 1.6081979498692536d+1/t33+1.0d+0
              t35 = log(t34)
              t36 = 1.3256889990520176d-1*t31*t9+1.0d+0
              t37 = 1/t16
              t38 = 1/rhoa**1.6666666666666669d+0
              t39 = 1/t7**3
              t40 = 1/rhoa**1.3333333333333333d+0
              t41 = 1/rhoa**1.1666666666666667d+0
              t42 = -9.970917392951799d-1*t41-7.418564737168958d-1*t40-4
     1           .002143174996817d-1*t39-1.264669550498372d-1*t38
              t43 = 1/t15**2
              t44 = 1/t12
              t45 = -1.8533958105157808d+0*t41-1.2815820791490704d+0*t40
     1           -8.223668877838045d-1*t39-1.6039141941921276d-1*t38
              t46 = 1/t11**2
              t47 = 1.0d+0*t14*t44*t45*t46+1.1102230246251565d-16*t18*t3
     1           7*t42*t43+3.0506411443514264d-19*t17*t40+1.321039893133
     2           9265d-3*t13*t40
              t48 = 1/t34
              t49 = 3.968502629920499d-1
              t50 = -7.418564737168958d-1*t40*t49-4.4415387620319857d-1*
     1           t41-4.002143174996817d-1*t39/t29**3-3.9834594695849657d
     2           -2*t38
              t51 = 1/t33**2
              t52 = 2*rhoa*(1.0d+0*t36*t48*t50*t51+2.747773264188437d-3*
     1           t35*t40*t49)-rhoa*t47-6.21814d-2*t35*t36+6.903522198342
     2           671d-18*t17*t18+3.1090699999999993d-2*t13*t14
              t53 = gammaaa**2
              t54 = 1/t2**2
              t55 = 1/rhoa**6.333333333333333d+0
              t56 = 1/rhoa**3.6666666666666664d+0
              t57 = 9.225837832d-2*gammaaa*t3*t56-5.72001945584d-4*t53*t
     1           54*t55
              t58 = 6.2d-3*gammaaa*t1*t3*t57-8.266666666666665d-3*gammaa
     1           a*t3*t4*t56+5.125333333333332d-5*t4*t53*t54*t55
              t59 = t20-1.243628d-1*rhoa*t35*t36
              t60 = 1/t21**2
              t61 = 2.1344441279999993d-2*t53*t55*t60-3.557406879999999d
     1           -1*gammaaa*t22*t56
              t62 = 6.0d-2*gammaaa*t1*t22*t61+9.599999999999997d-3*t23*t
     1           53*t55*t60-1.5999999999999998d-1*gammaaa*t22*t23*t56
              t63 = 1/rhoa**5.333333333333333d+0
              t64 = 2.14500729594d-4*gammaaa*t54*t63-3.459689187d-2*t1*t
     1           3
              t65 = 6.2d-3*gammaaa*t1*t3*t64-1.9219999999999998d-5*gamma
     1           aa*t4*t54*t63+3.1d-3*t1*t3*t4
              t66 = 1.3340275799999998d-1*t1*t22-8.004165479999998d-3*ga
     1           mmaaa*t60*t63
              t67 = 6.0d-2*gammaaa*t1*t22*t66-3.6d-3*gammaaa*t23*t60*t63
     1           +6.0d-2*t1*t22*t23
              t68 = 1/taua**2
              t69 = 2.0d+0*t52*t58
              t70 = 2.0d+0*t36*t48*t50*t51
              t71 = 5.495546528376875d-3*t35*t40*t49
              t72 = t42**2
              t73 = 1/t7**5
              t74 = 1/rhoa**2.3333333333333334d+0
              t75 = 1/rhoa**2.1666666666666665d+0
              t76 = t45**2
              t77 = -2.0d+0*t14*t44*t76/t11**3+3.216395899738507d+1*t14*
     1           t76/(t11**4*t12**2)+1.0d+0*t14*t44*t46*(2.1622951122684
     2           114d+0*t75+1.7087761055320938d+0*t74+1.2335503316757068
     3           d+0*t73+2.673190323653546d-1*t1)+1.1102230246251565d-16
     4           *t18*t37*t43*(1.1632736958443765d+0*t75+9.8914196495586
     5           1d-1*t74+6.003214762495226d-1*t73+2.1077825841639536d-1
     6           *t1)-4.0675215258019015d-19*t17*t74-1.7613865241785684d
     7           -3*t13*t74-2.220446049250313d-16*t18*t37*t72/t15**3+1.7
     8           854583920998188d-15*t18*t72/(t15**4*t16**2)-8.497974591
     9           333913d-2*t40*t44*t45*t46-9.812069668265515d-18*t37*t40
     :           *t42*t43
              t78 = t50**2
              t79 = 1.6081979498692536d+1*t36*t78/(t33**4*t34**2)
              t80 = -2.0d+0*t36*t48*t78/t33**3
              t81 = 1.9842513149602492d-1
              t82 = 1.0d+0*t36*t48*t51*(9.89141964955861d-1*t74*t81+2.59
     1           08976111853255d-1*t75+6.003214762495226d-1*t73/t29**5+3
     2           .319549557987472d-2*t1)
              t83 = -3.663697685584583d-3*t35*t74*t81
              t84 = log(2.9608813203268075d+1/(2.247591863577616d+0*t31*
     1           t9+4.3009724712766434d-1*t30*t8+1.9115125951273373d-1*t
     2           28*t6+8.157414703487641d+0*t10*t32)+1.0d+0)
              t85 = 6.901399211255825d-2*t31*t9+1.0d+0
              t86 = 1/rhoa**2
              t87 = -8.837926660346784d-2*t40*t48*t49*t50*t51
              t88 = gammaaa**3
              t89 = 1/t2**3
              t90 = 1/rhoa**10
              t91 = 8.473884444444441d-7*t4*t88*t89*t90
              t92 = 1/rhoa**7.333333333333333d+0
              t93 = 1.0250666666666663d-4*t53*t54*t55*t57
              t94 = 1/rhoa**4.666666666666667d+0
              t95 = -1.653333333333333d-2*gammaaa*t3*t56*t57
              t96 = -9.457098833655464d-6*t88*t89*t90
              t97 = 1/t21**3
              t98 = 1.0d+0*t52*t65
              t99 = 1/rhoa**9
              t100 = -3.1777066666666653d-7*t4*t53*t89*t99
              t101 = 5.125333333333332d-5*t53*t54*t55*t64
              t102 = -1.9219999999999998d-5*gammaaa*t54*t57*t63
              t103 = -8.266666666666665d-3*gammaaa*t3*t56*t64
              t104 = 3.5464120626207996d-6*t53*t89*t99
              t105 = 3.1d-3*t1*t3*t57
              t106 = 1.25d-1*t19*t24
              t107 = 1/rhoa**8
              t108 = 6.2d-3*gammaaa*t1*t3*(2.14500729594d-4*t54*t63-1.32
     1           99045234828d-6*gammaaa*t107*t89)+1.1916399999999999d-7*
     2           gammaaa*t107*t4*t89-3.8439999999999996d-5*gammaaa*t54*t
     3           63*t64+6.2d-3*t1*t3*t64-1.9219999999999998d-5*t4*t54*t6
     4           3
              fnc(iq) = (1.0d+0*t5*(t20-1.243628d-1*rhoa*(1.052200055838
     1           9212d-1*t9+1.0d+0)*log(1.6081979498692536d+1/(1.7664356
     2           20181429d+0*t9+5.659885156639418d-1*t8+1.19503784087549
     3           d-1*t6+5.329846514438383d+0*t10)+1.0d+0))+1.0d+0*rhoa*t
     4           19*t24*t25*t27)*wght+fnc(iq)
              Amat(iq,D1_RA) = (t25*(5.0d-1*rhoa*t19*t27*t62+5.0d-1*rhoa
     1           *t24*t27*t47+5.0d-1*t19*t24*t27)+1.0d+0*t58*t59+1.0d+0*
     2           t5*t52+1.25d-1*gammaaa*t19*t24*t25*t26)*wght+Amat(iq,D1
     3           _RA)
              Cmat(iq,D1_GAA) = (t25*(5.0d-1*rhoa*t19*t27*t67-1.25d-1*t1
     1           9*t24)+1.0d+0*t59*t65)*wght+Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Mmat(iq,D1_TA) = (1.0d+0*rhoa*t19*t24*t25-5.0d-1*rhoa*t19*
     1           t24*t27*t68)*wght+Mmat(iq,D1_TA)
              Amat2(iq,D2_RA_RA) = (t25*(5.0d-1*rhoa*t19*t27*(6.0d-2*gam
     1           maaa*t1*t22*(6.830221209599997d-3*t88*t90*t97+1.3043825
     2           226666664d+0*gammaaa*t22*t94-1.9209997151999994d-1*t53*
     3           t60*t92)+3.0719999999999986d-3*t23*t88*t90*t97+5.866666
     4           666666666d-1*gammaaa*t22*t23*t94-8.639999999999998d-2*t
     5           23*t53*t60*t92+1.9199999999999995d-2*t53*t55*t60*t61-3.
     6           1999999999999995d-1*gammaaa*t22*t56*t61)+1.25d-1*gammaa
     7           a*t19*t24*t86+5.0d-1*rhoa*t24*t27*t77+1.0d+0*rhoa*t27*t
     8           47*t62+1.0d+0*t19*t27*t62+1.25d-1*gammaaa*t19*t26*t62+1
     9           .0d+0*t24*t27*t47+1.25d-1*gammaaa*t24*t26*t47)+1.0d+0*t
     :           59*(6.2d-3*gammaaa*t1*t3*(t96-3.3828072050666663d-1*gam
     ;           maaa*t3*t94+3.622678988698666d-3*t53*t54*t92)+t95+3.031
     <           1111111111105d-2*gammaaa*t3*t4*t94+t93-3.24604444444444
     =           36d-4*t4*t53*t54*t92+t91)+1.0d+0*t5*(2*rhoa*(t87+8.4434
     >           31970194815d-3*t84*t85*t86+t83+t82+t80+t79)-rhoa*t77+t7
     ?           1+t70-2.0d+0*t14*t44*t45*t46-2.220446049250313d-16*t18*
     @           t37*t42*t43-6.101282288702853d-19*t17*t40-2.64207978626
     1           7853d-3*t13*t40)-1.25d-1*gammaaa*t19*t24*t25*t86+t69+t2
     2           5*t26*(1.25d-1*gammaaa*t19*t62+1.25d-1*gammaaa*t24*t47)
     3           )*wght+Amat2(iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = (1.0d+0*t59*(6.2d-3*gammaaa*t1*t3*(t9
     1           6+1.525338521557333d-3*t53*t54*t92)+t95+t93-1.366755555
     2           555555d-4*t4*t53*t54*t92+t91)+1.0d+0*t5*(2*rhoa*(t87-8.
     3           443431970194815d-3*t84*t85*t86+t83+t82+t80+t79)+t71+t70
     4           )+t69)*wght+Amat2(iq,D2_RA_RB)
              Cmat2(iq,D2_RA_GAA) = (t25*(5.0d-1*rhoa*t19*t27*(6.0d-2*ga
     1           mmaaa*t1*t22*(-2.561332953599999d-3*t53*t97*t99+6.40333
     2           2383999999d-2*gammaaa*t55*t60-3.557406879999999d-1*t22*
     3           t56)-1.1519999999999996d-3*t23*t53*t97*t99+9.5999999999
     4           99997d-3*t53*t55*t60*t66-1.5999999999999998d-1*gammaaa*
     5           t22*t56*t66-3.6d-3*gammaaa*t60*t61*t63+6.0d-2*t1*t22*t6
     6           1+2.879999999999999d-2*gammaaa*t23*t55*t60-1.5999999999
     7           999998d-1*t22*t23*t56)+5.0d-1*rhoa*t27*t47*t67+5.0d-1*t
     8           19*t27*t67-1.25d-1*t19*t62-1.25d-1*t24*t47-1.25d-1*t19*
     9           t24*t26)+t98+t25*t26*(1.25d-1*gammaaa*t19*t67+t106)+1.0
     :           d+0*(6.2d-3*gammaaa*t1*t3*(9.225837832d-2*t3*t56-1.1440
     ;           038911679998d-3*gammaaa*t54*t55+t104)-8.266666666666665
     <           d-3*t3*t4*t56+1.0250666666666663d-4*gammaaa*t4*t54*t55+
     =           t105+t103+t102+t101+t100)*t59)*wght+Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = (t98+1.0d+0*(6.2d-3*gammaaa*t1*t3*(t
     1           104-5.72001945584d-4*gammaaa*t54*t55)+5.125333333333332
     2           d-5*gammaaa*t4*t54*t55+t105+t103+t102+t101+t100)*t59)*w
     3           ght+Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_GAA_GAA) = (t25*(5.0d-1*rhoa*t19*t27*(6.0d-2*g
     1           ammaaa*t1*t22*(9.604998575999998d-4*gammaaa*t107*t97-1.
     2           6008330959999997d-2*t60*t63)+4.32d-4*gammaaa*t107*t23*t
     3           97-7.2d-3*gammaaa*t60*t63*t66+1.2d-1*t1*t22*t66-7.2d-3*
     4           t23*t60*t63)-2.5d-1*t19*t67)+1.0d+0*t108*t59)*wght+Cmat
     5           2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = 1.0d+0*t108*t59*wght+Cmat2(iq,D2_GA
     1           A_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Mmat2(iq,D2_RA_TA) = ((-5.0d-1*rhoa*t19*t27*t62-5.0d-1*rho
     1           a*t24*t27*t47-5.0d-1*t19*t24*t27)*t68-1.25d-1*gammaaa*t
     2           19*t24*t26*t68+t25*(1.0d+0*rhoa*t19*t62+1.0d+0*rhoa*t24
     3           *t47+1.0d+0*t19*t24))*wght+Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = ((t106-5.0d-1*rhoa*t19*t27*t67)*t68+
     1           1.0d+0*rhoa*t19*t25*t67)*wght+Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_TA_TA) = (1.0d+0*rhoa*t19*t24*t27/taua**3-2.0d
     1           +0*rhoa*t19*t24*t68)*wght+Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
            else 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 2.4d-51*t1+1.0d+0
              t3 = 1/t2
              t4 = 5.336110319999999d-51*t1*t3-2.5960897d+0
              t5 = 2.4d-51*t1*t3*t4+1.0d+0
              t6 = 1/rhoa**6.666666666666666d-1
              t7 = rhoa**5.0d-1
              t8 = 1/t7
              t9 = 1/rhoa**3.333333333333333d-1
              t10 = 1/rhoa**1.6666666666666666d-1
              t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.4
     1           058712912881916d-1*t6+1.1120374863094686d+1*t10
              t12 = 3.216395899738507d+1/t11+1.0d+0
              t13 = log(t12)
              t14 = 1.274696188700087d-1*t9+1.0d+0
              t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.8
     1           970043257475583d-1*t6+5.982550435771079d+0*t10
              t16 = 1.6081979498692536d+1/t15+1.0d+0
              t17 = log(t16)
              t18 = 1.3256889990520176d-1*t9+1.0d+0
              t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2
     1           *t13*t14
              t20 = 2.4799999999999997d-52*t1+1.0d+0
              t21 = 1/t20
              t22 = -2*rhoa*t19
              t23 = 1/t16
              t24 = 1/t7**3
              t25 = 1/rhoa**1.3333333333333333d+0
              t26 = 1/rhoa**1.1666666666666667d+0
              t27 = -9.970917392951799d-1*t26-7.418564737168958d-1*t25-4
     1           .002143174996817d-1*t24-1.264669550498372d-1*t1
              t28 = 1/t15**2
              t29 = 1/t12
              t30 = -1.8533958105157808d+0*t26-1.2815820791490704d+0*t25
     1           -8.223668877838045d-1*t24-1.6039141941921276d-1*t1
              t31 = 1/t11**2
              t32 = 1.0d+0*t14*t29*t30*t31+1.1102230246251565d-16*t18*t2
     1           3*t27*t28+3.0506411443514264d-19*t17*t25+1.321039893133
     2           9265d-3*t13*t25
              t33 = 1/t2**2
              t34 = 1/rhoa**4.333333333333333d+0
              t35 = 1/rhoa**2.6666666666666666d+0
              t36 = 2.134444128d-101*t33*t34-8.8935172d-51*t3*t35
              t37 = -4.0d-51*t3*t35*t4+9.6d-102*t33*t34*t4+2.4d-51*t1*t3
     1           *t36
              t38 = 5.9515308d+0-2.7677513496d-51*t1*t21
              t39 = 2.4799999999999997d-52*t1*t21*t38+1.0d+0
              t40 = 6.299605249474366d-1
              t41 = 1.414213562373095d+0
              t42 = 1/t41
              t43 = 7.937005259840998d-1
              t44 = 8.908987181403393d-1
              t45 = 2.2255694211506874d+0*t43*t9+8.004286349993635d-1*t4
     1           2*t8+1.8970043257475583d-1*t40*t6+5.982550435771079d+0*
     2           t10*t44
              t46 = 1.6081979498692536d+1/t45+1.0d+0
              t47 = log(t46)
              t48 = 1.3256889990520176d-1*t43*t9+1.0d+0
              t49 = 1/t46
              t50 = 3.968502629920499d-1
              t51 = -7.418564737168958d-1*t25*t50-4.002143174996817d-1*t
     1           24/t41**3-4.4415387620319857d-1*t26-3.9834594695849657d
     2           -2*t1
              t52 = 1/t45**2
              t53 = 2*rhoa*(1.0d+0*t48*t49*t51*t52+2.747773264188437d-3*
     1           t25*t47*t50)-6.21814d-2*t47*t48-rhoa*t32+6.903522198342
     2           671d-18*t17*t18+3.1090699999999993d-2*t13*t14
              t54 = 1/t20**2
              t55 = 2.306459458d-51*t21*t35-5.72001945584d-103*t34*t54
              t56 = 2.4799999999999997d-52*t1*t21*t55+5.125333333333333d
     1           -104*t34*t38*t54-2.0666666666666667d-52*t21*t35*t38
              t57 = t22-1.243628d-1*rhoa*t47*t48
              t58 = t27**2
              t59 = 1/t7**5
              t60 = 1/rhoa**2.3333333333333334d+0
              t61 = 1/rhoa**2.1666666666666665d+0
              t62 = t30**2
              t63 = -2.0d+0*t14*t29*t62/t11**3+3.216395899738507d+1*t14*
     1           t62/(t11**4*t12**2)+1.0d+0*t14*t29*t31*(2.1622951122684
     2           114d+0*t61+1.7087761055320938d+0*t60+1.2335503316757068
     3           d+0*t59+2.673190323653546d-1*t35)+1.1102230246251565d-1
     4           6*t18*t23*t28*(1.1632736958443765d+0*t61+9.891419649558
     5           61d-1*t60+6.003214762495226d-1*t59+2.1077825841639536d-
     6           1*t35)-4.0675215258019015d-19*t17*t60-1.761386524178568
     7           4d-3*t13*t60-2.220446049250313d-16*t18*t23*t58/t15**3+1
     8           .7854583920998188d-15*t18*t58/(t15**4*t16**2)-8.4979745
     9           91333913d-2*t25*t29*t30*t31-9.812069668265515d-18*t23*t
     :           25*t27*t28
              t64 = 1/t2**3
              t65 = 1/rhoa**7
              t66 = 1/rhoa**5.333333333333333d+0
              t67 = 1/rhoa**3.6666666666666664d+0
              t68 = 2.0d+0*t53*t56
              t69 = 2.0d+0*t48*t49*t51*t52
              t70 = 5.495546528376875d-3*t25*t47*t50
              t71 = t51**2
              t72 = 1.6081979498692536d+1*t48*t71/(t45**4*t46**2)
              t73 = -2.0d+0*t48*t49*t71/t45**3
              t74 = 1.9842513149602492d-1
              t75 = 1.0d+0*t48*t49*t52*(9.89141964955861d-1*t60*t74+2.59
     1           08976111853255d-1*t61+6.003214762495226d-1*t59/t41**5+3
     2           .319549557987472d-2*t35)
              t76 = -3.663697685584583d-3*t47*t60*t74
              t77 = log(2.9608813203268075d+1/(2.247591863577616d+0*t43*
     1           t9+4.3009724712766434d-1*t42*t8+1.9115125951273373d-1*t
     2           40*t6+8.157414703487641d+0*t10*t44)+1.0d+0)
              t78 = 6.901399211255825d-2*t43*t9+1.0d+0
              t79 = 1/rhoa**2
              t80 = -8.837926660346784d-2*t25*t49*t50*t51*t52
              t81 = 1/t20**3
              t82 = 2.118471111111111d-155*t38*t65*t81
              t83 = 1.0250666666666666d-103*t34*t54*t55
              t84 = -4.1333333333333333d-52*t21*t35*t55
              t85 = -2.3642747084138666d-154*t65*t81
              fnc(iq) = (1.0d+0*(2.4799999999999997d-52*t1*t21*(5.951530
     1           8d+0-2.7677513495999995d-51*t1*t21)+1.0d+0)*(t22-1.2436
     2           28d-1*rhoa*(1.0522000558389212d-1*t9+1.0d+0)*log(1.6081
     3           979498692536d+1/(1.766435620181429d+0*t9+5.659885156639
     4           418d-1*t8+1.19503784087549d-1*t6+5.329846514438383d+0*t
     5           10)+1.0d+0))+1.0d+0*rhoa*t19*t5)*wght+fnc(iq)
              Amat(iq,D1_RA) = (1.0d+0*t56*t57+1.0d+0*t39*t53+5.0d-1*rho
     1           a*t32*t5+5.0d-1*t19*t5+5.0d-1*rhoa*t19*t37)*wght+Amat(i
     2           q,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RA_RA) = (1.0d+0*t57*(2.4799999999999997d-52*t
     1           1*t21*(t85-6.150558554666666d-51*t21*t67+2.478675097530
     2           6662d-102*t54*t66)+t84+t83+t82+5.51111111111111d-52*t21
     3           *t38*t67-2.2209777777777773d-103*t38*t54*t66)+1.0d+0*t3
     4           9*(2*rhoa*(t80+8.443431970194815d-3*t77*t78*t79+t76+t75
     5           +t73+t72)+t70+t69-rhoa*t63-2.0d+0*t14*t29*t30*t31-2.220
     6           446049250313d-16*t18*t23*t27*t28-6.101282288702853d-19*
     7           t17*t25-2.642079786267853d-3*t13*t25)+t68+5.0d-1*rhoa*t
     8           19*(2.4d-51*t1*t3*(2.3716045866666666d-50*t3*t67-1.2806
     9           664767999998d-100*t33*t66+1.7075553024d-151*t64*t65)+1.
     :           0666666666666666d-50*t3*t4*t67-5.76d-101*t33*t4*t66+7.6
     ;           8d-152*t4*t64*t65-8.0d-51*t3*t35*t36+1.92d-101*t33*t34*
     <           t36)+5.0d-1*rhoa*t5*t63+1.0d+0*t32*t5+1.0d+0*rhoa*t32*t
     =           37+1.0d+0*t19*t37)*wght+Amat2(iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = (1.0d+0*t57*(2.4799999999999997d-52*t
     1           1*t21*(t85+9.533365759733332d-103*t54*t66)+t84+t83+t82-
     2           8.542222222222222d-104*t38*t54*t66)+1.0d+0*t39*(2*rhoa*
     3           (t80-8.443431970194815d-3*t77*t78*t79+t76+t75+t73+t72)+
     4           t70+t69)+t68)*wght+Amat2(iq,D2_RA_RB)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
            endif 
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          taua    = tau(iq,T_A) 
          taub    = tau(iq,T_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhoa**2.6666666666666666d+0
              t2 = 1/rhob**2.6666666666666666d+0
              t3 = gammabb*t2+gammaaa*t1
              t4 = 3.1d-3*t3+1.0d+0
              t5 = 1/t4
              t6 = 5.9515308d+0-3.459689187d-2*t3*t5
              t7 = 3.1d-3*t3*t5*t6+1.0d+0
              t8 = 1/rhoa**6.666666666666666d-1
              t9 = rhoa**5.0d-1
              t10 = 1/t9
              t11 = 1/rhoa**3.333333333333333d-1
              t12 = 1/rhoa**1.6666666666666666d-1
              t13 = 2.4058712912881916d-1*t8+1.1120374863094686d+1*t12+3
     1           .8447462374472113d+0*t11+1.644733775567609d+0*t10
              t14 = 3.216395899738507d+1/t13+1.0d+0
              t15 = log(t14)
              t16 = 1.274696188700087d-1*t11+1.0d+0
              t17 = 1.8970043257475583d-1*t8+5.982550435771079d+0*t12+2.
     1           2255694211506874d+0*t11+8.004286349993635d-1*t10
              t18 = 1.6081979498692536d+1/t17+1.0d+0
              t19 = log(t18)
              t20 = 1.3256889990520176d-1*t11+1.0d+0
              t21 = -6.903522198342671d-18*t19*t20-3.1090699999999993d-2
     1           *t15*t16
              t22 = 1/rhob**6.666666666666666d-1
              t23 = rhob**5.0d-1
              t24 = 1/t23
              t25 = 1/rhob**3.333333333333333d-1
              t26 = 1/rhob**1.6666666666666666d-1
              t27 = 1.1120374863094686d+1*t26+3.8447462374472113d+0*t25+
     1           1.644733775567609d+0*t24+2.4058712912881916d-1*t22
              t28 = 3.216395899738507d+1/t27+1.0d+0
              t29 = log(t28)
              t30 = 1.274696188700087d-1*t25+1.0d+0
              t31 = 5.982550435771079d+0*t26+2.2255694211506874d+0*t25+8
     1           .004286349993635d-1*t24+1.8970043257475583d-1*t22
              t32 = 1.6081979498692536d+1/t31+1.0d+0
              t33 = log(t32)
              t34 = 1.3256889990520176d-1*t25+1.0d+0
              t35 = -6.903522198342671d-18*t33*t34-3.1090699999999993d-2
     1           *t29*t30
              t36 = rhob+rhoa
              t37 = 1/t36**3.333333333333333d-1
              t38 = 1.3256889990520176d-1*t37+1.0d+0
              t39 = rhoa-rhob
              t40 = t39**4
              t41 = 1/t36**4
              t42 = 1/t36
              t43 = 1.0d+0-t39*t42
              t44 = t39*t42+1.0d+0
              t45 = t44**1.3333333333333333d+0+t43**1.3333333333333333d+
     1           0-2.0d+0
              t46 = -1.923661050931536d+0*t40*t41*t45
              t47 = t46+1.0d+0
              t48 = 1/t36**6.666666666666666d-1
              t49 = t36**5.0d-1
              t50 = 1/t49
              t51 = 1/t36**1.6666666666666666d-1
              t52 = 5.982550435771079d+0*t51+8.004286349993635d-1*t50+1.
     1           8970043257475583d-1*t48+2.2255694211506874d+0*t37
              t53 = 1.6081979498692536d+1/t52+1.0d+0
              t54 = log(t53)
              t55 = -6.21814d-2*t38*t47*t54
              t56 = 6.901399211255825d-2*t37+1.0d+0
              t57 = t46+1.923661050931536d+0*t45
              t58 = 8.157414703487641d+0*t51+4.3009724712766434d-1*t50+1
     1           .9115125951273373d-1*t48+2.247591863577616d+0*t37
              t59 = 2.9608813203268075d+1/t58+1.0d+0
              t60 = log(t59)
              t61 = 1.9751631321680768d-2*t56*t57*t60
              t62 = 1.274696188700087d-1*t37+1.0d+0
              t63 = 1.1120374863094686d+1*t51+1.644733775567609d+0*t50+2
     1           .4058712912881916d-1*t48+3.8447462374472113d+0*t37
              t64 = 3.216395899738507d+1/t63+1.0d+0
              t65 = log(t64)
              t66 = -5.980796863619711d-2*t40*t41*t45*t62*t65
              t67 = t36*(t66+t61+t55)-rhob*t35-rhoa*t21
              t68 = 6.0d-2*gammaaa*t1+1.0d+0
              t69 = 1/t68
              t70 = 1.3340275799999998d-1*gammaaa*t1*t69-2.5960897d+0
              t71 = 6.0d-2*gammaaa*t1*t69*t70+1.0d+0
              t72 = 1/taua
              t73 = 1/rhoa
              t74 = 2.0d+0*taua-2.5d-1*gammaaa*t73
              t75 = 6.0d-2*gammabb*t2+1.0d+0
              t76 = 1/t75
              t77 = 1.3340275799999998d-1*gammabb*t2*t76-2.5960897d+0
              t78 = 6.0d-2*gammabb*t2*t76*t77+1.0d+0
              t79 = 1/taub
              t80 = 1/rhob
              t81 = 2.0d+0*taub-2.5d-1*gammabb*t80
              t82 = 1/t18
              t83 = 1/rhoa**1.6666666666666669d+0
              t84 = 1/t9**3
              t85 = 1/rhoa**1.3333333333333333d+0
              t86 = 1/rhoa**1.1666666666666667d+0
              t87 = -9.970917392951799d-1*t86-7.418564737168958d-1*t85-4
     1           .002143174996817d-1*t84-1.264669550498372d-1*t83
              t88 = 1/t17**2
              t89 = 1/t14
              t90 = -1.8533958105157808d+0*t86-1.2815820791490704d+0*t85
     1           -8.223668877838045d-1*t84-1.6039141941921276d-1*t83
              t91 = 1/t13**2
              t92 = 1.0d+0*t16*t89*t90*t91+1.1102230246251565d-16*t20*t8
     1           2*t87*t88+3.0506411443514264d-19*t19*t85+1.321039893133
     2           9265d-3*t15*t85
              t93 = 1/t36**1.6666666666666669d+0
              t94 = 1/t49**3
              t95 = 1/t36**1.3333333333333333d+0
              t96 = 1/t36**1.1666666666666667d+0
              t97 = -9.970917392951799d-1*t96-7.418564737168958d-1*t95-4
     1           .002143174996817d-1*t94-1.264669550498372d-1*t93
              t98 = 1/t52**2
              t99 = 1/t53
              t100 = 1.0d+0*t38*t47*t97*t98*t99
              t101 = -1.3595691172479402d+0*t96-7.491972878592053d-1*t95
     1           -2.1504862356383217d-1*t94-1.2743417300848914d-1*t93
              t102 = 1/t58**2
              t103 = 1/t59
              t104 = -5.848223622634647d-1*t101*t102*t103*t56*t57
              t105 = -1.8533958105157808d+0*t96-1.2815820791490704d+0*t9
     1           5-8.223668877838045d-1*t94-1.6039141941921276d-1*t93
              t106 = 1/t63**2
              t107 = 1/t64
              t108 = 1.923661050931536d+0*t105*t106*t107*t40*t41*t45*t62
              t109 = 1/t36**2
              t110 = t109*t39
              t111 = -t42
              t112 = t111+t110
              t113 = t43**3.333333333333333d-1
              t114 = -t109*t39
              t115 = t42+t114
              t116 = t44**3.333333333333333d-1
              t117 = 1.3333333333333333d+0*t115*t116+1.3333333333333333d
     1           +0*t112*t113
              t118 = -1.923661050931536d+0*t117*t40*t41
              t119 = 1/t36**5
              t120 = 7.694644203726144d+0*t119*t40*t45
              t121 = t39**3
              t122 = -7.694644203726144d+0*t121*t41*t45
              t123 = t122+t120+t118
              t124 = -6.21814d-2*t123*t38*t54
              t125 = 2.747773264188437d-3*t47*t54*t95
              t126 = t122+t120+t118+1.923661050931536d+0*t117
              t127 = 1.9751631321680768d-2*t126*t56*t60
              t128 = -4.5437964274821163d-4*t57*t60*t95
              t129 = -5.980796863619711d-2*t117*t40*t41*t62*t65
              t130 = 1/t36**5.333333333333333d+0
              t131 = 2.541232989148493d-3*t130*t40*t45*t65
              t132 = 2.3923187454478842d-1*t119*t40*t45*t62*t65
              t133 = -rhoa*t92+t66+t36*(-2.3923187454478842d-1*t121*t41*
     1           t45*t62*t65+t132+t131+t129+t128+t127+t125+t124+t108+t10
     2           4+t100)+t61+t55+6.903522198342671d-18*t19*t20+3.1090699
     3           999999993d-2*t15*t16
              t134 = 1/rhoa**3.6666666666666664d+0
              t135 = 1/t4**2
              t136 = 9.225837832d-2*gammaaa*t134*t5-2.86000972792d-4*gam
     1           maaa*t134*t135*t3
              t137 = -8.266666666666665d-3*gammaaa*t134*t5*t6+2.56266666
     1           6666666d-5*gammaaa*t134*t135*t3*t6+3.1d-3*t136*t3*t5
              t138 = gammaaa**2
              t139 = 1/t68**2
              t140 = 1/rhoa**6.333333333333333d+0
              t141 = 2.1344441279999993d-2*t138*t139*t140-3.557406879999
     1           999d-1*gammaaa*t134*t69
              t142 = -1.5999999999999998d-1*gammaaa*t134*t69*t70+9.59999
     1           9999999997d-3*t138*t139*t140*t70+6.0d-2*gammaaa*t1*t141
     2           *t69
              t143 = 1/t32
              t144 = 1/rhob**1.6666666666666669d+0
              t145 = 1/t23**3
              t146 = 1/rhob**1.3333333333333333d+0
              t147 = 1/rhob**1.1666666666666667d+0
              t148 = -9.970917392951799d-1*t147-7.418564737168958d-1*t14
     1           6-4.002143174996817d-1*t145-1.264669550498372d-1*t144
              t149 = 1/t31**2
              t150 = 1/t28
              t151 = -1.8533958105157808d+0*t147-1.2815820791490704d+0*t
     1           146-8.223668877838045d-1*t145-1.6039141941921276d-1*t14
     2           4
              t152 = 1/t27**2
              t153 = 1.1102230246251565d-16*t143*t148*t149*t34+3.0506411
     1           443514264d-19*t146*t33+1.0d+0*t150*t151*t152*t30+1.3210
     2           398931339265d-3*t146*t29
              t154 = t42+t110
              t155 = t114+t111
              t156 = 1.3333333333333333d+0*t116*t155+1.3333333333333333d
     1           +0*t113*t154
              t157 = -1.923661050931536d+0*t156*t40*t41
              t158 = 7.694644203726144d+0*t121*t41*t45
              t159 = t158+t157+t120
              t160 = -6.21814d-2*t159*t38*t54
              t161 = t158+t157+1.923661050931536d+0*t156+t120
              t162 = 1.9751631321680768d-2*t161*t56*t60
              t163 = -5.980796863619711d-2*t156*t40*t41*t62*t65
              t164 = t66+t36*(2.3923187454478842d-1*t121*t41*t45*t62*t65
     1           +t163+t162+t160+t132+t131+t128+t125+t108+t104+t100)+t61
     2           +t55+6.903522198342671d-18*t33*t34+3.1090699999999993d-
     3           2*t29*t30-rhob*t153
              t165 = 1/rhob**3.6666666666666664d+0
              t166 = 9.225837832d-2*gammabb*t165*t5-2.86000972792d-4*gam
     1           mabb*t135*t165*t3
              t167 = -8.266666666666665d-3*gammabb*t165*t5*t6+2.56266666
     1           6666666d-5*gammabb*t135*t165*t3*t6+3.1d-3*t166*t3*t5
              t168 = gammabb**2
              t169 = 1/t75**2
              t170 = 1/rhob**6.333333333333333d+0
              t171 = 2.1344441279999993d-2*t168*t169*t170-3.557406879999
     1           999d-1*gammabb*t165*t76
              t172 = -1.5999999999999998d-1*gammabb*t165*t76*t77+9.59999
     1           9999999997d-3*t168*t169*t170*t77+6.0d-2*gammabb*t171*t2
     2           *t76
              t173 = 1.07250364797d-4*t1*t135*t3-3.459689187d-2*t1*t5
              t174 = 3.1d-3*t1*t5*t6-9.61d-6*t1*t135*t3*t6+3.1d-3*t173*t
     1           3*t5
              t175 = 1/rhoa**5.333333333333333d+0
              t176 = 1.3340275799999998d-1*t1*t69-8.004165479999998d-3*g
     1           ammaaa*t139*t175
              t177 = 6.0d-2*t1*t69*t70-3.6d-3*gammaaa*t139*t175*t70+6.0d
     1           -2*gammaaa*t1*t176*t69
              t178 = 1.07250364797d-4*t135*t2*t3-3.459689187d-2*t2*t5
              t179 = 3.1d-3*t2*t5*t6-9.61d-6*t135*t2*t3*t6+3.1d-3*t178*t
     1           3*t5
              t180 = 1/rhob**5.333333333333333d+0
              t181 = 1.3340275799999998d-1*t2*t76-8.004165479999998d-3*g
     1           ammabb*t169*t180
              t182 = 6.0d-2*t2*t76*t77-3.6d-3*gammabb*t169*t180*t77+6.0d
     1           -2*gammabb*t181*t2*t76
              t183 = 1/taua**2
              t184 = 1/taub**2
              t185 = t87**2
              t186 = 1/t9**5
              t187 = 1/rhoa**2.3333333333333334d+0
              t188 = 1/rhoa**2.1666666666666665d+0
              t189 = t90**2
              t190 = -8.497974591333913d-2*t85*t89*t90*t91+1.0d+0*t16*(2
     1           .1622951122684114d+0*t188+1.7087761055320938d+0*t187+1.
     2           2335503316757068d+0*t186+2.673190323653546d-1*t1)*t89*t
     3           91-2.0d+0*t16*t189*t89/t13**3-9.812069668265515d-18*t82
     4           *t85*t87*t88+1.1102230246251565d-16*(1.1632736958443765
     5           d+0*t188+9.89141964955861d-1*t187+6.003214762495226d-1*
     6           t186+2.1077825841639536d-1*t1)*t20*t82*t88-2.2204460492
     7           50313d-16*t185*t20*t82/t17**3+1.7854583920998188d-15*t1
     8           85*t20/(t17**4*t18**2)-4.0675215258019015d-19*t187*t19+
     9           3.216395899738507d+1*t16*t189/(t13**4*t14**2)-1.7613865
     :           241785684d-3*t15*t187
              t191 = 2.0d+0*t38*t47*t97*t98*t99
              t192 = -1.1696447245269295d+0*t101*t102*t103*t56*t57
              t193 = 3.847322101863072d+0*t105*t106*t107*t40*t41*t45*t62
              t194 = 5.495546528376875d-3*t47*t54*t95
              t195 = -9.087592854964233d-4*t57*t60*t95
              t196 = 5.082465978296986d-3*t130*t40*t45*t65
              t197 = 4.7846374908957684d-1*t119*t40*t45*t62*t65
              t198 = t97**2
              t199 = 1.6081979498692536d+1*t198*t38*t47/(t52**4*t53**2)
              t200 = -2.0d+0*t198*t38*t47*t99/t52**3
              t201 = -8.837926660346784d-2*t47*t95*t97*t98*t99
              t202 = 1/t36**2.6666666666666666d+0
              t203 = 1/t49**5
              t204 = 1/t36**2.3333333333333334d+0
              t205 = 1/t36**2.1666666666666665d+0
              t206 = 1.0d+0*(1.1632736958443765d+0*t205+9.89141964955861
     1           d-1*t204+6.003214762495226d-1*t203+2.1077825841639536d-
     2           1*t202)*t38*t47*t98*t99
              t207 = t101**2
              t208 = -1.73158960813529d+1*t207*t56*t57/(t58**4*t59**2)
              t209 = 1.1696447245269295d+0*t103*t207*t56*t57/t58**3
              t210 = 2.690728393099896d-2*t101*t102*t103*t57*t95
              t211 = -5.848223622634647d-1*t102*t103*(1.5861639701225969
     1           d+0*t205+9.98929717145607d-1*t204+3.2257293534574827d-1
     2           *t203+2.1239028834748191d-1*t202)*t56*t57
              t212 = t105**2
              t213 = 6.187255516702861d+1*t212*t40*t41*t45*t62/(t63**4*t
     1           64**2)
              t214 = -3.847322101863072d+0*t107*t212*t40*t41*t45*t62/t63
     1           **3
              t215 = -1.6347222733154887d-1*t105*t106*t107*t130*t40*t45
              t216 = 1.923661050931536d+0*t106*t107*(2.1622951122684114d
     1           +0*t205+1.7087761055320938d+0*t204+1.2335503316757068d+
     2           0*t203+2.673190323653546d-1*t202)*t40*t41*t45*t62
              t217 = -1.538928840745229d+1*t105*t106*t107*t119*t40*t45*t
     1           62
              t218 = 1/t43**6.666666666666666d-1
              t219 = 1/t36**3
              t220 = -2*t219*t39
              t221 = 2*t109
              t222 = 1/t44**6.666666666666666d-1
              t223 = 2*t219*t39
              t224 = -2*t109
              t225 = 1.3333333333333333d+0*t116*(t224+t223)+4.4444444444
     1           44444d-1*t115**2*t222+1.3333333333333333d+0*t113*(t221+
     2           t220)+4.444444444444444d-1*t112**2*t218
              t226 = -1.923661050931536d+0*t225*t40*t41
              t227 = 1.5389288407452287d+1*t117*t119*t40
              t228 = -1.5389288407452287d+1*t117*t121*t41
              t229 = 1/t36**6
              t230 = -3.8473221018630716d+1*t229*t40*t45
              t231 = 6.155715362980915d+1*t119*t121*t45
              t232 = t39**2
              t233 = -2.3083932611178434d+1*t232*t41*t45
              t234 = -3.663697685584583d-3*t204*t47*t54
              t235 = 6.058395236642822d-4*t204*t57*t60
              t236 = -2.3718174565385935d-2*t40*t45*t65/t36**6.333333333
     1           333333d+0
              t237 = -1.1961593727239421d+0*t229*t40*t45*t62*t65
              t238 = -7.176956236343652d-1*t232*t41*t45*t62*t65
              t239 = 1/rhoa**7.333333333333333d+0
              t240 = 1/t4**3
              t241 = 1/rhoa**4.666666666666667d+0
              t242 = 1/rhoa**2
              t243 = gammaaa**3
              t244 = 1/t68**3
              t245 = 1/rhoa**10
              t246 = 2.6666666666666666d+0*t116*t219*t39-2.6666666666666
     1           666d+0*t113*t219*t39+4.444444444444444d-1*t115*t155*t22
     2           2+4.444444444444444d-1*t112*t154*t218
              t247 = -1.923661050931536d+0*t246*t40*t41
              t248 = 7.694644203726144d+0*t119*t156*t40
              t249 = -7.694644203726144d+0*t121*t156*t41
              t250 = 7.694644203726144d+0*t117*t119*t40
              t251 = 7.694644203726144d+0*t117*t121*t41
              t252 = 2.3083932611178434d+1*t232*t41*t45
              t253 = t148**2
              t254 = 1/t23**5
              t255 = 1/rhob**2.3333333333333334d+0
              t256 = 1/rhob**2.1666666666666665d+0
              t257 = t151**2
              t258 = 1.7854583920998188d-15*t253*t34/(t31**4*t32**2)-2.2
     1           20446049250313d-16*t143*t253*t34/t31**3+1.1102230246251
     2           565d-16*t143*t149*(1.1632736958443765d+0*t256+9.8914196
     3           4955861d-1*t255+6.003214762495226d-1*t254+2.10778258416
     4           39536d-1*t2)*t34-4.0675215258019015d-19*t255*t33+3.2163
     5           95899738507d+1*t257*t30/(t27**4*t28**2)-2.0d+0*t150*t25
     6           7*t30/t27**3+1.0d+0*t150*t152*(2.1622951122684114d+0*t2
     7           56+1.7087761055320938d+0*t255+1.2335503316757068d+0*t25
     8           4+2.673190323653546d-1*t2)*t30-1.7613865241785684d-3*t2
     9           55*t29-8.497974591333913d-2*t146*t150*t151*t152-9.81206
     :           9668265515d-18*t143*t146*t148*t149
              t259 = 1.3333333333333333d+0*t113*(t224+t220)+1.3333333333
     1           333333d+0*t116*(t223+t221)+4.444444444444444d-1*t155**2
     2           *t222+4.444444444444444d-1*t154**2*t218
              t260 = -1.923661050931536d+0*t259*t40*t41
              t261 = 1.5389288407452287d+1*t119*t156*t40
              t262 = 1.5389288407452287d+1*t121*t156*t41
              t263 = -6.155715362980915d+1*t119*t121*t45
              t264 = 1/rhob**7.333333333333333d+0
              t265 = 1/rhob**4.666666666666667d+0
              t266 = 1/rhob**2
              t267 = gammabb**3
              t268 = 1/t75**3
              t269 = 1/rhob**10
              t270 = 1.25d-1*t21*t71
              t271 = 1/rhoa**9
              t272 = 1.25d-1*t35*t78
              t273 = 1/rhob**9
              t274 = 1/rhoa**8
              t275 = 1/rhob**8
              fnc(iq) = (5.0d-1*rhob*t35*t78*t79*t81+5.0d-1*rhoa*t21*t71
     1           *t72*t74+1.0d+0*t67*t7)*wght+fnc(iq)
              Amat(iq,D1_RA) = (t72*(5.0d-1*rhoa*t71*t74*t92+5.0d-1*t21*
     1           t71*t74+5.0d-1*rhoa*t142*t21*t74)+1.25d-1*gammaaa*t21*t
     2           71*t72*t73+1.0d+0*t133*t7+1.0d+0*t137*t67)*wght+Amat(iq
     3           ,D1_RA)
              Amat(iq,D1_RB) = (t79*(5.0d-1*t35*t78*t81+5.0d-1*rhob*t153
     1           *t78*t81+5.0d-1*rhob*t172*t35*t81)+1.25d-1*gammabb*t35*
     2           t78*t79*t80+1.0d+0*t164*t7+1.0d+0*t167*t67)*wght+Amat(i
     3           q,D1_RB)
              Cmat(iq,D1_GAA) = (t72*(5.0d-1*rhoa*t177*t21*t74-1.25d-1*t
     1           21*t71)+1.0d+0*t174*t67)*wght+Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = (t79*(5.0d-1*rhob*t182*t35*t81-1.25d-1*t
     1           35*t78)+1.0d+0*t179*t67)*wght+Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = (1.0d+0*rhoa*t21*t71*t72-5.0d-1*rhoa*t183
     1           *t21*t71*t74)*wght+Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = (1.0d+0*rhob*t35*t78*t79-5.0d-1*rhob*t184
     1           *t35*t78*t81)*wght+Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (1.0d+0*t7*(t36*(2.0d+0*t123*t38*t97*
     1           t98*t99-9.087592854964233d-4*t126*t60*t95+5.49554652837
     2           6875d-3*t123*t54*t95+1.9138549963583074d+0*t119*t121*t4
     3           5*t62*t65-5.980796863619711d-2*t225*t40*t41*t62*t65-4.7
     4           846374908957684d-1*t117*t121*t41*t62*t65+4.784637490895
     5           7684d-1*t117*t119*t40*t62*t65+2.0329863913187946d-2*t12
     6           1*t130*t45*t65+5.082465978296986d-3*t117*t130*t40*t65+1
     7           .538928840745229d+1*t105*t106*t107*t121*t41*t45*t62+3.8
     8           47322101863072d+0*t105*t106*t107*t117*t40*t41*t62+1.975
     9           1631321680768d-2*(t233+t231+t230+t228+t227+t226+1.92366
     :           1050931536d+0*t225)*t56*t60-1.1696447245269295d+0*t101*
     ;           t102*t103*t126*t56-6.21814d-2*(t233+t231+t230+t228+t227
     <           +t226)*t38*t54+t238+t237+t236+t235+t234+t217+t216+t215+
     =           t214+t213+t211+t210+t209+t208+t206+t201+t200+t199)-2.0d
     >           +0*t16*t89*t90*t91-2.220446049250313d-16*t20*t82*t87*t8
     ?           8-6.101282288702853d-19*t19*t85-2.642079786267853d-3*t1
     @           5*t85-4.7846374908957684d-1*t121*t41*t45*t62*t65-1.1961
     1           593727239421d-1*t117*t40*t41*t62*t65+3.9503262643361536
     2           d-2*t126*t56*t60-1.243628d-1*t123*t38*t54+t197+t196+t19
     3           5+t194+t193+t192+t191-rhoa*t190)+t72*(1.0d+0*t71*t74*t9
     4           2+1.0d+0*rhoa*t142*t74*t92+1.25d-1*gammaaa*t71*t73*t92+
     5           5.0d-1*rhoa*t190*t71*t74+5.0d-1*rhoa*t21*(5.86666666666
     6           6666d-1*gammaaa*t241*t69*t70+3.0719999999999986d-3*t243
     7           *t244*t245*t70-8.639999999999998d-2*t138*t139*t239*t70+
     8           6.0d-2*gammaaa*t1*t69*(1.3043825226666664d+0*gammaaa*t2
     9           41*t69+6.830221209599997d-3*t243*t244*t245-1.9209997151
     :           999994d-1*t138*t139*t239)-3.1999999999999995d-1*gammaaa
     ;           *t134*t141*t69+1.9199999999999995d-2*t138*t139*t140*t14
     <           1)*t74+1.0d+0*t142*t21*t74+1.25d-1*gammaaa*t142*t21*t73
     =           +1.25d-1*gammaaa*t21*t242*t71)+t72*t73*(1.25d-1*gammaaa
     >           *t71*t92+1.25d-1*gammaaa*t142*t21)-1.25d-1*gammaaa*t21*
     ?           t242*t71*t72+1.0d+0*(3.0311111111111105d-2*gammaaa*t241
     @           *t5*t6-9.396444444444442d-5*gammaaa*t135*t241*t3*t6+4.2
     1           369422222222203d-7*t138*t239*t240*t3*t6-1.3667555555555
     2           55d-4*t135*t138*t239*t6+3.1d-3*t3*t5*(-3.38280720506666
     3           63d-1*gammaaa*t241*t5+1.0486702335706666d-3*gammaaa*t13
     4           5*t241*t3-4.728549416827732d-6*t138*t239*t240*t3+1.5253
     5           38521557333d-3*t135*t138*t239)-1.653333333333333d-2*gam
     6           maaa*t134*t136*t5+5.125333333333332d-5*gammaaa*t134*t13
     7           5*t136*t3)*t67+2.0d+0*t133*t137)*wght+Amat2(iq,D2_RA_RA
     8           )
              Amat2(iq,D2_RA_RB) = (1.0d+0*t7*(t36*(1.0d+0*t159*t38*t97*
     1           t98*t99+1.0d+0*t123*t38*t97*t98*t99-4.5437964274821163d
     2           -4*t161*t60*t95-4.5437964274821163d-4*t126*t60*t95+2.74
     3           7773264188437d-3*t159*t54*t95+2.747773264188437d-3*t123
     4           *t54*t95+7.176956236343652d-1*t232*t41*t45*t62*t65-5.98
     5           0796863619711d-2*t246*t40*t41*t62*t65-2.392318745447884
     6           2d-1*t121*t156*t41*t62*t65+2.3923187454478842d-1*t117*t
     7           121*t41*t62*t65+2.3923187454478842d-1*t119*t156*t40*t62
     8           *t65+2.3923187454478842d-1*t117*t119*t40*t62*t65+2.5412
     9           32989148493d-3*t130*t156*t40*t65+2.541232989148493d-3*t
     :           117*t130*t40*t65+1.923661050931536d+0*t105*t106*t107*t1
     ;           56*t40*t41*t62+1.923661050931536d+0*t105*t106*t107*t117
     <           *t40*t41*t62+1.9751631321680768d-2*(t252+t251+t250+t249
     =           +t248+t247+1.923661050931536d+0*t246+t230)*t56*t60-5.84
     >           8223622634647d-1*t101*t102*t103*t161*t56-5.848223622634
     ?           647d-1*t101*t102*t103*t126*t56-6.21814d-2*(t252+t251+t2
     @           50+t249+t248+t247+t230)*t38*t54+t237+t236+t235+t234+t21
     1           7+t216+t215+t214+t213+t211+t210+t209+t208+t206+t201+t20
     2           0+t199)+t197+t196+t195+t194+t193+t192+t191+t163+t162+t1
     3           60+t129+t127+t124)+1.0d+0*(4.2369422222222203d-7*gammaa
     4           a*gammabb*t134*t165*t240*t3*t6-1.366755555555555d-4*gam
     5           maaa*gammabb*t134*t135*t165*t6+3.1d-3*t3*(1.52533852155
     6           7333d-3*gammaaa*gammabb*t134*t135*t165-4.72854941682773
     7           2d-6*gammaaa*gammabb*t134*t165*t240*t3)*t5-8.2666666666
     8           66665d-3*gammaaa*t134*t166*t5-8.266666666666665d-3*gamm
     9           abb*t136*t165*t5+2.562666666666666d-5*gammaaa*t134*t135
     :           *t166*t3+2.562666666666666d-5*gammabb*t135*t136*t165*t3
     ;           )*t67+1.0d+0*t133*t167+1.0d+0*t137*t164)*wght+Amat2(iq,
     <           D2_RA_RB)
              Amat2(iq,D2_RB_RB) = (1.0d+0*t7*(t36*(2.0d+0*t159*t38*t97*
     1           t98*t99-9.087592854964233d-4*t161*t60*t95+5.49554652837
     2           6875d-3*t159*t54*t95-1.9138549963583074d+0*t119*t121*t4
     3           5*t62*t65-5.980796863619711d-2*t259*t40*t41*t62*t65+4.7
     4           846374908957684d-1*t121*t156*t41*t62*t65+4.784637490895
     5           7684d-1*t119*t156*t40*t62*t65-2.0329863913187946d-2*t12
     6           1*t130*t45*t65+5.082465978296986d-3*t130*t156*t40*t65-1
     7           .538928840745229d+1*t105*t106*t107*t121*t41*t45*t62+3.8
     8           47322101863072d+0*t105*t106*t107*t156*t40*t41*t62+1.975
     9           1631321680768d-2*(t263+t262+t261+t260+1.923661050931536
     :           d+0*t259+t233+t230)*t56*t60-1.1696447245269295d+0*t101*
     ;           t102*t103*t161*t56-6.21814d-2*(t263+t262+t261+t260+t233
     <           +t230)*t38*t54+t238+t237+t236+t235+t234+t217+t216+t215+
     =           t214+t213+t211+t210+t209+t208+t206+t201+t200+t199)+4.78
     >           46374908957684d-1*t121*t41*t45*t62*t65-1.19615937272394
     ?           21d-1*t156*t40*t41*t62*t65+3.9503262643361536d-2*t161*t
     @           56*t60-1.243628d-1*t159*t38*t54-2.220446049250313d-16*t
     1           143*t148*t149*t34-6.101282288702853d-19*t146*t33-2.0d+0
     2           *t150*t151*t152*t30-2.642079786267853d-3*t146*t29-rhob*
     3           t258+t197+t196+t195+t194+t193+t192+t191)+t79*(5.0d-1*rh
     4           ob*t258*t78*t81+1.0d+0*t153*t78*t81+5.0d-1*rhob*t35*(5.
     5           866666666666666d-1*gammabb*t265*t76*t77+3.0719999999999
     6           986d-3*t267*t268*t269*t77-8.639999999999998d-2*t168*t16
     7           9*t264*t77+6.0d-2*gammabb*t2*t76*(1.3043825226666664d+0
     8           *gammabb*t265*t76+6.830221209599997d-3*t267*t268*t269-1
     9           .9209997151999994d-1*t168*t169*t264)-3.1999999999999995
     :           d-1*gammabb*t165*t171*t76+1.9199999999999995d-2*t168*t1
     ;           69*t170*t171)*t81+1.0d+0*t172*t35*t81+1.0d+0*rhob*t153*
     <           t172*t81+1.25d-1*gammabb*t153*t78*t80+1.25d-1*gammabb*t
     =           172*t35*t80+1.25d-1*gammabb*t266*t35*t78)+(1.25d-1*gamm
     >           abb*t153*t78+1.25d-1*gammabb*t172*t35)*t79*t80-1.25d-1*
     ?           gammabb*t266*t35*t78*t79+1.0d+0*(3.0311111111111105d-2*
     @           gammabb*t265*t5*t6-9.396444444444442d-5*gammabb*t135*t2
     1           65*t3*t6+4.2369422222222203d-7*t168*t240*t264*t3*t6-1.3
     2           66755555555555d-4*t135*t168*t264*t6+3.1d-3*t3*t5*(-3.38
     3           28072050666663d-1*gammabb*t265*t5+1.0486702335706666d-3
     4           *gammabb*t135*t265*t3-4.728549416827732d-6*t168*t240*t2
     5           64*t3+1.525338521557333d-3*t135*t168*t264)-1.6533333333
     6           33333d-2*gammabb*t165*t166*t5+5.125333333333332d-5*gamm
     7           abb*t135*t165*t166*t3)*t67+2.0d+0*t164*t167)*wght+Amat2
     8           (iq,D2_RB_RB)
              Cmat2(iq,D2_RA_GAA) = (t72*(5.0d-1*rhoa*t177*t74*t92-1.25d
     1           -1*t71*t92+5.0d-1*rhoa*t21*(-1.5999999999999998d-1*t134
     2           *t69*t70-1.1519999999999996d-3*t138*t244*t271*t70+2.879
     3           999999999999d-2*gammaaa*t139*t140*t70+6.0d-2*gammaaa*t1
     4           *t69*(-3.557406879999999d-1*t134*t69-2.561332953599999d
     5           -3*t138*t244*t271+6.403332383999999d-2*gammaaa*t139*t14
     6           0)-1.5999999999999998d-1*gammaaa*t134*t176*t69+6.0d-2*t
     7           1*t141*t69+9.599999999999997d-3*t138*t139*t140*t176-3.6
     8           d-3*gammaaa*t139*t141*t175)*t74+5.0d-1*t177*t21*t74-1.2
     9           5d-1*t21*t71*t73-1.25d-1*t142*t21)+(t270+1.25d-1*gammaa
     :           a*t177*t21)*t72*t73+1.0d+0*(-8.266666666666665d-3*t134*
     ;           t5*t6-1.5888533333333327d-7*gammaaa*t140*t240*t3*t6+2.5
     <           62666666666666d-5*t134*t135*t3*t6+5.125333333333332d-5*
     =           gammaaa*t135*t140*t6+3.1d-3*t3*t5*(9.225837832d-2*t134*
     >           t5+1.7732060313103998d-6*gammaaa*t140*t240*t3-2.8600097
     ?           2792d-4*t134*t135*t3-5.72001945584d-4*gammaaa*t135*t140
     @           )-8.266666666666665d-3*gammaaa*t134*t173*t5+3.1d-3*t1*t
     1           136*t5+2.562666666666666d-5*gammaaa*t134*t135*t173*t3-9
     2           .61d-6*t1*t135*t136*t3)*t67+1.0d+0*t133*t174)*wght+Cmat
     3           2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = (1.0d+0*(-1.5888533333333327d-7*gamm
     1           aaa*t134*t2*t240*t3*t6+5.125333333333332d-5*gammaaa*t13
     2           4*t135*t2*t6+3.1d-3*t3*(1.7732060313103998d-6*gammaaa*t
     3           134*t2*t240*t3-5.72001945584d-4*gammaaa*t134*t135*t2)*t
     4           5+3.1d-3*t136*t2*t5-8.266666666666665d-3*gammaaa*t134*t
     5           178*t5-9.61d-6*t135*t136*t2*t3+2.562666666666666d-5*gam
     6           maaa*t134*t135*t178*t3)*t67+1.0d+0*t133*t179)*wght+Cmat
     7           2(iq,D2_RA_GBB)
              Cmat2(iq,D2_RB_GAA) = (1.0d+0*(-1.5888533333333327d-7*gamm
     1           abb*t1*t165*t240*t3*t6+5.125333333333332d-5*gammabb*t1*
     2           t135*t165*t6+3.1d-3*t3*(1.7732060313103998d-6*gammabb*t
     3           1*t165*t240*t3-5.72001945584d-4*gammabb*t1*t135*t165)*t
     4           5-8.266666666666665d-3*gammabb*t165*t173*t5+3.1d-3*t1*t
     5           166*t5+2.562666666666666d-5*gammabb*t135*t165*t173*t3-9
     6           .61d-6*t1*t135*t166*t3)*t67+1.0d+0*t164*t174)*wght+Cmat
     7           2(iq,D2_RB_GAA)
              Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
              Cmat2(iq,D2_RB_GBB) = (t79*(5.0d-1*rhob*t35*(-1.5999999999
     1           999998d-1*t165*t76*t77-1.1519999999999996d-3*t168*t268*
     2           t273*t77+2.879999999999999d-2*gammabb*t169*t170*t77+6.0
     3           d-2*gammabb*t2*t76*(-3.557406879999999d-1*t165*t76-2.56
     4           1332953599999d-3*t168*t268*t273+6.403332383999999d-2*ga
     5           mmabb*t169*t170)+6.0d-2*t171*t2*t76-1.5999999999999998d
     6           -1*gammabb*t165*t181*t76+9.599999999999997d-3*t168*t169
     7           *t170*t181-3.6d-3*gammabb*t169*t171*t180)*t81+5.0d-1*t1
     8           82*t35*t81+5.0d-1*rhob*t153*t182*t81-1.25d-1*t35*t78*t8
     9           0-1.25d-1*t153*t78-1.25d-1*t172*t35)+(1.25d-1*gammabb*t
     :           182*t35+t272)*t79*t80+1.0d+0*(-8.266666666666665d-3*t16
     ;           5*t5*t6-1.5888533333333327d-7*gammabb*t170*t240*t3*t6+2
     <           .562666666666666d-5*t135*t165*t3*t6+5.125333333333332d-
     =           5*gammabb*t135*t170*t6+3.1d-3*t3*t5*(9.225837832d-2*t16
     >           5*t5+1.7732060313103998d-6*gammabb*t170*t240*t3-2.86000
     ?           972792d-4*t135*t165*t3-5.72001945584d-4*gammabb*t135*t1
     @           70)+3.1d-3*t166*t2*t5-8.266666666666665d-3*gammabb*t165
     1           *t178*t5-9.61d-6*t135*t166*t2*t3+2.562666666666666d-5*g
     2           ammabb*t135*t165*t178*t3)*t67+1.0d+0*t164*t179)*wght+Cm
     3           at2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GAA_GAA) = (t72*(5.0d-1*rhoa*t21*(4.32d-4*gamm
     1           aaa*t244*t274*t70-7.2d-3*t139*t175*t70+6.0d-2*gammaaa*t
     2           1*(9.604998575999998d-4*gammaaa*t244*t274-1.60083309599
     3           99997d-2*t139*t175)*t69+1.2d-1*t1*t176*t69-7.2d-3*gamma
     4           aa*t139*t175*t176)*t74-2.5d-1*t177*t21)+1.0d+0*(5.9582d
     5           -8*t175*t240*t3*t6-1.9219999999999998d-5*t135*t175*t6+3
     6           .1d-3*t3*(2.14500729594d-4*t135*t175-6.649522617413999d
     7           -7*t175*t240*t3)*t5+6.2d-3*t1*t173*t5-1.921999999999999
     8           8d-5*t1*t135*t173*t3)*t67)*wght+Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = 1.0d+0*(5.9582d-8*t1*t2*t240*t3*t6-
     1           1.9219999999999998d-5*t1*t135*t2*t6+3.1d-3*t3*(2.145007
     2           29594d-4*t1*t135*t2-6.649522617413999d-7*t1*t2*t240*t3)
     3           *t5+3.1d-3*t173*t2*t5+3.1d-3*t1*t178*t5-9.61d-6*t135*t1
     4           73*t2*t3-9.61d-6*t1*t135*t178*t3)*t67*wght+Cmat2(iq,D2_
     5           GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
              Cmat2(iq,D2_GBB_GBB) = (t79*(5.0d-1*rhob*t35*(4.32d-4*gamm
     1           abb*t268*t275*t77-7.2d-3*t169*t180*t77+6.0d-2*gammabb*t
     2           2*(9.604998575999998d-4*gammabb*t268*t275-1.60083309599
     3           99997d-2*t169*t180)*t76+1.2d-1*t181*t2*t76-7.2d-3*gamma
     4           bb*t169*t180*t181)*t81-2.5d-1*t182*t35)+1.0d+0*(5.9582d
     5           -8*t180*t240*t3*t6-1.9219999999999998d-5*t135*t180*t6+3
     6           .1d-3*t3*(2.14500729594d-4*t135*t180-6.649522617413999d
     7           -7*t180*t240*t3)*t5+6.2d-3*t178*t2*t5-1.921999999999999
     8           8d-5*t135*t178*t2*t3)*t67)*wght+Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RA_TA) = (t183*(-5.0d-1*rhoa*t71*t74*t92-5.0d-
     1           1*t21*t71*t74-5.0d-1*rhoa*t142*t21*t74)+t72*(1.0d+0*rho
     2           a*t71*t92+1.0d+0*t21*t71+1.0d+0*rhoa*t142*t21)-1.25d-1*
     3           gammaaa*t183*t21*t71*t73)*wght+Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = (t184*(-5.0d-1*t35*t78*t81-5.0d-1*rho
     1           b*t153*t78*t81-5.0d-1*rhob*t172*t35*t81)-1.25d-1*gammab
     2           b*t184*t35*t78*t80+(1.0d+0*t35*t78+1.0d+0*rhob*t153*t78
     3           +1.0d+0*rhob*t172*t35)*t79)*wght+Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GAA_TA) = (t183*(t270-5.0d-1*rhoa*t177*t21*t74
     1           )+1.0d+0*rhoa*t177*t21*t72)*wght+Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = (t184*(t272-5.0d-1*rhob*t182*t35*t81
     1           )+1.0d+0*rhob*t182*t35*t79)*wght+Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = (1.0d+0*rhoa*t21*t71*t74/taua**3-2.0d
     1           +0*rhoa*t183*t21*t71)*wght+Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = (1.0d+0*rhob*t35*t78*t81/taub**3-2.0d
     1           +0*rhob*t184*t35*t78)*wght+Mmat2(iq,D2_TB_TB)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = 1/rhob**1.6666666666666669d+0
              t2 = 2.4d-51*t1+1.0d+0
              t3 = 1/t2
              t4 = 5.336110319999999d-51*t1*t3-2.5960897d+0
              t5 = 2.4d-51*t1*t3*t4+1.0d+0
              t6 = 1/rhob**6.666666666666666d-1
              t7 = rhob**5.0d-1
              t8 = 1/t7
              t9 = 1/rhob**3.333333333333333d-1
              t10 = 1/rhob**1.6666666666666666d-1
              t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.4
     1           058712912881916d-1*t6+1.1120374863094686d+1*t10
              t12 = 3.216395899738507d+1/t11+1.0d+0
              t13 = log(t12)
              t14 = 1.274696188700087d-1*t9+1.0d+0
              t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.8
     1           970043257475583d-1*t6+5.982550435771079d+0*t10
              t16 = 1.6081979498692536d+1/t15+1.0d+0
              t17 = log(t16)
              t18 = 1.3256889990520176d-1*t9+1.0d+0
              t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2
     1           *t13*t14
              t20 = 1/rhoa**2.6666666666666666d+0
              t21 = gammaaa*t20+4.0d-50*t1
              t22 = 3.1d-3*t21+1.0d+0
              t23 = 1/t22
              t24 = 5.9515308d+0-3.459689187d-2*t21*t23
              t25 = 3.1d-3*t21*t23*t24+1.0d+0
              t26 = 1/rhoa**6.666666666666666d-1
              t27 = rhoa**5.0d-1
              t28 = 1/t27
              t29 = 1/rhoa**3.333333333333333d-1
              t30 = 1/rhoa**1.6666666666666666d-1
              t31 = 1.1120374863094686d+1*t30+3.8447462374472113d+0*t29+
     1           1.644733775567609d+0*t28+2.4058712912881916d-1*t26
              t32 = 3.216395899738507d+1/t31+1.0d+0
              t33 = log(t32)
              t34 = 1.274696188700087d-1*t29+1.0d+0
              t35 = 5.982550435771079d+0*t30+2.2255694211506874d+0*t29+8
     1           .004286349993635d-1*t28+1.8970043257475583d-1*t26
              t36 = 1.6081979498692536d+1/t35+1.0d+0
              t37 = log(t36)
              t38 = 1.3256889990520176d-1*t29+1.0d+0
              t39 = -6.903522198342671d-18*t37*t38-3.1090699999999993d-2
     1           *t33*t34
              t40 = rhob+rhoa
              t41 = 1/t40**3.333333333333333d-1
              t42 = 1.3256889990520176d-1*t41+1.0d+0
              t43 = rhoa-rhob
              t44 = t43**4
              t45 = 1/t40**4
              t46 = 1/t40
              t47 = 1.0d+0-t43*t46
              t48 = t43*t46+1.0d+0
              t49 = t48**1.3333333333333333d+0+t47**1.3333333333333333d+
     1           0-2.0d+0
              t50 = -1.923661050931536d+0*t44*t45*t49
              t51 = t50+1.0d+0
              t52 = 1/t40**6.666666666666666d-1
              t53 = t40**5.0d-1
              t54 = 1/t53
              t55 = 1/t40**1.6666666666666666d-1
              t56 = 5.982550435771079d+0*t55+8.004286349993635d-1*t54+1.
     1           8970043257475583d-1*t52+2.2255694211506874d+0*t41
              t57 = 1.6081979498692536d+1/t56+1.0d+0
              t58 = log(t57)
              t59 = -6.21814d-2*t42*t51*t58
              t60 = 6.901399211255825d-2*t41+1.0d+0
              t61 = t50+1.923661050931536d+0*t49
              t62 = 8.157414703487641d+0*t55+4.3009724712766434d-1*t54+1
     1           .9115125951273373d-1*t52+2.247591863577616d+0*t41
              t63 = 2.9608813203268075d+1/t62+1.0d+0
              t64 = log(t63)
              t65 = 1.9751631321680768d-2*t60*t61*t64
              t66 = 1.274696188700087d-1*t41+1.0d+0
              t67 = 1.1120374863094686d+1*t55+1.644733775567609d+0*t54+2
     1           .4058712912881916d-1*t52+3.8447462374472113d+0*t41
              t68 = 3.216395899738507d+1/t67+1.0d+0
              t69 = log(t68)
              t70 = -5.980796863619711d-2*t44*t45*t49*t66*t69
              t71 = t40*(t70+t65+t59)-rhoa*t39-rhob*t19
              t72 = 6.0d-2*gammaaa*t20+1.0d+0
              t73 = 1/t72
              t74 = 1.3340275799999998d-1*gammaaa*t20*t73-2.5960897d+0
              t75 = 6.0d-2*gammaaa*t20*t73*t74+1.0d+0
              t76 = 1/taua
              t77 = 1/rhoa
              t78 = 2.0d+0*taua-2.5d-1*gammaaa*t77
              t79 = 1/t36
              t80 = 1/rhoa**1.6666666666666669d+0
              t81 = 1/t27**3
              t82 = 1/rhoa**1.3333333333333333d+0
              t83 = 1/rhoa**1.1666666666666667d+0
              t84 = -9.970917392951799d-1*t83-7.418564737168958d-1*t82-4
     1           .002143174996817d-1*t81-1.264669550498372d-1*t80
              t85 = 1/t35**2
              t86 = 1/t32
              t87 = -1.8533958105157808d+0*t83-1.2815820791490704d+0*t82
     1           -8.223668877838045d-1*t81-1.6039141941921276d-1*t80
              t88 = 1/t31**2
              t89 = 1.0d+0*t34*t86*t87*t88+1.1102230246251565d-16*t38*t7
     1           9*t84*t85+3.0506411443514264d-19*t37*t82+1.321039893133
     2           9265d-3*t33*t82
              t90 = 1/t40**1.6666666666666669d+0
              t91 = 1/t53**3
              t92 = 1/t40**1.3333333333333333d+0
              t93 = 1/t40**1.1666666666666667d+0
              t94 = -9.970917392951799d-1*t93-7.418564737168958d-1*t92-4
     1           .002143174996817d-1*t91-1.264669550498372d-1*t90
              t95 = 1/t56**2
              t96 = 1/t57
              t97 = 1.0d+0*t42*t51*t94*t95*t96
              t98 = -1.3595691172479402d+0*t93-7.491972878592053d-1*t92-
     1           2.1504862356383217d-1*t91-1.2743417300848914d-1*t90
              t99 = 1/t62**2
              t100 = 1/t63
              t101 = -5.848223622634647d-1*t100*t60*t61*t98*t99
              t102 = -1.8533958105157808d+0*t93-1.2815820791490704d+0*t9
     1           2-8.223668877838045d-1*t91-1.6039141941921276d-1*t90
              t103 = 1/t67**2
              t104 = 1/t68
              t105 = 1.923661050931536d+0*t102*t103*t104*t44*t45*t49*t66
              t106 = 1/t40**2
              t107 = t106*t43
              t108 = -t46
              t109 = t108+t107
              t110 = t47**3.333333333333333d-1
              t111 = -t106*t43
              t112 = t46+t111
              t113 = t48**3.333333333333333d-1
              t114 = 1.3333333333333333d+0*t112*t113+1.3333333333333333d
     1           +0*t109*t110
              t115 = -1.923661050931536d+0*t114*t44*t45
              t116 = 1/t40**5
              t117 = 7.694644203726144d+0*t116*t44*t49
              t118 = t43**3
              t119 = -7.694644203726144d+0*t118*t45*t49
              t120 = t119+t117+t115
              t121 = -6.21814d-2*t120*t42*t58
              t122 = 2.747773264188437d-3*t51*t58*t92
              t123 = t119+t117+t115+1.923661050931536d+0*t114
              t124 = 1.9751631321680768d-2*t123*t60*t64
              t125 = -4.5437964274821163d-4*t61*t64*t92
              t126 = -5.980796863619711d-2*t114*t44*t45*t66*t69
              t127 = 1/t40**5.333333333333333d+0
              t128 = 2.541232989148493d-3*t127*t44*t49*t69
              t129 = 2.3923187454478842d-1*t116*t44*t49*t66*t69
              t130 = t40*(t97-2.3923187454478842d-1*t118*t45*t49*t66*t69
     1           +t129+t128+t126+t125+t124+t122+t121+t105+t101)-rhoa*t89
     2           +t70+t65+t59+6.903522198342671d-18*t37*t38+3.1090699999
     3           999993d-2*t33*t34
              t131 = 1/rhoa**3.6666666666666664d+0
              t132 = 1/t22**2
              t133 = 9.225837832d-2*gammaaa*t131*t23-2.86000972792d-4*ga
     1           mmaaa*t131*t132*t21
              t134 = -8.266666666666665d-3*gammaaa*t131*t23*t24+2.562666
     1           666666666d-5*gammaaa*t131*t132*t21*t24+3.1d-3*t133*t21*
     2           t23
              t135 = gammaaa**2
              t136 = 1/t72**2
              t137 = 1/rhoa**6.333333333333333d+0
              t138 = 2.1344441279999993d-2*t135*t136*t137-3.557406879999
     1           999d-1*gammaaa*t131*t73
              t139 = -1.5999999999999998d-1*gammaaa*t131*t73*t74+9.59999
     1           9999999997d-3*t135*t136*t137*t74+6.0d-2*gammaaa*t138*t2
     2           0*t73
              t140 = 1/t16
              t141 = 1/t7**3
              t142 = 1/rhob**1.3333333333333333d+0
              t143 = 1/rhob**1.1666666666666667d+0
              t144 = -9.970917392951799d-1*t143-7.418564737168958d-1*t14
     1           2-4.002143174996817d-1*t141-1.264669550498372d-1*t1
              t145 = 1/t15**2
              t146 = 1/t12
              t147 = -1.8533958105157808d+0*t143-1.2815820791490704d+0*t
     1           142-8.223668877838045d-1*t141-1.6039141941921276d-1*t1
              t148 = 1/t11**2
              t149 = 1.1102230246251565d-16*t140*t144*t145*t18+3.0506411
     1           443514264d-19*t142*t17+1.0d+0*t14*t146*t147*t148+1.3210
     2           398931339265d-3*t13*t142
              t150 = 1/t2**2
              t151 = 1/rhob**4.333333333333333d+0
              t152 = 1/rhob**2.6666666666666666d+0
              t153 = 2.134444128d-101*t150*t151-8.8935172d-51*t152*t3
              t154 = -4.0d-51*t152*t3*t4+9.6d-102*t150*t151*t4+2.4d-51*t
     1           1*t153*t3
              t155 = t46+t107
              t156 = t111+t108
              t157 = 1.3333333333333333d+0*t113*t156+1.3333333333333333d
     1           +0*t110*t155
              t158 = -1.923661050931536d+0*t157*t44*t45
              t159 = 7.694644203726144d+0*t118*t45*t49
              t160 = t159+t158+t117
              t161 = -6.21814d-2*t160*t42*t58
              t162 = t159+t158+1.923661050931536d+0*t157+t117
              t163 = 1.9751631321680768d-2*t162*t60*t64
              t164 = -5.980796863619711d-2*t157*t44*t45*t66*t69
              t165 = t40*(t97+2.3923187454478842d-1*t118*t45*t49*t66*t69
     1           +t164+t163+t161+t129+t128+t125+t122+t105+t101)+t70+t65+
     2           t59+6.903522198342671d-18*t17*t18-rhob*t149+3.109069999
     3           9999993d-2*t13*t14
              t166 = 2.306459458d-51*t152*t23-7.1500243198d-54*t132*t152
     1           *t21
              t167 = -2.0666666666666667d-52*t152*t23*t24+6.406666666666
     1           666d-55*t132*t152*t21*t24+3.1d-3*t166*t21*t23
              t168 = 1.07250364797d-4*t132*t20*t21-3.459689187d-2*t20*t2
     1           3
              t169 = 3.1d-3*t20*t23*t24-9.61d-6*t132*t20*t21*t24+3.1d-3*
     1           t168*t21*t23
              t170 = 1/rhoa**5.333333333333333d+0
              t171 = 1.3340275799999998d-1*t20*t73-8.004165479999998d-3*
     1           gammaaa*t136*t170
              t172 = 6.0d-2*t20*t73*t74-3.6d-3*gammaaa*t136*t170*t74+6.0
     1           d-2*gammaaa*t171*t20*t73
              t173 = 1/taua**2
              t174 = t84**2
              t175 = 1/t27**5
              t176 = 1/rhoa**2.3333333333333334d+0
              t177 = 1/rhoa**2.1666666666666665d+0
              t178 = t87**2
              t179 = -8.497974591333913d-2*t82*t86*t87*t88+1.0d+0*(2.673
     1           190323653546d-1*t20+2.1622951122684114d+0*t177+1.708776
     2           1055320938d+0*t176+1.2335503316757068d+0*t175)*t34*t86*
     3           t88-2.0d+0*t178*t34*t86/t31**3-9.812069668265515d-18*t7
     4           9*t82*t84*t85+1.1102230246251565d-16*(2.107782584163953
     5           6d-1*t20+1.1632736958443765d+0*t177+9.89141964955861d-1
     6           *t176+6.003214762495226d-1*t175)*t38*t79*t85-2.22044604
     7           9250313d-16*t174*t38*t79/t35**3+1.7854583920998188d-15*
     8           t174*t38/(t35**4*t36**2)-4.0675215258019015d-19*t176*t3
     9           7+3.216395899738507d+1*t178*t34/(t31**4*t32**2)-1.76138
     :           65241785684d-3*t176*t33
              t180 = 2.0d+0*t42*t51*t94*t95*t96
              t181 = -1.1696447245269295d+0*t100*t60*t61*t98*t99
              t182 = 3.847322101863072d+0*t102*t103*t104*t44*t45*t49*t66
              t183 = 5.495546528376875d-3*t51*t58*t92
              t184 = -9.087592854964233d-4*t61*t64*t92
              t185 = 5.082465978296986d-3*t127*t44*t49*t69
              t186 = 4.7846374908957684d-1*t116*t44*t49*t66*t69
              t187 = t94**2
              t188 = 1.6081979498692536d+1*t187*t42*t51/(t56**4*t57**2)
              t189 = -2.0d+0*t187*t42*t51*t96/t56**3
              t190 = -8.837926660346784d-2*t51*t92*t94*t95*t96
              t191 = 1/t40**2.6666666666666666d+0
              t192 = 1/t53**5
              t193 = 1/t40**2.3333333333333334d+0
              t194 = 1/t40**2.1666666666666665d+0
              t195 = 1.0d+0*(1.1632736958443765d+0*t194+9.89141964955861
     1           d-1*t193+6.003214762495226d-1*t192+2.1077825841639536d-
     2           1*t191)*t42*t51*t95*t96
              t196 = t98**2
              t197 = -1.73158960813529d+1*t196*t60*t61/(t62**4*t63**2)
              t198 = 1.1696447245269295d+0*t100*t196*t60*t61/t62**3
              t199 = 2.690728393099896d-2*t100*t61*t92*t98*t99
              t200 = -5.848223622634647d-1*t100*(1.5861639701225969d+0*t
     1           194+9.98929717145607d-1*t193+3.2257293534574827d-1*t192
     2           +2.1239028834748191d-1*t191)*t60*t61*t99
              t201 = t102**2
              t202 = 6.187255516702861d+1*t201*t44*t45*t49*t66/(t67**4*t
     1           68**2)
              t203 = -3.847322101863072d+0*t104*t201*t44*t45*t49*t66/t67
     1           **3
              t204 = -1.6347222733154887d-1*t102*t103*t104*t127*t44*t49
              t205 = 1.923661050931536d+0*t103*t104*(2.1622951122684114d
     1           +0*t194+1.7087761055320938d+0*t193+1.2335503316757068d+
     2           0*t192+2.673190323653546d-1*t191)*t44*t45*t49*t66
              t206 = -1.538928840745229d+1*t102*t103*t104*t116*t44*t49*t
     1           66
              t207 = 1/t47**6.666666666666666d-1
              t208 = 1/t40**3
              t209 = -2*t208*t43
              t210 = 2*t106
              t211 = 1/t48**6.666666666666666d-1
              t212 = 2*t208*t43
              t213 = -2*t106
              t214 = 1.3333333333333333d+0*t113*(t213+t212)+4.4444444444
     1           44444d-1*t112**2*t211+1.3333333333333333d+0*t110*(t210+
     2           t209)+4.444444444444444d-1*t109**2*t207
              t215 = -1.923661050931536d+0*t214*t44*t45
              t216 = 1.5389288407452287d+1*t114*t116*t44
              t217 = -1.5389288407452287d+1*t114*t118*t45
              t218 = 1/t40**6
              t219 = -3.8473221018630716d+1*t218*t44*t49
              t220 = 6.155715362980915d+1*t116*t118*t49
              t221 = t43**2
              t222 = -2.3083932611178434d+1*t221*t45*t49
              t223 = -3.663697685584583d-3*t193*t51*t58
              t224 = 6.058395236642822d-4*t193*t61*t64
              t225 = -2.3718174565385935d-2*t44*t49*t69/t40**6.333333333
     1           333333d+0
              t226 = -1.1961593727239421d+0*t218*t44*t49*t66*t69
              t227 = -7.176956236343652d-1*t221*t45*t49*t66*t69
              t228 = 1/rhoa**7.333333333333333d+0
              t229 = 1/rhoa**4.666666666666667d+0
              t230 = 1/t22**3
              t231 = 1/rhoa**2
              t232 = gammaaa**3
              t233 = 1/t72**3
              t234 = 1/rhoa**10
              t235 = 2.6666666666666666d+0*t113*t208*t43-2.6666666666666
     1           666d+0*t110*t208*t43+4.444444444444444d-1*t112*t156*t21
     2           1+4.444444444444444d-1*t109*t155*t207
              t236 = -1.923661050931536d+0*t235*t44*t45
              t237 = 7.694644203726144d+0*t116*t157*t44
              t238 = -7.694644203726144d+0*t118*t157*t45
              t239 = 7.694644203726144d+0*t114*t116*t44
              t240 = 7.694644203726144d+0*t114*t118*t45
              t241 = 2.3083932611178434d+1*t221*t45*t49
              t242 = t144**2
              t243 = 1/t7**5
              t244 = 1/rhob**2.3333333333333334d+0
              t245 = 1/rhob**2.1666666666666665d+0
              t246 = t147**2
              t247 = -2.0d+0*t14*t146*t246/t11**3+3.216395899738507d+1*t
     1           14*t246/(t11**4*t12**2)+1.0d+0*t14*t146*t148*(2.1622951
     2           122684114d+0*t245+1.7087761055320938d+0*t244+1.23355033
     3           16757068d+0*t243+2.673190323653546d-1*t152)+1.110223024
     4           6251565d-16*t140*t145*t18*(1.1632736958443765d+0*t245+9
     5           .89141964955861d-1*t244+6.003214762495226d-1*t243+2.107
     6           7825841639536d-1*t152)-4.0675215258019015d-19*t17*t244-
     7           1.7613865241785684d-3*t13*t244+1.7854583920998188d-15*t
     8           18*t242/(t15**4*t16**2)-2.220446049250313d-16*t140*t18*
     9           t242/t15**3-8.497974591333913d-2*t142*t146*t147*t148-9.
     :           812069668265515d-18*t140*t142*t144*t145
              t248 = 1/t2**3
              t249 = 1/rhob**7
              t250 = 1/rhob**5.333333333333333d+0
              t251 = 1/rhob**3.6666666666666664d+0
              t252 = 1.3333333333333333d+0*t110*(t213+t209)+1.3333333333
     1           333333d+0*t113*(t212+t210)+4.444444444444444d-1*t156**2
     2           *t211+4.444444444444444d-1*t155**2*t207
              t253 = -1.923661050931536d+0*t252*t44*t45
              t254 = 1.5389288407452287d+1*t116*t157*t44
              t255 = 1.5389288407452287d+1*t118*t157*t45
              t256 = -6.155715362980915d+1*t116*t118*t49
              t257 = 1.25d-1*t39*t75
              t258 = 1/rhoa**9
              t259 = 1/rhoa**8
              fnc(iq) = (5.0d-1*rhoa*t39*t75*t76*t78+1.0d+0*t25*t71+5.0d
     1           -1*rhob*t19*t5)*wght+fnc(iq)
              Amat(iq,D1_RA) = (t76*(5.0d-1*rhoa*t75*t78*t89+5.0d-1*t39*
     1           t75*t78+5.0d-1*rhoa*t139*t39*t78)+1.25d-1*gammaaa*t39*t
     2           75*t76*t77+1.0d+0*t134*t71+1.0d+0*t130*t25)*wght+Amat(i
     3           q,D1_RA)
              Amat(iq,D1_RB) = (1.0d+0*t167*t71+5.0d-1*t19*t5+5.0d-1*rho
     1           b*t149*t5+1.0d+0*t165*t25+5.0d-1*rhob*t154*t19)*wght+Am
     2           at(iq,D1_RB)
              Cmat(iq,D1_GAA) = (t76*(5.0d-1*rhoa*t172*t39*t78-1.25d-1*t
     1           39*t75)+1.0d+0*t169*t71)*wght+Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = (1.0d+0*rhoa*t39*t75*t76-5.0d-1*rhoa*t173
     1           *t39*t75*t78)*wght+Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (1.0d+0*t25*(t40*(-1.1696447245269295
     1           d+0*t100*t123*t60*t98*t99+2.0d+0*t120*t42*t94*t95*t96-9
     2           .087592854964233d-4*t123*t64*t92+5.495546528376875d-3*t
     3           120*t58*t92+1.9138549963583074d+0*t116*t118*t49*t66*t69
     4           -5.980796863619711d-2*t214*t44*t45*t66*t69-4.7846374908
     5           957684d-1*t114*t118*t45*t66*t69+4.7846374908957684d-1*t
     6           114*t116*t44*t66*t69+2.0329863913187946d-2*t118*t127*t4
     7           9*t69+5.082465978296986d-3*t114*t127*t44*t69+1.53892884
     8           0745229d+1*t102*t103*t104*t118*t45*t49*t66+3.8473221018
     9           63072d+0*t102*t103*t104*t114*t44*t45*t66+1.975163132168
     :           0768d-2*(t222+t220+t219+t217+t216+t215+1.92366105093153
     ;           6d+0*t214)*t60*t64-6.21814d-2*(t222+t220+t219+t217+t216
     <           +t215)*t42*t58+t227+t226+t225+t224+t223+t206+t205+t204+
     =           t203+t202+t200+t199+t198+t197+t195+t190+t189+t188)-2.0d
     >           +0*t34*t86*t87*t88-2.220446049250313d-16*t38*t79*t84*t8
     ?           5-6.101282288702853d-19*t37*t82-2.642079786267853d-3*t3
     @           3*t82-4.7846374908957684d-1*t118*t45*t49*t66*t69-1.1961
     1           593727239421d-1*t114*t44*t45*t66*t69+3.9503262643361536
     2           d-2*t123*t60*t64-1.243628d-1*t120*t42*t58+t186+t185+t18
     3           4+t183+t182+t181+t180-rhoa*t179)+t76*(1.0d+0*t75*t78*t8
     4           9+1.0d+0*rhoa*t139*t78*t89+1.25d-1*gammaaa*t75*t77*t89+
     5           5.0d-1*rhoa*t179*t75*t78+5.0d-1*rhoa*t39*(5.86666666666
     6           6666d-1*gammaaa*t229*t73*t74+3.0719999999999986d-3*t232
     7           *t233*t234*t74-8.639999999999998d-2*t135*t136*t228*t74+
     8           6.0d-2*gammaaa*t20*t73*(1.3043825226666664d+0*gammaaa*t
     9           229*t73+6.830221209599997d-3*t232*t233*t234-1.920999715
     :           1999994d-1*t135*t136*t228)-3.1999999999999995d-1*gammaa
     ;           a*t131*t138*t73+1.9199999999999995d-2*t135*t136*t137*t1
     <           38)*t78+1.0d+0*t139*t39*t78+1.25d-1*gammaaa*t139*t39*t7
     =           7+1.25d-1*gammaaa*t231*t39*t75)+t76*t77*(1.25d-1*gammaa
     >           a*t75*t89+1.25d-1*gammaaa*t139*t39)-1.25d-1*gammaaa*t23
     ?           1*t39*t75*t76+1.0d+0*(4.2369422222222203d-7*t135*t21*t2
     @           28*t230*t24+3.0311111111111105d-2*gammaaa*t229*t23*t24-
     1           9.396444444444442d-5*gammaaa*t132*t21*t229*t24-1.366755
     2           555555555d-4*t132*t135*t228*t24+3.1d-3*t21*t23*(-4.7285
     3           49416827732d-6*t135*t21*t228*t230-3.3828072050666663d-1
     4           *gammaaa*t229*t23+1.0486702335706666d-3*gammaaa*t132*t2
     5           1*t229+1.525338521557333d-3*t132*t135*t228)-1.653333333
     6           333333d-2*gammaaa*t131*t133*t23+5.125333333333332d-5*ga
     7           mmaaa*t131*t132*t133*t21)*t71+2.0d+0*t130*t134)*wght+Am
     8           at2(iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = (1.0d+0*t25*(t40*(-5.848223622634647d
     1           -1*t100*t162*t60*t98*t99-5.848223622634647d-1*t100*t123
     2           *t60*t98*t99+1.0d+0*t160*t42*t94*t95*t96+1.0d+0*t120*t4
     3           2*t94*t95*t96-4.5437964274821163d-4*t162*t64*t92-4.5437
     4           964274821163d-4*t123*t64*t92+2.747773264188437d-3*t160*
     5           t58*t92+2.747773264188437d-3*t120*t58*t92+7.17695623634
     6           3652d-1*t221*t45*t49*t66*t69-5.980796863619711d-2*t235*
     7           t44*t45*t66*t69-2.3923187454478842d-1*t118*t157*t45*t66
     8           *t69+2.3923187454478842d-1*t114*t118*t45*t66*t69+2.3923
     9           187454478842d-1*t116*t157*t44*t66*t69+2.392318745447884
     :           2d-1*t114*t116*t44*t66*t69+2.541232989148493d-3*t127*t1
     ;           57*t44*t69+2.541232989148493d-3*t114*t127*t44*t69+1.923
     <           661050931536d+0*t102*t103*t104*t157*t44*t45*t66+1.92366
     =           1050931536d+0*t102*t103*t104*t114*t44*t45*t66+1.9751631
     >           321680768d-2*(t241+t240+t239+t238+t237+t236+1.923661050
     ?           931536d+0*t235+t219)*t60*t64-6.21814d-2*(t241+t240+t239
     @           +t238+t237+t236+t219)*t42*t58+t226+t225+t224+t223+t206+
     1           t205+t204+t203+t202+t200+t199+t198+t197+t195+t190+t189+
     2           t188)+t186+t185+t184+t183+t182+t181+t180+t164+t163+t161
     3           +t126+t124+t121)+1.0d+0*(1.0592355555555552d-56*gammaaa
     4           *t131*t152*t21*t230*t24-3.416888888888888d-54*gammaaa*t
     5           131*t132*t152*t24+3.1d-3*t21*t23*(3.813346303893333d-53
     6           *gammaaa*t131*t132*t152-1.1821373542069331d-55*gammaaa*
     7           t131*t152*t21*t230)-8.266666666666665d-3*gammaaa*t131*t
     8           166*t23-2.0666666666666667d-52*t133*t152*t23+2.56266666
     9           6666666d-5*gammaaa*t131*t132*t166*t21+6.406666666666666
     :           d-55*t132*t133*t152*t21)*t71+1.0d+0*t130*t167+1.0d+0*t1
     ;           34*t165)*wght+Amat2(iq,D2_RA_RB)
              Amat2(iq,D2_RB_RB) = (1.0d+0*t25*(t40*(-1.1696447245269295
     1           d+0*t100*t162*t60*t98*t99+2.0d+0*t160*t42*t94*t95*t96-9
     2           .087592854964233d-4*t162*t64*t92+5.495546528376875d-3*t
     3           160*t58*t92-1.9138549963583074d+0*t116*t118*t49*t66*t69
     4           -5.980796863619711d-2*t252*t44*t45*t66*t69+4.7846374908
     5           957684d-1*t118*t157*t45*t66*t69+4.7846374908957684d-1*t
     6           116*t157*t44*t66*t69-2.0329863913187946d-2*t118*t127*t4
     7           9*t69+5.082465978296986d-3*t127*t157*t44*t69-1.53892884
     8           0745229d+1*t102*t103*t104*t118*t45*t49*t66+3.8473221018
     9           63072d+0*t102*t103*t104*t157*t44*t45*t66+1.975163132168
     :           0768d-2*(t256+t255+t254+t253+1.923661050931536d+0*t252+
     ;           t222+t219)*t60*t64-6.21814d-2*(t256+t255+t254+t253+t222
     <           +t219)*t42*t58+t227+t226+t225+t224+t223+t206+t205+t204+
     =           t203+t202+t200+t199+t198+t197+t195+t190+t189+t188)+4.78
     >           46374908957684d-1*t118*t45*t49*t66*t69-1.19615937272394
     ?           21d-1*t157*t44*t45*t66*t69+3.9503262643361536d-2*t162*t
     @           60*t64-1.243628d-1*t160*t42*t58-rhob*t247+t186+t185+t18
     1           4+t183+t182+t181+t180-2.220446049250313d-16*t140*t144*t
     2           145*t18-6.101282288702853d-19*t142*t17-2.0d+0*t14*t146*
     3           t147*t148-2.642079786267853d-3*t13*t142)+1.0d+0*(3.1d-3
     4           *t21*t23*(-6.150558554666666d-51*t23*t251+1.90667315194
     5           66665d-53*t132*t21*t251-2.9553433855173333d-105*t21*t23
     6           0*t250+9.533365759733332d-103*t132*t250)+5.511111111111
     7           11d-52*t23*t24*t251-1.708444444444444d-54*t132*t21*t24*
     8           t251+2.6480888888888887d-106*t21*t230*t24*t250-8.542222
     9           222222222d-104*t132*t24*t250-4.1333333333333333d-52*t15
     :           2*t166*t23+1.2813333333333332d-54*t132*t152*t166*t21)*t
     ;           71+5.0d-1*rhob*t247*t5+1.0d+0*t149*t5+5.0d-1*rhob*t19*(
     <           1.0666666666666666d-50*t251*t3*t4-5.76d-101*t150*t250*t
     =           4+7.68d-152*t248*t249*t4+2.4d-51*t1*t3*(2.3716045866666
     >           666d-50*t251*t3-1.2806664767999998d-100*t150*t250+1.707
     ?           5553024d-151*t248*t249)-8.0d-51*t152*t153*t3+1.92d-101*
     @           t150*t151*t153)+1.0d+0*t154*t19+2.0d+0*t165*t167+1.0d+0
     1           *rhob*t149*t154)*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RA_GAA) = (t76*(5.0d-1*rhoa*t172*t78*t89-1.25d
     1           -1*t75*t89+5.0d-1*rhoa*t39*(-1.5999999999999998d-1*t131
     2           *t73*t74-1.1519999999999996d-3*t135*t233*t258*t74+2.879
     3           999999999999d-2*gammaaa*t136*t137*t74+6.0d-2*gammaaa*t2
     4           0*t73*(-3.557406879999999d-1*t131*t73-2.561332953599999
     5           d-3*t135*t233*t258+6.403332383999999d-2*gammaaa*t136*t1
     6           37)+6.0d-2*t138*t20*t73-1.5999999999999998d-1*gammaaa*t
     7           131*t171*t73+9.599999999999997d-3*t135*t136*t137*t171-3
     8           .6d-3*gammaaa*t136*t138*t170)*t78+5.0d-1*t172*t39*t78-1
     9           .25d-1*t39*t75*t77-1.25d-1*t139*t39)+(1.25d-1*gammaaa*t
     :           172*t39+t257)*t76*t77+1.0d+0*(-1.5888533333333327d-7*ga
     ;           mmaaa*t137*t21*t230*t24-8.266666666666665d-3*t131*t23*t
     <           24+2.562666666666666d-5*t131*t132*t21*t24+5.12533333333
     =           3332d-5*gammaaa*t132*t137*t24+3.1d-3*t21*t23*(1.7732060
     >           313103998d-6*gammaaa*t137*t21*t230+9.225837832d-2*t131*
     ?           t23-2.86000972792d-4*t131*t132*t21-5.72001945584d-4*gam
     @           maaa*t132*t137)+3.1d-3*t133*t20*t23-8.266666666666665d-
     1           3*gammaaa*t131*t168*t23-9.61d-6*t132*t133*t20*t21+2.562
     2           666666666666d-5*gammaaa*t131*t132*t168*t21)*t71+1.0d+0*
     3           t130*t169)*wght+Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_RB_GAA) = (1.0d+0*(-3.972133333333333d-57*t152
     1           *t20*t21*t230*t24+1.2813333333333332d-54*t132*t152*t20*
     2           t24+3.1d-3*t21*t23*(4.433015078276d-56*t152*t20*t21*t23
     3           0-1.4300048639599997d-53*t132*t152*t20)+3.1d-3*t166*t20
     4           *t23-2.0666666666666667d-52*t152*t168*t23-9.61d-6*t132*
     5           t166*t20*t21+6.406666666666666d-55*t132*t152*t168*t21)*
     6           t71+1.0d+0*t165*t169)*wght+Cmat2(iq,D2_RB_GAA)
              Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
              Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GAA_GAA) = (t76*(5.0d-1*rhoa*t39*(4.32d-4*gamm
     1           aaa*t233*t259*t74-7.2d-3*t136*t170*t74+6.0d-2*gammaaa*t
     2           20*(9.604998575999998d-4*gammaaa*t233*t259-1.6008330959
     3           999997d-2*t136*t170)*t73+1.2d-1*t171*t20*t73-7.2d-3*gam
     4           maaa*t136*t170*t171)*t78-2.5d-1*t172*t39)+1.0d+0*(5.958
     5           2d-8*t170*t21*t230*t24-1.9219999999999998d-5*t132*t170*
     6           t24+3.1d-3*t21*t23*(2.14500729594d-4*t132*t170-6.649522
     7           617413999d-7*t170*t21*t230)+6.2d-3*t168*t20*t23-1.92199
     8           99999999998d-5*t132*t168*t20*t21)*t71)*wght+Cmat2(iq,D2
     9           _GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
              Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RA_TA) = (t173*(-5.0d-1*rhoa*t75*t78*t89-5.0d-
     1           1*t39*t75*t78-5.0d-1*rhoa*t139*t39*t78)+t76*(1.0d+0*rho
     2           a*t75*t89+1.0d+0*t39*t75+1.0d+0*rhoa*t139*t39)-1.25d-1*
     3           gammaaa*t173*t39*t75*t77)*wght+Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GAA_TA) = (t173*(t257-5.0d-1*rhoa*t172*t39*t78
     1           )+1.0d+0*rhoa*t172*t39*t76)*wght+Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = (1.0d+0*rhoa*t39*t75*t78/taua**3-2.0d
     1           +0*rhoa*t173*t39*t75)*wght+Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 2.4d-51*t1+1.0d+0
              t3 = 1/t2
              t4 = 5.336110319999999d-51*t1*t3-2.5960897d+0
              t5 = 2.4d-51*t1*t3*t4+1.0d+0
              t6 = 1/rhoa**6.666666666666666d-1
              t7 = rhoa**5.0d-1
              t8 = 1/t7
              t9 = 1/rhoa**3.333333333333333d-1
              t10 = 1/rhoa**1.6666666666666666d-1
              t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.4
     1           058712912881916d-1*t6+1.1120374863094686d+1*t10
              t12 = 3.216395899738507d+1/t11+1.0d+0
              t13 = log(t12)
              t14 = 1.274696188700087d-1*t9+1.0d+0
              t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.8
     1           970043257475583d-1*t6+5.982550435771079d+0*t10
              t16 = 1.6081979498692536d+1/t15+1.0d+0
              t17 = log(t16)
              t18 = 1.3256889990520176d-1*t9+1.0d+0
              t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2
     1           *t13*t14
              t20 = 1/rhob**2.6666666666666666d+0
              t21 = gammabb*t20+4.0d-50*t1
              t22 = 3.1d-3*t21+1.0d+0
              t23 = 1/t22
              t24 = 5.9515308d+0-3.459689187d-2*t21*t23
              t25 = 3.1d-3*t21*t23*t24+1.0d+0
              t26 = 1/rhob**6.666666666666666d-1
              t27 = rhob**5.0d-1
              t28 = 1/t27
              t29 = 1/rhob**3.333333333333333d-1
              t30 = 1/rhob**1.6666666666666666d-1
              t31 = 1.1120374863094686d+1*t30+3.8447462374472113d+0*t29+
     1           1.644733775567609d+0*t28+2.4058712912881916d-1*t26
              t32 = 3.216395899738507d+1/t31+1.0d+0
              t33 = log(t32)
              t34 = 1.274696188700087d-1*t29+1.0d+0
              t35 = 5.982550435771079d+0*t30+2.2255694211506874d+0*t29+8
     1           .004286349993635d-1*t28+1.8970043257475583d-1*t26
              t36 = 1.6081979498692536d+1/t35+1.0d+0
              t37 = log(t36)
              t38 = 1.3256889990520176d-1*t29+1.0d+0
              t39 = -6.903522198342671d-18*t37*t38-3.1090699999999993d-2
     1           *t33*t34
              t40 = rhob+rhoa
              t41 = 1/t40**3.333333333333333d-1
              t42 = 1.3256889990520176d-1*t41+1.0d+0
              t43 = rhoa-rhob
              t44 = t43**4
              t45 = 1/t40**4
              t46 = 1/t40
              t47 = 1.0d+0-t43*t46
              t48 = t43*t46+1.0d+0
              t49 = t48**1.3333333333333333d+0+t47**1.3333333333333333d+
     1           0-2.0d+0
              t50 = -1.923661050931536d+0*t44*t45*t49
              t51 = t50+1.0d+0
              t52 = 1/t40**6.666666666666666d-1
              t53 = t40**5.0d-1
              t54 = 1/t53
              t55 = 1/t40**1.6666666666666666d-1
              t56 = 5.982550435771079d+0*t55+8.004286349993635d-1*t54+1.
     1           8970043257475583d-1*t52+2.2255694211506874d+0*t41
              t57 = 1.6081979498692536d+1/t56+1.0d+0
              t58 = log(t57)
              t59 = -6.21814d-2*t42*t51*t58
              t60 = 6.901399211255825d-2*t41+1.0d+0
              t61 = t50+1.923661050931536d+0*t49
              t62 = 8.157414703487641d+0*t55+4.3009724712766434d-1*t54+1
     1           .9115125951273373d-1*t52+2.247591863577616d+0*t41
              t63 = 2.9608813203268075d+1/t62+1.0d+0
              t64 = log(t63)
              t65 = 1.9751631321680768d-2*t60*t61*t64
              t66 = 1.274696188700087d-1*t41+1.0d+0
              t67 = 1.1120374863094686d+1*t55+1.644733775567609d+0*t54+2
     1           .4058712912881916d-1*t52+3.8447462374472113d+0*t41
              t68 = 3.216395899738507d+1/t67+1.0d+0
              t69 = log(t68)
              t70 = -5.980796863619711d-2*t44*t45*t49*t66*t69
              t71 = t40*(t70+t65+t59)-rhob*t39-rhoa*t19
              t72 = 6.0d-2*gammabb*t20+1.0d+0
              t73 = 1/t72
              t74 = 1.3340275799999998d-1*gammabb*t20*t73-2.5960897d+0
              t75 = 6.0d-2*gammabb*t20*t73*t74+1.0d+0
              t76 = 1/taub
              t77 = 1/rhob
              t78 = 2.0d+0*taub-2.5d-1*gammabb*t77
              t79 = 1/t16
              t80 = 1/t7**3
              t81 = 1/rhoa**1.3333333333333333d+0
              t82 = 1/rhoa**1.1666666666666667d+0
              t83 = -9.970917392951799d-1*t82-7.418564737168958d-1*t81-4
     1           .002143174996817d-1*t80-1.264669550498372d-1*t1
              t84 = 1/t15**2
              t85 = 1/t12
              t86 = -1.8533958105157808d+0*t82-1.2815820791490704d+0*t81
     1           -8.223668877838045d-1*t80-1.6039141941921276d-1*t1
              t87 = 1/t11**2
              t88 = 1.0d+0*t14*t85*t86*t87+1.1102230246251565d-16*t18*t7
     1           9*t83*t84+3.0506411443514264d-19*t17*t81+1.321039893133
     2           9265d-3*t13*t81
              t89 = 1/t2**2
              t90 = 1/rhoa**4.333333333333333d+0
              t91 = 1/rhoa**2.6666666666666666d+0
              t92 = 2.134444128d-101*t89*t90-8.8935172d-51*t3*t91
              t93 = 2.4d-51*t1*t3*t92-4.0d-51*t3*t4*t91+9.6d-102*t4*t89*
     1           t90
              t94 = 1/t40**1.6666666666666669d+0
              t95 = 1/t53**3
              t96 = 1/t40**1.3333333333333333d+0
              t97 = 1/t40**1.1666666666666667d+0
              t98 = -9.970917392951799d-1*t97-7.418564737168958d-1*t96-4
     1           .002143174996817d-1*t95-1.264669550498372d-1*t94
              t99 = 1/t56**2
              t100 = 1/t57
              t101 = 1.0d+0*t100*t42*t51*t98*t99
              t102 = -1.3595691172479402d+0*t97-7.491972878592053d-1*t96
     1           -2.1504862356383217d-1*t95-1.2743417300848914d-1*t94
              t103 = 1/t62**2
              t104 = 1/t63
              t105 = -5.848223622634647d-1*t102*t103*t104*t60*t61
              t106 = -1.8533958105157808d+0*t97-1.2815820791490704d+0*t9
     1           6-8.223668877838045d-1*t95-1.6039141941921276d-1*t94
              t107 = 1/t67**2
              t108 = 1/t68
              t109 = 1.923661050931536d+0*t106*t107*t108*t44*t45*t49*t66
              t110 = 1/t40**2
              t111 = t110*t43
              t112 = -t46
              t113 = t112+t111
              t114 = t47**3.333333333333333d-1
              t115 = -t110*t43
              t116 = t46+t115
              t117 = t48**3.333333333333333d-1
              t118 = 1.3333333333333333d+0*t116*t117+1.3333333333333333d
     1           +0*t113*t114
              t119 = -1.923661050931536d+0*t118*t44*t45
              t120 = 1/t40**5
              t121 = 7.694644203726144d+0*t120*t44*t49
              t122 = t43**3
              t123 = -7.694644203726144d+0*t122*t45*t49
              t124 = t123+t121+t119
              t125 = -6.21814d-2*t124*t42*t58
              t126 = 2.747773264188437d-3*t51*t58*t96
              t127 = t123+t121+t119+1.923661050931536d+0*t118
              t128 = 1.9751631321680768d-2*t127*t60*t64
              t129 = -4.5437964274821163d-4*t61*t64*t96
              t130 = -5.980796863619711d-2*t118*t44*t45*t66*t69
              t131 = 1/t40**5.333333333333333d+0
              t132 = 2.541232989148493d-3*t131*t44*t49*t69
              t133 = 2.3923187454478842d-1*t120*t44*t49*t66*t69
              t134 = -rhoa*t88+t70+t40*(-2.3923187454478842d-1*t122*t45*
     1           t49*t66*t69+t133+t132+t130+t129+t128+t126+t125+t109+t10
     2           5+t101)+t65+t59+6.903522198342671d-18*t17*t18+3.1090699
     3           999999993d-2*t13*t14
              t135 = 1/t22**2
              t136 = 2.306459458d-51*t23*t91-7.1500243198d-54*t135*t21*t
     1           91
              t137 = -2.0666666666666667d-52*t23*t24*t91+6.4066666666666
     1           66d-55*t135*t21*t24*t91+3.1d-3*t136*t21*t23
              t138 = 1/t36
              t139 = 1/rhob**1.6666666666666669d+0
              t140 = 1/t27**3
              t141 = 1/rhob**1.3333333333333333d+0
              t142 = 1/rhob**1.1666666666666667d+0
              t143 = -9.970917392951799d-1*t142-7.418564737168958d-1*t14
     1           1-4.002143174996817d-1*t140-1.264669550498372d-1*t139
              t144 = 1/t35**2
              t145 = 1/t32
              t146 = -1.8533958105157808d+0*t142-1.2815820791490704d+0*t
     1           141-8.223668877838045d-1*t140-1.6039141941921276d-1*t13
     2           9
              t147 = 1/t31**2
              t148 = 1.1102230246251565d-16*t138*t143*t144*t38+3.0506411
     1           443514264d-19*t141*t37+1.0d+0*t145*t146*t147*t34+1.3210
     2           398931339265d-3*t141*t33
              t149 = t46+t111
              t150 = t115+t112
              t151 = 1.3333333333333333d+0*t117*t150+1.3333333333333333d
     1           +0*t114*t149
              t152 = -1.923661050931536d+0*t151*t44*t45
              t153 = 7.694644203726144d+0*t122*t45*t49
              t154 = t153+t152+t121
              t155 = -6.21814d-2*t154*t42*t58
              t156 = t153+t152+1.923661050931536d+0*t151+t121
              t157 = 1.9751631321680768d-2*t156*t60*t64
              t158 = -5.980796863619711d-2*t151*t44*t45*t66*t69
              t159 = t70+t40*(2.3923187454478842d-1*t122*t45*t49*t66*t69
     1           +t158+t157+t155+t133+t132+t129+t126+t109+t105+t101)+t65
     2           +t59+6.903522198342671d-18*t37*t38+3.1090699999999993d-
     3           2*t33*t34-rhob*t148
              t160 = 1/rhob**3.6666666666666664d+0
              t161 = 9.225837832d-2*gammabb*t160*t23-2.86000972792d-4*ga
     1           mmabb*t135*t160*t21
              t162 = -8.266666666666665d-3*gammabb*t160*t23*t24+2.562666
     1           666666666d-5*gammabb*t135*t160*t21*t24+3.1d-3*t161*t21*
     2           t23
              t163 = gammabb**2
              t164 = 1/t72**2
              t165 = 1/rhob**6.333333333333333d+0
              t166 = 2.1344441279999993d-2*t163*t164*t165-3.557406879999
     1           999d-1*gammabb*t160*t73
              t167 = -1.5999999999999998d-1*gammabb*t160*t73*t74+9.59999
     1           9999999997d-3*t163*t164*t165*t74+6.0d-2*gammabb*t166*t2
     2           0*t73
              t168 = 1.07250364797d-4*t135*t20*t21-3.459689187d-2*t20*t2
     1           3
              t169 = 3.1d-3*t20*t23*t24-9.61d-6*t135*t20*t21*t24+3.1d-3*
     1           t168*t21*t23
              t170 = 1/rhob**5.333333333333333d+0
              t171 = 1.3340275799999998d-1*t20*t73-8.004165479999998d-3*
     1           gammabb*t164*t170
              t172 = 6.0d-2*t20*t73*t74-3.6d-3*gammabb*t164*t170*t74+6.0
     1           d-2*gammabb*t171*t20*t73
              t173 = 1/taub**2
              t174 = t83**2
              t175 = 1/t7**5
              t176 = 1/rhoa**2.3333333333333334d+0
              t177 = 1/rhoa**2.1666666666666665d+0
              t178 = t86**2
              t179 = 1.0d+0*t14*t85*t87*(2.673190323653546d-1*t91+2.1622
     1           951122684114d+0*t177+1.7087761055320938d+0*t176+1.23355
     2           03316757068d+0*t175)+1.1102230246251565d-16*t18*t79*t84
     3           *(2.1077825841639536d-1*t91+1.1632736958443765d+0*t177+
     4           9.89141964955861d-1*t176+6.003214762495226d-1*t175)-8.4
     5           97974591333913d-2*t81*t85*t86*t87-2.0d+0*t14*t178*t85/t
     6           11**3-9.812069668265515d-18*t79*t81*t83*t84-2.220446049
     7           250313d-16*t174*t18*t79/t15**3+1.7854583920998188d-15*t
     8           174*t18/(t15**4*t16**2)+3.216395899738507d+1*t14*t178/(
     9           t11**4*t12**2)-4.0675215258019015d-19*t17*t176-1.761386
     :           5241785684d-3*t13*t176
              t180 = 1/t2**3
              t181 = 1/rhoa**7
              t182 = 1/rhoa**5.333333333333333d+0
              t183 = 1/rhoa**3.6666666666666664d+0
              t184 = 2.0d+0*t100*t42*t51*t98*t99
              t185 = -1.1696447245269295d+0*t102*t103*t104*t60*t61
              t186 = 3.847322101863072d+0*t106*t107*t108*t44*t45*t49*t66
              t187 = 5.495546528376875d-3*t51*t58*t96
              t188 = -9.087592854964233d-4*t61*t64*t96
              t189 = 5.082465978296986d-3*t131*t44*t49*t69
              t190 = 4.7846374908957684d-1*t120*t44*t49*t66*t69
              t191 = t98**2
              t192 = 1.6081979498692536d+1*t191*t42*t51/(t56**4*t57**2)
              t193 = -2.0d+0*t100*t191*t42*t51/t56**3
              t194 = -8.837926660346784d-2*t100*t51*t96*t98*t99
              t195 = 1/t40**2.6666666666666666d+0
              t196 = 1/t53**5
              t197 = 1/t40**2.3333333333333334d+0
              t198 = 1/t40**2.1666666666666665d+0
              t199 = 1.0d+0*t100*(1.1632736958443765d+0*t198+9.891419649
     1           55861d-1*t197+6.003214762495226d-1*t196+2.1077825841639
     2           536d-1*t195)*t42*t51*t99
              t200 = t102**2
              t201 = -1.73158960813529d+1*t200*t60*t61/(t62**4*t63**2)
              t202 = 1.1696447245269295d+0*t104*t200*t60*t61/t62**3
              t203 = 2.690728393099896d-2*t102*t103*t104*t61*t96
              t204 = -5.848223622634647d-1*t103*t104*(1.5861639701225969
     1           d+0*t198+9.98929717145607d-1*t197+3.2257293534574827d-1
     2           *t196+2.1239028834748191d-1*t195)*t60*t61
              t205 = t106**2
              t206 = 6.187255516702861d+1*t205*t44*t45*t49*t66/(t67**4*t
     1           68**2)
              t207 = -3.847322101863072d+0*t108*t205*t44*t45*t49*t66/t67
     1           **3
              t208 = -1.6347222733154887d-1*t106*t107*t108*t131*t44*t49
              t209 = 1.923661050931536d+0*t107*t108*(2.1622951122684114d
     1           +0*t198+1.7087761055320938d+0*t197+1.2335503316757068d+
     2           0*t196+2.673190323653546d-1*t195)*t44*t45*t49*t66
              t210 = -1.538928840745229d+1*t106*t107*t108*t120*t44*t49*t
     1           66
              t211 = 1/t47**6.666666666666666d-1
              t212 = 1/t40**3
              t213 = -2*t212*t43
              t214 = 2*t110
              t215 = 1/t48**6.666666666666666d-1
              t216 = 2*t212*t43
              t217 = -2*t110
              t218 = 1.3333333333333333d+0*t117*(t217+t216)+4.4444444444
     1           44444d-1*t116**2*t215+1.3333333333333333d+0*t114*(t214+
     2           t213)+4.444444444444444d-1*t113**2*t211
              t219 = -1.923661050931536d+0*t218*t44*t45
              t220 = 1.5389288407452287d+1*t118*t120*t44
              t221 = -1.5389288407452287d+1*t118*t122*t45
              t222 = 1/t40**6
              t223 = -3.8473221018630716d+1*t222*t44*t49
              t224 = 6.155715362980915d+1*t120*t122*t49
              t225 = t43**2
              t226 = -2.3083932611178434d+1*t225*t45*t49
              t227 = -3.663697685584583d-3*t197*t51*t58
              t228 = 6.058395236642822d-4*t197*t61*t64
              t229 = -2.3718174565385935d-2*t44*t49*t69/t40**6.333333333
     1           333333d+0
              t230 = -1.1961593727239421d+0*t222*t44*t49*t66*t69
              t231 = -7.176956236343652d-1*t225*t45*t49*t66*t69
              t232 = 1/t22**3
              t233 = 2.6666666666666666d+0*t117*t212*t43-2.6666666666666
     1           666d+0*t114*t212*t43+4.444444444444444d-1*t116*t150*t21
     2           5+4.444444444444444d-1*t113*t149*t211
              t234 = -1.923661050931536d+0*t233*t44*t45
              t235 = 7.694644203726144d+0*t120*t151*t44
              t236 = -7.694644203726144d+0*t122*t151*t45
              t237 = 7.694644203726144d+0*t118*t120*t44
              t238 = 7.694644203726144d+0*t118*t122*t45
              t239 = 2.3083932611178434d+1*t225*t45*t49
              t240 = t143**2
              t241 = 1/t27**5
              t242 = 1/rhob**2.3333333333333334d+0
              t243 = 1/rhob**2.1666666666666665d+0
              t244 = t146**2
              t245 = 1.7854583920998188d-15*t240*t38/(t35**4*t36**2)-2.2
     1           20446049250313d-16*t138*t240*t38/t35**3+1.1102230246251
     2           565d-16*t138*t144*(1.1632736958443765d+0*t243+9.8914196
     3           4955861d-1*t242+6.003214762495226d-1*t241+2.10778258416
     4           39536d-1*t20)*t38-4.0675215258019015d-19*t242*t37+3.216
     5           395899738507d+1*t244*t34/(t31**4*t32**2)-2.0d+0*t145*t2
     6           44*t34/t31**3+1.0d+0*t145*t147*(2.1622951122684114d+0*t
     7           243+1.7087761055320938d+0*t242+1.2335503316757068d+0*t2
     8           41+2.673190323653546d-1*t20)*t34-1.7613865241785684d-3*
     9           t242*t33-8.497974591333913d-2*t141*t145*t146*t147-9.812
     :           069668265515d-18*t138*t141*t143*t144
              t246 = 1.3333333333333333d+0*t114*(t217+t213)+1.3333333333
     1           333333d+0*t117*(t216+t214)+4.444444444444444d-1*t150**2
     2           *t215+4.444444444444444d-1*t149**2*t211
              t247 = -1.923661050931536d+0*t246*t44*t45
              t248 = 1.5389288407452287d+1*t120*t151*t44
              t249 = 1.5389288407452287d+1*t122*t151*t45
              t250 = -6.155715362980915d+1*t120*t122*t49
              t251 = 1/rhob**7.333333333333333d+0
              t252 = 1/rhob**4.666666666666667d+0
              t253 = 1/rhob**2
              t254 = gammabb**3
              t255 = 1/t72**3
              t256 = 1/rhob**10
              t257 = 1.25d-1*t39*t75
              t258 = 1/rhob**9
              t259 = 1/rhob**8
              fnc(iq) = (5.0d-1*rhob*t39*t75*t76*t78+1.0d+0*t25*t71+5.0d
     1           -1*rhoa*t19*t5)*wght+fnc(iq)
              Amat(iq,D1_RA) = (5.0d-1*rhoa*t19*t93+5.0d-1*rhoa*t5*t88+1
     1           .0d+0*t137*t71+5.0d-1*t19*t5+1.0d+0*t134*t25)*wght+Amat
     2           (iq,D1_RA)
              Amat(iq,D1_RB) = (t76*(5.0d-1*t39*t75*t78+5.0d-1*rhob*t148
     1           *t75*t78+5.0d-1*rhob*t167*t39*t78)+1.25d-1*gammabb*t39*
     2           t75*t76*t77+1.0d+0*t162*t71+1.0d+0*t159*t25)*wght+Amat(
     3           iq,D1_RB)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = (t76*(5.0d-1*rhob*t172*t39*t78-1.25d-1*t
     1           39*t75)+1.0d+0*t169*t71)*wght+Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = (1.0d+0*rhob*t39*t75*t76-5.0d-1*rhob*t173
     1           *t39*t75*t78)*wght+Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (1.0d+0*t25*(t40*(2.0d+0*t100*t124*t4
     1           2*t98*t99-9.087592854964233d-4*t127*t64*t96+5.495546528
     2           376875d-3*t124*t58*t96+1.9138549963583074d+0*t120*t122*
     3           t49*t66*t69-5.980796863619711d-2*t218*t44*t45*t66*t69-4
     4           .7846374908957684d-1*t118*t122*t45*t66*t69+4.7846374908
     5           957684d-1*t118*t120*t44*t66*t69+2.0329863913187946d-2*t
     6           122*t131*t49*t69+5.082465978296986d-3*t118*t131*t44*t69
     7           +1.538928840745229d+1*t106*t107*t108*t122*t45*t49*t66+3
     8           .847322101863072d+0*t106*t107*t108*t118*t44*t45*t66+1.9
     9           751631321680768d-2*(t226+t224+t223+t221+t220+t219+1.923
     :           661050931536d+0*t218)*t60*t64-1.1696447245269295d+0*t10
     ;           2*t103*t104*t127*t60-6.21814d-2*(t226+t224+t223+t221+t2
     <           20+t219)*t42*t58+t231+t230+t229+t228+t227+t210+t209+t20
     =           8+t207+t206+t204+t203+t202+t201+t199+t194+t193+t192)-2.
     >           0d+0*t14*t85*t86*t87-2.220446049250313d-16*t18*t79*t83*
     ?           t84-6.101282288702853d-19*t17*t81-2.642079786267853d-3*
     @           t13*t81-4.7846374908957684d-1*t122*t45*t49*t66*t69-1.19
     1           61593727239421d-1*t118*t44*t45*t66*t69+3.95032626433615
     2           36d-2*t127*t60*t64-1.243628d-1*t124*t42*t58+t190+t189+t
     3           188+t187+t186+t185+t184-rhoa*t179)+1.0d+0*rhoa*t88*t93+
     4           1.0d+0*t19*t93+5.0d-1*rhoa*t19*(-8.0d-51*t3*t91*t92+1.9
     5           2d-101*t89*t90*t92+2.4d-51*t1*t3*(-1.2806664767999998d-
     6           100*t182*t89+2.3716045866666666d-50*t183*t3+1.707555302
     7           4d-151*t180*t181)-5.76d-101*t182*t4*t89+1.0666666666666
     8           666d-50*t183*t3*t4+7.68d-152*t180*t181*t4)+1.0d+0*t71*(
     9           -4.1333333333333333d-52*t136*t23*t91+1.2813333333333332
     :           d-54*t135*t136*t21*t91+2.6480888888888887d-106*t182*t21
     ;           *t232*t24+5.51111111111111d-52*t183*t23*t24-1.708444444
     <           444444d-54*t135*t183*t21*t24-8.542222222222222d-104*t13
     =           5*t182*t24+3.1d-3*t21*t23*(-2.9553433855173333d-105*t18
     >           2*t21*t232-6.150558554666666d-51*t183*t23+1.90667315194
     ?           66665d-53*t135*t183*t21+9.533365759733332d-103*t135*t18
     @           2))+1.0d+0*t5*t88+5.0d-1*rhoa*t179*t5+2.0d+0*t134*t137)
     1           *wght+Amat2(iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = (1.0d+0*t25*(t40*(1.0d+0*t100*t154*t4
     1           2*t98*t99+1.0d+0*t100*t124*t42*t98*t99-4.54379642748211
     2           63d-4*t156*t64*t96-4.5437964274821163d-4*t127*t64*t96+2
     3           .747773264188437d-3*t154*t58*t96+2.747773264188437d-3*t
     4           124*t58*t96+7.176956236343652d-1*t225*t45*t49*t66*t69-5
     5           .980796863619711d-2*t233*t44*t45*t66*t69-2.392318745447
     6           8842d-1*t122*t151*t45*t66*t69+2.3923187454478842d-1*t11
     7           8*t122*t45*t66*t69+2.3923187454478842d-1*t120*t151*t44*
     8           t66*t69+2.3923187454478842d-1*t118*t120*t44*t66*t69+2.5
     9           41232989148493d-3*t131*t151*t44*t69+2.541232989148493d-
     :           3*t118*t131*t44*t69+1.923661050931536d+0*t106*t107*t108
     ;           *t151*t44*t45*t66+1.923661050931536d+0*t106*t107*t108*t
     <           118*t44*t45*t66+1.9751631321680768d-2*(t239+t238+t237+t
     =           236+t235+t234+1.923661050931536d+0*t233+t223)*t60*t64-5
     >           .848223622634647d-1*t102*t103*t104*t156*t60-5.848223622
     ?           634647d-1*t102*t103*t104*t127*t60-6.21814d-2*(t239+t238
     @           +t237+t236+t235+t234+t223)*t42*t58+t230+t229+t228+t227+
     1           t210+t209+t208+t207+t206+t204+t203+t202+t201+t199+t194+
     2           t193+t192)+t190+t189+t188+t187+t186+t185+t184+t158+t157
     3           +t155+t130+t128+t125)+1.0d+0*t71*(3.1d-3*t21*t23*(3.813
     4           346303893333d-53*gammabb*t135*t160*t91-1.18213735420693
     5           31d-55*gammabb*t160*t21*t232*t91)+1.0592355555555552d-5
     6           6*gammabb*t160*t21*t232*t24*t91-3.416888888888888d-54*g
     7           ammabb*t135*t160*t24*t91-2.0666666666666667d-52*t161*t2
     8           3*t91+6.406666666666666d-55*t135*t161*t21*t91-8.2666666
     9           66666665d-3*gammabb*t136*t160*t23+2.562666666666666d-5*
     :           gammabb*t135*t136*t160*t21)+1.0d+0*t134*t162+1.0d+0*t13
     ;           7*t159)*wght+Amat2(iq,D2_RA_RB)
              Amat2(iq,D2_RB_RB) = (1.0d+0*t25*(t40*(2.0d+0*t100*t154*t4
     1           2*t98*t99-9.087592854964233d-4*t156*t64*t96+5.495546528
     2           376875d-3*t154*t58*t96-1.9138549963583074d+0*t120*t122*
     3           t49*t66*t69-5.980796863619711d-2*t246*t44*t45*t66*t69+4
     4           .7846374908957684d-1*t122*t151*t45*t66*t69+4.7846374908
     5           957684d-1*t120*t151*t44*t66*t69-2.0329863913187946d-2*t
     6           122*t131*t49*t69+5.082465978296986d-3*t131*t151*t44*t69
     7           -1.538928840745229d+1*t106*t107*t108*t122*t45*t49*t66+3
     8           .847322101863072d+0*t106*t107*t108*t151*t44*t45*t66+1.9
     9           751631321680768d-2*(t250+t249+t248+t247+1.9236610509315
     :           36d+0*t246+t226+t223)*t60*t64-1.1696447245269295d+0*t10
     ;           2*t103*t104*t156*t60-6.21814d-2*(t250+t249+t248+t247+t2
     <           26+t223)*t42*t58+t231+t230+t229+t228+t227+t210+t209+t20
     =           8+t207+t206+t204+t203+t202+t201+t199+t194+t193+t192)+4.
     >           7846374908957684d-1*t122*t45*t49*t66*t69-1.196159372723
     ?           9421d-1*t151*t44*t45*t66*t69+3.9503262643361536d-2*t156
     @           *t60*t64-1.243628d-1*t154*t42*t58-2.220446049250313d-16
     1           *t138*t143*t144*t38-6.101282288702853d-19*t141*t37-2.0d
     2           +0*t145*t146*t147*t34-2.642079786267853d-3*t141*t33-rho
     3           b*t245+t190+t189+t188+t187+t186+t185+t184)+t76*(5.0d-1*
     4           rhob*t245*t75*t78+1.0d+0*t148*t75*t78+5.0d-1*rhob*t39*(
     5           5.866666666666666d-1*gammabb*t252*t73*t74+3.07199999999
     6           99986d-3*t254*t255*t256*t74-8.639999999999998d-2*t163*t
     7           164*t251*t74+6.0d-2*gammabb*t20*t73*(1.3043825226666664
     8           d+0*gammabb*t252*t73+6.830221209599997d-3*t254*t255*t25
     9           6-1.9209997151999994d-1*t163*t164*t251)-3.1999999999999
     :           995d-1*gammabb*t160*t166*t73+1.9199999999999995d-2*t163
     ;           *t164*t165*t166)*t78+1.0d+0*t167*t39*t78+1.0d+0*rhob*t1
     <           48*t167*t78+1.25d-1*gammabb*t148*t75*t77+1.25d-1*gammab
     =           b*t167*t39*t77+1.25d-1*gammabb*t253*t39*t75)+(1.25d-1*g
     >           ammabb*t148*t75+1.25d-1*gammabb*t167*t39)*t76*t77-1.25d
     ?           -1*gammabb*t253*t39*t75*t76+1.0d+0*(3.1d-3*t21*t23*(-3.
     @           3828072050666663d-1*gammabb*t23*t252+1.0486702335706666
     1           d-3*gammabb*t135*t21*t252-4.728549416827732d-6*t163*t21
     2           *t232*t251+1.525338521557333d-3*t135*t163*t251)+3.03111
     3           11111111105d-2*gammabb*t23*t24*t252-9.396444444444442d-
     4           5*gammabb*t135*t21*t24*t252+4.2369422222222203d-7*t163*
     5           t21*t232*t24*t251-1.366755555555555d-4*t135*t163*t24*t2
     6           51-1.653333333333333d-2*gammabb*t160*t161*t23+5.1253333
     7           33333332d-5*gammabb*t135*t160*t161*t21)*t71+2.0d+0*t159
     8           *t162)*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = (1.0d+0*t71*(3.1d-3*t21*t23*(4.43301
     1           5078276d-56*t20*t21*t232*t91-1.4300048639599997d-53*t13
     2           5*t20*t91)-3.972133333333333d-57*t20*t21*t232*t24*t91+1
     3           .2813333333333332d-54*t135*t20*t24*t91-2.06666666666666
     4           67d-52*t168*t23*t91+6.406666666666666d-55*t135*t168*t21
     5           *t91+3.1d-3*t136*t20*t23-9.61d-6*t135*t136*t20*t21)+1.0
     6           d+0*t134*t169)*wght+Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_RB_GAA) = Cmat2(iq,D2_RB_GAA)
              Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
              Cmat2(iq,D2_RB_GBB) = (t76*(5.0d-1*rhob*t39*(-1.5999999999
     1           999998d-1*t160*t73*t74-1.1519999999999996d-3*t163*t255*
     2           t258*t74+2.879999999999999d-2*gammabb*t164*t165*t74+6.0
     3           d-2*gammabb*t20*t73*(-3.557406879999999d-1*t160*t73-2.5
     4           61332953599999d-3*t163*t255*t258+6.403332383999999d-2*g
     5           ammabb*t164*t165)+6.0d-2*t166*t20*t73-1.599999999999999
     6           8d-1*gammabb*t160*t171*t73+9.599999999999997d-3*t163*t1
     7           64*t165*t171-3.6d-3*gammabb*t164*t166*t170)*t78+5.0d-1*
     8           t172*t39*t78+5.0d-1*rhob*t148*t172*t78-1.25d-1*t39*t75*
     9           t77-1.25d-1*t148*t75-1.25d-1*t167*t39)+(1.25d-1*gammabb
     :           *t172*t39+t257)*t76*t77+1.0d+0*(-1.5888533333333327d-7*
     ;           gammabb*t165*t21*t232*t24-8.266666666666665d-3*t160*t23
     <           *t24+2.562666666666666d-5*t135*t160*t21*t24+5.125333333
     =           333332d-5*gammabb*t135*t165*t24+3.1d-3*t21*t23*(1.77320
     >           60313103998d-6*gammabb*t165*t21*t232+9.225837832d-2*t16
     ?           0*t23-2.86000972792d-4*t135*t160*t21-5.72001945584d-4*g
     @           ammabb*t135*t165)+3.1d-3*t161*t20*t23-8.266666666666665
     1           d-3*gammabb*t160*t168*t23-9.61d-6*t135*t161*t20*t21+2.5
     2           62666666666666d-5*gammabb*t135*t160*t168*t21)*t71+1.0d+
     3           0*t159*t169)*wght+Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
              Cmat2(iq,D2_GBB_GBB) = (t76*(5.0d-1*rhob*t39*(4.32d-4*gamm
     1           abb*t255*t259*t74-7.2d-3*t164*t170*t74+6.0d-2*gammabb*t
     2           20*(9.604998575999998d-4*gammabb*t255*t259-1.6008330959
     3           999997d-2*t164*t170)*t73+1.2d-1*t171*t20*t73-7.2d-3*gam
     4           mabb*t164*t170*t171)*t78-2.5d-1*t172*t39)+1.0d+0*(5.958
     5           2d-8*t170*t21*t232*t24-1.9219999999999998d-5*t135*t170*
     6           t24+3.1d-3*t21*t23*(2.14500729594d-4*t135*t170-6.649522
     7           617413999d-7*t170*t21*t232)+6.2d-3*t168*t20*t23-1.92199
     8           99999999998d-5*t135*t168*t20*t21)*t71)*wght+Cmat2(iq,D2
     9           _GBB_GBB)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = (t173*(-5.0d-1*t39*t75*t78-5.0d-1*rho
     1           b*t148*t75*t78-5.0d-1*rhob*t167*t39*t78)-1.25d-1*gammab
     2           b*t173*t39*t75*t77+(1.0d+0*t39*t75+1.0d+0*rhob*t148*t75
     3           +1.0d+0*rhob*t167*t39)*t76)*wght+Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = (t173*(t257-5.0d-1*rhob*t172*t39*t78
     1           )+1.0d+0*rhob*t172*t39*t76)*wght+Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = (1.0d+0*rhob*t39*t75*t78/taub**3-2.0d
     1           +0*rhob*t173*t39*t75)*wght+Mmat2(iq,D2_TB_TB)
            else 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 2.4d-51*t1+1.0d+0
              t3 = 1/t2
              t4 = 5.336110319999999d-51*t1*t3-2.5960897d+0
              t5 = 2.4d-51*t1*t3*t4+1.0d+0
              t6 = 1/rhoa**6.666666666666666d-1
              t7 = rhoa**5.0d-1
              t8 = 1/t7
              t9 = 1/rhoa**3.333333333333333d-1
              t10 = 1/rhoa**1.6666666666666666d-1
              t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.4
     1           058712912881916d-1*t6+1.1120374863094686d+1*t10
              t12 = 3.216395899738507d+1/t11+1.0d+0
              t13 = log(t12)
              t14 = 1.274696188700087d-1*t9+1.0d+0
              t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.8
     1           970043257475583d-1*t6+5.982550435771079d+0*t10
              t16 = 1.6081979498692536d+1/t15+1.0d+0
              t17 = log(t16)
              t18 = 1.3256889990520176d-1*t9+1.0d+0
              t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2
     1           *t13*t14
              t20 = 1/rhob**1.6666666666666669d+0
              t21 = 2.4d-51*t20+1.0d+0
              t22 = 1/t21
              t23 = 5.336110319999999d-51*t20*t22-2.5960897d+0
              t24 = 2.4d-51*t20*t22*t23+1.0d+0
              t25 = 1/rhob**6.666666666666666d-1
              t26 = rhob**5.0d-1
              t27 = 1/t26
              t28 = 1/rhob**3.333333333333333d-1
              t29 = 1/rhob**1.6666666666666666d-1
              t30 = 1.1120374863094686d+1*t29+3.8447462374472113d+0*t28+
     1           1.644733775567609d+0*t27+2.4058712912881916d-1*t25
              t31 = 3.216395899738507d+1/t30+1.0d+0
              t32 = log(t31)
              t33 = 1.274696188700087d-1*t28+1.0d+0
              t34 = 5.982550435771079d+0*t29+2.2255694211506874d+0*t28+8
     1           .004286349993635d-1*t27+1.8970043257475583d-1*t25
              t35 = 1.6081979498692536d+1/t34+1.0d+0
              t36 = log(t35)
              t37 = 1.3256889990520176d-1*t28+1.0d+0
              t38 = -6.903522198342671d-18*t36*t37-3.1090699999999993d-2
     1           *t32*t33
              t39 = 4.0d-50*t20+4.0d-50*t1
              t40 = 3.1d-3*t39+1.0d+0
              t41 = 1/t40
              t42 = 5.9515308d+0-3.459689187d-2*t39*t41
              t43 = 3.1d-3*t39*t41*t42+1.0d+0
              t44 = rhob+rhoa
              t45 = 1/t44**3.333333333333333d-1
              t46 = 1.3256889990520176d-1*t45+1.0d+0
              t47 = rhoa-rhob
              t48 = t47**4
              t49 = 1/t44**4
              t50 = 1/t44
              t51 = 1.0d+0-t47*t50
              t52 = t47*t50+1.0d+0
              t53 = t52**1.3333333333333333d+0+t51**1.3333333333333333d+
     1           0-2.0d+0
              t54 = -1.923661050931536d+0*t48*t49*t53
              t55 = t54+1.0d+0
              t56 = 1/t44**6.666666666666666d-1
              t57 = t44**5.0d-1
              t58 = 1/t57
              t59 = 1/t44**1.6666666666666666d-1
              t60 = 5.982550435771079d+0*t59+8.004286349993635d-1*t58+1.
     1           8970043257475583d-1*t56+2.2255694211506874d+0*t45
              t61 = 1.6081979498692536d+1/t60+1.0d+0
              t62 = log(t61)
              t63 = -6.21814d-2*t46*t55*t62
              t64 = 6.901399211255825d-2*t45+1.0d+0
              t65 = t54+1.923661050931536d+0*t53
              t66 = 8.157414703487641d+0*t59+4.3009724712766434d-1*t58+1
     1           .9115125951273373d-1*t56+2.247591863577616d+0*t45
              t67 = 2.9608813203268075d+1/t66+1.0d+0
              t68 = log(t67)
              t69 = 1.9751631321680768d-2*t64*t65*t68
              t70 = 1.274696188700087d-1*t45+1.0d+0
              t71 = 1.1120374863094686d+1*t59+1.644733775567609d+0*t58+2
     1           .4058712912881916d-1*t56+3.8447462374472113d+0*t45
              t72 = 3.216395899738507d+1/t71+1.0d+0
              t73 = log(t72)
              t74 = -5.980796863619711d-2*t48*t49*t53*t70*t73
              t75 = t44*(t74+t69+t63)-rhob*t38-rhoa*t19
              t76 = 1/t16
              t77 = 1/t7**3
              t78 = 1/rhoa**1.3333333333333333d+0
              t79 = 1/rhoa**1.1666666666666667d+0
              t80 = -9.970917392951799d-1*t79-7.418564737168958d-1*t78-4
     1           .002143174996817d-1*t77-1.264669550498372d-1*t1
              t81 = 1/t15**2
              t82 = 1/t12
              t83 = -1.8533958105157808d+0*t79-1.2815820791490704d+0*t78
     1           -8.223668877838045d-1*t77-1.6039141941921276d-1*t1
              t84 = 1/t11**2
              t85 = 1.0d+0*t14*t82*t83*t84+1.1102230246251565d-16*t18*t7
     1           6*t80*t81+3.0506411443514264d-19*t17*t78+1.321039893133
     2           9265d-3*t13*t78
              t86 = 1/t2**2
              t87 = 1/rhoa**4.333333333333333d+0
              t88 = 1/rhoa**2.6666666666666666d+0
              t89 = 2.134444128d-101*t86*t87-8.8935172d-51*t3*t88
              t90 = 2.4d-51*t1*t3*t89-4.0d-51*t3*t4*t88+9.6d-102*t4*t86*
     1           t87
              t91 = 1/t44**1.6666666666666669d+0
              t92 = 1/t57**3
              t93 = 1/t44**1.3333333333333333d+0
              t94 = 1/t44**1.1666666666666667d+0
              t95 = -9.970917392951799d-1*t94-7.418564737168958d-1*t93-4
     1           .002143174996817d-1*t92-1.264669550498372d-1*t91
              t96 = 1/t60**2
              t97 = 1/t61
              t98 = 1.0d+0*t46*t55*t95*t96*t97
              t99 = -1.3595691172479402d+0*t94-7.491972878592053d-1*t93-
     1           2.1504862356383217d-1*t92-1.2743417300848914d-1*t91
              t100 = 1/t66**2
              t101 = 1/t67
              t102 = -5.848223622634647d-1*t100*t101*t64*t65*t99
              t103 = -1.8533958105157808d+0*t94-1.2815820791490704d+0*t9
     1           3-8.223668877838045d-1*t92-1.6039141941921276d-1*t91
              t104 = 1/t71**2
              t105 = 1/t72
              t106 = 1.923661050931536d+0*t103*t104*t105*t48*t49*t53*t70
              t107 = 1/t44**2
              t108 = t107*t47
              t109 = -t50
              t110 = t109+t108
              t111 = t51**3.333333333333333d-1
              t112 = -t107*t47
              t113 = t50+t112
              t114 = t52**3.333333333333333d-1
              t115 = 1.3333333333333333d+0*t113*t114+1.3333333333333333d
     1           +0*t110*t111
              t116 = -1.923661050931536d+0*t115*t48*t49
              t117 = 1/t44**5
              t118 = 7.694644203726144d+0*t117*t48*t53
              t119 = t47**3
              t120 = -7.694644203726144d+0*t119*t49*t53
              t121 = t120+t118+t116
              t122 = -6.21814d-2*t121*t46*t62
              t123 = 2.747773264188437d-3*t55*t62*t93
              t124 = t120+t118+t116+1.923661050931536d+0*t115
              t125 = 1.9751631321680768d-2*t124*t64*t68
              t126 = -4.5437964274821163d-4*t65*t68*t93
              t127 = -5.980796863619711d-2*t115*t48*t49*t70*t73
              t128 = 1/t44**5.333333333333333d+0
              t129 = 2.541232989148493d-3*t128*t48*t53*t73
              t130 = 2.3923187454478842d-1*t117*t48*t53*t70*t73
              t131 = t44*(t98-2.3923187454478842d-1*t119*t49*t53*t70*t73
     1           +t130+t129+t127+t126+t125+t123+t122+t106+t102)-rhoa*t85
     2           +t74+t69+t63+6.903522198342671d-18*t17*t18+3.1090699999
     3           999993d-2*t13*t14
              t132 = 1/t40**2
              t133 = 2.306459458d-51*t41*t88-7.1500243198d-54*t132*t39*t
     1           88
              t134 = -2.0666666666666667d-52*t41*t42*t88+6.4066666666666
     1           66d-55*t132*t39*t42*t88+3.1d-3*t133*t39*t41
              t135 = 1/t35
              t136 = 1/t26**3
              t137 = 1/rhob**1.3333333333333333d+0
              t138 = 1/rhob**1.1666666666666667d+0
              t139 = -1.264669550498372d-1*t20-9.970917392951799d-1*t138
     1           -7.418564737168958d-1*t137-4.002143174996817d-1*t136
              t140 = 1/t34**2
              t141 = 1/t31
              t142 = -1.6039141941921276d-1*t20-1.8533958105157808d+0*t1
     1           38-1.2815820791490704d+0*t137-8.223668877838045d-1*t136
              t143 = 1/t30**2
              t144 = 1.1102230246251565d-16*t135*t139*t140*t37+3.0506411
     1           443514264d-19*t137*t36+1.0d+0*t141*t142*t143*t33+1.3210
     2           398931339265d-3*t137*t32
              t145 = 1/t21**2
              t146 = 1/rhob**4.333333333333333d+0
              t147 = 1/rhob**2.6666666666666666d+0
              t148 = 2.134444128d-101*t145*t146-8.8935172d-51*t147*t22
              t149 = -4.0d-51*t147*t22*t23+9.6d-102*t145*t146*t23+2.4d-5
     1           1*t148*t20*t22
              t150 = t50+t108
              t151 = t112+t109
              t152 = 1.3333333333333333d+0*t114*t151+1.3333333333333333d
     1           +0*t111*t150
              t153 = -1.923661050931536d+0*t152*t48*t49
              t154 = 7.694644203726144d+0*t119*t49*t53
              t155 = t154+t153+t118
              t156 = -6.21814d-2*t155*t46*t62
              t157 = t154+t153+1.923661050931536d+0*t152+t118
              t158 = 1.9751631321680768d-2*t157*t64*t68
              t159 = -5.980796863619711d-2*t152*t48*t49*t70*t73
              t160 = t44*(t98+2.3923187454478842d-1*t119*t49*t53*t70*t73
     1           +t159+t158+t156+t130+t129+t126+t123+t106+t102)+t74+t69+
     2           t63+6.903522198342671d-18*t36*t37+3.1090699999999993d-2
     3           *t32*t33-rhob*t144
              t161 = 2.306459458d-51*t147*t41-7.1500243198d-54*t132*t147
     1           *t39
              t162 = -2.0666666666666667d-52*t147*t41*t42+6.406666666666
     1           666d-55*t132*t147*t39*t42+3.1d-3*t161*t39*t41
              t163 = t80**2
              t164 = 1/t7**5
              t165 = 1/rhoa**2.3333333333333334d+0
              t166 = 1/rhoa**2.1666666666666665d+0
              t167 = t83**2
              t168 = 1.0d+0*t14*t82*t84*(2.673190323653546d-1*t88+2.1622
     1           951122684114d+0*t166+1.7087761055320938d+0*t165+1.23355
     2           03316757068d+0*t164)+1.1102230246251565d-16*t18*t76*t81
     3           *(2.1077825841639536d-1*t88+1.1632736958443765d+0*t166+
     4           9.89141964955861d-1*t165+6.003214762495226d-1*t164)-8.4
     5           97974591333913d-2*t78*t82*t83*t84-2.0d+0*t14*t167*t82/t
     6           11**3-9.812069668265515d-18*t76*t78*t80*t81-2.220446049
     7           250313d-16*t163*t18*t76/t15**3+1.7854583920998188d-15*t
     8           163*t18/(t15**4*t16**2)-4.0675215258019015d-19*t165*t17
     9           +3.216395899738507d+1*t14*t167/(t11**4*t12**2)-1.761386
     :           5241785684d-3*t13*t165
              t169 = 1/t2**3
              t170 = 1/rhoa**7
              t171 = 1/rhoa**5.333333333333333d+0
              t172 = 1/rhoa**3.6666666666666664d+0
              t173 = 2.0d+0*t46*t55*t95*t96*t97
              t174 = -1.1696447245269295d+0*t100*t101*t64*t65*t99
              t175 = 3.847322101863072d+0*t103*t104*t105*t48*t49*t53*t70
              t176 = 5.495546528376875d-3*t55*t62*t93
              t177 = -9.087592854964233d-4*t65*t68*t93
              t178 = 5.082465978296986d-3*t128*t48*t53*t73
              t179 = 4.7846374908957684d-1*t117*t48*t53*t70*t73
              t180 = t95**2
              t181 = 1.6081979498692536d+1*t180*t46*t55/(t60**4*t61**2)
              t182 = -2.0d+0*t180*t46*t55*t97/t60**3
              t183 = -8.837926660346784d-2*t55*t93*t95*t96*t97
              t184 = 1/t44**2.6666666666666666d+0
              t185 = 1/t57**5
              t186 = 1/t44**2.3333333333333334d+0
              t187 = 1/t44**2.1666666666666665d+0
              t188 = 1.0d+0*(1.1632736958443765d+0*t187+9.89141964955861
     1           d-1*t186+6.003214762495226d-1*t185+2.1077825841639536d-
     2           1*t184)*t46*t55*t96*t97
              t189 = t99**2
              t190 = -1.73158960813529d+1*t189*t64*t65/(t66**4*t67**2)
              t191 = 1.1696447245269295d+0*t101*t189*t64*t65/t66**3
              t192 = 2.690728393099896d-2*t100*t101*t65*t93*t99
              t193 = -5.848223622634647d-1*t100*t101*(1.5861639701225969
     1           d+0*t187+9.98929717145607d-1*t186+3.2257293534574827d-1
     2           *t185+2.1239028834748191d-1*t184)*t64*t65
              t194 = t103**2
              t195 = 6.187255516702861d+1*t194*t48*t49*t53*t70/(t71**4*t
     1           72**2)
              t196 = -3.847322101863072d+0*t105*t194*t48*t49*t53*t70/t71
     1           **3
              t197 = -1.6347222733154887d-1*t103*t104*t105*t128*t48*t53
              t198 = 1.923661050931536d+0*t104*t105*(2.1622951122684114d
     1           +0*t187+1.7087761055320938d+0*t186+1.2335503316757068d+
     2           0*t185+2.673190323653546d-1*t184)*t48*t49*t53*t70
              t199 = -1.538928840745229d+1*t103*t104*t105*t117*t48*t53*t
     1           70
              t200 = 1/t51**6.666666666666666d-1
              t201 = 1/t44**3
              t202 = -2*t201*t47
              t203 = 2*t107
              t204 = 1/t52**6.666666666666666d-1
              t205 = 2*t201*t47
              t206 = -2*t107
              t207 = 1.3333333333333333d+0*t114*(t206+t205)+4.4444444444
     1           44444d-1*t113**2*t204+1.3333333333333333d+0*t111*(t203+
     2           t202)+4.444444444444444d-1*t110**2*t200
              t208 = -1.923661050931536d+0*t207*t48*t49
              t209 = 1.5389288407452287d+1*t115*t117*t48
              t210 = -1.5389288407452287d+1*t115*t119*t49
              t211 = 1/t44**6
              t212 = -3.8473221018630716d+1*t211*t48*t53
              t213 = 6.155715362980915d+1*t117*t119*t53
              t214 = t47**2
              t215 = -2.3083932611178434d+1*t214*t49*t53
              t216 = -3.663697685584583d-3*t186*t55*t62
              t217 = 6.058395236642822d-4*t186*t65*t68
              t218 = -2.3718174565385935d-2*t48*t53*t73/t44**6.333333333
     1           333333d+0
              t219 = -1.1961593727239421d+0*t211*t48*t53*t70*t73
              t220 = -7.176956236343652d-1*t214*t49*t53*t70*t73
              t221 = 1/t40**3
              t222 = 2.6666666666666666d+0*t114*t201*t47-2.6666666666666
     1           666d+0*t111*t201*t47+4.444444444444444d-1*t113*t151*t20
     2           4+4.444444444444444d-1*t110*t150*t200
              t223 = -1.923661050931536d+0*t222*t48*t49
              t224 = 7.694644203726144d+0*t117*t152*t48
              t225 = -7.694644203726144d+0*t119*t152*t49
              t226 = 7.694644203726144d+0*t115*t117*t48
              t227 = 7.694644203726144d+0*t115*t119*t49
              t228 = 2.3083932611178434d+1*t214*t49*t53
              t229 = t139**2
              t230 = 1/t26**5
              t231 = 1/rhob**2.3333333333333334d+0
              t232 = 1/rhob**2.1666666666666665d+0
              t233 = t142**2
              t234 = 1.7854583920998188d-15*t229*t37/(t34**4*t35**2)-2.2
     1           20446049250313d-16*t135*t229*t37/t34**3+1.1102230246251
     2           565d-16*t135*t140*(1.1632736958443765d+0*t232+9.8914196
     3           4955861d-1*t231+6.003214762495226d-1*t230+2.10778258416
     4           39536d-1*t147)*t37-4.0675215258019015d-19*t231*t36+3.21
     5           6395899738507d+1*t233*t33/(t30**4*t31**2)-2.0d+0*t141*t
     6           233*t33/t30**3+1.0d+0*t141*t143*(2.1622951122684114d+0*
     7           t232+1.7087761055320938d+0*t231+1.2335503316757068d+0*t
     8           230+2.673190323653546d-1*t147)*t33-1.7613865241785684d-
     9           3*t231*t32-8.497974591333913d-2*t137*t141*t142*t143-9.8
     :           12069668265515d-18*t135*t137*t139*t140
              t235 = 1/t21**3
              t236 = 1/rhob**7
              t237 = 1/rhob**5.333333333333333d+0
              t238 = 1/rhob**3.6666666666666664d+0
              t239 = 1.3333333333333333d+0*t111*(t206+t202)+1.3333333333
     1           333333d+0*t114*(t205+t203)+4.444444444444444d-1*t151**2
     2           *t204+4.444444444444444d-1*t150**2*t200
              t240 = -1.923661050931536d+0*t239*t48*t49
              t241 = 1.5389288407452287d+1*t117*t152*t48
              t242 = 1.5389288407452287d+1*t119*t152*t49
              t243 = -6.155715362980915d+1*t117*t119*t53
              fnc(iq) = (1.0d+0*t43*t75+5.0d-1*rhoa*t19*t5+5.0d-1*rhob*t
     1           24*t38)*wght+fnc(iq)
              Amat(iq,D1_RA) = (5.0d-1*rhoa*t19*t90+5.0d-1*rhoa*t5*t85+1
     1           .0d+0*t134*t75+5.0d-1*t19*t5+1.0d+0*t131*t43)*wght+Amat
     2           (iq,D1_RA)
              Amat(iq,D1_RB) = (1.0d+0*t162*t75+1.0d+0*t160*t43+5.0d-1*t
     1           24*t38+5.0d-1*rhob*t149*t38+5.0d-1*rhob*t144*t24)*wght+
     2           Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (1.0d+0*t43*(t44*(-1.1696447245269295
     1           d+0*t100*t101*t124*t64*t99+2.0d+0*t121*t46*t95*t96*t97-
     2           9.087592854964233d-4*t124*t68*t93+5.495546528376875d-3*
     3           t121*t62*t93+1.9138549963583074d+0*t117*t119*t53*t70*t7
     4           3-5.980796863619711d-2*t207*t48*t49*t70*t73-4.784637490
     5           8957684d-1*t115*t119*t49*t70*t73+4.7846374908957684d-1*
     6           t115*t117*t48*t70*t73+2.0329863913187946d-2*t119*t128*t
     7           53*t73+5.082465978296986d-3*t115*t128*t48*t73+1.5389288
     8           40745229d+1*t103*t104*t105*t119*t49*t53*t70+3.847322101
     9           863072d+0*t103*t104*t105*t115*t48*t49*t70+1.97516313216
     :           80768d-2*(t215+t213+t212+t210+t209+t208+1.9236610509315
     ;           36d+0*t207)*t64*t68-6.21814d-2*(t215+t213+t212+t210+t20
     <           9+t208)*t46*t62+t220+t219+t218+t217+t216+t199+t198+t197
     =           +t196+t195+t193+t192+t191+t190+t188+t183+t182+t181)-2.0
     >           d+0*t14*t82*t83*t84-2.220446049250313d-16*t18*t76*t80*t
     ?           81-6.101282288702853d-19*t17*t78-2.642079786267853d-3*t
     @           13*t78-4.7846374908957684d-1*t119*t49*t53*t70*t73-1.196
     1           1593727239421d-1*t115*t48*t49*t70*t73+3.950326264336153
     2           6d-2*t124*t64*t68-1.243628d-1*t121*t46*t62+t179+t178+t1
     3           77+t176+t175+t174+t173-rhoa*t168)+1.0d+0*rhoa*t85*t90+1
     4           .0d+0*t19*t90+5.0d-1*rhoa*t19*(-8.0d-51*t3*t88*t89+1.92
     5           d-101*t86*t87*t89+2.4d-51*t1*t3*(-1.2806664767999998d-1
     6           00*t171*t86+2.3716045866666666d-50*t172*t3+1.7075553024
     7           d-151*t169*t170)-5.76d-101*t171*t4*t86+1.06666666666666
     8           66d-50*t172*t3*t4+7.68d-152*t169*t170*t4)+1.0d+0*t75*(-
     9           4.1333333333333333d-52*t133*t41*t88+1.2813333333333332d
     :           -54*t132*t133*t39*t88+5.51111111111111d-52*t172*t41*t42
     ;           +2.6480888888888887d-106*t171*t221*t39*t42-1.7084444444
     <           44444d-54*t132*t172*t39*t42-8.542222222222222d-104*t132
     =           *t171*t42+3.1d-3*t39*t41*(-6.150558554666666d-51*t172*t
     >           41-2.9553433855173333d-105*t171*t221*t39+1.906673151946
     ?           6665d-53*t132*t172*t39+9.533365759733332d-103*t132*t171
     @           ))+1.0d+0*t5*t85+5.0d-1*rhoa*t168*t5+2.0d+0*t131*t134)*
     1           wght+Amat2(iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = (1.0d+0*t43*(t44*(-5.848223622634647d
     1           -1*t100*t101*t157*t64*t99-5.848223622634647d-1*t100*t10
     2           1*t124*t64*t99+1.0d+0*t155*t46*t95*t96*t97+1.0d+0*t121*
     3           t46*t95*t96*t97-4.5437964274821163d-4*t157*t68*t93-4.54
     4           37964274821163d-4*t124*t68*t93+2.747773264188437d-3*t15
     5           5*t62*t93+2.747773264188437d-3*t121*t62*t93+7.176956236
     6           343652d-1*t214*t49*t53*t70*t73-5.980796863619711d-2*t22
     7           2*t48*t49*t70*t73-2.3923187454478842d-1*t119*t152*t49*t
     8           70*t73+2.3923187454478842d-1*t115*t119*t49*t70*t73+2.39
     9           23187454478842d-1*t117*t152*t48*t70*t73+2.3923187454478
     :           842d-1*t115*t117*t48*t70*t73+2.541232989148493d-3*t128*
     ;           t152*t48*t73+2.541232989148493d-3*t115*t128*t48*t73+1.9
     <           23661050931536d+0*t103*t104*t105*t152*t48*t49*t70+1.923
     =           661050931536d+0*t103*t104*t105*t115*t48*t49*t70+1.97516
     >           31321680768d-2*(t228+t227+t226+t225+t224+t223+1.9236610
     ?           50931536d+0*t222+t212)*t64*t68-6.21814d-2*(t228+t227+t2
     @           26+t225+t224+t223+t212)*t46*t62+t219+t218+t217+t216+t19
     1           9+t198+t197+t196+t195+t193+t192+t191+t190+t188+t183+t18
     2           2+t181)+t179+t178+t177+t176+t175+t174+t173+t159+t158+t1
     3           56+t127+t125+t122)+1.0d+0*t75*(3.1d-3*t39*t41*(9.533365
     4           759733332d-103*t132*t147*t88-2.9553433855173333d-105*t1
     5           47*t221*t39*t88)+2.6480888888888887d-106*t147*t221*t39*
     6           t42*t88-8.542222222222222d-104*t132*t147*t42*t88-2.0666
     7           666666666667d-52*t161*t41*t88+6.406666666666666d-55*t13
     8           2*t161*t39*t88-2.0666666666666667d-52*t133*t147*t41+6.4
     9           06666666666666d-55*t132*t133*t147*t39)+1.0d+0*t131*t162
     :           +1.0d+0*t134*t160)*wght+Amat2(iq,D2_RA_RB)
              Amat2(iq,D2_RB_RB) = (1.0d+0*t43*(t44*(-1.1696447245269295
     1           d+0*t100*t101*t157*t64*t99+2.0d+0*t155*t46*t95*t96*t97-
     2           9.087592854964233d-4*t157*t68*t93+5.495546528376875d-3*
     3           t155*t62*t93-1.9138549963583074d+0*t117*t119*t53*t70*t7
     4           3-5.980796863619711d-2*t239*t48*t49*t70*t73+4.784637490
     5           8957684d-1*t119*t152*t49*t70*t73+4.7846374908957684d-1*
     6           t117*t152*t48*t70*t73-2.0329863913187946d-2*t119*t128*t
     7           53*t73+5.082465978296986d-3*t128*t152*t48*t73-1.5389288
     8           40745229d+1*t103*t104*t105*t119*t49*t53*t70+3.847322101
     9           863072d+0*t103*t104*t105*t152*t48*t49*t70+1.97516313216
     :           80768d-2*(t243+t242+t241+t240+1.923661050931536d+0*t239
     ;           +t215+t212)*t64*t68-6.21814d-2*(t243+t242+t241+t240+t21
     <           5+t212)*t46*t62+t220+t219+t218+t217+t216+t199+t198+t197
     =           +t196+t195+t193+t192+t191+t190+t188+t183+t182+t181)+4.7
     >           846374908957684d-1*t119*t49*t53*t70*t73-1.1961593727239
     ?           421d-1*t152*t48*t49*t70*t73+3.9503262643361536d-2*t157*
     @           t64*t68-1.243628d-1*t155*t46*t62-2.220446049250313d-16*
     1           t135*t139*t140*t37-6.101282288702853d-19*t137*t36-2.0d+
     2           0*t141*t142*t143*t33-2.642079786267853d-3*t137*t32-rhob
     3           *t234+t179+t178+t177+t176+t175+t174+t173)+1.0d+0*(5.511
     4           11111111111d-52*t238*t41*t42-1.708444444444444d-54*t132
     5           *t238*t39*t42+2.6480888888888887d-106*t221*t237*t39*t42
     6           -8.542222222222222d-104*t132*t237*t42+3.1d-3*t39*t41*(-
     7           6.150558554666666d-51*t238*t41+1.9066731519466665d-53*t
     8           132*t238*t39-2.9553433855173333d-105*t221*t237*t39+9.53
     9           3365759733332d-103*t132*t237)-4.1333333333333333d-52*t1
     :           47*t161*t41+1.2813333333333332d-54*t132*t147*t161*t39)*
     ;           t75+5.0d-1*rhob*(2.4d-51*t20*t22*(2.3716045866666666d-5
     <           0*t22*t238-1.2806664767999998d-100*t145*t237+1.70755530
     =           24d-151*t235*t236)+1.0666666666666666d-50*t22*t23*t238-
     >           5.76d-101*t145*t23*t237+7.68d-152*t23*t235*t236-8.0d-51
     ?           *t147*t148*t22+1.92d-101*t145*t146*t148)*t38+1.0d+0*t14
     @           9*t38+5.0d-1*rhob*t234*t24+1.0d+0*t144*t24+2.0d+0*t160*
     1           t162+1.0d+0*rhob*t144*t149)*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_RB_GAA) = Cmat2(iq,D2_RB_GAA)
              Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
              Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
              Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            endif 
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhoa**2.6666666666666666d+0
              t2 = 6.0d-2*gammaaa*t1+1.0d+0
              t3 = 1/t2
              t4 = 1.3340275799999998d-1*gammaaa*t1*t3-2.5960897d+0
              t5 = 6.0d-2*gammaaa*t1*t3*t4+1.0d+0
              t6 = 1/rhoa**6.666666666666666d-1
              t7 = rhoa**5.0d-1
              t8 = 1/t7
              t9 = 1/rhoa**3.333333333333333d-1
              t10 = 1/rhoa**1.6666666666666666d-1
              t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.4
     1           058712912881916d-1*t6+1.1120374863094686d+1*t10
              t12 = 3.216395899738507d+1/t11+1.0d+0
              t13 = log(t12)
              t14 = 1.274696188700087d-1*t9+1.0d+0
              t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.8
     1           970043257475583d-1*t6+5.982550435771079d+0*t10
              t16 = 1.6081979498692536d+1/t15+1.0d+0
              t17 = log(t16)
              t18 = 1.3256889990520176d-1*t9+1.0d+0
              t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2
     1           *t13*t14
              t20 = 1/taua
              t21 = 1/rhoa
              t22 = 2.0d+0*taua-2.5d-1*gammaaa*t21
              t23 = 1/t16
              t24 = 1/rhoa**1.6666666666666669d+0
              t25 = 1/t7**3
              t26 = 1/rhoa**1.3333333333333333d+0
              t27 = 1/rhoa**1.1666666666666667d+0
              t28 = -9.970917392951799d-1*t27-7.418564737168958d-1*t26-4
     1           .002143174996817d-1*t25-1.264669550498372d-1*t24
              t29 = 1/t15**2
              t30 = 1/t12
              t31 = -1.8533958105157808d+0*t27-1.2815820791490704d+0*t26
     1           -8.223668877838045d-1*t25-1.6039141941921276d-1*t24
              t32 = 1/t11**2
              t33 = 1.0d+0*t14*t30*t31*t32+1.1102230246251565d-16*t18*t2
     1           3*t28*t29+3.0506411443514264d-19*t17*t26+1.321039893133
     2           9265d-3*t13*t26
              t34 = gammaaa**2
              t35 = 1/t2**2
              t36 = 1/rhoa**6.333333333333333d+0
              t37 = 1/rhoa**3.6666666666666664d+0
              t38 = 2.1344441279999993d-2*t34*t35*t36-3.557406879999999d
     1           -1*gammaaa*t3*t37
              t39 = -1.5999999999999998d-1*gammaaa*t3*t37*t4+9.599999999
     1           999997d-3*t34*t35*t36*t4+6.0d-2*gammaaa*t1*t3*t38
              t40 = 1/rhoa**5.333333333333333d+0
              t41 = 1.3340275799999998d-1*t1*t3-8.004165479999998d-3*gam
     1           maaa*t35*t40
              t42 = 6.0d-2*gammaaa*t1*t3*t41-3.6d-3*gammaaa*t35*t4*t40+6
     1           .0d-2*t1*t3*t4
              t43 = 1/taua**2
              t44 = 1/rhoa**2
              t45 = t28**2
              t46 = 1/t7**5
              t47 = 1/rhoa**2.3333333333333334d+0
              t48 = 1/rhoa**2.1666666666666665d+0
              t49 = t31**2
              t50 = gammaaa**3
              t51 = 1/t2**3
              t52 = 1/rhoa**10
              t53 = 1/rhoa**7.333333333333333d+0
              t54 = 1/rhoa**4.666666666666667d+0
              t55 = 1.25d-1*t19*t5*wght
              t56 = 1/rhoa**9
              t57 = 1/rhoa**8
              fnc(iq) = 5.0d-1*rhoa*t19*t20*t22*t5*wght+fnc(iq)
              Amat(iq,D1_RA) = t20*(5.0d-1*rhoa*t22*t33*t5*wght+5.0d-1*t
     1           19*t22*t5*wght+5.0d-1*rhoa*t19*t22*t39*wght)+1.25d-1*ga
     2           mmaaa*t19*t20*t21*t5*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = t20*(5.0d-1*rhoa*t19*t22*t42*wght-1.25d-
     1           1*t19*t5*wght)+Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = -5.0d-1*rhoa*t19*t22*t43*t5*wght+1.0d+0*r
     1           hoa*t19*t20*t5*wght+Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = t20*(5.0d-1*rhoa*t19*t22*(6.0d-2*gamm
     1           aaa*t1*t3*(1.3043825226666664d+0*gammaaa*t3*t54-1.92099
     2           97151999994d-1*t34*t35*t53+6.830221209599997d-3*t50*t51
     3           *t52)+5.866666666666666d-1*gammaaa*t3*t4*t54-8.63999999
     4           9999998d-2*t34*t35*t4*t53+3.0719999999999986d-3*t4*t50*
     5           t51*t52-3.1999999999999995d-1*gammaaa*t3*t37*t38+1.9199
     6           999999999995d-2*t34*t35*t36*t38)*wght+5.0d-1*rhoa*t22*(
     7           -2.0d+0*t14*t30*t49/t11**3+3.216395899738507d+1*t14*t49
     8           /(t11**4*t12**2)+1.0d+0*t14*t30*t32*(2.1622951122684114
     9           d+0*t48+1.7087761055320938d+0*t47+1.2335503316757068d+0
     :           *t46+2.673190323653546d-1*t1)+1.1102230246251565d-16*t1
     ;           8*t23*t29*(1.1632736958443765d+0*t48+9.89141964955861d-
     <           1*t47+6.003214762495226d-1*t46+2.1077825841639536d-1*t1
     =           )-4.0675215258019015d-19*t17*t47-1.7613865241785684d-3*
     >           t13*t47-2.220446049250313d-16*t18*t23*t45/t15**3+1.7854
     ?           583920998188d-15*t18*t45/(t15**4*t16**2)-8.497974591333
     @           913d-2*t26*t30*t31*t32-9.812069668265515d-18*t23*t26*t2
     1           8*t29)*t5*wght+1.25d-1*gammaaa*t19*t44*t5*wght+1.0d+0*t
     2           22*t33*t5*wght+1.25d-1*gammaaa*t21*t33*t5*wght+1.0d+0*r
     3           hoa*t22*t33*t39*wght+1.0d+0*t19*t22*t39*wght+1.25d-1*ga
     4           mmaaa*t19*t21*t39*wght)+t20*t21*(1.25d-1*gammaaa*t33*t5
     5           *wght+1.25d-1*gammaaa*t19*t39*wght)-1.25d-1*gammaaa*t19
     6           *t20*t44*t5*wght+Amat2(iq,D2_RA_RA)
              Cmat2(iq,D2_RA_GAA) = t20*(5.0d-1*rhoa*t19*t22*(6.0d-2*gam
     1           maaa*t1*t3*(-2.561332953599999d-3*t34*t51*t56-3.5574068
     2           79999999d-1*t3*t37+6.403332383999999d-2*gammaaa*t35*t36
     3           )-1.1519999999999996d-3*t34*t4*t51*t56-1.59999999999999
     4           98d-1*gammaaa*t3*t37*t41+9.599999999999997d-3*t34*t35*t
     5           36*t41-3.6d-3*gammaaa*t35*t38*t40-1.5999999999999998d-1
     6           *t3*t37*t4+2.879999999999999d-2*gammaaa*t35*t36*t4+6.0d
     7           -2*t1*t3*t38)*wght-1.25d-1*t33*t5*wght-1.25d-1*t19*t21*
     8           t5*wght+5.0d-1*rhoa*t22*t33*t42*wght+5.0d-1*t19*t22*t42
     9           *wght-1.25d-1*t19*t39*wght)+t20*t21*(1.25d-1*gammaaa*t1
     :           9*t42*wght+t55)+Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_GAA_GAA) = t20*(5.0d-1*rhoa*t19*t22*(6.0d-2*ga
     1           mmaaa*t1*t3*(9.604998575999998d-4*gammaaa*t51*t57-1.600
     2           8330959999997d-2*t35*t40)+4.32d-4*gammaaa*t4*t51*t57-7.
     3           2d-3*gammaaa*t35*t40*t41+1.2d-1*t1*t3*t41-7.2d-3*t35*t4
     4           *t40)*wght-2.5d-1*t19*t42*wght)+Cmat2(iq,D2_GAA_GAA)
              Mmat2(iq,D2_RA_TA) = t43*(-5.0d-1*rhoa*t22*t33*t5*wght-5.0
     1           d-1*t19*t22*t5*wght-5.0d-1*rhoa*t19*t22*t39*wght)+t20*(
     2           1.0d+0*rhoa*t33*t5*wght+1.0d+0*t19*t5*wght+1.0d+0*rhoa*
     3           t19*t39*wght)-1.25d-1*gammaaa*t19*t21*t43*t5*wght+Mmat2
     4           (iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = t43*(t55-5.0d-1*rhoa*t19*t22*t42*wgh
     1           t)+1.0d+0*rhoa*t19*t20*t42*wght+Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_TA_TA) = 1.0d+0*rhoa*t19*t22*t5*wght/taua**3-2
     1           .0d+0*rhoa*t19*t43*t5*wght+Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = 1/rhoa**2.6666666666666666d+0
              t2 = 6.0d-2*gammaaa*t1+1.0d+0
              t3 = 1/t2
              t4 = 1.3340275799999998d-1*gammaaa*t1*t3-2.5960897d+0
              t5 = 6.0d-2*gammaaa*t1*t3*t4+1.0d+0
              t6 = 1/rhoa**6.666666666666666d-1
              t7 = rhoa**5.0d-1
              t8 = 1/t7
              t9 = 1/rhoa**3.333333333333333d-1
              t10 = 1/rhoa**1.6666666666666666d-1
              t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.4
     1           058712912881916d-1*t6+1.1120374863094686d+1*t10
              t12 = 3.216395899738507d+1/t11+1.0d+0
              t13 = log(t12)
              t14 = 1.274696188700087d-1*t9+1.0d+0
              t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.8
     1           970043257475583d-1*t6+5.982550435771079d+0*t10
              t16 = 1.6081979498692536d+1/t15+1.0d+0
              t17 = log(t16)
              t18 = 1.3256889990520176d-1*t9+1.0d+0
              t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2
     1           *t13*t14
              t20 = 1/taua
              t21 = 1/rhoa
              t22 = 2.0d+0*taua-2.5d-1*gammaaa*t21
              t23 = 1/t16
              t24 = 1/rhoa**1.6666666666666669d+0
              t25 = 1/t7**3
              t26 = 1/rhoa**1.3333333333333333d+0
              t27 = 1/rhoa**1.1666666666666667d+0
              t28 = -9.970917392951799d-1*t27-7.418564737168958d-1*t26-4
     1           .002143174996817d-1*t25-1.264669550498372d-1*t24
              t29 = 1/t15**2
              t30 = 1/t12
              t31 = -1.8533958105157808d+0*t27-1.2815820791490704d+0*t26
     1           -8.223668877838045d-1*t25-1.6039141941921276d-1*t24
              t32 = 1/t11**2
              t33 = 1.0d+0*t14*t30*t31*t32+1.1102230246251565d-16*t18*t2
     1           3*t28*t29+3.0506411443514264d-19*t17*t26+1.321039893133
     2           9265d-3*t13*t26
              t34 = gammaaa**2
              t35 = 1/t2**2
              t36 = 1/rhoa**6.333333333333333d+0
              t37 = 1/rhoa**3.6666666666666664d+0
              t38 = 2.1344441279999993d-2*t34*t35*t36-3.557406879999999d
     1           -1*gammaaa*t3*t37
              t39 = -1.5999999999999998d-1*gammaaa*t3*t37*t4+9.599999999
     1           999997d-3*t34*t35*t36*t4+6.0d-2*gammaaa*t1*t3*t38
              t40 = 1/rhoa**5.333333333333333d+0
              t41 = 1.3340275799999998d-1*t1*t3-8.004165479999998d-3*gam
     1           maaa*t35*t40
              t42 = 6.0d-2*gammaaa*t1*t3*t41-3.6d-3*gammaaa*t35*t4*t40+6
     1           .0d-2*t1*t3*t4
              t43 = 1/taua**2
              t44 = 1/rhoa**2
              t45 = t28**2
              t46 = 1/t7**5
              t47 = 1/rhoa**2.3333333333333334d+0
              t48 = 1/rhoa**2.1666666666666665d+0
              t49 = t31**2
              t50 = gammaaa**3
              t51 = 1/t2**3
              t52 = 1/rhoa**10
              t53 = 1/rhoa**7.333333333333333d+0
              t54 = 1/rhoa**4.666666666666667d+0
              t55 = 1.25d-1*t19*t5*wght
              t56 = 1/rhoa**9
              t57 = 1/rhoa**8
              fnc(iq) = 5.0d-1*rhoa*t19*t20*t22*t5*wght+fnc(iq)
              Amat(iq,D1_RA) = t20*(5.0d-1*rhoa*t22*t33*t5*wght+5.0d-1*t
     1           19*t22*t5*wght+5.0d-1*rhoa*t19*t22*t39*wght)+1.25d-1*ga
     2           mmaaa*t19*t20*t21*t5*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = t20*(5.0d-1*rhoa*t19*t22*t42*wght-1.25d-
     1           1*t19*t5*wght)+Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = -5.0d-1*rhoa*t19*t22*t43*t5*wght+1.0d+0*r
     1           hoa*t19*t20*t5*wght+Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = t20*(5.0d-1*rhoa*t19*t22*(6.0d-2*gamm
     1           aaa*t1*t3*(1.3043825226666664d+0*gammaaa*t3*t54-1.92099
     2           97151999994d-1*t34*t35*t53+6.830221209599997d-3*t50*t51
     3           *t52)+5.866666666666666d-1*gammaaa*t3*t4*t54-8.63999999
     4           9999998d-2*t34*t35*t4*t53+3.0719999999999986d-3*t4*t50*
     5           t51*t52-3.1999999999999995d-1*gammaaa*t3*t37*t38+1.9199
     6           999999999995d-2*t34*t35*t36*t38)*wght+5.0d-1*rhoa*t22*(
     7           -2.0d+0*t14*t30*t49/t11**3+3.216395899738507d+1*t14*t49
     8           /(t11**4*t12**2)+1.0d+0*t14*t30*t32*(2.1622951122684114
     9           d+0*t48+1.7087761055320938d+0*t47+1.2335503316757068d+0
     :           *t46+2.673190323653546d-1*t1)+1.1102230246251565d-16*t1
     ;           8*t23*t29*(1.1632736958443765d+0*t48+9.89141964955861d-
     <           1*t47+6.003214762495226d-1*t46+2.1077825841639536d-1*t1
     =           )-4.0675215258019015d-19*t17*t47-1.7613865241785684d-3*
     >           t13*t47-2.220446049250313d-16*t18*t23*t45/t15**3+1.7854
     ?           583920998188d-15*t18*t45/(t15**4*t16**2)-8.497974591333
     @           913d-2*t26*t30*t31*t32-9.812069668265515d-18*t23*t26*t2
     1           8*t29)*t5*wght+1.25d-1*gammaaa*t19*t44*t5*wght+1.0d+0*t
     2           22*t33*t5*wght+1.25d-1*gammaaa*t21*t33*t5*wght+1.0d+0*r
     3           hoa*t22*t33*t39*wght+1.0d+0*t19*t22*t39*wght+1.25d-1*ga
     4           mmaaa*t19*t21*t39*wght)+t20*t21*(1.25d-1*gammaaa*t33*t5
     5           *wght+1.25d-1*gammaaa*t19*t39*wght)-1.25d-1*gammaaa*t19
     6           *t20*t44*t5*wght+Amat2(iq,D2_RA_RA)
              Cmat2(iq,D2_RA_GAA) = t20*(5.0d-1*rhoa*t19*t22*(6.0d-2*gam
     1           maaa*t1*t3*(-2.561332953599999d-3*t34*t51*t56-3.5574068
     2           79999999d-1*t3*t37+6.403332383999999d-2*gammaaa*t35*t36
     3           )-1.1519999999999996d-3*t34*t4*t51*t56-1.59999999999999
     4           98d-1*gammaaa*t3*t37*t41+9.599999999999997d-3*t34*t35*t
     5           36*t41-3.6d-3*gammaaa*t35*t38*t40-1.5999999999999998d-1
     6           *t3*t37*t4+2.879999999999999d-2*gammaaa*t35*t36*t4+6.0d
     7           -2*t1*t3*t38)*wght-1.25d-1*t33*t5*wght-1.25d-1*t19*t21*
     8           t5*wght+5.0d-1*rhoa*t22*t33*t42*wght+5.0d-1*t19*t22*t42
     9           *wght-1.25d-1*t19*t39*wght)+t20*t21*(1.25d-1*gammaaa*t1
     :           9*t42*wght+t55)+Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_GAA_GAA) = t20*(5.0d-1*rhoa*t19*t22*(6.0d-2*ga
     1           mmaaa*t1*t3*(9.604998575999998d-4*gammaaa*t51*t57-1.600
     2           8330959999997d-2*t35*t40)+4.32d-4*gammaaa*t4*t51*t57-7.
     3           2d-3*gammaaa*t35*t40*t41+1.2d-1*t1*t3*t41-7.2d-3*t35*t4
     4           *t40)*wght-2.5d-1*t19*t42*wght)+Cmat2(iq,D2_GAA_GAA)
              Mmat2(iq,D2_RA_TA) = t43*(-5.0d-1*rhoa*t22*t33*t5*wght-5.0
     1           d-1*t19*t22*t5*wght-5.0d-1*rhoa*t19*t22*t39*wght)+t20*(
     2           1.0d+0*rhoa*t33*t5*wght+1.0d+0*t19*t5*wght+1.0d+0*rhoa*
     3           t19*t39*wght)-1.25d-1*gammaaa*t19*t21*t43*t5*wght+Mmat2
     4           (iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = t43*(t55-5.0d-1*rhoa*t19*t22*t42*wgh
     1           t)+1.0d+0*rhoa*t19*t20*t42*wght+Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_TA_TA) = 1.0d+0*rhoa*t19*t22*t5*wght/taua**3-2
     1           .0d+0*rhoa*t19*t43*t5*wght+Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 2.4d-51*t1+1.0d+0
              t3 = 1/t2
              t4 = 5.336110319999999d-51*t1*t3-2.5960897d+0
              t5 = 2.4d-51*t1*t3*t4+1.0d+0
              t6 = 1/rhoa**6.666666666666666d-1
              t7 = rhoa**5.0d-1
              t8 = 1/t7
              t9 = 1/rhoa**3.333333333333333d-1
              t10 = 1/rhoa**1.6666666666666666d-1
              t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.4
     1           058712912881916d-1*t6+1.1120374863094686d+1*t10
              t12 = 3.216395899738507d+1/t11+1.0d+0
              t13 = log(t12)
              t14 = 1.274696188700087d-1*t9+1.0d+0
              t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.8
     1           970043257475583d-1*t6+5.982550435771079d+0*t10
              t16 = 1.6081979498692536d+1/t15+1.0d+0
              t17 = log(t16)
              t18 = 1.3256889990520176d-1*t9+1.0d+0
              t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2
     1           *t13*t14
              t20 = 1/t16
              t21 = 1/t7**3
              t22 = 1/rhoa**1.3333333333333333d+0
              t23 = 1/rhoa**1.1666666666666667d+0
              t24 = -9.970917392951799d-1*t23-7.418564737168958d-1*t22-4
     1           .002143174996817d-1*t21-1.264669550498372d-1*t1
              t25 = 1/t15**2
              t26 = 1/t12
              t27 = -1.8533958105157808d+0*t23-1.2815820791490704d+0*t22
     1           -8.223668877838045d-1*t21-1.6039141941921276d-1*t1
              t28 = 1/t11**2
              t29 = 1.0d+0*t14*t26*t27*t28+1.1102230246251565d-16*t18*t2
     1           0*t24*t25+3.0506411443514264d-19*t17*t22+1.321039893133
     2           9265d-3*t13*t22
              t30 = 1/t2**2
              t31 = 1/rhoa**4.333333333333333d+0
              t32 = 1/rhoa**2.6666666666666666d+0
              t33 = 2.134444128d-101*t30*t31-8.8935172d-51*t3*t32
              t34 = -4.0d-51*t3*t32*t4+9.6d-102*t30*t31*t4+2.4d-51*t1*t3
     1           *t33
              t35 = t24**2
              t36 = 1/t7**5
              t37 = 1/rhoa**2.3333333333333334d+0
              t38 = 1/rhoa**2.1666666666666665d+0
              t39 = t27**2
              t40 = 1/t2**3
              t41 = 1/rhoa**7
              t42 = 1/rhoa**5.333333333333333d+0
              t43 = 1/rhoa**3.6666666666666664d+0
              fnc(iq) = 5.0d-1*rhoa*t19*t5*wght+fnc(iq)
              Amat(iq,D1_RA) = 5.0d-1*rhoa*t29*t5*wght+5.0d-1*t19*t5*wgh
     1           t+5.0d-1*rhoa*t19*t34*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = 5.0d-1*rhoa*(-2.0d+0*t14*t26*t39/t11*
     1           *3+3.216395899738507d+1*t14*t39/(t11**4*t12**2)+1.0d+0*
     2           t14*t26*t28*(2.1622951122684114d+0*t38+1.70877610553209
     3           38d+0*t37+1.2335503316757068d+0*t36+2.673190323653546d-
     4           1*t32)+1.1102230246251565d-16*t18*t20*t25*(1.1632736958
     5           443765d+0*t38+9.89141964955861d-1*t37+6.003214762495226
     6           d-1*t36+2.1077825841639536d-1*t32)-4.0675215258019015d-
     7           19*t17*t37-1.7613865241785684d-3*t13*t37-2.220446049250
     8           313d-16*t18*t20*t35/t15**3+1.7854583920998188d-15*t18*t
     9           35/(t15**4*t16**2)-8.497974591333913d-2*t22*t26*t27*t28
     :           -9.812069668265515d-18*t20*t22*t24*t25)*t5*wght+1.0d+0*
     ;           t29*t5*wght+5.0d-1*rhoa*t19*(2.4d-51*t1*t3*(2.371604586
     <           6666666d-50*t3*t43-1.2806664767999998d-100*t30*t42+1.70
     =           75553024d-151*t40*t41)+1.0666666666666666d-50*t3*t4*t43
     >           -5.76d-101*t30*t4*t42+7.68d-152*t4*t40*t41-8.0d-51*t3*t
     ?           32*t33+1.92d-101*t30*t31*t33)*wght+1.0d+0*rhoa*t29*t34*
     @           wght+1.0d+0*t19*t34*wght+Amat2(iq,D2_RA_RA)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            else 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 2.4d-51*t1+1.0d+0
              t3 = 1/t2
              t4 = 5.336110319999999d-51*t1*t3-2.5960897d+0
              t5 = 2.4d-51*t1*t3*t4+1.0d+0
              t6 = 1/rhoa**6.666666666666666d-1
              t7 = rhoa**5.0d-1
              t8 = 1/t7
              t9 = 1/rhoa**3.333333333333333d-1
              t10 = 1/rhoa**1.6666666666666666d-1
              t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.4
     1           058712912881916d-1*t6+1.1120374863094686d+1*t10
              t12 = 3.216395899738507d+1/t11+1.0d+0
              t13 = log(t12)
              t14 = 1.274696188700087d-1*t9+1.0d+0
              t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.8
     1           970043257475583d-1*t6+5.982550435771079d+0*t10
              t16 = 1.6081979498692536d+1/t15+1.0d+0
              t17 = log(t16)
              t18 = 1.3256889990520176d-1*t9+1.0d+0
              t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2
     1           *t13*t14
              t20 = 1/t16
              t21 = 1/t7**3
              t22 = 1/rhoa**1.3333333333333333d+0
              t23 = 1/rhoa**1.1666666666666667d+0
              t24 = -9.970917392951799d-1*t23-7.418564737168958d-1*t22-4
     1           .002143174996817d-1*t21-1.264669550498372d-1*t1
              t25 = 1/t15**2
              t26 = 1/t12
              t27 = -1.8533958105157808d+0*t23-1.2815820791490704d+0*t22
     1           -8.223668877838045d-1*t21-1.6039141941921276d-1*t1
              t28 = 1/t11**2
              t29 = 1.0d+0*t14*t26*t27*t28+1.1102230246251565d-16*t18*t2
     1           0*t24*t25+3.0506411443514264d-19*t17*t22+1.321039893133
     2           9265d-3*t13*t22
              t30 = 1/t2**2
              t31 = 1/rhoa**4.333333333333333d+0
              t32 = 1/rhoa**2.6666666666666666d+0
              t33 = 2.134444128d-101*t30*t31-8.8935172d-51*t3*t32
              t34 = -4.0d-51*t3*t32*t4+9.6d-102*t30*t31*t4+2.4d-51*t1*t3
     1           *t33
              t35 = t24**2
              t36 = 1/t7**5
              t37 = 1/rhoa**2.3333333333333334d+0
              t38 = 1/rhoa**2.1666666666666665d+0
              t39 = t27**2
              t40 = 1/t2**3
              t41 = 1/rhoa**7
              t42 = 1/rhoa**5.333333333333333d+0
              t43 = 1/rhoa**3.6666666666666664d+0
              fnc(iq) = 5.0d-1*rhoa*t19*t5*wght+fnc(iq)
              Amat(iq,D1_RA) = 5.0d-1*rhoa*t29*t5*wght+5.0d-1*t19*t5*wgh
     1           t+5.0d-1*rhoa*t19*t34*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = 5.0d-1*rhoa*(-2.0d+0*t14*t26*t39/t11*
     1           *3+3.216395899738507d+1*t14*t39/(t11**4*t12**2)+1.0d+0*
     2           t14*t26*t28*(2.1622951122684114d+0*t38+1.70877610553209
     3           38d+0*t37+1.2335503316757068d+0*t36+2.673190323653546d-
     4           1*t32)+1.1102230246251565d-16*t18*t20*t25*(1.1632736958
     5           443765d+0*t38+9.89141964955861d-1*t37+6.003214762495226
     6           d-1*t36+2.1077825841639536d-1*t32)-4.0675215258019015d-
     7           19*t17*t37-1.7613865241785684d-3*t13*t37-2.220446049250
     8           313d-16*t18*t20*t35/t15**3+1.7854583920998188d-15*t18*t
     9           35/(t15**4*t16**2)-8.497974591333913d-2*t22*t26*t27*t28
     :           -9.812069668265515d-18*t20*t22*t24*t25)*t5*wght+1.0d+0*
     ;           t29*t5*wght+5.0d-1*rhoa*t19*(2.4d-51*t1*t3*(2.371604586
     <           6666666d-50*t3*t43-1.2806664767999998d-100*t30*t42+1.70
     =           75553024d-151*t40*t41)+1.0666666666666666d-50*t3*t4*t43
     >           -5.76d-101*t30*t4*t42+7.68d-152*t4*t40*t41-8.0d-51*t3*t
     ?           32*t33+1.92d-101*t30*t31*t33)*wght+1.0d+0*rhoa*t29*t34*
     @           wght+1.0d+0*t19*t34*wght+Amat2(iq,D2_RA_RA)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            endif 
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhob**2.6666666666666666d+0
              t2 = 6.0d-2*gammabb*t1+1.0d+0
              t3 = 1/t2
              t4 = 1.3340275799999998d-1*gammabb*t1*t3-2.5960897d+0
              t5 = 6.0d-2*gammabb*t1*t3*t4+1.0d+0
              t6 = 1/rhob**6.666666666666666d-1
              t7 = rhob**5.0d-1
              t8 = 1/t7
              t9 = 1/rhob**3.333333333333333d-1
              t10 = 1/rhob**1.6666666666666666d-1
              t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.4
     1           058712912881916d-1*t6+1.1120374863094686d+1*t10
              t12 = 3.216395899738507d+1/t11+1.0d+0
              t13 = log(t12)
              t14 = 1.274696188700087d-1*t9+1.0d+0
              t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.8
     1           970043257475583d-1*t6+5.982550435771079d+0*t10
              t16 = 1.6081979498692536d+1/t15+1.0d+0
              t17 = log(t16)
              t18 = 1.3256889990520176d-1*t9+1.0d+0
              t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2
     1           *t13*t14
              t20 = 1/taub
              t21 = 1/rhob
              t22 = 2.0d+0*taub-2.5d-1*gammabb*t21
              t23 = 1/t16
              t24 = 1/rhob**1.6666666666666669d+0
              t25 = 1/t7**3
              t26 = 1/rhob**1.3333333333333333d+0
              t27 = 1/rhob**1.1666666666666667d+0
              t28 = -9.970917392951799d-1*t27-7.418564737168958d-1*t26-4
     1           .002143174996817d-1*t25-1.264669550498372d-1*t24
              t29 = 1/t15**2
              t30 = 1/t12
              t31 = -1.8533958105157808d+0*t27-1.2815820791490704d+0*t26
     1           -8.223668877838045d-1*t25-1.6039141941921276d-1*t24
              t32 = 1/t11**2
              t33 = 1.0d+0*t14*t30*t31*t32+1.1102230246251565d-16*t18*t2
     1           3*t28*t29+3.0506411443514264d-19*t17*t26+1.321039893133
     2           9265d-3*t13*t26
              t34 = gammabb**2
              t35 = 1/t2**2
              t36 = 1/rhob**6.333333333333333d+0
              t37 = 1/rhob**3.6666666666666664d+0
              t38 = 2.1344441279999993d-2*t34*t35*t36-3.557406879999999d
     1           -1*gammabb*t3*t37
              t39 = -1.5999999999999998d-1*gammabb*t3*t37*t4+9.599999999
     1           999997d-3*t34*t35*t36*t4+6.0d-2*gammabb*t1*t3*t38
              t40 = 1/rhob**5.333333333333333d+0
              t41 = 1.3340275799999998d-1*t1*t3-8.004165479999998d-3*gam
     1           mabb*t35*t40
              t42 = 6.0d-2*gammabb*t1*t3*t41-3.6d-3*gammabb*t35*t4*t40+6
     1           .0d-2*t1*t3*t4
              t43 = 1/taub**2
              t44 = 1/rhob**2
              t45 = t28**2
              t46 = 1/t7**5
              t47 = 1/rhob**2.3333333333333334d+0
              t48 = 1/rhob**2.1666666666666665d+0
              t49 = t31**2
              t50 = gammabb**3
              t51 = 1/t2**3
              t52 = 1/rhob**10
              t53 = 1/rhob**7.333333333333333d+0
              t54 = 1/rhob**4.666666666666667d+0
              t55 = 1.25d-1*t19*t5*wght
              t56 = 1/rhob**9
              t57 = 1/rhob**8
              fnc(iq) = 5.0d-1*rhob*t19*t20*t22*t5*wght+fnc(iq)
              Amat(iq,D1_RB) = t20*(5.0d-1*rhob*t22*t33*t5*wght+5.0d-1*t
     1           19*t22*t5*wght+5.0d-1*rhob*t19*t22*t39*wght)+1.25d-1*ga
     2           mmabb*t19*t20*t21*t5*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = t20*(5.0d-1*rhob*t19*t22*t42*wght-1.25d-
     1           1*t19*t5*wght)+Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = -5.0d-1*rhob*t19*t22*t43*t5*wght+1.0d+0*r
     1           hob*t19*t20*t5*wght+Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RB_RB) = t20*(5.0d-1*rhob*t19*t22*(6.0d-2*gamm
     1           abb*t1*t3*(1.3043825226666664d+0*gammabb*t3*t54-1.92099
     2           97151999994d-1*t34*t35*t53+6.830221209599997d-3*t50*t51
     3           *t52)+5.866666666666666d-1*gammabb*t3*t4*t54-8.63999999
     4           9999998d-2*t34*t35*t4*t53+3.0719999999999986d-3*t4*t50*
     5           t51*t52-3.1999999999999995d-1*gammabb*t3*t37*t38+1.9199
     6           999999999995d-2*t34*t35*t36*t38)*wght+5.0d-1*rhob*t22*(
     7           -2.0d+0*t14*t30*t49/t11**3+3.216395899738507d+1*t14*t49
     8           /(t11**4*t12**2)+1.0d+0*t14*t30*t32*(2.1622951122684114
     9           d+0*t48+1.7087761055320938d+0*t47+1.2335503316757068d+0
     :           *t46+2.673190323653546d-1*t1)+1.1102230246251565d-16*t1
     ;           8*t23*t29*(1.1632736958443765d+0*t48+9.89141964955861d-
     <           1*t47+6.003214762495226d-1*t46+2.1077825841639536d-1*t1
     =           )-4.0675215258019015d-19*t17*t47-1.7613865241785684d-3*
     >           t13*t47-2.220446049250313d-16*t18*t23*t45/t15**3+1.7854
     ?           583920998188d-15*t18*t45/(t15**4*t16**2)-8.497974591333
     @           913d-2*t26*t30*t31*t32-9.812069668265515d-18*t23*t26*t2
     1           8*t29)*t5*wght+1.25d-1*gammabb*t19*t44*t5*wght+1.0d+0*t
     2           22*t33*t5*wght+1.25d-1*gammabb*t21*t33*t5*wght+1.0d+0*r
     3           hob*t22*t33*t39*wght+1.0d+0*t19*t22*t39*wght+1.25d-1*ga
     4           mmabb*t19*t21*t39*wght)+t20*t21*(1.25d-1*gammabb*t33*t5
     5           *wght+1.25d-1*gammabb*t19*t39*wght)-1.25d-1*gammabb*t19
     6           *t20*t44*t5*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RB_GBB) = t20*(5.0d-1*rhob*t19*t22*(6.0d-2*gam
     1           mabb*t1*t3*(-2.561332953599999d-3*t34*t51*t56-3.5574068
     2           79999999d-1*t3*t37+6.403332383999999d-2*gammabb*t35*t36
     3           )-1.1519999999999996d-3*t34*t4*t51*t56-1.59999999999999
     4           98d-1*gammabb*t3*t37*t41+9.599999999999997d-3*t34*t35*t
     5           36*t41-3.6d-3*gammabb*t35*t38*t40-1.5999999999999998d-1
     6           *t3*t37*t4+2.879999999999999d-2*gammabb*t35*t36*t4+6.0d
     7           -2*t1*t3*t38)*wght-1.25d-1*t33*t5*wght-1.25d-1*t19*t21*
     8           t5*wght+5.0d-1*rhob*t22*t33*t42*wght+5.0d-1*t19*t22*t42
     9           *wght-1.25d-1*t19*t39*wght)+t20*t21*(1.25d-1*gammabb*t1
     :           9*t42*wght+t55)+Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GBB_GBB) = t20*(5.0d-1*rhob*t19*t22*(6.0d-2*ga
     1           mmabb*t1*t3*(9.604998575999998d-4*gammabb*t51*t57-1.600
     2           8330959999997d-2*t35*t40)+4.32d-4*gammabb*t4*t51*t57-7.
     3           2d-3*gammabb*t35*t40*t41+1.2d-1*t1*t3*t41-7.2d-3*t35*t4
     4           *t40)*wght-2.5d-1*t19*t42*wght)+Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = t43*(-5.0d-1*rhob*t22*t33*t5*wght-5.0
     1           d-1*t19*t22*t5*wght-5.0d-1*rhob*t19*t22*t39*wght)+t20*(
     2           1.0d+0*rhob*t33*t5*wght+1.0d+0*t19*t5*wght+1.0d+0*rhob*
     3           t19*t39*wght)-1.25d-1*gammabb*t19*t21*t43*t5*wght+Mmat2
     4           (iq,D2_RB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = t43*(t55-5.0d-1*rhob*t19*t22*t42*wgh
     1           t)+1.0d+0*rhob*t19*t20*t42*wght+Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = 1.0d+0*rhob*t19*t22*t5*wght/taub**3-2
     1           .0d+0*rhob*t19*t43*t5*wght+Mmat2(iq,D2_TB_TB)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = 1/rhob**1.6666666666666669d+0
              t2 = 2.4d-51*t1+1.0d+0
              t3 = 1/t2
              t4 = 5.336110319999999d-51*t1*t3-2.5960897d+0
              t5 = 2.4d-51*t1*t3*t4+1.0d+0
              t6 = 1/rhob**6.666666666666666d-1
              t7 = rhob**5.0d-1
              t8 = 1/t7
              t9 = 1/rhob**3.333333333333333d-1
              t10 = 1/rhob**1.6666666666666666d-1
              t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.4
     1           058712912881916d-1*t6+1.1120374863094686d+1*t10
              t12 = 3.216395899738507d+1/t11+1.0d+0
              t13 = log(t12)
              t14 = 1.274696188700087d-1*t9+1.0d+0
              t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.8
     1           970043257475583d-1*t6+5.982550435771079d+0*t10
              t16 = 1.6081979498692536d+1/t15+1.0d+0
              t17 = log(t16)
              t18 = 1.3256889990520176d-1*t9+1.0d+0
              t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2
     1           *t13*t14
              t20 = 1/t16
              t21 = 1/t7**3
              t22 = 1/rhob**1.3333333333333333d+0
              t23 = 1/rhob**1.1666666666666667d+0
              t24 = -9.970917392951799d-1*t23-7.418564737168958d-1*t22-4
     1           .002143174996817d-1*t21-1.264669550498372d-1*t1
              t25 = 1/t15**2
              t26 = 1/t12
              t27 = -1.8533958105157808d+0*t23-1.2815820791490704d+0*t22
     1           -8.223668877838045d-1*t21-1.6039141941921276d-1*t1
              t28 = 1/t11**2
              t29 = 1.0d+0*t14*t26*t27*t28+1.1102230246251565d-16*t18*t2
     1           0*t24*t25+3.0506411443514264d-19*t17*t22+1.321039893133
     2           9265d-3*t13*t22
              t30 = 1/t2**2
              t31 = 1/rhob**4.333333333333333d+0
              t32 = 1/rhob**2.6666666666666666d+0
              t33 = 2.134444128d-101*t30*t31-8.8935172d-51*t3*t32
              t34 = -4.0d-51*t3*t32*t4+9.6d-102*t30*t31*t4+2.4d-51*t1*t3
     1           *t33
              t35 = t24**2
              t36 = 1/t7**5
              t37 = 1/rhob**2.3333333333333334d+0
              t38 = 1/rhob**2.1666666666666665d+0
              t39 = t27**2
              t40 = 1/t2**3
              t41 = 1/rhob**7
              t42 = 1/rhob**5.333333333333333d+0
              t43 = 1/rhob**3.6666666666666664d+0
              fnc(iq) = 5.0d-1*rhob*t19*t5*wght+fnc(iq)
              Amat(iq,D1_RB) = 5.0d-1*rhob*t29*t5*wght+5.0d-1*t19*t5*wgh
     1           t+5.0d-1*rhob*t19*t34*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RB_RB) = 5.0d-1*rhob*(-2.0d+0*t14*t26*t39/t11*
     1           *3+3.216395899738507d+1*t14*t39/(t11**4*t12**2)+1.0d+0*
     2           t14*t26*t28*(2.1622951122684114d+0*t38+1.70877610553209
     3           38d+0*t37+1.2335503316757068d+0*t36+2.673190323653546d-
     4           1*t32)+1.1102230246251565d-16*t18*t20*t25*(1.1632736958
     5           443765d+0*t38+9.89141964955861d-1*t37+6.003214762495226
     6           d-1*t36+2.1077825841639536d-1*t32)-4.0675215258019015d-
     7           19*t17*t37-1.7613865241785684d-3*t13*t37-2.220446049250
     8           313d-16*t18*t20*t35/t15**3+1.7854583920998188d-15*t18*t
     9           35/(t15**4*t16**2)-8.497974591333913d-2*t22*t26*t27*t28
     :           -9.812069668265515d-18*t20*t22*t24*t25)*t5*wght+1.0d+0*
     ;           t29*t5*wght+5.0d-1*rhob*t19*(2.4d-51*t1*t3*(2.371604586
     <           6666666d-50*t3*t43-1.2806664767999998d-100*t30*t42+1.70
     =           75553024d-151*t40*t41)+1.0666666666666666d-50*t3*t4*t43
     >           -5.76d-101*t30*t4*t42+7.68d-152*t4*t40*t41-8.0d-51*t3*t
     ?           32*t33+1.92d-101*t30*t31*t33)*wght+1.0d+0*rhob*t29*t34*
     @           wght+1.0d+0*t19*t34*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhob**2.6666666666666666d+0
              t2 = 6.0d-2*gammabb*t1+1.0d+0
              t3 = 1/t2
              t4 = 1.3340275799999998d-1*gammabb*t1*t3-2.5960897d+0
              t5 = 6.0d-2*gammabb*t1*t3*t4+1.0d+0
              t6 = 1/rhob**6.666666666666666d-1
              t7 = rhob**5.0d-1
              t8 = 1/t7
              t9 = 1/rhob**3.333333333333333d-1
              t10 = 1/rhob**1.6666666666666666d-1
              t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.4
     1           058712912881916d-1*t6+1.1120374863094686d+1*t10
              t12 = 3.216395899738507d+1/t11+1.0d+0
              t13 = log(t12)
              t14 = 1.274696188700087d-1*t9+1.0d+0
              t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.8
     1           970043257475583d-1*t6+5.982550435771079d+0*t10
              t16 = 1.6081979498692536d+1/t15+1.0d+0
              t17 = log(t16)
              t18 = 1.3256889990520176d-1*t9+1.0d+0
              t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2
     1           *t13*t14
              t20 = 1/taub
              t21 = 1/rhob
              t22 = 2.0d+0*taub-2.5d-1*gammabb*t21
              t23 = 1/t16
              t24 = 1/rhob**1.6666666666666669d+0
              t25 = 1/t7**3
              t26 = 1/rhob**1.3333333333333333d+0
              t27 = 1/rhob**1.1666666666666667d+0
              t28 = -9.970917392951799d-1*t27-7.418564737168958d-1*t26-4
     1           .002143174996817d-1*t25-1.264669550498372d-1*t24
              t29 = 1/t15**2
              t30 = 1/t12
              t31 = -1.8533958105157808d+0*t27-1.2815820791490704d+0*t26
     1           -8.223668877838045d-1*t25-1.6039141941921276d-1*t24
              t32 = 1/t11**2
              t33 = 1.0d+0*t14*t30*t31*t32+1.1102230246251565d-16*t18*t2
     1           3*t28*t29+3.0506411443514264d-19*t17*t26+1.321039893133
     2           9265d-3*t13*t26
              t34 = gammabb**2
              t35 = 1/t2**2
              t36 = 1/rhob**6.333333333333333d+0
              t37 = 1/rhob**3.6666666666666664d+0
              t38 = 2.1344441279999993d-2*t34*t35*t36-3.557406879999999d
     1           -1*gammabb*t3*t37
              t39 = -1.5999999999999998d-1*gammabb*t3*t37*t4+9.599999999
     1           999997d-3*t34*t35*t36*t4+6.0d-2*gammabb*t1*t3*t38
              t40 = 1/rhob**5.333333333333333d+0
              t41 = 1.3340275799999998d-1*t1*t3-8.004165479999998d-3*gam
     1           mabb*t35*t40
              t42 = 6.0d-2*gammabb*t1*t3*t41-3.6d-3*gammabb*t35*t4*t40+6
     1           .0d-2*t1*t3*t4
              t43 = 1/taub**2
              t44 = 1/rhob**2
              t45 = t28**2
              t46 = 1/t7**5
              t47 = 1/rhob**2.3333333333333334d+0
              t48 = 1/rhob**2.1666666666666665d+0
              t49 = t31**2
              t50 = gammabb**3
              t51 = 1/t2**3
              t52 = 1/rhob**10
              t53 = 1/rhob**7.333333333333333d+0
              t54 = 1/rhob**4.666666666666667d+0
              t55 = 1.25d-1*t19*t5*wght
              t56 = 1/rhob**9
              t57 = 1/rhob**8
              fnc(iq) = 5.0d-1*rhob*t19*t20*t22*t5*wght+fnc(iq)
              Amat(iq,D1_RB) = t20*(5.0d-1*rhob*t22*t33*t5*wght+5.0d-1*t
     1           19*t22*t5*wght+5.0d-1*rhob*t19*t22*t39*wght)+1.25d-1*ga
     2           mmabb*t19*t20*t21*t5*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = t20*(5.0d-1*rhob*t19*t22*t42*wght-1.25d-
     1           1*t19*t5*wght)+Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = -5.0d-1*rhob*t19*t22*t43*t5*wght+1.0d+0*r
     1           hob*t19*t20*t5*wght+Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RB_RB) = t20*(5.0d-1*rhob*t19*t22*(6.0d-2*gamm
     1           abb*t1*t3*(1.3043825226666664d+0*gammabb*t3*t54-1.92099
     2           97151999994d-1*t34*t35*t53+6.830221209599997d-3*t50*t51
     3           *t52)+5.866666666666666d-1*gammabb*t3*t4*t54-8.63999999
     4           9999998d-2*t34*t35*t4*t53+3.0719999999999986d-3*t4*t50*
     5           t51*t52-3.1999999999999995d-1*gammabb*t3*t37*t38+1.9199
     6           999999999995d-2*t34*t35*t36*t38)*wght+5.0d-1*rhob*t22*(
     7           -2.0d+0*t14*t30*t49/t11**3+3.216395899738507d+1*t14*t49
     8           /(t11**4*t12**2)+1.0d+0*t14*t30*t32*(2.1622951122684114
     9           d+0*t48+1.7087761055320938d+0*t47+1.2335503316757068d+0
     :           *t46+2.673190323653546d-1*t1)+1.1102230246251565d-16*t1
     ;           8*t23*t29*(1.1632736958443765d+0*t48+9.89141964955861d-
     <           1*t47+6.003214762495226d-1*t46+2.1077825841639536d-1*t1
     =           )-4.0675215258019015d-19*t17*t47-1.7613865241785684d-3*
     >           t13*t47-2.220446049250313d-16*t18*t23*t45/t15**3+1.7854
     ?           583920998188d-15*t18*t45/(t15**4*t16**2)-8.497974591333
     @           913d-2*t26*t30*t31*t32-9.812069668265515d-18*t23*t26*t2
     1           8*t29)*t5*wght+1.25d-1*gammabb*t19*t44*t5*wght+1.0d+0*t
     2           22*t33*t5*wght+1.25d-1*gammabb*t21*t33*t5*wght+1.0d+0*r
     3           hob*t22*t33*t39*wght+1.0d+0*t19*t22*t39*wght+1.25d-1*ga
     4           mmabb*t19*t21*t39*wght)+t20*t21*(1.25d-1*gammabb*t33*t5
     5           *wght+1.25d-1*gammabb*t19*t39*wght)-1.25d-1*gammabb*t19
     6           *t20*t44*t5*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RB_GBB) = t20*(5.0d-1*rhob*t19*t22*(6.0d-2*gam
     1           mabb*t1*t3*(-2.561332953599999d-3*t34*t51*t56-3.5574068
     2           79999999d-1*t3*t37+6.403332383999999d-2*gammabb*t35*t36
     3           )-1.1519999999999996d-3*t34*t4*t51*t56-1.59999999999999
     4           98d-1*gammabb*t3*t37*t41+9.599999999999997d-3*t34*t35*t
     5           36*t41-3.6d-3*gammabb*t35*t38*t40-1.5999999999999998d-1
     6           *t3*t37*t4+2.879999999999999d-2*gammabb*t35*t36*t4+6.0d
     7           -2*t1*t3*t38)*wght-1.25d-1*t33*t5*wght-1.25d-1*t19*t21*
     8           t5*wght+5.0d-1*rhob*t22*t33*t42*wght+5.0d-1*t19*t22*t42
     9           *wght-1.25d-1*t19*t39*wght)+t20*t21*(1.25d-1*gammabb*t1
     :           9*t42*wght+t55)+Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GBB_GBB) = t20*(5.0d-1*rhob*t19*t22*(6.0d-2*ga
     1           mmabb*t1*t3*(9.604998575999998d-4*gammabb*t51*t57-1.600
     2           8330959999997d-2*t35*t40)+4.32d-4*gammabb*t4*t51*t57-7.
     3           2d-3*gammabb*t35*t40*t41+1.2d-1*t1*t3*t41-7.2d-3*t35*t4
     4           *t40)*wght-2.5d-1*t19*t42*wght)+Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = t43*(-5.0d-1*rhob*t22*t33*t5*wght-5.0
     1           d-1*t19*t22*t5*wght-5.0d-1*rhob*t19*t22*t39*wght)+t20*(
     2           1.0d+0*rhob*t33*t5*wght+1.0d+0*t19*t5*wght+1.0d+0*rhob*
     3           t19*t39*wght)-1.25d-1*gammabb*t19*t21*t43*t5*wght+Mmat2
     4           (iq,D2_RB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = t43*(t55-5.0d-1*rhob*t19*t22*t42*wgh
     1           t)+1.0d+0*rhob*t19*t20*t42*wght+Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = 1.0d+0*rhob*t19*t22*t5*wght/taub**3-2
     1           .0d+0*rhob*t19*t43*t5*wght+Mmat2(iq,D2_TB_TB)
            else 
              t1 = 1/rhob**1.6666666666666669d+0
              t2 = 2.4d-51*t1+1.0d+0
              t3 = 1/t2
              t4 = 5.336110319999999d-51*t1*t3-2.5960897d+0
              t5 = 2.4d-51*t1*t3*t4+1.0d+0
              t6 = 1/rhob**6.666666666666666d-1
              t7 = rhob**5.0d-1
              t8 = 1/t7
              t9 = 1/rhob**3.333333333333333d-1
              t10 = 1/rhob**1.6666666666666666d-1
              t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.4
     1           058712912881916d-1*t6+1.1120374863094686d+1*t10
              t12 = 3.216395899738507d+1/t11+1.0d+0
              t13 = log(t12)
              t14 = 1.274696188700087d-1*t9+1.0d+0
              t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.8
     1           970043257475583d-1*t6+5.982550435771079d+0*t10
              t16 = 1.6081979498692536d+1/t15+1.0d+0
              t17 = log(t16)
              t18 = 1.3256889990520176d-1*t9+1.0d+0
              t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2
     1           *t13*t14
              t20 = 1/t16
              t21 = 1/t7**3
              t22 = 1/rhob**1.3333333333333333d+0
              t23 = 1/rhob**1.1666666666666667d+0
              t24 = -9.970917392951799d-1*t23-7.418564737168958d-1*t22-4
     1           .002143174996817d-1*t21-1.264669550498372d-1*t1
              t25 = 1/t15**2
              t26 = 1/t12
              t27 = -1.8533958105157808d+0*t23-1.2815820791490704d+0*t22
     1           -8.223668877838045d-1*t21-1.6039141941921276d-1*t1
              t28 = 1/t11**2
              t29 = 1.0d+0*t14*t26*t27*t28+1.1102230246251565d-16*t18*t2
     1           0*t24*t25+3.0506411443514264d-19*t17*t22+1.321039893133
     2           9265d-3*t13*t22
              t30 = 1/t2**2
              t31 = 1/rhob**4.333333333333333d+0
              t32 = 1/rhob**2.6666666666666666d+0
              t33 = 2.134444128d-101*t30*t31-8.8935172d-51*t3*t32
              t34 = -4.0d-51*t3*t32*t4+9.6d-102*t30*t31*t4+2.4d-51*t1*t3
     1           *t33
              t35 = t24**2
              t36 = 1/t7**5
              t37 = 1/rhob**2.3333333333333334d+0
              t38 = 1/rhob**2.1666666666666665d+0
              t39 = t27**2
              t40 = 1/t2**3
              t41 = 1/rhob**7
              t42 = 1/rhob**5.333333333333333d+0
              t43 = 1/rhob**3.6666666666666664d+0
              fnc(iq) = 5.0d-1*rhob*t19*t5*wght+fnc(iq)
              Amat(iq,D1_RB) = 5.0d-1*rhob*t29*t5*wght+5.0d-1*t19*t5*wgh
     1           t+5.0d-1*rhob*t19*t34*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RB_RB) = 5.0d-1*rhob*(-2.0d+0*t14*t26*t39/t11*
     1           *3+3.216395899738507d+1*t14*t39/(t11**4*t12**2)+1.0d+0*
     2           t14*t26*t28*(2.1622951122684114d+0*t38+1.70877610553209
     3           38d+0*t37+1.2335503316757068d+0*t36+2.673190323653546d-
     4           1*t32)+1.1102230246251565d-16*t18*t20*t25*(1.1632736958
     5           443765d+0*t38+9.89141964955861d-1*t37+6.003214762495226
     6           d-1*t36+2.1077825841639536d-1*t32)-4.0675215258019015d-
     7           19*t17*t37-1.7613865241785684d-3*t13*t37-2.220446049250
     8           313d-16*t18*t20*t35/t15**3+1.7854583920998188d-15*t18*t
     9           35/(t15**4*t16**2)-8.497974591333913d-2*t22*t26*t27*t28
     :           -9.812069668265515d-18*t20*t22*t24*t25)*t5*wght+1.0d+0*
     ;           t29*t5*wght+5.0d-1*rhob*t19*(2.4d-51*t1*t3*(2.371604586
     <           6666666d-50*t3*t43-1.2806664767999998d-100*t30*t42+1.70
     =           75553024d-151*t40*t41)+1.0666666666666666d-50*t3*t4*t43
     >           -5.76d-101*t30*t4*t42+7.68d-152*t4*t40*t41-8.0d-51*t3*t
     ?           32*t33+1.92d-101*t30*t31*t33)*wght+1.0d+0*rhob*t29*t34*
     @           wght+1.0d+0*t19*t34*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            endif 
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_c_dldf functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& {{1}\over{\rho_\alpha^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_2} &=& {{1}\over{\sqrt{\rho_\alpha}}}\\\\ 
C>   {\it t_3} &=& {{1}\over{\rho_\alpha^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_4} &=& {{1}\over{\rho_\alpha^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_5} &=& -6.903522198342671 \times 10^{-18}\,\log 
C>    \left({{16.08197949869254}\over{5.98255043577108\,{\it t_4}
C>    +2.225569421150687\,{\it t_3}+0.8004286349993635\,{\it t_2}
C>    +0.1897004325747558\,{\it t_1}}}+1.0\right)\,
C>    \left(0.1325688999052018\,{\it t_3}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_4}+3.844746237447211\,{\it t_3}+1.644733775567609\,{
C>    \it t_2}+0.2405871291288192\,{\it t_1}}}+1.0\right)\,
C>    \left(0.1274696188700087\,{\it t_3}+1.0\right)\\\\ 
C>   {\it t_6} &=& {{1}\over{\rho_\beta^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_7} &=& {{1}\over{\sqrt{\rho_\beta}}}\\\\ 
C>   {\it t_8} &=& {{1}\over{\rho_\beta^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_9} &=& {{1}\over{\rho_\beta^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{10}} &=& -6.903522198342671 \times 10^{-18}
C>    \,\log \left({{16.08197949869254}\over{5.98255043577108\,{
C>    \it t_9}+2.225569421150687\,{\it t_8}+0.8004286349993635\,{
C>    \it t_7}+0.1897004325747558\,{\it t_6}}}+1.0\right)\,
C>    \left(0.1325688999052018\,{\it t_8}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_9}+3.844746237447211\,{\it t_8}+1.644733775567609\,{
C>    \it t_7}+0.2405871291288192\,{\it t_6}}}+1.0\right)\,
C>    \left(0.1274696188700087\,{\it t_8}+1.0\right)\\\\ 
C>   {\it t_{11}} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_{12}} &=& {{1}\over{{\it t_{11}}^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{13}} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_{14}} &=& {\it t_{13}}^4\\\\ 
C>   {\it t_{15}} &=& {{1}\over{{\it t_{11}}^4}}\\\\ 
C>   {\it t_{16}} &=& {{1}\over{{\it t_{11}}}}\\\\ 
C>   {\it t_{17}} &=& \left({\it t_{13}}\,{\it t_{16}}
C>    +1.0\right)^{{{4}\over{3}}}+\left(1.0-{\it t_{13}}\,{
C>    \it t_{16}}\right)^{{{4}\over{3}}}-2.0\\\\ 
C>   {\it t_{18}} &=& -1.923661050931536\,{\it t_{14}}\,{\it t_{15}}
C>    \,{\it t_{17}}\\\\ 
C>   {\it t_{19}} &=& {{1}\over{{\it t_{11}}^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{20}} &=& {{1}\over{\sqrt{{\it t_{11}}}}}\\\\ 
C>   {\it t_{21}} &=& {{1}\over{{\it t_{11}}^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{22}} &=& {{1}\over{\rho_\alpha^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{23}} &=& {{1}\over{\rho_\beta^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{24}} &=& {\it t_{23}}\,\sigma_{\beta\beta}+{\it t_{22}}
C>    \,\sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{25}} &=& {{1}\over{0.0031\,{\it t_{24}}+1.0}}\\\\ 
C>   {\it t_{26}} &=& {{1}\over{0.06\,{\it t_{22}}\,
C>    \sigma_{\alpha\alpha}+1.0}}\\\\ 
C>   {\it t_{27}} &=& {{1}\over{0.06\,{\it t_{23}}\,
C>    \sigma_{\beta\beta}+1.0}}\\\\ 
C>   {\it t_{28}} &=& {{1}\over{\rho_s^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{29}} &=& {{1}\over{\sqrt{\rho_s}}}\\\\ 
C>   {\it t_{30}} &=& {{1}\over{\rho_s^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{31}} &=& {{1}\over{\rho_s^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{32}} &=& {{1}\over{\rho_s^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{33}} &=& {{1}\over{0.06\,{\it t_{32}}\,\sigma_{ss}
C>    +1.0}}\\\\ 
C>   f &=& {{0.5\,{\it t_{10}}\,\rho_\beta\,\left(0.06\,{\it t_{23}}
C>    \,\sigma_{\beta\beta}\,{\it t_{27}}\,\left(0.133402758\,{
C>    \it t_{23}}\,\sigma_{\beta\beta}\,{\it t_{27}}-2.5960897\right)
C>    +1.0\right)\,\left(2.0\,\tau_\beta-{{0.25\,
C>    \sigma_{\beta\beta}}\over{\rho_\beta}}\right)}\over{\tau_\beta}}
C>    +{{0.5\,{\it t_5}\,\rho_\alpha\,\left(0.06\,{\it t_{22}}
C>    \,\sigma_{\alpha\alpha}\,{\it t_{26}}\,\left(0.133402758\,{
C>    \it t_{22}}\,\sigma_{\alpha\alpha}\,{\it t_{26}}
C>    -2.5960897\right)+1.0\right)\,\left(2.0\,\tau_\alpha-{{0.25
C>    \,\sigma_{\alpha\alpha}}\over{\rho_\alpha}}\right)}
C>    \over{\tau_\alpha}}+1.0\,\left({\it t_{11}}\,\left(
C>    -0.0598079686361971\,{\it t_{14}}\,{\it t_{15}}\,
C>    \left(0.1274696188700087\,{\it t_{12}}+1.0\right)\,{
C>    \it t_{17}}\,\log \left({{32.16395899738507}
C>    \over{11.12037486309469\,{\it t_{21}}+3.844746237447211\,{
C>    \it t_{12}}+1.644733775567609\,{\it t_{20}}+0.2405871291288192
C>    \,{\it t_{19}}}}+1.0\right)+0.01975163132168077\,
C>    \left(0.06901399211255825\,{\it t_{12}}+1.0\right)\,\left({
C>    \it t_{18}}+1.923661050931536\,{\it t_{17}}\right)
C>    \,\log \left({{29.60881320326807}\over{8.15741470348764\,{
C>    \it t_{21}}+2.247591863577616\,{\it t_{12}}+0.4300972471276643
C>    \,{\it t_{20}}+0.1911512595127337\,{\it t_{19}}}}+1.0\right)
C>    -0.0621814\,\left(0.1325688999052018\,{\it t_{12}}+1.0\right)
C>    \,\left({\it t_{18}}+1.0\right)\,\log 
C>    \left({{16.08197949869254}\over{5.98255043577108\,{\it t_{21}}
C>    +2.225569421150687\,{\it t_{12}}+0.8004286349993635\,{
C>    \it t_{20}}+0.1897004325747558\,{\it t_{19}}}}+1.0\right)\right)
C>    -{\it t_{10}}\,\rho_\beta-{\it t_5}\,\rho_\alpha\right)
C>    \,\left(0.0031\,{\it t_{24}}\,{\it t_{25}}\,\left(5.9515308
C>    -0.03459689187\,{\it t_{24}}\,{\it t_{25}}\right)+1.0\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& {{0.5\,\left(-6.903522198342671 \times 10^{-18}
C>    \,\log \left({{16.08197949869254}\over{5.98255043577108\,{
C>    \it t_{31}}+2.225569421150687\,{\it t_{30}}+0.8004286349993635
C>    \,{\it t_{29}}+0.1897004325747558\,{\it t_{28}}}}+1.0\right)
C>    \,\left(0.1325688999052018\,{\it t_{30}}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_{31}}+3.844746237447211\,{\it t_{30}}+1.644733775567609
C>    \,{\it t_{29}}+0.2405871291288192\,{\it t_{28}}}}+1.0\right)
C>    \,\left(0.1274696188700087\,{\it t_{30}}+1.0\right)\right)
C>    \,\rho_s\,\left(0.06\,{\it t_{32}}\,\sigma_{ss}\,{\it t_{33}}
C>    \,\left(0.133402758\,{\it t_{32}}\,\sigma_{ss}\,{\it t_{33}}
C>    -2.5960897\right)+1.0\right)\,\left(2.0\,\tau_s-{{0.25
C>    \,\sigma_{ss}}\over{\rho_s}}\right)}\over{\tau_s}}\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc-Ds [3]. 
C> 
C> ### References ### 
C> 
C> [1] K Pernal, R Podeszwa, K Patkowski, K Szalewicz
C>    , Phys.Rev.Lett. 103, 263201 (2009)  , DOI: 
C> <a href="https://doi.org/10.1103/PhysRevLett.103.263201 "> 
C> 10.1103/PhysRevLett.103.263201 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc-Ds, revision 27207 2015-06-23 
C> 
      subroutine nwxcm_c_dldf_d3(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,tau,fnc,Amat,Amat2,Amat3, 
     +Cmat,Cmat2,Cmat3,Mmat,Mmat2,Mmat3) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,NCOL_RHO)      !< [Input] The density 
      double precision rgamma(nq,NCOL_GAMMA) !< [Input] The norm of the density 
                                             !< gradients 
      double precision tau(nq,NCOL_TAU)      !< [Input] The kinetic energy density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,NCOL_AMAT)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,NCOL_CMAT)   !< [Output] The derivative wrt rgamma 
      double precision Mmat(nq,NCOL_MMAT)   !< [Output] The derivative wrt tau 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,NCOL_AMAT2)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,NCOL_CMAT2)  !< [Output] The 2nd derivative wrt rgamma 
                                             !< and possibly rho 
      double precision Mmat2(nq,NCOL_MMAT2)  !< [Output] The 2nd derivative wrt tau 
                                             !< and possibly rho 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat3(nq,NCOL_AMAT3)  !< [Output] The 3rd derivative wrt rho 
      double precision Cmat3(nq,NCOL_CMAT3)  !< [Output] The 3rd derivative wrt rgamma 
                                             !< and possibly rho 
      double precision Mmat3(nq,NCOL_MMAT3)  !< [Output] The 3rd derivative wrt tau 
                                             !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          taua    = 0.5d0*tau(iq,T_T) 
          if (rhoa.gt.tol_rho) then 
            if (taua.gt.tol_rho) then 
              t1 = 1/rhoa**2.6666666666666666d+0
              t2 = 6.2d-3*gammaaa*t1+1.0d+0
              t3 = 1/t2
              t4 = 5.9515308d+0-6.919378374d-2*gammaaa*t1*t3
              t5 = 6.2d-3*gammaaa*t1*t3*t4+1.0d+0
              t6 = 1/rhoa**6.666666666666666d-1
              t7 = rhoa**5.0d-1
              t8 = 1/t7
              t9 = 1/rhoa**3.333333333333333d-1
              t10 = 1/rhoa**1.6666666666666666d-1
              t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.4
     1           058712912881916d-1*t6+1.1120374863094686d+1*t10
              t12 = 3.216395899738507d+1/t11+1.0d+0
              t13 = log(t12)
              t14 = 1.274696188700087d-1*t9+1.0d+0
              t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.8
     1           970043257475583d-1*t6+5.982550435771079d+0*t10
              t16 = 1.6081979498692536d+1/t15+1.0d+0
              t17 = log(t16)
              t18 = 1.3256889990520176d-1*t9+1.0d+0
              t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2
     1           *t13*t14
              t20 = -2*rhoa*t19
              t21 = 6.0d-2*gammaaa*t1+1.0d+0
              t22 = 1/t21
              t23 = 1.3340275799999998d-1*gammaaa*t1*t22-2.5960897d+0
              t24 = 6.0d-2*gammaaa*t1*t22*t23+1.0d+0
              t25 = 1/taua
              t26 = 1/rhoa
              t27 = 2.0d+0*taua-2.5d-1*gammaaa*t26
              t28 = 6.299605249474366d-1
              t29 = 1.414213562373095d+0
              t30 = 1/t29
              t31 = 7.937005259840998d-1
              t32 = 8.908987181403393d-1
              t33 = 2.2255694211506874d+0*t31*t9+8.004286349993635d-1*t3
     1           0*t8+1.8970043257475583d-1*t28*t6+5.982550435771079d+0*
     2           t10*t32
              t34 = 1.6081979498692536d+1/t33+1.0d+0
              t35 = log(t34)
              t36 = 1.3256889990520176d-1*t31*t9+1.0d+0
              t37 = 1/t16
              t38 = 1/rhoa**1.6666666666666669d+0
              t39 = 1/t7**3
              t40 = 1/rhoa**1.3333333333333333d+0
              t41 = 1/rhoa**1.1666666666666667d+0
              t42 = -9.970917392951799d-1*t41-7.418564737168958d-1*t40-4
     1           .002143174996817d-1*t39-1.264669550498372d-1*t38
              t43 = 1/t15**2
              t44 = 1/t12
              t45 = -1.8533958105157808d+0*t41-1.2815820791490704d+0*t40
     1           -8.223668877838045d-1*t39-1.6039141941921276d-1*t38
              t46 = 1/t11**2
              t47 = 1.0d+0*t14*t44*t45*t46+1.1102230246251565d-16*t18*t3
     1           7*t42*t43+3.0506411443514264d-19*t17*t40+1.321039893133
     2           9265d-3*t13*t40
              t48 = 1/t34
              t49 = 3.149802624737183d-1
              t50 = 1/t29**3
              t51 = 3.968502629920499d-1
              t52 = 4.4544935907016964d-1
              t53 = -9.970917392951799d-1*t41*t52-7.418564737168958d-1*t
     1           40*t51-4.002143174996817d-1*t39*t50-1.264669550498372d-
     2           1*t38*t49
              t54 = 1/t33**2
              t55 = 2*rhoa*(1.0d+0*t36*t48*t53*t54+2.747773264188437d-3*
     1           t35*t40*t51)-rhoa*t47-6.21814d-2*t35*t36+6.903522198342
     2           671d-18*t17*t18+3.1090699999999993d-2*t13*t14
              t56 = gammaaa**2
              t57 = 1/t2**2
              t58 = 1/rhoa**6.333333333333333d+0
              t59 = 1/rhoa**3.6666666666666664d+0
              t60 = 9.225837832d-2*gammaaa*t3*t59-5.72001945584d-4*t56*t
     1           57*t58
              t61 = 6.2d-3*gammaaa*t1*t3*t60-8.266666666666665d-3*gammaa
     1           a*t3*t4*t59+5.125333333333332d-5*t4*t56*t57*t58
              t62 = t20-1.243628d-1*rhoa*t35*t36
              t63 = 1/t21**2
              t64 = 2.1344441279999993d-2*t56*t58*t63-3.557406879999999d
     1           -1*gammaaa*t22*t59
              t65 = 6.0d-2*gammaaa*t1*t22*t64+9.599999999999997d-3*t23*t
     1           56*t58*t63-1.5999999999999998d-1*gammaaa*t22*t23*t59
              t66 = 1/rhoa**5.333333333333333d+0
              t67 = 2.14500729594d-4*gammaaa*t57*t66-3.459689187d-2*t1*t
     1           3
              t68 = 6.2d-3*gammaaa*t1*t3*t67-1.9219999999999998d-5*gamma
     1           aa*t4*t57*t66+3.1d-3*t1*t3*t4
              t69 = -1.25d-1*t19*t24
              t70 = 1.3340275799999998d-1*t1*t22-8.004165479999998d-3*ga
     1           mmaaa*t63*t66
              t71 = 6.0d-2*gammaaa*t1*t22*t70-3.6d-3*gammaaa*t23*t63*t66
     1           +6.0d-2*t1*t22*t23
              t72 = 1/taua**2
              t73 = 2.0d+0*t55*t61
              t74 = 2.0d+0*t36*t48*t53*t54
              t75 = 5.495546528376875d-3*t35*t40*t51
              t76 = 1/t16**2
              t77 = t42**2
              t78 = 1/t15**4
              t79 = 1/t15**3
              t80 = 1/t7**5
              t81 = 1/rhoa**2.3333333333333334d+0
              t82 = 1/rhoa**2.1666666666666665d+0
              t83 = 1.1632736958443765d+0*t82+9.89141964955861d-1*t81+6.
     1           003214762495226d-1*t80+2.1077825841639536d-1*t1
              t84 = 1/t12**2
              t85 = t45**2
              t86 = 1/t11**4
              t87 = 1/t11**3
              t88 = 2.1622951122684114d+0*t82+1.7087761055320938d+0*t81+
     1           1.2335503316757068d+0*t80+2.673190323653546d-1*t1
              t89 = 1.0d+0*t14*t44*t46*t88-2.0d+0*t14*t44*t85*t87+3.2163
     1           95899738507d+1*t14*t84*t85*t86+1.1102230246251565d-16*t
     2           18*t37*t43*t83-4.0675215258019015d-19*t17*t81-1.7613865
     3           241785684d-3*t13*t81-2.220446049250313d-16*t18*t37*t77*
     4           t79+1.7854583920998188d-15*t18*t76*t77*t78-8.4979745913
     5           33913d-2*t40*t44*t45*t46-9.812069668265515d-18*t37*t40*
     6           t42*t43
              t90 = 1/t34**2
              t91 = t53**2
              t92 = 1/t33**4
              t93 = 1.6081979498692536d+1*t36*t90*t91*t92
              t94 = 1/t33**3
              t95 = -2.0d+0*t36*t48*t91*t94
              t96 = 1.9842513149602492d-1
              t97 = 9.89141964955861d-1*t81*t96+2.5908976111853255d-1*t8
     1           2+6.003214762495226d-1*t80/t29**5+3.319549557987472d-2*
     2           t1
              t98 = 1.0d+0*t36*t48*t54*t97
              t99 = -3.663697685584583d-3*t35*t81*t96
              t100 = 2.247591863577616d+0*t31*t9+4.3009724712766434d-1*t
     1           30*t8+1.9115125951273373d-1*t28*t6+8.157414703487641d+0
     2           *t10*t32
              t101 = 2.9608813203268075d+1/t100+1.0d+0
              t102 = log(t101)
              t103 = 6.901399211255825d-2*t31*t9+1.0d+0
              t104 = 1/rhoa**2
              t105 = -8.837926660346784d-2*t40*t48*t51*t53*t54
              t106 = 2*rhoa*(t99+t98+t95+t93+t105+8.443431970194815d-3*t
     1           102*t103*t104)-rhoa*t89+t75+t74-2.0d+0*t14*t44*t45*t46-
     2           2.220446049250313d-16*t18*t37*t42*t43-6.101282288702853
     3           d-19*t17*t40-2.642079786267853d-3*t13*t40
              t107 = gammaaa**3
              t108 = 1/t2**3
              t109 = 1/rhoa**10
              t110 = 8.473884444444441d-7*t107*t108*t109*t4
              t111 = 1/rhoa**7.333333333333333d+0
              t112 = 1.0250666666666663d-4*t56*t57*t58*t60
              t113 = 1/rhoa**4.666666666666667d+0
              t114 = -1.653333333333333d-2*gammaaa*t3*t59*t60
              t115 = -9.457098833655464d-6*t107*t108*t109
              t116 = 3.622678988698666d-3*t111*t56*t57-3.382807205066666
     1           3d-1*gammaaa*t113*t3+t115
              t117 = -3.2460444444444436d-4*t111*t4*t56*t57+3.0311111111
     1           111105d-2*gammaaa*t113*t3*t4+6.2d-3*gammaaa*t1*t116*t3+
     2           t114+t112+t110
              t118 = 1/t21**3
              t119 = -1.9209997151999994d-1*t111*t56*t63+1.3043825226666
     1           664d+0*gammaaa*t113*t22+6.830221209599997d-3*t107*t109*
     2           t118
              t120 = 1.9199999999999995d-2*t56*t58*t63*t64-3.19999999999
     1           99995d-1*gammaaa*t22*t59*t64-8.639999999999998d-2*t111*
     2           t23*t56*t63+5.866666666666666d-1*gammaaa*t113*t22*t23+3
     3           .0719999999999986d-3*t107*t109*t118*t23+6.0d-2*gammaaa*
     4           t1*t119*t22
              t121 = -8.443431970194815d-3*t102*t103*t104
              t122 = 2*rhoa*(t99+t98+t95+t93+t121+t105)+t75+t74
              t123 = 1.525338521557333d-3*t111*t56*t57+t115
              t124 = -1.366755555555555d-4*t111*t4*t56*t57+6.2d-3*gammaa
     1           a*t1*t123*t3+t114+t112+t110
              t125 = 1.0d+0*t55*t68
              t126 = 1/rhoa**9
              t127 = -3.1777066666666653d-7*t108*t126*t4*t56
              t128 = 5.125333333333332d-5*t56*t57*t58*t67
              t129 = -1.9219999999999998d-5*gammaaa*t57*t60*t66
              t130 = -8.266666666666665d-3*gammaaa*t3*t59*t67
              t131 = 3.5464120626207996d-6*t108*t126*t56
              t132 = 9.225837832d-2*t3*t59-1.1440038911679998d-3*gammaaa
     1           *t57*t58+t131
              t133 = 3.1d-3*t1*t3*t60
              t134 = -8.266666666666665d-3*t3*t4*t59+1.0250666666666663d
     1           -4*gammaaa*t4*t57*t58+6.2d-3*gammaaa*t1*t132*t3+t133+t1
     2           30+t129+t128+t127
              t135 = 1.25d-1*t19*t24
              t136 = 6.403332383999999d-2*gammaaa*t58*t63-3.557406879999
     1           999d-1*t22*t59-2.561332953599999d-3*t118*t126*t56
              t137 = 9.599999999999997d-3*t56*t58*t63*t70-1.599999999999
     1           9998d-1*gammaaa*t22*t59*t70-3.6d-3*gammaaa*t63*t64*t66+
     2           6.0d-2*t1*t22*t64+2.879999999999999d-2*gammaaa*t23*t58*
     3           t63-1.5999999999999998d-1*t22*t23*t59-1.151999999999999
     4           6d-3*t118*t126*t23*t56+6.0d-2*gammaaa*t1*t136*t22
              t138 = t131-5.72001945584d-4*gammaaa*t57*t58
              t139 = 5.125333333333332d-5*gammaaa*t4*t57*t58+6.2d-3*gamm
     1           aaa*t1*t138*t3+t133+t130+t129+t128+t127
              t140 = 1/rhoa**8
              t141 = 2.14500729594d-4*t57*t66-1.3299045234828d-6*gammaaa
     1           *t108*t140
              t142 = -3.8439999999999996d-5*gammaaa*t57*t66*t67+6.2d-3*t
     1           1*t3*t67-1.9219999999999998d-5*t4*t57*t66+1.19163999999
     2           99999d-7*gammaaa*t108*t140*t4+6.2d-3*gammaaa*t1*t141*t3
              t143 = 9.604998575999998d-4*gammaaa*t118*t140-1.6008330959
     1           999997d-2*t63*t66
              t144 = -7.2d-3*gammaaa*t63*t66*t70+1.2d-1*t1*t22*t70-7.2d-
     1           3*t23*t63*t66+4.32d-4*gammaaa*t118*t140*t23+6.0d-2*gamm
     2           aaa*t1*t143*t22
              t145 = 1/taua**3
              t146 = 4.824593849607761d+1*t36*t90*t91*t92
              t147 = -6.0d+0*t36*t48*t91*t94
              t148 = 3.0d+0*t36*t48*t54*t97
              t149 = -1.099109305675375d-2*t35*t81*t96
              t150 = -2.6513779981040353d-1*t40*t48*t51*t53*t54
              t151 = t42**3
              t152 = 1/t7**7
              t153 = 1/rhoa**3.3333333333333337d+0
              t154 = 1/rhoa**3.1666666666666665d+0
              t155 = t45**3
              t156 = -6.0d+0*t14*t44*t45*t87*t88+9.649187699215522d+1*t1
     1           4*t45*t84*t86*t88-1.274696188700087d-1*t40*t44*t46*t88+
     2           2.549392377400174d-1*t40*t44*t85*t87-4.0999275947472624
     3           d+0*t40*t84*t85*t86+6.0d+0*t14*t155*t44*t86-1.929837539
     4           8431045d+2*t14*t155*t84/t11**5-6.661338147750939d-16*t1
     5           8*t37*t42*t79*t83+5.356375176299456d-15*t18*t42*t76*t78
     6           *t83-1.4718104502398274d-17*t37*t40*t43*t83+1.699594918
     7           2667827d-1*t44*t45*t46*t81+1.962413933653103d-17*t37*t4
     8           2*t43*t81+2.943620900479655d-17*t37*t40*t77*t79-2.36696
     9           25486718335d-16*t40*t76*t77*t78+6.661338147750939d-16*t
     :           151*t18*t37*t78-1.0712750352598913d-14*t151*t18*t76/t15
     ;           **5+1.1102230246251565d-16*t18*t37*t43*(-5.620753557770
     <           543d-1*t59-2.520426340996149d+0*t154-2.3079979182303428
     =           d+0*t153-1.5008036906238065d+0*t152)+1.0d+0*t14*t44*t46
     >           *(-7.128507529742789d-1*t59-4.684972743248224d+0*t154-3
     ?           .9871442462415524d+0*t153-3.083875829189267d+0*t152)+5.
     @           742741051503565d-14*t151*t18/(t15**6*t16**3)+9.49088356
     1           0204437d-19*t153*t17+2.0690405167709364d+3*t14*t155/(t1
     2           1**6*t12**3)+4.1099018897499934d-3*t13*t153
              t157 = t53**3
              t158 = 5.172601291927341d+2*t157*t36/(t33**6*t34**3)
              t159 = -9.649187699215522d+1*t157*t36*t90/t33**5
              t160 = 6.0d+0*t157*t36*t48*t92
              t161 = 4.824593849607761d+1*t36*t53*t90*t92*t97
              t162 = -6.0d+0*t36*t48*t53*t94*t97
              t163 = 9.921256574801247d-2
              t164 = 1.0d+0*t36*t48*t54*(-4.4260660773166294d-2*t59-1.50
     1           08036906238065d+0*t152/t29**7-2.3079979182303428d+0*t15
     2           3*t163-2.8068057454507694d-1*t154)
              t165 = 8.548627933030694d-3*t153*t163*t35
              t166 = 1/rhoa**3
              t167 = 1.767585332069357d-1*t48*t53*t54*t81*t96
              t168 = 1/t101
              t169 = -1.3595691172479402d+0*t41*t52-7.491972878592053d-1
     1           *t40*t51-2.1504862356383217d-1*t39*t50-1.27434173008489
     2           14d-1*t38*t49
              t170 = 1/t100**2
              t171 = -2.1319703304396778d+0*t40*t51*t90*t91*t92
              t172 = 2.6513779981040353d-1*t40*t48*t51*t91*t94
              t173 = -1.3256889990520176d-1*t40*t48*t51*t54*t97
              t174 = gammaaa**4
              t175 = 1/t2**4
              t176 = 1/rhoa**1.3666666666666666d+1
              t177 = 2.101523342222221d-8*t174*t175*t176*t4
              t178 = 1/rhoa**11
              t179 = 2.542165333333332d-6*t107*t108*t109*t60
              t180 = 1/rhoa**8.333333333333334d+0
              t181 = 1/rhoa**5.666666666666667d+0
              t182 = -2.3453605107465544d-7*t174*t175*t176
              t183 = 1/t21**4
              t184 = 1.0d+0*t106*t68
              t185 = 1/rhoa**1.2666666666666665d+1
              t186 = -7.880712533333329d-9*t107*t175*t185*t4
              t187 = 8.473884444444441d-7*t107*t108*t109*t67
              t188 = -6.355413333333331d-7*t108*t126*t56*t60
              t189 = -3.2460444444444436d-4*t111*t56*t57*t67
              t190 = -1.9219999999999998d-5*gammaaa*t116*t57*t66
              t191 = 3.0311111111111105d-2*gammaaa*t113*t3*t67
              t192 = 8.795101915299581d-8*t107*t175*t185
              t193 = 3.1d-3*t1*t116*t3
              t194 = t69-1.25d-1*gammaaa*t19*t71
              t195 = 1.25d-1*t24*t47
              t196 = 1.25d-1*t19*t65
              t197 = 1.0d+0*t142*t55
              t198 = 1/rhoa**1.1666666666666665d+1
              t199 = 2.9552671999999985d-9*t175*t198*t4*t56
              t200 = -6.355413333333331d-7*t108*t126*t56*t67
              t201 = 1.1916399999999999d-7*gammaaa*t108*t140*t60
              t202 = 5.125333333333332d-5*t141*t56*t57*t58
              t203 = -1.9219999999999998d-5*t57*t60*t66
              t204 = -8.266666666666665d-3*gammaaa*t141*t3*t59
              t205 = -3.298163218237343d-8*t175*t198*t56
              t206 = 2.5d-1*t19*t71
              t207 = 1/rhoa**1.0666666666666666d+1
              t208 = -5.766d-5*t57*t66*t67+3.57492d-7*gammaaa*t108*t140*
     1           t67-5.766d-5*gammaaa*t141*t57*t66-1.1082252d-9*gammaaa*
     2           t175*t207*t4+1.78746d-7*t108*t140*t4+6.2d-3*gammaaa*t1*
     3           (1.2368112068390037d-8*gammaaa*t175*t207-1.994856785224
     4           2d-6*t108*t140)*t3+9.299999999999999d-3*t1*t141*t3
              fnc(iq) = (1.0d+0*t5*(t20-1.243628d-1*rhoa*(1.052200055838
     1           9212d-1*t9+1.0d+0)*log(1.6081979498692536d+1/(1.7664356
     2           20181429d+0*t9+5.659885156639418d-1*t8+1.19503784087549
     3           d-1*t6+5.329846514438383d+0*t10)+1.0d+0))+1.0d+0*rhoa*t
     4           19*t24*t25*t27)*wght+fnc(iq)
              Amat(iq,D1_RA) = (t25*(5.0d-1*rhoa*t19*t27*t65+5.0d-1*rhoa
     1           *t24*t27*t47+5.0d-1*t19*t24*t27)+1.0d+0*t61*t62+1.0d+0*
     2           t5*t55+1.25d-1*gammaaa*t19*t24*t25*t26)*wght+Amat(iq,D1
     3           _RA)
              Cmat(iq,D1_GAA) = (t25*(5.0d-1*rhoa*t19*t27*t71+t69)+1.0d+
     1           0*t62*t68)*wght+Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Mmat(iq,D1_TA) = (1.0d+0*rhoa*t19*t24*t25-5.0d-1*rhoa*t19*
     1           t24*t27*t72)*wght+Mmat(iq,D1_TA)
              Amat2(iq,D2_RA_RA) = (t25*(5.0d-1*rhoa*t24*t27*t89+1.0d+0*
     1           rhoa*t27*t47*t65+1.0d+0*t19*t27*t65+1.25d-1*gammaaa*t19
     2           *t26*t65+1.0d+0*t24*t27*t47+1.25d-1*gammaaa*t24*t26*t47
     3           +5.0d-1*rhoa*t120*t19*t27+1.25d-1*gammaaa*t104*t19*t24)
     4           +t73+t25*t26*(1.25d-1*gammaaa*t19*t65+1.25d-1*gammaaa*t
     5           24*t47)+1.0d+0*t117*t62+1.0d+0*t106*t5-1.25d-1*gammaaa*
     6           t104*t19*t24*t25)*wght+Amat2(iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = (t73+1.0d+0*t124*t62+1.0d+0*t122*t5)*
     1           wght+Amat2(iq,D2_RA_RB)
              Cmat2(iq,D2_RA_GAA) = (t25*(5.0d-1*rhoa*t27*t47*t71+5.0d-1
     1           *t19*t27*t71-1.25d-1*t19*t65-1.25d-1*t24*t47+5.0d-1*rho
     2           a*t137*t19*t27-1.25d-1*t19*t24*t26)+t25*t26*(1.25d-1*ga
     3           mmaaa*t19*t71+t135)+1.0d+0*t134*t62+t125)*wght+Cmat2(iq
     4           ,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = (1.0d+0*t139*t62+t125)*wght+Cmat2(iq
     1           ,D2_RA_GBB)
              Cmat2(iq,D2_GAA_GAA) = (t25*(5.0d-1*rhoa*t144*t19*t27-2.5d
     1           -1*t19*t71)+1.0d+0*t142*t62)*wght+Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = 1.0d+0*t142*t62*wght+Cmat2(iq,D2_GA
     1           A_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Mmat2(iq,D2_RA_TA) = ((-5.0d-1*rhoa*t19*t27*t65-5.0d-1*rho
     1           a*t24*t27*t47-5.0d-1*t19*t24*t27)*t72-1.25d-1*gammaaa*t
     2           19*t24*t26*t72+t25*(1.0d+0*rhoa*t19*t65+1.0d+0*rhoa*t24
     3           *t47+1.0d+0*t19*t24))*wght+Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = ((t135-5.0d-1*rhoa*t19*t27*t71)*t72+
     1           1.0d+0*rhoa*t19*t25*t71)*wght+Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_TA_TA) = (1.0d+0*rhoa*t145*t19*t24*t27-2.0d+0*
     1           rhoa*t19*t24*t72)*wght+Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Amat3(iq,D3_RA_RA_RA) = (t25*(1.5d+0*rhoa*t27*t65*t89+1.5d
     1           +0*t24*t27*t89+2.5d-1*gammaaa*t24*t26*t89+3.0d+0*t27*t4
     2           7*t65+5.0d-1*gammaaa*t26*t47*t65+2.5d-1*gammaaa*t104*t1
     3           9*t65+5.0d-1*rhoa*t19*t27*(-2.5919999999999993d-1*t111*
     4           t56*t63*t64+1.76d+0*gammaaa*t113*t22*t64+9.215999999999
     5           996d-3*t107*t109*t118*t64+6.0d-2*gammaaa*t1*t22*(1.6174
     6           34328106666d+0*t180*t56*t63-6.08711843911111d+0*gammaaa
     7           *t181*t22+3.2785061806079985d-3*t174*t176*t183-1.297742
     8           0298239994d-1*t107*t118*t178)+2.879999999999999d-2*t119
     9           *t56*t58*t63+7.274666666666665d-1*t180*t23*t56*t63-4.79
     :           9999999999999d-1*gammaaa*t119*t22*t59-2.737777777777778
     ;           d+0*gammaaa*t181*t22*t23+1.4745599999999992d-3*t174*t17
     <           6*t183*t23-5.836799999999998d-2*t107*t118*t178*t23)+1.5
     =           d+0*rhoa*t120*t27*t47+2.5d-1*gammaaa*t104*t24*t47+5.0d-
     >           1*rhoa*t156*t24*t27+1.5d+0*t120*t19*t27+2.5d-1*gammaaa*
     ?           t120*t19*t26-2.5d-1*gammaaa*t166*t19*t24)+t25*t26*(1.25
     @           d-1*gammaaa*t24*t89+2.5d-1*gammaaa*t47*t65+1.25d-1*gamm
     1           aaa*t120*t19)+1.0d+0*t5*(-3.0d+0*t14*t44*t46*t88+6.0d+0
     2           *t14*t44*t85*t87-9.649187699215522d+1*t14*t84*t85*t86-3
     3           .3306690738754696d-16*t18*t37*t43*t83+1.220256457740570
     4           6d-18*t17*t81+5.284159572535705d-3*t13*t81+6.6613381477
     5           50939d-16*t18*t37*t77*t79-5.356375176299456d-15*t18*t76
     6           *t77*t78+2*rhoa*(-5.82714947393947d-4*t102*t153*t51+t17
     7           3+t172+t171-7.5d-1*t103*t104*t168*t169*t170+t167-2.5330
     8           29591058444d-2*t102*t103*t166+t165+t164+t162+t161+t160+
     9           t159+t158)+2.549392377400174d-1*t40*t44*t45*t46+2.94362
     :           0900479655d-17*t37*t40*t42*t43-rhoa*t156+t150+t149+t148
     ;           +t147+t146+2.5330295910584444d-2*t102*t103*t104)+t104*t
     <           25*(-2.5d-1*gammaaa*t19*t65-2.5d-1*gammaaa*t24*t47)+1.0
     =           d+0*(-9.73813333333333d-4*t111*t56*t57*t60+9.0933333333
     >           33331d-2*gammaaa*t113*t3*t60-2.4799999999999994d-2*gamm
     ?           aaa*t116*t3*t59+1.5375999999999995d-4*t116*t56*t57*t58+
     @           6.2d-3*gammaaa*t1*t3*(-2.656631258379022d-2*t180*t56*t5
     1           7+1.5786433623644444d+0*gammaaa*t181*t3+t182+1.41856482
     2           50483196d-4*t107*t108*t178)+2.3804325925925923d-3*t180*
     3           t4*t56*t57-1.4145185185185183d-1*gammaaa*t181*t3*t4-1.2
     4           71082666666666d-5*t107*t108*t178*t4+t179+t177)*t62+3.0d
     5           +0*t106*t61+3.0d+0*t117*t55+2.5d-1*gammaaa*t166*t19*t24
     6           *t25)*wght+Amat3(iq,D3_RA_RA_RA)
              Amat3(iq,D3_RA_RA_RB) = (1.0d+0*(-5.979555555555554d-4*t11
     1           1*t56*t57*t60+3.0311111111111105d-2*gammaaa*t113*t3*t60
     2           -1.653333333333333d-2*gammaaa*t123*t3*t59-8.26666666666
     3           6665d-3*gammaaa*t116*t3*t59+1.0250666666666663d-4*t123*
     4           t56*t57*t58+5.125333333333332d-5*t116*t56*t57*t58+6.2d-
     5           3*gammaaa*t1*t3*(-5.592907912376887d-3*t180*t56*t57+t18
     6           2+7.250442439135856d-5*t107*t108*t178)+5.01143703703703
     7           5d-4*t180*t4*t56*t57-6.496644740740738d-6*t107*t108*t17
     8           8*t4+t179+t177)*t62+2.0d+0*t122*t61+1.0d+0*t106*t61+2.0
     9           d+0*t124*t55+1.0d+0*t117*t55+1.0d+0*t5*(2*rhoa*(1.94238
     :           31579798237d-4*t102*t153*t51+t173+t172+t171+2.5d-1*t103
     ;           *t104*t168*t169*t170+t167+8.443431970194815d-3*t102*t10
     <           3*t166+t165+t164+t162+t161+t160+t159+t158)+t150+t149+t1
     =           48+t147+t146+t121))*wght+Amat3(iq,D3_RA_RA_RB)
              Cmat3(iq,D3_RA_RA_GAA) = (t25*(5.0d-1*rhoa*t27*t71*t89-1.2
     1           5d-1*t24*t89+1.0d+0*t27*t47*t71+1.25d-1*gammaaa*t26*t47
     2           *t71+1.25d-1*gammaaa*t104*t19*t71+5.0d-1*rhoa*t19*t27*(
     3           -8.639999999999998d-2*t111*t56*t63*t70+5.86666666666666
     4           6d-1*gammaaa*t113*t22*t70+3.0719999999999986d-3*t107*t1
     5           09*t118*t70-3.6d-3*gammaaa*t119*t63*t66+5.7599999999999
     6           98d-2*gammaaa*t58*t63*t64-3.1999999999999995d-1*t22*t59
     7           *t64-2.303999999999999d-3*t118*t126*t56*t64+6.0d-2*gamm
     8           aaa*t1*t22*(-4.624628943999999d-1*gammaaa*t111*t63+4.35
     9           42660211199985d-2*t109*t118*t56+1.3043825226666664d+0*t
     :           113*t22-1.2294398177279994d-3*t107*t183*t185)+1.9199999
     ;           999999995d-2*t136*t56*t58*t63-2.0799999999999996d-1*gam
     <           maaa*t111*t23*t63-3.1999999999999995d-1*gammaaa*t136*t2
     =           2*t59+1.9583999999999993d-2*t109*t118*t23*t56+5.8666666
     >           66666666d-1*t113*t22*t23-5.529599999999998d-4*t107*t183
     ?           *t185*t23+6.0d-2*t1*t119*t22)-2.5d-1*t47*t65-1.25d-1*t1
     @           9*t26*t65+1.0d+0*rhoa*t137*t27*t47-1.25d-1*t24*t26*t47+
     1           1.0d+0*t137*t19*t27+1.25d-1*gammaaa*t137*t19*t26+1.25d-
     2           1*t104*t19*t24-1.25d-1*t120*t19)+t25*t26*(1.25d-1*gamma
     3           aa*t47*t71+t196+t195+1.25d-1*gammaaa*t137*t19)+1.0d+0*(
     4           -1.653333333333333d-2*t3*t59*t60+2.0501333333333327d-4*
     5           gammaaa*t57*t58*t60-1.653333333333333d-2*gammaaa*t132*t
     6           3*t59+1.0250666666666663d-4*t132*t56*t57*t58+6.2d-3*gam
     7           maaa*t1*t3*(7.245357977397332d-3*gammaaa*t111*t57-4.610
     8           3356814070384d-5*t108*t109*t56-3.3828072050666663d-1*t1
     9           13*t3+t192)-6.492088888888888d-4*gammaaa*t111*t4*t57+4.
     :           1310186666666654d-6*t108*t109*t4*t56+3.0311111111111105
     ;           d-2*t113*t3*t4+t193+t191+t190+t189+t188+t187+t186)*t62+
     <           2.0d+0*t134*t55+t104*t194*t25+t184)*wght+Cmat3(iq,D3_RA
     =           _RA_GAA)
              Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
              Cmat3(iq,D3_RA_RA_GBB) = (1.0d+0*(1.0250666666666663d-4*ga
     1           mmaaa*t57*t58*t60-1.653333333333333d-2*gammaaa*t138*t3*
     2           t59+1.0250666666666663d-4*t138*t56*t57*t58+6.2d-3*gamma
     3           aa*t1*t3*(2.0973404671413332d-3*gammaaa*t111*t57-2.7189
     4           15914675946d-5*t108*t109*t56+t192)-1.8792888888888884d-
     5           4*gammaaa*t111*t4*t57+2.436241777777777d-6*t108*t109*t4
     6           *t56+t193+t191+t190+t189+t188+t187+t186)*t62+2.0d+0*t13
     7           9*t55+t184)*wght+Cmat3(iq,D3_RA_RA_GBB)
              Cmat3(iq,D3_RA_RB_GAA) = (1.0d+0*t122*t68+1.0d+0*t62*(-1.3
     1           66755555555555d-4*t111*t56*t57*t67-1.9219999999999998d-
     2           5*gammaaa*t123*t57*t66-8.266666666666665d-3*t3*t59*t60+
     3           1.5375999999999995d-4*gammaaa*t57*t58*t60-8.26666666666
     4           6665d-3*gammaaa*t138*t3*t59-8.266666666666665d-3*gammaa
     5           a*t132*t3*t59+5.125333333333332d-5*t138*t56*t57*t58+5.1
     6           25333333333332d-5*t132*t56*t57*t58+6.2d-3*gammaaa*t1*t3
     7           *(1.525338521557333d-3*gammaaa*t111*t57-2.3642747084138
     8           66d-5*t108*t109*t56+t192)-1.366755555555555d-4*gammaaa*
     9           t111*t4*t57+2.1184711111111104d-6*t108*t109*t4*t56+3.1d
     :           -3*t1*t123*t3+t188+t187+t186)+1.0d+0*t139*t55+1.0d+0*t1
     ;           34*t55)*wght+Cmat3(iq,D3_RA_RB_GAA)
              Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
              Cmat3(iq,D3_RA_GAA_GAA) = (t25*(-2.5d-1*t47*t71-2.5d-1*t19
     1           *t26*t71+5.0d-1*rhoa*t19*t27*(5.759999999999998d-2*gamm
     2           aaa*t58*t63*t70-3.1999999999999995d-1*t22*t59*t70-2.303
     3           999999999999d-3*t118*t126*t56*t70-7.2d-3*t63*t64*t66-7.
     4           2d-3*gammaaa*t136*t63*t66+4.32d-4*gammaaa*t118*t140*t64
     5           +6.0d-2*gammaaa*t1*t22*(8.537776511999997d-2*t58*t63+4.
     6           6103993164799983d-4*t183*t198*t56-1.2806664767999995d-2
     7           *gammaaa*t118*t126)+9.599999999999997d-3*t143*t56*t58*t
     8           63+3.839999999999999d-2*t23*t58*t63-1.5999999999999998d
     9           -1*gammaaa*t143*t22*t59+2.073599999999999d-4*t183*t198*
     :           t23*t56-5.759999999999997d-3*gammaaa*t118*t126*t23+1.2d
     ;           -1*t1*t136*t22)+5.0d-1*rhoa*t144*t27*t47+5.0d-1*t144*t1
     <           9*t27-2.5d-1*t137*t19)+1.0d+0*t62*(-1.653333333333333d-
     =           2*t3*t59*t67+2.0501333333333327d-4*gammaaa*t57*t58*t67-
     >           3.8439999999999996d-5*gammaaa*t132*t57*t66+6.2d-3*gamma
     ?           aa*t1*t3*(-1.1440038911679998d-3*t57*t58+t205+1.2412442
     @           219172796d-5*gammaaa*t108*t126)+1.0250666666666663d-4*t
     1           4*t57*t58-1.1121973333333329d-6*gammaaa*t108*t126*t4+6.
     2           2d-3*t1*t132*t3+t204+t203+t202+t201+t200+t199)+(t206+1.
     3           25d-1*gammaaa*t144*t19)*t25*t26+t197)*wght+Cmat3(iq,D3_
     4           RA_GAA_GAA)
              Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
              Cmat3(iq,D3_RA_GAA_GBB) = (1.0d+0*t62*(-8.266666666666665d
     1           -3*t3*t59*t67+1.5375999999999995d-4*gammaaa*t57*t58*t67
     2           -1.9219999999999998d-5*gammaaa*t138*t57*t66-1.921999999
     3           9999998d-5*gammaaa*t132*t57*t66+6.2d-3*gammaaa*t1*t3*(-
     4           5.72001945584d-4*t57*t58+t205+8.866030156551998d-6*gamm
     5           aaa*t108*t126)+5.125333333333332d-5*t4*t57*t58-7.944266
     6           666666663d-7*gammaaa*t108*t126*t4+3.1d-3*t1*t138*t3+3.1
     7           d-3*t1*t132*t3+t204+t203+t202+t201+t200+t199)+t197)*wgh
     8           t+Cmat3(iq,D3_RA_GAA_GBB)
              Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
              Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
              Cmat3(iq,D3_RA_GBB_GBB) = (1.0d+0*t62*(1.0250666666666663d
     1           -4*gammaaa*t57*t58*t67-3.8439999999999996d-5*gammaaa*t1
     2           38*t57*t66-4.766559999999998d-7*gammaaa*t108*t126*t4+6.
     3           2d-3*gammaaa*t1*(t205+5.319618093931199d-6*gammaaa*t108
     4           *t126)*t3+6.2d-3*t1*t138*t3+t204+t203+t202+t201+t200+t1
     5           99)+t197)*wght+Cmat3(iq,D3_RA_GBB_GBB)
              Cmat3(iq,D3_GAA_GAA_GAA) = (t25*(5.0d-1*rhoa*t19*t27*(-2.1
     1           600000000000003d-2*t63*t66*t70+1.296d-3*gammaaa*t118*t1
     2           40*t70-1.0800000000000001d-2*gammaaa*t143*t63*t66-7.776
     3           d-5*gammaaa*t183*t207*t23+1.296d-3*t118*t140*t23+6.0d-2
     4           *gammaaa*t1*(2.881499572799999d-3*t118*t140-1.728899743
     5           6799997d-4*gammaaa*t183*t207)*t22+1.8d-1*t1*t143*t22)-3
     6           .75d-1*t144*t19)+1.0d+0*t208*t62)*wght+Cmat3(iq,D3_GAA_
     7           GAA_GAA)
              Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
              Cmat3(iq,D3_GAA_GAA_GBB) = 1.0d+0*t208*t62*wght+Cmat3(iq,D
     1           3_GAA_GAA_GBB)
              Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
              Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
              Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
              Mmat3(iq,D3_RA_RA_TA) = (t72*(-5.0d-1*rhoa*t24*t27*t89-1.0
     1           d+0*rhoa*t27*t47*t65-1.0d+0*t19*t27*t65-1.25d-1*gammaaa
     2           *t19*t26*t65-1.0d+0*t24*t27*t47-1.25d-1*gammaaa*t24*t26
     3           *t47-5.0d-1*rhoa*t120*t19*t27-1.25d-1*gammaaa*t104*t19*
     4           t24)+t25*(1.0d+0*rhoa*t24*t89+2.0d+0*rhoa*t47*t65+2.0d+
     5           0*t19*t65+2.0d+0*t24*t47+1.0d+0*rhoa*t120*t19)+t26*(-1.
     6           25d-1*gammaaa*t19*t65-1.25d-1*gammaaa*t24*t47)*t72+1.25
     7           d-1*gammaaa*t104*t19*t24*t72)*wght+Mmat3(iq,D3_RA_RA_TA
     8           )
              Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
              Mmat3(iq,D3_RA_RB_TA) = Mmat3(iq,D3_RA_RB_TA)
              Mmat3(iq,D3_RA_GAA_TA) = ((-5.0d-1*rhoa*t27*t47*t71-5.0d-1
     1           *t19*t27*t71-5.0d-1*rhoa*t137*t19*t27+1.25d-1*t19*t24*t
     2           26+t196+t195)*t72+t194*t26*t72+t25*(1.0d+0*rhoa*t47*t71
     3           +1.0d+0*t19*t71+1.0d+0*rhoa*t137*t19))*wght+Mmat3(iq,D3
     4           _RA_GAA_TA)
              Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
              Mmat3(iq,D3_RA_GAB_TA) = Mmat3(iq,D3_RA_GAB_TA)
              Mmat3(iq,D3_RA_GAB_TB) = Mmat3(iq,D3_RA_GAB_TB)
              Mmat3(iq,D3_RA_GBB_TA) = Mmat3(iq,D3_RA_GBB_TA)
              Mmat3(iq,D3_RA_GBB_TB) = Mmat3(iq,D3_RA_GBB_TB)
              Mmat3(iq,D3_GAA_GAA_TA) = ((t206-5.0d-1*rhoa*t144*t19*t27)
     1           *t72+1.0d+0*rhoa*t144*t19*t25)*wght+Mmat3(iq,D3_GAA_GAA
     2           _TA)
              Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
              Mmat3(iq,D3_GAA_GAB_TA) = Mmat3(iq,D3_GAA_GAB_TA)
              Mmat3(iq,D3_GAA_GAB_TB) = Mmat3(iq,D3_GAA_GAB_TB)
              Mmat3(iq,D3_GAA_GBB_TA) = Mmat3(iq,D3_GAA_GBB_TA)
              Mmat3(iq,D3_GAB_GAB_TA) = Mmat3(iq,D3_GAB_GAB_TA)
              Mmat3(iq,D3_TA_TA_TA) = (6.0d+0*rhoa*t145*t19*t24-3.0d+0*r
     1           hoa*t19*t24*t27/taua**4)*wght+Mmat3(iq,D3_TA_TA_TA)
              Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
            else 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 2.4d-51*t1+1.0d+0
              t3 = 1/t2
              t4 = 5.336110319999999d-51*t1*t3-2.5960897d+0
              t5 = 2.4d-51*t1*t3*t4+1.0d+0
              t6 = 1/rhoa**6.666666666666666d-1
              t7 = rhoa**5.0d-1
              t8 = 1/t7
              t9 = 1/rhoa**3.333333333333333d-1
              t10 = 1/rhoa**1.6666666666666666d-1
              t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.4
     1           058712912881916d-1*t6+1.1120374863094686d+1*t10
              t12 = 3.216395899738507d+1/t11+1.0d+0
              t13 = log(t12)
              t14 = 1.274696188700087d-1*t9+1.0d+0
              t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.8
     1           970043257475583d-1*t6+5.982550435771079d+0*t10
              t16 = 1.6081979498692536d+1/t15+1.0d+0
              t17 = log(t16)
              t18 = 1.3256889990520176d-1*t9+1.0d+0
              t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2
     1           *t13*t14
              t20 = 2.4799999999999997d-52*t1+1.0d+0
              t21 = 1/t20
              t22 = -2*rhoa*t19
              t23 = 1/t16
              t24 = 1/t7**3
              t25 = 1/rhoa**1.3333333333333333d+0
              t26 = 1/rhoa**1.1666666666666667d+0
              t27 = -9.970917392951799d-1*t26-7.418564737168958d-1*t25-4
     1           .002143174996817d-1*t24-1.264669550498372d-1*t1
              t28 = 1/t15**2
              t29 = 1/t12
              t30 = -1.8533958105157808d+0*t26-1.2815820791490704d+0*t25
     1           -8.223668877838045d-1*t24-1.6039141941921276d-1*t1
              t31 = 1/t11**2
              t32 = 1.0d+0*t14*t29*t30*t31+1.1102230246251565d-16*t18*t2
     1           3*t27*t28+3.0506411443514264d-19*t17*t25+1.321039893133
     2           9265d-3*t13*t25
              t33 = 1/t2**2
              t34 = 1/rhoa**4.333333333333333d+0
              t35 = 1/rhoa**2.6666666666666666d+0
              t36 = 2.134444128d-101*t33*t34-8.8935172d-51*t3*t35
              t37 = -4.0d-51*t3*t35*t4+9.6d-102*t33*t34*t4+2.4d-51*t1*t3
     1           *t36
              t38 = 5.9515308d+0-2.7677513496d-51*t1*t21
              t39 = 2.4799999999999997d-52*t1*t21*t38+1.0d+0
              t40 = 6.299605249474366d-1
              t41 = 1.414213562373095d+0
              t42 = 1/t41
              t43 = 7.937005259840998d-1
              t44 = 8.908987181403393d-1
              t45 = 2.2255694211506874d+0*t43*t9+8.004286349993635d-1*t4
     1           2*t8+1.8970043257475583d-1*t40*t6+5.982550435771079d+0*
     2           t10*t44
              t46 = 1.6081979498692536d+1/t45+1.0d+0
              t47 = log(t46)
              t48 = 1.3256889990520176d-1*t43*t9+1.0d+0
              t49 = 1/t46
              t50 = 3.149802624737183d-1
              t51 = 1/t41**3
              t52 = 3.968502629920499d-1
              t53 = 4.4544935907016964d-1
              t54 = -9.970917392951799d-1*t26*t53-7.418564737168958d-1*t
     1           25*t52-4.002143174996817d-1*t24*t51-1.264669550498372d-
     2           1*t1*t50
              t55 = 1/t45**2
              t56 = 2*rhoa*(1.0d+0*t48*t49*t54*t55+2.747773264188437d-3*
     1           t25*t47*t52)-6.21814d-2*t47*t48-rhoa*t32+6.903522198342
     2           671d-18*t17*t18+3.1090699999999993d-2*t13*t14
              t57 = 1/t20**2
              t58 = 2.306459458d-51*t21*t35-5.72001945584d-103*t34*t57
              t59 = 2.4799999999999997d-52*t1*t21*t58+5.125333333333333d
     1           -104*t34*t38*t57-2.0666666666666667d-52*t21*t35*t38
              t60 = t22-1.243628d-1*rhoa*t47*t48
              t61 = 1/t16**2
              t62 = t27**2
              t63 = 1/t15**4
              t64 = 1/t15**3
              t65 = 1/t7**5
              t66 = 1/rhoa**2.3333333333333334d+0
              t67 = 1/rhoa**2.1666666666666665d+0
              t68 = 1.1632736958443765d+0*t67+9.89141964955861d-1*t66+6.
     1           003214762495226d-1*t65+2.1077825841639536d-1*t35
              t69 = 1/t12**2
              t70 = t30**2
              t71 = 1/t11**4
              t72 = 1/t11**3
              t73 = 2.1622951122684114d+0*t67+1.7087761055320938d+0*t66+
     1           1.2335503316757068d+0*t65+2.673190323653546d-1*t35
              t74 = 1.0d+0*t14*t29*t31*t73-2.0d+0*t14*t29*t70*t72+3.2163
     1           95899738507d+1*t14*t69*t70*t71+1.1102230246251565d-16*t
     2           18*t23*t28*t68-4.0675215258019015d-19*t17*t66-1.7613865
     3           241785684d-3*t13*t66-2.220446049250313d-16*t18*t23*t62*
     4           t64+1.7854583920998188d-15*t18*t61*t62*t63-8.4979745913
     5           33913d-2*t25*t29*t30*t31-9.812069668265515d-18*t23*t25*
     6           t27*t28
              t75 = 1/t2**3
              t76 = 1/rhoa**7
              t77 = 1/rhoa**5.333333333333333d+0
              t78 = 1/rhoa**3.6666666666666664d+0
              t79 = 2.3716045866666666d-50*t3*t78-1.2806664767999998d-10
     1           0*t33*t77+1.7075553024d-151*t75*t76
              t80 = 2.4d-51*t1*t3*t79+1.0666666666666666d-50*t3*t4*t78-5
     1           .76d-101*t33*t4*t77+7.68d-152*t4*t75*t76-8.0d-51*t3*t35
     2           *t36+1.92d-101*t33*t34*t36
              t81 = 2.0d+0*t56*t59
              t82 = 2.0d+0*t48*t49*t54*t55
              t83 = 5.495546528376875d-3*t25*t47*t52
              t84 = 1/t46**2
              t85 = t54**2
              t86 = 1/t45**4
              t87 = 1.6081979498692536d+1*t48*t84*t85*t86
              t88 = 1/t45**3
              t89 = -2.0d+0*t48*t49*t85*t88
              t90 = 1.9842513149602492d-1
              t91 = 9.89141964955861d-1*t66*t90+2.5908976111853255d-1*t6
     1           7+6.003214762495226d-1*t65/t41**5+3.319549557987472d-2*
     2           t35
              t92 = 1.0d+0*t48*t49*t55*t91
              t93 = -3.663697685584583d-3*t47*t66*t90
              t94 = 2.247591863577616d+0*t43*t9+4.3009724712766434d-1*t4
     1           2*t8+1.9115125951273373d-1*t40*t6+8.157414703487641d+0*
     2           t10*t44
              t95 = 2.9608813203268075d+1/t94+1.0d+0
              t96 = log(t95)
              t97 = 6.901399211255825d-2*t43*t9+1.0d+0
              t98 = 1/rhoa**2
              t99 = -8.837926660346784d-2*t25*t49*t52*t54*t55
              t100 = 2*rhoa*(t99+8.443431970194815d-3*t96*t97*t98+t93+t9
     1           2+t89+t87)+t83+t82-rhoa*t74-2.0d+0*t14*t29*t30*t31-2.22
     2           0446049250313d-16*t18*t23*t27*t28-6.101282288702853d-19
     3           *t17*t25-2.642079786267853d-3*t13*t25
              t101 = 1/t20**3
              t102 = 2.118471111111111d-155*t101*t38*t76
              t103 = 1.0250666666666666d-103*t34*t57*t58
              t104 = -4.1333333333333333d-52*t21*t35*t58
              t105 = -2.3642747084138666d-154*t101*t76
              t106 = -6.150558554666666d-51*t21*t78+2.4786750975306662d-
     1           102*t57*t77+t105
              t107 = 5.51111111111111d-52*t21*t38*t78-2.2209777777777773
     1           d-103*t38*t57*t77+2.4799999999999997d-52*t1*t106*t21+t1
     2           04+t103+t102
              t108 = -8.443431970194815d-3*t96*t97*t98
              t109 = 2*rhoa*(t99+t93+t92+t89+t87+t108)+t83+t82
              t110 = 9.533365759733332d-103*t57*t77+t105
              t111 = -8.542222222222222d-104*t38*t57*t77+2.4799999999999
     1           997d-52*t1*t110*t21+t104+t103+t102
              t112 = t27**3
              t113 = 1/t7**7
              t114 = 1/rhoa**3.3333333333333337d+0
              t115 = 1/rhoa**3.1666666666666665d+0
              t116 = t30**3
              t117 = 1.1102230246251565d-16*t18*t23*t28*(-5.620753557770
     1           543d-1*t78-2.520426340996149d+0*t115-2.3079979182303428
     2           d+0*t114-1.5008036906238065d+0*t113)+1.0d+0*t14*t29*t31
     3           *(-7.128507529742789d-1*t78-4.684972743248224d+0*t115-3
     4           .9871442462415524d+0*t114-3.083875829189267d+0*t113)-6.
     5           0d+0*t14*t29*t30*t72*t73+9.649187699215522d+1*t14*t30*t
     6           69*t71*t73-1.274696188700087d-1*t25*t29*t31*t73+2.54939
     7           2377400174d-1*t25*t29*t70*t72-4.0999275947472624d+0*t25
     8           *t69*t70*t71+6.0d+0*t116*t14*t29*t71-1.9298375398431045
     9           d+2*t116*t14*t69/t11**5-6.661338147750939d-16*t18*t23*t
     :           27*t64*t68+5.356375176299456d-15*t18*t27*t61*t63*t68-1.
     ;           4718104502398274d-17*t23*t25*t28*t68+1.6995949182667827
     <           d-1*t29*t30*t31*t66+1.962413933653103d-17*t23*t27*t28*t
     =           66+2.943620900479655d-17*t23*t25*t62*t64-2.366962548671
     >           8335d-16*t25*t61*t62*t63+6.661338147750939d-16*t112*t18
     ?           *t23*t63-1.0712750352598913d-14*t112*t18*t61/t15**5+5.7
     @           42741051503565d-14*t112*t18/(t15**6*t16**3)+9.490883560
     1           204437d-19*t114*t17+2.0690405167709364d+3*t116*t14/(t11
     2           **6*t12**3)+4.1099018897499934d-3*t114*t13
              t118 = 1/t2**4
              t119 = 1/rhoa**9.666666666666666d+0
              t120 = 1/rhoa**8
              t121 = 1/rhoa**6.333333333333333d+0
              t122 = 1/rhoa**4.666666666666667d+0
              t123 = 4.824593849607761d+1*t48*t84*t85*t86
              t124 = -6.0d+0*t48*t49*t85*t88
              t125 = 3.0d+0*t48*t49*t55*t91
              t126 = -1.099109305675375d-2*t47*t66*t90
              t127 = -2.6513779981040353d-1*t25*t49*t52*t54*t55
              t128 = t54**3
              t129 = 5.172601291927341d+2*t128*t48/(t45**6*t46**3)
              t130 = -9.649187699215522d+1*t128*t48*t84/t45**5
              t131 = 6.0d+0*t128*t48*t49*t86
              t132 = 4.824593849607761d+1*t48*t54*t84*t86*t91
              t133 = -6.0d+0*t48*t49*t54*t88*t91
              t134 = 9.921256574801247d-2
              t135 = 1.0d+0*t48*t49*t55*(-4.4260660773166294d-2*t78-1.50
     1           08036906238065d+0*t113/t41**7-2.3079979182303428d+0*t11
     2           4*t134-2.8068057454507694d-1*t115)
              t136 = 8.548627933030694d-3*t114*t134*t47
              t137 = 1/rhoa**3
              t138 = 1.767585332069357d-1*t49*t54*t55*t66*t90
              t139 = 1/t95
              t140 = -1.3595691172479402d+0*t26*t53-7.491972878592053d-1
     1           *t25*t52-2.1504862356383217d-1*t24*t51-1.27434173008489
     2           14d-1*t1*t50
              t141 = 1/t94**2
              t142 = -2.1319703304396778d+0*t25*t52*t84*t85*t86
              t143 = 2.6513779981040353d-1*t25*t49*t52*t85*t88
              t144 = -1.3256889990520176d-1*t25*t49*t52*t55*t91
              t145 = 1/t20**4
              t146 = 1.3134520888888887d-206*t119*t145*t38
              t147 = 6.355413333333333d-155*t101*t58*t76
              t148 = -1.4658503192165973d-205*t119*t145
              fnc(iq) = (1.0d+0*(2.4799999999999997d-52*t1*t21*(5.951530
     1           8d+0-2.7677513495999995d-51*t1*t21)+1.0d+0)*(t22-1.2436
     2           28d-1*rhoa*(1.0522000558389212d-1*t9+1.0d+0)*log(1.6081
     3           979498692536d+1/(1.766435620181429d+0*t9+5.659885156639
     4           418d-1*t8+1.19503784087549d-1*t6+5.329846514438383d+0*t
     5           10)+1.0d+0))+1.0d+0*rhoa*t19*t5)*wght+fnc(iq)
              Amat(iq,D1_RA) = (1.0d+0*t59*t60+1.0d+0*t39*t56+5.0d-1*rho
     1           a*t32*t5+5.0d-1*t19*t5+5.0d-1*rhoa*t19*t37)*wght+Amat(i
     2           q,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RA_RA) = (t81+5.0d-1*rhoa*t19*t80+5.0d-1*rhoa*
     1           t5*t74+1.0d+0*t107*t60+1.0d+0*t32*t5+1.0d+0*t100*t39+1.
     2           0d+0*rhoa*t32*t37+1.0d+0*t19*t37)*wght+Amat2(iq,D2_RA_R
     3           A)
              Amat2(iq,D2_RA_RB) = (t81+1.0d+0*t111*t60+1.0d+0*t109*t39)
     1           *wght+Amat2(iq,D2_RA_RB)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Amat3(iq,D3_RA_RA_RA) = (1.0d+0*t39*(2*rhoa*(-7.5d-1*t139*
     1           t140*t141*t97*t98-2.533029591058444d-2*t137*t96*t97-5.8
     2           2714947393947d-4*t114*t52*t96+t144+t143+t142+t138+t136+
     3           t135+t133+t132+t131+t130+t129)+2.5330295910584444d-2*t9
     4           6*t97*t98-3.0d+0*t14*t29*t31*t73+6.0d+0*t14*t29*t70*t72
     5           -9.649187699215522d+1*t14*t69*t70*t71-3.330669073875469
     6           6d-16*t18*t23*t28*t68+1.2202564577405706d-18*t17*t66+5.
     7           284159572535705d-3*t13*t66+6.661338147750939d-16*t18*t2
     8           3*t62*t64-5.356375176299456d-15*t18*t61*t62*t63+2.54939
     9           2377400174d-1*t25*t29*t30*t31+2.943620900479655d-17*t23
     :           *t25*t27*t28+t127+t126+t125+t124+t123-rhoa*t117)+1.5d+0
     ;           *rhoa*t32*t80+1.5d+0*t19*t80+5.0d-1*rhoa*t19*(-1.2d-50*
     <           t3*t35*t79+2.88d-101*t33*t34*t79+3.2d-50*t3*t36*t78-1.7
     =           279999999999998d-100*t33*t36*t77+2.3040000000000002d-15
     >           1*t36*t75*t76+2.4d-51*t1*t3*(-2.2198218931199998d-150*t
     ?           120*t75+7.778863044266666d-100*t121*t33-8.6958834844444
     @           43d-50*t122*t3+2.04906636288d-201*t118*t119)-9.98400000
     1           0000001d-151*t120*t4*t75+3.4986666666666666d-100*t121*t
     2           33*t4-3.911111111111111d-50*t122*t3*t4+9.21600000000000
     3           1d-202*t118*t119*t4)+1.0d+0*t60*(1.6533333333333333d-51
     4           *t21*t58*t78-6.662933333333332d-103*t57*t58*t77+2.47999
     5           99999999997d-52*t1*t21*(-1.3219600520163555d-101*t121*t
     6           57+2.2552048033777775d-50*t122*t21+t148+2.4824884438345
     7           599d-153*t101*t120)+1.1845214814814811d-102*t121*t38*t5
     8           7+1.5375999999999998d-103*t106*t34*t57-2.02074074074074
     9           04d-51*t122*t21*t38-2.2243946666666667d-154*t101*t120*t
     :           38-6.2d-52*t106*t21*t35+t147+t146)+1.5d+0*t5*t74+1.5d+0
     ;           *rhoa*t37*t74+3.0d+0*t100*t59+3.0d+0*t107*t56+5.0d-1*rh
     <           oa*t117*t5+3.0d+0*t32*t37)*wght+Amat3(iq,D3_RA_RA_RA)
              Amat3(iq,D3_RA_RA_RB) = (1.0d+0*t39*(2*rhoa*(2.5d-1*t139*t
     1           140*t141*t97*t98+8.443431970194815d-3*t137*t96*t97+1.94
     2           23831579798237d-4*t114*t52*t96+t144+t143+t142+t138+t136
     3           +t135+t133+t132+t131+t130+t129)+t127+t126+t125+t124+t12
     4           3+t108)+1.0d+0*t60*(5.51111111111111d-52*t21*t58*t78-3.
     5           929422222222222d-103*t57*t58*t77+2.4799999999999997d-52
     6           *t1*t21*(-2.542230869262222d-102*t121*t57+t148+1.221541
     7           9326804977d-153*t101*t120)+2.2779259259259252d-103*t121
     8           *t38*t57+1.0250666666666666d-103*t110*t34*t57+5.1253333
     9           33333333d-104*t106*t34*t57-1.0945434074074073d-154*t101
     :           *t120*t38-4.1333333333333333d-52*t110*t21*t35-2.0666666
     ;           666666667d-52*t106*t21*t35+t147+t146)+2.0d+0*t109*t59+1
     <           .0d+0*t100*t59+2.0d+0*t111*t56+1.0d+0*t107*t56)*wght+Am
     =           at3(iq,D3_RA_RA_RB)
              Cmat3(iq,D3_RA_RA_GAA) = Cmat3(iq,D3_RA_RA_GAA)
              Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
              Cmat3(iq,D3_RA_RA_GBB) = Cmat3(iq,D3_RA_RA_GBB)
              Cmat3(iq,D3_RA_RB_GAA) = Cmat3(iq,D3_RA_RB_GAA)
              Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
              Cmat3(iq,D3_RA_GAA_GAA) = Cmat3(iq,D3_RA_GAA_GAA)
              Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
              Cmat3(iq,D3_RA_GAA_GBB) = Cmat3(iq,D3_RA_GAA_GBB)
              Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
              Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
              Cmat3(iq,D3_RA_GBB_GBB) = Cmat3(iq,D3_RA_GBB_GBB)
              Cmat3(iq,D3_GAA_GAA_GAA) = Cmat3(iq,D3_GAA_GAA_GAA)
              Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
              Cmat3(iq,D3_GAA_GAA_GBB) = Cmat3(iq,D3_GAA_GAA_GBB)
              Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
              Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
              Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
              Mmat3(iq,D3_RA_RA_TA) = Mmat3(iq,D3_RA_RA_TA)
              Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
              Mmat3(iq,D3_RA_RB_TA) = Mmat3(iq,D3_RA_RB_TA)
              Mmat3(iq,D3_RA_GAA_TA) = Mmat3(iq,D3_RA_GAA_TA)
              Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
              Mmat3(iq,D3_RA_GAB_TA) = Mmat3(iq,D3_RA_GAB_TA)
              Mmat3(iq,D3_RA_GAB_TB) = Mmat3(iq,D3_RA_GAB_TB)
              Mmat3(iq,D3_RA_GBB_TA) = Mmat3(iq,D3_RA_GBB_TA)
              Mmat3(iq,D3_RA_GBB_TB) = Mmat3(iq,D3_RA_GBB_TB)
              Mmat3(iq,D3_GAA_GAA_TA) = Mmat3(iq,D3_GAA_GAA_TA)
              Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
              Mmat3(iq,D3_GAA_GAB_TA) = Mmat3(iq,D3_GAA_GAB_TA)
              Mmat3(iq,D3_GAA_GAB_TB) = Mmat3(iq,D3_GAA_GAB_TB)
              Mmat3(iq,D3_GAA_GBB_TA) = Mmat3(iq,D3_GAA_GBB_TA)
              Mmat3(iq,D3_GAB_GAB_TA) = Mmat3(iq,D3_GAB_GAB_TA)
              Mmat3(iq,D3_TA_TA_TA) = Mmat3(iq,D3_TA_TA_TA)
              Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
            endif 
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          taua    = tau(iq,T_A) 
          taub    = tau(iq,T_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhoa**2.6666666666666666d+0
              t2 = 1/rhob**2.6666666666666666d+0
              t3 = gammabb*t2+gammaaa*t1
              t4 = 3.1d-3*t3+1.0d+0
              t5 = 1/t4
              t6 = 5.9515308d+0-3.459689187d-2*t3*t5
              t7 = 3.1d-3*t3*t5*t6+1.0d+0
              t8 = 1/rhoa**6.666666666666666d-1
              t9 = rhoa**5.0d-1
              t10 = 1/t9
              t11 = 1/rhoa**3.333333333333333d-1
              t12 = 1/rhoa**1.6666666666666666d-1
              t13 = 2.4058712912881916d-1*t8+1.1120374863094686d+1*t12+3
     1           .8447462374472113d+0*t11+1.644733775567609d+0*t10
              t14 = 3.216395899738507d+1/t13+1.0d+0
              t15 = log(t14)
              t16 = 1.274696188700087d-1*t11+1.0d+0
              t17 = 1.8970043257475583d-1*t8+5.982550435771079d+0*t12+2.
     1           2255694211506874d+0*t11+8.004286349993635d-1*t10
              t18 = 1.6081979498692536d+1/t17+1.0d+0
              t19 = log(t18)
              t20 = 1.3256889990520176d-1*t11+1.0d+0
              t21 = -6.903522198342671d-18*t19*t20-3.1090699999999993d-2
     1           *t15*t16
              t22 = 1/rhob**6.666666666666666d-1
              t23 = rhob**5.0d-1
              t24 = 1/t23
              t25 = 1/rhob**3.333333333333333d-1
              t26 = 1/rhob**1.6666666666666666d-1
              t27 = 1.1120374863094686d+1*t26+3.8447462374472113d+0*t25+
     1           1.644733775567609d+0*t24+2.4058712912881916d-1*t22
              t28 = 3.216395899738507d+1/t27+1.0d+0
              t29 = log(t28)
              t30 = 1.274696188700087d-1*t25+1.0d+0
              t31 = 5.982550435771079d+0*t26+2.2255694211506874d+0*t25+8
     1           .004286349993635d-1*t24+1.8970043257475583d-1*t22
              t32 = 1.6081979498692536d+1/t31+1.0d+0
              t33 = log(t32)
              t34 = 1.3256889990520176d-1*t25+1.0d+0
              t35 = -6.903522198342671d-18*t33*t34-3.1090699999999993d-2
     1           *t29*t30
              t36 = rhob+rhoa
              t37 = 1/t36**3.333333333333333d-1
              t38 = 1.3256889990520176d-1*t37+1.0d+0
              t39 = rhoa-rhob
              t40 = t39**4
              t41 = 1/t36**4
              t42 = 1/t36
              t43 = 1.0d+0-t39*t42
              t44 = t39*t42+1.0d+0
              t45 = t44**1.3333333333333333d+0+t43**1.3333333333333333d+
     1           0-2.0d+0
              t46 = -1.923661050931536d+0*t40*t41*t45
              t47 = t46+1.0d+0
              t48 = 1/t36**6.666666666666666d-1
              t49 = t36**5.0d-1
              t50 = 1/t49
              t51 = 1/t36**1.6666666666666666d-1
              t52 = 5.982550435771079d+0*t51+8.004286349993635d-1*t50+1.
     1           8970043257475583d-1*t48+2.2255694211506874d+0*t37
              t53 = 1.6081979498692536d+1/t52+1.0d+0
              t54 = log(t53)
              t55 = -6.21814d-2*t38*t47*t54
              t56 = 6.901399211255825d-2*t37+1.0d+0
              t57 = t46+1.923661050931536d+0*t45
              t58 = 8.157414703487641d+0*t51+4.3009724712766434d-1*t50+1
     1           .9115125951273373d-1*t48+2.247591863577616d+0*t37
              t59 = 2.9608813203268075d+1/t58+1.0d+0
              t60 = log(t59)
              t61 = 1.9751631321680768d-2*t56*t57*t60
              t62 = 1.274696188700087d-1*t37+1.0d+0
              t63 = 1.1120374863094686d+1*t51+1.644733775567609d+0*t50+2
     1           .4058712912881916d-1*t48+3.8447462374472113d+0*t37
              t64 = 3.216395899738507d+1/t63+1.0d+0
              t65 = log(t64)
              t66 = -5.980796863619711d-2*t40*t41*t45*t62*t65
              t67 = t36*(t66+t61+t55)-rhob*t35-rhoa*t21
              t68 = 6.0d-2*gammaaa*t1+1.0d+0
              t69 = 1/t68
              t70 = 1.3340275799999998d-1*gammaaa*t1*t69-2.5960897d+0
              t71 = 6.0d-2*gammaaa*t1*t69*t70+1.0d+0
              t72 = 1/taua
              t73 = 1/rhoa
              t74 = 2.0d+0*taua-2.5d-1*gammaaa*t73
              t75 = 6.0d-2*gammabb*t2+1.0d+0
              t76 = 1/t75
              t77 = 1.3340275799999998d-1*gammabb*t2*t76-2.5960897d+0
              t78 = 6.0d-2*gammabb*t2*t76*t77+1.0d+0
              t79 = 1/taub
              t80 = 1/rhob
              t81 = 2.0d+0*taub-2.5d-1*gammabb*t80
              t82 = 1/t18
              t83 = 1/rhoa**1.6666666666666669d+0
              t84 = 1/t9**3
              t85 = 1/rhoa**1.3333333333333333d+0
              t86 = 1/rhoa**1.1666666666666667d+0
              t87 = -9.970917392951799d-1*t86-7.418564737168958d-1*t85-4
     1           .002143174996817d-1*t84-1.264669550498372d-1*t83
              t88 = 1/t17**2
              t89 = 1/t14
              t90 = -1.8533958105157808d+0*t86-1.2815820791490704d+0*t85
     1           -8.223668877838045d-1*t84-1.6039141941921276d-1*t83
              t91 = 1/t13**2
              t92 = 1.0d+0*t16*t89*t90*t91+1.1102230246251565d-16*t20*t8
     1           2*t87*t88+3.0506411443514264d-19*t19*t85+1.321039893133
     2           9265d-3*t15*t85
              t93 = 1/t36**1.6666666666666669d+0
              t94 = 1/t49**3
              t95 = 1/t36**1.3333333333333333d+0
              t96 = 1/t36**1.1666666666666667d+0
              t97 = -9.970917392951799d-1*t96-7.418564737168958d-1*t95-4
     1           .002143174996817d-1*t94-1.264669550498372d-1*t93
              t98 = 1/t52**2
              t99 = 1/t53
              t100 = 1.0d+0*t38*t47*t97*t98*t99
              t101 = -1.3595691172479402d+0*t96-7.491972878592053d-1*t95
     1           -2.1504862356383217d-1*t94-1.2743417300848914d-1*t93
              t102 = 1/t58**2
              t103 = 1/t59
              t104 = -5.848223622634647d-1*t101*t102*t103*t56*t57
              t105 = -1.8533958105157808d+0*t96-1.2815820791490704d+0*t9
     1           5-8.223668877838045d-1*t94-1.6039141941921276d-1*t93
              t106 = 1/t63**2
              t107 = 1/t64
              t108 = 1.923661050931536d+0*t105*t106*t107*t40*t41*t45*t62
              t109 = 1/t36**2
              t110 = t109*t39
              t111 = -t42
              t112 = t111+t110
              t113 = t43**3.333333333333333d-1
              t114 = -t109*t39
              t115 = t42+t114
              t116 = t44**3.333333333333333d-1
              t117 = 1.3333333333333333d+0*t115*t116+1.3333333333333333d
     1           +0*t112*t113
              t118 = -1.923661050931536d+0*t117*t40*t41
              t119 = 1/t36**5
              t120 = 7.694644203726144d+0*t119*t40*t45
              t121 = t39**3
              t122 = -7.694644203726144d+0*t121*t41*t45
              t123 = t122+t120+t118
              t124 = -6.21814d-2*t123*t38*t54
              t125 = 2.747773264188437d-3*t47*t54*t95
              t126 = t122+t120+t118+1.923661050931536d+0*t117
              t127 = 1.9751631321680768d-2*t126*t56*t60
              t128 = -4.5437964274821163d-4*t57*t60*t95
              t129 = -5.980796863619711d-2*t117*t40*t41*t62*t65
              t130 = 1/t36**5.333333333333333d+0
              t131 = 2.541232989148493d-3*t130*t40*t45*t65
              t132 = 2.3923187454478842d-1*t119*t40*t45*t62*t65
              t133 = -rhoa*t92+t66+t36*(-2.3923187454478842d-1*t121*t41*
     1           t45*t62*t65+t132+t131+t129+t128+t127+t125+t124+t108+t10
     2           4+t100)+t61+t55+6.903522198342671d-18*t19*t20+3.1090699
     3           999999993d-2*t15*t16
              t134 = 1/rhoa**3.6666666666666664d+0
              t135 = 1/t4**2
              t136 = 9.225837832d-2*gammaaa*t134*t5-2.86000972792d-4*gam
     1           maaa*t134*t135*t3
              t137 = -8.266666666666665d-3*gammaaa*t134*t5*t6+2.56266666
     1           6666666d-5*gammaaa*t134*t135*t3*t6+3.1d-3*t136*t3*t5
              t138 = gammaaa**2
              t139 = 1/t68**2
              t140 = 1/rhoa**6.333333333333333d+0
              t141 = 2.1344441279999993d-2*t138*t139*t140-3.557406879999
     1           999d-1*gammaaa*t134*t69
              t142 = -1.5999999999999998d-1*gammaaa*t134*t69*t70+9.59999
     1           9999999997d-3*t138*t139*t140*t70+6.0d-2*gammaaa*t1*t141
     2           *t69
              t143 = 1/t32
              t144 = 1/rhob**1.6666666666666669d+0
              t145 = 1/t23**3
              t146 = 1/rhob**1.3333333333333333d+0
              t147 = 1/rhob**1.1666666666666667d+0
              t148 = -9.970917392951799d-1*t147-7.418564737168958d-1*t14
     1           6-4.002143174996817d-1*t145-1.264669550498372d-1*t144
              t149 = 1/t31**2
              t150 = 1/t28
              t151 = -1.8533958105157808d+0*t147-1.2815820791490704d+0*t
     1           146-8.223668877838045d-1*t145-1.6039141941921276d-1*t14
     2           4
              t152 = 1/t27**2
              t153 = 1.1102230246251565d-16*t143*t148*t149*t34+3.0506411
     1           443514264d-19*t146*t33+1.0d+0*t150*t151*t152*t30+1.3210
     2           398931339265d-3*t146*t29
              t154 = t42+t110
              t155 = t114+t111
              t156 = 1.3333333333333333d+0*t116*t155+1.3333333333333333d
     1           +0*t113*t154
              t157 = -1.923661050931536d+0*t156*t40*t41
              t158 = 7.694644203726144d+0*t121*t41*t45
              t159 = t158+t157+t120
              t160 = -6.21814d-2*t159*t38*t54
              t161 = t158+t157+1.923661050931536d+0*t156+t120
              t162 = 1.9751631321680768d-2*t161*t56*t60
              t163 = -5.980796863619711d-2*t156*t40*t41*t62*t65
              t164 = t66+t36*(2.3923187454478842d-1*t121*t41*t45*t62*t65
     1           +t163+t162+t160+t132+t131+t128+t125+t108+t104+t100)+t61
     2           +t55+6.903522198342671d-18*t33*t34+3.1090699999999993d-
     3           2*t29*t30-rhob*t153
              t165 = 1/rhob**3.6666666666666664d+0
              t166 = 9.225837832d-2*gammabb*t165*t5-2.86000972792d-4*gam
     1           mabb*t135*t165*t3
              t167 = -8.266666666666665d-3*gammabb*t165*t5*t6+2.56266666
     1           6666666d-5*gammabb*t135*t165*t3*t6+3.1d-3*t166*t3*t5
              t168 = gammabb**2
              t169 = 1/t75**2
              t170 = 1/rhob**6.333333333333333d+0
              t171 = 2.1344441279999993d-2*t168*t169*t170-3.557406879999
     1           999d-1*gammabb*t165*t76
              t172 = -1.5999999999999998d-1*gammabb*t165*t76*t77+9.59999
     1           9999999997d-3*t168*t169*t170*t77+6.0d-2*gammabb*t171*t2
     2           *t76
              t173 = 1.07250364797d-4*t1*t135*t3-3.459689187d-2*t1*t5
              t174 = 3.1d-3*t1*t5*t6-9.61d-6*t1*t135*t3*t6+3.1d-3*t173*t
     1           3*t5
              t175 = -1.25d-1*t21*t71
              t176 = 1/rhoa**5.333333333333333d+0
              t177 = 1.3340275799999998d-1*t1*t69-8.004165479999998d-3*g
     1           ammaaa*t139*t176
              t178 = 6.0d-2*t1*t69*t70-3.6d-3*gammaaa*t139*t176*t70+6.0d
     1           -2*gammaaa*t1*t177*t69
              t179 = 1.07250364797d-4*t135*t2*t3-3.459689187d-2*t2*t5
              t180 = 3.1d-3*t2*t5*t6-9.61d-6*t135*t2*t3*t6+3.1d-3*t179*t
     1           3*t5
              t181 = -1.25d-1*t35*t78
              t182 = 1/rhob**5.333333333333333d+0
              t183 = 1.3340275799999998d-1*t2*t76-8.004165479999998d-3*g
     1           ammabb*t169*t182
              t184 = 6.0d-2*t2*t76*t77-3.6d-3*gammabb*t169*t182*t77+6.0d
     1           -2*gammabb*t183*t2*t76
              t185 = 1/taua**2
              t186 = 1/taub**2
              t187 = 1/t18**2
              t188 = t87**2
              t189 = 1/t17**4
              t190 = 1/t17**3
              t191 = 1/t9**5
              t192 = 1/rhoa**2.3333333333333334d+0
              t193 = 1/rhoa**2.1666666666666665d+0
              t194 = 1.1632736958443765d+0*t193+9.89141964955861d-1*t192
     1           +6.003214762495226d-1*t191+2.1077825841639536d-1*t1
              t195 = 1/t14**2
              t196 = t90**2
              t197 = 1/t13**4
              t198 = 1/t13**3
              t199 = 2.1622951122684114d+0*t193+1.7087761055320938d+0*t1
     1           92+1.2335503316757068d+0*t191+2.673190323653546d-1*t1
              t200 = -8.497974591333913d-2*t85*t89*t90*t91+1.0d+0*t16*t1
     1           99*t89*t91-2.0d+0*t16*t196*t198*t89-9.812069668265515d-
     2           18*t82*t85*t87*t88+1.1102230246251565d-16*t194*t20*t82*
     3           t88-2.220446049250313d-16*t188*t190*t20*t82+1.785458392
     4           0998188d-15*t187*t188*t189*t20+3.216395899738507d+1*t16
     5           *t195*t196*t197-4.0675215258019015d-19*t19*t192-1.76138
     6           65241785684d-3*t15*t192
              t201 = 2.0d+0*t38*t47*t97*t98*t99
              t202 = -1.1696447245269295d+0*t101*t102*t103*t56*t57
              t203 = 3.847322101863072d+0*t105*t106*t107*t40*t41*t45*t62
              t204 = 5.495546528376875d-3*t47*t54*t95
              t205 = -9.087592854964233d-4*t57*t60*t95
              t206 = 5.082465978296986d-3*t130*t40*t45*t65
              t207 = 4.7846374908957684d-1*t119*t40*t45*t62*t65
              t208 = t97**2
              t209 = 1/t52**4
              t210 = 1/t53**2
              t211 = 1.6081979498692536d+1*t208*t209*t210*t38*t47
              t212 = 2.0d+0*t123*t38*t97*t98*t99
              t213 = 1/t52**3
              t214 = -2.0d+0*t208*t213*t38*t47*t99
              t215 = -8.837926660346784d-2*t47*t95*t97*t98*t99
              t216 = 1/t36**2.6666666666666666d+0
              t217 = 1/t49**5
              t218 = 1/t36**2.3333333333333334d+0
              t219 = 1/t36**2.1666666666666665d+0
              t220 = 1.1632736958443765d+0*t219+9.89141964955861d-1*t218
     1           +6.003214762495226d-1*t217+2.1077825841639536d-1*t216
              t221 = 1.0d+0*t220*t38*t47*t98*t99
              t222 = t101**2
              t223 = 1/t58**4
              t224 = 1/t59**2
              t225 = -1.73158960813529d+1*t222*t223*t224*t56*t57
              t226 = -1.1696447245269295d+0*t101*t102*t103*t126*t56
              t227 = 1/t58**3
              t228 = 1.1696447245269295d+0*t103*t222*t227*t56*t57
              t229 = 2.690728393099896d-2*t101*t102*t103*t57*t95
              t230 = 1.5861639701225969d+0*t219+9.98929717145607d-1*t218
     1           +3.2257293534574827d-1*t217+2.1239028834748191d-1*t216
              t231 = -5.848223622634647d-1*t102*t103*t230*t56*t57
              t232 = t105**2
              t233 = 1/t63**4
              t234 = 1/t64**2
              t235 = 6.187255516702861d+1*t232*t233*t234*t40*t41*t45*t62
              t236 = 3.847322101863072d+0*t105*t106*t107*t117*t40*t41*t6
     1           2
              t237 = 1/t63**3
              t238 = -3.847322101863072d+0*t107*t232*t237*t40*t41*t45*t6
     1           2
              t239 = -1.6347222733154887d-1*t105*t106*t107*t130*t40*t45
              t240 = 2.1622951122684114d+0*t219+1.7087761055320938d+0*t2
     1           18+1.2335503316757068d+0*t217+2.673190323653546d-1*t216
              t241 = 1.923661050931536d+0*t106*t107*t240*t40*t41*t45*t62
              t242 = -1.538928840745229d+1*t105*t106*t107*t119*t40*t45*t
     1           62
              t243 = 1.538928840745229d+1*t105*t106*t107*t121*t41*t45*t6
     1           2
              t244 = t112**2
              t245 = 1/t43**6.666666666666666d-1
              t246 = 1/t36**3
              t247 = -2*t246*t39
              t248 = 2*t109
              t249 = t248+t247
              t250 = t115**2
              t251 = 1/t44**6.666666666666666d-1
              t252 = 2*t246*t39
              t253 = -2*t109
              t254 = t253+t252
              t255 = 1.3333333333333333d+0*t116*t254+4.444444444444444d-
     1           1*t250*t251+1.3333333333333333d+0*t113*t249+4.444444444
     2           444444d-1*t244*t245
              t256 = -1.923661050931536d+0*t255*t40*t41
              t257 = 1.5389288407452287d+1*t117*t119*t40
              t258 = -1.5389288407452287d+1*t117*t121*t41
              t259 = 1/t36**6
              t260 = -3.8473221018630716d+1*t259*t40*t45
              t261 = 6.155715362980915d+1*t119*t121*t45
              t262 = t39**2
              t263 = -2.3083932611178434d+1*t262*t41*t45
              t264 = t263+t261+t260+t258+t257+t256
              t265 = -6.21814d-2*t264*t38*t54
              t266 = 5.495546528376875d-3*t123*t54*t95
              t267 = -3.663697685584583d-3*t218*t47*t54
              t268 = t263+t261+t260+t258+t257+t256+1.923661050931536d+0*
     1           t255
              t269 = 1.9751631321680768d-2*t268*t56*t60
              t270 = -9.087592854964233d-4*t126*t60*t95
              t271 = 6.058395236642822d-4*t218*t57*t60
              t272 = -5.980796863619711d-2*t255*t40*t41*t62*t65
              t273 = 5.082465978296986d-3*t117*t130*t40*t65
              t274 = 4.7846374908957684d-1*t117*t119*t40*t62*t65
              t275 = 1/t36**6.333333333333333d+0
              t276 = -2.3718174565385935d-2*t275*t40*t45*t65
              t277 = 2.0329863913187946d-2*t121*t130*t45*t65
              t278 = -1.1961593727239421d+0*t259*t40*t45*t62*t65
              t279 = 1.9138549963583074d+0*t119*t121*t45*t62*t65
              t280 = -7.176956236343652d-1*t262*t41*t45*t62*t65
              t281 = -2.0d+0*t16*t89*t90*t91-2.220446049250313d-16*t20*t
     1           82*t87*t88-6.101282288702853d-19*t19*t85-2.642079786267
     2           853d-3*t15*t85+t36*(-4.7846374908957684d-1*t117*t121*t4
     3           1*t62*t65+t280+t279+t278+t277+t276+t274+t273+t272+t271+
     4           t270+t269+t267+t266+t265+t243+t242+t241+t239+t238+t236+
     5           t235+t231+t229+t228+t226+t225+t221+t215+t214+t212+t211)
     6           -4.7846374908957684d-1*t121*t41*t45*t62*t65-1.196159372
     7           7239421d-1*t117*t40*t41*t62*t65+3.9503262643361536d-2*t
     8           126*t56*t60-1.243628d-1*t123*t38*t54+t207+t206+t205+t20
     9           4+t203+t202+t201-rhoa*t200
              t282 = 1/rhoa**7.333333333333333d+0
              t283 = 1/t4**3
              t284 = 1/rhoa**4.666666666666667d+0
              t285 = -3.3828072050666663d-1*gammaaa*t284*t5+1.0486702335
     1           706666d-3*gammaaa*t135*t284*t3-4.728549416827732d-6*t13
     2           8*t282*t283*t3+1.525338521557333d-3*t135*t138*t282
              t286 = 3.0311111111111105d-2*gammaaa*t284*t5*t6-9.39644444
     1           4444442d-5*gammaaa*t135*t284*t3*t6+4.2369422222222203d-
     2           7*t138*t282*t283*t3*t6-1.366755555555555d-4*t135*t138*t
     3           282*t6+3.1d-3*t285*t3*t5-1.653333333333333d-2*gammaaa*t
     4           134*t136*t5+5.125333333333332d-5*gammaaa*t134*t135*t136
     5           *t3
              t287 = 1/rhoa**2
              t288 = gammaaa**3
              t289 = 1/t68**3
              t290 = 1/rhoa**10
              t291 = 1.3043825226666664d+0*gammaaa*t284*t69+6.8302212095
     1           99997d-3*t288*t289*t290-1.9209997151999994d-1*t138*t139
     2           *t282
              t292 = 5.866666666666666d-1*gammaaa*t284*t69*t70+3.0719999
     1           999999986d-3*t288*t289*t290*t70-8.639999999999998d-2*t1
     2           38*t139*t282*t70+6.0d-2*gammaaa*t1*t291*t69-3.199999999
     3           9999995d-1*gammaaa*t134*t141*t69+1.9199999999999995d-2*
     4           t138*t139*t140*t141
              t293 = 2.6666666666666666d+0*t116*t246*t39-2.6666666666666
     1           666d+0*t113*t246*t39+4.444444444444444d-1*t115*t155*t25
     2           1+4.444444444444444d-1*t112*t154*t245
              t294 = -1.923661050931536d+0*t293*t40*t41
              t295 = 7.694644203726144d+0*t119*t156*t40
              t296 = -7.694644203726144d+0*t121*t156*t41
              t297 = 7.694644203726144d+0*t117*t119*t40
              t298 = 7.694644203726144d+0*t117*t121*t41
              t299 = 2.3083932611178434d+1*t262*t41*t45
              t300 = t299+t298+t297+t296+t295+t294+t260
              t301 = t299+t298+t297+t296+t295+t294+1.923661050931536d+0*
     1           t293+t260
              t302 = 7.176956236343652d-1*t262*t41*t45*t62*t65
              t303 = t36*(1.0d+0*t159*t38*t97*t98*t99+1.0d+0*t123*t38*t9
     1           7*t98*t99-4.5437964274821163d-4*t161*t60*t95-4.54379642
     2           74821163d-4*t126*t60*t95+2.747773264188437d-3*t159*t54*
     3           t95+2.747773264188437d-3*t123*t54*t95-5.980796863619711
     4           d-2*t293*t40*t41*t62*t65-2.3923187454478842d-1*t121*t15
     5           6*t41*t62*t65+2.3923187454478842d-1*t117*t121*t41*t62*t
     6           65+2.3923187454478842d-1*t119*t156*t40*t62*t65+2.392318
     7           7454478842d-1*t117*t119*t40*t62*t65+2.541232989148493d-
     8           3*t130*t156*t40*t65+2.541232989148493d-3*t117*t130*t40*
     9           t65+1.923661050931536d+0*t105*t106*t107*t156*t40*t41*t6
     :           2+1.923661050931536d+0*t105*t106*t107*t117*t40*t41*t62+
     ;           1.9751631321680768d-2*t301*t56*t60-5.848223622634647d-1
     <           *t101*t102*t103*t161*t56-5.848223622634647d-1*t101*t102
     =           *t103*t126*t56-6.21814d-2*t300*t38*t54+t302+t278+t276+t
     >           271+t267+t242+t241+t239+t238+t235+t231+t229+t228+t225+t
     ?           221+t215+t214+t211)+t207+t206+t205+t204+t203+t202+t201+
     @           t163+t162+t160+t129+t127+t124
              t304 = 1.525338521557333d-3*gammaaa*gammabb*t134*t135*t165
     1           -4.728549416827732d-6*gammaaa*gammabb*t134*t165*t283*t3
              t305 = 4.2369422222222203d-7*gammaaa*gammabb*t134*t165*t28
     1           3*t3*t6-1.366755555555555d-4*gammaaa*gammabb*t134*t135*
     2           t165*t6+3.1d-3*t3*t304*t5-8.266666666666665d-3*gammaaa*
     3           t134*t166*t5-8.266666666666665d-3*gammabb*t136*t165*t5+
     4           2.562666666666666d-5*gammaaa*t134*t135*t166*t3+2.562666
     5           666666666d-5*gammabb*t135*t136*t165*t3
              t306 = 1/t32**2
              t307 = t148**2
              t308 = 1/t31**4
              t309 = 1/t31**3
              t310 = 1/t23**5
              t311 = 1/rhob**2.3333333333333334d+0
              t312 = 1/rhob**2.1666666666666665d+0
              t313 = 1.1632736958443765d+0*t312+9.89141964955861d-1*t311
     1           +6.003214762495226d-1*t310+2.1077825841639536d-1*t2
              t314 = 1/t28**2
              t315 = t151**2
              t316 = 1/t27**4
              t317 = 1/t27**3
              t318 = 2.1622951122684114d+0*t312+1.7087761055320938d+0*t3
     1           11+1.2335503316757068d+0*t310+2.673190323653546d-1*t2
              t319 = 1.1102230246251565d-16*t143*t149*t313*t34-2.2204460
     1           49250313d-16*t143*t307*t309*t34+1.7854583920998188d-15*
     2           t306*t307*t308*t34-4.0675215258019015d-19*t311*t33+1.0d
     3           +0*t150*t152*t30*t318-2.0d+0*t150*t30*t315*t317+3.21639
     4           5899738507d+1*t30*t314*t315*t316-1.7613865241785684d-3*
     5           t29*t311-8.497974591333913d-2*t146*t150*t151*t152-9.812
     6           069668265515d-18*t143*t146*t148*t149
              t320 = 2.0d+0*t159*t38*t97*t98*t99
              t321 = -1.1696447245269295d+0*t101*t102*t103*t161*t56
              t322 = 3.847322101863072d+0*t105*t106*t107*t156*t40*t41*t6
     1           2
              t323 = -1.538928840745229d+1*t105*t106*t107*t121*t41*t45*t
     1           62
              t324 = t154**2
              t325 = t253+t247
              t326 = t155**2
              t327 = t252+t248
              t328 = 1.3333333333333333d+0*t116*t327+4.444444444444444d-
     1           1*t251*t326+1.3333333333333333d+0*t113*t325+4.444444444
     2           444444d-1*t245*t324
              t329 = -1.923661050931536d+0*t328*t40*t41
              t330 = 1.5389288407452287d+1*t119*t156*t40
              t331 = 1.5389288407452287d+1*t121*t156*t41
              t332 = -6.155715362980915d+1*t119*t121*t45
              t333 = t332+t331+t330+t329+t263+t260
              t334 = -6.21814d-2*t333*t38*t54
              t335 = 5.495546528376875d-3*t159*t54*t95
              t336 = t332+t331+t330+t329+1.923661050931536d+0*t328+t263+
     1           t260
              t337 = 1.9751631321680768d-2*t336*t56*t60
              t338 = -9.087592854964233d-4*t161*t60*t95
              t339 = -5.980796863619711d-2*t328*t40*t41*t62*t65
              t340 = 5.082465978296986d-3*t130*t156*t40*t65
              t341 = 4.7846374908957684d-1*t119*t156*t40*t62*t65
              t342 = -2.0329863913187946d-2*t121*t130*t45*t65
              t343 = -1.9138549963583074d+0*t119*t121*t45*t62*t65
              t344 = t36*(4.7846374908957684d-1*t121*t156*t41*t62*t65+t3
     1           43+t342+t341+t340+t339+t338+t337+t335+t334+t323+t322+t3
     2           21+t320+t280+t278+t276+t271+t267+t242+t241+t239+t238+t2
     3           35+t231+t229+t228+t225+t221+t215+t214+t211)+4.784637490
     4           8957684d-1*t121*t41*t45*t62*t65-1.1961593727239421d-1*t
     5           156*t40*t41*t62*t65+3.9503262643361536d-2*t161*t56*t60-
     6           1.243628d-1*t159*t38*t54-2.220446049250313d-16*t143*t14
     7           8*t149*t34-6.101282288702853d-19*t146*t33-rhob*t319-2.0
     8           d+0*t150*t151*t152*t30-2.642079786267853d-3*t146*t29+t2
     9           07+t206+t205+t204+t203+t202+t201
              t345 = 1/rhob**7.333333333333333d+0
              t346 = 1/rhob**4.666666666666667d+0
              t347 = -3.3828072050666663d-1*gammabb*t346*t5+1.0486702335
     1           706666d-3*gammabb*t135*t3*t346-4.728549416827732d-6*t16
     2           8*t283*t3*t345+1.525338521557333d-3*t135*t168*t345
              t348 = 3.0311111111111105d-2*gammabb*t346*t5*t6-9.39644444
     1           4444442d-5*gammabb*t135*t3*t346*t6+4.2369422222222203d-
     2           7*t168*t283*t3*t345*t6-1.366755555555555d-4*t135*t168*t
     3           345*t6+3.1d-3*t3*t347*t5-1.653333333333333d-2*gammabb*t
     4           165*t166*t5+5.125333333333332d-5*gammabb*t135*t165*t166
     5           *t3
              t349 = 1/rhob**2
              t350 = gammabb**3
              t351 = 1/t75**3
              t352 = 1/rhob**10
              t353 = 1.3043825226666664d+0*gammabb*t346*t76+6.8302212095
     1           99997d-3*t350*t351*t352-1.9209997151999994d-1*t168*t169
     2           *t345
              t354 = 5.866666666666666d-1*gammabb*t346*t76*t77+3.0719999
     1           999999986d-3*t350*t351*t352*t77-8.639999999999998d-2*t1
     2           68*t169*t345*t77+6.0d-2*gammabb*t2*t353*t76-3.199999999
     3           9999995d-1*gammabb*t165*t171*t76+1.9199999999999995d-2*
     4           t168*t169*t170*t171
              t355 = 9.225837832d-2*t134*t5+1.7732060313103998d-6*gammaa
     1           a*t140*t283*t3-2.86000972792d-4*t134*t135*t3-5.72001945
     2           584d-4*gammaaa*t135*t140
              t356 = -8.266666666666665d-3*t134*t5*t6-1.5888533333333327
     1           d-7*gammaaa*t140*t283*t3*t6+2.562666666666666d-5*t134*t
     2           135*t3*t6+5.125333333333332d-5*gammaaa*t135*t140*t6+3.1
     3           d-3*t3*t355*t5-8.266666666666665d-3*gammaaa*t134*t173*t
     4           5+3.1d-3*t1*t136*t5+2.562666666666666d-5*gammaaa*t134*t
     5           135*t173*t3-9.61d-6*t1*t135*t136*t3
              t357 = 1.25d-1*t21*t71
              t358 = 1/rhoa**9
              t359 = -3.557406879999999d-1*t134*t69-2.561332953599999d-3
     1           *t138*t289*t358+6.403332383999999d-2*gammaaa*t139*t140
              t360 = -1.5999999999999998d-1*t134*t69*t70-1.1519999999999
     1           996d-3*t138*t289*t358*t70+2.879999999999999d-2*gammaaa*
     2           t139*t140*t70+6.0d-2*gammaaa*t1*t359*t69-1.599999999999
     3           9998d-1*gammaaa*t134*t177*t69+6.0d-2*t1*t141*t69+9.5999
     4           99999999997d-3*t138*t139*t140*t177-3.6d-3*gammaaa*t139*
     5           t141*t176
              t361 = 1.7732060313103998d-6*gammaaa*t134*t2*t283*t3-5.720
     1           01945584d-4*gammaaa*t134*t135*t2
              t362 = -1.5888533333333327d-7*gammaaa*t134*t2*t283*t3*t6+5
     1           .125333333333332d-5*gammaaa*t134*t135*t2*t6+3.1d-3*t3*t
     2           361*t5+3.1d-3*t136*t2*t5-8.266666666666665d-3*gammaaa*t
     3           134*t179*t5-9.61d-6*t135*t136*t2*t3+2.562666666666666d-
     4           5*gammaaa*t134*t135*t179*t3
              t363 = 1.7732060313103998d-6*gammabb*t1*t165*t283*t3-5.720
     1           01945584d-4*gammabb*t1*t135*t165
              t364 = -1.5888533333333327d-7*gammabb*t1*t165*t283*t3*t6+5
     1           .125333333333332d-5*gammabb*t1*t135*t165*t6+3.1d-3*t3*t
     2           363*t5-8.266666666666665d-3*gammabb*t165*t173*t5+3.1d-3
     3           *t1*t166*t5+2.562666666666666d-5*gammabb*t135*t165*t173
     4           *t3-9.61d-6*t1*t135*t166*t3
              t365 = 9.225837832d-2*t165*t5+1.7732060313103998d-6*gammab
     1           b*t170*t283*t3-2.86000972792d-4*t135*t165*t3-5.72001945
     2           584d-4*gammabb*t135*t170
              t366 = -8.266666666666665d-3*t165*t5*t6-1.5888533333333327
     1           d-7*gammabb*t170*t283*t3*t6+2.562666666666666d-5*t135*t
     2           165*t3*t6+5.125333333333332d-5*gammabb*t135*t170*t6+3.1
     3           d-3*t3*t365*t5+3.1d-3*t166*t2*t5-8.266666666666665d-3*g
     4           ammabb*t165*t179*t5-9.61d-6*t135*t166*t2*t3+2.562666666
     5           666666d-5*gammabb*t135*t165*t179*t3
              t367 = 1.25d-1*t35*t78
              t368 = 1/rhob**9
              t369 = -3.557406879999999d-1*t165*t76-2.561332953599999d-3
     1           *t168*t351*t368+6.403332383999999d-2*gammabb*t169*t170
              t370 = -1.5999999999999998d-1*t165*t76*t77-1.1519999999999
     1           996d-3*t168*t351*t368*t77+2.879999999999999d-2*gammabb*
     2           t169*t170*t77+6.0d-2*gammabb*t2*t369*t76+6.0d-2*t171*t2
     3           *t76-1.5999999999999998d-1*gammabb*t165*t183*t76+9.5999
     4           99999999997d-3*t168*t169*t170*t183-3.6d-3*gammabb*t169*
     5           t171*t182
              t371 = 2.14500729594d-4*t135*t176-6.649522617413999d-7*t17
     1           6*t283*t3
              t372 = 5.9582d-8*t176*t283*t3*t6-1.9219999999999998d-5*t13
     1           5*t176*t6+3.1d-3*t3*t371*t5+6.2d-3*t1*t173*t5-1.9219999
     2           999999998d-5*t1*t135*t173*t3
              t373 = 1/rhoa**8
              t374 = 9.604998575999998d-4*gammaaa*t289*t373-1.6008330959
     1           999997d-2*t139*t176
              t375 = 4.32d-4*gammaaa*t289*t373*t70-7.2d-3*t139*t176*t70+
     1           6.0d-2*gammaaa*t1*t374*t69+1.2d-1*t1*t177*t69-7.2d-3*ga
     2           mmaaa*t139*t176*t177
              t376 = 2.14500729594d-4*t1*t135*t2-6.649522617413999d-7*t1
     1           *t2*t283*t3
              t377 = 5.9582d-8*t1*t2*t283*t3*t6-1.9219999999999998d-5*t1
     1           *t135*t2*t6+3.1d-3*t3*t376*t5+3.1d-3*t173*t2*t5+3.1d-3*
     2           t1*t179*t5-9.61d-6*t135*t173*t2*t3-9.61d-6*t1*t135*t179
     3           *t3
              t378 = 2.14500729594d-4*t135*t182-6.649522617413999d-7*t18
     1           2*t283*t3
              t379 = 5.9582d-8*t182*t283*t3*t6-1.9219999999999998d-5*t13
     1           5*t182*t6+3.1d-3*t3*t378*t5+6.2d-3*t179*t2*t5-1.9219999
     2           999999998d-5*t135*t179*t2*t3
              t380 = 1/rhob**8
              t381 = 9.604998575999998d-4*gammabb*t351*t380-1.6008330959
     1           999997d-2*t169*t182
              t382 = 4.32d-4*gammabb*t351*t380*t77-7.2d-3*t169*t182*t77+
     1           6.0d-2*gammabb*t2*t381*t76+1.2d-1*t183*t2*t76-7.2d-3*ga
     2           mmabb*t169*t182*t183
              t383 = t357-5.0d-1*rhoa*t178*t21*t74
              t384 = t367-5.0d-1*rhob*t184*t35*t81
              t385 = 1/taua**3
              t386 = 1/taub**3
              t387 = 1/rhoa**11
              t388 = 1/t4**4
              t389 = 1/rhoa**8.333333333333334d+0
              t390 = 1/rhoa**5.666666666666667d+0
              t391 = t87**3
              t392 = 1/t9**7
              t393 = 1/rhoa**3.3333333333333337d+0
              t394 = 1/rhoa**3.1666666666666665d+0
              t395 = t90**3
              t396 = 1.6995949182667827d-1*t192*t89*t90*t91-1.2746961887
     1           00087d-1*t199*t85*t89*t91+1.0d+0*t16*(-4.68497274324822
     2           4d+0*t394-3.9871442462415524d+0*t393-3.083875829189267d
     3           +0*t392-7.128507529742789d-1*t134)*t89*t91-6.0d+0*t16*t
     4           198*t199*t89*t90+9.649187699215522d+1*t16*t195*t197*t19
     5           9*t90+2.549392377400174d-1*t196*t198*t85*t89+6.0d+0*t16
     6           *t197*t395*t89+1.962413933653103d-17*t192*t82*t87*t88-1
     7           .4718104502398274d-17*t194*t82*t85*t88+1.11022302462515
     8           65d-16*t20*(-2.520426340996149d+0*t394-2.30799791823034
     9           28d+0*t393-1.5008036906238065d+0*t392-5.620753557770543
     :           d-1*t134)*t82*t88-6.661338147750939d-16*t190*t194*t20*t
     ;           82*t87+5.356375176299456d-15*t187*t189*t194*t20*t87+2.9
     <           43620900479655d-17*t188*t190*t82*t85-4.0999275947472624
     =           d+0*t195*t196*t197*t85-2.3669625486718335d-16*t187*t188
     >           *t189*t85+6.661338147750939d-16*t189*t20*t391*t82-1.929
     ?           8375398431045d+2*t16*t195*t395/t13**5+2.069040516770936
     @           4d+3*t16*t395/(t13**6*t14**3)+9.490883560204437d-19*t19
     1           *t393+4.1099018897499934d-3*t15*t393-1.0712750352598913
     2           d-14*t187*t20*t391/t17**5+5.742741051503565d-14*t20*t39
     3           1/(t17**6*t18**3)
              t397 = 4.824593849607761d+1*t208*t209*t210*t38*t47
              t398 = -6.0d+0*t208*t213*t38*t47*t99
              t399 = -2.6513779981040353d-1*t47*t95*t97*t98*t99
              t400 = 3.0d+0*t220*t38*t47*t98*t99
              t401 = -5.19476882440587d+1*t222*t223*t224*t56*t57
              t402 = 3.5089341735807883d+0*t103*t222*t227*t56*t57
              t403 = 8.072185179299687d-2*t101*t102*t103*t57*t95
              t404 = -1.7544670867903941d+0*t102*t103*t230*t56*t57
              t405 = 1.856176655010858d+2*t232*t233*t234*t40*t41*t45*t62
              t406 = -1.1541966305589217d+1*t107*t232*t237*t40*t41*t45*t
     1           62
              t407 = -4.904166819946466d-1*t105*t106*t107*t130*t40*t45
              t408 = 5.770983152794609d+0*t106*t107*t240*t40*t41*t45*t62
              t409 = -4.616786522235687d+1*t105*t106*t107*t119*t40*t45*t
     1           62
              t410 = -1.099109305675375d-2*t218*t47*t54
              t411 = 1.8175185709928465d-3*t218*t57*t60
              t412 = -7.11545236961578d-2*t275*t40*t45*t65
              t413 = -3.588478118171826d+0*t259*t40*t45*t62*t65
              t414 = -2.1530868709030954d+0*t262*t41*t45*t62*t65
              t415 = t97**3
              t416 = 5.172601291927341d+2*t38*t415*t47/(t52**6*t53**3)
              t417 = -9.649187699215522d+1*t210*t38*t415*t47/t52**5
              t418 = 4.824593849607761d+1*t209*t210*t220*t38*t47*t97
              t419 = -2.1319703304396778d+0*t208*t209*t210*t47*t95
              t420 = 6.0d+0*t209*t38*t415*t47*t99
              t421 = -6.0d+0*t213*t220*t38*t47*t97*t99
              t422 = 2.6513779981040353d-1*t208*t213*t47*t95*t99
              t423 = -1.3256889990520176d-1*t220*t47*t95*t98*t99
              t424 = 1.767585332069357d-1*t218*t47*t97*t98*t99
              t425 = 1/t36**3.6666666666666664d+0
              t426 = 1/t49**7
              t427 = 1/t36**3.3333333333333337d+0
              t428 = 1/t36**3.1666666666666665d+0
              t429 = 1.0d+0*t38*(-2.520426340996149d+0*t428-2.3079979182
     1           303428d+0*t427-1.5008036906238065d+0*t426-5.62075355777
     2           0543d-1*t425)*t47*t98*t99
              t430 = t101**3
              t431 = -1.0254062650399592d+3*t430*t56*t57/(t58**6*t59**3)
              t432 = 1.0389537648811739d+2*t224*t430*t56*t57/t58**5
              t433 = -5.19476882440587d+1*t101*t223*t224*t230*t56*t57
              t434 = 1.1950391155803675d+0*t222*t223*t224*t57*t95
              t435 = -3.5089341735807883d+0*t103*t223*t430*t56*t57
              t436 = 3.5089341735807883d+0*t101*t103*t227*t230*t56*t57
              t437 = -8.072185179299687d-2*t103*t222*t227*t57*t95
              t438 = 4.0360925896498434d-2*t102*t103*t230*t57*t95
              t439 = -5.381456786199791d-2*t101*t102*t103*t218*t57
              t440 = -5.848223622634647d-1*t102*t103*(-3.436688601932293
     1           d+0*t428-2.3308360066730832d+0*t427-8.064323383643707d-
     2           1*t426-5.663741022599518d-1*t425)*t56*t57
              t441 = t105**3
              t442 = 3.9801326549115085d+3*t40*t41*t441*t45*t62/(t63**6*
     1           t64**3)
              t443 = -3.712353310021716d+2*t234*t40*t41*t441*t45*t62/t63
     1           **5
              t444 = 1.856176655010858d+2*t105*t233*t234*t240*t40*t41*t4
     1           5*t62
              t445 = -7.424706620043432d+2*t119*t232*t233*t234*t40*t45*t
     1           62
              t446 = -7.886871025654724d+0*t130*t232*t233*t234*t40*t45
              t447 = 1.1541966305589217d+1*t107*t233*t40*t41*t441*t45*t6
     1           2
              t448 = -1.1541966305589217d+1*t105*t107*t237*t240*t40*t41*
     1           t45*t62
              t449 = 4.616786522235687d+1*t107*t119*t232*t237*t40*t45*t6
     1           2
              t450 = 4.904166819946466d-1*t107*t130*t232*t237*t40*t45
              t451 = -2.452083409973233d-1*t106*t107*t130*t240*t40*t45
              t452 = 2.2886111826416838d+0*t105*t106*t107*t275*t40*t45
              t453 = 1.923661050931536d+0*t106*t107*t40*t41*(-4.68497274
     1           3248224d+0*t428-3.9871442462415524d+0*t427-3.0838758291
     2           89267d+0*t426-7.128507529742789d-1*t425)*t45*t62
              t454 = -2.3083932611178434d+1*t106*t107*t119*t240*t40*t45*
     1           t62
              t455 = 1.1541966305589217d+2*t105*t106*t107*t259*t40*t45*t
     1           62
              t456 = 6.925179783353531d+1*t105*t106*t107*t262*t41*t45*t6
     1           2
              t457 = 8.548627933030694d-3*t427*t47*t54
              t458 = 1/t43**1.6666666666666669d+0
              t459 = 6*t39*t41
              t460 = -6*t246
              t461 = 1/t44**1.6666666666666669d+0
              t462 = -6*t39*t41
              t463 = 6*t246
              t464 = 1.3333333333333333d+0*t116*(t463+t462)-2.9629629629
     1           62963d-1*t115**3*t461+1.3333333333333333d+0*t113*(t460+
     2           t459)-2.962962962962963d-1*t112**3*t458+1.3333333333333
     3           333d+0*t115*t251*t254+1.3333333333333333d+0*t112*t245*t
     4           249
              t465 = -1.923661050931536d+0*t40*t41*t464
              t466 = 2.3083932611178434d+1*t119*t255*t40
              t467 = -2.3083932611178434d+1*t121*t255*t41
              t468 = -1.1541966305589216d+2*t117*t259*t40
              t469 = 1.8467146088942746d+2*t117*t119*t121
              t470 = -6.925179783353531d+1*t117*t262*t41
              t471 = 1/t36**7
              t472 = 2.3083932611178432d+2*t40*t45*t471
              t473 = -4.6167865222356863d+2*t121*t259*t45
              t474 = 2.770071913341412d+2*t119*t262*t45
              t475 = -4.616786522235687d+1*t39*t41*t45
              t476 = -1.4136255552166585d-3*t427*t57*t60
              t477 = 2.0103976536374746d-1*t40*t45*t65/t36**7.3333333333
     1           33333d+0
              t478 = 9.148438760934575d-2*t130*t262*t45*t65
              t479 = 7.176956236343652d+0*t40*t45*t471*t62*t65
              t480 = 8.612347483612381d+0*t119*t262*t45*t62*t65
              t481 = -1.4353912472687305d+0*t39*t41*t45*t62*t65
              t482 = 1/rhoa**3
              t483 = gammaaa**4
              t484 = 1/t68**4
              t485 = 1/rhoa**1.3666666666666666d+1
              t486 = -1.243628d-1*t300*t38*t54
              t487 = 3.9503262643361536d-2*t301*t56*t60
              t488 = -1.1961593727239421d-1*t293*t40*t41*t62*t65
              t489 = 2.0d+0*t300*t38*t97*t98*t99
              t490 = -1.1696447245269295d+0*t101*t102*t103*t301*t56
              t491 = 3.847322101863072d+0*t105*t106*t107*t293*t40*t41*t6
     1           2
              t492 = -2.3083932611178434d+1*t105*t106*t107*t262*t41*t45*
     1           t62
              t493 = 5.495546528376875d-3*t300*t54*t95
              t494 = 1.5389288407452287d+1*t119*t293*t40
              t495 = -1.5389288407452287d+1*t121*t293*t41
              t496 = 1.3333333333333333d+0*t116*(t462+2*t246)-2.96296296
     1           2962963d-1*t155*t250*t461+1.3333333333333333d+0*t113*(t
     2           459-2*t246)-2.962962962962963d-1*t154*t244*t458+1.77777
     3           77777777776d+0*t115*t246*t251*t39-1.7777777777777776d+0
     4           *t112*t245*t246*t39+4.444444444444444d-1*t155*t251*t254
     5           +4.444444444444444d-1*t154*t245*t249
              t497 = -1.923661050931536d+0*t40*t41*t496
              t498 = 7.694644203726144d+0*t119*t255*t40
              t499 = 7.694644203726144d+0*t121*t255*t41
              t500 = -3.8473221018630716d+1*t156*t259*t40
              t501 = 6.155715362980915d+1*t119*t121*t156
              t502 = -2.3083932611178434d+1*t156*t262*t41
              t503 = -7.694644203726143d+1*t117*t259*t40
              t504 = 4.616786522235687d+1*t117*t262*t41
              t505 = -1.5389288407452287d+2*t121*t259*t45
              t506 = -9.233573044471374d+1*t119*t262*t45
              t507 = 4.616786522235687d+1*t39*t41*t45
              t508 = -9.087592854964233d-4*t301*t60*t95
              t509 = 5.082465978296986d-3*t130*t293*t40*t65
              t510 = 4.7846374908957684d-1*t119*t293*t40*t62*t65
              t511 = -2.870782494537461d+0*t119*t262*t45*t62*t65
              t512 = 1.4353912472687305d+0*t39*t41*t45*t62*t65
              t513 = -2.962962962962963d-1*t115*t326*t461-2.962962962962
     1           963d-1*t112*t324*t458-8*t116*t39*t41+8*t113*t39*t41+1.7
     2           777777777777776d+0*t155*t246*t251*t39-1.777777777777777
     3           6d+0*t154*t245*t246*t39+4.444444444444444d-1*t115*t251*
     4           t327+4.444444444444444d-1*t112*t245*t325-2.666666666666
     5           6666d+0*t116*t246+2.6666666666666666d+0*t113*t246
              t514 = -1.923661050931536d+0*t40*t41*t513
              t515 = 1.5389288407452287d+1*t121*t293*t41
              t516 = 7.694644203726144d+0*t119*t328*t40
              t517 = -7.694644203726144d+0*t121*t328*t41
              t518 = -7.694644203726143d+1*t156*t259*t40
              t519 = 4.616786522235687d+1*t156*t262*t41
              t520 = -3.8473221018630716d+1*t117*t259*t40
              t521 = -6.155715362980915d+1*t117*t119*t121
              t522 = -2.3083932611178434d+1*t117*t262*t41
              t523 = 1.5389288407452287d+2*t121*t259*t45
              t524 = 1/rhob**11
              t525 = 1/rhob**8.333333333333334d+0
              t526 = 1/rhob**5.666666666666667d+0
              t527 = t148**3
              t528 = 1/t23**7
              t529 = 1/rhob**3.3333333333333337d+0
              t530 = 1/rhob**3.1666666666666665d+0
              t531 = t151**3
              t532 = 6.0d+0*t150*t30*t316*t531-1.9298375398431045d+2*t30
     1           *t314*t531/t27**5+2.0690405167709364d+3*t30*t531/(t27**
     2           6*t28**3)+1.1102230246251565d-16*t143*t149*t34*(-2.5204
     3           26340996149d+0*t530-2.3079979182303428d+0*t529-1.500803
     4           6906238065d+0*t528-5.620753557770543d-1*t165)+1.0d+0*t1
     5           50*t152*t30*(-4.684972743248224d+0*t530-3.9871442462415
     6           524d+0*t529-3.083875829189267d+0*t528-7.128507529742789
     7           d-1*t165)+9.490883560204437d-19*t33*t529+4.109901889749
     8           9934d-3*t29*t529+5.742741051503565d-14*t34*t527/(t31**6
     9           *t32**3)-1.0712750352598913d-14*t306*t34*t527/t31**5+6.
     :           661338147750939d-16*t143*t308*t34*t527-6.66133814775093
     ;           9d-16*t143*t148*t309*t313*t34+5.356375176299456d-15*t14
     <           8*t306*t308*t313*t34-6.0d+0*t150*t151*t30*t317*t318+9.6
     =           49187699215522d+1*t151*t30*t314*t316*t318-1.27469618870
     >           0087d-1*t146*t150*t152*t318+2.549392377400174d-1*t146*t
     ?           150*t315*t317-4.0999275947472624d+0*t146*t314*t315*t316
     @           -1.4718104502398274d-17*t143*t146*t149*t313+1.699594918
     1           2667827d-1*t150*t151*t152*t311+1.962413933653103d-17*t1
     2           43*t148*t149*t311+2.943620900479655d-17*t143*t146*t307*
     3           t309-2.3669625486718335d-16*t146*t306*t307*t308
              t533 = 1.3333333333333333d+0*t113*(t463+t459)+1.3333333333
     1           333333d+0*t116*(t462+t460)-2.962962962962963d-1*t155**3
     2           *t461-2.962962962962963d-1*t154**3*t458+1.3333333333333
     3           333d+0*t155*t251*t327+1.3333333333333333d+0*t154*t245*t
     4           325
              t534 = -1.923661050931536d+0*t40*t41*t533
              t535 = 2.3083932611178434d+1*t119*t328*t40
              t536 = 2.3083932611178434d+1*t121*t328*t41
              t537 = -1.1541966305589216d+2*t156*t259*t40
              t538 = -1.8467146088942746d+2*t119*t121*t156
              t539 = -6.925179783353531d+1*t156*t262*t41
              t540 = 4.6167865222356863d+2*t121*t259*t45
              t541 = 1/rhob**3
              t542 = gammabb**4
              t543 = 1/t75**4
              t544 = 1/rhob**1.3666666666666666d+1
              t545 = t175-1.25d-1*gammaaa*t178*t21
              t546 = 1.25d-1*t71*t92
              t547 = 1.25d-1*t142*t21
              t548 = 1/rhoa**1.2666666666666665d+1
              t549 = t181-1.25d-1*gammabb*t184*t35
              t550 = 1.25d-1*t153*t78
              t551 = 1.25d-1*t172*t35
              t552 = 1/rhob**1.2666666666666665d+1
              t553 = 2.5d-1*t178*t21
              t554 = 1/rhoa**1.1666666666666665d+1
              t555 = 2.5d-1*t184*t35
              t556 = 1/rhob**1.1666666666666665d+1
              t557 = 1/rhoa**1.0666666666666666d+1
              t558 = 1/rhob**1.0666666666666666d+1
              fnc(iq) = (5.0d-1*rhob*t35*t78*t79*t81+5.0d-1*rhoa*t21*t71
     1           *t72*t74+1.0d+0*t67*t7)*wght+fnc(iq)
              Amat(iq,D1_RA) = (t72*(5.0d-1*rhoa*t71*t74*t92+5.0d-1*t21*
     1           t71*t74+5.0d-1*rhoa*t142*t21*t74)+1.25d-1*gammaaa*t21*t
     2           71*t72*t73+1.0d+0*t133*t7+1.0d+0*t137*t67)*wght+Amat(iq
     3           ,D1_RA)
              Amat(iq,D1_RB) = (t79*(5.0d-1*t35*t78*t81+5.0d-1*rhob*t153
     1           *t78*t81+5.0d-1*rhob*t172*t35*t81)+1.25d-1*gammabb*t35*
     2           t78*t79*t80+1.0d+0*t164*t7+1.0d+0*t167*t67)*wght+Amat(i
     3           q,D1_RB)
              Cmat(iq,D1_GAA) = (t72*(5.0d-1*rhoa*t178*t21*t74+t175)+1.0
     1           d+0*t174*t67)*wght+Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = (t79*(5.0d-1*rhob*t184*t35*t81+t181)+1.0
     1           d+0*t180*t67)*wght+Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = (1.0d+0*rhoa*t21*t71*t72-5.0d-1*rhoa*t185
     1           *t21*t71*t74)*wght+Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = (1.0d+0*rhob*t35*t78*t79-5.0d-1*rhob*t186
     1           *t35*t78*t81)*wght+Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (t72*(1.0d+0*t71*t74*t92+1.0d+0*rhoa*
     1           t142*t74*t92+1.25d-1*gammaaa*t71*t73*t92+5.0d-1*rhoa*t2
     2           00*t71*t74+5.0d-1*rhoa*t21*t292*t74+1.0d+0*t142*t21*t74
     3           +1.25d-1*gammaaa*t142*t21*t73+1.25d-1*gammaaa*t21*t287*
     4           t71)+t72*t73*(1.25d-1*gammaaa*t71*t92+1.25d-1*gammaaa*t
     5           142*t21)-1.25d-1*gammaaa*t21*t287*t71*t72+1.0d+0*t281*t
     6           7+1.0d+0*t286*t67+2.0d+0*t133*t137)*wght+Amat2(iq,D2_RA
     7           _RA)
              Amat2(iq,D2_RA_RB) = (1.0d+0*t303*t7+1.0d+0*t305*t67+1.0d+
     1           0*t133*t167+1.0d+0*t137*t164)*wght+Amat2(iq,D2_RA_RB)
              Amat2(iq,D2_RB_RB) = (t79*(5.0d-1*rhob*t319*t78*t81+1.0d+0
     1           *t153*t78*t81+5.0d-1*rhob*t35*t354*t81+1.0d+0*t172*t35*
     2           t81+1.0d+0*rhob*t153*t172*t81+1.25d-1*gammabb*t153*t78*
     3           t80+1.25d-1*gammabb*t172*t35*t80+1.25d-1*gammabb*t349*t
     4           35*t78)+(1.25d-1*gammabb*t153*t78+1.25d-1*gammabb*t172*
     5           t35)*t79*t80-1.25d-1*gammabb*t349*t35*t78*t79+1.0d+0*t3
     6           44*t7+1.0d+0*t348*t67+2.0d+0*t164*t167)*wght+Amat2(iq,D
     7           2_RB_RB)
              Cmat2(iq,D2_RA_GAA) = (t72*(5.0d-1*rhoa*t178*t74*t92-1.25d
     1           -1*t71*t92+5.0d-1*rhoa*t21*t360*t74+5.0d-1*t178*t21*t74
     2           -1.25d-1*t21*t71*t73-1.25d-1*t142*t21)+(t357+1.25d-1*ga
     3           mmaaa*t178*t21)*t72*t73+1.0d+0*t356*t67+1.0d+0*t133*t17
     4           4)*wght+Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = (1.0d+0*t362*t67+1.0d+0*t133*t180)*w
     1           ght+Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_RB_GAA) = (1.0d+0*t364*t67+1.0d+0*t164*t174)*w
     1           ght+Cmat2(iq,D2_RB_GAA)
              Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
              Cmat2(iq,D2_RB_GBB) = (t79*(5.0d-1*rhob*t35*t370*t81+5.0d-
     1           1*t184*t35*t81+5.0d-1*rhob*t153*t184*t81-1.25d-1*t35*t7
     2           8*t80-1.25d-1*t153*t78-1.25d-1*t172*t35)+(t367+1.25d-1*
     3           gammabb*t184*t35)*t79*t80+1.0d+0*t366*t67+1.0d+0*t164*t
     4           180)*wght+Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GAA_GAA) = (t72*(5.0d-1*rhoa*t21*t375*t74-2.5d
     1           -1*t178*t21)+1.0d+0*t372*t67)*wght+Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = 1.0d+0*t377*t67*wght+Cmat2(iq,D2_GA
     1           A_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
              Cmat2(iq,D2_GBB_GBB) = (t79*(5.0d-1*rhob*t35*t382*t81-2.5d
     1           -1*t184*t35)+1.0d+0*t379*t67)*wght+Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RA_TA) = (t185*(-5.0d-1*rhoa*t71*t74*t92-5.0d-
     1           1*t21*t71*t74-5.0d-1*rhoa*t142*t21*t74)+t72*(1.0d+0*rho
     2           a*t71*t92+1.0d+0*t21*t71+1.0d+0*rhoa*t142*t21)-1.25d-1*
     3           gammaaa*t185*t21*t71*t73)*wght+Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = (t186*(-5.0d-1*t35*t78*t81-5.0d-1*rho
     1           b*t153*t78*t81-5.0d-1*rhob*t172*t35*t81)-1.25d-1*gammab
     2           b*t186*t35*t78*t80+(1.0d+0*t35*t78+1.0d+0*rhob*t153*t78
     3           +1.0d+0*rhob*t172*t35)*t79)*wght+Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GAA_TA) = (1.0d+0*rhoa*t178*t21*t72+t185*t383)
     1           *wght+Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = (1.0d+0*rhob*t184*t35*t79+t186*t384)
     1           *wght+Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = (1.0d+0*rhoa*t21*t385*t71*t74-2.0d+0*
     1           rhoa*t185*t21*t71)*wght+Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = (1.0d+0*rhob*t35*t386*t78*t81-2.0d+0*
     1           rhob*t186*t35*t78)*wght+Mmat2(iq,D2_TB_TB)
              Amat3(iq,D3_RA_RA_RA) = (1.0d+0*t7*(t36*(-2.65137799810403
     1           53d-1*t123*t95*t97*t98*t99+3.0d+0*t264*t38*t97*t98*t99+
     2           3.0d+0*t123*t220*t38*t98*t99-6.0d+0*t123*t208*t213*t38*
     3           t99-1.363138928244635d-3*t268*t60*t95+8.243319792565312
     4           d-3*t264*t54*t95+8.072185179299687d-2*t101*t102*t103*t1
     5           26*t95-5.980796863619711d-2*t40*t41*t464*t62*t65-1.4353
     6           912472687305d+1*t121*t259*t45*t62*t65-2.153086870903095
     7           4d+0*t117*t262*t41*t62*t65-7.176956236343652d-1*t121*t2
     8           55*t41*t62*t65-3.588478118171826d+0*t117*t259*t40*t62*t
     9           65+7.176956236343652d-1*t119*t255*t40*t62*t65+5.7415649
     :           89074922d+0*t117*t119*t121*t62*t65-2.8461809478463124d-
     ;           1*t121*t275*t45*t65-7.11545236961578d-2*t117*t275*t40*t
     <           65+7.623698967445479d-3*t130*t255*t40*t65+6.09895917395
     =           6384d-2*t117*t121*t130*t65+2.3083932611178434d+1*t106*t
     >           107*t121*t240*t41*t45*t62-4.616786522235687d+1*t107*t12
     ?           1*t232*t237*t41*t45*t62+7.424706620043432d+2*t121*t232*
     @           t233*t234*t41*t45*t62-1.8467146088942746d+2*t105*t106*t
     1           107*t119*t121*t45*t62+5.770983152794609d+0*t105*t106*t1
     2           07*t255*t40*t41*t62+5.770983152794609d+0*t106*t107*t117
     3           *t240*t40*t41*t62-1.1541966305589217d+1*t107*t117*t232*
     4           t237*t40*t41*t62+1.856176655010858d+2*t117*t232*t233*t2
     5           34*t40*t41*t62+4.616786522235687d+1*t105*t106*t107*t117
     6           *t121*t41*t62-4.616786522235687d+1*t105*t106*t107*t117*
     7           t119*t40*t62+1.9751631321680768d-2*(t475+t474+t473+t472
     8           +t470+t469+t468+t467+t466+t465+1.923661050931536d+0*t46
     9           4)*t56*t60+1.8175185709928465d-3*t126*t218*t60-1.754467
     :           0867903941d+0*t101*t102*t103*t268*t56-1.754467086790394
     ;           1d+0*t102*t103*t126*t230*t56+3.5089341735807883d+0*t103
     <           *t126*t222*t227*t56-5.19476882440587d+1*t126*t222*t223*
     =           t224*t56-6.21814d-2*t38*(t475+t474+t473+t472+t470+t469+
     >           t468+t467+t466+t465)*t54-1.099109305675375d-2*t123*t218
     ?           *t54+t481+t480+t479+t478+t477+t476+t457+t456+t455+t454+
     @           t453+t452+t451+t450-1.9616667279785865d+0*t105*t106*t10
     1           7*t121*t130*t45+t449+t448+t447+t446+t445+t444+t443+t442
     2           +t440+t439+t438+t437+t436+t435+t434+t433+t432+t431+t429
     3           +t424+t423+t422+t421+t420+t419+t418+t417+t416-4.9041668
     4           19946466d-1*t105*t106*t107*t117*t130*t40+4.824593849607
     5           761d+1*t123*t208*t209*t210*t38)+6.0d+0*t123*t38*t97*t98
     6           *t99-2.72627785648927d-3*t126*t60*t95+1.648663958513062
     7           5d-2*t123*t54*t95+2.549392377400174d-1*t85*t89*t90*t91-
     8           3.0d+0*t16*t199*t89*t91+6.0d+0*t16*t196*t198*t89+2.9436
     9           20900479655d-17*t82*t85*t87*t88-3.3306690738754696d-16*
     :           t194*t20*t82*t88+6.661338147750939d-16*t188*t190*t20*t8
     ;           2+5.741564989074922d+0*t119*t121*t45*t62*t65-1.79423905
     <           9085913d-1*t255*t40*t41*t62*t65-1.4353912472687305d+0*t
     =           117*t121*t41*t62*t65+1.4353912472687305d+0*t117*t119*t4
     >           0*t62*t65+6.098959173956384d-2*t121*t130*t45*t65+1.5247
     ?           39793489096d-2*t117*t130*t40*t65+4.616786522235687d+1*t
     @           105*t106*t107*t121*t41*t45*t62+1.1541966305589217d+1*t1
     1           05*t106*t107*t117*t40*t41*t62+5.92548939650423d-2*t268*
     2           t56*t60-3.5089341735807883d+0*t101*t102*t103*t126*t56-1
     3           .865442d-1*t264*t38*t54+t414+t413+t412+t411+t410+t409+t
     4           408+t407+t406+t405+t404+t403+t402+t401+t400+t399+t398+t
     5           397-rhoa*t396-5.356375176299456d-15*t187*t188*t189*t20-
     6           9.649187699215522d+1*t16*t195*t196*t197+1.2202564577405
     7           706d-18*t19*t192+5.284159572535705d-3*t15*t192)+t72*(1.
     8           5d+0*rhoa*t292*t74*t92+3.0d+0*t142*t74*t92+5.0d-1*gamma
     9           aa*t142*t73*t92+2.5d-1*gammaaa*t287*t71*t92+5.0d-1*rhoa
     :           *t396*t71*t74+1.5d+0*t200*t71*t74+5.0d-1*rhoa*t21*(-2.7
     ;           37777777777778d+0*gammaaa*t390*t69*t70+1.47455999999999
     <           92d-3*t483*t484*t485*t70+7.274666666666665d-1*t138*t139
     =           *t389*t70-5.836799999999998d-2*t288*t289*t387*t70+6.0d-
     >           2*gammaaa*t1*t69*(-6.08711843911111d+0*gammaaa*t390*t69
     ?           +3.2785061806079985d-3*t483*t484*t485+1.617434328106666
     @           d+0*t138*t139*t389-1.2977420298239994d-1*t288*t289*t387
     1           )-4.799999999999999d-1*gammaaa*t134*t291*t69+1.76d+0*ga
     2           mmaaa*t141*t284*t69+2.879999999999999d-2*t138*t139*t140
     3           *t291+9.215999999999996d-3*t141*t288*t289*t290-2.591999
     4           9999999993d-1*t138*t139*t141*t282)*t74+1.5d+0*t21*t292*
     5           t74+1.5d+0*rhoa*t142*t200*t74+2.5d-1*gammaaa*t200*t71*t
     6           73+2.5d-1*gammaaa*t21*t292*t73-2.5d-1*gammaaa*t21*t482*
     7           t71+2.5d-1*gammaaa*t142*t21*t287)+t287*t72*(-2.5d-1*gam
     8           maaa*t71*t92-2.5d-1*gammaaa*t142*t21)+t72*t73*(2.5d-1*g
     9           ammaaa*t142*t92+1.25d-1*gammaaa*t200*t71+1.25d-1*gammaa
     :           a*t21*t292)+2.5d-1*gammaaa*t21*t482*t71*t72+1.0d+0*(-1.
     ;           4145185185185183d-1*gammaaa*t390*t5*t6+4.38500740740740
     <           64d-4*gammaaa*t135*t3*t390*t6-4.6606364444444426d-6*t13
     =           8*t283*t3*t389*t6+1.5034311111111107d-3*t135*t138*t389*
     >           t6+1.0507616711111105d-8*t288*t3*t387*t388*t6-3.3895537
     ?           77777776d-6*t283*t288*t387*t6+3.1d-3*t3*t5*(1.578643362
     @           3644444d+0*gammaaa*t390*t5-4.8937944233297775d-3*gammaa
     1           a*t135*t3*t390+5.201404358510505d-5*t138*t283*t3*t389-1
     2           .6778723737130663d-2*t135*t138*t389-1.1726802553732772d
     3           -7*t288*t3*t387*t388+3.7828395334621856d-5*t283*t288*t3
     4           87)-2.4799999999999994d-2*gammaaa*t134*t285*t5+9.093333
     5           333333331d-2*gammaaa*t136*t284*t5+7.687999999999998d-5*
     6           gammaaa*t134*t135*t285*t3-2.818933333333332d-4*gammaaa*
     7           t135*t136*t284*t3+1.271082666666666d-6*t136*t138*t282*t
     8           283*t3-4.100266666666665d-4*t135*t136*t138*t282)*t67+3.
     9           0d+0*t133*t286+3.0d+0*t137*t281)*wght+Amat3(iq,D3_RA_RA
     :           _RA)
              Amat3(iq,D3_RA_RA_RB) = (1.0d+0*t7*(t36*(-8.83792666034678
     1           4d-2*t159*t95*t97*t98*t99-1.767585332069357d-1*t123*t95
     2           *t97*t98*t99+1.0d+0*t264*t38*t97*t98*t99+1.0d+0*t159*t2
     3           20*t38*t98*t99+2.0d+0*t123*t220*t38*t98*t99-2.0d+0*t159
     4           *t208*t213*t38*t99-4.0d+0*t123*t208*t213*t38*t99-4.5437
     5           964274821163d-4*t268*t60*t95+2.747773264188437d-3*t264*
     6           t54*t95+2.690728393099896d-2*t101*t102*t103*t161*t95+5.
     7           381456786199792d-2*t101*t102*t103*t126*t95-5.9807968636
     8           19711d-2*t40*t41*t496*t62*t65-4.7846374908957684d+0*t12
     9           1*t259*t45*t62*t65-4.7846374908957684d-1*t121*t293*t41*
     :           t62*t65-7.176956236343652d-1*t156*t262*t41*t62*t65+1.43
     ;           53912472687305d+0*t117*t262*t41*t62*t65+2.3923187454478
     <           842d-1*t121*t255*t41*t62*t65-1.1961593727239421d+0*t156
     =           *t259*t40*t62*t65-2.3923187454478842d+0*t117*t259*t40*t
     >           62*t65+2.3923187454478842d-1*t119*t255*t40*t62*t65+1.91
     ?           38549963583074d+0*t119*t121*t156*t62*t65-9.487269826154
     @           375d-2*t121*t275*t45*t65-3.049479586978192d-2*t130*t262
     1           *t45*t65-2.3718174565385935d-2*t156*t275*t40*t65-4.7436
     2           34913077187d-2*t117*t275*t40*t65+2.541232989148493d-3*t
     3           130*t255*t40*t65+2.0329863913187946d-2*t121*t130*t156*t
     4           65+7.694644203726144d+0*t106*t107*t121*t240*t41*t45*t62
     5           -1.538928840745229d+1*t107*t121*t232*t237*t41*t45*t62+2
     6           .4749022066811444d+2*t121*t232*t233*t234*t41*t45*t62-6.
     7           155715362980916d+1*t105*t106*t107*t119*t121*t45*t62+1.9
     8           23661050931536d+0*t105*t106*t107*t255*t40*t41*t62+1.923
     9           661050931536d+0*t106*t107*t156*t240*t40*t41*t62+3.84732
     :           2101863072d+0*t106*t107*t117*t240*t40*t41*t62-3.8473221
     ;           01863072d+0*t107*t156*t232*t237*t40*t41*t62-7.694644203
     <           726144d+0*t107*t117*t232*t237*t40*t41*t62+6.18725551670
     =           2861d+1*t156*t232*t233*t234*t40*t41*t62+1.2374511033405
     >           722d+2*t117*t232*t233*t234*t40*t41*t62+1.53892884074522
     ?           9d+1*t105*t106*t107*t121*t156*t41*t62-1.538928840745229
     @           d+1*t105*t106*t107*t119*t156*t40*t62-3.077857681490458d
     1           +1*t105*t106*t107*t117*t119*t40*t62+1.9751631321680768d
     2           -2*(t507+t506+t505+t504+t503+t502+t501+t500+t499+t498+t
     3           497+1.923661050931536d+0*t496+t495+t494+t472)*t56*t60+6
     4           .058395236642822d-4*t161*t218*t60+1.2116790473285642d-3
     5           *t126*t218*t60-5.848223622634647d-1*t101*t102*t103*t268
     6           *t56-5.848223622634647d-1*t102*t103*t161*t230*t56-1.169
     7           6447245269295d+0*t102*t103*t126*t230*t56+1.169644724526
     8           9295d+0*t103*t161*t222*t227*t56+2.339289449053859d+0*t1
     9           03*t126*t222*t227*t56-1.73158960813529d+1*t161*t222*t22
     :           3*t224*t56-3.46317921627058d+1*t126*t222*t223*t224*t56-
     ;           6.21814d-2*t38*(t507+t506+t505+t504+t503+t502+t501+t500
     <           +t499+t498+t497+t495+t494+t472)*t54-3.663697685584583d-
     =           3*t159*t218*t54-7.327395371169166d-3*t123*t218*t54+t512
     >           +t511+t510+t509+t508+t493+t492+t491+t490+t489+t479+t477
     ?           +t476+t457+t455+t454+t453+t452+t451+t450-6.538889093261
     @           956d-1*t105*t106*t107*t121*t130*t45+t449+t448+t447+t446
     1           +t445+t444+t443+t442+t440+t439+t438+t437+t436+t435+t434
     2           +t433+t432+t431+t429+t424+t423+t422+t421+t420+t419+t418
     3           +t417+t416-1.6347222733154887d-1*t105*t106*t107*t130*t1
     4           56*t40-3.2694445466309774d-1*t105*t106*t107*t117*t130*t
     5           40+1.6081979498692536d+1*t159*t208*t209*t210*t38+3.2163
     6           95899738507d+1*t123*t208*t209*t210*t38)+4.0d+0*t123*t38
     7           *t97*t98*t99-1.8175185709928465d-3*t126*t60*t95+1.09910
     8           9305675375d-2*t123*t54*t95-4.7846374908957684d-1*t121*t
     9           156*t41*t62*t65+9.569274981791537d-1*t117*t119*t40*t62*
     :           t65+1.0164931956593973d-2*t117*t130*t40*t65+7.694644203
     ;           726144d+0*t105*t106*t107*t117*t40*t41*t62-2.33928944905
     <           3859d+0*t101*t102*t103*t126*t56+t488+t487+t486+t413+t41
     =           2+t411+t410+t409+t408+t407+t406+t405+t404+t403+t402+t40
     >           1+t400+t399+t398+t397+t341+t340+t338+t335+t322+t321+t32
     ?           0+t302+t279+t277+t272+t269+t265+t243)+1.0d+0*(1.0507616
     @           711111105d-8*gammabb*t138*t165*t282*t3*t388*t6-1.553545
     1           4814814809d-6*gammaaa*gammabb*t165*t283*t284*t3*t6+5.01
     2           1437037037035d-4*gammaaa*gammabb*t135*t165*t284*t6-3.38
     3           9553777777776d-6*gammabb*t138*t165*t282*t283*t6+3.1d-3*
     4           t3*(-1.1726802553732772d-7*gammabb*t138*t165*t282*t3*t3
     5           88+1.733801452836835d-5*gammaaa*gammabb*t165*t283*t284*
     6           t3-5.592907912376887d-3*gammaaa*gammabb*t135*t165*t284+
     7           3.7828395334621856d-5*gammabb*t138*t165*t282*t283)*t5-1
     8           .653333333333333d-2*gammaaa*t134*t304*t5-8.266666666666
     9           665d-3*gammabb*t165*t285*t5+3.0311111111111105d-2*gamma
     :           aa*t166*t284*t5+5.125333333333332d-5*gammaaa*t134*t135*
     ;           t3*t304+2.562666666666666d-5*gammabb*t135*t165*t285*t3-
     <           9.396444444444442d-5*gammaaa*t135*t166*t284*t3+4.236942
     =           2222222203d-7*t138*t166*t282*t283*t3+8.473884444444441d
     >           -7*gammaaa*gammabb*t134*t136*t165*t283*t3-1.36675555555
     ?           5555d-4*t135*t138*t166*t282-2.73351111111111d-4*gammaaa
     @           *gammabb*t134*t135*t136*t165)*t67+2.0d+0*t133*t305+2.0d
     1           +0*t137*t303+1.0d+0*t164*t286+1.0d+0*t167*t281)*wght+Am
     2           at3(iq,D3_RA_RA_RB)
              Amat3(iq,D3_RA_RB_RB) = (1.0d+0*t7*(t36*(-1.76758533206935
     1           7d-1*t159*t95*t97*t98*t99-8.837926660346784d-2*t123*t95
     2           *t97*t98*t99+1.0d+0*t333*t38*t97*t98*t99+2.0d+0*t159*t2
     3           20*t38*t98*t99+1.0d+0*t123*t220*t38*t98*t99-4.0d+0*t159
     4           *t208*t213*t38*t99-2.0d+0*t123*t208*t213*t38*t99-4.5437
     5           964274821163d-4*t336*t60*t95+2.747773264188437d-3*t333*
     6           t54*t95+5.381456786199792d-2*t101*t102*t103*t161*t95+2.
     7           690728393099896d-2*t101*t102*t103*t126*t95-5.9807968636
     8           19711d-2*t40*t41*t513*t62*t65+4.7846374908957684d+0*t12
     9           1*t259*t45*t62*t65-2.3923187454478842d-1*t121*t328*t41*
     :           t62*t65+4.7846374908957684d-1*t121*t293*t41*t62*t65+1.4
     ;           353912472687305d+0*t156*t262*t41*t62*t65-7.176956236343
     <           652d-1*t117*t262*t41*t62*t65+2.3923187454478842d-1*t119
     =           *t328*t40*t62*t65-2.3923187454478842d+0*t156*t259*t40*t
     >           62*t65-1.1961593727239421d+0*t117*t259*t40*t62*t65-1.91
     ?           38549963583074d+0*t117*t119*t121*t62*t65+9.487269826154
     @           374d-2*t121*t275*t45*t65-3.0494795869781915d-2*t130*t26
     1           2*t45*t65+2.541232989148493d-3*t130*t328*t40*t65-4.7436
     2           34913077187d-2*t156*t275*t40*t65-2.3718174565385935d-2*
     3           t117*t275*t40*t65-2.0329863913187946d-2*t117*t121*t130*
     4           t65-7.694644203726144d+0*t106*t107*t121*t240*t41*t45*t6
     5           2+1.538928840745229d+1*t107*t121*t232*t237*t41*t45*t62-
     6           2.4749022066811444d+2*t121*t232*t233*t234*t41*t45*t62+6
     7           .155715362980916d+1*t105*t106*t107*t119*t121*t45*t62+1.
     8           923661050931536d+0*t105*t106*t107*t328*t40*t41*t62+3.84
     9           7322101863072d+0*t106*t107*t156*t240*t40*t41*t62+1.9236
     :           61050931536d+0*t106*t107*t117*t240*t40*t41*t62-7.694644
     ;           203726144d+0*t107*t156*t232*t237*t40*t41*t62-3.84732210
     <           1863072d+0*t107*t117*t232*t237*t40*t41*t62+1.2374511033
     =           405722d+2*t156*t232*t233*t234*t40*t41*t62+6.18725551670
     >           2861d+1*t117*t232*t233*t234*t40*t41*t62-1.5389288407452
     ?           29d+1*t105*t106*t107*t117*t121*t41*t62-3.07785768149045
     @           8d+1*t105*t106*t107*t119*t156*t40*t62-1.538928840745229
     1           d+1*t105*t106*t107*t117*t119*t40*t62+1.9751631321680768
     2           d-2*(t523+t522+t521+t520+t519+t518+t517+t516+t515+t514+
     3           1.923661050931536d+0*t513+t506+t494+t475+t472)*t56*t60+
     4           1.2116790473285642d-3*t161*t218*t60+6.058395236642822d-
     5           4*t126*t218*t60-5.848223622634647d-1*t101*t102*t103*t33
     6           6*t56-1.1696447245269295d+0*t102*t103*t161*t230*t56-5.8
     7           48223622634647d-1*t102*t103*t126*t230*t56+2.33928944905
     8           3859d+0*t103*t161*t222*t227*t56+1.1696447245269295d+0*t
     9           103*t126*t222*t227*t56-3.46317921627058d+1*t161*t222*t2
     :           23*t224*t56-1.73158960813529d+1*t126*t222*t223*t224*t56
     ;           -6.21814d-2*t38*(t523+t522+t521+t520+t519+t518+t517+t51
     <           6+t515+t514+t506+t494+t475+t472)*t54-7.327395371169166d
     =           -3*t159*t218*t54-3.663697685584583d-3*t123*t218*t54+t51
     >           1+t510+t509+t508+t493+t492+t491+t490+t489+t481+t479+t47
     ?           7+t476+t457+t455+t454+t453+t452+t451+t450+6.53888909326
     @           1955d-1*t105*t106*t107*t121*t130*t45+t449+t448+t447+t44
     1           6+t445+t444+t443+t442+t440+t439+t438+t437+t436+t435+t43
     2           4+t433+t432+t431+t429+t424+t423+t422+t421+t420+t419+t41
     3           8+t417+t416-3.2694445466309774d-1*t105*t106*t107*t130*t
     4           156*t40-1.6347222733154887d-1*t105*t106*t107*t117*t130*
     5           t40+3.216395899738507d+1*t159*t208*t209*t210*t38+1.6081
     6           979498692536d+1*t123*t208*t209*t210*t38)+4.0d+0*t159*t3
     7           8*t97*t98*t99-1.8175185709928465d-3*t161*t60*t95+1.0991
     8           09305675375d-2*t159*t54*t95+4.7846374908957684d-1*t117*
     9           t121*t41*t62*t65+9.569274981791537d-1*t119*t156*t40*t62
     :           *t65+1.0164931956593973d-2*t130*t156*t40*t65+7.69464420
     ;           3726144d+0*t105*t106*t107*t156*t40*t41*t62-2.3392894490
     <           53859d+0*t101*t102*t103*t161*t56+t488+t487+t486+t413+t4
     =           12+t411+t410+t409+t408+t407+t406+t405+t404+t403+t402+t4
     >           01+t400+t399+t398+t397+t343+t342+t339+t337+t334+t323+t3
     ?           02+t274+t273+t270+t266+t236+t226+t212)+1.0d+0*(1.050761
     @           6711111105d-8*gammaaa*t134*t168*t3*t345*t388*t6-1.55354
     1           54814814809d-6*gammaaa*gammabb*t134*t283*t3*t346*t6+5.0
     2           11437037037035d-4*gammaaa*gammabb*t134*t135*t346*t6-3.3
     3           89553777777776d-6*gammaaa*t134*t168*t283*t345*t6+3.1d-3
     4           *t3*(-1.1726802553732772d-7*gammaaa*t134*t168*t3*t345*t
     5           388+1.7338014528368348d-5*gammaaa*gammabb*t134*t283*t3*
     6           t346-5.592907912376888d-3*gammaaa*gammabb*t134*t135*t34
     7           6+3.7828395334621856d-5*gammaaa*t134*t168*t283*t345)*t5
     8           -8.266666666666665d-3*gammaaa*t134*t347*t5+3.0311111111
     9           111105d-2*gammabb*t136*t346*t5-1.653333333333333d-2*gam
     :           mabb*t165*t304*t5+2.562666666666666d-5*gammaaa*t134*t13
     ;           5*t3*t347-9.396444444444442d-5*gammabb*t135*t136*t3*t34
     <           6+4.2369422222222203d-7*t136*t168*t283*t3*t345-1.366755
     =           555555555d-4*t135*t136*t168*t345+5.125333333333332d-5*g
     >           ammabb*t135*t165*t3*t304+8.473884444444441d-7*gammaaa*g
     ?           ammabb*t134*t165*t166*t283*t3-2.73351111111111d-4*gamma
     @           aa*gammabb*t134*t135*t165*t166)*t67+1.0d+0*t133*t348+1.
     1           0d+0*t137*t344+2.0d+0*t164*t305+2.0d+0*t167*t303)*wght+
     2           Amat3(iq,D3_RA_RB_RB)
              Amat3(iq,D3_RB_RB_RB) = (1.0d+0*t7*(t36*(-2.65137799810403
     1           53d-1*t159*t95*t97*t98*t99+3.0d+0*t333*t38*t97*t98*t99+
     2           3.0d+0*t159*t220*t38*t98*t99-6.0d+0*t159*t208*t213*t38*
     3           t99-1.363138928244635d-3*t336*t60*t95+8.243319792565312
     4           d-3*t333*t54*t95+8.072185179299687d-2*t101*t102*t103*t1
     5           61*t95-5.980796863619711d-2*t40*t41*t533*t62*t65+1.4353
     6           912472687305d+1*t121*t259*t45*t62*t65+7.176956236343652
     7           d-1*t121*t328*t41*t62*t65-2.1530868709030954d+0*t156*t2
     8           62*t41*t62*t65+7.176956236343652d-1*t119*t328*t40*t62*t
     9           65-3.588478118171826d+0*t156*t259*t40*t62*t65-5.7415649
     :           89074922d+0*t119*t121*t156*t62*t65+2.8461809478463124d-
     ;           1*t121*t275*t45*t65+7.623698967445479d-3*t130*t328*t40*
     <           t65-7.11545236961578d-2*t156*t275*t40*t65-6.09895917395
     =           6384d-2*t121*t130*t156*t65-2.3083932611178434d+1*t106*t
     >           107*t121*t240*t41*t45*t62+4.616786522235687d+1*t107*t12
     ?           1*t232*t237*t41*t45*t62-7.424706620043432d+2*t121*t232*
     @           t233*t234*t41*t45*t62+1.8467146088942746d+2*t105*t106*t
     1           107*t119*t121*t45*t62+5.770983152794609d+0*t105*t106*t1
     2           07*t328*t40*t41*t62+5.770983152794609d+0*t106*t107*t156
     3           *t240*t40*t41*t62-1.1541966305589217d+1*t107*t156*t232*
     4           t237*t40*t41*t62+1.856176655010858d+2*t156*t232*t233*t2
     5           34*t40*t41*t62-4.616786522235687d+1*t105*t106*t107*t121
     6           *t156*t41*t62-4.616786522235687d+1*t105*t106*t107*t119*
     7           t156*t40*t62+1.9751631321680768d-2*(t540+t539+t538+t537
     8           +t536+t535+t534+1.923661050931536d+0*t533+t507+t474+t47
     9           2)*t56*t60+1.8175185709928465d-3*t161*t218*t60-1.754467
     :           0867903941d+0*t101*t102*t103*t336*t56-1.754467086790394
     ;           1d+0*t102*t103*t161*t230*t56+3.5089341735807883d+0*t103
     <           *t161*t222*t227*t56-5.19476882440587d+1*t161*t222*t223*
     =           t224*t56-6.21814d-2*t38*t54*(t540+t539+t538+t537+t536+t
     >           535+t534+t507+t474+t472)-1.099109305675375d-2*t159*t218
     ?           *t54+t512+t480+t479+t478+t477+t476+t457+t456+t455+t454+
     @           t453+t452+t451+t450+1.9616667279785865d+0*t105*t106*t10
     1           7*t121*t130*t45+t449+t448+t447+t446+t445+t444+t443+t442
     2           +t440+t439+t438+t437+t436+t435+t434+t433+t432+t431+t429
     3           +t424+t423+t422+t421+t420+t419+t418+t417+t416-4.9041668
     4           19946466d-1*t105*t106*t107*t130*t156*t40+4.824593849607
     5           761d+1*t159*t208*t209*t210*t38)+6.0d+0*t159*t38*t97*t98
     6           *t99-2.72627785648927d-3*t161*t60*t95+1.648663958513062
     7           5d-2*t159*t54*t95-5.741564989074922d+0*t119*t121*t45*t6
     8           2*t65-1.794239059085913d-1*t328*t40*t41*t62*t65+1.43539
     9           12472687305d+0*t121*t156*t41*t62*t65+1.4353912472687305
     :           d+0*t119*t156*t40*t62*t65-6.098959173956384d-2*t121*t13
     ;           0*t45*t65+1.524739793489096d-2*t130*t156*t40*t65-4.6167
     <           86522235687d+1*t105*t106*t107*t121*t41*t45*t62+1.154196
     =           6305589217d+1*t105*t106*t107*t156*t40*t41*t62+5.9254893
     >           9650423d-2*t336*t56*t60-3.5089341735807883d+0*t101*t102
     ?           *t103*t161*t56-1.865442d-1*t333*t38*t54-rhob*t532+t414+
     @           t413+t412+t411+t410+t409+t408+t407+t406+t405+t404+t403+
     1           t402+t401+t400+t399+t398+t397-3.3306690738754696d-16*t1
     2           43*t149*t313*t34+6.661338147750939d-16*t143*t307*t309*t
     3           34-5.356375176299456d-15*t306*t307*t308*t34+1.220256457
     4           7405706d-18*t311*t33-3.0d+0*t150*t152*t30*t318+6.0d+0*t
     5           150*t30*t315*t317-9.649187699215522d+1*t30*t314*t315*t3
     6           16+5.284159572535705d-3*t29*t311+2.549392377400174d-1*t
     7           146*t150*t151*t152+2.943620900479655d-17*t143*t146*t148
     8           *t149)+t79*(5.0d-1*rhob*t532*t78*t81+1.5d+0*t319*t78*t8
     9           1+5.0d-1*rhob*t35*(-2.737777777777778d+0*gammabb*t526*t
     :           76*t77+1.4745599999999992d-3*t542*t543*t544*t77+7.27466
     ;           6666666665d-1*t168*t169*t525*t77-5.836799999999998d-2*t
     <           350*t351*t524*t77+6.0d-2*gammabb*t2*t76*(-6.08711843911
     =           111d+0*gammabb*t526*t76+3.2785061806079985d-3*t542*t543
     >           *t544+1.617434328106666d+0*t168*t169*t525-1.29774202982
     ?           39994d-1*t350*t351*t524)-4.799999999999999d-1*gammabb*t
     @           165*t353*t76+1.76d+0*gammabb*t171*t346*t76+2.8799999999
     1           99999d-2*t168*t169*t170*t353+9.215999999999996d-3*t171*
     2           t350*t351*t352-2.5919999999999993d-1*t168*t169*t171*t34
     3           5)*t81+1.5d+0*t35*t354*t81+1.5d+0*rhob*t153*t354*t81+1.
     4           5d+0*rhob*t172*t319*t81+3.0d+0*t153*t172*t81+2.5d-1*gam
     5           mabb*t319*t78*t80+2.5d-1*gammabb*t35*t354*t80+5.0d-1*ga
     6           mmabb*t153*t172*t80-2.5d-1*gammabb*t35*t541*t78+2.5d-1*
     7           gammabb*t153*t349*t78+2.5d-1*gammabb*t172*t349*t35)+(1.
     8           25d-1*gammabb*t319*t78+1.25d-1*gammabb*t35*t354+2.5d-1*
     9           gammabb*t153*t172)*t79*t80+t349*(-2.5d-1*gammabb*t153*t
     :           78-2.5d-1*gammabb*t172*t35)*t79+2.5d-1*gammabb*t35*t541
     ;           *t78*t79+1.0d+0*(-1.4145185185185183d-1*gammabb*t5*t526
     <           *t6+4.3850074074074064d-4*gammabb*t135*t3*t526*t6-4.660
     =           6364444444426d-6*t168*t283*t3*t525*t6+1.503431111111110
     >           7d-3*t135*t168*t525*t6+1.0507616711111105d-8*t3*t350*t3
     ?           88*t524*t6-3.389553777777776d-6*t283*t350*t524*t6+3.1d-
     @           3*t3*t5*(1.5786433623644444d+0*gammabb*t5*t526-4.893794
     1           4233297775d-3*gammabb*t135*t3*t526+5.201404358510505d-5
     2           *t168*t283*t3*t525-1.6778723737130663d-2*t135*t168*t525
     3           -1.1726802553732772d-7*t3*t350*t388*t524+3.782839533462
     4           1856d-5*t283*t350*t524)-2.4799999999999994d-2*gammabb*t
     5           165*t347*t5+9.093333333333331d-2*gammabb*t166*t346*t5+7
     6           .687999999999998d-5*gammabb*t135*t165*t3*t347-2.8189333
     7           33333332d-4*gammabb*t135*t166*t3*t346+1.271082666666666
     8           d-6*t166*t168*t283*t3*t345-4.100266666666665d-4*t135*t1
     9           66*t168*t345)*t67+3.0d+0*t164*t348+3.0d+0*t167*t344)*wg
     :           ht+Amat3(iq,D3_RB_RB_RB)
              Cmat3(iq,D3_RA_RA_GAA) = (t72*(1.0d+0*rhoa*t360*t74*t92+1.
     1           0d+0*t178*t74*t92-1.25d-1*t71*t73*t92+1.25d-1*gammaaa*t
     2           178*t73*t92-2.5d-1*t142*t92+5.0d-1*rhoa*t21*(5.86666666
     3           6666666d-1*t284*t69*t70-5.529599999999998d-4*t288*t484*
     4           t548*t70+1.9583999999999993d-2*t138*t289*t290*t70-2.079
     5           9999999999996d-1*gammaaa*t139*t282*t70+6.0d-2*gammaaa*t
     6           1*t69*(1.3043825226666664d+0*t284*t69-1.229439817727999
     7           4d-3*t288*t484*t548+4.3542660211199985d-2*t138*t289*t29
     8           0-4.624628943999999d-1*gammaaa*t139*t282)-3.19999999999
     9           99995d-1*gammaaa*t134*t359*t69+6.0d-2*t1*t291*t69+5.866
     :           666666666666d-1*gammaaa*t177*t284*t69-3.199999999999999
     ;           5d-1*t134*t141*t69+1.9199999999999995d-2*t138*t139*t140
     <           *t359-2.303999999999999d-3*t138*t141*t289*t358-3.6d-3*g
     =           ammaaa*t139*t176*t291+3.0719999999999986d-3*t177*t288*t
     >           289*t290-8.639999999999998d-2*t138*t139*t177*t282+5.759
     ?           999999999998d-2*gammaaa*t139*t140*t141)*t74+1.0d+0*t21*
     @           t360*t74+5.0d-1*rhoa*t178*t200*t74+1.25d-1*gammaaa*t21*
     1           t360*t73-1.25d-1*t142*t21*t73+1.25d-1*t21*t287*t71-1.25
     2           d-1*t200*t71-1.25d-1*t21*t292+1.25d-1*gammaaa*t178*t21*
     3           t287)+t72*t73*(1.25d-1*gammaaa*t178*t92+t547+t546+1.25d
     4           -1*gammaaa*t21*t360)+t287*t545*t72+1.0d+0*(3.0311111111
     5           111105d-2*t284*t5*t6-3.9403562666666647d-9*t138*t290*t3
     6           *t388*t6-9.396444444444442d-5*t135*t284*t3*t6+1.4299679
     7           999999995d-6*gammaaa*t282*t283*t3*t6+1.271082666666666d
     8           -6*t138*t283*t290*t6-4.612799999999999d-4*gammaaa*t135*
     9           t282*t6+3.1d-3*t3*t5*(-3.3828072050666663d-1*t284*t5+4.
     :           3975509576497906d-8*t138*t290*t3*t388+1.048670233570666
     ;           6d-3*t135*t284*t3-1.5958854281793597d-5*gammaaa*t282*t2
     <           83*t3-1.4185648250483196d-5*t138*t283*t290+5.1480175102
     =           55999d-3*gammaaa*t135*t282)-1.653333333333333d-2*gammaa
     >           a*t134*t355*t5+3.1d-3*t1*t285*t5+3.0311111111111105d-2*
     ?           gammaaa*t173*t284*t5-1.653333333333333d-2*t134*t136*t5+
     @           5.125333333333332d-5*gammaaa*t134*t135*t3*t355-9.61d-6*
     1           t1*t135*t285*t3-9.396444444444442d-5*gammaaa*t135*t173*
     2           t284*t3+4.2369422222222203d-7*t138*t173*t282*t283*t3-3.
     3           1777066666666653d-7*gammaaa*t136*t140*t283*t3+5.1253333
     4           33333332d-5*t134*t135*t136*t3-1.366755555555555d-4*t135
     5           *t138*t173*t282+1.0250666666666663d-4*gammaaa*t135*t136
     6           *t140)*t67+2.0d+0*t133*t356+1.0d+0*t174*t281)*wght+Cmat
     7           3(iq,D3_RA_RA_GAA)
              Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
              Cmat3(iq,D3_RA_RA_GBB) = (1.0d+0*(-3.9403562666666647d-9*t
     1           138*t2*t282*t3*t388*t6+5.825795555555554d-7*gammaaa*t2*
     2           t283*t284*t3*t6-1.8792888888888884d-4*gammaaa*t135*t2*t
     3           284*t6+1.271082666666666d-6*t138*t2*t282*t283*t6+3.1d-3
     4           *t3*(4.3975509576497906d-8*t138*t2*t282*t3*t388-6.50175
     5           5448138132d-6*gammaaa*t2*t283*t284*t3+2.097340467141333
     6           2d-3*gammaaa*t135*t2*t284-1.4185648250483196d-5*t138*t2
     7           *t282*t283)*t5-1.653333333333333d-2*gammaaa*t134*t361*t
     8           5+3.1d-3*t2*t285*t5+3.0311111111111105d-2*gammaaa*t179*
     9           t284*t5+5.125333333333332d-5*gammaaa*t134*t135*t3*t361-
     :           9.61d-6*t135*t2*t285*t3-9.396444444444442d-5*gammaaa*t1
     ;           35*t179*t284*t3+4.2369422222222203d-7*t138*t179*t282*t2
     <           83*t3-3.1777066666666653d-7*gammaaa*t134*t136*t2*t283*t
     =           3-1.366755555555555d-4*t135*t138*t179*t282+1.0250666666
     >           666663d-4*gammaaa*t134*t135*t136*t2)*t67+2.0d+0*t133*t3
     ?           62+1.0d+0*t180*t281)*wght+Cmat3(iq,D3_RA_RA_GBB)
              Cmat3(iq,D3_RA_RB_GAA) = (1.0d+0*(-3.9403562666666647d-9*g
     1           ammaaa*gammabb*t140*t165*t3*t388*t6+4.2369422222222203d
     2           -7*gammabb*t134*t165*t283*t3*t6+1.271082666666666d-6*ga
     3           mmaaa*gammabb*t140*t165*t283*t6-1.366755555555555d-4*ga
     4           mmabb*t134*t135*t165*t6+3.1d-3*t3*(4.3975509576497906d-
     5           8*gammaaa*gammabb*t140*t165*t3*t388-4.728549416827732d-
     6           6*gammabb*t134*t165*t283*t3-1.4185648250483196d-5*gamma
     7           aa*gammabb*t140*t165*t283+1.525338521557333d-3*gammabb*
     8           t134*t135*t165)*t5-8.266666666666665d-3*gammaaa*t134*t3
     9           63*t5-8.266666666666665d-3*gammabb*t165*t355*t5+3.1d-3*
     :           t1*t304*t5-8.266666666666665d-3*t134*t166*t5+2.56266666
     ;           6666666d-5*gammaaa*t134*t135*t3*t363+2.562666666666666d
     <           -5*gammabb*t135*t165*t3*t355-9.61d-6*t1*t135*t3*t304+4.
     =           2369422222222203d-7*gammaaa*gammabb*t134*t165*t173*t283
     >           *t3-1.5888533333333327d-7*gammaaa*t140*t166*t283*t3-1.5
     ?           888533333333327d-7*gammabb*t1*t136*t165*t283*t3+2.56266
     @           6666666666d-5*t134*t135*t166*t3-1.366755555555555d-4*ga
     1           mmaaa*gammabb*t134*t135*t165*t173+5.125333333333332d-5*
     2           gammaaa*t135*t140*t166+5.125333333333332d-5*gammabb*t1*
     3           t135*t136*t165)*t67+1.0d+0*t133*t364+1.0d+0*t164*t356+1
     4           .0d+0*t174*t303)*wght+Cmat3(iq,D3_RA_RB_GAA)
              Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
              Cmat3(iq,D3_RA_RB_GBB) = (1.0d+0*(-3.9403562666666647d-9*g
     1           ammaaa*gammabb*t134*t170*t3*t388*t6+4.2369422222222203d
     2           -7*gammaaa*t134*t165*t283*t3*t6+1.271082666666666d-6*ga
     3           mmaaa*gammabb*t134*t170*t283*t6-1.366755555555555d-4*ga
     4           mmaaa*t134*t135*t165*t6+3.1d-3*t3*(4.3975509576497906d-
     5           8*gammaaa*gammabb*t134*t170*t3*t388-4.728549416827732d-
     6           6*gammaaa*t134*t165*t283*t3-1.4185648250483196d-5*gamma
     7           aa*gammabb*t134*t170*t283+1.525338521557333d-3*gammaaa*
     8           t134*t135*t165)*t5-8.266666666666665d-3*gammaaa*t134*t3
     9           65*t5-8.266666666666665d-3*gammabb*t165*t361*t5+3.1d-3*
     :           t2*t304*t5-8.266666666666665d-3*t136*t165*t5+2.56266666
     ;           6666666d-5*gammaaa*t134*t135*t3*t365+2.562666666666666d
     <           -5*gammabb*t135*t165*t3*t361-9.61d-6*t135*t2*t3*t304-1.
     =           5888533333333327d-7*gammaaa*t134*t166*t2*t283*t3+4.2369
     >           422222222203d-7*gammaaa*gammabb*t134*t165*t179*t283*t3-
     ?           1.5888533333333327d-7*gammabb*t136*t170*t283*t3+2.56266
     @           6666666666d-5*t135*t136*t165*t3+5.125333333333332d-5*ga
     1           mmaaa*t134*t135*t166*t2-1.366755555555555d-4*gammaaa*ga
     2           mmabb*t134*t135*t165*t179+5.125333333333332d-5*gammabb*
     3           t135*t136*t170)*t67+1.0d+0*t133*t366+1.0d+0*t164*t362+1
     4           .0d+0*t180*t303)*wght+Cmat3(iq,D3_RA_RB_GBB)
              Cmat3(iq,D3_RB_RB_GAA) = (1.0d+0*(-3.9403562666666647d-9*t
     1           1*t168*t3*t345*t388*t6+5.825795555555554d-7*gammabb*t1*
     2           t283*t3*t346*t6-1.8792888888888884d-4*gammabb*t1*t135*t
     3           346*t6+1.271082666666666d-6*t1*t168*t283*t345*t6+3.1d-3
     4           *t3*(4.3975509576497906d-8*t1*t168*t3*t345*t388-6.50175
     5           5448138132d-6*gammabb*t1*t283*t3*t346+2.097340467141333
     6           2d-3*gammabb*t1*t135*t346-1.4185648250483196d-5*t1*t168
     7           *t283*t345)*t5-1.653333333333333d-2*gammabb*t165*t363*t
     8           5+3.1d-3*t1*t347*t5+3.0311111111111105d-2*gammabb*t173*
     9           t346*t5+5.125333333333332d-5*gammabb*t135*t165*t3*t363-
     :           9.61d-6*t1*t135*t3*t347-9.396444444444442d-5*gammabb*t1
     ;           35*t173*t3*t346+4.2369422222222203d-7*t168*t173*t283*t3
     <           *t345-1.366755555555555d-4*t135*t168*t173*t345-3.177706
     =           6666666653d-7*gammabb*t1*t165*t166*t283*t3+1.0250666666
     >           666663d-4*gammabb*t1*t135*t165*t166)*t67+2.0d+0*t164*t3
     ?           64+1.0d+0*t174*t344)*wght+Cmat3(iq,D3_RB_RB_GAA)
              Cmat3(iq,D3_RB_RB_GAB) = Cmat3(iq,D3_RB_RB_GAB)
              Cmat3(iq,D3_RB_RB_GBB) = (t79*(5.0d-1*rhob*t35*(5.86666666
     1           6666666d-1*t346*t76*t77-5.529599999999998d-4*t350*t543*
     2           t552*t77+1.9583999999999993d-2*t168*t351*t352*t77-2.079
     3           9999999999996d-1*gammabb*t169*t345*t77+6.0d-2*gammabb*t
     4           2*t76*(1.3043825226666664d+0*t346*t76-1.229439817727999
     5           4d-3*t350*t543*t552+4.3542660211199985d-2*t168*t351*t35
     6           2-4.624628943999999d-1*gammabb*t169*t345)-3.19999999999
     7           99995d-1*gammabb*t165*t369*t76+6.0d-2*t2*t353*t76+5.866
     8           666666666666d-1*gammabb*t183*t346*t76-3.199999999999999
     9           5d-1*t165*t171*t76+1.9199999999999995d-2*t168*t169*t170
     :           *t369-2.303999999999999d-3*t168*t171*t351*t368-3.6d-3*g
     ;           ammabb*t169*t182*t353+3.0719999999999986d-3*t183*t350*t
     <           351*t352-8.639999999999998d-2*t168*t169*t183*t345+5.759
     =           999999999998d-2*gammabb*t169*t170*t171)*t81+1.0d+0*t35*
     >           t370*t81+1.0d+0*rhob*t153*t370*t81+5.0d-1*rhob*t184*t31
     ?           9*t81+1.0d+0*t153*t184*t81-1.25d-1*t153*t78*t80+1.25d-1
     @           *gammabb*t35*t370*t80-1.25d-1*t172*t35*t80+1.25d-1*gamm
     1           abb*t153*t184*t80+1.25d-1*t349*t35*t78-1.25d-1*t319*t78
     2           -1.25d-1*t35*t354+1.25d-1*gammabb*t184*t349*t35-2.5d-1*
     3           t153*t172)+(t551+t550+1.25d-1*gammabb*t35*t370+1.25d-1*
     4           gammabb*t153*t184)*t79*t80+t349*t549*t79+1.0d+0*(3.0311
     5           111111111105d-2*t346*t5*t6-3.9403562666666647d-9*t168*t
     6           3*t352*t388*t6+1.271082666666666d-6*t168*t283*t352*t6-9
     7           .396444444444442d-5*t135*t3*t346*t6+1.4299679999999995d
     8           -6*gammabb*t283*t3*t345*t6-4.612799999999999d-4*gammabb
     9           *t135*t345*t6+3.1d-3*t3*t5*(-3.3828072050666663d-1*t346
     :           *t5+4.3975509576497906d-8*t168*t3*t352*t388-1.418564825
     ;           0483196d-5*t168*t283*t352+1.0486702335706666d-3*t135*t3
     <           *t346-1.5958854281793597d-5*gammabb*t283*t3*t345+5.1480
     =           17510255999d-3*gammabb*t135*t345)-1.653333333333333d-2*
     >           gammabb*t165*t365*t5+3.1d-3*t2*t347*t5+3.03111111111111
     ?           05d-2*gammabb*t179*t346*t5-1.653333333333333d-2*t165*t1
     @           66*t5+5.125333333333332d-5*gammabb*t135*t165*t3*t365-9.
     1           61d-6*t135*t2*t3*t347-9.396444444444442d-5*gammabb*t135
     2           *t179*t3*t346+4.2369422222222203d-7*t168*t179*t283*t3*t
     3           345-1.366755555555555d-4*t135*t168*t179*t345-3.17770666
     4           66666653d-7*gammabb*t166*t170*t283*t3+5.125333333333332
     5           d-5*t135*t165*t166*t3+1.0250666666666663d-4*gammabb*t13
     6           5*t166*t170)*t67+2.0d+0*t164*t366+1.0d+0*t180*t344)*wgh
     7           t+Cmat3(iq,D3_RB_RB_GBB)
              Cmat3(iq,D3_RA_GAA_GAA) = (t72*(5.0d-1*rhoa*t375*t74*t92-2
     1           .5d-1*t178*t92+5.0d-1*rhoa*t21*(2.073599999999999d-4*t1
     2           38*t484*t554*t70-5.759999999999997d-3*gammaaa*t289*t358
     3           *t70+3.839999999999999d-2*t139*t140*t70+6.0d-2*gammaaa*
     4           t1*(4.6103993164799983d-4*t138*t484*t554-1.280666476799
     5           9995d-2*gammaaa*t289*t358+8.537776511999997d-2*t139*t14
     6           0)*t69-1.5999999999999998d-1*gammaaa*t134*t374*t69+1.2d
     7           -1*t1*t359*t69-3.1999999999999995d-1*t134*t177*t69+9.59
     8           9999999999997d-3*t138*t139*t140*t374+4.32d-4*gammaaa*t1
     9           41*t289*t373-7.2d-3*gammaaa*t139*t176*t359-2.3039999999
     :           99999d-3*t138*t177*t289*t358+5.759999999999998d-2*gamma
     ;           aa*t139*t140*t177-7.2d-3*t139*t141*t176)*t74+5.0d-1*t21
     <           *t375*t74-2.5d-1*t178*t21*t73-2.5d-1*t21*t360)+(t553+1.
     =           25d-1*gammaaa*t21*t375)*t72*t73+1.0d+0*(1.4776335999999
     >           993d-9*gammaaa*t3*t358*t388*t6-4.766559999999998d-7*gam
     ?           maaa*t283*t358*t6-3.1777066666666653d-7*t140*t283*t3*t6
     @           +1.0250666666666663d-4*t135*t140*t6+3.1d-3*t3*(-1.64908
     1           16091186716d-8*gammaaa*t3*t358*t388+5.319618093931199d-
     2           6*gammaaa*t283*t358+3.5464120626207996d-6*t140*t283*t3-
     3           1.1440038911679998d-3*t135*t140)*t5-8.266666666666665d-
     4           3*gammaaa*t134*t371*t5+6.2d-3*t1*t355*t5-1.653333333333
     5           333d-2*t134*t173*t5+2.562666666666666d-5*gammaaa*t134*t
     6           135*t3*t371-1.9219999999999998d-5*t1*t135*t3*t355+5.958
     7           2d-8*t136*t176*t283*t3-3.1777066666666653d-7*gammaaa*t1
     8           40*t173*t283*t3+5.125333333333332d-5*t134*t135*t173*t3-
     9           1.9219999999999998d-5*t135*t136*t176+1.0250666666666663
     :           d-4*gammaaa*t135*t140*t173)*t67+1.0d+0*t133*t372)*wght+
     ;           Cmat3(iq,D3_RA_GAA_GAA)
              Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
              Cmat3(iq,D3_RA_GAA_GBB) = (1.0d+0*(1.4776335999999993d-9*g
     1           ammaaa*t140*t2*t3*t388*t6-1.5888533333333327d-7*t134*t2
     2           *t283*t3*t6-4.766559999999998d-7*gammaaa*t140*t2*t283*t
     3           6+5.125333333333332d-5*t134*t135*t2*t6+3.1d-3*t3*(-1.64
     4           90816091186716d-8*gammaaa*t140*t2*t3*t388+1.77320603131
     5           03998d-6*t134*t2*t283*t3+5.319618093931199d-6*gammaaa*t
     6           140*t2*t283-5.72001945584d-4*t134*t135*t2)*t5-8.2666666
     7           66666665d-3*gammaaa*t134*t376*t5+3.1d-3*t1*t361*t5+3.1d
     8           -3*t2*t355*t5-8.266666666666665d-3*t134*t179*t5+2.56266
     9           6666666666d-5*gammaaa*t134*t135*t3*t376-9.61d-6*t1*t135
     :           *t3*t361-9.61d-6*t135*t2*t3*t355-1.5888533333333327d-7*
     ;           gammaaa*t134*t173*t2*t283*t3+5.9582d-8*t1*t136*t2*t283*
     <           t3-1.5888533333333327d-7*gammaaa*t140*t179*t283*t3+2.56
     =           2666666666666d-5*t134*t135*t179*t3+5.125333333333332d-5
     >           *gammaaa*t134*t135*t173*t2-1.9219999999999998d-5*t1*t13
     ?           5*t136*t2+5.125333333333332d-5*gammaaa*t135*t140*t179)*
     @           t67+1.0d+0*t133*t377)*wght+Cmat3(iq,D3_RA_GAA_GBB)
              Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
              Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
              Cmat3(iq,D3_RA_GBB_GBB) = (1.0d+0*(1.4776335999999993d-9*g
     1           ammaaa*t134*t182*t3*t388*t6-4.766559999999998d-7*gammaa
     2           a*t134*t182*t283*t6+3.1d-3*t3*(5.319618093931199d-6*gam
     3           maaa*t134*t182*t283-1.6490816091186716d-8*gammaaa*t134*
     4           t182*t3*t388)*t5-8.266666666666665d-3*gammaaa*t134*t378
     5           *t5+6.2d-3*t2*t361*t5+2.562666666666666d-5*gammaaa*t134
     6           *t135*t3*t378-1.9219999999999998d-5*t135*t2*t3*t361-3.1
     7           777066666666653d-7*gammaaa*t134*t179*t2*t283*t3+5.9582d
     8           -8*t136*t182*t283*t3+1.0250666666666663d-4*gammaaa*t134
     9           *t135*t179*t2-1.9219999999999998d-5*t135*t136*t182)*t67
     :           +1.0d+0*t133*t379)*wght+Cmat3(iq,D3_RA_GBB_GBB)
              Cmat3(iq,D3_RB_GAA_GAA) = (1.0d+0*(1.4776335999999993d-9*g
     1           ammabb*t165*t176*t3*t388*t6-4.766559999999998d-7*gammab
     2           b*t165*t176*t283*t6+3.1d-3*t3*(5.319618093931199d-6*gam
     3           mabb*t165*t176*t283-1.6490816091186716d-8*gammabb*t165*
     4           t176*t3*t388)*t5-8.266666666666665d-3*gammabb*t165*t371
     5           *t5+6.2d-3*t1*t363*t5+2.562666666666666d-5*gammabb*t135
     6           *t165*t3*t371-1.9219999999999998d-5*t1*t135*t3*t363+5.9
     7           582d-8*t166*t176*t283*t3-3.1777066666666653d-7*gammabb*
     8           t1*t165*t173*t283*t3-1.9219999999999998d-5*t135*t166*t1
     9           76+1.0250666666666663d-4*gammabb*t1*t135*t165*t173)*t67
     :           +1.0d+0*t164*t372)*wght+Cmat3(iq,D3_RB_GAA_GAA)
              Cmat3(iq,D3_RB_GAA_GAB) = Cmat3(iq,D3_RB_GAA_GAB)
              Cmat3(iq,D3_RB_GAA_GBB) = (1.0d+0*(1.4776335999999993d-9*g
     1           ammabb*t1*t170*t3*t388*t6-1.5888533333333327d-7*t1*t165
     2           *t283*t3*t6-4.766559999999998d-7*gammabb*t1*t170*t283*t
     3           6+5.125333333333332d-5*t1*t135*t165*t6+3.1d-3*t3*(-1.64
     4           90816091186716d-8*gammabb*t1*t170*t3*t388+1.77320603131
     5           03998d-6*t1*t165*t283*t3+5.319618093931199d-6*gammabb*t
     6           1*t170*t283-5.72001945584d-4*t1*t135*t165)*t5-8.2666666
     7           66666665d-3*gammabb*t165*t376*t5+3.1d-3*t1*t365*t5+3.1d
     8           -3*t2*t363*t5-8.266666666666665d-3*t165*t173*t5+2.56266
     9           6666666666d-5*gammabb*t135*t165*t3*t376-9.61d-6*t1*t135
     :           *t3*t365-9.61d-6*t135*t2*t3*t363+5.9582d-8*t1*t166*t2*t
     ;           283*t3-1.5888533333333327d-7*gammabb*t1*t165*t179*t283*
     <           t3-1.5888533333333327d-7*gammabb*t170*t173*t283*t3+2.56
     =           2666666666666d-5*t135*t165*t173*t3-1.9219999999999998d-
     >           5*t1*t135*t166*t2+5.125333333333332d-5*gammabb*t1*t135*
     ?           t165*t179+5.125333333333332d-5*gammabb*t135*t170*t173)*
     @           t67+1.0d+0*t164*t377)*wght+Cmat3(iq,D3_RB_GAA_GBB)
              Cmat3(iq,D3_RB_GAB_GAB) = Cmat3(iq,D3_RB_GAB_GAB)
              Cmat3(iq,D3_RB_GAB_GBB) = Cmat3(iq,D3_RB_GAB_GBB)
              Cmat3(iq,D3_RB_GBB_GBB) = (t79*(5.0d-1*rhob*t35*(2.0735999
     1           99999999d-4*t168*t543*t556*t77-5.759999999999997d-3*gam
     2           mabb*t351*t368*t77+3.839999999999999d-2*t169*t170*t77+6
     3           .0d-2*gammabb*t2*(4.6103993164799983d-4*t168*t543*t556-
     4           1.2806664767999995d-2*gammabb*t351*t368+8.5377765119999
     5           97d-2*t169*t170)*t76-1.5999999999999998d-1*gammabb*t165
     6           *t381*t76+1.2d-1*t2*t369*t76-3.1999999999999995d-1*t165
     7           *t183*t76+9.599999999999997d-3*t168*t169*t170*t381+4.32
     8           d-4*gammabb*t171*t351*t380-7.2d-3*gammabb*t169*t182*t36
     9           9-2.303999999999999d-3*t168*t183*t351*t368+5.7599999999
     :           99998d-2*gammabb*t169*t170*t183-7.2d-3*t169*t171*t182)*
     ;           t81+5.0d-1*t35*t382*t81+5.0d-1*rhob*t153*t382*t81-2.5d-
     <           1*t184*t35*t80-2.5d-1*t35*t370-2.5d-1*t153*t184)+(t555+
     =           1.25d-1*gammabb*t35*t382)*t79*t80+1.0d+0*(1.47763359999
     >           99993d-9*gammabb*t3*t368*t388*t6-4.766559999999998d-7*g
     ?           ammabb*t283*t368*t6-3.1777066666666653d-7*t170*t283*t3*
     @           t6+1.0250666666666663d-4*t135*t170*t6+3.1d-3*t3*(-1.649
     1           0816091186716d-8*gammabb*t3*t368*t388+5.319618093931199
     2           d-6*gammabb*t283*t368+3.5464120626207996d-6*t170*t283*t
     3           3-1.1440038911679998d-3*t135*t170)*t5-8.266666666666665
     4           d-3*gammabb*t165*t378*t5+6.2d-3*t2*t365*t5-1.6533333333
     5           33333d-2*t165*t179*t5+2.562666666666666d-5*gammabb*t135
     6           *t165*t3*t378-1.9219999999999998d-5*t135*t2*t3*t365+5.9
     7           582d-8*t166*t182*t283*t3-3.1777066666666653d-7*gammabb*
     8           t170*t179*t283*t3+5.125333333333332d-5*t135*t165*t179*t
     9           3-1.9219999999999998d-5*t135*t166*t182+1.02506666666666
     :           63d-4*gammabb*t135*t170*t179)*t67+1.0d+0*t164*t379)*wgh
     ;           t+Cmat3(iq,D3_RB_GBB_GBB)
              Cmat3(iq,D3_GAA_GAA_GAA) = (t72*(5.0d-1*rhoa*t21*(-7.776d-
     1           5*gammaaa*t484*t557*t70+1.296d-3*t289*t373*t70+6.0d-2*g
     2           ammaaa*t1*(2.881499572799999d-3*t289*t373-1.72889974367
     3           99997d-4*gammaaa*t484*t557)*t69+1.8d-1*t1*t374*t69-1.08
     4           00000000000001d-2*gammaaa*t139*t176*t374+1.296d-3*gamma
     5           aa*t177*t289*t373-2.1600000000000003d-2*t139*t176*t177)
     6           *t74-3.75d-1*t21*t375)+1.0d+0*(-5.541126d-10*t3*t373*t3
     7           88*t6+1.78746d-7*t283*t373*t6+3.1d-3*t3*(6.184056034195
     8           019d-9*t3*t373*t388-1.9948567852242d-6*t283*t373)*t5+9.
     9           299999999999999d-3*t1*t371*t5-2.883d-5*t1*t135*t3*t371+
     :           1.78746d-7*t173*t176*t283*t3-5.766d-5*t135*t173*t176)*t
     ;           67)*wght+Cmat3(iq,D3_GAA_GAA_GAA)
              Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
              Cmat3(iq,D3_GAA_GAA_GBB) = 1.0d+0*(-5.541126d-10*t176*t2*t
     1           3*t388*t6+1.78746d-7*t176*t2*t283*t6+3.1d-3*t3*(6.18405
     2           6034195019d-9*t176*t2*t3*t388-1.9948567852242d-6*t176*t
     3           2*t283)*t5+6.2d-3*t1*t376*t5+3.1d-3*t2*t371*t5-1.921999
     4           9999999998d-5*t1*t135*t3*t376-9.61d-6*t135*t2*t3*t371+1
     5           .1916399999999999d-7*t1*t173*t2*t283*t3+5.9582d-8*t176*
     6           t179*t283*t3-3.8439999999999996d-5*t1*t135*t173*t2-1.92
     7           19999999999998d-5*t135*t176*t179)*t67*wght+Cmat3(iq,D3_
     8           GAA_GAA_GBB)
              Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
              Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
              Cmat3(iq,D3_GAA_GBB_GBB) = 1.0d+0*(-5.541126d-10*t1*t182*t
     1           3*t388*t6+1.78746d-7*t1*t182*t283*t6+3.1d-3*t3*(6.18405
     2           6034195019d-9*t1*t182*t3*t388-1.9948567852242d-6*t1*t18
     3           2*t283)*t5+3.1d-3*t1*t378*t5+6.2d-3*t2*t376*t5-9.61d-6*
     4           t1*t135*t3*t378-1.9219999999999998d-5*t135*t2*t3*t376+1
     5           .1916399999999999d-7*t1*t179*t2*t283*t3+5.9582d-8*t173*
     6           t182*t283*t3-3.8439999999999996d-5*t1*t135*t179*t2-1.92
     7           19999999999998d-5*t135*t173*t182)*t67*wght+Cmat3(iq,D3_
     8           GAA_GBB_GBB)
              Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
              Cmat3(iq,D3_GAB_GAB_GBB) = Cmat3(iq,D3_GAB_GAB_GBB)
              Cmat3(iq,D3_GAB_GBB_GBB) = Cmat3(iq,D3_GAB_GBB_GBB)
              Cmat3(iq,D3_GBB_GBB_GBB) = (t79*(5.0d-1*rhob*t35*(-7.776d-
     1           5*gammabb*t543*t558*t77+1.296d-3*t351*t380*t77+6.0d-2*g
     2           ammabb*t2*(2.881499572799999d-3*t351*t380-1.72889974367
     3           99997d-4*gammabb*t543*t558)*t76+1.8d-1*t2*t381*t76-1.08
     4           00000000000001d-2*gammabb*t169*t182*t381+1.296d-3*gamma
     5           bb*t183*t351*t380-2.1600000000000003d-2*t169*t182*t183)
     6           *t81-3.75d-1*t35*t382)+1.0d+0*(-5.541126d-10*t3*t380*t3
     7           88*t6+1.78746d-7*t283*t380*t6+3.1d-3*t3*(6.184056034195
     8           019d-9*t3*t380*t388-1.9948567852242d-6*t283*t380)*t5+9.
     9           299999999999999d-3*t2*t378*t5-2.883d-5*t135*t2*t3*t378+
     :           1.78746d-7*t179*t182*t283*t3-5.766d-5*t135*t179*t182)*t
     ;           67)*wght+Cmat3(iq,D3_GBB_GBB_GBB)
              Mmat3(iq,D3_RA_RA_TA) = (t185*(-1.0d+0*t71*t74*t92-1.0d+0*
     1           rhoa*t142*t74*t92-1.25d-1*gammaaa*t71*t73*t92-5.0d-1*rh
     2           oa*t200*t71*t74-5.0d-1*rhoa*t21*t292*t74-1.0d+0*t142*t2
     3           1*t74-1.25d-1*gammaaa*t142*t21*t73-1.25d-1*gammaaa*t21*
     4           t287*t71)+t185*t73*(-1.25d-1*gammaaa*t71*t92-1.25d-1*ga
     5           mmaaa*t142*t21)+t72*(2.0d+0*t71*t92+2.0d+0*rhoa*t142*t9
     6           2+1.0d+0*rhoa*t200*t71+1.0d+0*rhoa*t21*t292+2.0d+0*t142
     7           *t21)+1.25d-1*gammaaa*t185*t21*t287*t71)*wght+Mmat3(iq,
     8           D3_RA_RA_TA)
              Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
              Mmat3(iq,D3_RA_RB_TA) = Mmat3(iq,D3_RA_RB_TA)
              Mmat3(iq,D3_RA_RB_TB) = Mmat3(iq,D3_RA_RB_TB)
              Mmat3(iq,D3_RB_RB_TA) = Mmat3(iq,D3_RB_RB_TA)
              Mmat3(iq,D3_RB_RB_TB) = (t186*(-5.0d-1*rhob*t319*t78*t81-1
     1           .0d+0*t153*t78*t81-5.0d-1*rhob*t35*t354*t81-1.0d+0*t172
     2           *t35*t81-1.0d+0*rhob*t153*t172*t81-1.25d-1*gammabb*t153
     3           *t78*t80-1.25d-1*gammabb*t172*t35*t80-1.25d-1*gammabb*t
     4           349*t35*t78)+t186*(-1.25d-1*gammabb*t153*t78-1.25d-1*ga
     5           mmabb*t172*t35)*t80+(1.0d+0*rhob*t319*t78+2.0d+0*t153*t
     6           78+1.0d+0*rhob*t35*t354+2.0d+0*t172*t35+2.0d+0*rhob*t15
     7           3*t172)*t79+1.25d-1*gammabb*t186*t349*t35*t78)*wght+Mma
     8           t3(iq,D3_RB_RB_TB)
              Mmat3(iq,D3_RA_GAA_TA) = (t185*(-5.0d-1*rhoa*t178*t74*t92-
     1           5.0d-1*rhoa*t21*t360*t74-5.0d-1*t178*t21*t74+1.25d-1*t2
     2           1*t71*t73+t547+t546)+t72*(1.0d+0*rhoa*t178*t92+1.0d+0*r
     3           hoa*t21*t360+1.0d+0*t178*t21)+t185*t545*t73)*wght+Mmat3
     4           (iq,D3_RA_GAA_TA)
              Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
              Mmat3(iq,D3_RA_GAB_TA) = Mmat3(iq,D3_RA_GAB_TA)
              Mmat3(iq,D3_RA_GAB_TB) = Mmat3(iq,D3_RA_GAB_TB)
              Mmat3(iq,D3_RA_GBB_TA) = Mmat3(iq,D3_RA_GBB_TA)
              Mmat3(iq,D3_RA_GBB_TB) = Mmat3(iq,D3_RA_GBB_TB)
              Mmat3(iq,D3_RB_GAA_TA) = Mmat3(iq,D3_RB_GAA_TA)
              Mmat3(iq,D3_RB_GAA_TB) = Mmat3(iq,D3_RB_GAA_TB)
              Mmat3(iq,D3_RB_GAB_TA) = Mmat3(iq,D3_RB_GAB_TA)
              Mmat3(iq,D3_RB_GAB_TB) = Mmat3(iq,D3_RB_GAB_TB)
              Mmat3(iq,D3_RB_GBB_TA) = Mmat3(iq,D3_RB_GBB_TA)
              Mmat3(iq,D3_RB_GBB_TB) = (t186*(-5.0d-1*rhob*t35*t370*t81-
     1           5.0d-1*t184*t35*t81-5.0d-1*rhob*t153*t184*t81+1.25d-1*t
     2           35*t78*t80+t551+t550)+t186*t549*t80+(1.0d+0*rhob*t35*t3
     3           70+1.0d+0*t184*t35+1.0d+0*rhob*t153*t184)*t79)*wght+Mma
     4           t3(iq,D3_RB_GBB_TB)
              Mmat3(iq,D3_RA_TA_TA) = (t185*(t553-5.0d-1*rhoa*t21*t375*t
     1           74)+1.0d+0*rhoa*t21*t375*t72)*wght+Mmat3(iq,D3_RA_TA_TA
     2           )
              Mmat3(iq,D3_RA_TA_TB) = Mmat3(iq,D3_RA_TA_TB)
              Mmat3(iq,D3_RA_TB_TB) = Mmat3(iq,D3_RA_TB_TB)
              Mmat3(iq,D3_RB_TA_TA) = Mmat3(iq,D3_RB_TA_TA)
              Mmat3(iq,D3_RB_TA_TB) = Mmat3(iq,D3_RB_TA_TB)
              Mmat3(iq,D3_RB_TB_TB) = Mmat3(iq,D3_RB_TB_TB)
              Mmat3(iq,D3_GAA_GAA_TA) = Mmat3(iq,D3_GAA_GAA_TA)
              Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
              Mmat3(iq,D3_GAA_GAB_TA) = Mmat3(iq,D3_GAA_GAB_TA)
              Mmat3(iq,D3_GAA_GAB_TB) = Mmat3(iq,D3_GAA_GAB_TB)
              Mmat3(iq,D3_GAA_GBB_TA) = Mmat3(iq,D3_GAA_GBB_TA)
              Mmat3(iq,D3_GAA_GBB_TB) = (t186*(t555-5.0d-1*rhob*t35*t382
     1           *t81)+1.0d+0*rhob*t35*t382*t79)*wght+Mmat3(iq,D3_GAA_GB
     2           B_TB)
              Mmat3(iq,D3_GAB_GAB_TA) = (-2*t383*t385-2.0d+0*rhoa*t178*t
     1           185*t21)*wght+Mmat3(iq,D3_GAB_GAB_TA)
              Mmat3(iq,D3_GAB_GAB_TB) = Mmat3(iq,D3_GAB_GAB_TB)
              Mmat3(iq,D3_GAB_GBB_TA) = Mmat3(iq,D3_GAB_GBB_TA)
              Mmat3(iq,D3_GAB_GBB_TB) = Mmat3(iq,D3_GAB_GBB_TB)
              Mmat3(iq,D3_GBB_GBB_TA) = Mmat3(iq,D3_GBB_GBB_TA)
              Mmat3(iq,D3_GBB_GBB_TB) = Mmat3(iq,D3_GBB_GBB_TB)
              Mmat3(iq,D3_GAA_TA_TA) = Mmat3(iq,D3_GAA_TA_TA)
              Mmat3(iq,D3_GAA_TA_TB) = Mmat3(iq,D3_GAA_TA_TB)
              Mmat3(iq,D3_GAA_TB_TB) = (-2*t384*t386-2.0d+0*rhob*t184*t1
     1           86*t35)*wght+Mmat3(iq,D3_GAA_TB_TB)
              Mmat3(iq,D3_GAB_TA_TA) = (6.0d+0*rhoa*t21*t385*t71-3.0d+0*
     1           rhoa*t21*t71*t74/taua**4)*wght+Mmat3(iq,D3_GAB_TA_TA)
              Mmat3(iq,D3_GAB_TA_TB) = Mmat3(iq,D3_GAB_TA_TB)
              Mmat3(iq,D3_GAB_TB_TB) = Mmat3(iq,D3_GAB_TB_TB)
              Mmat3(iq,D3_GBB_TA_TA) = (6.0d+0*rhob*t35*t386*t78-3.0d+0*
     1           rhob*t35*t78*t81/taub**4)*wght+Mmat3(iq,D3_GBB_TA_TA)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = 1/rhob**1.6666666666666669d+0
              t2 = 2.4d-51*t1+1.0d+0
              t3 = 1/t2
              t4 = 5.336110319999999d-51*t1*t3-2.5960897d+0
              t5 = 2.4d-51*t1*t3*t4+1.0d+0
              t6 = 1/rhob**6.666666666666666d-1
              t7 = rhob**5.0d-1
              t8 = 1/t7
              t9 = 1/rhob**3.333333333333333d-1
              t10 = 1/rhob**1.6666666666666666d-1
              t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.4
     1           058712912881916d-1*t6+1.1120374863094686d+1*t10
              t12 = 3.216395899738507d+1/t11+1.0d+0
              t13 = log(t12)
              t14 = 1.274696188700087d-1*t9+1.0d+0
              t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.8
     1           970043257475583d-1*t6+5.982550435771079d+0*t10
              t16 = 1.6081979498692536d+1/t15+1.0d+0
              t17 = log(t16)
              t18 = 1.3256889990520176d-1*t9+1.0d+0
              t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2
     1           *t13*t14
              t20 = 1/rhoa**2.6666666666666666d+0
              t21 = gammaaa*t20+4.0d-50*t1
              t22 = 3.1d-3*t21+1.0d+0
              t23 = 1/t22
              t24 = 5.9515308d+0-3.459689187d-2*t21*t23
              t25 = 3.1d-3*t21*t23*t24+1.0d+0
              t26 = 1/rhoa**6.666666666666666d-1
              t27 = rhoa**5.0d-1
              t28 = 1/t27
              t29 = 1/rhoa**3.333333333333333d-1
              t30 = 1/rhoa**1.6666666666666666d-1
              t31 = 1.1120374863094686d+1*t30+3.8447462374472113d+0*t29+
     1           1.644733775567609d+0*t28+2.4058712912881916d-1*t26
              t32 = 3.216395899738507d+1/t31+1.0d+0
              t33 = log(t32)
              t34 = 1.274696188700087d-1*t29+1.0d+0
              t35 = 5.982550435771079d+0*t30+2.2255694211506874d+0*t29+8
     1           .004286349993635d-1*t28+1.8970043257475583d-1*t26
              t36 = 1.6081979498692536d+1/t35+1.0d+0
              t37 = log(t36)
              t38 = 1.3256889990520176d-1*t29+1.0d+0
              t39 = -6.903522198342671d-18*t37*t38-3.1090699999999993d-2
     1           *t33*t34
              t40 = rhob+rhoa
              t41 = 1/t40**3.333333333333333d-1
              t42 = 1.3256889990520176d-1*t41+1.0d+0
              t43 = rhoa-rhob
              t44 = t43**4
              t45 = 1/t40**4
              t46 = 1/t40
              t47 = 1.0d+0-t43*t46
              t48 = t43*t46+1.0d+0
              t49 = t48**1.3333333333333333d+0+t47**1.3333333333333333d+
     1           0-2.0d+0
              t50 = -1.923661050931536d+0*t44*t45*t49
              t51 = t50+1.0d+0
              t52 = 1/t40**6.666666666666666d-1
              t53 = t40**5.0d-1
              t54 = 1/t53
              t55 = 1/t40**1.6666666666666666d-1
              t56 = 5.982550435771079d+0*t55+8.004286349993635d-1*t54+1.
     1           8970043257475583d-1*t52+2.2255694211506874d+0*t41
              t57 = 1.6081979498692536d+1/t56+1.0d+0
              t58 = log(t57)
              t59 = -6.21814d-2*t42*t51*t58
              t60 = 6.901399211255825d-2*t41+1.0d+0
              t61 = t50+1.923661050931536d+0*t49
              t62 = 8.157414703487641d+0*t55+4.3009724712766434d-1*t54+1
     1           .9115125951273373d-1*t52+2.247591863577616d+0*t41
              t63 = 2.9608813203268075d+1/t62+1.0d+0
              t64 = log(t63)
              t65 = 1.9751631321680768d-2*t60*t61*t64
              t66 = 1.274696188700087d-1*t41+1.0d+0
              t67 = 1.1120374863094686d+1*t55+1.644733775567609d+0*t54+2
     1           .4058712912881916d-1*t52+3.8447462374472113d+0*t41
              t68 = 3.216395899738507d+1/t67+1.0d+0
              t69 = log(t68)
              t70 = -5.980796863619711d-2*t44*t45*t49*t66*t69
              t71 = t40*(t70+t65+t59)-rhoa*t39-rhob*t19
              t72 = 6.0d-2*gammaaa*t20+1.0d+0
              t73 = 1/t72
              t74 = 1.3340275799999998d-1*gammaaa*t20*t73-2.5960897d+0
              t75 = 6.0d-2*gammaaa*t20*t73*t74+1.0d+0
              t76 = 1/taua
              t77 = 1/rhoa
              t78 = 2.0d+0*taua-2.5d-1*gammaaa*t77
              t79 = 1/t36
              t80 = 1/rhoa**1.6666666666666669d+0
              t81 = 1/t27**3
              t82 = 1/rhoa**1.3333333333333333d+0
              t83 = 1/rhoa**1.1666666666666667d+0
              t84 = -9.970917392951799d-1*t83-7.418564737168958d-1*t82-4
     1           .002143174996817d-1*t81-1.264669550498372d-1*t80
              t85 = 1/t35**2
              t86 = 1/t32
              t87 = -1.8533958105157808d+0*t83-1.2815820791490704d+0*t82
     1           -8.223668877838045d-1*t81-1.6039141941921276d-1*t80
              t88 = 1/t31**2
              t89 = 1.0d+0*t34*t86*t87*t88+1.1102230246251565d-16*t38*t7
     1           9*t84*t85+3.0506411443514264d-19*t37*t82+1.321039893133
     2           9265d-3*t33*t82
              t90 = 1/t40**1.6666666666666669d+0
              t91 = 1/t53**3
              t92 = 1/t40**1.3333333333333333d+0
              t93 = 1/t40**1.1666666666666667d+0
              t94 = -9.970917392951799d-1*t93-7.418564737168958d-1*t92-4
     1           .002143174996817d-1*t91-1.264669550498372d-1*t90
              t95 = 1/t56**2
              t96 = 1/t57
              t97 = 1.0d+0*t42*t51*t94*t95*t96
              t98 = -1.3595691172479402d+0*t93-7.491972878592053d-1*t92-
     1           2.1504862356383217d-1*t91-1.2743417300848914d-1*t90
              t99 = 1/t62**2
              t100 = 1/t63
              t101 = -5.848223622634647d-1*t100*t60*t61*t98*t99
              t102 = -1.8533958105157808d+0*t93-1.2815820791490704d+0*t9
     1           2-8.223668877838045d-1*t91-1.6039141941921276d-1*t90
              t103 = 1/t67**2
              t104 = 1/t68
              t105 = 1.923661050931536d+0*t102*t103*t104*t44*t45*t49*t66
              t106 = 1/t40**2
              t107 = t106*t43
              t108 = -t46
              t109 = t108+t107
              t110 = t47**3.333333333333333d-1
              t111 = -t106*t43
              t112 = t46+t111
              t113 = t48**3.333333333333333d-1
              t114 = 1.3333333333333333d+0*t112*t113+1.3333333333333333d
     1           +0*t109*t110
              t115 = -1.923661050931536d+0*t114*t44*t45
              t116 = 1/t40**5
              t117 = 7.694644203726144d+0*t116*t44*t49
              t118 = t43**3
              t119 = -7.694644203726144d+0*t118*t45*t49
              t120 = t119+t117+t115
              t121 = -6.21814d-2*t120*t42*t58
              t122 = 2.747773264188437d-3*t51*t58*t92
              t123 = t119+t117+t115+1.923661050931536d+0*t114
              t124 = 1.9751631321680768d-2*t123*t60*t64
              t125 = -4.5437964274821163d-4*t61*t64*t92
              t126 = -5.980796863619711d-2*t114*t44*t45*t66*t69
              t127 = 1/t40**5.333333333333333d+0
              t128 = 2.541232989148493d-3*t127*t44*t49*t69
              t129 = 2.3923187454478842d-1*t116*t44*t49*t66*t69
              t130 = t40*(t97-2.3923187454478842d-1*t118*t45*t49*t66*t69
     1           +t129+t128+t126+t125+t124+t122+t121+t105+t101)-rhoa*t89
     2           +t70+t65+t59+6.903522198342671d-18*t37*t38+3.1090699999
     3           999993d-2*t33*t34
              t131 = 1/rhoa**3.6666666666666664d+0
              t132 = 1/t22**2
              t133 = 9.225837832d-2*gammaaa*t131*t23-2.86000972792d-4*ga
     1           mmaaa*t131*t132*t21
              t134 = -8.266666666666665d-3*gammaaa*t131*t23*t24+2.562666
     1           666666666d-5*gammaaa*t131*t132*t21*t24+3.1d-3*t133*t21*
     2           t23
              t135 = gammaaa**2
              t136 = 1/t72**2
              t137 = 1/rhoa**6.333333333333333d+0
              t138 = 2.1344441279999993d-2*t135*t136*t137-3.557406879999
     1           999d-1*gammaaa*t131*t73
              t139 = -1.5999999999999998d-1*gammaaa*t131*t73*t74+9.59999
     1           9999999997d-3*t135*t136*t137*t74+6.0d-2*gammaaa*t138*t2
     2           0*t73
              t140 = 1/t16
              t141 = 1/t7**3
              t142 = 1/rhob**1.3333333333333333d+0
              t143 = 1/rhob**1.1666666666666667d+0
              t144 = -9.970917392951799d-1*t143-7.418564737168958d-1*t14
     1           2-4.002143174996817d-1*t141-1.264669550498372d-1*t1
              t145 = 1/t15**2
              t146 = 1/t12
              t147 = -1.8533958105157808d+0*t143-1.2815820791490704d+0*t
     1           142-8.223668877838045d-1*t141-1.6039141941921276d-1*t1
              t148 = 1/t11**2
              t149 = 1.1102230246251565d-16*t140*t144*t145*t18+3.0506411
     1           443514264d-19*t142*t17+1.0d+0*t14*t146*t147*t148+1.3210
     2           398931339265d-3*t13*t142
              t150 = 1/t2**2
              t151 = 1/rhob**4.333333333333333d+0
              t152 = 1/rhob**2.6666666666666666d+0
              t153 = 2.134444128d-101*t150*t151-8.8935172d-51*t152*t3
              t154 = -4.0d-51*t152*t3*t4+9.6d-102*t150*t151*t4+2.4d-51*t
     1           1*t153*t3
              t155 = t46+t107
              t156 = t111+t108
              t157 = 1.3333333333333333d+0*t113*t156+1.3333333333333333d
     1           +0*t110*t155
              t158 = -1.923661050931536d+0*t157*t44*t45
              t159 = 7.694644203726144d+0*t118*t45*t49
              t160 = t159+t158+t117
              t161 = -6.21814d-2*t160*t42*t58
              t162 = t159+t158+1.923661050931536d+0*t157+t117
              t163 = 1.9751631321680768d-2*t162*t60*t64
              t164 = -5.980796863619711d-2*t157*t44*t45*t66*t69
              t165 = t40*(t97+2.3923187454478842d-1*t118*t45*t49*t66*t69
     1           +t164+t163+t161+t129+t128+t125+t122+t105+t101)+t70+t65+
     2           t59+6.903522198342671d-18*t17*t18-rhob*t149+3.109069999
     3           9999993d-2*t13*t14
              t166 = 2.306459458d-51*t152*t23-7.1500243198d-54*t132*t152
     1           *t21
              t167 = -2.0666666666666667d-52*t152*t23*t24+6.406666666666
     1           666d-55*t132*t152*t21*t24+3.1d-3*t166*t21*t23
              t168 = 1.07250364797d-4*t132*t20*t21-3.459689187d-2*t20*t2
     1           3
              t169 = 3.1d-3*t20*t23*t24-9.61d-6*t132*t20*t21*t24+3.1d-3*
     1           t168*t21*t23
              t170 = -1.25d-1*t39*t75
              t171 = 1/rhoa**5.333333333333333d+0
              t172 = 1.3340275799999998d-1*t20*t73-8.004165479999998d-3*
     1           gammaaa*t136*t171
              t173 = 6.0d-2*t20*t73*t74-3.6d-3*gammaaa*t136*t171*t74+6.0
     1           d-2*gammaaa*t172*t20*t73
              t174 = 1/taua**2
              t175 = 1/t36**2
              t176 = t84**2
              t177 = 1/t35**4
              t178 = 1/t35**3
              t179 = 1/t27**5
              t180 = 1/rhoa**2.3333333333333334d+0
              t181 = 1/rhoa**2.1666666666666665d+0
              t182 = 2.1077825841639536d-1*t20+1.1632736958443765d+0*t18
     1           1+9.89141964955861d-1*t180+6.003214762495226d-1*t179
              t183 = 1/t32**2
              t184 = t87**2
              t185 = 1/t31**4
              t186 = 1/t31**3
              t187 = 2.673190323653546d-1*t20+2.1622951122684114d+0*t181
     1           +1.7087761055320938d+0*t180+1.2335503316757068d+0*t179
              t188 = -8.497974591333913d-2*t82*t86*t87*t88+1.0d+0*t187*t
     1           34*t86*t88-2.0d+0*t184*t186*t34*t86-9.812069668265515d-
     2           18*t79*t82*t84*t85+1.1102230246251565d-16*t182*t38*t79*
     3           t85-2.220446049250313d-16*t176*t178*t38*t79+1.785458392
     4           0998188d-15*t175*t176*t177*t38-4.0675215258019015d-19*t
     5           180*t37+3.216395899738507d+1*t183*t184*t185*t34-1.76138
     6           65241785684d-3*t180*t33
              t189 = 2.0d+0*t42*t51*t94*t95*t96
              t190 = -1.1696447245269295d+0*t100*t60*t61*t98*t99
              t191 = 3.847322101863072d+0*t102*t103*t104*t44*t45*t49*t66
              t192 = 5.495546528376875d-3*t51*t58*t92
              t193 = -9.087592854964233d-4*t61*t64*t92
              t194 = 5.082465978296986d-3*t127*t44*t49*t69
              t195 = 4.7846374908957684d-1*t116*t44*t49*t66*t69
              t196 = t94**2
              t197 = 1/t56**4
              t198 = 1/t57**2
              t199 = 1.6081979498692536d+1*t196*t197*t198*t42*t51
              t200 = 2.0d+0*t120*t42*t94*t95*t96
              t201 = 1/t56**3
              t202 = -2.0d+0*t196*t201*t42*t51*t96
              t203 = -8.837926660346784d-2*t51*t92*t94*t95*t96
              t204 = 1/t40**2.6666666666666666d+0
              t205 = 1/t53**5
              t206 = 1/t40**2.3333333333333334d+0
              t207 = 1/t40**2.1666666666666665d+0
              t208 = 1.1632736958443765d+0*t207+9.89141964955861d-1*t206
     1           +6.003214762495226d-1*t205+2.1077825841639536d-1*t204
              t209 = 1.0d+0*t208*t42*t51*t95*t96
              t210 = t98**2
              t211 = 1/t62**4
              t212 = 1/t63**2
              t213 = -1.73158960813529d+1*t210*t211*t212*t60*t61
              t214 = -1.1696447245269295d+0*t100*t123*t60*t98*t99
              t215 = 1/t62**3
              t216 = 1.1696447245269295d+0*t100*t210*t215*t60*t61
              t217 = 2.690728393099896d-2*t100*t61*t92*t98*t99
              t218 = 1.5861639701225969d+0*t207+9.98929717145607d-1*t206
     1           +3.2257293534574827d-1*t205+2.1239028834748191d-1*t204
              t219 = -5.848223622634647d-1*t100*t218*t60*t61*t99
              t220 = t102**2
              t221 = 1/t67**4
              t222 = 1/t68**2
              t223 = 6.187255516702861d+1*t220*t221*t222*t44*t45*t49*t66
              t224 = 3.847322101863072d+0*t102*t103*t104*t114*t44*t45*t6
     1           6
              t225 = 1/t67**3
              t226 = -3.847322101863072d+0*t104*t220*t225*t44*t45*t49*t6
     1           6
              t227 = -1.6347222733154887d-1*t102*t103*t104*t127*t44*t49
              t228 = 2.1622951122684114d+0*t207+1.7087761055320938d+0*t2
     1           06+1.2335503316757068d+0*t205+2.673190323653546d-1*t204
              t229 = 1.923661050931536d+0*t103*t104*t228*t44*t45*t49*t66
              t230 = -1.538928840745229d+1*t102*t103*t104*t116*t44*t49*t
     1           66
              t231 = 1.538928840745229d+1*t102*t103*t104*t118*t45*t49*t6
     1           6
              t232 = t109**2
              t233 = 1/t47**6.666666666666666d-1
              t234 = 1/t40**3
              t235 = -2*t234*t43
              t236 = 2*t106
              t237 = t236+t235
              t238 = t112**2
              t239 = 1/t48**6.666666666666666d-1
              t240 = 2*t234*t43
              t241 = -2*t106
              t242 = t241+t240
              t243 = 1.3333333333333333d+0*t113*t242+4.444444444444444d-
     1           1*t238*t239+1.3333333333333333d+0*t110*t237+4.444444444
     2           444444d-1*t232*t233
              t244 = -1.923661050931536d+0*t243*t44*t45
              t245 = 1.5389288407452287d+1*t114*t116*t44
              t246 = -1.5389288407452287d+1*t114*t118*t45
              t247 = 1/t40**6
              t248 = -3.8473221018630716d+1*t247*t44*t49
              t249 = 6.155715362980915d+1*t116*t118*t49
              t250 = t43**2
              t251 = -2.3083932611178434d+1*t250*t45*t49
              t252 = t251+t249+t248+t246+t245+t244
              t253 = -6.21814d-2*t252*t42*t58
              t254 = 5.495546528376875d-3*t120*t58*t92
              t255 = -3.663697685584583d-3*t206*t51*t58
              t256 = t251+t249+t248+t246+t245+t244+1.923661050931536d+0*
     1           t243
              t257 = 1.9751631321680768d-2*t256*t60*t64
              t258 = -9.087592854964233d-4*t123*t64*t92
              t259 = 6.058395236642822d-4*t206*t61*t64
              t260 = -5.980796863619711d-2*t243*t44*t45*t66*t69
              t261 = 5.082465978296986d-3*t114*t127*t44*t69
              t262 = 4.7846374908957684d-1*t114*t116*t44*t66*t69
              t263 = 1/t40**6.333333333333333d+0
              t264 = -2.3718174565385935d-2*t263*t44*t49*t69
              t265 = 2.0329863913187946d-2*t118*t127*t49*t69
              t266 = -1.1961593727239421d+0*t247*t44*t49*t66*t69
              t267 = 1.9138549963583074d+0*t116*t118*t49*t66*t69
              t268 = -7.176956236343652d-1*t250*t45*t49*t66*t69
              t269 = -2.0d+0*t34*t86*t87*t88-2.220446049250313d-16*t38*t
     1           79*t84*t85-6.101282288702853d-19*t37*t82-2.642079786267
     2           853d-3*t33*t82+t40*(-4.7846374908957684d-1*t114*t118*t4
     3           5*t66*t69+t268+t267+t266+t265+t264+t262+t261+t260+t259+
     4           t258+t257+t255+t254+t253+t231+t230+t229+t227+t226+t224+
     5           t223+t219+t217+t216+t214+t213+t209+t203+t202+t200+t199)
     6           -4.7846374908957684d-1*t118*t45*t49*t66*t69-1.196159372
     7           7239421d-1*t114*t44*t45*t66*t69+3.9503262643361536d-2*t
     8           123*t60*t64-1.243628d-1*t120*t42*t58+t195+t194+t193+t19
     9           2+t191+t190+t189-rhoa*t188
              t270 = 1/rhoa**7.333333333333333d+0
              t271 = 1/rhoa**4.666666666666667d+0
              t272 = 1/t22**3
              t273 = -4.728549416827732d-6*t135*t21*t270*t272-3.38280720
     1           50666663d-1*gammaaa*t23*t271+1.0486702335706666d-3*gamm
     2           aaa*t132*t21*t271+1.525338521557333d-3*t132*t135*t270
              t274 = 3.1d-3*t21*t23*t273+4.2369422222222203d-7*t135*t21*
     1           t24*t270*t272+3.0311111111111105d-2*gammaaa*t23*t24*t27
     2           1-9.396444444444442d-5*gammaaa*t132*t21*t24*t271-1.3667
     3           55555555555d-4*t132*t135*t24*t270-1.653333333333333d-2*
     4           gammaaa*t131*t133*t23+5.125333333333332d-5*gammaaa*t131
     5           *t132*t133*t21
              t275 = 1/rhoa**2
              t276 = gammaaa**3
              t277 = 1/t72**3
              t278 = 1/rhoa**10
              t279 = 1.3043825226666664d+0*gammaaa*t271*t73+6.8302212095
     1           99997d-3*t276*t277*t278-1.9209997151999994d-1*t135*t136
     2           *t270
              t280 = 5.866666666666666d-1*gammaaa*t271*t73*t74+3.0719999
     1           999999986d-3*t276*t277*t278*t74-8.639999999999998d-2*t1
     2           35*t136*t270*t74+6.0d-2*gammaaa*t20*t279*t73-3.19999999
     3           99999995d-1*gammaaa*t131*t138*t73+1.9199999999999995d-2
     4           *t135*t136*t137*t138
              t281 = 2.6666666666666666d+0*t113*t234*t43-2.6666666666666
     1           666d+0*t110*t234*t43+4.444444444444444d-1*t112*t156*t23
     2           9+4.444444444444444d-1*t109*t155*t233
              t282 = -1.923661050931536d+0*t281*t44*t45
              t283 = 7.694644203726144d+0*t116*t157*t44
              t284 = -7.694644203726144d+0*t118*t157*t45
              t285 = 7.694644203726144d+0*t114*t116*t44
              t286 = 7.694644203726144d+0*t114*t118*t45
              t287 = 2.3083932611178434d+1*t250*t45*t49
              t288 = t287+t286+t285+t284+t283+t282+t248
              t289 = t287+t286+t285+t284+t283+t282+1.923661050931536d+0*
     1           t281+t248
              t290 = 7.176956236343652d-1*t250*t45*t49*t66*t69
              t291 = t40*(-5.848223622634647d-1*t100*t162*t60*t98*t99-5.
     1           848223622634647d-1*t100*t123*t60*t98*t99+1.0d+0*t160*t4
     2           2*t94*t95*t96+1.0d+0*t120*t42*t94*t95*t96-4.54379642748
     3           21163d-4*t162*t64*t92-4.5437964274821163d-4*t123*t64*t9
     4           2+2.747773264188437d-3*t160*t58*t92+2.747773264188437d-
     5           3*t120*t58*t92-5.980796863619711d-2*t281*t44*t45*t66*t6
     6           9-2.3923187454478842d-1*t118*t157*t45*t66*t69+2.3923187
     7           454478842d-1*t114*t118*t45*t66*t69+2.3923187454478842d-
     8           1*t116*t157*t44*t66*t69+2.3923187454478842d-1*t114*t116
     9           *t44*t66*t69+2.541232989148493d-3*t127*t157*t44*t69+2.5
     :           41232989148493d-3*t114*t127*t44*t69+1.923661050931536d+
     ;           0*t102*t103*t104*t157*t44*t45*t66+1.923661050931536d+0*
     <           t102*t103*t104*t114*t44*t45*t66+1.9751631321680768d-2*t
     =           289*t60*t64-6.21814d-2*t288*t42*t58+t290+t266+t264+t259
     >           +t255+t230+t229+t227+t226+t223+t219+t217+t216+t213+t209
     ?           +t203+t202+t199)+t195+t194+t193+t192+t191+t190+t189+t16
     @           4+t163+t161+t126+t124+t121
              t292 = 3.813346303893333d-53*gammaaa*t131*t132*t152-1.1821
     1           373542069331d-55*gammaaa*t131*t152*t21*t272
              t293 = 3.1d-3*t21*t23*t292+1.0592355555555552d-56*gammaaa*
     1           t131*t152*t21*t24*t272-3.416888888888888d-54*gammaaa*t1
     2           31*t132*t152*t24-8.266666666666665d-3*gammaaa*t131*t166
     3           *t23-2.0666666666666667d-52*t133*t152*t23+2.56266666666
     4           6666d-5*gammaaa*t131*t132*t166*t21+6.406666666666666d-5
     5           5*t132*t133*t152*t21
              t294 = 1/t16**2
              t295 = t144**2
              t296 = 1/t15**4
              t297 = 1/t15**3
              t298 = 1/t7**5
              t299 = 1/rhob**2.3333333333333334d+0
              t300 = 1/rhob**2.1666666666666665d+0
              t301 = 1.1632736958443765d+0*t300+9.89141964955861d-1*t299
     1           +6.003214762495226d-1*t298+2.1077825841639536d-1*t152
              t302 = 1/t12**2
              t303 = t147**2
              t304 = 1/t11**4
              t305 = 1/t11**3
              t306 = 2.1622951122684114d+0*t300+1.7087761055320938d+0*t2
     1           99+1.2335503316757068d+0*t298+2.673190323653546d-1*t152
              t307 = 1.0d+0*t14*t146*t148*t306-2.0d+0*t14*t146*t303*t305
     1           +3.216395899738507d+1*t14*t302*t303*t304+1.110223024625
     2           1565d-16*t140*t145*t18*t301-4.0675215258019015d-19*t17*
     3           t299-1.7613865241785684d-3*t13*t299-2.220446049250313d-
     4           16*t140*t18*t295*t297+1.7854583920998188d-15*t18*t294*t
     5           295*t296-8.497974591333913d-2*t142*t146*t147*t148-9.812
     6           069668265515d-18*t140*t142*t144*t145
              t308 = 1/t2**3
              t309 = 1/rhob**7
              t310 = 1/rhob**5.333333333333333d+0
              t311 = 1/rhob**3.6666666666666664d+0
              t312 = 2.3716045866666666d-50*t3*t311-1.2806664767999998d-
     1           100*t150*t310+1.7075553024d-151*t308*t309
              t313 = 1.0666666666666666d-50*t3*t311*t4-5.76d-101*t150*t3
     1           10*t4+7.68d-152*t308*t309*t4+2.4d-51*t1*t3*t312-8.0d-51
     2           *t152*t153*t3+1.92d-101*t150*t151*t153
              t314 = 2.0d+0*t160*t42*t94*t95*t96
              t315 = -1.1696447245269295d+0*t100*t162*t60*t98*t99
              t316 = 3.847322101863072d+0*t102*t103*t104*t157*t44*t45*t6
     1           6
              t317 = -1.538928840745229d+1*t102*t103*t104*t118*t45*t49*t
     1           66
              t318 = t155**2
              t319 = t241+t235
              t320 = t156**2
              t321 = t240+t236
              t322 = 1.3333333333333333d+0*t113*t321+4.444444444444444d-
     1           1*t239*t320+1.3333333333333333d+0*t110*t319+4.444444444
     2           444444d-1*t233*t318
              t323 = -1.923661050931536d+0*t322*t44*t45
              t324 = 1.5389288407452287d+1*t116*t157*t44
              t325 = 1.5389288407452287d+1*t118*t157*t45
              t326 = -6.155715362980915d+1*t116*t118*t49
              t327 = t326+t325+t324+t323+t251+t248
              t328 = -6.21814d-2*t327*t42*t58
              t329 = 5.495546528376875d-3*t160*t58*t92
              t330 = t326+t325+t324+t323+1.923661050931536d+0*t322+t251+
     1           t248
              t331 = 1.9751631321680768d-2*t330*t60*t64
              t332 = -9.087592854964233d-4*t162*t64*t92
              t333 = -5.980796863619711d-2*t322*t44*t45*t66*t69
              t334 = 5.082465978296986d-3*t127*t157*t44*t69
              t335 = 4.7846374908957684d-1*t116*t157*t44*t66*t69
              t336 = -2.0329863913187946d-2*t118*t127*t49*t69
              t337 = -1.9138549963583074d+0*t116*t118*t49*t66*t69
              t338 = t40*(4.7846374908957684d-1*t118*t157*t45*t66*t69+t3
     1           37+t336+t335+t334+t333+t332+t331+t329+t328+t317+t316+t3
     2           15+t314+t268+t266+t264+t259+t255+t230+t229+t227+t226+t2
     3           23+t219+t217+t216+t213+t209+t203+t202+t199)+4.784637490
     4           8957684d-1*t118*t45*t49*t66*t69-1.1961593727239421d-1*t
     5           157*t44*t45*t66*t69+3.9503262643361536d-2*t162*t60*t64-
     6           1.243628d-1*t160*t42*t58-rhob*t307+t195+t194+t193+t192+
     7           t191+t190+t189-2.220446049250313d-16*t140*t144*t145*t18
     8           -6.101282288702853d-19*t142*t17-2.0d+0*t14*t146*t147*t1
     9           48-2.642079786267853d-3*t13*t142
              t339 = -6.150558554666666d-51*t23*t311+1.9066731519466665d
     1           -53*t132*t21*t311-2.9553433855173333d-105*t21*t272*t310
     2           +9.533365759733332d-103*t132*t310
              t340 = 3.1d-3*t21*t23*t339+5.51111111111111d-52*t23*t24*t3
     1           11-1.708444444444444d-54*t132*t21*t24*t311+2.6480888888
     2           888887d-106*t21*t24*t272*t310-8.542222222222222d-104*t1
     3           32*t24*t310-4.1333333333333333d-52*t152*t166*t23+1.2813
     4           333333333332d-54*t132*t152*t166*t21
              t341 = 1.7732060313103998d-6*gammaaa*t137*t21*t272+9.22583
     1           7832d-2*t131*t23-2.86000972792d-4*t131*t132*t21-5.72001
     2           945584d-4*gammaaa*t132*t137
              t342 = 3.1d-3*t21*t23*t341-1.5888533333333327d-7*gammaaa*t
     1           137*t21*t24*t272-8.266666666666665d-3*t131*t23*t24+2.56
     2           2666666666666d-5*t131*t132*t21*t24+5.125333333333332d-5
     3           *gammaaa*t132*t137*t24+3.1d-3*t133*t20*t23-8.2666666666
     4           66665d-3*gammaaa*t131*t168*t23-9.61d-6*t132*t133*t20*t2
     5           1+2.562666666666666d-5*gammaaa*t131*t132*t168*t21
              t343 = 1.25d-1*t39*t75
              t344 = 1/rhoa**9
              t345 = -3.557406879999999d-1*t131*t73-2.561332953599999d-3
     1           *t135*t277*t344+6.403332383999999d-2*gammaaa*t136*t137
              t346 = -1.5999999999999998d-1*t131*t73*t74-1.1519999999999
     1           996d-3*t135*t277*t344*t74+2.879999999999999d-2*gammaaa*
     2           t136*t137*t74+6.0d-2*gammaaa*t20*t345*t73+6.0d-2*t138*t
     3           20*t73-1.5999999999999998d-1*gammaaa*t131*t172*t73+9.59
     4           9999999999997d-3*t135*t136*t137*t172-3.6d-3*gammaaa*t13
     5           6*t138*t171
              t347 = 4.433015078276d-56*t152*t20*t21*t272-1.430004863959
     1           9997d-53*t132*t152*t20
              t348 = 3.1d-3*t21*t23*t347-3.972133333333333d-57*t152*t20*
     1           t21*t24*t272+1.2813333333333332d-54*t132*t152*t20*t24+3
     2           .1d-3*t166*t20*t23-2.0666666666666667d-52*t152*t168*t23
     3           -9.61d-6*t132*t166*t20*t21+6.406666666666666d-55*t132*t
     4           152*t168*t21
              t349 = 2.14500729594d-4*t132*t171-6.649522617413999d-7*t17
     1           1*t21*t272
              t350 = 3.1d-3*t21*t23*t349+5.9582d-8*t171*t21*t24*t272-1.9
     1           219999999999998d-5*t132*t171*t24+6.2d-3*t168*t20*t23-1.
     2           9219999999999998d-5*t132*t168*t20*t21
              t351 = 1/rhoa**8
              t352 = 9.604998575999998d-4*gammaaa*t277*t351-1.6008330959
     1           999997d-2*t136*t171
              t353 = 4.32d-4*gammaaa*t277*t351*t74-7.2d-3*t136*t171*t74+
     1           6.0d-2*gammaaa*t20*t352*t73+1.2d-1*t172*t20*t73-7.2d-3*
     2           gammaaa*t136*t171*t172
              t354 = t343-5.0d-1*rhoa*t173*t39*t78
              t355 = 1/taua**3
              t356 = 1/rhoa**11
              t357 = 1/rhoa**8.333333333333334d+0
              t358 = 1/rhoa**5.666666666666667d+0
              t359 = 1/t22**4
              t360 = t84**3
              t361 = 1/t27**7
              t362 = 1/rhoa**3.3333333333333337d+0
              t363 = 1/rhoa**3.1666666666666665d+0
              t364 = t87**3
              t365 = 1.6995949182667827d-1*t180*t86*t87*t88-1.2746961887
     1           00087d-1*t187*t82*t86*t88+1.0d+0*t34*(-4.68497274324822
     2           4d+0*t363-3.9871442462415524d+0*t362-3.083875829189267d
     3           +0*t361-7.128507529742789d-1*t131)*t86*t88-6.0d+0*t186*
     4           t187*t34*t86*t87+9.649187699215522d+1*t183*t185*t187*t3
     5           4*t87+2.549392377400174d-1*t184*t186*t82*t86+6.0d+0*t18
     6           5*t34*t364*t86+1.962413933653103d-17*t180*t79*t84*t85-1
     7           .4718104502398274d-17*t182*t79*t82*t85+1.11022302462515
     8           65d-16*(-2.520426340996149d+0*t363-2.3079979182303428d+
     9           0*t362-1.5008036906238065d+0*t361-5.620753557770543d-1*
     :           t131)*t38*t79*t85-6.661338147750939d-16*t178*t182*t38*t
     ;           79*t84+5.356375176299456d-15*t175*t177*t182*t38*t84+2.9
     <           43620900479655d-17*t176*t178*t79*t82-4.0999275947472624
     =           d+0*t183*t184*t185*t82-2.3669625486718335d-16*t175*t176
     >           *t177*t82+6.661338147750939d-16*t177*t360*t38*t79+5.742
     ?           741051503565d-14*t360*t38/(t35**6*t36**3)-1.07127503525
     @           98913d-14*t175*t360*t38/t35**5+9.490883560204437d-19*t3
     1           62*t37+2.0690405167709364d+3*t34*t364/(t31**6*t32**3)-1
     2           .9298375398431045d+2*t183*t34*t364/t31**5+4.10990188974
     3           99934d-3*t33*t362
              t366 = 4.824593849607761d+1*t196*t197*t198*t42*t51
              t367 = -6.0d+0*t196*t201*t42*t51*t96
              t368 = -2.6513779981040353d-1*t51*t92*t94*t95*t96
              t369 = 3.0d+0*t208*t42*t51*t95*t96
              t370 = -5.19476882440587d+1*t210*t211*t212*t60*t61
              t371 = 3.5089341735807883d+0*t100*t210*t215*t60*t61
              t372 = 8.072185179299687d-2*t100*t61*t92*t98*t99
              t373 = -1.7544670867903941d+0*t100*t218*t60*t61*t99
              t374 = 1.856176655010858d+2*t220*t221*t222*t44*t45*t49*t66
              t375 = -1.1541966305589217d+1*t104*t220*t225*t44*t45*t49*t
     1           66
              t376 = -4.904166819946466d-1*t102*t103*t104*t127*t44*t49
              t377 = 5.770983152794609d+0*t103*t104*t228*t44*t45*t49*t66
              t378 = -4.616786522235687d+1*t102*t103*t104*t116*t44*t49*t
     1           66
              t379 = -1.099109305675375d-2*t206*t51*t58
              t380 = 1.8175185709928465d-3*t206*t61*t64
              t381 = -7.11545236961578d-2*t263*t44*t49*t69
              t382 = -3.588478118171826d+0*t247*t44*t49*t66*t69
              t383 = -2.1530868709030954d+0*t250*t45*t49*t66*t69
              t384 = t94**3
              t385 = 5.172601291927341d+2*t384*t42*t51/(t56**6*t57**3)
              t386 = -9.649187699215522d+1*t198*t384*t42*t51/t56**5
              t387 = 4.824593849607761d+1*t197*t198*t208*t42*t51*t94
              t388 = -2.1319703304396778d+0*t196*t197*t198*t51*t92
              t389 = 6.0d+0*t197*t384*t42*t51*t96
              t390 = -6.0d+0*t201*t208*t42*t51*t94*t96
              t391 = 2.6513779981040353d-1*t196*t201*t51*t92*t96
              t392 = -1.3256889990520176d-1*t208*t51*t92*t95*t96
              t393 = 1.767585332069357d-1*t206*t51*t94*t95*t96
              t394 = 1/t40**3.6666666666666664d+0
              t395 = 1/t53**7
              t396 = 1/t40**3.3333333333333337d+0
              t397 = 1/t40**3.1666666666666665d+0
              t398 = 1.0d+0*(-2.520426340996149d+0*t397-2.30799791823034
     1           28d+0*t396-1.5008036906238065d+0*t395-5.620753557770543
     2           d-1*t394)*t42*t51*t95*t96
              t399 = t98**3
              t400 = -1.0254062650399592d+3*t399*t60*t61/(t62**6*t63**3)
              t401 = 1.0389537648811739d+2*t212*t399*t60*t61/t62**5
              t402 = -5.19476882440587d+1*t211*t212*t218*t60*t61*t98
              t403 = 1.1950391155803675d+0*t210*t211*t212*t61*t92
              t404 = -3.5089341735807883d+0*t100*t211*t399*t60*t61
              t405 = 3.5089341735807883d+0*t100*t215*t218*t60*t61*t98
              t406 = -8.072185179299687d-2*t100*t210*t215*t61*t92
              t407 = 4.0360925896498434d-2*t100*t218*t61*t92*t99
              t408 = -5.381456786199791d-2*t100*t206*t61*t98*t99
              t409 = -5.848223622634647d-1*t100*(-3.436688601932293d+0*t
     1           397-2.3308360066730832d+0*t396-8.064323383643707d-1*t39
     2           5-5.663741022599518d-1*t394)*t60*t61*t99
              t410 = t102**3
              t411 = 3.9801326549115085d+3*t410*t44*t45*t49*t66/(t67**6*
     1           t68**3)
              t412 = -3.712353310021716d+2*t222*t410*t44*t45*t49*t66/t67
     1           **5
              t413 = 1.856176655010858d+2*t102*t221*t222*t228*t44*t45*t4
     1           9*t66
              t414 = -7.424706620043432d+2*t116*t220*t221*t222*t44*t49*t
     1           66
              t415 = -7.886871025654724d+0*t127*t220*t221*t222*t44*t49
              t416 = 1.1541966305589217d+1*t104*t221*t410*t44*t45*t49*t6
     1           6
              t417 = -1.1541966305589217d+1*t102*t104*t225*t228*t44*t45*
     1           t49*t66
              t418 = 4.616786522235687d+1*t104*t116*t220*t225*t44*t49*t6
     1           6
              t419 = 4.904166819946466d-1*t104*t127*t220*t225*t44*t49
              t420 = -2.452083409973233d-1*t103*t104*t127*t228*t44*t49
              t421 = 2.2886111826416838d+0*t102*t103*t104*t263*t44*t49
              t422 = 1.923661050931536d+0*t103*t104*(-4.684972743248224d
     1           +0*t397-3.9871442462415524d+0*t396-3.083875829189267d+0
     2           *t395-7.128507529742789d-1*t394)*t44*t45*t49*t66
              t423 = -2.3083932611178434d+1*t103*t104*t116*t228*t44*t49*
     1           t66
              t424 = 1.1541966305589217d+2*t102*t103*t104*t247*t44*t49*t
     1           66
              t425 = 6.925179783353531d+1*t102*t103*t104*t250*t45*t49*t6
     1           6
              t426 = 8.548627933030694d-3*t396*t51*t58
              t427 = 1/t47**1.6666666666666669d+0
              t428 = 6*t43*t45
              t429 = -6*t234
              t430 = 1/t48**1.6666666666666669d+0
              t431 = -6*t43*t45
              t432 = 6*t234
              t433 = 1.3333333333333333d+0*t113*(t432+t431)-2.9629629629
     1           62963d-1*t112**3*t430+1.3333333333333333d+0*t110*(t429+
     2           t428)-2.962962962962963d-1*t109**3*t427+1.3333333333333
     3           333d+0*t112*t239*t242+1.3333333333333333d+0*t109*t233*t
     4           237
              t434 = -1.923661050931536d+0*t433*t44*t45
              t435 = 2.3083932611178434d+1*t116*t243*t44
              t436 = -2.3083932611178434d+1*t118*t243*t45
              t437 = -1.1541966305589216d+2*t114*t247*t44
              t438 = 1.8467146088942746d+2*t114*t116*t118
              t439 = -6.925179783353531d+1*t114*t250*t45
              t440 = 1/t40**7
              t441 = 2.3083932611178432d+2*t44*t440*t49
              t442 = -4.6167865222356863d+2*t118*t247*t49
              t443 = 2.770071913341412d+2*t116*t250*t49
              t444 = -4.616786522235687d+1*t43*t45*t49
              t445 = -1.4136255552166585d-3*t396*t61*t64
              t446 = 2.0103976536374746d-1*t44*t49*t69/t40**7.3333333333
     1           33333d+0
              t447 = 9.148438760934575d-2*t127*t250*t49*t69
              t448 = 7.176956236343652d+0*t44*t440*t49*t66*t69
              t449 = 8.612347483612381d+0*t116*t250*t49*t66*t69
              t450 = -1.4353912472687305d+0*t43*t45*t49*t66*t69
              t451 = 1/rhoa**3
              t452 = gammaaa**4
              t453 = 1/t72**4
              t454 = 1/rhoa**1.3666666666666666d+1
              t455 = -1.243628d-1*t288*t42*t58
              t456 = 3.9503262643361536d-2*t289*t60*t64
              t457 = -1.1961593727239421d-1*t281*t44*t45*t66*t69
              t458 = 2.0d+0*t288*t42*t94*t95*t96
              t459 = -1.1696447245269295d+0*t100*t289*t60*t98*t99
              t460 = 3.847322101863072d+0*t102*t103*t104*t281*t44*t45*t6
     1           6
              t461 = -2.3083932611178434d+1*t102*t103*t104*t250*t45*t49*
     1           t66
              t462 = 5.495546528376875d-3*t288*t58*t92
              t463 = 1.5389288407452287d+1*t116*t281*t44
              t464 = -1.5389288407452287d+1*t118*t281*t45
              t465 = 1.3333333333333333d+0*t113*(t431+2*t234)-2.96296296
     1           2962963d-1*t156*t238*t430+1.7777777777777776d+0*t112*t2
     2           34*t239*t43-1.7777777777777776d+0*t109*t233*t234*t43+1.
     3           3333333333333333d+0*t110*(t428-2*t234)-2.96296296296296
     4           3d-1*t155*t232*t427+4.444444444444444d-1*t156*t239*t242
     5           +4.444444444444444d-1*t155*t233*t237
              t466 = -1.923661050931536d+0*t44*t45*t465
              t467 = 7.694644203726144d+0*t116*t243*t44
              t468 = 7.694644203726144d+0*t118*t243*t45
              t469 = -3.8473221018630716d+1*t157*t247*t44
              t470 = 6.155715362980915d+1*t116*t118*t157
              t471 = -2.3083932611178434d+1*t157*t250*t45
              t472 = -7.694644203726143d+1*t114*t247*t44
              t473 = 4.616786522235687d+1*t114*t250*t45
              t474 = -1.5389288407452287d+2*t118*t247*t49
              t475 = -9.233573044471374d+1*t116*t250*t49
              t476 = 4.616786522235687d+1*t43*t45*t49
              t477 = -9.087592854964233d-4*t289*t64*t92
              t478 = 5.082465978296986d-3*t127*t281*t44*t69
              t479 = 4.7846374908957684d-1*t116*t281*t44*t66*t69
              t480 = -2.870782494537461d+0*t116*t250*t49*t66*t69
              t481 = 1.4353912472687305d+0*t43*t45*t49*t66*t69
              t482 = -8*t113*t43*t45+8*t110*t43*t45-2.962962962962963d-1
     1           *t112*t320*t430+1.7777777777777776d+0*t156*t234*t239*t4
     2           3-1.7777777777777776d+0*t155*t233*t234*t43-2.9629629629
     3           62963d-1*t109*t318*t427+4.444444444444444d-1*t112*t239*
     4           t321+4.444444444444444d-1*t109*t233*t319-2.666666666666
     5           6666d+0*t113*t234+2.6666666666666666d+0*t110*t234
              t483 = -1.923661050931536d+0*t44*t45*t482
              t484 = 1.5389288407452287d+1*t118*t281*t45
              t485 = 7.694644203726144d+0*t116*t322*t44
              t486 = -7.694644203726144d+0*t118*t322*t45
              t487 = -7.694644203726143d+1*t157*t247*t44
              t488 = 4.616786522235687d+1*t157*t250*t45
              t489 = -3.8473221018630716d+1*t114*t247*t44
              t490 = -6.155715362980915d+1*t114*t116*t118
              t491 = -2.3083932611178434d+1*t114*t250*t45
              t492 = 1.5389288407452287d+2*t118*t247*t49
              t493 = t144**3
              t494 = 1/t7**7
              t495 = 1/rhob**3.3333333333333337d+0
              t496 = 1/rhob**3.1666666666666665d+0
              t497 = t147**3
              t498 = 6.0d+0*t14*t146*t304*t497-1.9298375398431045d+2*t14
     1           *t302*t497/t11**5+2.0690405167709364d+3*t14*t497/(t11**
     2           6*t12**3)+1.1102230246251565d-16*t140*t145*t18*(-2.5204
     3           26340996149d+0*t496-2.3079979182303428d+0*t495-1.500803
     4           6906238065d+0*t494-5.620753557770543d-1*t311)+1.0d+0*t1
     5           4*t146*t148*(-4.684972743248224d+0*t496-3.9871442462415
     6           524d+0*t495-3.083875829189267d+0*t494-7.128507529742789
     7           d-1*t311)+9.490883560204437d-19*t17*t495+4.109901889749
     8           9934d-3*t13*t495+6.661338147750939d-16*t140*t18*t296*t4
     9           93-1.0712750352598913d-14*t18*t294*t493/t15**5+5.742741
     :           051503565d-14*t18*t493/(t15**6*t16**3)-6.0d+0*t14*t146*
     ;           t147*t305*t306+9.649187699215522d+1*t14*t147*t302*t304*
     <           t306-1.274696188700087d-1*t142*t146*t148*t306+2.5493923
     =           77400174d-1*t142*t146*t303*t305-4.0999275947472624d+0*t
     >           142*t302*t303*t304-6.661338147750939d-16*t140*t144*t18*
     ?           t297*t301+5.356375176299456d-15*t144*t18*t294*t296*t301
     @           -1.4718104502398274d-17*t140*t142*t145*t301+1.699594918
     1           2667827d-1*t146*t147*t148*t299+1.962413933653103d-17*t1
     2           40*t144*t145*t299+2.943620900479655d-17*t140*t142*t295*
     3           t297-2.3669625486718335d-16*t142*t294*t295*t296
              t499 = 1/t2**4
              t500 = 1/rhob**9.666666666666666d+0
              t501 = 1/rhob**8
              t502 = 1/rhob**6.333333333333333d+0
              t503 = 1/rhob**4.666666666666667d+0
              t504 = 1.3333333333333333d+0*t110*(t432+t428)+1.3333333333
     1           333333d+0*t113*(t431+t429)-2.962962962962963d-1*t156**3
     2           *t430-2.962962962962963d-1*t155**3*t427+1.3333333333333
     3           333d+0*t156*t239*t321+1.3333333333333333d+0*t155*t233*t
     4           319
              t505 = -1.923661050931536d+0*t44*t45*t504
              t506 = 2.3083932611178434d+1*t116*t322*t44
              t507 = 2.3083932611178434d+1*t118*t322*t45
              t508 = -1.1541966305589216d+2*t157*t247*t44
              t509 = -1.8467146088942746d+2*t116*t118*t157
              t510 = -6.925179783353531d+1*t157*t250*t45
              t511 = 4.6167865222356863d+2*t118*t247*t49
              t512 = t170-1.25d-1*gammaaa*t173*t39
              t513 = 1.25d-1*t75*t89
              t514 = 1.25d-1*t139*t39
              t515 = 1/rhoa**1.2666666666666665d+1
              t516 = 2.5d-1*t173*t39
              t517 = 1/rhoa**1.1666666666666665d+1
              t518 = 1/rhoa**1.0666666666666666d+1
              fnc(iq) = (5.0d-1*rhoa*t39*t75*t76*t78+1.0d+0*t25*t71+5.0d
     1           -1*rhob*t19*t5)*wght+fnc(iq)
              Amat(iq,D1_RA) = (t76*(5.0d-1*rhoa*t75*t78*t89+5.0d-1*t39*
     1           t75*t78+5.0d-1*rhoa*t139*t39*t78)+1.25d-1*gammaaa*t39*t
     2           75*t76*t77+1.0d+0*t134*t71+1.0d+0*t130*t25)*wght+Amat(i
     3           q,D1_RA)
              Amat(iq,D1_RB) = (1.0d+0*t167*t71+5.0d-1*t19*t5+5.0d-1*rho
     1           b*t149*t5+1.0d+0*t165*t25+5.0d-1*rhob*t154*t19)*wght+Am
     2           at(iq,D1_RB)
              Cmat(iq,D1_GAA) = (t76*(5.0d-1*rhoa*t173*t39*t78+t170)+1.0
     1           d+0*t169*t71)*wght+Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = (1.0d+0*rhoa*t39*t75*t76-5.0d-1*rhoa*t174
     1           *t39*t75*t78)*wght+Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (t76*(1.0d+0*t75*t78*t89+1.0d+0*rhoa*
     1           t139*t78*t89+1.25d-1*gammaaa*t75*t77*t89+5.0d-1*rhoa*t1
     2           88*t75*t78+5.0d-1*rhoa*t280*t39*t78+1.0d+0*t139*t39*t78
     3           +1.25d-1*gammaaa*t139*t39*t77+1.25d-1*gammaaa*t275*t39*
     4           t75)+t76*t77*(1.25d-1*gammaaa*t75*t89+1.25d-1*gammaaa*t
     5           139*t39)-1.25d-1*gammaaa*t275*t39*t75*t76+1.0d+0*t274*t
     6           71+1.0d+0*t25*t269+2.0d+0*t130*t134)*wght+Amat2(iq,D2_R
     7           A_RA)
              Amat2(iq,D2_RA_RB) = (1.0d+0*t293*t71+1.0d+0*t25*t291+1.0d
     1           +0*t130*t167+1.0d+0*t134*t165)*wght+Amat2(iq,D2_RA_RB)
              Amat2(iq,D2_RB_RB) = (1.0d+0*t340*t71+5.0d-1*rhob*t307*t5+
     1           1.0d+0*t149*t5+1.0d+0*t25*t338+5.0d-1*rhob*t19*t313+1.0
     2           d+0*t154*t19+2.0d+0*t165*t167+1.0d+0*rhob*t149*t154)*wg
     3           ht+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RA_GAA) = (t76*(5.0d-1*rhoa*t173*t78*t89-1.25d
     1           -1*t75*t89+5.0d-1*rhoa*t346*t39*t78+5.0d-1*t173*t39*t78
     2           -1.25d-1*t39*t75*t77-1.25d-1*t139*t39)+(1.25d-1*gammaaa
     3           *t173*t39+t343)*t76*t77+1.0d+0*t342*t71+1.0d+0*t130*t16
     4           9)*wght+Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_RB_GAA) = (1.0d+0*t348*t71+1.0d+0*t165*t169)*w
     1           ght+Cmat2(iq,D2_RB_GAA)
              Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
              Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GAA_GAA) = (t76*(5.0d-1*rhoa*t353*t39*t78-2.5d
     1           -1*t173*t39)+1.0d+0*t350*t71)*wght+Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
              Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RA_TA) = (t174*(-5.0d-1*rhoa*t75*t78*t89-5.0d-
     1           1*t39*t75*t78-5.0d-1*rhoa*t139*t39*t78)+t76*(1.0d+0*rho
     2           a*t75*t89+1.0d+0*t39*t75+1.0d+0*rhoa*t139*t39)-1.25d-1*
     3           gammaaa*t174*t39*t75*t77)*wght+Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GAA_TA) = (1.0d+0*rhoa*t173*t39*t76+t174*t354)
     1           *wght+Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = (1.0d+0*rhoa*t355*t39*t75*t78-2.0d+0*
     1           rhoa*t174*t39*t75)*wght+Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
              Amat3(iq,D3_RA_RA_RA) = (1.0d+0*t25*(t40*(8.07218517929968
     1           7d-2*t100*t123*t92*t98*t99-1.7544670867903941d+0*t100*t
     2           256*t60*t98*t99-1.7544670867903941d+0*t100*t123*t218*t6
     3           0*t99-2.6513779981040353d-1*t120*t92*t94*t95*t96+3.0d+0
     4           *t252*t42*t94*t95*t96+3.0d+0*t120*t208*t42*t95*t96-6.0d
     5           +0*t120*t196*t201*t42*t96-1.363138928244635d-3*t256*t64
     6           *t92+8.243319792565312d-3*t252*t58*t92-1.43539124726873
     7           05d+1*t118*t247*t49*t66*t69-5.980796863619711d-2*t433*t
     8           44*t45*t66*t69-2.1530868709030954d+0*t114*t250*t45*t66*
     9           t69-7.176956236343652d-1*t118*t243*t45*t66*t69-3.588478
     :           118171826d+0*t114*t247*t44*t66*t69+7.176956236343652d-1
     ;           *t116*t243*t44*t66*t69+5.741564989074922d+0*t114*t116*t
     <           118*t66*t69-2.8461809478463124d-1*t118*t263*t49*t69-7.1
     =           1545236961578d-2*t114*t263*t44*t69+7.623698967445479d-3
     >           *t127*t243*t44*t69+6.098959173956384d-2*t114*t118*t127*
     ?           t69+2.3083932611178434d+1*t103*t104*t118*t228*t45*t49*t
     @           66-4.616786522235687d+1*t104*t118*t220*t225*t45*t49*t66
     1           +7.424706620043432d+2*t118*t220*t221*t222*t45*t49*t66-1
     2           .8467146088942746d+2*t102*t103*t104*t116*t118*t49*t66+5
     3           .770983152794609d+0*t102*t103*t104*t243*t44*t45*t66+5.7
     4           70983152794609d+0*t103*t104*t114*t228*t44*t45*t66-1.154
     5           1966305589217d+1*t104*t114*t220*t225*t44*t45*t66+1.8561
     6           76655010858d+2*t114*t220*t221*t222*t44*t45*t66+4.616786
     7           522235687d+1*t102*t103*t104*t114*t118*t45*t66-4.6167865
     8           22235687d+1*t102*t103*t104*t114*t116*t44*t66+1.97516313
     9           21680768d-2*(t444+t443+t442+t441+t439+t438+t437+t436+t4
     :           35+t434+1.923661050931536d+0*t433)*t60*t64+1.8175185709
     ;           928465d-3*t123*t206*t64+3.5089341735807883d+0*t100*t123
     <           *t210*t215*t60-5.19476882440587d+1*t123*t210*t211*t212*
     =           t60-6.21814d-2*t42*(t444+t443+t442+t441+t439+t438+t437+
     >           t436+t435+t434)*t58-1.099109305675375d-2*t120*t206*t58-
     ?           1.9616667279785865d+0*t102*t103*t104*t118*t127*t49+t450
     @           +t449+t448+t447+t446+t445-4.904166819946466d-1*t102*t10
     1           3*t104*t114*t127*t44+t426+t425+t424+t423+t422+t421+t420
     2           +4.824593849607761d+1*t120*t196*t197*t198*t42+t419+t418
     3           +t417+t416+t415+t414+t413+t412+t411+t409+t408+t407+t406
     4           +t405+t404+t403+t402+t401+t400+t398+t393+t392+t391+t390
     5           +t389+t388+t387+t386+t385)-3.5089341735807883d+0*t100*t
     6           123*t60*t98*t99+6.0d+0*t120*t42*t94*t95*t96-2.726277856
     7           48927d-3*t123*t64*t92+1.6486639585130625d-2*t120*t58*t9
     8           2+2.549392377400174d-1*t82*t86*t87*t88-3.0d+0*t187*t34*
     9           t86*t88+6.0d+0*t184*t186*t34*t86+2.943620900479655d-17*
     :           t79*t82*t84*t85-3.3306690738754696d-16*t182*t38*t79*t85
     ;           +6.661338147750939d-16*t176*t178*t38*t79+5.741564989074
     <           922d+0*t116*t118*t49*t66*t69-1.794239059085913d-1*t243*
     =           t44*t45*t66*t69-1.4353912472687305d+0*t114*t118*t45*t66
     >           *t69+1.4353912472687305d+0*t114*t116*t44*t66*t69+6.0989
     ?           59173956384d-2*t118*t127*t49*t69+1.524739793489096d-2*t
     @           114*t127*t44*t69+4.616786522235687d+1*t102*t103*t104*t1
     1           18*t45*t49*t66+1.1541966305589217d+1*t102*t103*t104*t11
     2           4*t44*t45*t66+5.92548939650423d-2*t256*t60*t64-1.865442
     3           d-1*t252*t42*t58+t383+t382+t381+t380-5.356375176299456d
     4           -15*t175*t176*t177*t38+t379+t378+t377+t376+t375+t374+t3
     5           73+t372+t371+t370+1.2202564577405706d-18*t180*t37+t369+
     6           t368+t367+t366-rhoa*t365-9.649187699215522d+1*t183*t184
     7           *t185*t34+5.284159572535705d-3*t180*t33)+t76*(1.5d+0*rh
     8           oa*t280*t78*t89+3.0d+0*t139*t78*t89+5.0d-1*gammaaa*t139
     9           *t77*t89+2.5d-1*gammaaa*t275*t75*t89+5.0d-1*rhoa*t365*t
     :           75*t78+1.5d+0*t188*t75*t78+5.0d-1*rhoa*t39*(-2.73777777
     ;           7777778d+0*gammaaa*t358*t73*t74+1.4745599999999992d-3*t
     <           452*t453*t454*t74+7.274666666666665d-1*t135*t136*t357*t
     =           74-5.836799999999998d-2*t276*t277*t356*t74+6.0d-2*gamma
     >           aa*t20*t73*(-6.08711843911111d+0*gammaaa*t358*t73+3.278
     ?           5061806079985d-3*t452*t453*t454+1.617434328106666d+0*t1
     @           35*t136*t357-1.2977420298239994d-1*t276*t277*t356)-4.79
     1           9999999999999d-1*gammaaa*t131*t279*t73+1.76d+0*gammaaa*
     2           t138*t271*t73+2.879999999999999d-2*t135*t136*t137*t279+
     3           9.215999999999996d-3*t138*t276*t277*t278-2.591999999999
     4           9993d-1*t135*t136*t138*t270)*t78+1.5d+0*t280*t39*t78+1.
     5           5d+0*rhoa*t139*t188*t78+2.5d-1*gammaaa*t188*t75*t77+2.5
     6           d-1*gammaaa*t280*t39*t77-2.5d-1*gammaaa*t39*t451*t75+2.
     7           5d-1*gammaaa*t139*t275*t39)+t275*t76*(-2.5d-1*gammaaa*t
     8           75*t89-2.5d-1*gammaaa*t139*t39)+t76*t77*(2.5d-1*gammaaa
     9           *t139*t89+1.25d-1*gammaaa*t188*t75+1.25d-1*gammaaa*t280
     :           *t39)+2.5d-1*gammaaa*t39*t451*t75*t76+1.0d+0*(3.1d-3*t2
     ;           1*t23*(-1.1726802553732772d-7*t21*t276*t356*t359+1.5786
     <           433623644444d+0*gammaaa*t23*t358-4.8937944233297775d-3*
     =           gammaaa*t132*t21*t358+5.201404358510505d-5*t135*t21*t27
     >           2*t357-1.6778723737130663d-2*t132*t135*t357+3.782839533
     ?           4621856d-5*t272*t276*t356)+1.0507616711111105d-8*t21*t2
     @           4*t276*t356*t359-1.4145185185185183d-1*gammaaa*t23*t24*
     1           t358+4.3850074074074064d-4*gammaaa*t132*t21*t24*t358-4.
     2           6606364444444426d-6*t135*t21*t24*t272*t357+1.5034311111
     3           111107d-3*t132*t135*t24*t357-3.389553777777776d-6*t24*t
     4           272*t276*t356-2.4799999999999994d-2*gammaaa*t131*t23*t2
     5           73+7.687999999999998d-5*gammaaa*t131*t132*t21*t273+1.27
     6           1082666666666d-6*t133*t135*t21*t270*t272+9.093333333333
     7           331d-2*gammaaa*t133*t23*t271-2.818933333333332d-4*gamma
     8           aa*t132*t133*t21*t271-4.100266666666665d-4*t132*t133*t1
     9           35*t270)*t71+3.0d+0*t130*t274+3.0d+0*t134*t269)*wght+Am
     :           at3(iq,D3_RA_RA_RA)
              Amat3(iq,D3_RA_RA_RB) = (1.0d+0*t25*(t40*(2.69072839309989
     1           6d-2*t100*t162*t92*t98*t99+5.381456786199792d-2*t100*t1
     2           23*t92*t98*t99-5.848223622634647d-1*t100*t256*t60*t98*t
     3           99-5.848223622634647d-1*t100*t162*t218*t60*t99-1.169644
     4           7245269295d+0*t100*t123*t218*t60*t99-8.837926660346784d
     5           -2*t160*t92*t94*t95*t96-1.767585332069357d-1*t120*t92*t
     6           94*t95*t96+1.0d+0*t252*t42*t94*t95*t96+1.0d+0*t160*t208
     7           *t42*t95*t96+2.0d+0*t120*t208*t42*t95*t96-2.0d+0*t160*t
     8           196*t201*t42*t96-4.0d+0*t120*t196*t201*t42*t96-4.543796
     9           4274821163d-4*t256*t64*t92+2.747773264188437d-3*t252*t5
     :           8*t92-4.7846374908957684d+0*t118*t247*t49*t66*t69-5.980
     ;           796863619711d-2*t44*t45*t465*t66*t69-4.7846374908957684
     <           d-1*t118*t281*t45*t66*t69-7.176956236343652d-1*t157*t25
     =           0*t45*t66*t69+1.4353912472687305d+0*t114*t250*t45*t66*t
     >           69+2.3923187454478842d-1*t118*t243*t45*t66*t69-1.196159
     ?           3727239421d+0*t157*t247*t44*t66*t69-2.3923187454478842d
     @           +0*t114*t247*t44*t66*t69+2.3923187454478842d-1*t116*t24
     1           3*t44*t66*t69+1.9138549963583074d+0*t116*t118*t157*t66*
     2           t69-9.487269826154375d-2*t118*t263*t49*t69-3.0494795869
     3           78192d-2*t127*t250*t49*t69-2.3718174565385935d-2*t157*t
     4           263*t44*t69-4.743634913077187d-2*t114*t263*t44*t69+2.54
     5           1232989148493d-3*t127*t243*t44*t69+2.0329863913187946d-
     6           2*t118*t127*t157*t69+7.694644203726144d+0*t103*t104*t11
     7           8*t228*t45*t49*t66-1.538928840745229d+1*t104*t118*t220*
     8           t225*t45*t49*t66+2.4749022066811444d+2*t118*t220*t221*t
     9           222*t45*t49*t66-6.155715362980916d+1*t102*t103*t104*t11
     :           6*t118*t49*t66+1.923661050931536d+0*t102*t103*t104*t243
     ;           *t44*t45*t66+1.923661050931536d+0*t103*t104*t157*t228*t
     <           44*t45*t66+3.847322101863072d+0*t103*t104*t114*t228*t44
     =           *t45*t66-3.847322101863072d+0*t104*t157*t220*t225*t44*t
     >           45*t66-7.694644203726144d+0*t104*t114*t220*t225*t44*t45
     ?           *t66+6.187255516702861d+1*t157*t220*t221*t222*t44*t45*t
     @           66+1.2374511033405722d+2*t114*t220*t221*t222*t44*t45*t6
     1           6+1.538928840745229d+1*t102*t103*t104*t118*t157*t45*t66
     2           -1.538928840745229d+1*t102*t103*t104*t116*t157*t44*t66-
     3           3.077857681490458d+1*t102*t103*t104*t114*t116*t44*t66+1
     4           .9751631321680768d-2*(t476+t475+t474+t473+t472+t471+t47
     5           0+t469+t468+t467+t466+1.923661050931536d+0*t465+t464+t4
     6           63+t441)*t60*t64+6.058395236642822d-4*t162*t206*t64+1.2
     7           116790473285642d-3*t123*t206*t64+1.1696447245269295d+0*
     8           t100*t162*t210*t215*t60+2.339289449053859d+0*t100*t123*
     9           t210*t215*t60-1.73158960813529d+1*t162*t210*t211*t212*t
     :           60-3.46317921627058d+1*t123*t210*t211*t212*t60-6.21814d
     ;           -2*t42*(t476+t475+t474+t473+t472+t471+t470+t469+t468+t4
     <           67+t466+t464+t463+t441)*t58-3.663697685584583d-3*t160*t
     =           206*t58-7.327395371169166d-3*t120*t206*t58-6.5388890932
     >           61956d-1*t102*t103*t104*t118*t127*t49+t481+t480+t479+t4
     ?           78+t477+t462+t461+t460+t459+t458+t448+t446+t445-1.63472
     @           22733154887d-1*t102*t103*t104*t127*t157*t44-3.269444546
     1           6309774d-1*t102*t103*t104*t114*t127*t44+t426+t424+t423+
     2           t422+t421+t420+1.6081979498692536d+1*t160*t196*t197*t19
     3           8*t42+3.216395899738507d+1*t120*t196*t197*t198*t42+t419
     4           +t418+t417+t416+t415+t414+t413+t412+t411+t409+t408+t407
     5           +t406+t405+t404+t403+t402+t401+t400+t398+t393+t392+t391
     6           +t390+t389+t388+t387+t386+t385)-2.339289449053859d+0*t1
     7           00*t123*t60*t98*t99+4.0d+0*t120*t42*t94*t95*t96-1.81751
     8           85709928465d-3*t123*t64*t92+1.099109305675375d-2*t120*t
     9           58*t92-4.7846374908957684d-1*t118*t157*t45*t66*t69+9.56
     :           9274981791537d-1*t114*t116*t44*t66*t69+1.01649319565939
     ;           73d-2*t114*t127*t44*t69+7.694644203726144d+0*t102*t103*
     <           t104*t114*t44*t45*t66+t457+t456+t455+t382+t381+t380+t37
     =           9+t378+t377+t376+t375+t374+t373+t372+t371+t370+t369+t36
     >           8+t367+t366+t335+t334+t332+t329+t316+t315+t314+t290+t26
     ?           7+t265+t260+t257+t253+t231)+1.0d+0*(3.1d-3*t21*t23*(-2.
     @           931700638433194d-57*t135*t152*t21*t270*t359+4.334503632
     1           092088d-55*gammaaa*t152*t21*t271*t272+9.457098833655464
     2           d-55*t135*t152*t270*t272-1.398226978094222d-52*gammaaa*
     3           t132*t152*t271)+2.6269041777777763d-58*t135*t152*t21*t2
     4           4*t270*t359-1.653333333333333d-2*gammaaa*t131*t23*t292+
     5           5.125333333333332d-5*gammaaa*t131*t132*t21*t292-2.06666
     6           66666666667d-52*t152*t23*t273+6.406666666666666d-55*t13
     7           2*t152*t21*t273-3.883863703703702d-56*gammaaa*t152*t21*
     8           t24*t271*t272-8.473884444444441d-56*t135*t152*t24*t270*
     9           t272+4.2369422222222203d-7*t135*t166*t21*t270*t272+2.11
     :           84711111111104d-56*gammaaa*t131*t133*t152*t21*t272+1.25
     ;           28592592592588d-53*gammaaa*t132*t152*t24*t271+3.0311111
     <           111111105d-2*gammaaa*t166*t23*t271-9.396444444444442d-5
     =           *gammaaa*t132*t166*t21*t271-1.366755555555555d-4*t132*t
     >           135*t166*t270-6.833777777777776d-54*gammaaa*t131*t132*t
     ?           133*t152)*t71+2.0d+0*t130*t293+2.0d+0*t134*t291+1.0d+0*
     @           t165*t274+1.0d+0*t167*t269)*wght+Amat3(iq,D3_RA_RA_RB)
              Amat3(iq,D3_RA_RB_RB) = (1.0d+0*t25*(t40*(5.38145678619979
     1           2d-2*t100*t162*t92*t98*t99+2.690728393099896d-2*t100*t1
     2           23*t92*t98*t99-5.848223622634647d-1*t100*t330*t60*t98*t
     3           99-1.1696447245269295d+0*t100*t162*t218*t60*t99-5.84822
     4           3622634647d-1*t100*t123*t218*t60*t99-1.767585332069357d
     5           -1*t160*t92*t94*t95*t96-8.837926660346784d-2*t120*t92*t
     6           94*t95*t96+1.0d+0*t327*t42*t94*t95*t96+2.0d+0*t160*t208
     7           *t42*t95*t96+1.0d+0*t120*t208*t42*t95*t96-4.0d+0*t160*t
     8           196*t201*t42*t96-2.0d+0*t120*t196*t201*t42*t96-4.543796
     9           4274821163d-4*t330*t64*t92+2.747773264188437d-3*t327*t5
     :           8*t92+4.7846374908957684d+0*t118*t247*t49*t66*t69-5.980
     ;           796863619711d-2*t44*t45*t482*t66*t69-2.3923187454478842
     <           d-1*t118*t322*t45*t66*t69+4.7846374908957684d-1*t118*t2
     =           81*t45*t66*t69+1.4353912472687305d+0*t157*t250*t45*t66*
     >           t69-7.176956236343652d-1*t114*t250*t45*t66*t69+2.392318
     ?           7454478842d-1*t116*t322*t44*t66*t69-2.3923187454478842d
     @           +0*t157*t247*t44*t66*t69-1.1961593727239421d+0*t114*t24
     1           7*t44*t66*t69-1.9138549963583074d+0*t114*t116*t118*t66*
     2           t69+9.487269826154374d-2*t118*t263*t49*t69-3.0494795869
     3           781915d-2*t127*t250*t49*t69+2.541232989148493d-3*t127*t
     4           322*t44*t69-4.743634913077187d-2*t157*t263*t44*t69-2.37
     5           18174565385935d-2*t114*t263*t44*t69-2.0329863913187946d
     6           -2*t114*t118*t127*t69-7.694644203726144d+0*t103*t104*t1
     7           18*t228*t45*t49*t66+1.538928840745229d+1*t104*t118*t220
     8           *t225*t45*t49*t66-2.4749022066811444d+2*t118*t220*t221*
     9           t222*t45*t49*t66+6.155715362980916d+1*t102*t103*t104*t1
     :           16*t118*t49*t66+1.923661050931536d+0*t102*t103*t104*t32
     ;           2*t44*t45*t66+3.847322101863072d+0*t103*t104*t157*t228*
     <           t44*t45*t66+1.923661050931536d+0*t103*t104*t114*t228*t4
     =           4*t45*t66-7.694644203726144d+0*t104*t157*t220*t225*t44*
     >           t45*t66-3.847322101863072d+0*t104*t114*t220*t225*t44*t4
     ?           5*t66+1.2374511033405722d+2*t157*t220*t221*t222*t44*t45
     @           *t66+6.187255516702861d+1*t114*t220*t221*t222*t44*t45*t
     1           66-1.538928840745229d+1*t102*t103*t104*t114*t118*t45*t6
     2           6-3.077857681490458d+1*t102*t103*t104*t116*t157*t44*t66
     3           -1.538928840745229d+1*t102*t103*t104*t114*t116*t44*t66+
     4           1.9751631321680768d-2*(t492+t491+t490+t489+t488+t487+t4
     5           86+t485+t484+t483+1.923661050931536d+0*t482+t475+t463+t
     6           444+t441)*t60*t64+1.2116790473285642d-3*t162*t206*t64+6
     7           .058395236642822d-4*t123*t206*t64+2.339289449053859d+0*
     8           t100*t162*t210*t215*t60+1.1696447245269295d+0*t100*t123
     9           *t210*t215*t60-3.46317921627058d+1*t162*t210*t211*t212*
     :           t60-1.73158960813529d+1*t123*t210*t211*t212*t60-6.21814
     ;           d-2*t42*(t492+t491+t490+t489+t488+t487+t486+t485+t484+t
     <           483+t475+t463+t444+t441)*t58-7.327395371169166d-3*t160*
     =           t206*t58-3.663697685584583d-3*t120*t206*t58+6.538889093
     >           261955d-1*t102*t103*t104*t118*t127*t49+t480+t479+t478+t
     ?           477+t462+t461+t460+t459+t458+t450+t448+t446+t445-3.2694
     @           445466309774d-1*t102*t103*t104*t127*t157*t44-1.63472227
     1           33154887d-1*t102*t103*t104*t114*t127*t44+t426+t424+t423
     2           +t422+t421+t420+3.216395899738507d+1*t160*t196*t197*t19
     3           8*t42+1.6081979498692536d+1*t120*t196*t197*t198*t42+t41
     4           9+t418+t417+t416+t415+t414+t413+t412+t411+t409+t408+t40
     5           7+t406+t405+t404+t403+t402+t401+t400+t398+t393+t392+t39
     6           1+t390+t389+t388+t387+t386+t385)-2.339289449053859d+0*t
     7           100*t162*t60*t98*t99+4.0d+0*t160*t42*t94*t95*t96-1.8175
     8           185709928465d-3*t162*t64*t92+1.099109305675375d-2*t160*
     9           t58*t92+4.7846374908957684d-1*t114*t118*t45*t66*t69+9.5
     :           69274981791537d-1*t116*t157*t44*t66*t69+1.0164931956593
     ;           973d-2*t127*t157*t44*t69+7.694644203726144d+0*t102*t103
     <           *t104*t157*t44*t45*t66+t457+t456+t455+t382+t381+t380+t3
     =           79+t378+t377+t376+t375+t374+t373+t372+t371+t370+t369+t3
     >           68+t367+t366+t337+t336+t333+t331+t328+t317+t290+t262+t2
     ?           61+t258+t254+t224+t214+t200)+1.0d+0*(3.1d-3*t21*t23*(-7
     @           .329251596082985d-107*gammaaa*t131*t21*t310*t359+3.1523
     1           662778851547d-55*gammaaa*t131*t21*t272*t311-1.016892347
     2           7048887d-52*gammaaa*t131*t132*t311+2.3642747084138666d-
     3           104*gammaaa*t131*t272*t310)+6.567260444444443d-108*gamm
     4           aaa*t131*t21*t24*t310*t359-8.266666666666665d-3*gammaaa
     5           *t131*t23*t339+2.562666666666666d-5*gammaaa*t131*t132*t
     6           21*t339-2.824628148148147d-56*gammaaa*t131*t21*t24*t272
     7           *t311+9.111703703703702d-54*gammaaa*t131*t132*t24*t311+
     8           5.51111111111111d-52*t133*t23*t311-1.708444444444444d-5
     9           4*t132*t133*t21*t311-2.1184711111111104d-105*gammaaa*t1
     :           31*t24*t272*t310+2.6480888888888887d-106*t133*t21*t272*
     ;           t310-8.542222222222222d-104*t132*t133*t310-4.1333333333
     <           333333d-52*t152*t23*t292+1.2813333333333332d-54*t132*t1
     =           52*t21*t292+2.1184711111111104d-56*gammaaa*t131*t152*t1
     >           66*t21*t272-6.833777777777776d-54*gammaaa*t131*t132*t15
     ?           2*t166)*t71+1.0d+0*t130*t340+1.0d+0*t134*t338+2.0d+0*t1
     @           65*t293+2.0d+0*t167*t291)*wght+Amat3(iq,D3_RA_RB_RB)
              Amat3(iq,D3_RB_RB_RB) = (1.0d+0*t25*(t40*(8.07218517929968
     1           7d-2*t100*t162*t92*t98*t99-1.7544670867903941d+0*t100*t
     2           330*t60*t98*t99-1.7544670867903941d+0*t100*t162*t218*t6
     3           0*t99-2.6513779981040353d-1*t160*t92*t94*t95*t96+3.0d+0
     4           *t327*t42*t94*t95*t96+3.0d+0*t160*t208*t42*t95*t96-6.0d
     5           +0*t160*t196*t201*t42*t96-1.363138928244635d-3*t330*t64
     6           *t92+8.243319792565312d-3*t327*t58*t92-5.98079686361971
     7           1d-2*t44*t45*t504*t66*t69+1.4353912472687305d+1*t118*t2
     8           47*t49*t66*t69+7.176956236343652d-1*t118*t322*t45*t66*t
     9           69-2.1530868709030954d+0*t157*t250*t45*t66*t69+7.176956
     :           236343652d-1*t116*t322*t44*t66*t69-3.588478118171826d+0
     ;           *t157*t247*t44*t66*t69-5.741564989074922d+0*t116*t118*t
     <           157*t66*t69+2.8461809478463124d-1*t118*t263*t49*t69+7.6
     =           23698967445479d-3*t127*t322*t44*t69-7.11545236961578d-2
     >           *t157*t263*t44*t69-6.098959173956384d-2*t118*t127*t157*
     ?           t69-2.3083932611178434d+1*t103*t104*t118*t228*t45*t49*t
     @           66+4.616786522235687d+1*t104*t118*t220*t225*t45*t49*t66
     1           -7.424706620043432d+2*t118*t220*t221*t222*t45*t49*t66+1
     2           .8467146088942746d+2*t102*t103*t104*t116*t118*t49*t66+5
     3           .770983152794609d+0*t102*t103*t104*t322*t44*t45*t66+5.7
     4           70983152794609d+0*t103*t104*t157*t228*t44*t45*t66-1.154
     5           1966305589217d+1*t104*t157*t220*t225*t44*t45*t66+1.8561
     6           76655010858d+2*t157*t220*t221*t222*t44*t45*t66-4.616786
     7           522235687d+1*t102*t103*t104*t118*t157*t45*t66-4.6167865
     8           22235687d+1*t102*t103*t104*t116*t157*t44*t66+1.97516313
     9           21680768d-2*(t511+t510+t509+t508+t507+t506+t505+1.92366
     :           1050931536d+0*t504+t476+t443+t441)*t60*t64+1.8175185709
     ;           928465d-3*t162*t206*t64+3.5089341735807883d+0*t100*t162
     <           *t210*t215*t60-5.19476882440587d+1*t162*t210*t211*t212*
     =           t60-6.21814d-2*t42*(t511+t510+t509+t508+t507+t506+t505+
     >           t476+t443+t441)*t58-1.099109305675375d-2*t160*t206*t58+
     ?           1.9616667279785865d+0*t102*t103*t104*t118*t127*t49+t481
     @           +t449+t448+t447+t446+t445-4.904166819946466d-1*t102*t10
     1           3*t104*t127*t157*t44+t426+t425+t424+t423+t422+t421+t420
     2           +4.824593849607761d+1*t160*t196*t197*t198*t42+t419+t418
     3           +t417+t416+t415+t414+t413+t412+t411+t409+t408+t407+t406
     4           +t405+t404+t403+t402+t401+t400+t398+t393+t392+t391+t390
     5           +t389+t388+t387+t386+t385)-3.5089341735807883d+0*t100*t
     6           162*t60*t98*t99+6.0d+0*t160*t42*t94*t95*t96-2.726277856
     7           48927d-3*t162*t64*t92+1.6486639585130625d-2*t160*t58*t9
     8           2-5.741564989074922d+0*t116*t118*t49*t66*t69-1.79423905
     9           9085913d-1*t322*t44*t45*t66*t69+1.4353912472687305d+0*t
     :           118*t157*t45*t66*t69+1.4353912472687305d+0*t116*t157*t4
     ;           4*t66*t69-6.098959173956384d-2*t118*t127*t49*t69+1.5247
     <           39793489096d-2*t127*t157*t44*t69-4.616786522235687d+1*t
     =           102*t103*t104*t118*t45*t49*t66+1.1541966305589217d+1*t1
     >           02*t103*t104*t157*t44*t45*t66+5.92548939650423d-2*t330*
     ?           t60*t64-1.865442d-1*t327*t42*t58-rhob*t498+t383+t382+t3
     @           81+t380+t379+t378+t377+t376+t375+t374+t373+t372+t371+t3
     1           70+t369+t368+t367+t366-3.0d+0*t14*t146*t148*t306+6.0d+0
     2           *t14*t146*t303*t305-9.649187699215522d+1*t14*t302*t303*
     3           t304-3.3306690738754696d-16*t140*t145*t18*t301+1.220256
     4           4577405706d-18*t17*t299+5.284159572535705d-3*t13*t299+6
     5           .661338147750939d-16*t140*t18*t295*t297-5.3563751762994
     6           56d-15*t18*t294*t295*t296+2.549392377400174d-1*t142*t14
     7           6*t147*t148+2.943620900479655d-17*t140*t142*t144*t145)+
     8           1.0d+0*(3.1d-3*t21*t23*(2.2552048033777775d-50*t23*t503
     9           -6.991134890471111d-53*t132*t21*t503+2.3642747084138666
     :           d-104*t21*t272*t502-7.626692607786666d-102*t132*t502-1.
     ;           8323128990207463d-156*t21*t359*t501+5.910686771034666d-
     <           154*t272*t501)-2.0207407407407404d-51*t23*t24*t503+6.26
     =           4296296296294d-54*t132*t21*t24*t503-2.118471111111111d-
     >           105*t21*t24*t272*t502+6.833777777777776d-103*t132*t24*t
     ?           502+1.641815111111111d-157*t21*t24*t359*t501-5.29617777
     @           7777777d-155*t24*t272*t501-6.2d-52*t152*t23*t339+1.9219
     1           999999999998d-54*t132*t152*t21*t339+1.6533333333333333d
     2           -51*t166*t23*t311-5.125333333333332d-54*t132*t166*t21*t
     3           311+7.944266666666666d-106*t166*t21*t272*t310-2.5626666
     4           666666664d-103*t132*t166*t310)*t71+5.0d-1*rhob*t19*(2.4
     5           d-51*t1*t3*(-8.695883484444443d-50*t3*t503+7.7788630442
     6           66666d-100*t150*t502-2.2198218931199998d-150*t308*t501+
     7           2.04906636288d-201*t499*t500)-3.911111111111111d-50*t3*
     8           t4*t503+3.4986666666666666d-100*t150*t4*t502-9.98400000
     9           0000001d-151*t308*t4*t501+9.216000000000001d-202*t4*t49
     :           9*t500-1.2d-50*t152*t3*t312+2.88d-101*t150*t151*t312+3.
     ;           2d-50*t153*t3*t311-1.7279999999999998d-100*t150*t153*t3
     <           10+2.3040000000000002d-151*t153*t308*t309)+5.0d-1*rhob*
     =           t498*t5+1.5d+0*t307*t5+3.0d+0*t165*t340+3.0d+0*t167*t33
     >           8+1.5d+0*t19*t313+1.5d+0*rhob*t149*t313+1.5d+0*rhob*t15
     ?           4*t307+3.0d+0*t149*t154)*wght+Amat3(iq,D3_RB_RB_RB)
              Cmat3(iq,D3_RA_RA_GAA) = (t76*(1.0d+0*rhoa*t346*t78*t89+1.
     1           0d+0*t173*t78*t89-1.25d-1*t75*t77*t89+1.25d-1*gammaaa*t
     2           173*t77*t89-2.5d-1*t139*t89+5.0d-1*rhoa*t39*(5.86666666
     3           6666666d-1*t271*t73*t74-5.529599999999998d-4*t276*t453*
     4           t515*t74+1.9583999999999993d-2*t135*t277*t278*t74-2.079
     5           9999999999996d-1*gammaaa*t136*t270*t74+6.0d-2*gammaaa*t
     6           20*t73*(1.3043825226666664d+0*t271*t73-1.22943981772799
     7           94d-3*t276*t453*t515+4.3542660211199985d-2*t135*t277*t2
     8           78-4.624628943999999d-1*gammaaa*t136*t270)-3.1999999999
     9           999995d-1*gammaaa*t131*t345*t73+6.0d-2*t20*t279*t73+5.8
     :           66666666666666d-1*gammaaa*t172*t271*t73-3.1999999999999
     ;           995d-1*t131*t138*t73+1.9199999999999995d-2*t135*t136*t1
     <           37*t345-2.303999999999999d-3*t135*t138*t277*t344-3.6d-3
     =           *gammaaa*t136*t171*t279+3.0719999999999986d-3*t172*t276
     >           *t277*t278-8.639999999999998d-2*t135*t136*t172*t270+5.7
     ?           59999999999998d-2*gammaaa*t136*t137*t138)*t78+1.0d+0*t3
     @           46*t39*t78+5.0d-1*rhoa*t173*t188*t78+1.25d-1*gammaaa*t3
     1           46*t39*t77-1.25d-1*t139*t39*t77+1.25d-1*t275*t39*t75-1.
     2           25d-1*t188*t75-1.25d-1*t280*t39+1.25d-1*gammaaa*t173*t2
     3           75*t39)+t76*t77*(1.25d-1*gammaaa*t173*t89+t514+t513+1.2
     4           5d-1*gammaaa*t346*t39)+t275*t512*t76+1.0d+0*(3.1d-3*t21
     5           *t23*(4.3975509576497906d-8*t135*t21*t278*t359-1.418564
     6           8250483196d-5*t135*t272*t278-1.5958854281793597d-5*gamm
     7           aaa*t21*t270*t272-3.3828072050666663d-1*t23*t271+1.0486
     8           702335706666d-3*t132*t21*t271+5.148017510255999d-3*gamm
     9           aaa*t132*t270)-3.9403562666666647d-9*t135*t21*t24*t278*
     :           t359-1.653333333333333d-2*gammaaa*t131*t23*t341+5.12533
     ;           3333333332d-5*gammaaa*t131*t132*t21*t341+1.271082666666
     <           666d-6*t135*t24*t272*t278+3.1d-3*t20*t23*t273-9.61d-6*t
     =           132*t20*t21*t273+1.4299679999999995d-6*gammaaa*t21*t24*
     >           t270*t272+4.2369422222222203d-7*t135*t168*t21*t270*t272
     ?           -3.1777066666666653d-7*gammaaa*t133*t137*t21*t272+3.031
     @           1111111111105d-2*t23*t24*t271-9.396444444444442d-5*t132
     1           *t21*t24*t271+3.0311111111111105d-2*gammaaa*t168*t23*t2
     2           71-9.396444444444442d-5*gammaaa*t132*t168*t21*t271-4.61
     3           2799999999999d-4*gammaaa*t132*t24*t270-1.36675555555555
     4           5d-4*t132*t135*t168*t270-1.653333333333333d-2*t131*t133
     5           *t23+5.125333333333332d-5*t131*t132*t133*t21+1.02506666
     6           66666663d-4*gammaaa*t132*t133*t137)*t71+2.0d+0*t130*t34
     7           2+1.0d+0*t169*t269)*wght+Cmat3(iq,D3_RA_RA_GAA)
              Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
              Cmat3(iq,D3_RA_RA_GBB) = Cmat3(iq,D3_RA_RA_GBB)
              Cmat3(iq,D3_RA_RB_GAA) = (1.0d+0*(3.1d-3*t21*t23*(1.099387
     1           7394124477d-57*gammaaa*t137*t152*t21*t359-1.18213735420
     2           69331d-55*t131*t152*t21*t272-3.5464120626207996d-55*gam
     3           maaa*t137*t152*t272+3.813346303893333d-53*t131*t132*t15
     4           2)-9.850890666666663d-59*gammaaa*t137*t152*t21*t24*t359
     5           -8.266666666666665d-3*gammaaa*t131*t23*t347+2.562666666
     6           666666d-5*gammaaa*t131*t132*t21*t347-2.0666666666666667
     7           d-52*t152*t23*t341+6.406666666666666d-55*t132*t152*t21*
     8           t341+3.1d-3*t20*t23*t292-9.61d-6*t132*t20*t21*t292+1.05
     9           92355555555552d-56*t131*t152*t21*t24*t272+3.17770666666
     :           6666d-56*gammaaa*t137*t152*t24*t272-3.972133333333333d-
     ;           57*t133*t152*t20*t21*t272+1.0592355555555552d-56*gammaa
     <           a*t131*t152*t168*t21*t272-1.5888533333333327d-7*gammaaa
     =           *t137*t166*t21*t272-3.416888888888888d-54*t131*t132*t15
     >           2*t24-8.266666666666665d-3*t131*t166*t23+2.562666666666
     ?           666d-5*t131*t132*t166*t21+1.2813333333333332d-54*t132*t
     @           133*t152*t20-3.416888888888888d-54*gammaaa*t131*t132*t1
     1           52*t168+5.125333333333332d-5*gammaaa*t132*t137*t166)*t7
     2           1+1.0d+0*t130*t348+1.0d+0*t165*t342+1.0d+0*t169*t291)*w
     3           ght+Cmat3(iq,D3_RA_RB_GAA)
              Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
              Cmat3(iq,D3_RA_RB_GBB) = Cmat3(iq,D3_RA_RB_GBB)
              Cmat3(iq,D3_RB_RB_GAA) = (1.0d+0*(3.1d-3*t21*t23*(2.748469
     1           3485311196d-107*t20*t21*t310*t359-1.1821373542069331d-5
     2           5*t20*t21*t272*t311+3.813346303893333d-53*t132*t20*t311
     3           -8.866030156551999d-105*t20*t272*t310)-2.46272266666666
     4           63d-108*t20*t21*t24*t310*t359-4.1333333333333333d-52*t1
     5           52*t23*t347+1.2813333333333332d-54*t132*t152*t21*t347+3
     6           .1d-3*t20*t23*t339-9.61d-6*t132*t20*t21*t339+1.05923555
     7           55555552d-56*t20*t21*t24*t272*t311-3.416888888888888d-5
     8           4*t132*t20*t24*t311+5.51111111111111d-52*t168*t23*t311-
     9           1.708444444444444d-54*t132*t168*t21*t311+7.944266666666
     :           666d-106*t20*t24*t272*t310+2.6480888888888887d-106*t168
     ;           *t21*t272*t310-8.542222222222222d-104*t132*t168*t310-7.
     <           944266666666666d-57*t152*t166*t20*t21*t272+2.5626666666
     =           666664d-54*t132*t152*t166*t20)*t71+2.0d+0*t165*t348+1.0
     >           d+0*t169*t338)*wght+Cmat3(iq,D3_RB_RB_GAA)
              Cmat3(iq,D3_RB_RB_GAB) = Cmat3(iq,D3_RB_RB_GAB)
              Cmat3(iq,D3_RB_RB_GBB) = Cmat3(iq,D3_RB_RB_GBB)
              Cmat3(iq,D3_RA_GAA_GAA) = (t76*(5.0d-1*rhoa*t353*t78*t89-2
     1           .5d-1*t173*t89+5.0d-1*rhoa*t39*(2.073599999999999d-4*t1
     2           35*t453*t517*t74-5.759999999999997d-3*gammaaa*t277*t344
     3           *t74+3.839999999999999d-2*t136*t137*t74+6.0d-2*gammaaa*
     4           t20*(4.6103993164799983d-4*t135*t453*t517-1.28066647679
     5           99995d-2*gammaaa*t277*t344+8.537776511999997d-2*t136*t1
     6           37)*t73-1.5999999999999998d-1*gammaaa*t131*t352*t73+1.2
     7           d-1*t20*t345*t73-3.1999999999999995d-1*t131*t172*t73+9.
     8           599999999999997d-3*t135*t136*t137*t352+4.32d-4*gammaaa*
     9           t138*t277*t351-7.2d-3*gammaaa*t136*t171*t345-2.30399999
     :           9999999d-3*t135*t172*t277*t344+5.759999999999998d-2*gam
     ;           maaa*t136*t137*t172-7.2d-3*t136*t138*t171)*t78+5.0d-1*t
     <           353*t39*t78-2.5d-1*t173*t39*t77-2.5d-1*t346*t39)+(t516+
     =           1.25d-1*gammaaa*t353*t39)*t76*t77+1.0d+0*(3.1d-3*t21*t2
     >           3*(-1.6490816091186716d-8*gammaaa*t21*t344*t359+5.31961
     ?           8093931199d-6*gammaaa*t272*t344+3.5464120626207996d-6*t
     @           137*t21*t272-1.1440038911679998d-3*t132*t137)+1.4776335
     1           999999993d-9*gammaaa*t21*t24*t344*t359-8.26666666666666
     2           5d-3*gammaaa*t131*t23*t349+2.562666666666666d-5*gammaaa
     3           *t131*t132*t21*t349-4.766559999999998d-7*gammaaa*t24*t2
     4           72*t344+6.2d-3*t20*t23*t341-1.9219999999999998d-5*t132*
     5           t20*t21*t341-3.1777066666666653d-7*t137*t21*t24*t272+5.
     6           9582d-8*t133*t171*t21*t272-3.1777066666666653d-7*gammaa
     7           a*t137*t168*t21*t272+1.0250666666666663d-4*t132*t137*t2
     8           4-1.653333333333333d-2*t131*t168*t23+5.125333333333332d
     9           -5*t131*t132*t168*t21-1.9219999999999998d-5*t132*t133*t
     :           171+1.0250666666666663d-4*gammaaa*t132*t137*t168)*t71+1
     ;           .0d+0*t130*t350)*wght+Cmat3(iq,D3_RA_GAA_GAA)
              Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
              Cmat3(iq,D3_RA_GAA_GBB) = Cmat3(iq,D3_RA_GAA_GBB)
              Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
              Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
              Cmat3(iq,D3_RA_GBB_GBB) = Cmat3(iq,D3_RA_GBB_GBB)
              Cmat3(iq,D3_RB_GAA_GAA) = (1.0d+0*(3.1d-3*t21*t23*(1.32990
     1           45234828d-55*t152*t171*t272-4.12270402279668d-58*t152*t
     2           171*t21*t359)+3.6940839999999997d-59*t152*t171*t21*t24*
     3           t359-2.0666666666666667d-52*t152*t23*t349+6.40666666666
     4           6666d-55*t132*t152*t21*t349+6.2d-3*t20*t23*t347-1.92199
     5           99999999998d-5*t132*t20*t21*t347-1.1916399999999998d-56
     6           *t152*t171*t24*t272-7.944266666666666d-57*t152*t168*t20
     7           *t21*t272+5.9582d-8*t166*t171*t21*t272+2.56266666666666
     8           64d-54*t132*t152*t168*t20-1.9219999999999998d-5*t132*t1
     9           66*t171)*t71+1.0d+0*t165*t350)*wght+Cmat3(iq,D3_RB_GAA_
     :           GAA)
              Cmat3(iq,D3_RB_GAA_GAB) = Cmat3(iq,D3_RB_GAA_GAB)
              Cmat3(iq,D3_RB_GAA_GBB) = Cmat3(iq,D3_RB_GAA_GBB)
              Cmat3(iq,D3_RB_GAB_GAB) = Cmat3(iq,D3_RB_GAB_GAB)
              Cmat3(iq,D3_RB_GAB_GBB) = Cmat3(iq,D3_RB_GAB_GBB)
              Cmat3(iq,D3_RB_GBB_GBB) = Cmat3(iq,D3_RB_GBB_GBB)
              Cmat3(iq,D3_GAA_GAA_GAA) = (t76*(5.0d-1*rhoa*t39*(-7.776d-
     1           5*gammaaa*t453*t518*t74+1.296d-3*t277*t351*t74+6.0d-2*g
     2           ammaaa*t20*(2.881499572799999d-3*t277*t351-1.7288997436
     3           799997d-4*gammaaa*t453*t518)*t73+1.8d-1*t20*t352*t73-1.
     4           0800000000000001d-2*gammaaa*t136*t171*t352+1.296d-3*gam
     5           maaa*t172*t277*t351-2.1600000000000003d-2*t136*t171*t17
     6           2)*t78-3.75d-1*t353*t39)+1.0d+0*(3.1d-3*t21*t23*(6.1840
     7           56034195019d-9*t21*t351*t359-1.9948567852242d-6*t272*t3
     8           51)-5.541126d-10*t21*t24*t351*t359+1.78746d-7*t24*t272*
     9           t351+9.299999999999999d-3*t20*t23*t349-2.883d-5*t132*t2
     :           0*t21*t349+1.78746d-7*t168*t171*t21*t272-5.766d-5*t132*
     ;           t168*t171)*t71)*wght+Cmat3(iq,D3_GAA_GAA_GAA)
              Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
              Cmat3(iq,D3_GAA_GAA_GBB) = Cmat3(iq,D3_GAA_GAA_GBB)
              Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
              Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
              Cmat3(iq,D3_GAA_GBB_GBB) = Cmat3(iq,D3_GAA_GBB_GBB)
              Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
              Cmat3(iq,D3_GAB_GAB_GBB) = Cmat3(iq,D3_GAB_GAB_GBB)
              Cmat3(iq,D3_GAB_GBB_GBB) = Cmat3(iq,D3_GAB_GBB_GBB)
              Cmat3(iq,D3_GBB_GBB_GBB) = Cmat3(iq,D3_GBB_GBB_GBB)
              Mmat3(iq,D3_RA_RA_TA) = (t174*(-1.0d+0*t75*t78*t89-1.0d+0*
     1           rhoa*t139*t78*t89-1.25d-1*gammaaa*t75*t77*t89-5.0d-1*rh
     2           oa*t188*t75*t78-5.0d-1*rhoa*t280*t39*t78-1.0d+0*t139*t3
     3           9*t78-1.25d-1*gammaaa*t139*t39*t77-1.25d-1*gammaaa*t275
     4           *t39*t75)+t174*t77*(-1.25d-1*gammaaa*t75*t89-1.25d-1*ga
     5           mmaaa*t139*t39)+t76*(2.0d+0*t75*t89+2.0d+0*rhoa*t139*t8
     6           9+1.0d+0*rhoa*t188*t75+1.0d+0*rhoa*t280*t39+2.0d+0*t139
     7           *t39)+1.25d-1*gammaaa*t174*t275*t39*t75)*wght+Mmat3(iq,
     8           D3_RA_RA_TA)
              Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
              Mmat3(iq,D3_RA_RB_TA) = Mmat3(iq,D3_RA_RB_TA)
              Mmat3(iq,D3_RA_RB_TB) = Mmat3(iq,D3_RA_RB_TB)
              Mmat3(iq,D3_RB_RB_TA) = Mmat3(iq,D3_RB_RB_TA)
              Mmat3(iq,D3_RB_RB_TB) = Mmat3(iq,D3_RB_RB_TB)
              Mmat3(iq,D3_RA_GAA_TA) = (t174*(-5.0d-1*rhoa*t173*t78*t89-
     1           5.0d-1*rhoa*t346*t39*t78-5.0d-1*t173*t39*t78+1.25d-1*t3
     2           9*t75*t77+t514+t513)+t76*(1.0d+0*rhoa*t173*t89+1.0d+0*r
     3           hoa*t346*t39+1.0d+0*t173*t39)+t174*t512*t77)*wght+Mmat3
     4           (iq,D3_RA_GAA_TA)
              Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
              Mmat3(iq,D3_RA_GAB_TA) = Mmat3(iq,D3_RA_GAB_TA)
              Mmat3(iq,D3_RA_GAB_TB) = Mmat3(iq,D3_RA_GAB_TB)
              Mmat3(iq,D3_RA_GBB_TA) = Mmat3(iq,D3_RA_GBB_TA)
              Mmat3(iq,D3_RA_GBB_TB) = Mmat3(iq,D3_RA_GBB_TB)
              Mmat3(iq,D3_RB_GAA_TA) = Mmat3(iq,D3_RB_GAA_TA)
              Mmat3(iq,D3_RB_GAA_TB) = Mmat3(iq,D3_RB_GAA_TB)
              Mmat3(iq,D3_RB_GAB_TA) = Mmat3(iq,D3_RB_GAB_TA)
              Mmat3(iq,D3_RB_GAB_TB) = Mmat3(iq,D3_RB_GAB_TB)
              Mmat3(iq,D3_RB_GBB_TA) = Mmat3(iq,D3_RB_GBB_TA)
              Mmat3(iq,D3_RB_GBB_TB) = Mmat3(iq,D3_RB_GBB_TB)
              Mmat3(iq,D3_RA_TA_TA) = (t174*(t516-5.0d-1*rhoa*t353*t39*t
     1           78)+1.0d+0*rhoa*t353*t39*t76)*wght+Mmat3(iq,D3_RA_TA_TA
     2           )
              Mmat3(iq,D3_RA_TA_TB) = Mmat3(iq,D3_RA_TA_TB)
              Mmat3(iq,D3_RA_TB_TB) = Mmat3(iq,D3_RA_TB_TB)
              Mmat3(iq,D3_RB_TA_TA) = Mmat3(iq,D3_RB_TA_TA)
              Mmat3(iq,D3_RB_TA_TB) = Mmat3(iq,D3_RB_TA_TB)
              Mmat3(iq,D3_RB_TB_TB) = Mmat3(iq,D3_RB_TB_TB)
              Mmat3(iq,D3_GAA_GAA_TA) = Mmat3(iq,D3_GAA_GAA_TA)
              Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
              Mmat3(iq,D3_GAA_GAB_TA) = Mmat3(iq,D3_GAA_GAB_TA)
              Mmat3(iq,D3_GAA_GAB_TB) = Mmat3(iq,D3_GAA_GAB_TB)
              Mmat3(iq,D3_GAA_GBB_TA) = Mmat3(iq,D3_GAA_GBB_TA)
              Mmat3(iq,D3_GAA_GBB_TB) = Mmat3(iq,D3_GAA_GBB_TB)
              Mmat3(iq,D3_GAB_GAB_TA) = (-2.0d+0*rhoa*t173*t174*t39-2*t3
     1           54*t355)*wght+Mmat3(iq,D3_GAB_GAB_TA)
              Mmat3(iq,D3_GAB_GAB_TB) = Mmat3(iq,D3_GAB_GAB_TB)
              Mmat3(iq,D3_GAB_GBB_TA) = Mmat3(iq,D3_GAB_GBB_TA)
              Mmat3(iq,D3_GAB_GBB_TB) = Mmat3(iq,D3_GAB_GBB_TB)
              Mmat3(iq,D3_GBB_GBB_TA) = Mmat3(iq,D3_GBB_GBB_TA)
              Mmat3(iq,D3_GBB_GBB_TB) = Mmat3(iq,D3_GBB_GBB_TB)
              Mmat3(iq,D3_GAA_TA_TA) = Mmat3(iq,D3_GAA_TA_TA)
              Mmat3(iq,D3_GAA_TA_TB) = Mmat3(iq,D3_GAA_TA_TB)
              Mmat3(iq,D3_GAA_TB_TB) = Mmat3(iq,D3_GAA_TB_TB)
              Mmat3(iq,D3_GAB_TA_TA) = (6.0d+0*rhoa*t355*t39*t75-3.0d+0*
     1           rhoa*t39*t75*t78/taua**4)*wght+Mmat3(iq,D3_GAB_TA_TA)
              Mmat3(iq,D3_GAB_TA_TB) = Mmat3(iq,D3_GAB_TA_TB)
              Mmat3(iq,D3_GAB_TB_TB) = Mmat3(iq,D3_GAB_TB_TB)
              Mmat3(iq,D3_GBB_TA_TA) = Mmat3(iq,D3_GBB_TA_TA)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 2.4d-51*t1+1.0d+0
              t3 = 1/t2
              t4 = 5.336110319999999d-51*t1*t3-2.5960897d+0
              t5 = 2.4d-51*t1*t3*t4+1.0d+0
              t6 = 1/rhoa**6.666666666666666d-1
              t7 = rhoa**5.0d-1
              t8 = 1/t7
              t9 = 1/rhoa**3.333333333333333d-1
              t10 = 1/rhoa**1.6666666666666666d-1
              t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.4
     1           058712912881916d-1*t6+1.1120374863094686d+1*t10
              t12 = 3.216395899738507d+1/t11+1.0d+0
              t13 = log(t12)
              t14 = 1.274696188700087d-1*t9+1.0d+0
              t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.8
     1           970043257475583d-1*t6+5.982550435771079d+0*t10
              t16 = 1.6081979498692536d+1/t15+1.0d+0
              t17 = log(t16)
              t18 = 1.3256889990520176d-1*t9+1.0d+0
              t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2
     1           *t13*t14
              t20 = 1/rhob**2.6666666666666666d+0
              t21 = gammabb*t20+4.0d-50*t1
              t22 = 3.1d-3*t21+1.0d+0
              t23 = 1/t22
              t24 = 5.9515308d+0-3.459689187d-2*t21*t23
              t25 = 3.1d-3*t21*t23*t24+1.0d+0
              t26 = 1/rhob**6.666666666666666d-1
              t27 = rhob**5.0d-1
              t28 = 1/t27
              t29 = 1/rhob**3.333333333333333d-1
              t30 = 1/rhob**1.6666666666666666d-1
              t31 = 1.1120374863094686d+1*t30+3.8447462374472113d+0*t29+
     1           1.644733775567609d+0*t28+2.4058712912881916d-1*t26
              t32 = 3.216395899738507d+1/t31+1.0d+0
              t33 = log(t32)
              t34 = 1.274696188700087d-1*t29+1.0d+0
              t35 = 5.982550435771079d+0*t30+2.2255694211506874d+0*t29+8
     1           .004286349993635d-1*t28+1.8970043257475583d-1*t26
              t36 = 1.6081979498692536d+1/t35+1.0d+0
              t37 = log(t36)
              t38 = 1.3256889990520176d-1*t29+1.0d+0
              t39 = -6.903522198342671d-18*t37*t38-3.1090699999999993d-2
     1           *t33*t34
              t40 = rhob+rhoa
              t41 = 1/t40**3.333333333333333d-1
              t42 = 1.3256889990520176d-1*t41+1.0d+0
              t43 = rhoa-rhob
              t44 = t43**4
              t45 = 1/t40**4
              t46 = 1/t40
              t47 = 1.0d+0-t43*t46
              t48 = t43*t46+1.0d+0
              t49 = t48**1.3333333333333333d+0+t47**1.3333333333333333d+
     1           0-2.0d+0
              t50 = -1.923661050931536d+0*t44*t45*t49
              t51 = t50+1.0d+0
              t52 = 1/t40**6.666666666666666d-1
              t53 = t40**5.0d-1
              t54 = 1/t53
              t55 = 1/t40**1.6666666666666666d-1
              t56 = 5.982550435771079d+0*t55+8.004286349993635d-1*t54+1.
     1           8970043257475583d-1*t52+2.2255694211506874d+0*t41
              t57 = 1.6081979498692536d+1/t56+1.0d+0
              t58 = log(t57)
              t59 = -6.21814d-2*t42*t51*t58
              t60 = 6.901399211255825d-2*t41+1.0d+0
              t61 = t50+1.923661050931536d+0*t49
              t62 = 8.157414703487641d+0*t55+4.3009724712766434d-1*t54+1
     1           .9115125951273373d-1*t52+2.247591863577616d+0*t41
              t63 = 2.9608813203268075d+1/t62+1.0d+0
              t64 = log(t63)
              t65 = 1.9751631321680768d-2*t60*t61*t64
              t66 = 1.274696188700087d-1*t41+1.0d+0
              t67 = 1.1120374863094686d+1*t55+1.644733775567609d+0*t54+2
     1           .4058712912881916d-1*t52+3.8447462374472113d+0*t41
              t68 = 3.216395899738507d+1/t67+1.0d+0
              t69 = log(t68)
              t70 = -5.980796863619711d-2*t44*t45*t49*t66*t69
              t71 = t40*(t70+t65+t59)-rhob*t39-rhoa*t19
              t72 = 6.0d-2*gammabb*t20+1.0d+0
              t73 = 1/t72
              t74 = 1.3340275799999998d-1*gammabb*t20*t73-2.5960897d+0
              t75 = 6.0d-2*gammabb*t20*t73*t74+1.0d+0
              t76 = 1/taub
              t77 = 1/rhob
              t78 = 2.0d+0*taub-2.5d-1*gammabb*t77
              t79 = 1/t16
              t80 = 1/t7**3
              t81 = 1/rhoa**1.3333333333333333d+0
              t82 = 1/rhoa**1.1666666666666667d+0
              t83 = -9.970917392951799d-1*t82-7.418564737168958d-1*t81-4
     1           .002143174996817d-1*t80-1.264669550498372d-1*t1
              t84 = 1/t15**2
              t85 = 1/t12
              t86 = -1.8533958105157808d+0*t82-1.2815820791490704d+0*t81
     1           -8.223668877838045d-1*t80-1.6039141941921276d-1*t1
              t87 = 1/t11**2
              t88 = 1.0d+0*t14*t85*t86*t87+1.1102230246251565d-16*t18*t7
     1           9*t83*t84+3.0506411443514264d-19*t17*t81+1.321039893133
     2           9265d-3*t13*t81
              t89 = 1/t2**2
              t90 = 1/rhoa**4.333333333333333d+0
              t91 = 1/rhoa**2.6666666666666666d+0
              t92 = 2.134444128d-101*t89*t90-8.8935172d-51*t3*t91
              t93 = 2.4d-51*t1*t3*t92-4.0d-51*t3*t4*t91+9.6d-102*t4*t89*
     1           t90
              t94 = 1/t40**1.6666666666666669d+0
              t95 = 1/t53**3
              t96 = 1/t40**1.3333333333333333d+0
              t97 = 1/t40**1.1666666666666667d+0
              t98 = -9.970917392951799d-1*t97-7.418564737168958d-1*t96-4
     1           .002143174996817d-1*t95-1.264669550498372d-1*t94
              t99 = 1/t56**2
              t100 = 1/t57
              t101 = 1.0d+0*t100*t42*t51*t98*t99
              t102 = -1.3595691172479402d+0*t97-7.491972878592053d-1*t96
     1           -2.1504862356383217d-1*t95-1.2743417300848914d-1*t94
              t103 = 1/t62**2
              t104 = 1/t63
              t105 = -5.848223622634647d-1*t102*t103*t104*t60*t61
              t106 = -1.8533958105157808d+0*t97-1.2815820791490704d+0*t9
     1           6-8.223668877838045d-1*t95-1.6039141941921276d-1*t94
              t107 = 1/t67**2
              t108 = 1/t68
              t109 = 1.923661050931536d+0*t106*t107*t108*t44*t45*t49*t66
              t110 = 1/t40**2
              t111 = t110*t43
              t112 = -t46
              t113 = t112+t111
              t114 = t47**3.333333333333333d-1
              t115 = -t110*t43
              t116 = t46+t115
              t117 = t48**3.333333333333333d-1
              t118 = 1.3333333333333333d+0*t116*t117+1.3333333333333333d
     1           +0*t113*t114
              t119 = -1.923661050931536d+0*t118*t44*t45
              t120 = 1/t40**5
              t121 = 7.694644203726144d+0*t120*t44*t49
              t122 = t43**3
              t123 = -7.694644203726144d+0*t122*t45*t49
              t124 = t123+t121+t119
              t125 = -6.21814d-2*t124*t42*t58
              t126 = 2.747773264188437d-3*t51*t58*t96
              t127 = t123+t121+t119+1.923661050931536d+0*t118
              t128 = 1.9751631321680768d-2*t127*t60*t64
              t129 = -4.5437964274821163d-4*t61*t64*t96
              t130 = -5.980796863619711d-2*t118*t44*t45*t66*t69
              t131 = 1/t40**5.333333333333333d+0
              t132 = 2.541232989148493d-3*t131*t44*t49*t69
              t133 = 2.3923187454478842d-1*t120*t44*t49*t66*t69
              t134 = -rhoa*t88+t70+t40*(-2.3923187454478842d-1*t122*t45*
     1           t49*t66*t69+t133+t132+t130+t129+t128+t126+t125+t109+t10
     2           5+t101)+t65+t59+6.903522198342671d-18*t17*t18+3.1090699
     3           999999993d-2*t13*t14
              t135 = 1/t22**2
              t136 = 2.306459458d-51*t23*t91-7.1500243198d-54*t135*t21*t
     1           91
              t137 = -2.0666666666666667d-52*t23*t24*t91+6.4066666666666
     1           66d-55*t135*t21*t24*t91+3.1d-3*t136*t21*t23
              t138 = 1/t36
              t139 = 1/rhob**1.6666666666666669d+0
              t140 = 1/t27**3
              t141 = 1/rhob**1.3333333333333333d+0
              t142 = 1/rhob**1.1666666666666667d+0
              t143 = -9.970917392951799d-1*t142-7.418564737168958d-1*t14
     1           1-4.002143174996817d-1*t140-1.264669550498372d-1*t139
              t144 = 1/t35**2
              t145 = 1/t32
              t146 = -1.8533958105157808d+0*t142-1.2815820791490704d+0*t
     1           141-8.223668877838045d-1*t140-1.6039141941921276d-1*t13
     2           9
              t147 = 1/t31**2
              t148 = 1.1102230246251565d-16*t138*t143*t144*t38+3.0506411
     1           443514264d-19*t141*t37+1.0d+0*t145*t146*t147*t34+1.3210
     2           398931339265d-3*t141*t33
              t149 = t46+t111
              t150 = t115+t112
              t151 = 1.3333333333333333d+0*t117*t150+1.3333333333333333d
     1           +0*t114*t149
              t152 = -1.923661050931536d+0*t151*t44*t45
              t153 = 7.694644203726144d+0*t122*t45*t49
              t154 = t153+t152+t121
              t155 = -6.21814d-2*t154*t42*t58
              t156 = t153+t152+1.923661050931536d+0*t151+t121
              t157 = 1.9751631321680768d-2*t156*t60*t64
              t158 = -5.980796863619711d-2*t151*t44*t45*t66*t69
              t159 = t70+t40*(2.3923187454478842d-1*t122*t45*t49*t66*t69
     1           +t158+t157+t155+t133+t132+t129+t126+t109+t105+t101)+t65
     2           +t59+6.903522198342671d-18*t37*t38+3.1090699999999993d-
     3           2*t33*t34-rhob*t148
              t160 = 1/rhob**3.6666666666666664d+0
              t161 = 9.225837832d-2*gammabb*t160*t23-2.86000972792d-4*ga
     1           mmabb*t135*t160*t21
              t162 = -8.266666666666665d-3*gammabb*t160*t23*t24+2.562666
     1           666666666d-5*gammabb*t135*t160*t21*t24+3.1d-3*t161*t21*
     2           t23
              t163 = gammabb**2
              t164 = 1/t72**2
              t165 = 1/rhob**6.333333333333333d+0
              t166 = 2.1344441279999993d-2*t163*t164*t165-3.557406879999
     1           999d-1*gammabb*t160*t73
              t167 = -1.5999999999999998d-1*gammabb*t160*t73*t74+9.59999
     1           9999999997d-3*t163*t164*t165*t74+6.0d-2*gammabb*t166*t2
     2           0*t73
              t168 = 1.07250364797d-4*t135*t20*t21-3.459689187d-2*t20*t2
     1           3
              t169 = 3.1d-3*t20*t23*t24-9.61d-6*t135*t20*t21*t24+3.1d-3*
     1           t168*t21*t23
              t170 = -1.25d-1*t39*t75
              t171 = 1/rhob**5.333333333333333d+0
              t172 = 1.3340275799999998d-1*t20*t73-8.004165479999998d-3*
     1           gammabb*t164*t171
              t173 = 6.0d-2*t20*t73*t74-3.6d-3*gammabb*t164*t171*t74+6.0
     1           d-2*gammabb*t172*t20*t73
              t174 = 1/taub**2
              t175 = 1/t16**2
              t176 = t83**2
              t177 = 1/t15**4
              t178 = 1/t15**3
              t179 = 1/t7**5
              t180 = 1/rhoa**2.3333333333333334d+0
              t181 = 1/rhoa**2.1666666666666665d+0
              t182 = 2.1077825841639536d-1*t91+1.1632736958443765d+0*t18
     1           1+9.89141964955861d-1*t180+6.003214762495226d-1*t179
              t183 = 1/t12**2
              t184 = t86**2
              t185 = 1/t11**4
              t186 = 1/t11**3
              t187 = 2.673190323653546d-1*t91+2.1622951122684114d+0*t181
     1           +1.7087761055320938d+0*t180+1.2335503316757068d+0*t179
              t188 = -8.497974591333913d-2*t81*t85*t86*t87+1.0d+0*t14*t1
     1           87*t85*t87-2.0d+0*t14*t184*t186*t85-9.812069668265515d-
     2           18*t79*t81*t83*t84+1.1102230246251565d-16*t18*t182*t79*
     3           t84-2.220446049250313d-16*t176*t178*t18*t79+3.216395899
     4           738507d+1*t14*t183*t184*t185-4.0675215258019015d-19*t17
     5           *t180-1.7613865241785684d-3*t13*t180+1.7854583920998188
     6           d-15*t175*t176*t177*t18
              t189 = 1/t2**3
              t190 = 1/rhoa**7
              t191 = 1/rhoa**5.333333333333333d+0
              t192 = 1/rhoa**3.6666666666666664d+0
              t193 = -1.2806664767999998d-100*t191*t89+2.371604586666666
     1           6d-50*t192*t3+1.7075553024d-151*t189*t190
              t194 = -8.0d-51*t3*t91*t92+1.92d-101*t89*t90*t92-5.76d-101
     1           *t191*t4*t89+1.0666666666666666d-50*t192*t3*t4+7.68d-15
     2           2*t189*t190*t4+2.4d-51*t1*t193*t3
              t195 = 2.0d+0*t100*t42*t51*t98*t99
              t196 = -1.1696447245269295d+0*t102*t103*t104*t60*t61
              t197 = 3.847322101863072d+0*t106*t107*t108*t44*t45*t49*t66
              t198 = 5.495546528376875d-3*t51*t58*t96
              t199 = -9.087592854964233d-4*t61*t64*t96
              t200 = 5.082465978296986d-3*t131*t44*t49*t69
              t201 = 4.7846374908957684d-1*t120*t44*t49*t66*t69
              t202 = t98**2
              t203 = 1/t56**4
              t204 = 1/t57**2
              t205 = 1.6081979498692536d+1*t202*t203*t204*t42*t51
              t206 = 2.0d+0*t100*t124*t42*t98*t99
              t207 = 1/t56**3
              t208 = -2.0d+0*t100*t202*t207*t42*t51
              t209 = -8.837926660346784d-2*t100*t51*t96*t98*t99
              t210 = 1/t40**2.6666666666666666d+0
              t211 = 1/t53**5
              t212 = 1/t40**2.3333333333333334d+0
              t213 = 1/t40**2.1666666666666665d+0
              t214 = 1.1632736958443765d+0*t213+9.89141964955861d-1*t212
     1           +6.003214762495226d-1*t211+2.1077825841639536d-1*t210
              t215 = 1.0d+0*t100*t214*t42*t51*t99
              t216 = t102**2
              t217 = 1/t62**4
              t218 = 1/t63**2
              t219 = -1.73158960813529d+1*t216*t217*t218*t60*t61
              t220 = -1.1696447245269295d+0*t102*t103*t104*t127*t60
              t221 = 1/t62**3
              t222 = 1.1696447245269295d+0*t104*t216*t221*t60*t61
              t223 = 2.690728393099896d-2*t102*t103*t104*t61*t96
              t224 = 1.5861639701225969d+0*t213+9.98929717145607d-1*t212
     1           +3.2257293534574827d-1*t211+2.1239028834748191d-1*t210
              t225 = -5.848223622634647d-1*t103*t104*t224*t60*t61
              t226 = t106**2
              t227 = 1/t67**4
              t228 = 1/t68**2
              t229 = 6.187255516702861d+1*t226*t227*t228*t44*t45*t49*t66
              t230 = 3.847322101863072d+0*t106*t107*t108*t118*t44*t45*t6
     1           6
              t231 = 1/t67**3
              t232 = -3.847322101863072d+0*t108*t226*t231*t44*t45*t49*t6
     1           6
              t233 = -1.6347222733154887d-1*t106*t107*t108*t131*t44*t49
              t234 = 2.1622951122684114d+0*t213+1.7087761055320938d+0*t2
     1           12+1.2335503316757068d+0*t211+2.673190323653546d-1*t210
              t235 = 1.923661050931536d+0*t107*t108*t234*t44*t45*t49*t66
              t236 = -1.538928840745229d+1*t106*t107*t108*t120*t44*t49*t
     1           66
              t237 = 1.538928840745229d+1*t106*t107*t108*t122*t45*t49*t6
     1           6
              t238 = t113**2
              t239 = 1/t47**6.666666666666666d-1
              t240 = 1/t40**3
              t241 = -2*t240*t43
              t242 = 2*t110
              t243 = t242+t241
              t244 = t116**2
              t245 = 1/t48**6.666666666666666d-1
              t246 = 2*t240*t43
              t247 = -2*t110
              t248 = t247+t246
              t249 = 1.3333333333333333d+0*t117*t248+4.444444444444444d-
     1           1*t244*t245+1.3333333333333333d+0*t114*t243+4.444444444
     2           444444d-1*t238*t239
              t250 = -1.923661050931536d+0*t249*t44*t45
              t251 = 1.5389288407452287d+1*t118*t120*t44
              t252 = -1.5389288407452287d+1*t118*t122*t45
              t253 = 1/t40**6
              t254 = -3.8473221018630716d+1*t253*t44*t49
              t255 = 6.155715362980915d+1*t120*t122*t49
              t256 = t43**2
              t257 = -2.3083932611178434d+1*t256*t45*t49
              t258 = t257+t255+t254+t252+t251+t250
              t259 = -6.21814d-2*t258*t42*t58
              t260 = 5.495546528376875d-3*t124*t58*t96
              t261 = -3.663697685584583d-3*t212*t51*t58
              t262 = t257+t255+t254+t252+t251+t250+1.923661050931536d+0*
     1           t249
              t263 = 1.9751631321680768d-2*t262*t60*t64
              t264 = -9.087592854964233d-4*t127*t64*t96
              t265 = 6.058395236642822d-4*t212*t61*t64
              t266 = -5.980796863619711d-2*t249*t44*t45*t66*t69
              t267 = 5.082465978296986d-3*t118*t131*t44*t69
              t268 = 4.7846374908957684d-1*t118*t120*t44*t66*t69
              t269 = 1/t40**6.333333333333333d+0
              t270 = -2.3718174565385935d-2*t269*t44*t49*t69
              t271 = 2.0329863913187946d-2*t122*t131*t49*t69
              t272 = -1.1961593727239421d+0*t253*t44*t49*t66*t69
              t273 = 1.9138549963583074d+0*t120*t122*t49*t66*t69
              t274 = -7.176956236343652d-1*t256*t45*t49*t66*t69
              t275 = -2.0d+0*t14*t85*t86*t87-2.220446049250313d-16*t18*t
     1           79*t83*t84-6.101282288702853d-19*t17*t81-2.642079786267
     2           853d-3*t13*t81+t40*(-4.7846374908957684d-1*t118*t122*t4
     3           5*t66*t69+t274+t273+t272+t271+t270+t268+t267+t266+t265+
     4           t264+t263+t261+t260+t259+t237+t236+t235+t233+t232+t230+
     5           t229+t225+t223+t222+t220+t219+t215+t209+t208+t206+t205)
     6           -4.7846374908957684d-1*t122*t45*t49*t66*t69-1.196159372
     7           7239421d-1*t118*t44*t45*t66*t69+3.9503262643361536d-2*t
     8           127*t60*t64-1.243628d-1*t124*t42*t58+t201+t200+t199+t19
     9           8+t197+t196+t195-rhoa*t188
              t276 = 1/t22**3
              t277 = -2.9553433855173333d-105*t191*t21*t276-6.1505585546
     1           66666d-51*t192*t23+1.9066731519466665d-53*t135*t192*t21
     2           +9.533365759733332d-103*t135*t191
              t278 = -4.1333333333333333d-52*t136*t23*t91+1.281333333333
     1           3332d-54*t135*t136*t21*t91+3.1d-3*t21*t23*t277+2.648088
     2           8888888887d-106*t191*t21*t24*t276+5.51111111111111d-52*
     3           t192*t23*t24-1.708444444444444d-54*t135*t192*t21*t24-8.
     4           542222222222222d-104*t135*t191*t24
              t279 = 2.6666666666666666d+0*t117*t240*t43-2.6666666666666
     1           666d+0*t114*t240*t43+4.444444444444444d-1*t116*t150*t24
     2           5+4.444444444444444d-1*t113*t149*t239
              t280 = -1.923661050931536d+0*t279*t44*t45
              t281 = 7.694644203726144d+0*t120*t151*t44
              t282 = -7.694644203726144d+0*t122*t151*t45
              t283 = 7.694644203726144d+0*t118*t120*t44
              t284 = 7.694644203726144d+0*t118*t122*t45
              t285 = 2.3083932611178434d+1*t256*t45*t49
              t286 = t285+t284+t283+t282+t281+t280+t254
              t287 = t285+t284+t283+t282+t281+t280+1.923661050931536d+0*
     1           t279+t254
              t288 = 7.176956236343652d-1*t256*t45*t49*t66*t69
              t289 = t40*(1.0d+0*t100*t154*t42*t98*t99+1.0d+0*t100*t124*
     1           t42*t98*t99-4.5437964274821163d-4*t156*t64*t96-4.543796
     2           4274821163d-4*t127*t64*t96+2.747773264188437d-3*t154*t5
     3           8*t96+2.747773264188437d-3*t124*t58*t96-5.9807968636197
     4           11d-2*t279*t44*t45*t66*t69-2.3923187454478842d-1*t122*t
     5           151*t45*t66*t69+2.3923187454478842d-1*t118*t122*t45*t66
     6           *t69+2.3923187454478842d-1*t120*t151*t44*t66*t69+2.3923
     7           187454478842d-1*t118*t120*t44*t66*t69+2.541232989148493
     8           d-3*t131*t151*t44*t69+2.541232989148493d-3*t118*t131*t4
     9           4*t69+1.923661050931536d+0*t106*t107*t108*t151*t44*t45*
     :           t66+1.923661050931536d+0*t106*t107*t108*t118*t44*t45*t6
     ;           6+1.9751631321680768d-2*t287*t60*t64-5.848223622634647d
     <           -1*t102*t103*t104*t156*t60-5.848223622634647d-1*t102*t1
     =           03*t104*t127*t60-6.21814d-2*t286*t42*t58+t288+t272+t270
     >           +t265+t261+t236+t235+t233+t232+t229+t225+t223+t222+t219
     ?           +t215+t209+t208+t205)+t201+t200+t199+t198+t197+t196+t19
     @           5+t158+t157+t155+t130+t128+t125
              t290 = 3.813346303893333d-53*gammabb*t135*t160*t91-1.18213
     1           73542069331d-55*gammabb*t160*t21*t276*t91
              t291 = 1.0592355555555552d-56*gammabb*t160*t21*t24*t276*t9
     1           1-3.416888888888888d-54*gammabb*t135*t160*t24*t91-2.066
     2           6666666666667d-52*t161*t23*t91+6.406666666666666d-55*t1
     3           35*t161*t21*t91+3.1d-3*t21*t23*t290-8.266666666666665d-
     4           3*gammabb*t136*t160*t23+2.562666666666666d-5*gammabb*t1
     5           35*t136*t160*t21
              t292 = 1/t36**2
              t293 = t143**2
              t294 = 1/t35**4
              t295 = 1/t35**3
              t296 = 1/t27**5
              t297 = 1/rhob**2.3333333333333334d+0
              t298 = 1/rhob**2.1666666666666665d+0
              t299 = 1.1632736958443765d+0*t298+9.89141964955861d-1*t297
     1           +6.003214762495226d-1*t296+2.1077825841639536d-1*t20
              t300 = 1/t32**2
              t301 = t146**2
              t302 = 1/t31**4
              t303 = 1/t31**3
              t304 = 2.1622951122684114d+0*t298+1.7087761055320938d+0*t2
     1           97+1.2335503316757068d+0*t296+2.673190323653546d-1*t20
              t305 = 1.1102230246251565d-16*t138*t144*t299*t38-2.2204460
     1           49250313d-16*t138*t293*t295*t38+1.7854583920998188d-15*
     2           t292*t293*t294*t38-4.0675215258019015d-19*t297*t37+1.0d
     3           +0*t145*t147*t304*t34-2.0d+0*t145*t301*t303*t34+3.21639
     4           5899738507d+1*t300*t301*t302*t34-1.7613865241785684d-3*
     5           t297*t33-8.497974591333913d-2*t141*t145*t146*t147-9.812
     6           069668265515d-18*t138*t141*t143*t144
              t306 = 2.0d+0*t100*t154*t42*t98*t99
              t307 = -1.1696447245269295d+0*t102*t103*t104*t156*t60
              t308 = 3.847322101863072d+0*t106*t107*t108*t151*t44*t45*t6
     1           6
              t309 = -1.538928840745229d+1*t106*t107*t108*t122*t45*t49*t
     1           66
              t310 = t149**2
              t311 = t247+t241
              t312 = t150**2
              t313 = t246+t242
              t314 = 1.3333333333333333d+0*t117*t313+4.444444444444444d-
     1           1*t245*t312+1.3333333333333333d+0*t114*t311+4.444444444
     2           444444d-1*t239*t310
              t315 = -1.923661050931536d+0*t314*t44*t45
              t316 = 1.5389288407452287d+1*t120*t151*t44
              t317 = 1.5389288407452287d+1*t122*t151*t45
              t318 = -6.155715362980915d+1*t120*t122*t49
              t319 = t318+t317+t316+t315+t257+t254
              t320 = -6.21814d-2*t319*t42*t58
              t321 = 5.495546528376875d-3*t154*t58*t96
              t322 = t318+t317+t316+t315+1.923661050931536d+0*t314+t257+
     1           t254
              t323 = 1.9751631321680768d-2*t322*t60*t64
              t324 = -9.087592854964233d-4*t156*t64*t96
              t325 = -5.980796863619711d-2*t314*t44*t45*t66*t69
              t326 = 5.082465978296986d-3*t131*t151*t44*t69
              t327 = 4.7846374908957684d-1*t120*t151*t44*t66*t69
              t328 = -2.0329863913187946d-2*t122*t131*t49*t69
              t329 = -1.9138549963583074d+0*t120*t122*t49*t66*t69
              t330 = t40*(4.7846374908957684d-1*t122*t151*t45*t66*t69+t3
     1           29+t328+t327+t326+t325+t324+t323+t321+t320+t309+t308+t3
     2           07+t306+t274+t272+t270+t265+t261+t236+t235+t233+t232+t2
     3           29+t225+t223+t222+t219+t215+t209+t208+t205)+4.784637490
     4           8957684d-1*t122*t45*t49*t66*t69-1.1961593727239421d-1*t
     5           151*t44*t45*t66*t69+3.9503262643361536d-2*t156*t60*t64-
     6           1.243628d-1*t154*t42*t58-2.220446049250313d-16*t138*t14
     7           3*t144*t38-6.101282288702853d-19*t141*t37-2.0d+0*t145*t
     8           146*t147*t34-2.642079786267853d-3*t141*t33-rhob*t305+t2
     9           01+t200+t199+t198+t197+t196+t195
              t331 = 1/rhob**7.333333333333333d+0
              t332 = 1/rhob**4.666666666666667d+0
              t333 = -3.3828072050666663d-1*gammabb*t23*t332+1.048670233
     1           5706666d-3*gammabb*t135*t21*t332-4.728549416827732d-6*t
     2           163*t21*t276*t331+1.525338521557333d-3*t135*t163*t331
              t334 = 3.1d-3*t21*t23*t333+3.0311111111111105d-2*gammabb*t
     1           23*t24*t332-9.396444444444442d-5*gammabb*t135*t21*t24*t
     2           332+4.2369422222222203d-7*t163*t21*t24*t276*t331-1.3667
     3           55555555555d-4*t135*t163*t24*t331-1.653333333333333d-2*
     4           gammabb*t160*t161*t23+5.125333333333332d-5*gammabb*t135
     5           *t160*t161*t21
              t335 = 1/rhob**2
              t336 = gammabb**3
              t337 = 1/t72**3
              t338 = 1/rhob**10
              t339 = 1.3043825226666664d+0*gammabb*t332*t73+6.8302212095
     1           99997d-3*t336*t337*t338-1.9209997151999994d-1*t163*t164
     2           *t331
              t340 = 5.866666666666666d-1*gammabb*t332*t73*t74+3.0719999
     1           999999986d-3*t336*t337*t338*t74-8.639999999999998d-2*t1
     2           63*t164*t331*t74+6.0d-2*gammabb*t20*t339*t73-3.19999999
     3           99999995d-1*gammabb*t160*t166*t73+1.9199999999999995d-2
     4           *t163*t164*t165*t166
              t341 = 4.433015078276d-56*t20*t21*t276*t91-1.4300048639599
     1           997d-53*t135*t20*t91
              t342 = -3.972133333333333d-57*t20*t21*t24*t276*t91+1.28133
     1           33333333332d-54*t135*t20*t24*t91-2.0666666666666667d-52
     2           *t168*t23*t91+6.406666666666666d-55*t135*t168*t21*t91+3
     3           .1d-3*t21*t23*t341+3.1d-3*t136*t20*t23-9.61d-6*t135*t13
     4           6*t20*t21
              t343 = 1.7732060313103998d-6*gammabb*t165*t21*t276+9.22583
     1           7832d-2*t160*t23-2.86000972792d-4*t135*t160*t21-5.72001
     2           945584d-4*gammabb*t135*t165
              t344 = 3.1d-3*t21*t23*t343-1.5888533333333327d-7*gammabb*t
     1           165*t21*t24*t276-8.266666666666665d-3*t160*t23*t24+2.56
     2           2666666666666d-5*t135*t160*t21*t24+5.125333333333332d-5
     3           *gammabb*t135*t165*t24+3.1d-3*t161*t20*t23-8.2666666666
     4           66665d-3*gammabb*t160*t168*t23-9.61d-6*t135*t161*t20*t2
     5           1+2.562666666666666d-5*gammabb*t135*t160*t168*t21
              t345 = 1.25d-1*t39*t75
              t346 = 1/rhob**9
              t347 = -3.557406879999999d-1*t160*t73-2.561332953599999d-3
     1           *t163*t337*t346+6.403332383999999d-2*gammabb*t164*t165
              t348 = -1.5999999999999998d-1*t160*t73*t74-1.1519999999999
     1           996d-3*t163*t337*t346*t74+2.879999999999999d-2*gammabb*
     2           t164*t165*t74+6.0d-2*gammabb*t20*t347*t73+6.0d-2*t166*t
     3           20*t73-1.5999999999999998d-1*gammabb*t160*t172*t73+9.59
     4           9999999999997d-3*t163*t164*t165*t172-3.6d-3*gammabb*t16
     5           4*t166*t171
              t349 = 2.14500729594d-4*t135*t171-6.649522617413999d-7*t17
     1           1*t21*t276
              t350 = 3.1d-3*t21*t23*t349+5.9582d-8*t171*t21*t24*t276-1.9
     1           219999999999998d-5*t135*t171*t24+6.2d-3*t168*t20*t23-1.
     2           9219999999999998d-5*t135*t168*t20*t21
              t351 = 1/rhob**8
              t352 = 9.604998575999998d-4*gammabb*t337*t351-1.6008330959
     1           999997d-2*t164*t171
              t353 = 4.32d-4*gammabb*t337*t351*t74-7.2d-3*t164*t171*t74+
     1           6.0d-2*gammabb*t20*t352*t73+1.2d-1*t172*t20*t73-7.2d-3*
     2           gammabb*t164*t171*t172
              t354 = t345-5.0d-1*rhob*t173*t39*t78
              t355 = 1/taub**3
              t356 = t83**3
              t357 = 1/t7**7
              t358 = 1/rhoa**3.3333333333333337d+0
              t359 = 1/rhoa**3.1666666666666665d+0
              t360 = t86**3
              t361 = 1.6995949182667827d-1*t180*t85*t86*t87-1.2746961887
     1           00087d-1*t187*t81*t85*t87+1.0d+0*t14*(-4.68497274324822
     2           4d+0*t359-3.9871442462415524d+0*t358-3.083875829189267d
     3           +0*t357-7.128507529742789d-1*t192)*t85*t87-6.0d+0*t14*t
     4           186*t187*t85*t86+9.649187699215522d+1*t14*t183*t185*t18
     5           7*t86+2.549392377400174d-1*t184*t186*t81*t85+6.0d+0*t14
     6           *t185*t360*t85+1.962413933653103d-17*t180*t79*t83*t84-1
     7           .4718104502398274d-17*t182*t79*t81*t84+1.11022302462515
     8           65d-16*t18*(-2.520426340996149d+0*t359-2.30799791823034
     9           28d+0*t358-1.5008036906238065d+0*t357-5.620753557770543
     :           d-1*t192)*t79*t84-6.661338147750939d-16*t178*t18*t182*t
     ;           79*t83+5.356375176299456d-15*t175*t177*t18*t182*t83+2.9
     <           43620900479655d-17*t176*t178*t79*t81-4.0999275947472624
     =           d+0*t183*t184*t185*t81-2.3669625486718335d-16*t175*t176
     >           *t177*t81+6.661338147750939d-16*t177*t18*t356*t79-1.929
     ?           8375398431045d+2*t14*t183*t360/t11**5+2.069040516770936
     @           4d+3*t14*t360/(t11**6*t12**3)+9.490883560204437d-19*t17
     1           *t358+4.1099018897499934d-3*t13*t358-1.0712750352598913
     2           d-14*t175*t18*t356/t15**5+5.742741051503565d-14*t18*t35
     3           6/(t15**6*t16**3)
              t362 = 1/t2**4
              t363 = 1/rhoa**9.666666666666666d+0
              t364 = 1/rhoa**8
              t365 = 1/rhoa**6.333333333333333d+0
              t366 = 1/rhoa**4.666666666666667d+0
              t367 = 1/t22**4
              t368 = 4.824593849607761d+1*t202*t203*t204*t42*t51
              t369 = -6.0d+0*t100*t202*t207*t42*t51
              t370 = -2.6513779981040353d-1*t100*t51*t96*t98*t99
              t371 = 3.0d+0*t100*t214*t42*t51*t99
              t372 = -5.19476882440587d+1*t216*t217*t218*t60*t61
              t373 = 3.5089341735807883d+0*t104*t216*t221*t60*t61
              t374 = 8.072185179299687d-2*t102*t103*t104*t61*t96
              t375 = -1.7544670867903941d+0*t103*t104*t224*t60*t61
              t376 = 1.856176655010858d+2*t226*t227*t228*t44*t45*t49*t66
              t377 = -1.1541966305589217d+1*t108*t226*t231*t44*t45*t49*t
     1           66
              t378 = -4.904166819946466d-1*t106*t107*t108*t131*t44*t49
              t379 = 5.770983152794609d+0*t107*t108*t234*t44*t45*t49*t66
              t380 = -4.616786522235687d+1*t106*t107*t108*t120*t44*t49*t
     1           66
              t381 = -1.099109305675375d-2*t212*t51*t58
              t382 = 1.8175185709928465d-3*t212*t61*t64
              t383 = -7.11545236961578d-2*t269*t44*t49*t69
              t384 = -3.588478118171826d+0*t253*t44*t49*t66*t69
              t385 = -2.1530868709030954d+0*t256*t45*t49*t66*t69
              t386 = t98**3
              t387 = 5.172601291927341d+2*t386*t42*t51/(t56**6*t57**3)
              t388 = -9.649187699215522d+1*t204*t386*t42*t51/t56**5
              t389 = 4.824593849607761d+1*t203*t204*t214*t42*t51*t98
              t390 = -2.1319703304396778d+0*t202*t203*t204*t51*t96
              t391 = 6.0d+0*t100*t203*t386*t42*t51
              t392 = -6.0d+0*t100*t207*t214*t42*t51*t98
              t393 = 2.6513779981040353d-1*t100*t202*t207*t51*t96
              t394 = -1.3256889990520176d-1*t100*t214*t51*t96*t99
              t395 = 1.767585332069357d-1*t100*t212*t51*t98*t99
              t396 = 1/t40**3.6666666666666664d+0
              t397 = 1/t53**7
              t398 = 1/t40**3.3333333333333337d+0
              t399 = 1/t40**3.1666666666666665d+0
              t400 = 1.0d+0*t100*(-2.520426340996149d+0*t399-2.307997918
     1           2303428d+0*t398-1.5008036906238065d+0*t397-5.6207535577
     2           70543d-1*t396)*t42*t51*t99
              t401 = t102**3
              t402 = -1.0254062650399592d+3*t401*t60*t61/(t62**6*t63**3)
              t403 = 1.0389537648811739d+2*t218*t401*t60*t61/t62**5
              t404 = -5.19476882440587d+1*t102*t217*t218*t224*t60*t61
              t405 = 1.1950391155803675d+0*t216*t217*t218*t61*t96
              t406 = -3.5089341735807883d+0*t104*t217*t401*t60*t61
              t407 = 3.5089341735807883d+0*t102*t104*t221*t224*t60*t61
              t408 = -8.072185179299687d-2*t104*t216*t221*t61*t96
              t409 = 4.0360925896498434d-2*t103*t104*t224*t61*t96
              t410 = -5.381456786199791d-2*t102*t103*t104*t212*t61
              t411 = -5.848223622634647d-1*t103*t104*(-3.436688601932293
     1           d+0*t399-2.3308360066730832d+0*t398-8.064323383643707d-
     2           1*t397-5.663741022599518d-1*t396)*t60*t61
              t412 = t106**3
              t413 = 3.9801326549115085d+3*t412*t44*t45*t49*t66/(t67**6*
     1           t68**3)
              t414 = -3.712353310021716d+2*t228*t412*t44*t45*t49*t66/t67
     1           **5
              t415 = 1.856176655010858d+2*t106*t227*t228*t234*t44*t45*t4
     1           9*t66
              t416 = -7.424706620043432d+2*t120*t226*t227*t228*t44*t49*t
     1           66
              t417 = -7.886871025654724d+0*t131*t226*t227*t228*t44*t49
              t418 = 1.1541966305589217d+1*t108*t227*t412*t44*t45*t49*t6
     1           6
              t419 = -1.1541966305589217d+1*t106*t108*t231*t234*t44*t45*
     1           t49*t66
              t420 = 4.616786522235687d+1*t108*t120*t226*t231*t44*t49*t6
     1           6
              t421 = 4.904166819946466d-1*t108*t131*t226*t231*t44*t49
              t422 = -2.452083409973233d-1*t107*t108*t131*t234*t44*t49
              t423 = 2.2886111826416838d+0*t106*t107*t108*t269*t44*t49
              t424 = 1.923661050931536d+0*t107*t108*(-4.684972743248224d
     1           +0*t399-3.9871442462415524d+0*t398-3.083875829189267d+0
     2           *t397-7.128507529742789d-1*t396)*t44*t45*t49*t66
              t425 = -2.3083932611178434d+1*t107*t108*t120*t234*t44*t49*
     1           t66
              t426 = 1.1541966305589217d+2*t106*t107*t108*t253*t44*t49*t
     1           66
              t427 = 6.925179783353531d+1*t106*t107*t108*t256*t45*t49*t6
     1           6
              t428 = 8.548627933030694d-3*t398*t51*t58
              t429 = 1/t47**1.6666666666666669d+0
              t430 = 6*t43*t45
              t431 = -6*t240
              t432 = 1/t48**1.6666666666666669d+0
              t433 = -6*t43*t45
              t434 = 6*t240
              t435 = 1.3333333333333333d+0*t117*(t434+t433)-2.9629629629
     1           62963d-1*t116**3*t432+1.3333333333333333d+0*t114*(t431+
     2           t430)-2.962962962962963d-1*t113**3*t429+1.3333333333333
     3           333d+0*t116*t245*t248+1.3333333333333333d+0*t113*t239*t
     4           243
              t436 = -1.923661050931536d+0*t435*t44*t45
              t437 = 2.3083932611178434d+1*t120*t249*t44
              t438 = -2.3083932611178434d+1*t122*t249*t45
              t439 = -1.1541966305589216d+2*t118*t253*t44
              t440 = 1.8467146088942746d+2*t118*t120*t122
              t441 = -6.925179783353531d+1*t118*t256*t45
              t442 = 1/t40**7
              t443 = 2.3083932611178432d+2*t44*t442*t49
              t444 = -4.6167865222356863d+2*t122*t253*t49
              t445 = 2.770071913341412d+2*t120*t256*t49
              t446 = -4.616786522235687d+1*t43*t45*t49
              t447 = -1.4136255552166585d-3*t398*t61*t64
              t448 = 2.0103976536374746d-1*t44*t49*t69/t40**7.3333333333
     1           33333d+0
              t449 = 9.148438760934575d-2*t131*t256*t49*t69
              t450 = 7.176956236343652d+0*t44*t442*t49*t66*t69
              t451 = 8.612347483612381d+0*t120*t256*t49*t66*t69
              t452 = -1.4353912472687305d+0*t43*t45*t49*t66*t69
              t453 = -1.243628d-1*t286*t42*t58
              t454 = 3.9503262643361536d-2*t287*t60*t64
              t455 = -1.1961593727239421d-1*t279*t44*t45*t66*t69
              t456 = 2.0d+0*t100*t286*t42*t98*t99
              t457 = -1.1696447245269295d+0*t102*t103*t104*t287*t60
              t458 = 3.847322101863072d+0*t106*t107*t108*t279*t44*t45*t6
     1           6
              t459 = -2.3083932611178434d+1*t106*t107*t108*t256*t45*t49*
     1           t66
              t460 = 5.495546528376875d-3*t286*t58*t96
              t461 = 1.5389288407452287d+1*t120*t279*t44
              t462 = -1.5389288407452287d+1*t122*t279*t45
              t463 = 1.3333333333333333d+0*t117*(t433+2*t240)-2.96296296
     1           2962963d-1*t150*t244*t432+1.3333333333333333d+0*t114*(t
     2           430-2*t240)+1.7777777777777776d+0*t116*t240*t245*t43-1.
     3           7777777777777776d+0*t113*t239*t240*t43-2.96296296296296
     4           3d-1*t149*t238*t429+4.444444444444444d-1*t150*t245*t248
     5           +4.444444444444444d-1*t149*t239*t243
              t464 = -1.923661050931536d+0*t44*t45*t463
              t465 = 7.694644203726144d+0*t120*t249*t44
              t466 = 7.694644203726144d+0*t122*t249*t45
              t467 = -3.8473221018630716d+1*t151*t253*t44
              t468 = 6.155715362980915d+1*t120*t122*t151
              t469 = -2.3083932611178434d+1*t151*t256*t45
              t470 = -7.694644203726143d+1*t118*t253*t44
              t471 = 4.616786522235687d+1*t118*t256*t45
              t472 = -1.5389288407452287d+2*t122*t253*t49
              t473 = -9.233573044471374d+1*t120*t256*t49
              t474 = 4.616786522235687d+1*t43*t45*t49
              t475 = -9.087592854964233d-4*t287*t64*t96
              t476 = 5.082465978296986d-3*t131*t279*t44*t69
              t477 = 4.7846374908957684d-1*t120*t279*t44*t66*t69
              t478 = -2.870782494537461d+0*t120*t256*t49*t66*t69
              t479 = 1.4353912472687305d+0*t43*t45*t49*t66*t69
              t480 = -8*t117*t43*t45+8*t114*t43*t45-2.962962962962963d-1
     1           *t116*t312*t432+1.7777777777777776d+0*t150*t240*t245*t4
     2           3-1.7777777777777776d+0*t149*t239*t240*t43-2.9629629629
     3           62963d-1*t113*t310*t429+4.444444444444444d-1*t116*t245*
     4           t313+4.444444444444444d-1*t113*t239*t311-2.666666666666
     5           6666d+0*t117*t240+2.6666666666666666d+0*t114*t240
              t481 = -1.923661050931536d+0*t44*t45*t480
              t482 = 1.5389288407452287d+1*t122*t279*t45
              t483 = 7.694644203726144d+0*t120*t314*t44
              t484 = -7.694644203726144d+0*t122*t314*t45
              t485 = -7.694644203726143d+1*t151*t253*t44
              t486 = 4.616786522235687d+1*t151*t256*t45
              t487 = -3.8473221018630716d+1*t118*t253*t44
              t488 = -6.155715362980915d+1*t118*t120*t122
              t489 = -2.3083932611178434d+1*t118*t256*t45
              t490 = 1.5389288407452287d+2*t122*t253*t49
              t491 = 1/rhob**11
              t492 = 1/rhob**8.333333333333334d+0
              t493 = 1/rhob**5.666666666666667d+0
              t494 = t143**3
              t495 = 1/t27**7
              t496 = 1/rhob**3.3333333333333337d+0
              t497 = 1/rhob**3.1666666666666665d+0
              t498 = t146**3
              t499 = 2.0690405167709364d+3*t34*t498/(t31**6*t32**3)-1.92
     1           98375398431045d+2*t300*t34*t498/t31**5+6.0d+0*t145*t302
     2           *t34*t498+1.1102230246251565d-16*t138*t144*t38*(-2.5204
     3           26340996149d+0*t497-2.3079979182303428d+0*t496-1.500803
     4           6906238065d+0*t495-5.620753557770543d-1*t160)+1.0d+0*t1
     5           45*t147*t34*(-4.684972743248224d+0*t497-3.9871442462415
     6           524d+0*t496-3.083875829189267d+0*t495-7.128507529742789
     7           d-1*t160)+9.490883560204437d-19*t37*t496+4.109901889749
     8           9934d-3*t33*t496+5.742741051503565d-14*t38*t494/(t35**6
     9           *t36**3)-1.0712750352598913d-14*t292*t38*t494/t35**5+6.
     :           661338147750939d-16*t138*t294*t38*t494-6.66133814775093
     ;           9d-16*t138*t143*t295*t299*t38+5.356375176299456d-15*t14
     <           3*t292*t294*t299*t38-6.0d+0*t145*t146*t303*t304*t34+9.6
     =           49187699215522d+1*t146*t300*t302*t304*t34-1.27469618870
     >           0087d-1*t141*t145*t147*t304+2.549392377400174d-1*t141*t
     ?           145*t301*t303-4.0999275947472624d+0*t141*t300*t301*t302
     @           -1.4718104502398274d-17*t138*t141*t144*t299+1.699594918
     1           2667827d-1*t145*t146*t147*t297+1.962413933653103d-17*t1
     2           38*t143*t144*t297+2.943620900479655d-17*t138*t141*t293*
     3           t295-2.3669625486718335d-16*t141*t292*t293*t294
              t500 = 1.3333333333333333d+0*t114*(t434+t430)+1.3333333333
     1           333333d+0*t117*(t433+t431)-2.962962962962963d-1*t150**3
     2           *t432-2.962962962962963d-1*t149**3*t429+1.3333333333333
     3           333d+0*t150*t245*t313+1.3333333333333333d+0*t149*t239*t
     4           311
              t501 = -1.923661050931536d+0*t44*t45*t500
              t502 = 2.3083932611178434d+1*t120*t314*t44
              t503 = 2.3083932611178434d+1*t122*t314*t45
              t504 = -1.1541966305589216d+2*t151*t253*t44
              t505 = -1.8467146088942746d+2*t120*t122*t151
              t506 = -6.925179783353531d+1*t151*t256*t45
              t507 = 4.6167865222356863d+2*t122*t253*t49
              t508 = 1/rhob**3
              t509 = gammabb**4
              t510 = 1/t72**4
              t511 = 1/rhob**1.3666666666666666d+1
              t512 = t170-1.25d-1*gammabb*t173*t39
              t513 = 1.25d-1*t148*t75
              t514 = 1.25d-1*t167*t39
              t515 = 1/rhob**1.2666666666666665d+1
              t516 = 2.5d-1*t173*t39
              t517 = 1/rhob**1.1666666666666665d+1
              t518 = 1/rhob**1.0666666666666666d+1
              fnc(iq) = (5.0d-1*rhob*t39*t75*t76*t78+1.0d+0*t25*t71+5.0d
     1           -1*rhoa*t19*t5)*wght+fnc(iq)
              Amat(iq,D1_RA) = (5.0d-1*rhoa*t19*t93+5.0d-1*rhoa*t5*t88+1
     1           .0d+0*t137*t71+5.0d-1*t19*t5+1.0d+0*t134*t25)*wght+Amat
     2           (iq,D1_RA)
              Amat(iq,D1_RB) = (t76*(5.0d-1*t39*t75*t78+5.0d-1*rhob*t148
     1           *t75*t78+5.0d-1*rhob*t167*t39*t78)+1.25d-1*gammabb*t39*
     2           t75*t76*t77+1.0d+0*t162*t71+1.0d+0*t159*t25)*wght+Amat(
     3           iq,D1_RB)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = (t76*(5.0d-1*rhob*t173*t39*t78+t170)+1.0
     1           d+0*t169*t71)*wght+Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = (1.0d+0*rhob*t39*t75*t76-5.0d-1*rhob*t174
     1           *t39*t75*t78)*wght+Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (1.0d+0*rhoa*t88*t93+1.0d+0*t19*t93+1
     1           .0d+0*t5*t88+1.0d+0*t278*t71+5.0d-1*rhoa*t188*t5+1.0d+0
     2           *t25*t275+5.0d-1*rhoa*t19*t194+2.0d+0*t134*t137)*wght+A
     3           mat2(iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = (1.0d+0*t291*t71+1.0d+0*t25*t289+1.0d
     1           +0*t134*t162+1.0d+0*t137*t159)*wght+Amat2(iq,D2_RA_RB)
              Amat2(iq,D2_RB_RB) = (t76*(5.0d-1*rhob*t305*t75*t78+1.0d+0
     1           *t148*t75*t78+5.0d-1*rhob*t340*t39*t78+1.0d+0*t167*t39*
     2           t78+1.0d+0*rhob*t148*t167*t78+1.25d-1*gammabb*t148*t75*
     3           t77+1.25d-1*gammabb*t167*t39*t77+1.25d-1*gammabb*t335*t
     4           39*t75)+(1.25d-1*gammabb*t148*t75+1.25d-1*gammabb*t167*
     5           t39)*t76*t77-1.25d-1*gammabb*t335*t39*t75*t76+1.0d+0*t3
     6           34*t71+1.0d+0*t25*t330+2.0d+0*t159*t162)*wght+Amat2(iq,
     7           D2_RB_RB)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = (1.0d+0*t342*t71+1.0d+0*t134*t169)*w
     1           ght+Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_RB_GAA) = Cmat2(iq,D2_RB_GAA)
              Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
              Cmat2(iq,D2_RB_GBB) = (t76*(5.0d-1*rhob*t348*t39*t78+5.0d-
     1           1*t173*t39*t78+5.0d-1*rhob*t148*t173*t78-1.25d-1*t39*t7
     2           5*t77-1.25d-1*t148*t75-1.25d-1*t167*t39)+(1.25d-1*gamma
     3           bb*t173*t39+t345)*t76*t77+1.0d+0*t344*t71+1.0d+0*t159*t
     4           169)*wght+Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
              Cmat2(iq,D2_GBB_GBB) = (t76*(5.0d-1*rhob*t353*t39*t78-2.5d
     1           -1*t173*t39)+1.0d+0*t350*t71)*wght+Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = (t174*(-5.0d-1*t39*t75*t78-5.0d-1*rho
     1           b*t148*t75*t78-5.0d-1*rhob*t167*t39*t78)-1.25d-1*gammab
     2           b*t174*t39*t75*t77+(1.0d+0*t39*t75+1.0d+0*rhob*t148*t75
     3           +1.0d+0*rhob*t167*t39)*t76)*wght+Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = (1.0d+0*rhob*t173*t39*t76+t174*t354)
     1           *wght+Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = (1.0d+0*rhob*t355*t39*t75*t78-2.0d+0*
     1           rhob*t174*t39*t75)*wght+Mmat2(iq,D2_TB_TB)
              Amat3(iq,D3_RA_RA_RA) = (1.0d+0*t25*(t40*(-2.6513779981040
     1           353d-1*t100*t124*t96*t98*t99+3.0d+0*t100*t258*t42*t98*t
     2           99+3.0d+0*t100*t124*t214*t42*t99-1.363138928244635d-3*t
     3           262*t64*t96+8.243319792565312d-3*t258*t58*t96+8.0721851
     4           79299687d-2*t102*t103*t104*t127*t96-1.4353912472687305d
     5           +1*t122*t253*t49*t66*t69-5.980796863619711d-2*t435*t44*
     6           t45*t66*t69-2.1530868709030954d+0*t118*t256*t45*t66*t69
     7           -7.176956236343652d-1*t122*t249*t45*t66*t69-3.588478118
     8           171826d+0*t118*t253*t44*t66*t69+7.176956236343652d-1*t1
     9           20*t249*t44*t66*t69+5.741564989074922d+0*t118*t120*t122
     :           *t66*t69-2.8461809478463124d-1*t122*t269*t49*t69-7.1154
     ;           5236961578d-2*t118*t269*t44*t69+7.623698967445479d-3*t1
     <           31*t249*t44*t69+6.098959173956384d-2*t118*t122*t131*t69
     =           +2.3083932611178434d+1*t107*t108*t122*t234*t45*t49*t66-
     >           4.616786522235687d+1*t108*t122*t226*t231*t45*t49*t66+7.
     ?           424706620043432d+2*t122*t226*t227*t228*t45*t49*t66-1.84
     @           67146088942746d+2*t106*t107*t108*t120*t122*t49*t66+5.77
     1           0983152794609d+0*t106*t107*t108*t249*t44*t45*t66+5.7709
     2           83152794609d+0*t107*t108*t118*t234*t44*t45*t66-1.154196
     3           6305589217d+1*t108*t118*t226*t231*t44*t45*t66+1.8561766
     4           55010858d+2*t118*t226*t227*t228*t44*t45*t66+4.616786522
     5           235687d+1*t106*t107*t108*t118*t122*t45*t66-4.6167865222
     6           35687d+1*t106*t107*t108*t118*t120*t44*t66+1.97516313216
     7           80768d-2*(t446+t445+t444+t443+t441+t440+t439+t438+t437+
     8           t436+1.923661050931536d+0*t435)*t60*t64+1.8175185709928
     9           465d-3*t127*t212*t64-1.7544670867903941d+0*t102*t103*t1
     :           04*t262*t60-1.7544670867903941d+0*t103*t104*t127*t224*t
     ;           60+3.5089341735807883d+0*t104*t127*t216*t221*t60-5.1947
     <           6882440587d+1*t127*t216*t217*t218*t60-6.21814d-2*t42*(t
     =           446+t445+t444+t443+t441+t440+t439+t438+t437+t436)*t58-1
     >           .099109305675375d-2*t124*t212*t58-1.9616667279785865d+0
     ?           *t106*t107*t108*t122*t131*t49+t452+t451+t450+t449+t448+
     @           t447-4.904166819946466d-1*t106*t107*t108*t118*t131*t44+
     1           t428+t427+t426+t425+t424+t423+t422+t421+t420-6.0d+0*t10
     2           0*t124*t202*t207*t42+4.824593849607761d+1*t124*t202*t20
     3           3*t204*t42+t419+t418+t417+t416+t415+t414+t413+t411+t410
     4           +t409+t408+t407+t406+t405+t404+t403+t402+t400+t395+t394
     5           +t393+t392+t391+t390+t389+t388+t387)+6.0d+0*t100*t124*t
     6           42*t98*t99-2.72627785648927d-3*t127*t64*t96+1.648663958
     7           5130625d-2*t124*t58*t96+2.549392377400174d-1*t81*t85*t8
     8           6*t87-3.0d+0*t14*t187*t85*t87+6.0d+0*t14*t184*t186*t85+
     9           2.943620900479655d-17*t79*t81*t83*t84-3.330669073875469
     :           6d-16*t18*t182*t79*t84+6.661338147750939d-16*t176*t178*
     ;           t18*t79+5.741564989074922d+0*t120*t122*t49*t66*t69-1.79
     <           4239059085913d-1*t249*t44*t45*t66*t69-1.435391247268730
     =           5d+0*t118*t122*t45*t66*t69+1.4353912472687305d+0*t118*t
     >           120*t44*t66*t69+6.098959173956384d-2*t122*t131*t49*t69+
     ?           1.524739793489096d-2*t118*t131*t44*t69+4.61678652223568
     @           7d+1*t106*t107*t108*t122*t45*t49*t66+1.1541966305589217
     1           d+1*t106*t107*t108*t118*t44*t45*t66+5.92548939650423d-2
     2           *t262*t60*t64-3.5089341735807883d+0*t102*t103*t104*t127
     3           *t60-1.865442d-1*t258*t42*t58+t385+t384+t383+t382+t381+
     4           t380+t379+t378+t377+t376+t375+t374+t373+t372+t371+t370+
     5           t369+t368-rhoa*t361-9.649187699215522d+1*t14*t183*t184*
     6           t185+1.2202564577405706d-18*t17*t180+5.284159572535705d
     7           -3*t13*t180-5.356375176299456d-15*t175*t176*t177*t18)+3
     8           .0d+0*t88*t93+1.5d+0*rhoa*t188*t93+5.0d-1*rhoa*t19*(-1.
     9           7279999999999998d-100*t191*t89*t92+3.2d-50*t192*t3*t92+
     :           2.3040000000000002d-151*t189*t190*t92-1.2d-50*t193*t3*t
     ;           91+2.88d-101*t193*t89*t90+2.4d-51*t1*t3*(7.778863044266
     <           666d-100*t365*t89-8.695883484444443d-50*t3*t366-2.21982
     =           18931199998d-150*t189*t364+2.04906636288d-201*t362*t363
     >           )+3.4986666666666666d-100*t365*t4*t89-3.911111111111111
     ?           d-50*t3*t366*t4-9.984000000000001d-151*t189*t364*t4+9.2
     @           16000000000001d-202*t362*t363*t4)+1.0d+0*t71*(-6.2d-52*
     1           t23*t277*t91+1.9219999999999998d-54*t135*t21*t277*t91+3
     2           .1d-3*t21*t23*(-1.8323128990207463d-156*t21*t364*t367+2
     3           .2552048033777775d-50*t23*t366-6.991134890471111d-53*t1
     4           35*t21*t366+2.3642747084138666d-104*t21*t276*t365-7.626
     5           692607786666d-102*t135*t365+5.910686771034666d-154*t276
     6           *t364)+1.641815111111111d-157*t21*t24*t364*t367-2.02074
     7           07407407404d-51*t23*t24*t366+6.264296296296294d-54*t135
     8           *t21*t24*t366-2.118471111111111d-105*t21*t24*t276*t365+
     9           6.833777777777776d-103*t135*t24*t365-5.296177777777777d
     :           -155*t24*t276*t364+7.944266666666666d-106*t136*t191*t21
     ;           *t276+1.6533333333333333d-51*t136*t192*t23-5.1253333333
     <           33332d-54*t135*t136*t192*t21-2.562666666666667d-103*t13
     =           5*t136*t191)+1.5d+0*rhoa*t194*t88+5.0d-1*rhoa*t361*t5+1
     >           .5d+0*t188*t5+3.0d+0*t134*t278+3.0d+0*t137*t275+1.5d+0*
     ?           t19*t194)*wght+Amat3(iq,D3_RA_RA_RA)
              Amat3(iq,D3_RA_RA_RB) = (1.0d+0*t25*(t40*(-8.8379266603467
     1           84d-2*t100*t154*t96*t98*t99-1.767585332069357d-1*t100*t
     2           124*t96*t98*t99+1.0d+0*t100*t258*t42*t98*t99+1.0d+0*t10
     3           0*t154*t214*t42*t99+2.0d+0*t100*t124*t214*t42*t99-4.543
     4           7964274821163d-4*t262*t64*t96+2.747773264188437d-3*t258
     5           *t58*t96+2.690728393099896d-2*t102*t103*t104*t156*t96+5
     6           .381456786199792d-2*t102*t103*t104*t127*t96-4.784637490
     7           8957684d+0*t122*t253*t49*t66*t69-5.980796863619711d-2*t
     8           44*t45*t463*t66*t69-4.7846374908957684d-1*t122*t279*t45
     9           *t66*t69-7.176956236343652d-1*t151*t256*t45*t66*t69+1.4
     :           353912472687305d+0*t118*t256*t45*t66*t69+2.392318745447
     ;           8842d-1*t122*t249*t45*t66*t69-1.1961593727239421d+0*t15
     <           1*t253*t44*t66*t69-2.3923187454478842d+0*t118*t253*t44*
     =           t66*t69+2.3923187454478842d-1*t120*t249*t44*t66*t69+1.9
     >           138549963583074d+0*t120*t122*t151*t66*t69-9.48726982615
     ?           4375d-2*t122*t269*t49*t69-3.049479586978192d-2*t131*t25
     @           6*t49*t69-2.3718174565385935d-2*t151*t269*t44*t69-4.743
     1           634913077187d-2*t118*t269*t44*t69+2.541232989148493d-3*
     2           t131*t249*t44*t69+2.0329863913187946d-2*t122*t131*t151*
     3           t69+7.694644203726144d+0*t107*t108*t122*t234*t45*t49*t6
     4           6-1.538928840745229d+1*t108*t122*t226*t231*t45*t49*t66+
     5           2.4749022066811444d+2*t122*t226*t227*t228*t45*t49*t66-6
     6           .155715362980916d+1*t106*t107*t108*t120*t122*t49*t66+1.
     7           923661050931536d+0*t106*t107*t108*t249*t44*t45*t66+1.92
     8           3661050931536d+0*t107*t108*t151*t234*t44*t45*t66+3.8473
     9           22101863072d+0*t107*t108*t118*t234*t44*t45*t66-3.847322
     :           101863072d+0*t108*t151*t226*t231*t44*t45*t66-7.69464420
     ;           3726144d+0*t108*t118*t226*t231*t44*t45*t66+6.1872555167
     <           02861d+1*t151*t226*t227*t228*t44*t45*t66+1.237451103340
     =           5722d+2*t118*t226*t227*t228*t44*t45*t66+1.5389288407452
     >           29d+1*t106*t107*t108*t122*t151*t45*t66-1.53892884074522
     ?           9d+1*t106*t107*t108*t120*t151*t44*t66-3.077857681490458
     @           d+1*t106*t107*t108*t118*t120*t44*t66+1.9751631321680768
     1           d-2*(t474+t473+t472+t471+t470+t469+t468+t467+t466+t465+
     2           t464+1.923661050931536d+0*t463+t462+t461+t443)*t60*t64+
     3           6.058395236642822d-4*t156*t212*t64+1.2116790473285642d-
     4           3*t127*t212*t64-5.848223622634647d-1*t102*t103*t104*t26
     5           2*t60-5.848223622634647d-1*t103*t104*t156*t224*t60-1.16
     6           96447245269295d+0*t103*t104*t127*t224*t60+1.16964472452
     7           69295d+0*t104*t156*t216*t221*t60+2.339289449053859d+0*t
     8           104*t127*t216*t221*t60-1.73158960813529d+1*t156*t216*t2
     9           17*t218*t60-3.46317921627058d+1*t127*t216*t217*t218*t60
     :           -6.21814d-2*t42*(t474+t473+t472+t471+t470+t469+t468+t46
     ;           7+t466+t465+t464+t462+t461+t443)*t58-3.663697685584583d
     <           -3*t154*t212*t58-7.327395371169166d-3*t124*t212*t58-6.5
     =           38889093261956d-1*t106*t107*t108*t122*t131*t49+t479+t47
     >           8+t477+t476+t475+t460+t459+t458+t457+t456+t450+t448+t44
     ?           7-1.6347222733154887d-1*t106*t107*t108*t131*t151*t44-3.
     @           2694445466309774d-1*t106*t107*t108*t118*t131*t44+t428+t
     1           426+t425+t424+t423+t422+t421+t420-2.0d+0*t100*t154*t202
     2           *t207*t42-4.0d+0*t100*t124*t202*t207*t42+1.608197949869
     3           2536d+1*t154*t202*t203*t204*t42+3.216395899738507d+1*t1
     4           24*t202*t203*t204*t42+t419+t418+t417+t416+t415+t414+t41
     5           3+t411+t410+t409+t408+t407+t406+t405+t404+t403+t402+t40
     6           0+t395+t394+t393+t392+t391+t390+t389+t388+t387)+4.0d+0*
     7           t100*t124*t42*t98*t99-1.8175185709928465d-3*t127*t64*t9
     8           6+1.099109305675375d-2*t124*t58*t96-4.7846374908957684d
     9           -1*t122*t151*t45*t66*t69+9.569274981791537d-1*t118*t120
     :           *t44*t66*t69+1.0164931956593973d-2*t118*t131*t44*t69+7.
     ;           694644203726144d+0*t106*t107*t108*t118*t44*t45*t66-2.33
     <           9289449053859d+0*t102*t103*t104*t127*t60+t455+t454+t453
     =           +t384+t383+t382+t381+t380+t379+t378+t377+t376+t375+t374
     >           +t373+t372+t371+t370+t369+t368+t327+t326+t324+t321+t308
     ?           +t307+t306+t288+t273+t271+t266+t263+t259+t237)+1.0d+0*t
     @           71*(-4.1333333333333333d-52*t23*t290*t91+1.281333333333
     1           3332d-54*t135*t21*t290*t91+2.1184711111111104d-56*gamma
     2           bb*t136*t160*t21*t276*t91-6.833777777777776d-54*gammabb
     3           *t135*t136*t160*t91+3.1d-3*t21*t23*(-7.329251596082985d
     4           -107*gammabb*t160*t191*t21*t367+3.1523662778851547d-55*
     5           gammabb*t160*t192*t21*t276+2.3642747084138663d-104*gamm
     6           abb*t160*t191*t276-1.0168923477048887d-52*gammabb*t135*
     7           t160*t192)+6.567260444444443d-108*gammabb*t160*t191*t21
     8           *t24*t367-8.266666666666665d-3*gammabb*t160*t23*t277+2.
     9           562666666666666d-5*gammabb*t135*t160*t21*t277-2.8246281
     :           48148147d-56*gammabb*t160*t192*t21*t24*t276-2.118471111
     ;           111111d-105*gammabb*t160*t191*t24*t276+2.64808888888888
     <           87d-106*t161*t191*t21*t276+9.111703703703702d-54*gammab
     =           b*t135*t160*t192*t24+5.51111111111111d-52*t161*t192*t23
     >           -1.708444444444444d-54*t135*t161*t192*t21-8.54222222222
     ?           2222d-104*t135*t161*t191)+2.0d+0*t134*t291+2.0d+0*t137*
     @           t289+1.0d+0*t159*t278+1.0d+0*t162*t275)*wght+Amat3(iq,D
     1           3_RA_RA_RB)
              Amat3(iq,D3_RA_RB_RB) = (1.0d+0*t25*(t40*(-1.7675853320693
     1           57d-1*t100*t154*t96*t98*t99-8.837926660346784d-2*t100*t
     2           124*t96*t98*t99+1.0d+0*t100*t319*t42*t98*t99+2.0d+0*t10
     3           0*t154*t214*t42*t99+1.0d+0*t100*t124*t214*t42*t99-4.543
     4           7964274821163d-4*t322*t64*t96+2.747773264188437d-3*t319
     5           *t58*t96+5.381456786199792d-2*t102*t103*t104*t156*t96+2
     6           .690728393099896d-2*t102*t103*t104*t127*t96+4.784637490
     7           8957684d+0*t122*t253*t49*t66*t69-5.980796863619711d-2*t
     8           44*t45*t480*t66*t69-2.3923187454478842d-1*t122*t314*t45
     9           *t66*t69+4.7846374908957684d-1*t122*t279*t45*t66*t69+1.
     :           4353912472687305d+0*t151*t256*t45*t66*t69-7.17695623634
     ;           3652d-1*t118*t256*t45*t66*t69+2.3923187454478842d-1*t12
     <           0*t314*t44*t66*t69-2.3923187454478842d+0*t151*t253*t44*
     =           t66*t69-1.1961593727239421d+0*t118*t253*t44*t66*t69-1.9
     >           138549963583074d+0*t118*t120*t122*t66*t69+9.48726982615
     ?           4374d-2*t122*t269*t49*t69-3.0494795869781915d-2*t131*t2
     @           56*t49*t69+2.541232989148493d-3*t131*t314*t44*t69-4.743
     1           634913077187d-2*t151*t269*t44*t69-2.3718174565385935d-2
     2           *t118*t269*t44*t69-2.0329863913187946d-2*t118*t122*t131
     3           *t69-7.694644203726144d+0*t107*t108*t122*t234*t45*t49*t
     4           66+1.538928840745229d+1*t108*t122*t226*t231*t45*t49*t66
     5           -2.4749022066811444d+2*t122*t226*t227*t228*t45*t49*t66+
     6           6.155715362980916d+1*t106*t107*t108*t120*t122*t49*t66+1
     7           .923661050931536d+0*t106*t107*t108*t314*t44*t45*t66+3.8
     8           47322101863072d+0*t107*t108*t151*t234*t44*t45*t66+1.923
     9           661050931536d+0*t107*t108*t118*t234*t44*t45*t66-7.69464
     :           4203726144d+0*t108*t151*t226*t231*t44*t45*t66-3.8473221
     ;           01863072d+0*t108*t118*t226*t231*t44*t45*t66+1.237451103
     <           3405722d+2*t151*t226*t227*t228*t44*t45*t66+6.1872555167
     =           02861d+1*t118*t226*t227*t228*t44*t45*t66-1.538928840745
     >           229d+1*t106*t107*t108*t118*t122*t45*t66-3.0778576814904
     ?           58d+1*t106*t107*t108*t120*t151*t44*t66-1.53892884074522
     @           9d+1*t106*t107*t108*t118*t120*t44*t66+1.975163132168076
     1           8d-2*(t490+t489+t488+t487+t486+t485+t484+t483+t482+t481
     2           +1.923661050931536d+0*t480+t473+t461+t446+t443)*t60*t64
     3           +1.2116790473285642d-3*t156*t212*t64+6.058395236642822d
     4           -4*t127*t212*t64-5.848223622634647d-1*t102*t103*t104*t3
     5           22*t60-1.1696447245269295d+0*t103*t104*t156*t224*t60-5.
     6           848223622634647d-1*t103*t104*t127*t224*t60+2.3392894490
     7           53859d+0*t104*t156*t216*t221*t60+1.1696447245269295d+0*
     8           t104*t127*t216*t221*t60-3.46317921627058d+1*t156*t216*t
     9           217*t218*t60-1.73158960813529d+1*t127*t216*t217*t218*t6
     :           0-6.21814d-2*t42*(t490+t489+t488+t487+t486+t485+t484+t4
     ;           83+t482+t481+t473+t461+t446+t443)*t58-7.327395371169166
     <           d-3*t154*t212*t58-3.663697685584583d-3*t124*t212*t58+6.
     =           538889093261955d-1*t106*t107*t108*t122*t131*t49+t478+t4
     >           77+t476+t475+t460+t459+t458+t457+t456+t452+t450+t448+t4
     ?           47-3.2694445466309774d-1*t106*t107*t108*t131*t151*t44-1
     @           .6347222733154887d-1*t106*t107*t108*t118*t131*t44+t428+
     1           t426+t425+t424+t423+t422+t421+t420-4.0d+0*t100*t154*t20
     2           2*t207*t42-2.0d+0*t100*t124*t202*t207*t42+3.21639589973
     3           8507d+1*t154*t202*t203*t204*t42+1.6081979498692536d+1*t
     4           124*t202*t203*t204*t42+t419+t418+t417+t416+t415+t414+t4
     5           13+t411+t410+t409+t408+t407+t406+t405+t404+t403+t402+t4
     6           00+t395+t394+t393+t392+t391+t390+t389+t388+t387)+4.0d+0
     7           *t100*t154*t42*t98*t99-1.8175185709928465d-3*t156*t64*t
     8           96+1.099109305675375d-2*t154*t58*t96+4.7846374908957684
     9           d-1*t118*t122*t45*t66*t69+9.569274981791537d-1*t120*t15
     :           1*t44*t66*t69+1.0164931956593973d-2*t131*t151*t44*t69+7
     ;           .694644203726144d+0*t106*t107*t108*t151*t44*t45*t66-2.3
     <           39289449053859d+0*t102*t103*t104*t156*t60+t455+t454+t45
     =           3+t384+t383+t382+t381+t380+t379+t378+t377+t376+t375+t37
     >           4+t373+t372+t371+t370+t369+t368+t329+t328+t325+t323+t32
     ?           0+t309+t288+t268+t267+t264+t260+t230+t220+t206)+1.0d+0*
     @           t71*(3.1d-3*t21*t23*(-2.931700638433194d-57*t163*t21*t3
     1           31*t367*t91+4.334503632092088d-55*gammabb*t21*t276*t332
     2           *t91-1.3982269780942222d-52*gammabb*t135*t332*t91+9.457
     3           098833655464d-55*t163*t276*t331*t91)+2.6269041777777763
     4           d-58*t163*t21*t24*t331*t367*t91-2.0666666666666667d-52*
     5           t23*t333*t91+6.406666666666666d-55*t135*t21*t333*t91-3.
     6           883863703703702d-56*gammabb*t21*t24*t276*t332*t91+1.252
     7           8592592592588d-53*gammabb*t135*t24*t332*t91-8.473884444
     8           444441d-56*t163*t24*t276*t331*t91+2.1184711111111104d-5
     9           6*gammabb*t160*t161*t21*t276*t91-6.833777777777776d-54*
     :           gammabb*t135*t160*t161*t91+3.0311111111111105d-2*gammab
     ;           b*t136*t23*t332-9.396444444444442d-5*gammabb*t135*t136*
     <           t21*t332+4.2369422222222203d-7*t136*t163*t21*t276*t331-
     =           1.366755555555555d-4*t135*t136*t163*t331-1.653333333333
     >           333d-2*gammabb*t160*t23*t290+5.125333333333332d-5*gamma
     ?           bb*t135*t160*t21*t290)+1.0d+0*t134*t334+1.0d+0*t137*t33
     @           0+2.0d+0*t159*t291+2.0d+0*t162*t289)*wght+Amat3(iq,D3_R
     1           A_RB_RB)
              Amat3(iq,D3_RB_RB_RB) = (1.0d+0*t25*(t40*(-2.6513779981040
     1           353d-1*t100*t154*t96*t98*t99+3.0d+0*t100*t319*t42*t98*t
     2           99+3.0d+0*t100*t154*t214*t42*t99-1.363138928244635d-3*t
     3           322*t64*t96+8.243319792565312d-3*t319*t58*t96+8.0721851
     4           79299687d-2*t102*t103*t104*t156*t96-5.980796863619711d-
     5           2*t44*t45*t500*t66*t69+1.4353912472687305d+1*t122*t253*
     6           t49*t66*t69+7.176956236343652d-1*t122*t314*t45*t66*t69-
     7           2.1530868709030954d+0*t151*t256*t45*t66*t69+7.176956236
     8           343652d-1*t120*t314*t44*t66*t69-3.588478118171826d+0*t1
     9           51*t253*t44*t66*t69-5.741564989074922d+0*t120*t122*t151
     :           *t66*t69+2.8461809478463124d-1*t122*t269*t49*t69+7.6236
     ;           98967445479d-3*t131*t314*t44*t69-7.11545236961578d-2*t1
     <           51*t269*t44*t69-6.098959173956384d-2*t122*t131*t151*t69
     =           -2.3083932611178434d+1*t107*t108*t122*t234*t45*t49*t66+
     >           4.616786522235687d+1*t108*t122*t226*t231*t45*t49*t66-7.
     ?           424706620043432d+2*t122*t226*t227*t228*t45*t49*t66+1.84
     @           67146088942746d+2*t106*t107*t108*t120*t122*t49*t66+5.77
     1           0983152794609d+0*t106*t107*t108*t314*t44*t45*t66+5.7709
     2           83152794609d+0*t107*t108*t151*t234*t44*t45*t66-1.154196
     3           6305589217d+1*t108*t151*t226*t231*t44*t45*t66+1.8561766
     4           55010858d+2*t151*t226*t227*t228*t44*t45*t66-4.616786522
     5           235687d+1*t106*t107*t108*t122*t151*t45*t66-4.6167865222
     6           35687d+1*t106*t107*t108*t120*t151*t44*t66+1.97516313216
     7           80768d-2*(t507+t506+t505+t504+t503+t502+t501+1.92366105
     8           0931536d+0*t500+t474+t445+t443)*t60*t64+1.8175185709928
     9           465d-3*t156*t212*t64-1.7544670867903941d+0*t102*t103*t1
     :           04*t322*t60-1.7544670867903941d+0*t103*t104*t156*t224*t
     ;           60+3.5089341735807883d+0*t104*t156*t216*t221*t60-5.1947
     <           6882440587d+1*t156*t216*t217*t218*t60-6.21814d-2*t42*(t
     =           507+t506+t505+t504+t503+t502+t501+t474+t445+t443)*t58-1
     >           .099109305675375d-2*t154*t212*t58+1.9616667279785865d+0
     ?           *t106*t107*t108*t122*t131*t49+t479+t451+t450+t449+t448+
     @           t447-4.904166819946466d-1*t106*t107*t108*t131*t151*t44+
     1           t428+t427+t426+t425+t424+t423+t422+t421+t420-6.0d+0*t10
     2           0*t154*t202*t207*t42+4.824593849607761d+1*t154*t202*t20
     3           3*t204*t42+t419+t418+t417+t416+t415+t414+t413+t411+t410
     4           +t409+t408+t407+t406+t405+t404+t403+t402+t400+t395+t394
     5           +t393+t392+t391+t390+t389+t388+t387)+6.0d+0*t100*t154*t
     6           42*t98*t99-2.72627785648927d-3*t156*t64*t96+1.648663958
     7           5130625d-2*t154*t58*t96-5.741564989074922d+0*t120*t122*
     8           t49*t66*t69-1.794239059085913d-1*t314*t44*t45*t66*t69+1
     9           .4353912472687305d+0*t122*t151*t45*t66*t69+1.4353912472
     :           687305d+0*t120*t151*t44*t66*t69-6.098959173956384d-2*t1
     ;           22*t131*t49*t69+1.524739793489096d-2*t131*t151*t44*t69-
     <           4.616786522235687d+1*t106*t107*t108*t122*t45*t49*t66+1.
     =           1541966305589217d+1*t106*t107*t108*t151*t44*t45*t66+5.9
     >           2548939650423d-2*t322*t60*t64-3.5089341735807883d+0*t10
     ?           2*t103*t104*t156*t60-1.865442d-1*t319*t42*t58-rhob*t499
     @           +t385+t384+t383+t382+t381+t380-3.3306690738754696d-16*t
     1           138*t144*t299*t38+6.661338147750939d-16*t138*t293*t295*
     2           t38-5.356375176299456d-15*t292*t293*t294*t38+t379+t378+
     3           t377+t376+t375+t374+t373+t372+t371+t370+1.2202564577405
     4           706d-18*t297*t37+t369+t368-3.0d+0*t145*t147*t304*t34+6.
     5           0d+0*t145*t301*t303*t34-9.649187699215522d+1*t300*t301*
     6           t302*t34+5.284159572535705d-3*t297*t33+2.54939237740017
     7           4d-1*t141*t145*t146*t147+2.943620900479655d-17*t138*t14
     8           1*t143*t144)+t76*(5.0d-1*rhob*t499*t75*t78+1.5d+0*t305*
     9           t75*t78+5.0d-1*rhob*t39*(-2.737777777777778d+0*gammabb*
     :           t493*t73*t74+1.4745599999999992d-3*t509*t510*t511*t74+7
     ;           .274666666666665d-1*t163*t164*t492*t74-5.83679999999999
     <           8d-2*t336*t337*t491*t74+6.0d-2*gammabb*t20*t73*(-6.0871
     =           1843911111d+0*gammabb*t493*t73+3.2785061806079985d-3*t5
     >           09*t510*t511+1.617434328106666d+0*t163*t164*t492-1.2977
     ?           420298239994d-1*t336*t337*t491)-4.799999999999999d-1*ga
     @           mmabb*t160*t339*t73+1.76d+0*gammabb*t166*t332*t73+2.879
     1           999999999999d-2*t163*t164*t165*t339+9.215999999999996d-
     2           3*t166*t336*t337*t338-2.5919999999999993d-1*t163*t164*t
     3           166*t331)*t78+1.5d+0*t340*t39*t78+1.5d+0*rhob*t148*t340
     4           *t78+1.5d+0*rhob*t167*t305*t78+3.0d+0*t148*t167*t78+2.5
     5           d-1*gammabb*t305*t75*t77+2.5d-1*gammabb*t340*t39*t77+5.
     6           0d-1*gammabb*t148*t167*t77-2.5d-1*gammabb*t39*t508*t75+
     7           2.5d-1*gammabb*t148*t335*t75+2.5d-1*gammabb*t167*t335*t
     8           39)+(1.25d-1*gammabb*t305*t75+1.25d-1*gammabb*t340*t39+
     9           2.5d-1*gammabb*t148*t167)*t76*t77+t335*(-2.5d-1*gammabb
     :           *t148*t75-2.5d-1*gammabb*t167*t39)*t76+2.5d-1*gammabb*t
     ;           39*t508*t75*t76+1.0d+0*(3.1d-3*t21*t23*(1.5786433623644
     <           444d+0*gammabb*t23*t493-4.8937944233297775d-3*gammabb*t
     =           135*t21*t493+5.201404358510505d-5*t163*t21*t276*t492-1.
     >           6778723737130663d-2*t135*t163*t492-1.1726802553732772d-
     ?           7*t21*t336*t367*t491+3.7828395334621856d-5*t276*t336*t4
     @           91)-1.4145185185185183d-1*gammabb*t23*t24*t493+4.385007
     1           4074074064d-4*gammabb*t135*t21*t24*t493-4.6606364444444
     2           426d-6*t163*t21*t24*t276*t492+1.5034311111111107d-3*t13
     3           5*t163*t24*t492+1.0507616711111105d-8*t21*t24*t336*t367
     4           *t491-3.389553777777776d-6*t24*t276*t336*t491-2.4799999
     5           999999994d-2*gammabb*t160*t23*t333+7.687999999999998d-5
     6           *gammabb*t135*t160*t21*t333+9.093333333333331d-2*gammab
     7           b*t161*t23*t332-2.818933333333332d-4*gammabb*t135*t161*
     8           t21*t332+1.271082666666666d-6*t161*t163*t21*t276*t331-4
     9           .100266666666665d-4*t135*t161*t163*t331)*t71+3.0d+0*t15
     :           9*t334+3.0d+0*t162*t330)*wght+Amat3(iq,D3_RB_RB_RB)
              Cmat3(iq,D3_RA_RA_GAA) = Cmat3(iq,D3_RA_RA_GAA)
              Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
              Cmat3(iq,D3_RA_RA_GBB) = (1.0d+0*t71*(-4.1333333333333333d
     1           -52*t23*t341*t91+1.2813333333333332d-54*t135*t21*t341*t
     2           91-7.944266666666666d-57*t136*t20*t21*t276*t91+2.562666
     3           6666666664d-54*t135*t136*t20*t91+3.1d-3*t21*t23*(2.7484
     4           693485311196d-107*t191*t20*t21*t367-1.1821373542069331d
     5           -55*t192*t20*t21*t276-8.866030156551999d-105*t191*t20*t
     6           276+3.813346303893333d-53*t135*t192*t20)-2.462722666666
     7           6663d-108*t191*t20*t21*t24*t367+3.1d-3*t20*t23*t277-9.6
     8           1d-6*t135*t20*t21*t277+1.0592355555555552d-56*t192*t20*
     9           t21*t24*t276+7.944266666666666d-106*t191*t20*t24*t276+2
     :           .6480888888888887d-106*t168*t191*t21*t276-3.41688888888
     ;           8888d-54*t135*t192*t20*t24+5.51111111111111d-52*t168*t1
     <           92*t23-1.708444444444444d-54*t135*t168*t192*t21-8.54222
     =           2222222222d-104*t135*t168*t191)+2.0d+0*t134*t342+1.0d+0
     >           *t169*t275)*wght+Cmat3(iq,D3_RA_RA_GBB)
              Cmat3(iq,D3_RA_RB_GAA) = Cmat3(iq,D3_RA_RB_GAA)
              Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
              Cmat3(iq,D3_RA_RB_GBB) = (1.0d+0*t71*(3.1d-3*t21*t23*(1.09
     1           93877394124477d-57*gammabb*t165*t21*t367*t91-1.18213735
     2           42069331d-55*t160*t21*t276*t91-3.5464120626207996d-55*g
     3           ammabb*t165*t276*t91+3.813346303893333d-53*t135*t160*t9
     4           1)-9.850890666666663d-59*gammabb*t165*t21*t24*t367*t91-
     5           2.0666666666666667d-52*t23*t343*t91+6.406666666666666d-
     6           55*t135*t21*t343*t91+1.0592355555555552d-56*t160*t21*t2
     7           4*t276*t91+3.177706666666666d-56*gammabb*t165*t24*t276*
     8           t91-3.972133333333333d-57*t161*t20*t21*t276*t91+1.05923
     9           55555555552d-56*gammabb*t160*t168*t21*t276*t91-3.416888
     :           888888888d-54*t135*t160*t24*t91+1.2813333333333332d-54*
     ;           t135*t161*t20*t91-3.416888888888888d-54*gammabb*t135*t1
     <           60*t168*t91-8.266666666666665d-3*gammabb*t160*t23*t341+
     =           2.562666666666666d-5*gammabb*t135*t160*t21*t341+3.1d-3*
     >           t20*t23*t290-9.61d-6*t135*t20*t21*t290-1.58885333333333
     ?           27d-7*gammabb*t136*t165*t21*t276-8.266666666666665d-3*t
     @           136*t160*t23+2.562666666666666d-5*t135*t136*t160*t21+5.
     1           125333333333332d-5*gammabb*t135*t136*t165)+1.0d+0*t134*
     2           t344+1.0d+0*t159*t342+1.0d+0*t169*t289)*wght+Cmat3(iq,D
     3           3_RA_RB_GBB)
              Cmat3(iq,D3_RB_RB_GAA) = Cmat3(iq,D3_RB_RB_GAA)
              Cmat3(iq,D3_RB_RB_GAB) = Cmat3(iq,D3_RB_RB_GAB)
              Cmat3(iq,D3_RB_RB_GBB) = (t76*(5.0d-1*rhob*t39*(5.86666666
     1           6666666d-1*t332*t73*t74-5.529599999999998d-4*t336*t510*
     2           t515*t74+1.9583999999999993d-2*t163*t337*t338*t74-2.079
     3           9999999999996d-1*gammabb*t164*t331*t74+6.0d-2*gammabb*t
     4           20*t73*(1.3043825226666664d+0*t332*t73-1.22943981772799
     5           94d-3*t336*t510*t515+4.3542660211199985d-2*t163*t337*t3
     6           38-4.624628943999999d-1*gammabb*t164*t331)-3.1999999999
     7           999995d-1*gammabb*t160*t347*t73+6.0d-2*t20*t339*t73+5.8
     8           66666666666666d-1*gammabb*t172*t332*t73-3.1999999999999
     9           995d-1*t160*t166*t73+1.9199999999999995d-2*t163*t164*t1
     :           65*t347-2.303999999999999d-3*t163*t166*t337*t346-3.6d-3
     ;           *gammabb*t164*t171*t339+3.0719999999999986d-3*t172*t336
     <           *t337*t338-8.639999999999998d-2*t163*t164*t172*t331+5.7
     =           59999999999998d-2*gammabb*t164*t165*t166)*t78+1.0d+0*t3
     >           48*t39*t78+1.0d+0*rhob*t148*t348*t78+5.0d-1*rhob*t173*t
     ?           305*t78+1.0d+0*t148*t173*t78-1.25d-1*t148*t75*t77+1.25d
     @           -1*gammabb*t348*t39*t77-1.25d-1*t167*t39*t77+1.25d-1*ga
     1           mmabb*t148*t173*t77+1.25d-1*t335*t39*t75-1.25d-1*t305*t
     2           75-1.25d-1*t340*t39+1.25d-1*gammabb*t173*t335*t39-2.5d-
     3           1*t148*t167)+(t514+t513+1.25d-1*gammabb*t348*t39+1.25d-
     4           1*gammabb*t148*t173)*t76*t77+t335*t512*t76+1.0d+0*(3.1d
     5           -3*t21*t23*(4.3975509576497906d-8*t163*t21*t338*t367-1.
     6           4185648250483196d-5*t163*t276*t338-3.3828072050666663d-
     7           1*t23*t332+1.0486702335706666d-3*t135*t21*t332-1.595885
     8           4281793597d-5*gammabb*t21*t276*t331+5.148017510255999d-
     9           3*gammabb*t135*t331)-3.9403562666666647d-9*t163*t21*t24
     :           *t338*t367-1.653333333333333d-2*gammabb*t160*t23*t343+5
     ;           .125333333333332d-5*gammabb*t135*t160*t21*t343+1.271082
     <           666666666d-6*t163*t24*t276*t338+3.1d-3*t20*t23*t333-9.6
     =           1d-6*t135*t20*t21*t333+3.0311111111111105d-2*t23*t24*t3
     >           32-9.396444444444442d-5*t135*t21*t24*t332+3.03111111111
     ?           11105d-2*gammabb*t168*t23*t332-9.396444444444442d-5*gam
     @           mabb*t135*t168*t21*t332+1.4299679999999995d-6*gammabb*t
     1           21*t24*t276*t331+4.2369422222222203d-7*t163*t168*t21*t2
     2           76*t331-4.612799999999999d-4*gammabb*t135*t24*t331-1.36
     3           6755555555555d-4*t135*t163*t168*t331-3.1777066666666653
     4           d-7*gammabb*t161*t165*t21*t276-1.653333333333333d-2*t16
     5           0*t161*t23+5.125333333333332d-5*t135*t160*t161*t21+1.02
     6           50666666666663d-4*gammabb*t135*t161*t165)*t71+2.0d+0*t1
     7           59*t344+1.0d+0*t169*t330)*wght+Cmat3(iq,D3_RB_RB_GBB)
              Cmat3(iq,D3_RA_GAA_GAA) = Cmat3(iq,D3_RA_GAA_GAA)
              Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
              Cmat3(iq,D3_RA_GAA_GBB) = Cmat3(iq,D3_RA_GAA_GBB)
              Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
              Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
              Cmat3(iq,D3_RA_GBB_GBB) = (1.0d+0*t71*(3.1d-3*t21*t23*(1.3
     1           299045234828d-55*t171*t276*t91-4.12270402279668d-58*t17
     2           1*t21*t367*t91)+3.6940839999999997d-59*t171*t21*t24*t36
     3           7*t91-2.0666666666666667d-52*t23*t349*t91+6.40666666666
     4           6666d-55*t135*t21*t349*t91-1.1916399999999998d-56*t171*
     5           t24*t276*t91-7.944266666666666d-57*t168*t20*t21*t276*t9
     6           1+2.5626666666666664d-54*t135*t168*t20*t91+6.2d-3*t20*t
     7           23*t341-1.9219999999999998d-5*t135*t20*t21*t341+5.9582d
     8           -8*t136*t171*t21*t276-1.9219999999999998d-5*t135*t136*t
     9           171)+1.0d+0*t134*t350)*wght+Cmat3(iq,D3_RA_GBB_GBB)
              Cmat3(iq,D3_RB_GAA_GAA) = Cmat3(iq,D3_RB_GAA_GAA)
              Cmat3(iq,D3_RB_GAA_GAB) = Cmat3(iq,D3_RB_GAA_GAB)
              Cmat3(iq,D3_RB_GAA_GBB) = Cmat3(iq,D3_RB_GAA_GBB)
              Cmat3(iq,D3_RB_GAB_GAB) = Cmat3(iq,D3_RB_GAB_GAB)
              Cmat3(iq,D3_RB_GAB_GBB) = Cmat3(iq,D3_RB_GAB_GBB)
              Cmat3(iq,D3_RB_GBB_GBB) = (t76*(5.0d-1*rhob*t39*(2.0735999
     1           99999999d-4*t163*t510*t517*t74-5.759999999999997d-3*gam
     2           mabb*t337*t346*t74+3.839999999999999d-2*t164*t165*t74+6
     3           .0d-2*gammabb*t20*(4.6103993164799983d-4*t163*t510*t517
     4           -1.2806664767999995d-2*gammabb*t337*t346+8.537776511999
     5           997d-2*t164*t165)*t73-1.5999999999999998d-1*gammabb*t16
     6           0*t352*t73+1.2d-1*t20*t347*t73-3.1999999999999995d-1*t1
     7           60*t172*t73+9.599999999999997d-3*t163*t164*t165*t352+4.
     8           32d-4*gammabb*t166*t337*t351-7.2d-3*gammabb*t164*t171*t
     9           347-2.303999999999999d-3*t163*t172*t337*t346+5.75999999
     :           9999998d-2*gammabb*t164*t165*t172-7.2d-3*t164*t166*t171
     ;           )*t78+5.0d-1*t353*t39*t78+5.0d-1*rhob*t148*t353*t78-2.5
     <           d-1*t173*t39*t77-2.5d-1*t348*t39-2.5d-1*t148*t173)+(t51
     =           6+1.25d-1*gammabb*t353*t39)*t76*t77+1.0d+0*(3.1d-3*t21*
     >           t23*(-1.6490816091186716d-8*gammabb*t21*t346*t367+5.319
     ?           618093931199d-6*gammabb*t276*t346+3.5464120626207996d-6
     @           *t165*t21*t276-1.1440038911679998d-3*t135*t165)+1.47763
     1           35999999993d-9*gammabb*t21*t24*t346*t367-8.266666666666
     2           665d-3*gammabb*t160*t23*t349+2.562666666666666d-5*gamma
     3           bb*t135*t160*t21*t349-4.766559999999998d-7*gammabb*t24*
     4           t276*t346+6.2d-3*t20*t23*t343-1.9219999999999998d-5*t13
     5           5*t20*t21*t343-3.1777066666666653d-7*t165*t21*t24*t276+
     6           5.9582d-8*t161*t171*t21*t276-3.1777066666666653d-7*gamm
     7           abb*t165*t168*t21*t276+1.0250666666666663d-4*t135*t165*
     8           t24-1.653333333333333d-2*t160*t168*t23+5.12533333333333
     9           2d-5*t135*t160*t168*t21-1.9219999999999998d-5*t135*t161
     :           *t171+1.0250666666666663d-4*gammabb*t135*t165*t168)*t71
     ;           +1.0d+0*t159*t350)*wght+Cmat3(iq,D3_RB_GBB_GBB)
              Cmat3(iq,D3_GAA_GAA_GAA) = Cmat3(iq,D3_GAA_GAA_GAA)
              Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
              Cmat3(iq,D3_GAA_GAA_GBB) = Cmat3(iq,D3_GAA_GAA_GBB)
              Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
              Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
              Cmat3(iq,D3_GAA_GBB_GBB) = Cmat3(iq,D3_GAA_GBB_GBB)
              Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
              Cmat3(iq,D3_GAB_GAB_GBB) = Cmat3(iq,D3_GAB_GAB_GBB)
              Cmat3(iq,D3_GAB_GBB_GBB) = Cmat3(iq,D3_GAB_GBB_GBB)
              Cmat3(iq,D3_GBB_GBB_GBB) = (t76*(5.0d-1*rhob*t39*(-7.776d-
     1           5*gammabb*t510*t518*t74+1.296d-3*t337*t351*t74+6.0d-2*g
     2           ammabb*t20*(2.881499572799999d-3*t337*t351-1.7288997436
     3           799997d-4*gammabb*t510*t518)*t73+1.8d-1*t20*t352*t73-1.
     4           0800000000000001d-2*gammabb*t164*t171*t352+1.296d-3*gam
     5           mabb*t172*t337*t351-2.1600000000000003d-2*t164*t171*t17
     6           2)*t78-3.75d-1*t353*t39)+1.0d+0*(3.1d-3*t21*t23*(6.1840
     7           56034195019d-9*t21*t351*t367-1.9948567852242d-6*t276*t3
     8           51)-5.541126d-10*t21*t24*t351*t367+1.78746d-7*t24*t276*
     9           t351+9.299999999999999d-3*t20*t23*t349-2.883d-5*t135*t2
     :           0*t21*t349+1.78746d-7*t168*t171*t21*t276-5.766d-5*t135*
     ;           t168*t171)*t71)*wght+Cmat3(iq,D3_GBB_GBB_GBB)
              Mmat3(iq,D3_RA_RA_TA) = Mmat3(iq,D3_RA_RA_TA)
              Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
              Mmat3(iq,D3_RA_RB_TA) = Mmat3(iq,D3_RA_RB_TA)
              Mmat3(iq,D3_RA_RB_TB) = Mmat3(iq,D3_RA_RB_TB)
              Mmat3(iq,D3_RB_RB_TA) = Mmat3(iq,D3_RB_RB_TA)
              Mmat3(iq,D3_RB_RB_TB) = (t174*(-5.0d-1*rhob*t305*t75*t78-1
     1           .0d+0*t148*t75*t78-5.0d-1*rhob*t340*t39*t78-1.0d+0*t167
     2           *t39*t78-1.0d+0*rhob*t148*t167*t78-1.25d-1*gammabb*t148
     3           *t75*t77-1.25d-1*gammabb*t167*t39*t77-1.25d-1*gammabb*t
     4           335*t39*t75)+t174*(-1.25d-1*gammabb*t148*t75-1.25d-1*ga
     5           mmabb*t167*t39)*t77+(1.0d+0*rhob*t305*t75+2.0d+0*t148*t
     6           75+1.0d+0*rhob*t340*t39+2.0d+0*t167*t39+2.0d+0*rhob*t14
     7           8*t167)*t76+1.25d-1*gammabb*t174*t335*t39*t75)*wght+Mma
     8           t3(iq,D3_RB_RB_TB)
              Mmat3(iq,D3_RA_GAA_TA) = Mmat3(iq,D3_RA_GAA_TA)
              Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
              Mmat3(iq,D3_RA_GAB_TA) = Mmat3(iq,D3_RA_GAB_TA)
              Mmat3(iq,D3_RA_GAB_TB) = Mmat3(iq,D3_RA_GAB_TB)
              Mmat3(iq,D3_RA_GBB_TA) = Mmat3(iq,D3_RA_GBB_TA)
              Mmat3(iq,D3_RA_GBB_TB) = Mmat3(iq,D3_RA_GBB_TB)
              Mmat3(iq,D3_RB_GAA_TA) = Mmat3(iq,D3_RB_GAA_TA)
              Mmat3(iq,D3_RB_GAA_TB) = Mmat3(iq,D3_RB_GAA_TB)
              Mmat3(iq,D3_RB_GAB_TA) = Mmat3(iq,D3_RB_GAB_TA)
              Mmat3(iq,D3_RB_GAB_TB) = Mmat3(iq,D3_RB_GAB_TB)
              Mmat3(iq,D3_RB_GBB_TA) = Mmat3(iq,D3_RB_GBB_TA)
              Mmat3(iq,D3_RB_GBB_TB) = (t174*(-5.0d-1*rhob*t348*t39*t78-
     1           5.0d-1*t173*t39*t78-5.0d-1*rhob*t148*t173*t78+1.25d-1*t
     2           39*t75*t77+t514+t513)+t174*t512*t77+(1.0d+0*rhob*t348*t
     3           39+1.0d+0*t173*t39+1.0d+0*rhob*t148*t173)*t76)*wght+Mma
     4           t3(iq,D3_RB_GBB_TB)
              Mmat3(iq,D3_RA_TA_TA) = Mmat3(iq,D3_RA_TA_TA)
              Mmat3(iq,D3_RA_TA_TB) = Mmat3(iq,D3_RA_TA_TB)
              Mmat3(iq,D3_RA_TB_TB) = Mmat3(iq,D3_RA_TB_TB)
              Mmat3(iq,D3_RB_TA_TA) = Mmat3(iq,D3_RB_TA_TA)
              Mmat3(iq,D3_RB_TA_TB) = Mmat3(iq,D3_RB_TA_TB)
              Mmat3(iq,D3_RB_TB_TB) = Mmat3(iq,D3_RB_TB_TB)
              Mmat3(iq,D3_GAA_GAA_TA) = Mmat3(iq,D3_GAA_GAA_TA)
              Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
              Mmat3(iq,D3_GAA_GAB_TA) = Mmat3(iq,D3_GAA_GAB_TA)
              Mmat3(iq,D3_GAA_GAB_TB) = Mmat3(iq,D3_GAA_GAB_TB)
              Mmat3(iq,D3_GAA_GBB_TA) = Mmat3(iq,D3_GAA_GBB_TA)
              Mmat3(iq,D3_GAA_GBB_TB) = (t174*(t516-5.0d-1*rhob*t353*t39
     1           *t78)+1.0d+0*rhob*t353*t39*t76)*wght+Mmat3(iq,D3_GAA_GB
     2           B_TB)
              Mmat3(iq,D3_GAB_GAB_TA) = Mmat3(iq,D3_GAB_GAB_TA)
              Mmat3(iq,D3_GAB_GAB_TB) = Mmat3(iq,D3_GAB_GAB_TB)
              Mmat3(iq,D3_GAB_GBB_TA) = Mmat3(iq,D3_GAB_GBB_TA)
              Mmat3(iq,D3_GAB_GBB_TB) = Mmat3(iq,D3_GAB_GBB_TB)
              Mmat3(iq,D3_GBB_GBB_TA) = Mmat3(iq,D3_GBB_GBB_TA)
              Mmat3(iq,D3_GBB_GBB_TB) = Mmat3(iq,D3_GBB_GBB_TB)
              Mmat3(iq,D3_GAA_TA_TA) = Mmat3(iq,D3_GAA_TA_TA)
              Mmat3(iq,D3_GAA_TA_TB) = Mmat3(iq,D3_GAA_TA_TB)
              Mmat3(iq,D3_GAA_TB_TB) = (-2.0d+0*rhob*t173*t174*t39-2*t35
     1           4*t355)*wght+Mmat3(iq,D3_GAA_TB_TB)
              Mmat3(iq,D3_GAB_TA_TA) = Mmat3(iq,D3_GAB_TA_TA)
              Mmat3(iq,D3_GAB_TA_TB) = Mmat3(iq,D3_GAB_TA_TB)
              Mmat3(iq,D3_GAB_TB_TB) = Mmat3(iq,D3_GAB_TB_TB)
              Mmat3(iq,D3_GBB_TA_TA) = (6.0d+0*rhob*t355*t39*t75-3.0d+0*
     1           rhob*t39*t75*t78/taub**4)*wght+Mmat3(iq,D3_GBB_TA_TA)
            else 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 2.4d-51*t1+1.0d+0
              t3 = 1/t2
              t4 = 5.336110319999999d-51*t1*t3-2.5960897d+0
              t5 = 2.4d-51*t1*t3*t4+1.0d+0
              t6 = 1/rhoa**6.666666666666666d-1
              t7 = rhoa**5.0d-1
              t8 = 1/t7
              t9 = 1/rhoa**3.333333333333333d-1
              t10 = 1/rhoa**1.6666666666666666d-1
              t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.4
     1           058712912881916d-1*t6+1.1120374863094686d+1*t10
              t12 = 3.216395899738507d+1/t11+1.0d+0
              t13 = log(t12)
              t14 = 1.274696188700087d-1*t9+1.0d+0
              t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.8
     1           970043257475583d-1*t6+5.982550435771079d+0*t10
              t16 = 1.6081979498692536d+1/t15+1.0d+0
              t17 = log(t16)
              t18 = 1.3256889990520176d-1*t9+1.0d+0
              t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2
     1           *t13*t14
              t20 = 1/rhob**1.6666666666666669d+0
              t21 = 2.4d-51*t20+1.0d+0
              t22 = 1/t21
              t23 = 5.336110319999999d-51*t20*t22-2.5960897d+0
              t24 = 2.4d-51*t20*t22*t23+1.0d+0
              t25 = 1/rhob**6.666666666666666d-1
              t26 = rhob**5.0d-1
              t27 = 1/t26
              t28 = 1/rhob**3.333333333333333d-1
              t29 = 1/rhob**1.6666666666666666d-1
              t30 = 1.1120374863094686d+1*t29+3.8447462374472113d+0*t28+
     1           1.644733775567609d+0*t27+2.4058712912881916d-1*t25
              t31 = 3.216395899738507d+1/t30+1.0d+0
              t32 = log(t31)
              t33 = 1.274696188700087d-1*t28+1.0d+0
              t34 = 5.982550435771079d+0*t29+2.2255694211506874d+0*t28+8
     1           .004286349993635d-1*t27+1.8970043257475583d-1*t25
              t35 = 1.6081979498692536d+1/t34+1.0d+0
              t36 = log(t35)
              t37 = 1.3256889990520176d-1*t28+1.0d+0
              t38 = -6.903522198342671d-18*t36*t37-3.1090699999999993d-2
     1           *t32*t33
              t39 = 4.0d-50*t20+4.0d-50*t1
              t40 = 3.1d-3*t39+1.0d+0
              t41 = 1/t40
              t42 = 5.9515308d+0-3.459689187d-2*t39*t41
              t43 = 3.1d-3*t39*t41*t42+1.0d+0
              t44 = rhob+rhoa
              t45 = 1/t44**3.333333333333333d-1
              t46 = 1.3256889990520176d-1*t45+1.0d+0
              t47 = rhoa-rhob
              t48 = t47**4
              t49 = 1/t44**4
              t50 = 1/t44
              t51 = 1.0d+0-t47*t50
              t52 = t47*t50+1.0d+0
              t53 = t52**1.3333333333333333d+0+t51**1.3333333333333333d+
     1           0-2.0d+0
              t54 = -1.923661050931536d+0*t48*t49*t53
              t55 = t54+1.0d+0
              t56 = 1/t44**6.666666666666666d-1
              t57 = t44**5.0d-1
              t58 = 1/t57
              t59 = 1/t44**1.6666666666666666d-1
              t60 = 5.982550435771079d+0*t59+8.004286349993635d-1*t58+1.
     1           8970043257475583d-1*t56+2.2255694211506874d+0*t45
              t61 = 1.6081979498692536d+1/t60+1.0d+0
              t62 = log(t61)
              t63 = -6.21814d-2*t46*t55*t62
              t64 = 6.901399211255825d-2*t45+1.0d+0
              t65 = t54+1.923661050931536d+0*t53
              t66 = 8.157414703487641d+0*t59+4.3009724712766434d-1*t58+1
     1           .9115125951273373d-1*t56+2.247591863577616d+0*t45
              t67 = 2.9608813203268075d+1/t66+1.0d+0
              t68 = log(t67)
              t69 = 1.9751631321680768d-2*t64*t65*t68
              t70 = 1.274696188700087d-1*t45+1.0d+0
              t71 = 1.1120374863094686d+1*t59+1.644733775567609d+0*t58+2
     1           .4058712912881916d-1*t56+3.8447462374472113d+0*t45
              t72 = 3.216395899738507d+1/t71+1.0d+0
              t73 = log(t72)
              t74 = -5.980796863619711d-2*t48*t49*t53*t70*t73
              t75 = t44*(t74+t69+t63)-rhob*t38-rhoa*t19
              t76 = 1/t16
              t77 = 1/t7**3
              t78 = 1/rhoa**1.3333333333333333d+0
              t79 = 1/rhoa**1.1666666666666667d+0
              t80 = -9.970917392951799d-1*t79-7.418564737168958d-1*t78-4
     1           .002143174996817d-1*t77-1.264669550498372d-1*t1
              t81 = 1/t15**2
              t82 = 1/t12
              t83 = -1.8533958105157808d+0*t79-1.2815820791490704d+0*t78
     1           -8.223668877838045d-1*t77-1.6039141941921276d-1*t1
              t84 = 1/t11**2
              t85 = 1.0d+0*t14*t82*t83*t84+1.1102230246251565d-16*t18*t7
     1           6*t80*t81+3.0506411443514264d-19*t17*t78+1.321039893133
     2           9265d-3*t13*t78
              t86 = 1/t2**2
              t87 = 1/rhoa**4.333333333333333d+0
              t88 = 1/rhoa**2.6666666666666666d+0
              t89 = 2.134444128d-101*t86*t87-8.8935172d-51*t3*t88
              t90 = 2.4d-51*t1*t3*t89-4.0d-51*t3*t4*t88+9.6d-102*t4*t86*
     1           t87
              t91 = 1/t44**1.6666666666666669d+0
              t92 = 1/t57**3
              t93 = 1/t44**1.3333333333333333d+0
              t94 = 1/t44**1.1666666666666667d+0
              t95 = -9.970917392951799d-1*t94-7.418564737168958d-1*t93-4
     1           .002143174996817d-1*t92-1.264669550498372d-1*t91
              t96 = 1/t60**2
              t97 = 1/t61
              t98 = 1.0d+0*t46*t55*t95*t96*t97
              t99 = -1.3595691172479402d+0*t94-7.491972878592053d-1*t93-
     1           2.1504862356383217d-1*t92-1.2743417300848914d-1*t91
              t100 = 1/t66**2
              t101 = 1/t67
              t102 = -5.848223622634647d-1*t100*t101*t64*t65*t99
              t103 = -1.8533958105157808d+0*t94-1.2815820791490704d+0*t9
     1           3-8.223668877838045d-1*t92-1.6039141941921276d-1*t91
              t104 = 1/t71**2
              t105 = 1/t72
              t106 = 1.923661050931536d+0*t103*t104*t105*t48*t49*t53*t70
              t107 = 1/t44**2
              t108 = t107*t47
              t109 = -t50
              t110 = t109+t108
              t111 = t51**3.333333333333333d-1
              t112 = -t107*t47
              t113 = t50+t112
              t114 = t52**3.333333333333333d-1
              t115 = 1.3333333333333333d+0*t113*t114+1.3333333333333333d
     1           +0*t110*t111
              t116 = -1.923661050931536d+0*t115*t48*t49
              t117 = 1/t44**5
              t118 = 7.694644203726144d+0*t117*t48*t53
              t119 = t47**3
              t120 = -7.694644203726144d+0*t119*t49*t53
              t121 = t120+t118+t116
              t122 = -6.21814d-2*t121*t46*t62
              t123 = 2.747773264188437d-3*t55*t62*t93
              t124 = t120+t118+t116+1.923661050931536d+0*t115
              t125 = 1.9751631321680768d-2*t124*t64*t68
              t126 = -4.5437964274821163d-4*t65*t68*t93
              t127 = -5.980796863619711d-2*t115*t48*t49*t70*t73
              t128 = 1/t44**5.333333333333333d+0
              t129 = 2.541232989148493d-3*t128*t48*t53*t73
              t130 = 2.3923187454478842d-1*t117*t48*t53*t70*t73
              t131 = t44*(t98-2.3923187454478842d-1*t119*t49*t53*t70*t73
     1           +t130+t129+t127+t126+t125+t123+t122+t106+t102)-rhoa*t85
     2           +t74+t69+t63+6.903522198342671d-18*t17*t18+3.1090699999
     3           999993d-2*t13*t14
              t132 = 1/t40**2
              t133 = 2.306459458d-51*t41*t88-7.1500243198d-54*t132*t39*t
     1           88
              t134 = -2.0666666666666667d-52*t41*t42*t88+6.4066666666666
     1           66d-55*t132*t39*t42*t88+3.1d-3*t133*t39*t41
              t135 = 1/t35
              t136 = 1/t26**3
              t137 = 1/rhob**1.3333333333333333d+0
              t138 = 1/rhob**1.1666666666666667d+0
              t139 = -1.264669550498372d-1*t20-9.970917392951799d-1*t138
     1           -7.418564737168958d-1*t137-4.002143174996817d-1*t136
              t140 = 1/t34**2
              t141 = 1/t31
              t142 = -1.6039141941921276d-1*t20-1.8533958105157808d+0*t1
     1           38-1.2815820791490704d+0*t137-8.223668877838045d-1*t136
              t143 = 1/t30**2
              t144 = 1.1102230246251565d-16*t135*t139*t140*t37+3.0506411
     1           443514264d-19*t137*t36+1.0d+0*t141*t142*t143*t33+1.3210
     2           398931339265d-3*t137*t32
              t145 = 1/t21**2
              t146 = 1/rhob**4.333333333333333d+0
              t147 = 1/rhob**2.6666666666666666d+0
              t148 = 2.134444128d-101*t145*t146-8.8935172d-51*t147*t22
              t149 = -4.0d-51*t147*t22*t23+9.6d-102*t145*t146*t23+2.4d-5
     1           1*t148*t20*t22
              t150 = t50+t108
              t151 = t112+t109
              t152 = 1.3333333333333333d+0*t114*t151+1.3333333333333333d
     1           +0*t111*t150
              t153 = -1.923661050931536d+0*t152*t48*t49
              t154 = 7.694644203726144d+0*t119*t49*t53
              t155 = t154+t153+t118
              t156 = -6.21814d-2*t155*t46*t62
              t157 = t154+t153+1.923661050931536d+0*t152+t118
              t158 = 1.9751631321680768d-2*t157*t64*t68
              t159 = -5.980796863619711d-2*t152*t48*t49*t70*t73
              t160 = t44*(t98+2.3923187454478842d-1*t119*t49*t53*t70*t73
     1           +t159+t158+t156+t130+t129+t126+t123+t106+t102)+t74+t69+
     2           t63+6.903522198342671d-18*t36*t37+3.1090699999999993d-2
     3           *t32*t33-rhob*t144
              t161 = 2.306459458d-51*t147*t41-7.1500243198d-54*t132*t147
     1           *t39
              t162 = -2.0666666666666667d-52*t147*t41*t42+6.406666666666
     1           666d-55*t132*t147*t39*t42+3.1d-3*t161*t39*t41
              t163 = 1/t16**2
              t164 = t80**2
              t165 = 1/t15**4
              t166 = 1/t15**3
              t167 = 1/t7**5
              t168 = 1/rhoa**2.3333333333333334d+0
              t169 = 1/rhoa**2.1666666666666665d+0
              t170 = 2.1077825841639536d-1*t88+1.1632736958443765d+0*t16
     1           9+9.89141964955861d-1*t168+6.003214762495226d-1*t167
              t171 = 1/t12**2
              t172 = t83**2
              t173 = 1/t11**4
              t174 = 1/t11**3
              t175 = 2.673190323653546d-1*t88+2.1622951122684114d+0*t169
     1           +1.7087761055320938d+0*t168+1.2335503316757068d+0*t167
              t176 = -8.497974591333913d-2*t78*t82*t83*t84+1.0d+0*t14*t1
     1           75*t82*t84-2.0d+0*t14*t172*t174*t82-9.812069668265515d-
     2           18*t76*t78*t80*t81+1.1102230246251565d-16*t170*t18*t76*
     3           t81-2.220446049250313d-16*t164*t166*t18*t76+1.785458392
     4           0998188d-15*t163*t164*t165*t18+3.216395899738507d+1*t14
     5           *t171*t172*t173-4.0675215258019015d-19*t168*t17-1.76138
     6           65241785684d-3*t13*t168
              t177 = 1/t2**3
              t178 = 1/rhoa**7
              t179 = 1/rhoa**5.333333333333333d+0
              t180 = 1/rhoa**3.6666666666666664d+0
              t181 = -1.2806664767999998d-100*t179*t86+2.371604586666666
     1           6d-50*t180*t3+1.7075553024d-151*t177*t178
              t182 = -8.0d-51*t3*t88*t89+1.92d-101*t86*t87*t89-5.76d-101
     1           *t179*t4*t86+1.0666666666666666d-50*t180*t3*t4+7.68d-15
     2           2*t177*t178*t4+2.4d-51*t1*t181*t3
              t183 = 2.0d+0*t46*t55*t95*t96*t97
              t184 = -1.1696447245269295d+0*t100*t101*t64*t65*t99
              t185 = 3.847322101863072d+0*t103*t104*t105*t48*t49*t53*t70
              t186 = 5.495546528376875d-3*t55*t62*t93
              t187 = -9.087592854964233d-4*t65*t68*t93
              t188 = 5.082465978296986d-3*t128*t48*t53*t73
              t189 = 4.7846374908957684d-1*t117*t48*t53*t70*t73
              t190 = t95**2
              t191 = 1/t60**4
              t192 = 1/t61**2
              t193 = 1.6081979498692536d+1*t190*t191*t192*t46*t55
              t194 = 2.0d+0*t121*t46*t95*t96*t97
              t195 = 1/t60**3
              t196 = -2.0d+0*t190*t195*t46*t55*t97
              t197 = -8.837926660346784d-2*t55*t93*t95*t96*t97
              t198 = 1/t44**2.6666666666666666d+0
              t199 = 1/t57**5
              t200 = 1/t44**2.3333333333333334d+0
              t201 = 1/t44**2.1666666666666665d+0
              t202 = 1.1632736958443765d+0*t201+9.89141964955861d-1*t200
     1           +6.003214762495226d-1*t199+2.1077825841639536d-1*t198
              t203 = 1.0d+0*t202*t46*t55*t96*t97
              t204 = t99**2
              t205 = 1/t66**4
              t206 = 1/t67**2
              t207 = -1.73158960813529d+1*t204*t205*t206*t64*t65
              t208 = -1.1696447245269295d+0*t100*t101*t124*t64*t99
              t209 = 1/t66**3
              t210 = 1.1696447245269295d+0*t101*t204*t209*t64*t65
              t211 = 2.690728393099896d-2*t100*t101*t65*t93*t99
              t212 = 1.5861639701225969d+0*t201+9.98929717145607d-1*t200
     1           +3.2257293534574827d-1*t199+2.1239028834748191d-1*t198
              t213 = -5.848223622634647d-1*t100*t101*t212*t64*t65
              t214 = t103**2
              t215 = 1/t71**4
              t216 = 1/t72**2
              t217 = 6.187255516702861d+1*t214*t215*t216*t48*t49*t53*t70
              t218 = 3.847322101863072d+0*t103*t104*t105*t115*t48*t49*t7
     1           0
              t219 = 1/t71**3
              t220 = -3.847322101863072d+0*t105*t214*t219*t48*t49*t53*t7
     1           0
              t221 = -1.6347222733154887d-1*t103*t104*t105*t128*t48*t53
              t222 = 2.1622951122684114d+0*t201+1.7087761055320938d+0*t2
     1           00+1.2335503316757068d+0*t199+2.673190323653546d-1*t198
              t223 = 1.923661050931536d+0*t104*t105*t222*t48*t49*t53*t70
              t224 = -1.538928840745229d+1*t103*t104*t105*t117*t48*t53*t
     1           70
              t225 = 1.538928840745229d+1*t103*t104*t105*t119*t49*t53*t7
     1           0
              t226 = t110**2
              t227 = 1/t51**6.666666666666666d-1
              t228 = 1/t44**3
              t229 = -2*t228*t47
              t230 = 2*t107
              t231 = t230+t229
              t232 = t113**2
              t233 = 1/t52**6.666666666666666d-1
              t234 = 2*t228*t47
              t235 = -2*t107
              t236 = t235+t234
              t237 = 1.3333333333333333d+0*t114*t236+4.444444444444444d-
     1           1*t232*t233+1.3333333333333333d+0*t111*t231+4.444444444
     2           444444d-1*t226*t227
              t238 = -1.923661050931536d+0*t237*t48*t49
              t239 = 1.5389288407452287d+1*t115*t117*t48
              t240 = -1.5389288407452287d+1*t115*t119*t49
              t241 = 1/t44**6
              t242 = -3.8473221018630716d+1*t241*t48*t53
              t243 = 6.155715362980915d+1*t117*t119*t53
              t244 = t47**2
              t245 = -2.3083932611178434d+1*t244*t49*t53
              t246 = t245+t243+t242+t240+t239+t238
              t247 = -6.21814d-2*t246*t46*t62
              t248 = 5.495546528376875d-3*t121*t62*t93
              t249 = -3.663697685584583d-3*t200*t55*t62
              t250 = t245+t243+t242+t240+t239+t238+1.923661050931536d+0*
     1           t237
              t251 = 1.9751631321680768d-2*t250*t64*t68
              t252 = -9.087592854964233d-4*t124*t68*t93
              t253 = 6.058395236642822d-4*t200*t65*t68
              t254 = -5.980796863619711d-2*t237*t48*t49*t70*t73
              t255 = 5.082465978296986d-3*t115*t128*t48*t73
              t256 = 4.7846374908957684d-1*t115*t117*t48*t70*t73
              t257 = 1/t44**6.333333333333333d+0
              t258 = -2.3718174565385935d-2*t257*t48*t53*t73
              t259 = 2.0329863913187946d-2*t119*t128*t53*t73
              t260 = -1.1961593727239421d+0*t241*t48*t53*t70*t73
              t261 = 1.9138549963583074d+0*t117*t119*t53*t70*t73
              t262 = -7.176956236343652d-1*t244*t49*t53*t70*t73
              t263 = -2.0d+0*t14*t82*t83*t84-2.220446049250313d-16*t18*t
     1           76*t80*t81-6.101282288702853d-19*t17*t78-2.642079786267
     2           853d-3*t13*t78+t44*(-4.7846374908957684d-1*t115*t119*t4
     3           9*t70*t73+t262+t261+t260+t259+t258+t256+t255+t254+t253+
     4           t252+t251+t249+t248+t247+t225+t224+t223+t221+t220+t218+
     5           t217+t213+t211+t210+t208+t207+t203+t197+t196+t194+t193)
     6           -4.7846374908957684d-1*t119*t49*t53*t70*t73-1.196159372
     7           7239421d-1*t115*t48*t49*t70*t73+3.9503262643361536d-2*t
     8           124*t64*t68-1.243628d-1*t121*t46*t62+t189+t188+t187+t18
     9           6+t185+t184+t183-rhoa*t176
              t264 = 1/t40**3
              t265 = -6.150558554666666d-51*t180*t41-2.9553433855173333d
     1           -105*t179*t264*t39+1.9066731519466665d-53*t132*t180*t39
     2           +9.533365759733332d-103*t132*t179
              t266 = -4.1333333333333333d-52*t133*t41*t88+1.281333333333
     1           3332d-54*t132*t133*t39*t88+5.51111111111111d-52*t180*t4
     2           1*t42+2.6480888888888887d-106*t179*t264*t39*t42-1.70844
     3           4444444444d-54*t132*t180*t39*t42-8.542222222222222d-104
     4           *t132*t179*t42+3.1d-3*t265*t39*t41
              t267 = 2.6666666666666666d+0*t114*t228*t47-2.6666666666666
     1           666d+0*t111*t228*t47+4.444444444444444d-1*t113*t151*t23
     2           3+4.444444444444444d-1*t110*t150*t227
              t268 = -1.923661050931536d+0*t267*t48*t49
              t269 = 7.694644203726144d+0*t117*t152*t48
              t270 = -7.694644203726144d+0*t119*t152*t49
              t271 = 7.694644203726144d+0*t115*t117*t48
              t272 = 7.694644203726144d+0*t115*t119*t49
              t273 = 2.3083932611178434d+1*t244*t49*t53
              t274 = t273+t272+t271+t270+t269+t268+t242
              t275 = t273+t272+t271+t270+t269+t268+1.923661050931536d+0*
     1           t267+t242
              t276 = 7.176956236343652d-1*t244*t49*t53*t70*t73
              t277 = t44*(-5.848223622634647d-1*t100*t101*t157*t64*t99-5
     1           .848223622634647d-1*t100*t101*t124*t64*t99+1.0d+0*t155*
     2           t46*t95*t96*t97+1.0d+0*t121*t46*t95*t96*t97-4.543796427
     3           4821163d-4*t157*t68*t93-4.5437964274821163d-4*t124*t68*
     4           t93+2.747773264188437d-3*t155*t62*t93+2.747773264188437
     5           d-3*t121*t62*t93-5.980796863619711d-2*t267*t48*t49*t70*
     6           t73-2.3923187454478842d-1*t119*t152*t49*t70*t73+2.39231
     7           87454478842d-1*t115*t119*t49*t70*t73+2.3923187454478842
     8           d-1*t117*t152*t48*t70*t73+2.3923187454478842d-1*t115*t1
     9           17*t48*t70*t73+2.541232989148493d-3*t128*t152*t48*t73+2
     :           .541232989148493d-3*t115*t128*t48*t73+1.923661050931536
     ;           d+0*t103*t104*t105*t152*t48*t49*t70+1.923661050931536d+
     <           0*t103*t104*t105*t115*t48*t49*t70+1.9751631321680768d-2
     =           *t275*t64*t68-6.21814d-2*t274*t46*t62+t276+t260+t258+t2
     >           53+t249+t224+t223+t221+t220+t217+t213+t211+t210+t207+t2
     ?           03+t197+t196+t193)+t189+t188+t187+t186+t185+t184+t183+t
     @           159+t158+t156+t127+t125+t122
              t278 = 9.533365759733332d-103*t132*t147*t88-2.955343385517
     1           3333d-105*t147*t264*t39*t88
              t279 = 2.6480888888888887d-106*t147*t264*t39*t42*t88-8.542
     1           222222222222d-104*t132*t147*t42*t88-2.0666666666666667d
     2           -52*t161*t41*t88+6.406666666666666d-55*t132*t161*t39*t8
     3           8+3.1d-3*t278*t39*t41-2.0666666666666667d-52*t133*t147*
     4           t41+6.406666666666666d-55*t132*t133*t147*t39
              t280 = 1/t35**2
              t281 = t139**2
              t282 = 1/t34**4
              t283 = 1/t34**3
              t284 = 1/t26**5
              t285 = 1/rhob**2.3333333333333334d+0
              t286 = 1/rhob**2.1666666666666665d+0
              t287 = 1.1632736958443765d+0*t286+9.89141964955861d-1*t285
     1           +6.003214762495226d-1*t284+2.1077825841639536d-1*t147
              t288 = 1/t31**2
              t289 = t142**2
              t290 = 1/t30**4
              t291 = 1/t30**3
              t292 = 2.1622951122684114d+0*t286+1.7087761055320938d+0*t2
     1           85+1.2335503316757068d+0*t284+2.673190323653546d-1*t147
              t293 = 1.1102230246251565d-16*t135*t140*t287*t37-2.2204460
     1           49250313d-16*t135*t281*t283*t37+1.7854583920998188d-15*
     2           t280*t281*t282*t37-4.0675215258019015d-19*t285*t36+1.0d
     3           +0*t141*t143*t292*t33-2.0d+0*t141*t289*t291*t33+3.21639
     4           5899738507d+1*t288*t289*t290*t33-1.7613865241785684d-3*
     5           t285*t32-8.497974591333913d-2*t137*t141*t142*t143-9.812
     6           069668265515d-18*t135*t137*t139*t140
              t294 = 1/t21**3
              t295 = 1/rhob**7
              t296 = 1/rhob**5.333333333333333d+0
              t297 = 1/rhob**3.6666666666666664d+0
              t298 = 2.3716045866666666d-50*t22*t297-1.2806664767999998d
     1           -100*t145*t296+1.7075553024d-151*t294*t295
              t299 = 2.4d-51*t20*t22*t298+1.0666666666666666d-50*t22*t23
     1           *t297-5.76d-101*t145*t23*t296+7.68d-152*t23*t294*t295-8
     2           .0d-51*t147*t148*t22+1.92d-101*t145*t146*t148
              t300 = 2.0d+0*t155*t46*t95*t96*t97
              t301 = -1.1696447245269295d+0*t100*t101*t157*t64*t99
              t302 = 3.847322101863072d+0*t103*t104*t105*t152*t48*t49*t7
     1           0
              t303 = -1.538928840745229d+1*t103*t104*t105*t119*t49*t53*t
     1           70
              t304 = t150**2
              t305 = t235+t229
              t306 = t151**2
              t307 = t234+t230
              t308 = 1.3333333333333333d+0*t114*t307+4.444444444444444d-
     1           1*t233*t306+1.3333333333333333d+0*t111*t305+4.444444444
     2           444444d-1*t227*t304
              t309 = -1.923661050931536d+0*t308*t48*t49
              t310 = 1.5389288407452287d+1*t117*t152*t48
              t311 = 1.5389288407452287d+1*t119*t152*t49
              t312 = -6.155715362980915d+1*t117*t119*t53
              t313 = t312+t311+t310+t309+t245+t242
              t314 = -6.21814d-2*t313*t46*t62
              t315 = 5.495546528376875d-3*t155*t62*t93
              t316 = t312+t311+t310+t309+1.923661050931536d+0*t308+t245+
     1           t242
              t317 = 1.9751631321680768d-2*t316*t64*t68
              t318 = -9.087592854964233d-4*t157*t68*t93
              t319 = -5.980796863619711d-2*t308*t48*t49*t70*t73
              t320 = 5.082465978296986d-3*t128*t152*t48*t73
              t321 = 4.7846374908957684d-1*t117*t152*t48*t70*t73
              t322 = -2.0329863913187946d-2*t119*t128*t53*t73
              t323 = -1.9138549963583074d+0*t117*t119*t53*t70*t73
              t324 = t44*(4.7846374908957684d-1*t119*t152*t49*t70*t73+t3
     1           23+t322+t321+t320+t319+t318+t317+t315+t314+t303+t302+t3
     2           01+t300+t262+t260+t258+t253+t249+t224+t223+t221+t220+t2
     3           17+t213+t211+t210+t207+t203+t197+t196+t193)+4.784637490
     4           8957684d-1*t119*t49*t53*t70*t73-1.1961593727239421d-1*t
     5           152*t48*t49*t70*t73+3.9503262643361536d-2*t157*t64*t68-
     6           1.243628d-1*t155*t46*t62-2.220446049250313d-16*t135*t13
     7           9*t140*t37-6.101282288702853d-19*t137*t36-2.0d+0*t141*t
     8           142*t143*t33-2.642079786267853d-3*t137*t32-rhob*t293+t1
     9           89+t188+t187+t186+t185+t184+t183
              t325 = -6.150558554666666d-51*t297*t41+1.9066731519466665d
     1           -53*t132*t297*t39-2.9553433855173333d-105*t264*t296*t39
     2           +9.533365759733332d-103*t132*t296
              t326 = 5.51111111111111d-52*t297*t41*t42-1.708444444444444
     1           d-54*t132*t297*t39*t42+2.6480888888888887d-106*t264*t29
     2           6*t39*t42-8.542222222222222d-104*t132*t296*t42+3.1d-3*t
     3           325*t39*t41-4.1333333333333333d-52*t147*t161*t41+1.2813
     4           333333333332d-54*t132*t147*t161*t39
              t327 = t80**3
              t328 = 1/t7**7
              t329 = 1/rhoa**3.3333333333333337d+0
              t330 = 1/rhoa**3.1666666666666665d+0
              t331 = t83**3
              t332 = 1.6995949182667827d-1*t168*t82*t83*t84-1.2746961887
     1           00087d-1*t175*t78*t82*t84+1.0d+0*t14*(-4.68497274324822
     2           4d+0*t330-3.9871442462415524d+0*t329-3.083875829189267d
     3           +0*t328-7.128507529742789d-1*t180)*t82*t84-6.0d+0*t14*t
     4           174*t175*t82*t83+9.649187699215522d+1*t14*t171*t173*t17
     5           5*t83+2.549392377400174d-1*t172*t174*t78*t82+6.0d+0*t14
     6           *t173*t331*t82+1.962413933653103d-17*t168*t76*t80*t81-1
     7           .4718104502398274d-17*t170*t76*t78*t81+1.11022302462515
     8           65d-16*t18*(-2.520426340996149d+0*t330-2.30799791823034
     9           28d+0*t329-1.5008036906238065d+0*t328-5.620753557770543
     :           d-1*t180)*t76*t81-6.661338147750939d-16*t166*t170*t18*t
     ;           76*t80+5.356375176299456d-15*t163*t165*t170*t18*t80+2.9
     <           43620900479655d-17*t164*t166*t76*t78-4.0999275947472624
     =           d+0*t171*t172*t173*t78-2.3669625486718335d-16*t163*t164
     >           *t165*t78+6.661338147750939d-16*t165*t18*t327*t76-1.929
     ?           8375398431045d+2*t14*t171*t331/t11**5+2.069040516770936
     @           4d+3*t14*t331/(t11**6*t12**3)+9.490883560204437d-19*t17
     1           *t329+4.1099018897499934d-3*t13*t329-1.0712750352598913
     2           d-14*t163*t18*t327/t15**5+5.742741051503565d-14*t18*t32
     3           7/(t15**6*t16**3)
              t333 = 1/t2**4
              t334 = 1/rhoa**9.666666666666666d+0
              t335 = 1/rhoa**8
              t336 = 1/rhoa**6.333333333333333d+0
              t337 = 1/rhoa**4.666666666666667d+0
              t338 = 1/t40**4
              t339 = 4.824593849607761d+1*t190*t191*t192*t46*t55
              t340 = -6.0d+0*t190*t195*t46*t55*t97
              t341 = -2.6513779981040353d-1*t55*t93*t95*t96*t97
              t342 = 3.0d+0*t202*t46*t55*t96*t97
              t343 = -5.19476882440587d+1*t204*t205*t206*t64*t65
              t344 = 3.5089341735807883d+0*t101*t204*t209*t64*t65
              t345 = 8.072185179299687d-2*t100*t101*t65*t93*t99
              t346 = -1.7544670867903941d+0*t100*t101*t212*t64*t65
              t347 = 1.856176655010858d+2*t214*t215*t216*t48*t49*t53*t70
              t348 = -1.1541966305589217d+1*t105*t214*t219*t48*t49*t53*t
     1           70
              t349 = -4.904166819946466d-1*t103*t104*t105*t128*t48*t53
              t350 = 5.770983152794609d+0*t104*t105*t222*t48*t49*t53*t70
              t351 = -4.616786522235687d+1*t103*t104*t105*t117*t48*t53*t
     1           70
              t352 = -1.099109305675375d-2*t200*t55*t62
              t353 = 1.8175185709928465d-3*t200*t65*t68
              t354 = -7.11545236961578d-2*t257*t48*t53*t73
              t355 = -3.588478118171826d+0*t241*t48*t53*t70*t73
              t356 = -2.1530868709030954d+0*t244*t49*t53*t70*t73
              t357 = t95**3
              t358 = 5.172601291927341d+2*t357*t46*t55/(t60**6*t61**3)
              t359 = -9.649187699215522d+1*t192*t357*t46*t55/t60**5
              t360 = 4.824593849607761d+1*t191*t192*t202*t46*t55*t95
              t361 = -2.1319703304396778d+0*t190*t191*t192*t55*t93
              t362 = 6.0d+0*t191*t357*t46*t55*t97
              t363 = -6.0d+0*t195*t202*t46*t55*t95*t97
              t364 = 2.6513779981040353d-1*t190*t195*t55*t93*t97
              t365 = -1.3256889990520176d-1*t202*t55*t93*t96*t97
              t366 = 1.767585332069357d-1*t200*t55*t95*t96*t97
              t367 = 1/t44**3.6666666666666664d+0
              t368 = 1/t57**7
              t369 = 1/t44**3.3333333333333337d+0
              t370 = 1/t44**3.1666666666666665d+0
              t371 = 1.0d+0*(-2.520426340996149d+0*t370-2.30799791823034
     1           28d+0*t369-1.5008036906238065d+0*t368-5.620753557770543
     2           d-1*t367)*t46*t55*t96*t97
              t372 = t99**3
              t373 = -1.0254062650399592d+3*t372*t64*t65/(t66**6*t67**3)
              t374 = 1.0389537648811739d+2*t206*t372*t64*t65/t66**5
              t375 = -5.19476882440587d+1*t205*t206*t212*t64*t65*t99
              t376 = 1.1950391155803675d+0*t204*t205*t206*t65*t93
              t377 = -3.5089341735807883d+0*t101*t205*t372*t64*t65
              t378 = 3.5089341735807883d+0*t101*t209*t212*t64*t65*t99
              t379 = -8.072185179299687d-2*t101*t204*t209*t65*t93
              t380 = 4.0360925896498434d-2*t100*t101*t212*t65*t93
              t381 = -5.381456786199791d-2*t100*t101*t200*t65*t99
              t382 = -5.848223622634647d-1*t100*t101*(-3.436688601932293
     1           d+0*t370-2.3308360066730832d+0*t369-8.064323383643707d-
     2           1*t368-5.663741022599518d-1*t367)*t64*t65
              t383 = t103**3
              t384 = 3.9801326549115085d+3*t383*t48*t49*t53*t70/(t71**6*
     1           t72**3)
              t385 = -3.712353310021716d+2*t216*t383*t48*t49*t53*t70/t71
     1           **5
              t386 = 1.856176655010858d+2*t103*t215*t216*t222*t48*t49*t5
     1           3*t70
              t387 = -7.424706620043432d+2*t117*t214*t215*t216*t48*t53*t
     1           70
              t388 = -7.886871025654724d+0*t128*t214*t215*t216*t48*t53
              t389 = 1.1541966305589217d+1*t105*t215*t383*t48*t49*t53*t7
     1           0
              t390 = -1.1541966305589217d+1*t103*t105*t219*t222*t48*t49*
     1           t53*t70
              t391 = 4.616786522235687d+1*t105*t117*t214*t219*t48*t53*t7
     1           0
              t392 = 4.904166819946466d-1*t105*t128*t214*t219*t48*t53
              t393 = -2.452083409973233d-1*t104*t105*t128*t222*t48*t53
              t394 = 2.2886111826416838d+0*t103*t104*t105*t257*t48*t53
              t395 = 1.923661050931536d+0*t104*t105*(-4.684972743248224d
     1           +0*t370-3.9871442462415524d+0*t369-3.083875829189267d+0
     2           *t368-7.128507529742789d-1*t367)*t48*t49*t53*t70
              t396 = -2.3083932611178434d+1*t104*t105*t117*t222*t48*t53*
     1           t70
              t397 = 1.1541966305589217d+2*t103*t104*t105*t241*t48*t53*t
     1           70
              t398 = 6.925179783353531d+1*t103*t104*t105*t244*t49*t53*t7
     1           0
              t399 = 8.548627933030694d-3*t369*t55*t62
              t400 = 1/t51**1.6666666666666669d+0
              t401 = 6*t47*t49
              t402 = -6*t228
              t403 = 1/t52**1.6666666666666669d+0
              t404 = -6*t47*t49
              t405 = 6*t228
              t406 = 1.3333333333333333d+0*t114*(t405+t404)-2.9629629629
     1           62963d-1*t113**3*t403+1.3333333333333333d+0*t111*(t402+
     2           t401)-2.962962962962963d-1*t110**3*t400+1.3333333333333
     3           333d+0*t113*t233*t236+1.3333333333333333d+0*t110*t227*t
     4           231
              t407 = -1.923661050931536d+0*t406*t48*t49
              t408 = 2.3083932611178434d+1*t117*t237*t48
              t409 = -2.3083932611178434d+1*t119*t237*t49
              t410 = -1.1541966305589216d+2*t115*t241*t48
              t411 = 1.8467146088942746d+2*t115*t117*t119
              t412 = -6.925179783353531d+1*t115*t244*t49
              t413 = 1/t44**7
              t414 = 2.3083932611178432d+2*t413*t48*t53
              t415 = -4.6167865222356863d+2*t119*t241*t53
              t416 = 2.770071913341412d+2*t117*t244*t53
              t417 = -4.616786522235687d+1*t47*t49*t53
              t418 = -1.4136255552166585d-3*t369*t65*t68
              t419 = 2.0103976536374746d-1*t48*t53*t73/t44**7.3333333333
     1           33333d+0
              t420 = 9.148438760934575d-2*t128*t244*t53*t73
              t421 = 7.176956236343652d+0*t413*t48*t53*t70*t73
              t422 = 8.612347483612381d+0*t117*t244*t53*t70*t73
              t423 = -1.4353912472687305d+0*t47*t49*t53*t70*t73
              t424 = -1.243628d-1*t274*t46*t62
              t425 = 3.9503262643361536d-2*t275*t64*t68
              t426 = -1.1961593727239421d-1*t267*t48*t49*t70*t73
              t427 = 2.0d+0*t274*t46*t95*t96*t97
              t428 = -1.1696447245269295d+0*t100*t101*t275*t64*t99
              t429 = 3.847322101863072d+0*t103*t104*t105*t267*t48*t49*t7
     1           0
              t430 = -2.3083932611178434d+1*t103*t104*t105*t244*t49*t53*
     1           t70
              t431 = 5.495546528376875d-3*t274*t62*t93
              t432 = 1.5389288407452287d+1*t117*t267*t48
              t433 = -1.5389288407452287d+1*t119*t267*t49
              t434 = 1.7777777777777776d+0*t113*t228*t233*t47-1.77777777
     1           77777776d+0*t110*t227*t228*t47+1.3333333333333333d+0*t1
     2           14*(t404+2*t228)-2.962962962962963d-1*t151*t232*t403+1.
     3           3333333333333333d+0*t111*(t401-2*t228)-2.96296296296296
     4           3d-1*t150*t226*t400+4.444444444444444d-1*t151*t233*t236
     5           +4.444444444444444d-1*t150*t227*t231
              t435 = -1.923661050931536d+0*t434*t48*t49
              t436 = 7.694644203726144d+0*t117*t237*t48
              t437 = 7.694644203726144d+0*t119*t237*t49
              t438 = -3.8473221018630716d+1*t152*t241*t48
              t439 = 6.155715362980915d+1*t117*t119*t152
              t440 = -2.3083932611178434d+1*t152*t244*t49
              t441 = -7.694644203726143d+1*t115*t241*t48
              t442 = 4.616786522235687d+1*t115*t244*t49
              t443 = -1.5389288407452287d+2*t119*t241*t53
              t444 = -9.233573044471374d+1*t117*t244*t53
              t445 = 4.616786522235687d+1*t47*t49*t53
              t446 = -9.087592854964233d-4*t275*t68*t93
              t447 = 5.082465978296986d-3*t128*t267*t48*t73
              t448 = 4.7846374908957684d-1*t117*t267*t48*t70*t73
              t449 = -2.870782494537461d+0*t117*t244*t53*t70*t73
              t450 = 1.4353912472687305d+0*t47*t49*t53*t70*t73
              t451 = -8*t114*t47*t49+8*t111*t47*t49+1.7777777777777776d+
     1           0*t151*t228*t233*t47-1.7777777777777776d+0*t150*t227*t2
     2           28*t47-2.962962962962963d-1*t113*t306*t403-2.9629629629
     3           62963d-1*t110*t304*t400+4.444444444444444d-1*t113*t233*
     4           t307+4.444444444444444d-1*t110*t227*t305-2.666666666666
     5           6666d+0*t114*t228+2.6666666666666666d+0*t111*t228
              t452 = -1.923661050931536d+0*t451*t48*t49
              t453 = 1.5389288407452287d+1*t119*t267*t49
              t454 = 7.694644203726144d+0*t117*t308*t48
              t455 = -7.694644203726144d+0*t119*t308*t49
              t456 = -7.694644203726143d+1*t152*t241*t48
              t457 = 4.616786522235687d+1*t152*t244*t49
              t458 = -3.8473221018630716d+1*t115*t241*t48
              t459 = -6.155715362980915d+1*t115*t117*t119
              t460 = -2.3083932611178434d+1*t115*t244*t49
              t461 = 1.5389288407452287d+2*t119*t241*t53
              t462 = t139**3
              t463 = 1/t26**7
              t464 = 1/rhob**3.3333333333333337d+0
              t465 = 1/rhob**3.1666666666666665d+0
              t466 = t142**3
              t467 = 2.0690405167709364d+3*t33*t466/(t30**6*t31**3)-1.92
     1           98375398431045d+2*t288*t33*t466/t30**5+6.0d+0*t141*t290
     2           *t33*t466+1.1102230246251565d-16*t135*t140*t37*(-2.5204
     3           26340996149d+0*t465-2.3079979182303428d+0*t464-1.500803
     4           6906238065d+0*t463-5.620753557770543d-1*t297)+1.0d+0*t1
     5           41*t143*t33*(-4.684972743248224d+0*t465-3.9871442462415
     6           524d+0*t464-3.083875829189267d+0*t463-7.128507529742789
     7           d-1*t297)+9.490883560204437d-19*t36*t464+4.109901889749
     8           9934d-3*t32*t464+5.742741051503565d-14*t37*t462/(t34**6
     9           *t35**3)-1.0712750352598913d-14*t280*t37*t462/t34**5+6.
     :           661338147750939d-16*t135*t282*t37*t462-6.66133814775093
     ;           9d-16*t135*t139*t283*t287*t37+5.356375176299456d-15*t13
     <           9*t280*t282*t287*t37-6.0d+0*t141*t142*t291*t292*t33+9.6
     =           49187699215522d+1*t142*t288*t290*t292*t33-1.27469618870
     >           0087d-1*t137*t141*t143*t292+2.549392377400174d-1*t137*t
     ?           141*t289*t291-4.0999275947472624d+0*t137*t288*t289*t290
     @           -1.4718104502398274d-17*t135*t137*t140*t287+1.699594918
     1           2667827d-1*t141*t142*t143*t285+1.962413933653103d-17*t1
     2           35*t139*t140*t285+2.943620900479655d-17*t135*t137*t281*
     3           t283-2.3669625486718335d-16*t137*t280*t281*t282
              t468 = 1/t21**4
              t469 = 1/rhob**9.666666666666666d+0
              t470 = 1/rhob**8
              t471 = 1/rhob**6.333333333333333d+0
              t472 = 1/rhob**4.666666666666667d+0
              t473 = 1.3333333333333333d+0*t111*(t405+t401)+1.3333333333
     1           333333d+0*t114*(t404+t402)-2.962962962962963d-1*t151**3
     2           *t403-2.962962962962963d-1*t150**3*t400+1.3333333333333
     3           333d+0*t151*t233*t307+1.3333333333333333d+0*t150*t227*t
     4           305
              t474 = -1.923661050931536d+0*t473*t48*t49
              t475 = 2.3083932611178434d+1*t117*t308*t48
              t476 = 2.3083932611178434d+1*t119*t308*t49
              t477 = -1.1541966305589216d+2*t152*t241*t48
              t478 = -1.8467146088942746d+2*t117*t119*t152
              t479 = -6.925179783353531d+1*t152*t244*t49
              t480 = 4.6167865222356863d+2*t119*t241*t53
              fnc(iq) = (1.0d+0*t43*t75+5.0d-1*rhoa*t19*t5+5.0d-1*rhob*t
     1           24*t38)*wght+fnc(iq)
              Amat(iq,D1_RA) = (5.0d-1*rhoa*t19*t90+5.0d-1*rhoa*t5*t85+1
     1           .0d+0*t134*t75+5.0d-1*t19*t5+1.0d+0*t131*t43)*wght+Amat
     2           (iq,D1_RA)
              Amat(iq,D1_RB) = (1.0d+0*t162*t75+1.0d+0*t160*t43+5.0d-1*t
     1           24*t38+5.0d-1*rhob*t149*t38+5.0d-1*rhob*t144*t24)*wght+
     2           Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (1.0d+0*rhoa*t85*t90+1.0d+0*t19*t90+1
     1           .0d+0*t5*t85+1.0d+0*t266*t75+5.0d-1*rhoa*t176*t5+1.0d+0
     2           *t263*t43+5.0d-1*rhoa*t182*t19+2.0d+0*t131*t134)*wght+A
     3           mat2(iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = (1.0d+0*t279*t75+1.0d+0*t277*t43+1.0d
     1           +0*t131*t162+1.0d+0*t134*t160)*wght+Amat2(iq,D2_RA_RB)
              Amat2(iq,D2_RB_RB) = (1.0d+0*t326*t75+1.0d+0*t324*t43+5.0d
     1           -1*rhob*t299*t38+1.0d+0*t149*t38+5.0d-1*rhob*t24*t293+1
     2           .0d+0*t144*t24+2.0d+0*t160*t162+1.0d+0*rhob*t144*t149)*
     3           wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_RB_GAA) = Cmat2(iq,D2_RB_GAA)
              Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
              Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
              Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
              Amat3(iq,D3_RA_RA_RA) = (1.0d+0*t43*(t44*(8.07218517929968
     1           7d-2*t100*t101*t124*t93*t99-1.7544670867903941d+0*t100*
     2           t101*t250*t64*t99-2.6513779981040353d-1*t121*t93*t95*t9
     3           6*t97+3.0d+0*t246*t46*t95*t96*t97+3.0d+0*t121*t202*t46*
     4           t96*t97-6.0d+0*t121*t190*t195*t46*t97-1.363138928244635
     5           d-3*t250*t68*t93+8.243319792565312d-3*t246*t62*t93-1.43
     6           53912472687305d+1*t119*t241*t53*t70*t73-5.9807968636197
     7           11d-2*t406*t48*t49*t70*t73-2.1530868709030954d+0*t115*t
     8           244*t49*t70*t73-7.176956236343652d-1*t119*t237*t49*t70*
     9           t73-3.588478118171826d+0*t115*t241*t48*t70*t73+7.176956
     :           236343652d-1*t117*t237*t48*t70*t73+5.741564989074922d+0
     ;           *t115*t117*t119*t70*t73-2.8461809478463124d-1*t119*t257
     <           *t53*t73-7.11545236961578d-2*t115*t257*t48*t73+7.623698
     =           967445479d-3*t128*t237*t48*t73+6.098959173956384d-2*t11
     >           5*t119*t128*t73+2.3083932611178434d+1*t104*t105*t119*t2
     ?           22*t49*t53*t70-4.616786522235687d+1*t105*t119*t214*t219
     @           *t49*t53*t70+7.424706620043432d+2*t119*t214*t215*t216*t
     1           49*t53*t70-1.8467146088942746d+2*t103*t104*t105*t117*t1
     2           19*t53*t70+5.770983152794609d+0*t103*t104*t105*t237*t48
     3           *t49*t70+5.770983152794609d+0*t104*t105*t115*t222*t48*t
     4           49*t70-1.1541966305589217d+1*t105*t115*t214*t219*t48*t4
     5           9*t70+1.856176655010858d+2*t115*t214*t215*t216*t48*t49*
     6           t70+4.616786522235687d+1*t103*t104*t105*t115*t119*t49*t
     7           70-4.616786522235687d+1*t103*t104*t105*t115*t117*t48*t7
     8           0+1.9751631321680768d-2*(t417+t416+t415+t414+t412+t411+
     9           t410+t409+t408+t407+1.923661050931536d+0*t406)*t64*t68+
     :           1.8175185709928465d-3*t124*t200*t68-1.7544670867903941d
     ;           +0*t100*t101*t124*t212*t64+3.5089341735807883d+0*t101*t
     <           124*t204*t209*t64-5.19476882440587d+1*t124*t204*t205*t2
     =           06*t64-6.21814d-2*(t417+t416+t415+t414+t412+t411+t410+t
     >           409+t408+t407)*t46*t62-1.099109305675375d-2*t121*t200*t
     ?           62-1.9616667279785865d+0*t103*t104*t105*t119*t128*t53-4
     @           .904166819946466d-1*t103*t104*t105*t115*t128*t48+4.8245
     1           93849607761d+1*t121*t190*t191*t192*t46+t423+t422+t421+t
     2           420+t419+t418+t399+t398+t397+t396+t395+t394+t393+t392+t
     3           391+t390+t389+t388+t387+t386+t385+t384+t382+t381+t380+t
     4           379+t378+t377+t376+t375+t374+t373+t371+t366+t365+t364+t
     5           363+t362+t361+t360+t359+t358)-3.5089341735807883d+0*t10
     6           0*t101*t124*t64*t99+6.0d+0*t121*t46*t95*t96*t97-2.72627
     7           785648927d-3*t124*t68*t93+1.6486639585130625d-2*t121*t6
     8           2*t93+2.549392377400174d-1*t78*t82*t83*t84-3.0d+0*t14*t
     9           175*t82*t84+6.0d+0*t14*t172*t174*t82+2.943620900479655d
     :           -17*t76*t78*t80*t81-3.3306690738754696d-16*t170*t18*t76
     ;           *t81+6.661338147750939d-16*t164*t166*t18*t76+5.74156498
     <           9074922d+0*t117*t119*t53*t70*t73-1.794239059085913d-1*t
     =           237*t48*t49*t70*t73-1.4353912472687305d+0*t115*t119*t49
     >           *t70*t73+1.4353912472687305d+0*t115*t117*t48*t70*t73+6.
     ?           098959173956384d-2*t119*t128*t53*t73+1.524739793489096d
     @           -2*t115*t128*t48*t73+4.616786522235687d+1*t103*t104*t10
     1           5*t119*t49*t53*t70+1.1541966305589217d+1*t103*t104*t105
     2           *t115*t48*t49*t70+5.92548939650423d-2*t250*t64*t68-1.86
     3           5442d-1*t246*t46*t62+t356+t355+t354+t353+t352+t351+t350
     4           +t349+t348+t347+t346+t345+t344+t343+t342+t341+t340+t339
     5           -rhoa*t332-5.356375176299456d-15*t163*t164*t165*t18-9.6
     6           49187699215522d+1*t14*t171*t172*t173+1.2202564577405706
     7           d-18*t168*t17+5.284159572535705d-3*t13*t168)+3.0d+0*t85
     8           *t90+1.5d+0*rhoa*t176*t90+5.0d-1*rhoa*t19*(-1.727999999
     9           9999998d-100*t179*t86*t89+3.2d-50*t180*t3*t89+2.3040000
     :           000000002d-151*t177*t178*t89-1.2d-50*t181*t3*t88+2.88d-
     ;           101*t181*t86*t87+2.4d-51*t1*t3*(7.778863044266666d-100*
     <           t336*t86-8.695883484444443d-50*t3*t337-2.21982189311999
     =           98d-150*t177*t335+2.04906636288d-201*t333*t334)+3.49866
     >           66666666666d-100*t336*t4*t86-3.911111111111111d-50*t3*t
     ?           337*t4-9.984000000000001d-151*t177*t335*t4+9.2160000000
     @           00001d-202*t333*t334*t4)+1.0d+0*t75*(-6.2d-52*t265*t41*
     1           t88+1.9219999999999998d-54*t132*t265*t39*t88-2.02074074
     2           07407404d-51*t337*t41*t42+1.641815111111111d-157*t335*t
     3           338*t39*t42+6.264296296296294d-54*t132*t337*t39*t42-2.1
     4           18471111111111d-105*t264*t336*t39*t42+6.833777777777776
     5           d-103*t132*t336*t42-5.296177777777777d-155*t264*t335*t4
     6           2+3.1d-3*t39*t41*(2.2552048033777775d-50*t337*t41-1.832
     7           3128990207463d-156*t335*t338*t39-6.991134890471111d-53*
     8           t132*t337*t39+2.3642747084138666d-104*t264*t336*t39-7.6
     9           26692607786666d-102*t132*t336+5.910686771034666d-154*t2
     :           64*t335)+1.6533333333333333d-51*t133*t180*t41+7.9442666
     ;           66666666d-106*t133*t179*t264*t39-5.125333333333332d-54*
     <           t132*t133*t180*t39-2.5626666666666664d-103*t132*t133*t1
     =           79)+1.5d+0*rhoa*t182*t85+5.0d-1*rhoa*t332*t5+1.5d+0*t17
     >           6*t5+3.0d+0*t131*t266+3.0d+0*t134*t263+1.5d+0*t182*t19)
     ?           *wght+Amat3(iq,D3_RA_RA_RA)
              Amat3(iq,D3_RA_RA_RB) = (1.0d+0*t43*(t44*(2.69072839309989
     1           6d-2*t100*t101*t157*t93*t99+5.381456786199792d-2*t100*t
     2           101*t124*t93*t99-5.848223622634647d-1*t100*t101*t250*t6
     3           4*t99-8.837926660346784d-2*t155*t93*t95*t96*t97-1.76758
     4           5332069357d-1*t121*t93*t95*t96*t97+1.0d+0*t246*t46*t95*
     5           t96*t97+1.0d+0*t155*t202*t46*t96*t97+2.0d+0*t121*t202*t
     6           46*t96*t97-2.0d+0*t155*t190*t195*t46*t97-4.0d+0*t121*t1
     7           90*t195*t46*t97-4.5437964274821163d-4*t250*t68*t93+2.74
     8           7773264188437d-3*t246*t62*t93-4.7846374908957684d+0*t11
     9           9*t241*t53*t70*t73-5.980796863619711d-2*t434*t48*t49*t7
     :           0*t73-4.7846374908957684d-1*t119*t267*t49*t70*t73-7.176
     ;           956236343652d-1*t152*t244*t49*t70*t73+1.435391247268730
     <           5d+0*t115*t244*t49*t70*t73+2.3923187454478842d-1*t119*t
     =           237*t49*t70*t73-1.1961593727239421d+0*t152*t241*t48*t70
     >           *t73-2.3923187454478842d+0*t115*t241*t48*t70*t73+2.3923
     ?           187454478842d-1*t117*t237*t48*t70*t73+1.913854996358307
     @           4d+0*t117*t119*t152*t70*t73-9.487269826154375d-2*t119*t
     1           257*t53*t73-3.049479586978192d-2*t128*t244*t53*t73-2.37
     2           18174565385935d-2*t152*t257*t48*t73-4.743634913077187d-
     3           2*t115*t257*t48*t73+2.541232989148493d-3*t128*t237*t48*
     4           t73+2.0329863913187946d-2*t119*t128*t152*t73+7.69464420
     5           3726144d+0*t104*t105*t119*t222*t49*t53*t70-1.5389288407
     6           45229d+1*t105*t119*t214*t219*t49*t53*t70+2.474902206681
     7           1444d+2*t119*t214*t215*t216*t49*t53*t70-6.1557153629809
     8           16d+1*t103*t104*t105*t117*t119*t53*t70+1.92366105093153
     9           6d+0*t103*t104*t105*t237*t48*t49*t70+1.923661050931536d
     :           +0*t104*t105*t152*t222*t48*t49*t70+3.847322101863072d+0
     ;           *t104*t105*t115*t222*t48*t49*t70-3.847322101863072d+0*t
     <           105*t152*t214*t219*t48*t49*t70-7.694644203726144d+0*t10
     =           5*t115*t214*t219*t48*t49*t70+6.187255516702861d+1*t152*
     >           t214*t215*t216*t48*t49*t70+1.2374511033405722d+2*t115*t
     ?           214*t215*t216*t48*t49*t70+1.538928840745229d+1*t103*t10
     @           4*t105*t119*t152*t49*t70-1.538928840745229d+1*t103*t104
     1           *t105*t117*t152*t48*t70-3.077857681490458d+1*t103*t104*
     2           t105*t115*t117*t48*t70+1.9751631321680768d-2*(t445+t444
     3           +t443+t442+t441+t440+t439+t438+t437+t436+t435+1.9236610
     4           50931536d+0*t434+t433+t432+t414)*t64*t68+6.058395236642
     5           822d-4*t157*t200*t68+1.2116790473285642d-3*t124*t200*t6
     6           8-5.848223622634647d-1*t100*t101*t157*t212*t64-1.169644
     7           7245269295d+0*t100*t101*t124*t212*t64+1.169644724526929
     8           5d+0*t101*t157*t204*t209*t64+2.339289449053859d+0*t101*
     9           t124*t204*t209*t64-1.73158960813529d+1*t157*t204*t205*t
     :           206*t64-3.46317921627058d+1*t124*t204*t205*t206*t64-6.2
     ;           1814d-2*(t445+t444+t443+t442+t441+t440+t439+t438+t437+t
     <           436+t435+t433+t432+t414)*t46*t62-3.663697685584583d-3*t
     =           155*t200*t62-7.327395371169166d-3*t121*t200*t62-6.53888
     >           9093261956d-1*t103*t104*t105*t119*t128*t53-1.6347222733
     ?           154887d-1*t103*t104*t105*t128*t152*t48-3.26944454663097
     @           74d-1*t103*t104*t105*t115*t128*t48+1.6081979498692536d+
     1           1*t155*t190*t191*t192*t46+3.216395899738507d+1*t121*t19
     2           0*t191*t192*t46+t450+t449+t448+t447+t446+t431+t430+t429
     3           +t428+t427+t421+t419+t418+t399+t397+t396+t395+t394+t393
     4           +t392+t391+t390+t389+t388+t387+t386+t385+t384+t382+t381
     5           +t380+t379+t378+t377+t376+t375+t374+t373+t371+t366+t365
     6           +t364+t363+t362+t361+t360+t359+t358)-2.339289449053859d
     7           +0*t100*t101*t124*t64*t99+4.0d+0*t121*t46*t95*t96*t97-1
     8           .8175185709928465d-3*t124*t68*t93+1.099109305675375d-2*
     9           t121*t62*t93-4.7846374908957684d-1*t119*t152*t49*t70*t7
     :           3+9.569274981791537d-1*t115*t117*t48*t70*t73+1.01649319
     ;           56593973d-2*t115*t128*t48*t73+7.694644203726144d+0*t103
     <           *t104*t105*t115*t48*t49*t70+t426+t425+t424+t355+t354+t3
     =           53+t352+t351+t350+t349+t348+t347+t346+t345+t344+t343+t3
     >           42+t341+t340+t339+t321+t320+t318+t315+t302+t301+t300+t2
     ?           76+t261+t259+t254+t251+t247+t225)+1.0d+0*t75*(-4.133333
     @           3333333333d-52*t278*t41*t88+1.2813333333333332d-54*t132
     1           *t278*t39*t88+5.296177777777777d-106*t133*t147*t264*t39
     2           *t88-1.7084444444444444d-103*t132*t133*t147*t88+1.64181
     3           5111111111d-157*t147*t179*t338*t39*t42-7.06157037037036
     4           8d-106*t147*t180*t264*t39*t42-5.296177777777777d-155*t1
     5           47*t179*t264*t42+2.2779259259259252d-103*t132*t147*t180
     6           *t42+3.1d-3*t39*(-1.8323128990207463d-156*t147*t179*t33
     7           8*t39+7.880915694712888d-105*t147*t180*t264*t39+5.91068
     8           6771034666d-154*t147*t179*t264-2.542230869262222d-102*t
     9           132*t147*t180)*t41-2.0666666666666667d-52*t147*t265*t41
     :           +5.51111111111111d-52*t161*t180*t41+6.406666666666666d-
     ;           55*t132*t147*t265*t39+2.6480888888888887d-106*t161*t179
     <           *t264*t39-1.708444444444444d-54*t132*t161*t180*t39-8.54
     =           2222222222222d-104*t132*t161*t179)+2.0d+0*t131*t279+2.0
     >           d+0*t134*t277+1.0d+0*t160*t266+1.0d+0*t162*t263)*wght+A
     ?           mat3(iq,D3_RA_RA_RB)
              Amat3(iq,D3_RA_RB_RB) = (1.0d+0*t43*(t44*(5.38145678619979
     1           2d-2*t100*t101*t157*t93*t99+2.690728393099896d-2*t100*t
     2           101*t124*t93*t99-5.848223622634647d-1*t100*t101*t316*t6
     3           4*t99-1.767585332069357d-1*t155*t93*t95*t96*t97-8.83792
     4           6660346784d-2*t121*t93*t95*t96*t97+1.0d+0*t313*t46*t95*
     5           t96*t97+2.0d+0*t155*t202*t46*t96*t97+1.0d+0*t121*t202*t
     6           46*t96*t97-4.0d+0*t155*t190*t195*t46*t97-2.0d+0*t121*t1
     7           90*t195*t46*t97-4.5437964274821163d-4*t316*t68*t93+2.74
     8           7773264188437d-3*t313*t62*t93+4.7846374908957684d+0*t11
     9           9*t241*t53*t70*t73-5.980796863619711d-2*t451*t48*t49*t7
     :           0*t73-2.3923187454478842d-1*t119*t308*t49*t70*t73+4.784
     ;           6374908957684d-1*t119*t267*t49*t70*t73+1.43539124726873
     <           05d+0*t152*t244*t49*t70*t73-7.176956236343652d-1*t115*t
     =           244*t49*t70*t73+2.3923187454478842d-1*t117*t308*t48*t70
     >           *t73-2.3923187454478842d+0*t152*t241*t48*t70*t73-1.1961
     ?           593727239421d+0*t115*t241*t48*t70*t73-1.913854996358307
     @           4d+0*t115*t117*t119*t70*t73+9.487269826154374d-2*t119*t
     1           257*t53*t73-3.0494795869781915d-2*t128*t244*t53*t73+2.5
     2           41232989148493d-3*t128*t308*t48*t73-4.743634913077187d-
     3           2*t152*t257*t48*t73-2.3718174565385935d-2*t115*t257*t48
     4           *t73-2.0329863913187946d-2*t115*t119*t128*t73-7.6946442
     5           03726144d+0*t104*t105*t119*t222*t49*t53*t70+1.538928840
     6           745229d+1*t105*t119*t214*t219*t49*t53*t70-2.47490220668
     7           11444d+2*t119*t214*t215*t216*t49*t53*t70+6.155715362980
     8           916d+1*t103*t104*t105*t117*t119*t53*t70+1.9236610509315
     9           36d+0*t103*t104*t105*t308*t48*t49*t70+3.847322101863072
     :           d+0*t104*t105*t152*t222*t48*t49*t70+1.923661050931536d+
     ;           0*t104*t105*t115*t222*t48*t49*t70-7.694644203726144d+0*
     <           t105*t152*t214*t219*t48*t49*t70-3.847322101863072d+0*t1
     =           05*t115*t214*t219*t48*t49*t70+1.2374511033405722d+2*t15
     >           2*t214*t215*t216*t48*t49*t70+6.187255516702861d+1*t115*
     ?           t214*t215*t216*t48*t49*t70-1.538928840745229d+1*t103*t1
     @           04*t105*t115*t119*t49*t70-3.077857681490458d+1*t103*t10
     1           4*t105*t117*t152*t48*t70-1.538928840745229d+1*t103*t104
     2           *t105*t115*t117*t48*t70+1.9751631321680768d-2*(t461+t46
     3           0+t459+t458+t457+t456+t455+t454+t453+t452+1.92366105093
     4           1536d+0*t451+t444+t432+t417+t414)*t64*t68+1.21167904732
     5           85642d-3*t157*t200*t68+6.058395236642822d-4*t124*t200*t
     6           68-1.1696447245269295d+0*t100*t101*t157*t212*t64-5.8482
     7           23622634647d-1*t100*t101*t124*t212*t64+2.33928944905385
     8           9d+0*t101*t157*t204*t209*t64+1.1696447245269295d+0*t101
     9           *t124*t204*t209*t64-3.46317921627058d+1*t157*t204*t205*
     :           t206*t64-1.73158960813529d+1*t124*t204*t205*t206*t64-6.
     ;           21814d-2*t46*(t461+t460+t459+t458+t457+t456+t455+t454+t
     <           453+t452+t444+t432+t417+t414)*t62-7.327395371169166d-3*
     =           t155*t200*t62-3.663697685584583d-3*t121*t200*t62+6.5388
     >           89093261955d-1*t103*t104*t105*t119*t128*t53-3.269444546
     ?           6309774d-1*t103*t104*t105*t128*t152*t48-1.6347222733154
     @           887d-1*t103*t104*t105*t115*t128*t48+3.216395899738507d+
     1           1*t155*t190*t191*t192*t46+1.6081979498692536d+1*t121*t1
     2           90*t191*t192*t46+t449+t448+t447+t446+t431+t430+t429+t42
     3           8+t427+t423+t421+t419+t418+t399+t397+t396+t395+t394+t39
     4           3+t392+t391+t390+t389+t388+t387+t386+t385+t384+t382+t38
     5           1+t380+t379+t378+t377+t376+t375+t374+t373+t371+t366+t36
     6           5+t364+t363+t362+t361+t360+t359+t358)-2.339289449053859
     7           d+0*t100*t101*t157*t64*t99+4.0d+0*t155*t46*t95*t96*t97-
     8           1.8175185709928465d-3*t157*t68*t93+1.099109305675375d-2
     9           *t155*t62*t93+4.7846374908957684d-1*t115*t119*t49*t70*t
     :           73+9.569274981791537d-1*t117*t152*t48*t70*t73+1.0164931
     ;           956593973d-2*t128*t152*t48*t73+7.694644203726144d+0*t10
     <           3*t104*t105*t152*t48*t49*t70+t426+t425+t424+t355+t354+t
     =           353+t352+t351+t350+t349+t348+t347+t346+t345+t344+t343+t
     >           342+t341+t340+t339+t323+t322+t319+t317+t314+t303+t276+t
     ?           256+t255+t252+t248+t218+t208+t194)+1.0d+0*t75*(3.1d-3*t
     @           39*t41*(-1.8323128990207463d-156*t296*t338*t39*t88+7.88
     1           0915694712888d-105*t264*t297*t39*t88-2.542230869262222d
     2           -102*t132*t297*t88+5.910686771034666d-154*t264*t296*t88
     3           )+1.641815111111111d-157*t296*t338*t39*t42*t88-7.061570
     4           370370369d-106*t264*t297*t39*t42*t88+2.2779259259259257
     5           d-103*t132*t297*t42*t88-5.296177777777777d-155*t264*t29
     6           6*t42*t88-2.0666666666666667d-52*t325*t41*t88+6.4066666
     7           66666666d-55*t132*t325*t39*t88+5.296177777777777d-106*t
     8           147*t161*t264*t39*t88-1.7084444444444444d-103*t132*t147
     9           *t161*t88+5.51111111111111d-52*t133*t297*t41-4.13333333
     :           33333333d-52*t147*t278*t41-1.708444444444444d-54*t132*t
     ;           133*t297*t39+2.6480888888888887d-106*t133*t264*t296*t39
     <           +1.2813333333333332d-54*t132*t147*t278*t39-8.5422222222
     =           22222d-104*t132*t133*t296)+1.0d+0*t131*t326+1.0d+0*t134
     >           *t324+2.0d+0*t160*t279+2.0d+0*t162*t277)*wght+Amat3(iq,
     ?           D3_RA_RB_RB)
              Amat3(iq,D3_RB_RB_RB) = (1.0d+0*t43*(t44*(8.07218517929968
     1           7d-2*t100*t101*t157*t93*t99-1.7544670867903941d+0*t100*
     2           t101*t316*t64*t99-2.6513779981040353d-1*t155*t93*t95*t9
     3           6*t97+3.0d+0*t313*t46*t95*t96*t97+3.0d+0*t155*t202*t46*
     4           t96*t97-6.0d+0*t155*t190*t195*t46*t97-1.363138928244635
     5           d-3*t316*t68*t93+8.243319792565312d-3*t313*t62*t93+1.43
     6           53912472687305d+1*t119*t241*t53*t70*t73-5.9807968636197
     7           11d-2*t473*t48*t49*t70*t73+7.176956236343652d-1*t119*t3
     8           08*t49*t70*t73-2.1530868709030954d+0*t152*t244*t49*t70*
     9           t73+7.176956236343652d-1*t117*t308*t48*t70*t73-3.588478
     :           118171826d+0*t152*t241*t48*t70*t73-5.741564989074922d+0
     ;           *t117*t119*t152*t70*t73+2.8461809478463124d-1*t119*t257
     <           *t53*t73+7.623698967445479d-3*t128*t308*t48*t73-7.11545
     =           236961578d-2*t152*t257*t48*t73-6.098959173956384d-2*t11
     >           9*t128*t152*t73-2.3083932611178434d+1*t104*t105*t119*t2
     ?           22*t49*t53*t70+4.616786522235687d+1*t105*t119*t214*t219
     @           *t49*t53*t70-7.424706620043432d+2*t119*t214*t215*t216*t
     1           49*t53*t70+1.8467146088942746d+2*t103*t104*t105*t117*t1
     2           19*t53*t70+5.770983152794609d+0*t103*t104*t105*t308*t48
     3           *t49*t70+5.770983152794609d+0*t104*t105*t152*t222*t48*t
     4           49*t70-1.1541966305589217d+1*t105*t152*t214*t219*t48*t4
     5           9*t70+1.856176655010858d+2*t152*t214*t215*t216*t48*t49*
     6           t70-4.616786522235687d+1*t103*t104*t105*t119*t152*t49*t
     7           70-4.616786522235687d+1*t103*t104*t105*t117*t152*t48*t7
     8           0+1.9751631321680768d-2*(t480+t479+t478+t477+t476+t475+
     9           t474+1.923661050931536d+0*t473+t445+t416+t414)*t64*t68+
     :           1.8175185709928465d-3*t157*t200*t68-1.7544670867903941d
     ;           +0*t100*t101*t157*t212*t64+3.5089341735807883d+0*t101*t
     <           157*t204*t209*t64-5.19476882440587d+1*t157*t204*t205*t2
     =           06*t64-6.21814d-2*t46*(t480+t479+t478+t477+t476+t475+t4
     >           74+t445+t416+t414)*t62-1.099109305675375d-2*t155*t200*t
     ?           62+1.9616667279785865d+0*t103*t104*t105*t119*t128*t53-4
     @           .904166819946466d-1*t103*t104*t105*t128*t152*t48+4.8245
     1           93849607761d+1*t155*t190*t191*t192*t46+t450+t422+t421+t
     2           420+t419+t418+t399+t398+t397+t396+t395+t394+t393+t392+t
     3           391+t390+t389+t388+t387+t386+t385+t384+t382+t381+t380+t
     4           379+t378+t377+t376+t375+t374+t373+t371+t366+t365+t364+t
     5           363+t362+t361+t360+t359+t358)-3.5089341735807883d+0*t10
     6           0*t101*t157*t64*t99+6.0d+0*t155*t46*t95*t96*t97-2.72627
     7           785648927d-3*t157*t68*t93+1.6486639585130625d-2*t155*t6
     8           2*t93-5.741564989074922d+0*t117*t119*t53*t70*t73-1.7942
     9           39059085913d-1*t308*t48*t49*t70*t73+1.4353912472687305d
     :           +0*t119*t152*t49*t70*t73+1.4353912472687305d+0*t117*t15
     ;           2*t48*t70*t73-6.098959173956384d-2*t119*t128*t53*t73+1.
     <           524739793489096d-2*t128*t152*t48*t73-4.616786522235687d
     =           +1*t103*t104*t105*t119*t49*t53*t70+1.1541966305589217d+
     >           1*t103*t104*t105*t152*t48*t49*t70+5.92548939650423d-2*t
     ?           316*t64*t68-1.865442d-1*t313*t46*t62-rhob*t467-3.330669
     @           0738754696d-16*t135*t140*t287*t37+6.661338147750939d-16
     1           *t135*t281*t283*t37-5.356375176299456d-15*t280*t281*t28
     2           2*t37+1.2202564577405706d-18*t285*t36+t356+t355+t354+t3
     3           53+t352+t351+t350+t349+t348+t347+t346+t345+t344+t343+t3
     4           42+t341+t340+t339-3.0d+0*t141*t143*t292*t33+6.0d+0*t141
     5           *t289*t291*t33-9.649187699215522d+1*t288*t289*t290*t33+
     6           5.284159572535705d-3*t285*t32+2.549392377400174d-1*t137
     7           *t141*t142*t143+2.943620900479655d-17*t135*t137*t139*t1
     8           40)+1.0d+0*(3.1d-3*t39*t41*(2.2552048033777775d-50*t41*
     9           t472-6.991134890471111d-53*t132*t39*t472+2.364274708413
     :           8666d-104*t264*t39*t471-7.626692607786666d-102*t132*t47
     ;           1-1.8323128990207463d-156*t338*t39*t470+5.9106867710346
     <           66d-154*t264*t470)-2.0207407407407404d-51*t41*t42*t472+
     =           6.264296296296294d-54*t132*t39*t42*t472-2.1184711111111
     >           11d-105*t264*t39*t42*t471+6.833777777777776d-103*t132*t
     ?           42*t471+1.641815111111111d-157*t338*t39*t42*t470-5.2961
     @           77777777777d-155*t264*t42*t470-6.2d-52*t147*t325*t41+1.
     1           6533333333333333d-51*t161*t297*t41+1.9219999999999998d-
     2           54*t132*t147*t325*t39-5.125333333333332d-54*t132*t161*t
     3           297*t39+7.944266666666666d-106*t161*t264*t296*t39-2.562
     4           6666666666664d-103*t132*t161*t296)*t75+5.0d-1*rhob*t38*
     5           (2.4d-51*t20*t22*(-8.695883484444443d-50*t22*t472+7.778
     6           863044266666d-100*t145*t471-2.2198218931199998d-150*t29
     7           4*t470+2.04906636288d-201*t468*t469)-3.911111111111111d
     8           -50*t22*t23*t472+3.4986666666666666d-100*t145*t23*t471-
     9           9.984000000000001d-151*t23*t294*t470+9.216000000000001d
     :           -202*t23*t468*t469-1.2d-50*t147*t22*t298+2.88d-101*t145
     ;           *t146*t298+3.2d-50*t148*t22*t297-1.7279999999999998d-10
     <           0*t145*t148*t296+2.3040000000000002d-151*t148*t294*t295
     =           )+5.0d-1*rhob*t24*t467+1.5d+0*t299*t38+3.0d+0*t160*t326
     >           +3.0d+0*t162*t324+1.5d+0*rhob*t144*t299+1.5d+0*t24*t293
     ?           +1.5d+0*rhob*t149*t293+3.0d+0*t144*t149)*wght+Amat3(iq,
     @           D3_RB_RB_RB)
              Cmat3(iq,D3_RA_RA_GAA) = Cmat3(iq,D3_RA_RA_GAA)
              Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
              Cmat3(iq,D3_RA_RA_GBB) = Cmat3(iq,D3_RA_RA_GBB)
              Cmat3(iq,D3_RA_RB_GAA) = Cmat3(iq,D3_RA_RB_GAA)
              Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
              Cmat3(iq,D3_RA_RB_GBB) = Cmat3(iq,D3_RA_RB_GBB)
              Cmat3(iq,D3_RB_RB_GAA) = Cmat3(iq,D3_RB_RB_GAA)
              Cmat3(iq,D3_RB_RB_GAB) = Cmat3(iq,D3_RB_RB_GAB)
              Cmat3(iq,D3_RB_RB_GBB) = Cmat3(iq,D3_RB_RB_GBB)
              Cmat3(iq,D3_RA_GAA_GAA) = Cmat3(iq,D3_RA_GAA_GAA)
              Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
              Cmat3(iq,D3_RA_GAA_GBB) = Cmat3(iq,D3_RA_GAA_GBB)
              Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
              Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
              Cmat3(iq,D3_RA_GBB_GBB) = Cmat3(iq,D3_RA_GBB_GBB)
              Cmat3(iq,D3_RB_GAA_GAA) = Cmat3(iq,D3_RB_GAA_GAA)
              Cmat3(iq,D3_RB_GAA_GAB) = Cmat3(iq,D3_RB_GAA_GAB)
              Cmat3(iq,D3_RB_GAA_GBB) = Cmat3(iq,D3_RB_GAA_GBB)
              Cmat3(iq,D3_RB_GAB_GAB) = Cmat3(iq,D3_RB_GAB_GAB)
              Cmat3(iq,D3_RB_GAB_GBB) = Cmat3(iq,D3_RB_GAB_GBB)
              Cmat3(iq,D3_RB_GBB_GBB) = Cmat3(iq,D3_RB_GBB_GBB)
              Cmat3(iq,D3_GAA_GAA_GAA) = Cmat3(iq,D3_GAA_GAA_GAA)
              Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
              Cmat3(iq,D3_GAA_GAA_GBB) = Cmat3(iq,D3_GAA_GAA_GBB)
              Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
              Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
              Cmat3(iq,D3_GAA_GBB_GBB) = Cmat3(iq,D3_GAA_GBB_GBB)
              Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
              Cmat3(iq,D3_GAB_GAB_GBB) = Cmat3(iq,D3_GAB_GAB_GBB)
              Cmat3(iq,D3_GAB_GBB_GBB) = Cmat3(iq,D3_GAB_GBB_GBB)
              Cmat3(iq,D3_GBB_GBB_GBB) = Cmat3(iq,D3_GBB_GBB_GBB)
              Mmat3(iq,D3_RA_RA_TA) = Mmat3(iq,D3_RA_RA_TA)
              Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
              Mmat3(iq,D3_RA_RB_TA) = Mmat3(iq,D3_RA_RB_TA)
              Mmat3(iq,D3_RA_RB_TB) = Mmat3(iq,D3_RA_RB_TB)
              Mmat3(iq,D3_RB_RB_TA) = Mmat3(iq,D3_RB_RB_TA)
              Mmat3(iq,D3_RB_RB_TB) = Mmat3(iq,D3_RB_RB_TB)
              Mmat3(iq,D3_RA_GAA_TA) = Mmat3(iq,D3_RA_GAA_TA)
              Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
              Mmat3(iq,D3_RA_GAB_TA) = Mmat3(iq,D3_RA_GAB_TA)
              Mmat3(iq,D3_RA_GAB_TB) = Mmat3(iq,D3_RA_GAB_TB)
              Mmat3(iq,D3_RA_GBB_TA) = Mmat3(iq,D3_RA_GBB_TA)
              Mmat3(iq,D3_RA_GBB_TB) = Mmat3(iq,D3_RA_GBB_TB)
              Mmat3(iq,D3_RB_GAA_TA) = Mmat3(iq,D3_RB_GAA_TA)
              Mmat3(iq,D3_RB_GAA_TB) = Mmat3(iq,D3_RB_GAA_TB)
              Mmat3(iq,D3_RB_GAB_TA) = Mmat3(iq,D3_RB_GAB_TA)
              Mmat3(iq,D3_RB_GAB_TB) = Mmat3(iq,D3_RB_GAB_TB)
              Mmat3(iq,D3_RB_GBB_TA) = Mmat3(iq,D3_RB_GBB_TA)
              Mmat3(iq,D3_RB_GBB_TB) = Mmat3(iq,D3_RB_GBB_TB)
              Mmat3(iq,D3_RA_TA_TA) = Mmat3(iq,D3_RA_TA_TA)
              Mmat3(iq,D3_RA_TA_TB) = Mmat3(iq,D3_RA_TA_TB)
              Mmat3(iq,D3_RA_TB_TB) = Mmat3(iq,D3_RA_TB_TB)
              Mmat3(iq,D3_RB_TA_TA) = Mmat3(iq,D3_RB_TA_TA)
              Mmat3(iq,D3_RB_TA_TB) = Mmat3(iq,D3_RB_TA_TB)
              Mmat3(iq,D3_RB_TB_TB) = Mmat3(iq,D3_RB_TB_TB)
              Mmat3(iq,D3_GAA_GAA_TA) = Mmat3(iq,D3_GAA_GAA_TA)
              Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
              Mmat3(iq,D3_GAA_GAB_TA) = Mmat3(iq,D3_GAA_GAB_TA)
              Mmat3(iq,D3_GAA_GAB_TB) = Mmat3(iq,D3_GAA_GAB_TB)
              Mmat3(iq,D3_GAA_GBB_TA) = Mmat3(iq,D3_GAA_GBB_TA)
              Mmat3(iq,D3_GAA_GBB_TB) = Mmat3(iq,D3_GAA_GBB_TB)
              Mmat3(iq,D3_GAB_GAB_TA) = Mmat3(iq,D3_GAB_GAB_TA)
              Mmat3(iq,D3_GAB_GAB_TB) = Mmat3(iq,D3_GAB_GAB_TB)
              Mmat3(iq,D3_GAB_GBB_TA) = Mmat3(iq,D3_GAB_GBB_TA)
              Mmat3(iq,D3_GAB_GBB_TB) = Mmat3(iq,D3_GAB_GBB_TB)
              Mmat3(iq,D3_GBB_GBB_TA) = Mmat3(iq,D3_GBB_GBB_TA)
              Mmat3(iq,D3_GBB_GBB_TB) = Mmat3(iq,D3_GBB_GBB_TB)
              Mmat3(iq,D3_GAA_TA_TA) = Mmat3(iq,D3_GAA_TA_TA)
              Mmat3(iq,D3_GAA_TA_TB) = Mmat3(iq,D3_GAA_TA_TB)
              Mmat3(iq,D3_GAA_TB_TB) = Mmat3(iq,D3_GAA_TB_TB)
              Mmat3(iq,D3_GAB_TA_TA) = Mmat3(iq,D3_GAB_TA_TA)
              Mmat3(iq,D3_GAB_TA_TB) = Mmat3(iq,D3_GAB_TA_TB)
              Mmat3(iq,D3_GAB_TB_TB) = Mmat3(iq,D3_GAB_TB_TB)
              Mmat3(iq,D3_GBB_TA_TA) = Mmat3(iq,D3_GBB_TA_TA)
            endif 
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhoa**2.6666666666666666d+0
              t2 = 6.0d-2*gammaaa*t1+1.0d+0
              t3 = 1/t2
              t4 = 1.3340275799999998d-1*gammaaa*t1*t3-2.5960897d+0
              t5 = 6.0d-2*gammaaa*t1*t3*t4+1.0d+0
              t6 = 1/rhoa**6.666666666666666d-1
              t7 = rhoa**5.0d-1
              t8 = 1/t7
              t9 = 1/rhoa**3.333333333333333d-1
              t10 = 1/rhoa**1.6666666666666666d-1
              t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.4
     1           058712912881916d-1*t6+1.1120374863094686d+1*t10
              t12 = 3.216395899738507d+1/t11+1.0d+0
              t13 = log(t12)
              t14 = 1.274696188700087d-1*t9+1.0d+0
              t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.8
     1           970043257475583d-1*t6+5.982550435771079d+0*t10
              t16 = 1.6081979498692536d+1/t15+1.0d+0
              t17 = log(t16)
              t18 = 1.3256889990520176d-1*t9+1.0d+0
              t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2
     1           *t13*t14
              t20 = 1/taua
              t21 = 1/rhoa
              t22 = 2.0d+0*taua-2.5d-1*gammaaa*t21
              t23 = 1/t16
              t24 = 1/rhoa**1.6666666666666669d+0
              t25 = 1/t7**3
              t26 = 1/rhoa**1.3333333333333333d+0
              t27 = 1/rhoa**1.1666666666666667d+0
              t28 = -9.970917392951799d-1*t27-7.418564737168958d-1*t26-4
     1           .002143174996817d-1*t25-1.264669550498372d-1*t24
              t29 = 1/t15**2
              t30 = 1/t12
              t31 = -1.8533958105157808d+0*t27-1.2815820791490704d+0*t26
     1           -8.223668877838045d-1*t25-1.6039141941921276d-1*t24
              t32 = 1/t11**2
              t33 = 1.0d+0*t14*t30*t31*t32+1.1102230246251565d-16*t18*t2
     1           3*t28*t29+3.0506411443514264d-19*t17*t26+1.321039893133
     2           9265d-3*t13*t26
              t34 = gammaaa**2
              t35 = 1/t2**2
              t36 = 1/rhoa**6.333333333333333d+0
              t37 = 1/rhoa**3.6666666666666664d+0
              t38 = 2.1344441279999993d-2*t34*t35*t36-3.557406879999999d
     1           -1*gammaaa*t3*t37
              t39 = -1.5999999999999998d-1*gammaaa*t3*t37*t4+9.599999999
     1           999997d-3*t34*t35*t36*t4+6.0d-2*gammaaa*t1*t3*t38
              t40 = -1.25d-1*t19*t5*wght
              t41 = 1/rhoa**5.333333333333333d+0
              t42 = 1.3340275799999998d-1*t1*t3-8.004165479999998d-3*gam
     1           maaa*t35*t41
              t43 = 6.0d-2*gammaaa*t1*t3*t42-3.6d-3*gammaaa*t35*t4*t41+6
     1           .0d-2*t1*t3*t4
              t44 = 1/taua**2
              t45 = 1/rhoa**2
              t46 = 1/t16**2
              t47 = t28**2
              t48 = 1/t15**4
              t49 = 1/t15**3
              t50 = 1/t7**5
              t51 = 1/rhoa**2.3333333333333334d+0
              t52 = 1/rhoa**2.1666666666666665d+0
              t53 = 1.1632736958443765d+0*t52+9.89141964955861d-1*t51+6.
     1           003214762495226d-1*t50+2.1077825841639536d-1*t1
              t54 = 1/t12**2
              t55 = t31**2
              t56 = 1/t11**4
              t57 = 1/t11**3
              t58 = 2.1622951122684114d+0*t52+1.7087761055320938d+0*t51+
     1           1.2335503316757068d+0*t50+2.673190323653546d-1*t1
              t59 = 1.0d+0*t14*t30*t32*t58-2.0d+0*t14*t30*t55*t57+3.2163
     1           95899738507d+1*t14*t54*t55*t56+1.1102230246251565d-16*t
     2           18*t23*t29*t53-4.0675215258019015d-19*t17*t51-1.7613865
     3           241785684d-3*t13*t51-2.220446049250313d-16*t18*t23*t47*
     4           t49+1.7854583920998188d-15*t18*t46*t47*t48-8.4979745913
     5           33913d-2*t26*t30*t31*t32-9.812069668265515d-18*t23*t26*
     6           t28*t29
              t60 = gammaaa**3
              t61 = 1/t2**3
              t62 = 1/rhoa**10
              t63 = 1/rhoa**7.333333333333333d+0
              t64 = 1/rhoa**4.666666666666667d+0
              t65 = 1.3043825226666664d+0*gammaaa*t3*t64-1.9209997151999
     1           994d-1*t34*t35*t63+6.830221209599997d-3*t60*t61*t62
              t66 = 6.0d-2*gammaaa*t1*t3*t65+5.866666666666666d-1*gammaa
     1           a*t3*t4*t64-8.639999999999998d-2*t34*t35*t4*t63+3.07199
     2           99999999986d-3*t4*t60*t61*t62-3.1999999999999995d-1*gam
     3           maaa*t3*t37*t38+1.9199999999999995d-2*t34*t35*t36*t38
              t67 = 1.25d-1*t19*t5*wght
              t68 = 1/rhoa**9
              t69 = -2.561332953599999d-3*t34*t61*t68-3.557406879999999d
     1           -1*t3*t37+6.403332383999999d-2*gammaaa*t35*t36
              t70 = 6.0d-2*gammaaa*t1*t3*t69-1.1519999999999996d-3*t34*t
     1           4*t61*t68-1.5999999999999998d-1*gammaaa*t3*t37*t42+9.59
     2           9999999999997d-3*t34*t35*t36*t42-3.6d-3*gammaaa*t35*t38
     3           *t41-1.5999999999999998d-1*t3*t37*t4+2.879999999999999d
     4           -2*gammaaa*t35*t36*t4+6.0d-2*t1*t3*t38
              t71 = 1/rhoa**8
              t72 = 9.604998575999998d-4*gammaaa*t61*t71-1.6008330959999
     1           997d-2*t35*t41
              t73 = 6.0d-2*gammaaa*t1*t3*t72+4.32d-4*gammaaa*t4*t61*t71-
     1           7.2d-3*gammaaa*t35*t41*t42+1.2d-1*t1*t3*t42-7.2d-3*t35*
     2           t4*t41
              t74 = -5.0d-1*rhoa*t22*t33*t5*wght-5.0d-1*t19*t22*t5*wght-
     1           5.0d-1*rhoa*t19*t22*t39*wght
              t75 = t67-5.0d-1*rhoa*t19*t22*t43*wght
              t76 = 1/taua**3
              t77 = 1/rhoa**3
              t78 = t28**3
              t79 = 1/t7**7
              t80 = 1/rhoa**3.3333333333333337d+0
              t81 = 1/rhoa**3.1666666666666665d+0
              t82 = t31**3
              t83 = gammaaa**4
              t84 = 1/t2**4
              t85 = 1/rhoa**1.3666666666666666d+1
              t86 = 1/rhoa**11
              t87 = 1/rhoa**8.333333333333334d+0
              t88 = 1/rhoa**5.666666666666667d+0
              t89 = 1.25d-1*t33*t5*wght
              t90 = 1.25d-1*t19*t39*wght
              t91 = t40-1.25d-1*gammaaa*t19*t43*wght
              t92 = 1/rhoa**1.2666666666666665d+1
              t93 = 2.5d-1*t19*t43*wght
              t94 = 1/rhoa**1.1666666666666665d+1
              t95 = 1/rhoa**1.0666666666666666d+1
              fnc(iq) = 5.0d-1*rhoa*t19*t20*t22*t5*wght+fnc(iq)
              Amat(iq,D1_RA) = t20*(5.0d-1*rhoa*t22*t33*t5*wght+5.0d-1*t
     1           19*t22*t5*wght+5.0d-1*rhoa*t19*t22*t39*wght)+1.25d-1*ga
     2           mmaaa*t19*t20*t21*t5*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = t20*(5.0d-1*rhoa*t19*t22*t43*wght+t40)+C
     1           mat(iq,D1_GAA)
              Mmat(iq,D1_TA) = -5.0d-1*rhoa*t19*t22*t44*t5*wght+1.0d+0*r
     1           hoa*t19*t20*t5*wght+Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = t20*(5.0d-1*rhoa*t19*t22*t66*wght+5.0
     1           d-1*rhoa*t22*t5*t59*wght+1.25d-1*gammaaa*t19*t45*t5*wgh
     2           t+1.0d+0*t22*t33*t5*wght+1.25d-1*gammaaa*t21*t33*t5*wgh
     3           t+1.0d+0*rhoa*t22*t33*t39*wght+1.0d+0*t19*t22*t39*wght+
     4           1.25d-1*gammaaa*t19*t21*t39*wght)+t20*t21*(1.25d-1*gamm
     5           aaa*t33*t5*wght+1.25d-1*gammaaa*t19*t39*wght)-1.25d-1*g
     6           ammaaa*t19*t20*t45*t5*wght+Amat2(iq,D2_RA_RA)
              Cmat2(iq,D2_RA_GAA) = t20*(5.0d-1*rhoa*t19*t22*t70*wght-1.
     1           25d-1*t33*t5*wght-1.25d-1*t19*t21*t5*wght+5.0d-1*rhoa*t
     2           22*t33*t43*wght+5.0d-1*t19*t22*t43*wght-1.25d-1*t19*t39
     3           *wght)+t20*t21*(1.25d-1*gammaaa*t19*t43*wght+t67)+Cmat2
     4           (iq,D2_RA_GAA)
              Cmat2(iq,D2_GAA_GAA) = t20*(5.0d-1*rhoa*t19*t22*t73*wght-2
     1           .5d-1*t19*t43*wght)+Cmat2(iq,D2_GAA_GAA)
              Mmat2(iq,D2_RA_TA) = t20*(1.0d+0*rhoa*t33*t5*wght+1.0d+0*t
     1           19*t5*wght+1.0d+0*rhoa*t19*t39*wght)-1.25d-1*gammaaa*t1
     2           9*t21*t44*t5*wght+t44*t74+Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = 1.0d+0*rhoa*t19*t20*t43*wght+t44*t75
     1           +Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_TA_TA) = 1.0d+0*rhoa*t19*t22*t5*t76*wght-2.0d+
     1           0*rhoa*t19*t44*t5*wght+Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
              Amat3(iq,D3_RA_RA_RA) = t20*(5.0d-1*rhoa*t19*t22*(6.0d-2*g
     1           ammaaa*t1*t3*(-6.08711843911111d+0*gammaaa*t3*t88+1.617
     2           434328106666d+0*t34*t35*t87-1.2977420298239994d-1*t60*t
     3           61*t86+3.2785061806079985d-3*t83*t84*t85)-2.73777777777
     4           7778d+0*gammaaa*t3*t4*t88+7.274666666666665d-1*t34*t35*
     5           t4*t87-5.836799999999998d-2*t4*t60*t61*t86+1.4745599999
     6           999992d-3*t4*t83*t84*t85-4.799999999999999d-1*gammaaa*t
     7           3*t37*t65+2.879999999999999d-2*t34*t35*t36*t65+1.76d+0*
     8           gammaaa*t3*t38*t64-2.5919999999999993d-1*t34*t35*t38*t6
     9           3+9.215999999999996d-3*t38*t60*t61*t62)*wght+5.0d-1*rho
     :           a*t22*t5*(6.0d+0*t14*t30*t56*t82-1.9298375398431045d+2*
     ;           t14*t54*t82/t11**5+2.0690405167709364d+3*t14*t82/(t11**
     <           6*t12**3)+1.1102230246251565d-16*t18*t23*t29*(-2.520426
     =           340996149d+0*t81-2.3079979182303428d+0*t80-1.5008036906
     >           238065d+0*t79-5.620753557770543d-1*t37)+1.0d+0*t14*t30*
     ?           t32*(-4.684972743248224d+0*t81-3.9871442462415524d+0*t8
     @           0-3.083875829189267d+0*t79-7.128507529742789d-1*t37)+9.
     1           490883560204437d-19*t17*t80+4.1099018897499934d-3*t13*t
     2           80+6.661338147750939d-16*t18*t23*t48*t78-1.071275035259
     3           8913d-14*t18*t46*t78/t15**5+5.742741051503565d-14*t18*t
     4           78/(t15**6*t16**3)-6.0d+0*t14*t30*t31*t57*t58+9.6491876
     5           99215522d+1*t14*t31*t54*t56*t58-1.274696188700087d-1*t2
     6           6*t30*t32*t58+2.549392377400174d-1*t26*t30*t55*t57-4.09
     7           99275947472624d+0*t26*t54*t55*t56-6.661338147750939d-16
     8           *t18*t23*t28*t49*t53+5.356375176299456d-15*t18*t28*t46*
     9           t48*t53-1.4718104502398274d-17*t23*t26*t29*t53+1.699594
     :           9182667827d-1*t30*t31*t32*t51+1.962413933653103d-17*t23
     ;           *t28*t29*t51+2.943620900479655d-17*t23*t26*t47*t49-2.36
     <           69625486718335d-16*t26*t46*t47*t48)*wght-2.5d-1*gammaaa
     =           *t19*t5*t77*wght+1.5d+0*rhoa*t22*t33*t66*wght+1.5d+0*t1
     >           9*t22*t66*wght+2.5d-1*gammaaa*t19*t21*t66*wght+1.5d+0*t
     ?           22*t5*t59*wght+2.5d-1*gammaaa*t21*t5*t59*wght+1.5d+0*rh
     @           oa*t22*t39*t59*wght+2.5d-1*gammaaa*t33*t45*t5*wght+2.5d
     1           -1*gammaaa*t19*t39*t45*wght+3.0d+0*t22*t33*t39*wght+5.0
     2           d-1*gammaaa*t21*t33*t39*wght)+t20*t21*(1.25d-1*gammaaa*
     3           t19*t66*wght+1.25d-1*gammaaa*t5*t59*wght+2.5d-1*gammaaa
     4           *t33*t39*wght)+t20*t45*(-2.5d-1*gammaaa*t33*t5*wght-2.5
     5           d-1*gammaaa*t19*t39*wght)+2.5d-1*gammaaa*t19*t20*t5*t77
     6           *wght+Amat3(iq,D3_RA_RA_RA)
              Cmat3(iq,D3_RA_RA_GAA) = t20*(5.0d-1*rhoa*t19*t22*(6.0d-2*
     1           gammaaa*t1*t3*(-1.2294398177279994d-3*t60*t84*t92+1.304
     2           3825226666664d+0*t3*t64-4.624628943999999d-1*gammaaa*t3
     3           5*t63+4.3542660211199985d-2*t34*t61*t62)-5.529599999999
     4           998d-4*t4*t60*t84*t92-3.1999999999999995d-1*gammaaa*t3*
     5           t37*t69+1.9199999999999995d-2*t34*t35*t36*t69-2.3039999
     6           99999999d-3*t34*t38*t61*t68-3.6d-3*gammaaa*t35*t41*t65+
     7           6.0d-2*t1*t3*t65+5.866666666666666d-1*gammaaa*t3*t42*t6
     8           4+5.866666666666666d-1*t3*t4*t64-8.639999999999998d-2*t
     9           34*t35*t42*t63-2.0799999999999996d-1*gammaaa*t35*t4*t63
     :           +3.0719999999999986d-3*t42*t60*t61*t62+1.95839999999999
     ;           93d-2*t34*t4*t61*t62-3.1999999999999995d-1*t3*t37*t38+5
     <           .759999999999998d-2*gammaaa*t35*t36*t38)*wght+1.0d+0*rh
     =           oa*t22*t33*t70*wght+1.0d+0*t19*t22*t70*wght+1.25d-1*gam
     >           maaa*t19*t21*t70*wght-1.25d-1*t19*t66*wght-1.25d-1*t5*t
     ?           59*wght+5.0d-1*rhoa*t22*t43*t59*wght+1.25d-1*t19*t45*t5
     @           *wght-1.25d-1*t21*t33*t5*wght+1.25d-1*gammaaa*t19*t43*t
     1           45*wght+1.0d+0*t22*t33*t43*wght+1.25d-1*gammaaa*t21*t33
     2           *t43*wght-2.5d-1*t33*t39*wght-1.25d-1*t19*t21*t39*wght)
     3           +t20*t21*(1.25d-1*gammaaa*t19*t70*wght+1.25d-1*gammaaa*
     4           t33*t43*wght+t90+t89)+t20*t45*t91+Cmat3(iq,D3_RA_RA_GAA
     5           )
              Cmat3(iq,D3_RA_GAA_GAA) = t20*(5.0d-1*rhoa*t19*t22*(6.0d-2
     1           *gammaaa*t1*t3*(4.6103993164799983d-4*t34*t84*t94-1.280
     2           6664767999995d-2*gammaaa*t61*t68+8.537776511999997d-2*t
     3           35*t36)+2.073599999999999d-4*t34*t4*t84*t94-1.599999999
     4           9999998d-1*gammaaa*t3*t37*t72+9.599999999999997d-3*t34*
     5           t35*t36*t72+4.32d-4*gammaaa*t38*t61*t71-7.2d-3*gammaaa*
     6           t35*t41*t69+1.2d-1*t1*t3*t69-2.303999999999999d-3*t34*t
     7           42*t61*t68-5.759999999999997d-3*gammaaa*t4*t61*t68-3.19
     8           99999999999995d-1*t3*t37*t42+5.759999999999998d-2*gamma
     9           aa*t35*t36*t42-7.2d-3*t35*t38*t41+3.839999999999999d-2*
     :           t35*t36*t4)*wght+5.0d-1*rhoa*t22*t33*t73*wght+5.0d-1*t1
     ;           9*t22*t73*wght-2.5d-1*t19*t70*wght-2.5d-1*t33*t43*wght-
     <           2.5d-1*t19*t21*t43*wght)+t20*t21*(1.25d-1*gammaaa*t19*t
     =           73*wght+t93)+Cmat3(iq,D3_RA_GAA_GAA)
              Cmat3(iq,D3_GAA_GAA_GAA) = t20*(5.0d-1*rhoa*t19*t22*(6.0d-
     1           2*gammaaa*t1*t3*(2.881499572799999d-3*t61*t71-1.7288997
     2           436799997d-4*gammaaa*t84*t95)-7.776d-5*gammaaa*t4*t84*t
     3           95-1.0800000000000001d-2*gammaaa*t35*t41*t72+1.8d-1*t1*
     4           t3*t72+1.296d-3*gammaaa*t42*t61*t71+1.296d-3*t4*t61*t71
     5           -2.1600000000000003d-2*t35*t41*t42)*wght-3.75d-1*t19*t7
     6           3*wght)+Cmat3(iq,D3_GAA_GAA_GAA)
              Mmat3(iq,D3_RA_RA_TA) = t44*(-5.0d-1*rhoa*t19*t22*t66*wght
     1           -5.0d-1*rhoa*t22*t5*t59*wght-1.25d-1*gammaaa*t19*t45*t5
     2           *wght-1.0d+0*t22*t33*t5*wght-1.25d-1*gammaaa*t21*t33*t5
     3           *wght-1.0d+0*rhoa*t22*t33*t39*wght-1.0d+0*t19*t22*t39*w
     4           ght-1.25d-1*gammaaa*t19*t21*t39*wght)+t20*(1.0d+0*rhoa*
     5           t19*t66*wght+1.0d+0*rhoa*t5*t59*wght+2.0d+0*t33*t5*wght
     6           +2.0d+0*rhoa*t33*t39*wght+2.0d+0*t19*t39*wght)+t21*t44*
     7           (-1.25d-1*gammaaa*t33*t5*wght-1.25d-1*gammaaa*t19*t39*w
     8           ght)+1.25d-1*gammaaa*t19*t44*t45*t5*wght+Mmat3(iq,D3_RA
     9           _RA_TA)
              Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
              Mmat3(iq,D3_RA_GAA_TA) = t44*(-5.0d-1*rhoa*t19*t22*t70*wgh
     1           t+1.25d-1*t19*t21*t5*wght-5.0d-1*rhoa*t22*t33*t43*wght-
     2           5.0d-1*t19*t22*t43*wght+t90+t89)+t20*(1.0d+0*rhoa*t19*t
     3           70*wght+1.0d+0*rhoa*t33*t43*wght+1.0d+0*t19*t43*wght)+t
     4           21*t44*t91+Mmat3(iq,D3_RA_GAA_TA)
              Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
              Mmat3(iq,D3_GAA_GAA_TA) = t44*(t93-5.0d-1*rhoa*t19*t22*t73
     1           *wght)+1.0d+0*rhoa*t19*t20*t73*wght+Mmat3(iq,D3_GAA_GAA
     2           _TA)
              Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
              Mmat3(iq,D3_RA_TA_TA) = t44*(-2.0d+0*rhoa*t33*t5*wght-2.0d
     1           +0*t19*t5*wght-2.0d+0*rhoa*t19*t39*wght)+2.5d-1*gammaaa
     2           *t19*t21*t5*t76*wght-2*t74*t76+Mmat3(iq,D3_RA_TA_TA)
              Mmat3(iq,D3_RA_TA_TB) = Mmat3(iq,D3_RA_TA_TB)
              Mmat3(iq,D3_RA_TB_TB) = Mmat3(iq,D3_RA_TB_TB)
              Mmat3(iq,D3_GAA_TA_TA) = -2.0d+0*rhoa*t19*t43*t44*wght-2*t
     1           75*t76+Mmat3(iq,D3_GAA_TA_TA)
              Mmat3(iq,D3_GAA_TA_TB) = Mmat3(iq,D3_GAA_TA_TB)
              Mmat3(iq,D3_GAA_TB_TB) = Mmat3(iq,D3_GAA_TB_TB)
              Mmat3(iq,D3_TA_TA_TA) = -3.0d+0*rhoa*t19*t22*t5*wght/taua*
     1           *4+6.0d+0*rhoa*t19*t5*t76*wght+Mmat3(iq,D3_TA_TA_TA)
              Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
              Mmat3(iq,D3_TA_TB_TB) = Mmat3(iq,D3_TA_TB_TB)
              Mmat3(iq,D3_TB_TB_TB) = Mmat3(iq,D3_TB_TB_TB)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = 1/rhoa**2.6666666666666666d+0
              t2 = 6.0d-2*gammaaa*t1+1.0d+0
              t3 = 1/t2
              t4 = 1.3340275799999998d-1*gammaaa*t1*t3-2.5960897d+0
              t5 = 6.0d-2*gammaaa*t1*t3*t4+1.0d+0
              t6 = 1/rhoa**6.666666666666666d-1
              t7 = rhoa**5.0d-1
              t8 = 1/t7
              t9 = 1/rhoa**3.333333333333333d-1
              t10 = 1/rhoa**1.6666666666666666d-1
              t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.4
     1           058712912881916d-1*t6+1.1120374863094686d+1*t10
              t12 = 3.216395899738507d+1/t11+1.0d+0
              t13 = log(t12)
              t14 = 1.274696188700087d-1*t9+1.0d+0
              t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.8
     1           970043257475583d-1*t6+5.982550435771079d+0*t10
              t16 = 1.6081979498692536d+1/t15+1.0d+0
              t17 = log(t16)
              t18 = 1.3256889990520176d-1*t9+1.0d+0
              t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2
     1           *t13*t14
              t20 = 1/taua
              t21 = 1/rhoa
              t22 = 2.0d+0*taua-2.5d-1*gammaaa*t21
              t23 = 1/t16
              t24 = 1/rhoa**1.6666666666666669d+0
              t25 = 1/t7**3
              t26 = 1/rhoa**1.3333333333333333d+0
              t27 = 1/rhoa**1.1666666666666667d+0
              t28 = -9.970917392951799d-1*t27-7.418564737168958d-1*t26-4
     1           .002143174996817d-1*t25-1.264669550498372d-1*t24
              t29 = 1/t15**2
              t30 = 1/t12
              t31 = -1.8533958105157808d+0*t27-1.2815820791490704d+0*t26
     1           -8.223668877838045d-1*t25-1.6039141941921276d-1*t24
              t32 = 1/t11**2
              t33 = 1.0d+0*t14*t30*t31*t32+1.1102230246251565d-16*t18*t2
     1           3*t28*t29+3.0506411443514264d-19*t17*t26+1.321039893133
     2           9265d-3*t13*t26
              t34 = gammaaa**2
              t35 = 1/t2**2
              t36 = 1/rhoa**6.333333333333333d+0
              t37 = 1/rhoa**3.6666666666666664d+0
              t38 = 2.1344441279999993d-2*t34*t35*t36-3.557406879999999d
     1           -1*gammaaa*t3*t37
              t39 = -1.5999999999999998d-1*gammaaa*t3*t37*t4+9.599999999
     1           999997d-3*t34*t35*t36*t4+6.0d-2*gammaaa*t1*t3*t38
              t40 = -1.25d-1*t19*t5*wght
              t41 = 1/rhoa**5.333333333333333d+0
              t42 = 1.3340275799999998d-1*t1*t3-8.004165479999998d-3*gam
     1           maaa*t35*t41
              t43 = 6.0d-2*gammaaa*t1*t3*t42-3.6d-3*gammaaa*t35*t4*t41+6
     1           .0d-2*t1*t3*t4
              t44 = 1/taua**2
              t45 = 1/rhoa**2
              t46 = 1/t16**2
              t47 = t28**2
              t48 = 1/t15**4
              t49 = 1/t15**3
              t50 = 1/t7**5
              t51 = 1/rhoa**2.3333333333333334d+0
              t52 = 1/rhoa**2.1666666666666665d+0
              t53 = 1.1632736958443765d+0*t52+9.89141964955861d-1*t51+6.
     1           003214762495226d-1*t50+2.1077825841639536d-1*t1
              t54 = 1/t12**2
              t55 = t31**2
              t56 = 1/t11**4
              t57 = 1/t11**3
              t58 = 2.1622951122684114d+0*t52+1.7087761055320938d+0*t51+
     1           1.2335503316757068d+0*t50+2.673190323653546d-1*t1
              t59 = 1.0d+0*t14*t30*t32*t58-2.0d+0*t14*t30*t55*t57+3.2163
     1           95899738507d+1*t14*t54*t55*t56+1.1102230246251565d-16*t
     2           18*t23*t29*t53-4.0675215258019015d-19*t17*t51-1.7613865
     3           241785684d-3*t13*t51-2.220446049250313d-16*t18*t23*t47*
     4           t49+1.7854583920998188d-15*t18*t46*t47*t48-8.4979745913
     5           33913d-2*t26*t30*t31*t32-9.812069668265515d-18*t23*t26*
     6           t28*t29
              t60 = gammaaa**3
              t61 = 1/t2**3
              t62 = 1/rhoa**10
              t63 = 1/rhoa**7.333333333333333d+0
              t64 = 1/rhoa**4.666666666666667d+0
              t65 = 1.3043825226666664d+0*gammaaa*t3*t64-1.9209997151999
     1           994d-1*t34*t35*t63+6.830221209599997d-3*t60*t61*t62
              t66 = 6.0d-2*gammaaa*t1*t3*t65+5.866666666666666d-1*gammaa
     1           a*t3*t4*t64-8.639999999999998d-2*t34*t35*t4*t63+3.07199
     2           99999999986d-3*t4*t60*t61*t62-3.1999999999999995d-1*gam
     3           maaa*t3*t37*t38+1.9199999999999995d-2*t34*t35*t36*t38
              t67 = 1.25d-1*t19*t5*wght
              t68 = 1/rhoa**9
              t69 = -2.561332953599999d-3*t34*t61*t68-3.557406879999999d
     1           -1*t3*t37+6.403332383999999d-2*gammaaa*t35*t36
              t70 = 6.0d-2*gammaaa*t1*t3*t69-1.1519999999999996d-3*t34*t
     1           4*t61*t68-1.5999999999999998d-1*gammaaa*t3*t37*t42+9.59
     2           9999999999997d-3*t34*t35*t36*t42-3.6d-3*gammaaa*t35*t38
     3           *t41-1.5999999999999998d-1*t3*t37*t4+2.879999999999999d
     4           -2*gammaaa*t35*t36*t4+6.0d-2*t1*t3*t38
              t71 = 1/rhoa**8
              t72 = 9.604998575999998d-4*gammaaa*t61*t71-1.6008330959999
     1           997d-2*t35*t41
              t73 = 6.0d-2*gammaaa*t1*t3*t72+4.32d-4*gammaaa*t4*t61*t71-
     1           7.2d-3*gammaaa*t35*t41*t42+1.2d-1*t1*t3*t42-7.2d-3*t35*
     2           t4*t41
              t74 = -5.0d-1*rhoa*t22*t33*t5*wght-5.0d-1*t19*t22*t5*wght-
     1           5.0d-1*rhoa*t19*t22*t39*wght
              t75 = t67-5.0d-1*rhoa*t19*t22*t43*wght
              t76 = 1/taua**3
              t77 = 1/rhoa**3
              t78 = t28**3
              t79 = 1/t7**7
              t80 = 1/rhoa**3.3333333333333337d+0
              t81 = 1/rhoa**3.1666666666666665d+0
              t82 = t31**3
              t83 = gammaaa**4
              t84 = 1/t2**4
              t85 = 1/rhoa**1.3666666666666666d+1
              t86 = 1/rhoa**11
              t87 = 1/rhoa**8.333333333333334d+0
              t88 = 1/rhoa**5.666666666666667d+0
              t89 = 1.25d-1*t33*t5*wght
              t90 = 1.25d-1*t19*t39*wght
              t91 = t40-1.25d-1*gammaaa*t19*t43*wght
              t92 = 1/rhoa**1.2666666666666665d+1
              t93 = 2.5d-1*t19*t43*wght
              t94 = 1/rhoa**1.1666666666666665d+1
              t95 = 1/rhoa**1.0666666666666666d+1
              fnc(iq) = 5.0d-1*rhoa*t19*t20*t22*t5*wght+fnc(iq)
              Amat(iq,D1_RA) = t20*(5.0d-1*rhoa*t22*t33*t5*wght+5.0d-1*t
     1           19*t22*t5*wght+5.0d-1*rhoa*t19*t22*t39*wght)+1.25d-1*ga
     2           mmaaa*t19*t20*t21*t5*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = t20*(5.0d-1*rhoa*t19*t22*t43*wght+t40)+C
     1           mat(iq,D1_GAA)
              Mmat(iq,D1_TA) = -5.0d-1*rhoa*t19*t22*t44*t5*wght+1.0d+0*r
     1           hoa*t19*t20*t5*wght+Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = t20*(5.0d-1*rhoa*t19*t22*t66*wght+5.0
     1           d-1*rhoa*t22*t5*t59*wght+1.25d-1*gammaaa*t19*t45*t5*wgh
     2           t+1.0d+0*t22*t33*t5*wght+1.25d-1*gammaaa*t21*t33*t5*wgh
     3           t+1.0d+0*rhoa*t22*t33*t39*wght+1.0d+0*t19*t22*t39*wght+
     4           1.25d-1*gammaaa*t19*t21*t39*wght)+t20*t21*(1.25d-1*gamm
     5           aaa*t33*t5*wght+1.25d-1*gammaaa*t19*t39*wght)-1.25d-1*g
     6           ammaaa*t19*t20*t45*t5*wght+Amat2(iq,D2_RA_RA)
              Cmat2(iq,D2_RA_GAA) = t20*(5.0d-1*rhoa*t19*t22*t70*wght-1.
     1           25d-1*t33*t5*wght-1.25d-1*t19*t21*t5*wght+5.0d-1*rhoa*t
     2           22*t33*t43*wght+5.0d-1*t19*t22*t43*wght-1.25d-1*t19*t39
     3           *wght)+t20*t21*(1.25d-1*gammaaa*t19*t43*wght+t67)+Cmat2
     4           (iq,D2_RA_GAA)
              Cmat2(iq,D2_GAA_GAA) = t20*(5.0d-1*rhoa*t19*t22*t73*wght-2
     1           .5d-1*t19*t43*wght)+Cmat2(iq,D2_GAA_GAA)
              Mmat2(iq,D2_RA_TA) = t20*(1.0d+0*rhoa*t33*t5*wght+1.0d+0*t
     1           19*t5*wght+1.0d+0*rhoa*t19*t39*wght)-1.25d-1*gammaaa*t1
     2           9*t21*t44*t5*wght+t44*t74+Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = 1.0d+0*rhoa*t19*t20*t43*wght+t44*t75
     1           +Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_TA_TA) = 1.0d+0*rhoa*t19*t22*t5*t76*wght-2.0d+
     1           0*rhoa*t19*t44*t5*wght+Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
              Amat3(iq,D3_RA_RA_RA) = t20*(5.0d-1*rhoa*t19*t22*(6.0d-2*g
     1           ammaaa*t1*t3*(-6.08711843911111d+0*gammaaa*t3*t88+1.617
     2           434328106666d+0*t34*t35*t87-1.2977420298239994d-1*t60*t
     3           61*t86+3.2785061806079985d-3*t83*t84*t85)-2.73777777777
     4           7778d+0*gammaaa*t3*t4*t88+7.274666666666665d-1*t34*t35*
     5           t4*t87-5.836799999999998d-2*t4*t60*t61*t86+1.4745599999
     6           999992d-3*t4*t83*t84*t85-4.799999999999999d-1*gammaaa*t
     7           3*t37*t65+2.879999999999999d-2*t34*t35*t36*t65+1.76d+0*
     8           gammaaa*t3*t38*t64-2.5919999999999993d-1*t34*t35*t38*t6
     9           3+9.215999999999996d-3*t38*t60*t61*t62)*wght+5.0d-1*rho
     :           a*t22*t5*(6.0d+0*t14*t30*t56*t82-1.9298375398431045d+2*
     ;           t14*t54*t82/t11**5+2.0690405167709364d+3*t14*t82/(t11**
     <           6*t12**3)+1.1102230246251565d-16*t18*t23*t29*(-2.520426
     =           340996149d+0*t81-2.3079979182303428d+0*t80-1.5008036906
     >           238065d+0*t79-5.620753557770543d-1*t37)+1.0d+0*t14*t30*
     ?           t32*(-4.684972743248224d+0*t81-3.9871442462415524d+0*t8
     @           0-3.083875829189267d+0*t79-7.128507529742789d-1*t37)+9.
     1           490883560204437d-19*t17*t80+4.1099018897499934d-3*t13*t
     2           80+6.661338147750939d-16*t18*t23*t48*t78-1.071275035259
     3           8913d-14*t18*t46*t78/t15**5+5.742741051503565d-14*t18*t
     4           78/(t15**6*t16**3)-6.0d+0*t14*t30*t31*t57*t58+9.6491876
     5           99215522d+1*t14*t31*t54*t56*t58-1.274696188700087d-1*t2
     6           6*t30*t32*t58+2.549392377400174d-1*t26*t30*t55*t57-4.09
     7           99275947472624d+0*t26*t54*t55*t56-6.661338147750939d-16
     8           *t18*t23*t28*t49*t53+5.356375176299456d-15*t18*t28*t46*
     9           t48*t53-1.4718104502398274d-17*t23*t26*t29*t53+1.699594
     :           9182667827d-1*t30*t31*t32*t51+1.962413933653103d-17*t23
     ;           *t28*t29*t51+2.943620900479655d-17*t23*t26*t47*t49-2.36
     <           69625486718335d-16*t26*t46*t47*t48)*wght-2.5d-1*gammaaa
     =           *t19*t5*t77*wght+1.5d+0*rhoa*t22*t33*t66*wght+1.5d+0*t1
     >           9*t22*t66*wght+2.5d-1*gammaaa*t19*t21*t66*wght+1.5d+0*t
     ?           22*t5*t59*wght+2.5d-1*gammaaa*t21*t5*t59*wght+1.5d+0*rh
     @           oa*t22*t39*t59*wght+2.5d-1*gammaaa*t33*t45*t5*wght+2.5d
     1           -1*gammaaa*t19*t39*t45*wght+3.0d+0*t22*t33*t39*wght+5.0
     2           d-1*gammaaa*t21*t33*t39*wght)+t20*t21*(1.25d-1*gammaaa*
     3           t19*t66*wght+1.25d-1*gammaaa*t5*t59*wght+2.5d-1*gammaaa
     4           *t33*t39*wght)+t20*t45*(-2.5d-1*gammaaa*t33*t5*wght-2.5
     5           d-1*gammaaa*t19*t39*wght)+2.5d-1*gammaaa*t19*t20*t5*t77
     6           *wght+Amat3(iq,D3_RA_RA_RA)
              Cmat3(iq,D3_RA_RA_GAA) = t20*(5.0d-1*rhoa*t19*t22*(6.0d-2*
     1           gammaaa*t1*t3*(-1.2294398177279994d-3*t60*t84*t92+1.304
     2           3825226666664d+0*t3*t64-4.624628943999999d-1*gammaaa*t3
     3           5*t63+4.3542660211199985d-2*t34*t61*t62)-5.529599999999
     4           998d-4*t4*t60*t84*t92-3.1999999999999995d-1*gammaaa*t3*
     5           t37*t69+1.9199999999999995d-2*t34*t35*t36*t69-2.3039999
     6           99999999d-3*t34*t38*t61*t68-3.6d-3*gammaaa*t35*t41*t65+
     7           6.0d-2*t1*t3*t65+5.866666666666666d-1*gammaaa*t3*t42*t6
     8           4+5.866666666666666d-1*t3*t4*t64-8.639999999999998d-2*t
     9           34*t35*t42*t63-2.0799999999999996d-1*gammaaa*t35*t4*t63
     :           +3.0719999999999986d-3*t42*t60*t61*t62+1.95839999999999
     ;           93d-2*t34*t4*t61*t62-3.1999999999999995d-1*t3*t37*t38+5
     <           .759999999999998d-2*gammaaa*t35*t36*t38)*wght+1.0d+0*rh
     =           oa*t22*t33*t70*wght+1.0d+0*t19*t22*t70*wght+1.25d-1*gam
     >           maaa*t19*t21*t70*wght-1.25d-1*t19*t66*wght-1.25d-1*t5*t
     ?           59*wght+5.0d-1*rhoa*t22*t43*t59*wght+1.25d-1*t19*t45*t5
     @           *wght-1.25d-1*t21*t33*t5*wght+1.25d-1*gammaaa*t19*t43*t
     1           45*wght+1.0d+0*t22*t33*t43*wght+1.25d-1*gammaaa*t21*t33
     2           *t43*wght-2.5d-1*t33*t39*wght-1.25d-1*t19*t21*t39*wght)
     3           +t20*t21*(1.25d-1*gammaaa*t19*t70*wght+1.25d-1*gammaaa*
     4           t33*t43*wght+t90+t89)+t20*t45*t91+Cmat3(iq,D3_RA_RA_GAA
     5           )
              Cmat3(iq,D3_RA_GAA_GAA) = t20*(5.0d-1*rhoa*t19*t22*(6.0d-2
     1           *gammaaa*t1*t3*(4.6103993164799983d-4*t34*t84*t94-1.280
     2           6664767999995d-2*gammaaa*t61*t68+8.537776511999997d-2*t
     3           35*t36)+2.073599999999999d-4*t34*t4*t84*t94-1.599999999
     4           9999998d-1*gammaaa*t3*t37*t72+9.599999999999997d-3*t34*
     5           t35*t36*t72+4.32d-4*gammaaa*t38*t61*t71-7.2d-3*gammaaa*
     6           t35*t41*t69+1.2d-1*t1*t3*t69-2.303999999999999d-3*t34*t
     7           42*t61*t68-5.759999999999997d-3*gammaaa*t4*t61*t68-3.19
     8           99999999999995d-1*t3*t37*t42+5.759999999999998d-2*gamma
     9           aa*t35*t36*t42-7.2d-3*t35*t38*t41+3.839999999999999d-2*
     :           t35*t36*t4)*wght+5.0d-1*rhoa*t22*t33*t73*wght+5.0d-1*t1
     ;           9*t22*t73*wght-2.5d-1*t19*t70*wght-2.5d-1*t33*t43*wght-
     <           2.5d-1*t19*t21*t43*wght)+t20*t21*(1.25d-1*gammaaa*t19*t
     =           73*wght+t93)+Cmat3(iq,D3_RA_GAA_GAA)
              Cmat3(iq,D3_GAA_GAA_GAA) = t20*(5.0d-1*rhoa*t19*t22*(6.0d-
     1           2*gammaaa*t1*t3*(2.881499572799999d-3*t61*t71-1.7288997
     2           436799997d-4*gammaaa*t84*t95)-7.776d-5*gammaaa*t4*t84*t
     3           95-1.0800000000000001d-2*gammaaa*t35*t41*t72+1.8d-1*t1*
     4           t3*t72+1.296d-3*gammaaa*t42*t61*t71+1.296d-3*t4*t61*t71
     5           -2.1600000000000003d-2*t35*t41*t42)*wght-3.75d-1*t19*t7
     6           3*wght)+Cmat3(iq,D3_GAA_GAA_GAA)
              Mmat3(iq,D3_RA_RA_TA) = t44*(-5.0d-1*rhoa*t19*t22*t66*wght
     1           -5.0d-1*rhoa*t22*t5*t59*wght-1.25d-1*gammaaa*t19*t45*t5
     2           *wght-1.0d+0*t22*t33*t5*wght-1.25d-1*gammaaa*t21*t33*t5
     3           *wght-1.0d+0*rhoa*t22*t33*t39*wght-1.0d+0*t19*t22*t39*w
     4           ght-1.25d-1*gammaaa*t19*t21*t39*wght)+t20*(1.0d+0*rhoa*
     5           t19*t66*wght+1.0d+0*rhoa*t5*t59*wght+2.0d+0*t33*t5*wght
     6           +2.0d+0*rhoa*t33*t39*wght+2.0d+0*t19*t39*wght)+t21*t44*
     7           (-1.25d-1*gammaaa*t33*t5*wght-1.25d-1*gammaaa*t19*t39*w
     8           ght)+1.25d-1*gammaaa*t19*t44*t45*t5*wght+Mmat3(iq,D3_RA
     9           _RA_TA)
              Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
              Mmat3(iq,D3_RA_GAA_TA) = t44*(-5.0d-1*rhoa*t19*t22*t70*wgh
     1           t+1.25d-1*t19*t21*t5*wght-5.0d-1*rhoa*t22*t33*t43*wght-
     2           5.0d-1*t19*t22*t43*wght+t90+t89)+t20*(1.0d+0*rhoa*t19*t
     3           70*wght+1.0d+0*rhoa*t33*t43*wght+1.0d+0*t19*t43*wght)+t
     4           21*t44*t91+Mmat3(iq,D3_RA_GAA_TA)
              Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
              Mmat3(iq,D3_GAA_GAA_TA) = t44*(t93-5.0d-1*rhoa*t19*t22*t73
     1           *wght)+1.0d+0*rhoa*t19*t20*t73*wght+Mmat3(iq,D3_GAA_GAA
     2           _TA)
              Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
              Mmat3(iq,D3_RA_TA_TA) = t44*(-2.0d+0*rhoa*t33*t5*wght-2.0d
     1           +0*t19*t5*wght-2.0d+0*rhoa*t19*t39*wght)+2.5d-1*gammaaa
     2           *t19*t21*t5*t76*wght-2*t74*t76+Mmat3(iq,D3_RA_TA_TA)
              Mmat3(iq,D3_RA_TA_TB) = Mmat3(iq,D3_RA_TA_TB)
              Mmat3(iq,D3_RA_TB_TB) = Mmat3(iq,D3_RA_TB_TB)
              Mmat3(iq,D3_GAA_TA_TA) = -2.0d+0*rhoa*t19*t43*t44*wght-2*t
     1           75*t76+Mmat3(iq,D3_GAA_TA_TA)
              Mmat3(iq,D3_GAA_TA_TB) = Mmat3(iq,D3_GAA_TA_TB)
              Mmat3(iq,D3_GAA_TB_TB) = Mmat3(iq,D3_GAA_TB_TB)
              Mmat3(iq,D3_TA_TA_TA) = -3.0d+0*rhoa*t19*t22*t5*wght/taua*
     1           *4+6.0d+0*rhoa*t19*t5*t76*wght+Mmat3(iq,D3_TA_TA_TA)
              Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
              Mmat3(iq,D3_TA_TB_TB) = Mmat3(iq,D3_TA_TB_TB)
              Mmat3(iq,D3_TB_TB_TB) = Mmat3(iq,D3_TB_TB_TB)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 2.4d-51*t1+1.0d+0
              t3 = 1/t2
              t4 = 5.336110319999999d-51*t1*t3-2.5960897d+0
              t5 = 2.4d-51*t1*t3*t4+1.0d+0
              t6 = 1/rhoa**6.666666666666666d-1
              t7 = rhoa**5.0d-1
              t8 = 1/t7
              t9 = 1/rhoa**3.333333333333333d-1
              t10 = 1/rhoa**1.6666666666666666d-1
              t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.4
     1           058712912881916d-1*t6+1.1120374863094686d+1*t10
              t12 = 3.216395899738507d+1/t11+1.0d+0
              t13 = log(t12)
              t14 = 1.274696188700087d-1*t9+1.0d+0
              t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.8
     1           970043257475583d-1*t6+5.982550435771079d+0*t10
              t16 = 1.6081979498692536d+1/t15+1.0d+0
              t17 = log(t16)
              t18 = 1.3256889990520176d-1*t9+1.0d+0
              t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2
     1           *t13*t14
              t20 = 1/t16
              t21 = 1/t7**3
              t22 = 1/rhoa**1.3333333333333333d+0
              t23 = 1/rhoa**1.1666666666666667d+0
              t24 = -9.970917392951799d-1*t23-7.418564737168958d-1*t22-4
     1           .002143174996817d-1*t21-1.264669550498372d-1*t1
              t25 = 1/t15**2
              t26 = 1/t12
              t27 = -1.8533958105157808d+0*t23-1.2815820791490704d+0*t22
     1           -8.223668877838045d-1*t21-1.6039141941921276d-1*t1
              t28 = 1/t11**2
              t29 = 1.0d+0*t14*t26*t27*t28+1.1102230246251565d-16*t18*t2
     1           0*t24*t25+3.0506411443514264d-19*t17*t22+1.321039893133
     2           9265d-3*t13*t22
              t30 = 1/t2**2
              t31 = 1/rhoa**4.333333333333333d+0
              t32 = 1/rhoa**2.6666666666666666d+0
              t33 = 2.134444128d-101*t30*t31-8.8935172d-51*t3*t32
              t34 = -4.0d-51*t3*t32*t4+9.6d-102*t30*t31*t4+2.4d-51*t1*t3
     1           *t33
              t35 = 1/t16**2
              t36 = t24**2
              t37 = 1/t15**4
              t38 = 1/t15**3
              t39 = 1/t7**5
              t40 = 1/rhoa**2.3333333333333334d+0
              t41 = 1/rhoa**2.1666666666666665d+0
              t42 = 1.1632736958443765d+0*t41+9.89141964955861d-1*t40+6.
     1           003214762495226d-1*t39+2.1077825841639536d-1*t32
              t43 = 1/t12**2
              t44 = t27**2
              t45 = 1/t11**4
              t46 = 1/t11**3
              t47 = 2.1622951122684114d+0*t41+1.7087761055320938d+0*t40+
     1           1.2335503316757068d+0*t39+2.673190323653546d-1*t32
              t48 = 1.0d+0*t14*t26*t28*t47-2.0d+0*t14*t26*t44*t46+3.2163
     1           95899738507d+1*t14*t43*t44*t45+1.1102230246251565d-16*t
     2           18*t20*t25*t42-4.0675215258019015d-19*t17*t40-1.7613865
     3           241785684d-3*t13*t40-2.220446049250313d-16*t18*t20*t36*
     4           t38+1.7854583920998188d-15*t18*t35*t36*t37-8.4979745913
     5           33913d-2*t22*t26*t27*t28-9.812069668265515d-18*t20*t22*
     6           t24*t25
              t49 = 1/t2**3
              t50 = 1/rhoa**7
              t51 = 1/rhoa**5.333333333333333d+0
              t52 = 1/rhoa**3.6666666666666664d+0
              t53 = 2.3716045866666666d-50*t3*t52-1.2806664767999998d-10
     1           0*t30*t51+1.7075553024d-151*t49*t50
              t54 = 2.4d-51*t1*t3*t53+1.0666666666666666d-50*t3*t4*t52-5
     1           .76d-101*t30*t4*t51+7.68d-152*t4*t49*t50-8.0d-51*t3*t32
     2           *t33+1.92d-101*t30*t31*t33
              t55 = t24**3
              t56 = 1/t7**7
              t57 = 1/rhoa**3.3333333333333337d+0
              t58 = 1/rhoa**3.1666666666666665d+0
              t59 = t27**3
              t60 = 1/t2**4
              t61 = 1/rhoa**9.666666666666666d+0
              t62 = 1/rhoa**8
              t63 = 1/rhoa**6.333333333333333d+0
              t64 = 1/rhoa**4.666666666666667d+0
              fnc(iq) = 5.0d-1*rhoa*t19*t5*wght+fnc(iq)
              Amat(iq,D1_RA) = 5.0d-1*rhoa*t29*t5*wght+5.0d-1*t19*t5*wgh
     1           t+5.0d-1*rhoa*t19*t34*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = 5.0d-1*rhoa*t19*t54*wght+5.0d-1*rhoa*
     1           t48*t5*wght+1.0d+0*t29*t5*wght+1.0d+0*rhoa*t29*t34*wght
     2           +1.0d+0*t19*t34*wght+Amat2(iq,D2_RA_RA)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
              Amat3(iq,D3_RA_RA_RA) = 5.0d-1*rhoa*t19*(2.4d-51*t1*t3*(-8
     1           .695883484444443d-50*t3*t64+7.778863044266666d-100*t30*
     2           t63-2.2198218931199998d-150*t49*t62+2.04906636288d-201*
     3           t60*t61)-3.911111111111111d-50*t3*t4*t64+3.498666666666
     4           6666d-100*t30*t4*t63-9.984000000000001d-151*t4*t49*t62+
     5           9.216000000000001d-202*t4*t60*t61-1.2d-50*t3*t32*t53+2.
     6           88d-101*t30*t31*t53+3.2d-50*t3*t33*t52-1.72799999999999
     7           98d-100*t30*t33*t51+2.3040000000000002d-151*t33*t49*t50
     8           )*wght+5.0d-1*rhoa*t5*(6.0d+0*t14*t26*t45*t59-1.9298375
     9           398431045d+2*t14*t43*t59/t11**5+2.0690405167709364d+3*t
     :           14*t59/(t11**6*t12**3)+1.1102230246251565d-16*t18*t20*t
     ;           25*(-2.520426340996149d+0*t58-2.3079979182303428d+0*t57
     <           -1.5008036906238065d+0*t56-5.620753557770543d-1*t52)+1.
     =           0d+0*t14*t26*t28*(-4.684972743248224d+0*t58-3.987144246
     >           2415524d+0*t57-3.083875829189267d+0*t56-7.1285075297427
     ?           89d-1*t52)+9.490883560204437d-19*t17*t57+4.109901889749
     @           9934d-3*t13*t57+6.661338147750939d-16*t18*t20*t37*t55-1
     1           .0712750352598913d-14*t18*t35*t55/t15**5+5.742741051503
     2           565d-14*t18*t55/(t15**6*t16**3)-6.0d+0*t14*t26*t27*t46*
     3           t47+9.649187699215522d+1*t14*t27*t43*t45*t47-1.27469618
     4           8700087d-1*t22*t26*t28*t47+2.549392377400174d-1*t22*t26
     5           *t44*t46-4.0999275947472624d+0*t22*t43*t44*t45-6.661338
     6           147750939d-16*t18*t20*t24*t38*t42+5.356375176299456d-15
     7           *t18*t24*t35*t37*t42-1.4718104502398274d-17*t20*t22*t25
     8           *t42+1.6995949182667827d-1*t26*t27*t28*t40+1.9624139336
     9           53103d-17*t20*t24*t25*t40+2.943620900479655d-17*t20*t22
     :           *t36*t38-2.3669625486718335d-16*t22*t35*t36*t37)*wght+1
     ;           .5d+0*rhoa*t29*t54*wght+1.5d+0*t19*t54*wght+1.5d+0*t48*
     <           t5*wght+1.5d+0*rhoa*t34*t48*wght+3.0d+0*t29*t34*wght+Am
     =           at3(iq,D3_RA_RA_RA)
              Cmat3(iq,D3_RA_RA_GAA) = Cmat3(iq,D3_RA_RA_GAA)
              Cmat3(iq,D3_RA_GAA_GAA) = Cmat3(iq,D3_RA_GAA_GAA)
              Cmat3(iq,D3_GAA_GAA_GAA) = Cmat3(iq,D3_GAA_GAA_GAA)
              Mmat3(iq,D3_RA_RA_TA) = Mmat3(iq,D3_RA_RA_TA)
              Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
              Mmat3(iq,D3_RA_GAA_TA) = Mmat3(iq,D3_RA_GAA_TA)
              Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
              Mmat3(iq,D3_GAA_GAA_TA) = Mmat3(iq,D3_GAA_GAA_TA)
              Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
              Mmat3(iq,D3_RA_TA_TA) = Mmat3(iq,D3_RA_TA_TA)
              Mmat3(iq,D3_RA_TA_TB) = Mmat3(iq,D3_RA_TA_TB)
              Mmat3(iq,D3_RA_TB_TB) = Mmat3(iq,D3_RA_TB_TB)
              Mmat3(iq,D3_GAA_TA_TA) = Mmat3(iq,D3_GAA_TA_TA)
              Mmat3(iq,D3_GAA_TA_TB) = Mmat3(iq,D3_GAA_TA_TB)
              Mmat3(iq,D3_GAA_TB_TB) = Mmat3(iq,D3_GAA_TB_TB)
              Mmat3(iq,D3_TA_TA_TA) = Mmat3(iq,D3_TA_TA_TA)
              Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
              Mmat3(iq,D3_TA_TB_TB) = Mmat3(iq,D3_TA_TB_TB)
              Mmat3(iq,D3_TB_TB_TB) = Mmat3(iq,D3_TB_TB_TB)
            else 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 2.4d-51*t1+1.0d+0
              t3 = 1/t2
              t4 = 5.336110319999999d-51*t1*t3-2.5960897d+0
              t5 = 2.4d-51*t1*t3*t4+1.0d+0
              t6 = 1/rhoa**6.666666666666666d-1
              t7 = rhoa**5.0d-1
              t8 = 1/t7
              t9 = 1/rhoa**3.333333333333333d-1
              t10 = 1/rhoa**1.6666666666666666d-1
              t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.4
     1           058712912881916d-1*t6+1.1120374863094686d+1*t10
              t12 = 3.216395899738507d+1/t11+1.0d+0
              t13 = log(t12)
              t14 = 1.274696188700087d-1*t9+1.0d+0
              t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.8
     1           970043257475583d-1*t6+5.982550435771079d+0*t10
              t16 = 1.6081979498692536d+1/t15+1.0d+0
              t17 = log(t16)
              t18 = 1.3256889990520176d-1*t9+1.0d+0
              t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2
     1           *t13*t14
              t20 = 1/t16
              t21 = 1/t7**3
              t22 = 1/rhoa**1.3333333333333333d+0
              t23 = 1/rhoa**1.1666666666666667d+0
              t24 = -9.970917392951799d-1*t23-7.418564737168958d-1*t22-4
     1           .002143174996817d-1*t21-1.264669550498372d-1*t1
              t25 = 1/t15**2
              t26 = 1/t12
              t27 = -1.8533958105157808d+0*t23-1.2815820791490704d+0*t22
     1           -8.223668877838045d-1*t21-1.6039141941921276d-1*t1
              t28 = 1/t11**2
              t29 = 1.0d+0*t14*t26*t27*t28+1.1102230246251565d-16*t18*t2
     1           0*t24*t25+3.0506411443514264d-19*t17*t22+1.321039893133
     2           9265d-3*t13*t22
              t30 = 1/t2**2
              t31 = 1/rhoa**4.333333333333333d+0
              t32 = 1/rhoa**2.6666666666666666d+0
              t33 = 2.134444128d-101*t30*t31-8.8935172d-51*t3*t32
              t34 = -4.0d-51*t3*t32*t4+9.6d-102*t30*t31*t4+2.4d-51*t1*t3
     1           *t33
              t35 = 1/t16**2
              t36 = t24**2
              t37 = 1/t15**4
              t38 = 1/t15**3
              t39 = 1/t7**5
              t40 = 1/rhoa**2.3333333333333334d+0
              t41 = 1/rhoa**2.1666666666666665d+0
              t42 = 1.1632736958443765d+0*t41+9.89141964955861d-1*t40+6.
     1           003214762495226d-1*t39+2.1077825841639536d-1*t32
              t43 = 1/t12**2
              t44 = t27**2
              t45 = 1/t11**4
              t46 = 1/t11**3
              t47 = 2.1622951122684114d+0*t41+1.7087761055320938d+0*t40+
     1           1.2335503316757068d+0*t39+2.673190323653546d-1*t32
              t48 = 1.0d+0*t14*t26*t28*t47-2.0d+0*t14*t26*t44*t46+3.2163
     1           95899738507d+1*t14*t43*t44*t45+1.1102230246251565d-16*t
     2           18*t20*t25*t42-4.0675215258019015d-19*t17*t40-1.7613865
     3           241785684d-3*t13*t40-2.220446049250313d-16*t18*t20*t36*
     4           t38+1.7854583920998188d-15*t18*t35*t36*t37-8.4979745913
     5           33913d-2*t22*t26*t27*t28-9.812069668265515d-18*t20*t22*
     6           t24*t25
              t49 = 1/t2**3
              t50 = 1/rhoa**7
              t51 = 1/rhoa**5.333333333333333d+0
              t52 = 1/rhoa**3.6666666666666664d+0
              t53 = 2.3716045866666666d-50*t3*t52-1.2806664767999998d-10
     1           0*t30*t51+1.7075553024d-151*t49*t50
              t54 = 2.4d-51*t1*t3*t53+1.0666666666666666d-50*t3*t4*t52-5
     1           .76d-101*t30*t4*t51+7.68d-152*t4*t49*t50-8.0d-51*t3*t32
     2           *t33+1.92d-101*t30*t31*t33
              t55 = t24**3
              t56 = 1/t7**7
              t57 = 1/rhoa**3.3333333333333337d+0
              t58 = 1/rhoa**3.1666666666666665d+0
              t59 = t27**3
              t60 = 1/t2**4
              t61 = 1/rhoa**9.666666666666666d+0
              t62 = 1/rhoa**8
              t63 = 1/rhoa**6.333333333333333d+0
              t64 = 1/rhoa**4.666666666666667d+0
              fnc(iq) = 5.0d-1*rhoa*t19*t5*wght+fnc(iq)
              Amat(iq,D1_RA) = 5.0d-1*rhoa*t29*t5*wght+5.0d-1*t19*t5*wgh
     1           t+5.0d-1*rhoa*t19*t34*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = 5.0d-1*rhoa*t19*t54*wght+5.0d-1*rhoa*
     1           t48*t5*wght+1.0d+0*t29*t5*wght+1.0d+0*rhoa*t29*t34*wght
     2           +1.0d+0*t19*t34*wght+Amat2(iq,D2_RA_RA)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
              Amat3(iq,D3_RA_RA_RA) = 5.0d-1*rhoa*t19*(2.4d-51*t1*t3*(-8
     1           .695883484444443d-50*t3*t64+7.778863044266666d-100*t30*
     2           t63-2.2198218931199998d-150*t49*t62+2.04906636288d-201*
     3           t60*t61)-3.911111111111111d-50*t3*t4*t64+3.498666666666
     4           6666d-100*t30*t4*t63-9.984000000000001d-151*t4*t49*t62+
     5           9.216000000000001d-202*t4*t60*t61-1.2d-50*t3*t32*t53+2.
     6           88d-101*t30*t31*t53+3.2d-50*t3*t33*t52-1.72799999999999
     7           98d-100*t30*t33*t51+2.3040000000000002d-151*t33*t49*t50
     8           )*wght+5.0d-1*rhoa*t5*(6.0d+0*t14*t26*t45*t59-1.9298375
     9           398431045d+2*t14*t43*t59/t11**5+2.0690405167709364d+3*t
     :           14*t59/(t11**6*t12**3)+1.1102230246251565d-16*t18*t20*t
     ;           25*(-2.520426340996149d+0*t58-2.3079979182303428d+0*t57
     <           -1.5008036906238065d+0*t56-5.620753557770543d-1*t52)+1.
     =           0d+0*t14*t26*t28*(-4.684972743248224d+0*t58-3.987144246
     >           2415524d+0*t57-3.083875829189267d+0*t56-7.1285075297427
     ?           89d-1*t52)+9.490883560204437d-19*t17*t57+4.109901889749
     @           9934d-3*t13*t57+6.661338147750939d-16*t18*t20*t37*t55-1
     1           .0712750352598913d-14*t18*t35*t55/t15**5+5.742741051503
     2           565d-14*t18*t55/(t15**6*t16**3)-6.0d+0*t14*t26*t27*t46*
     3           t47+9.649187699215522d+1*t14*t27*t43*t45*t47-1.27469618
     4           8700087d-1*t22*t26*t28*t47+2.549392377400174d-1*t22*t26
     5           *t44*t46-4.0999275947472624d+0*t22*t43*t44*t45-6.661338
     6           147750939d-16*t18*t20*t24*t38*t42+5.356375176299456d-15
     7           *t18*t24*t35*t37*t42-1.4718104502398274d-17*t20*t22*t25
     8           *t42+1.6995949182667827d-1*t26*t27*t28*t40+1.9624139336
     9           53103d-17*t20*t24*t25*t40+2.943620900479655d-17*t20*t22
     :           *t36*t38-2.3669625486718335d-16*t22*t35*t36*t37)*wght+1
     ;           .5d+0*rhoa*t29*t54*wght+1.5d+0*t19*t54*wght+1.5d+0*t48*
     <           t5*wght+1.5d+0*rhoa*t34*t48*wght+3.0d+0*t29*t34*wght+Am
     =           at3(iq,D3_RA_RA_RA)
              Cmat3(iq,D3_RA_RA_GAA) = Cmat3(iq,D3_RA_RA_GAA)
              Cmat3(iq,D3_RA_GAA_GAA) = Cmat3(iq,D3_RA_GAA_GAA)
              Cmat3(iq,D3_GAA_GAA_GAA) = Cmat3(iq,D3_GAA_GAA_GAA)
              Mmat3(iq,D3_RA_RA_TA) = Mmat3(iq,D3_RA_RA_TA)
              Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
              Mmat3(iq,D3_RA_GAA_TA) = Mmat3(iq,D3_RA_GAA_TA)
              Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
              Mmat3(iq,D3_GAA_GAA_TA) = Mmat3(iq,D3_GAA_GAA_TA)
              Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
              Mmat3(iq,D3_RA_TA_TA) = Mmat3(iq,D3_RA_TA_TA)
              Mmat3(iq,D3_RA_TA_TB) = Mmat3(iq,D3_RA_TA_TB)
              Mmat3(iq,D3_RA_TB_TB) = Mmat3(iq,D3_RA_TB_TB)
              Mmat3(iq,D3_GAA_TA_TA) = Mmat3(iq,D3_GAA_TA_TA)
              Mmat3(iq,D3_GAA_TA_TB) = Mmat3(iq,D3_GAA_TA_TB)
              Mmat3(iq,D3_GAA_TB_TB) = Mmat3(iq,D3_GAA_TB_TB)
              Mmat3(iq,D3_TA_TA_TA) = Mmat3(iq,D3_TA_TA_TA)
              Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
              Mmat3(iq,D3_TA_TB_TB) = Mmat3(iq,D3_TA_TB_TB)
              Mmat3(iq,D3_TB_TB_TB) = Mmat3(iq,D3_TB_TB_TB)
            endif 
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhob**2.6666666666666666d+0
              t2 = 6.0d-2*gammabb*t1+1.0d+0
              t3 = 1/t2
              t4 = 1.3340275799999998d-1*gammabb*t1*t3-2.5960897d+0
              t5 = 6.0d-2*gammabb*t1*t3*t4+1.0d+0
              t6 = 1/rhob**6.666666666666666d-1
              t7 = rhob**5.0d-1
              t8 = 1/t7
              t9 = 1/rhob**3.333333333333333d-1
              t10 = 1/rhob**1.6666666666666666d-1
              t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.4
     1           058712912881916d-1*t6+1.1120374863094686d+1*t10
              t12 = 3.216395899738507d+1/t11+1.0d+0
              t13 = log(t12)
              t14 = 1.274696188700087d-1*t9+1.0d+0
              t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.8
     1           970043257475583d-1*t6+5.982550435771079d+0*t10
              t16 = 1.6081979498692536d+1/t15+1.0d+0
              t17 = log(t16)
              t18 = 1.3256889990520176d-1*t9+1.0d+0
              t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2
     1           *t13*t14
              t20 = 1/taub
              t21 = 1/rhob
              t22 = 2.0d+0*taub-2.5d-1*gammabb*t21
              t23 = 1/t16
              t24 = 1/rhob**1.6666666666666669d+0
              t25 = 1/t7**3
              t26 = 1/rhob**1.3333333333333333d+0
              t27 = 1/rhob**1.1666666666666667d+0
              t28 = -9.970917392951799d-1*t27-7.418564737168958d-1*t26-4
     1           .002143174996817d-1*t25-1.264669550498372d-1*t24
              t29 = 1/t15**2
              t30 = 1/t12
              t31 = -1.8533958105157808d+0*t27-1.2815820791490704d+0*t26
     1           -8.223668877838045d-1*t25-1.6039141941921276d-1*t24
              t32 = 1/t11**2
              t33 = 1.0d+0*t14*t30*t31*t32+1.1102230246251565d-16*t18*t2
     1           3*t28*t29+3.0506411443514264d-19*t17*t26+1.321039893133
     2           9265d-3*t13*t26
              t34 = gammabb**2
              t35 = 1/t2**2
              t36 = 1/rhob**6.333333333333333d+0
              t37 = 1/rhob**3.6666666666666664d+0
              t38 = 2.1344441279999993d-2*t34*t35*t36-3.557406879999999d
     1           -1*gammabb*t3*t37
              t39 = -1.5999999999999998d-1*gammabb*t3*t37*t4+9.599999999
     1           999997d-3*t34*t35*t36*t4+6.0d-2*gammabb*t1*t3*t38
              t40 = -1.25d-1*t19*t5*wght
              t41 = 1/rhob**5.333333333333333d+0
              t42 = 1.3340275799999998d-1*t1*t3-8.004165479999998d-3*gam
     1           mabb*t35*t41
              t43 = 6.0d-2*gammabb*t1*t3*t42-3.6d-3*gammabb*t35*t4*t41+6
     1           .0d-2*t1*t3*t4
              t44 = 1/taub**2
              t45 = 1/rhob**2
              t46 = 1/t16**2
              t47 = t28**2
              t48 = 1/t15**4
              t49 = 1/t15**3
              t50 = 1/t7**5
              t51 = 1/rhob**2.3333333333333334d+0
              t52 = 1/rhob**2.1666666666666665d+0
              t53 = 1.1632736958443765d+0*t52+9.89141964955861d-1*t51+6.
     1           003214762495226d-1*t50+2.1077825841639536d-1*t1
              t54 = 1/t12**2
              t55 = t31**2
              t56 = 1/t11**4
              t57 = 1/t11**3
              t58 = 2.1622951122684114d+0*t52+1.7087761055320938d+0*t51+
     1           1.2335503316757068d+0*t50+2.673190323653546d-1*t1
              t59 = 1.0d+0*t14*t30*t32*t58-2.0d+0*t14*t30*t55*t57+3.2163
     1           95899738507d+1*t14*t54*t55*t56+1.1102230246251565d-16*t
     2           18*t23*t29*t53-4.0675215258019015d-19*t17*t51-1.7613865
     3           241785684d-3*t13*t51-2.220446049250313d-16*t18*t23*t47*
     4           t49+1.7854583920998188d-15*t18*t46*t47*t48-8.4979745913
     5           33913d-2*t26*t30*t31*t32-9.812069668265515d-18*t23*t26*
     6           t28*t29
              t60 = gammabb**3
              t61 = 1/t2**3
              t62 = 1/rhob**10
              t63 = 1/rhob**7.333333333333333d+0
              t64 = 1/rhob**4.666666666666667d+0
              t65 = 1.3043825226666664d+0*gammabb*t3*t64-1.9209997151999
     1           994d-1*t34*t35*t63+6.830221209599997d-3*t60*t61*t62
              t66 = 6.0d-2*gammabb*t1*t3*t65+5.866666666666666d-1*gammab
     1           b*t3*t4*t64-8.639999999999998d-2*t34*t35*t4*t63+3.07199
     2           99999999986d-3*t4*t60*t61*t62-3.1999999999999995d-1*gam
     3           mabb*t3*t37*t38+1.9199999999999995d-2*t34*t35*t36*t38
              t67 = 1.25d-1*t19*t5*wght
              t68 = 1/rhob**9
              t69 = -2.561332953599999d-3*t34*t61*t68-3.557406879999999d
     1           -1*t3*t37+6.403332383999999d-2*gammabb*t35*t36
              t70 = 6.0d-2*gammabb*t1*t3*t69-1.1519999999999996d-3*t34*t
     1           4*t61*t68-1.5999999999999998d-1*gammabb*t3*t37*t42+9.59
     2           9999999999997d-3*t34*t35*t36*t42-3.6d-3*gammabb*t35*t38
     3           *t41-1.5999999999999998d-1*t3*t37*t4+2.879999999999999d
     4           -2*gammabb*t35*t36*t4+6.0d-2*t1*t3*t38
              t71 = 1/rhob**8
              t72 = 9.604998575999998d-4*gammabb*t61*t71-1.6008330959999
     1           997d-2*t35*t41
              t73 = 6.0d-2*gammabb*t1*t3*t72+4.32d-4*gammabb*t4*t61*t71-
     1           7.2d-3*gammabb*t35*t41*t42+1.2d-1*t1*t3*t42-7.2d-3*t35*
     2           t4*t41
              t74 = -5.0d-1*rhob*t22*t33*t5*wght-5.0d-1*t19*t22*t5*wght-
     1           5.0d-1*rhob*t19*t22*t39*wght
              t75 = t67-5.0d-1*rhob*t19*t22*t43*wght
              t76 = 1/taub**3
              t77 = 1/rhob**3
              t78 = t28**3
              t79 = 1/t7**7
              t80 = 1/rhob**3.3333333333333337d+0
              t81 = 1/rhob**3.1666666666666665d+0
              t82 = t31**3
              t83 = gammabb**4
              t84 = 1/t2**4
              t85 = 1/rhob**1.3666666666666666d+1
              t86 = 1/rhob**11
              t87 = 1/rhob**8.333333333333334d+0
              t88 = 1/rhob**5.666666666666667d+0
              t89 = 1.25d-1*t33*t5*wght
              t90 = 1.25d-1*t19*t39*wght
              t91 = t40-1.25d-1*gammabb*t19*t43*wght
              t92 = 1/rhob**1.2666666666666665d+1
              t93 = 2.5d-1*t19*t43*wght
              t94 = 1/rhob**1.1666666666666665d+1
              t95 = 1/rhob**1.0666666666666666d+1
              fnc(iq) = 5.0d-1*rhob*t19*t20*t22*t5*wght+fnc(iq)
              Amat(iq,D1_RB) = t20*(5.0d-1*rhob*t22*t33*t5*wght+5.0d-1*t
     1           19*t22*t5*wght+5.0d-1*rhob*t19*t22*t39*wght)+1.25d-1*ga
     2           mmabb*t19*t20*t21*t5*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = t20*(5.0d-1*rhob*t19*t22*t43*wght+t40)+C
     1           mat(iq,D1_GBB)
              Mmat(iq,D1_TB) = -5.0d-1*rhob*t19*t22*t44*t5*wght+1.0d+0*r
     1           hob*t19*t20*t5*wght+Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RB_RB) = t20*(5.0d-1*rhob*t19*t22*t66*wght+5.0
     1           d-1*rhob*t22*t5*t59*wght+1.25d-1*gammabb*t19*t45*t5*wgh
     2           t+1.0d+0*t22*t33*t5*wght+1.25d-1*gammabb*t21*t33*t5*wgh
     3           t+1.0d+0*rhob*t22*t33*t39*wght+1.0d+0*t19*t22*t39*wght+
     4           1.25d-1*gammabb*t19*t21*t39*wght)+t20*t21*(1.25d-1*gamm
     5           abb*t33*t5*wght+1.25d-1*gammabb*t19*t39*wght)-1.25d-1*g
     6           ammabb*t19*t20*t45*t5*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RB_GBB) = t20*(5.0d-1*rhob*t19*t22*t70*wght-1.
     1           25d-1*t33*t5*wght-1.25d-1*t19*t21*t5*wght+5.0d-1*rhob*t
     2           22*t33*t43*wght+5.0d-1*t19*t22*t43*wght-1.25d-1*t19*t39
     3           *wght)+t20*t21*(1.25d-1*gammabb*t19*t43*wght+t67)+Cmat2
     4           (iq,D2_RB_GBB)
              Cmat2(iq,D2_GBB_GBB) = t20*(5.0d-1*rhob*t19*t22*t73*wght-2
     1           .5d-1*t19*t43*wght)+Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = t20*(1.0d+0*rhob*t33*t5*wght+1.0d+0*t
     1           19*t5*wght+1.0d+0*rhob*t19*t39*wght)-1.25d-1*gammabb*t1
     2           9*t21*t44*t5*wght+t44*t74+Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = 1.0d+0*rhob*t19*t20*t43*wght+t44*t75
     1           +Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = 1.0d+0*rhob*t19*t22*t5*t76*wght-2.0d+
     1           0*rhob*t19*t44*t5*wght+Mmat2(iq,D2_TB_TB)
              Amat3(iq,D3_RB_RB_RB) = t20*(5.0d-1*rhob*t19*t22*(6.0d-2*g
     1           ammabb*t1*t3*(-6.08711843911111d+0*gammabb*t3*t88+1.617
     2           434328106666d+0*t34*t35*t87-1.2977420298239994d-1*t60*t
     3           61*t86+3.2785061806079985d-3*t83*t84*t85)-2.73777777777
     4           7778d+0*gammabb*t3*t4*t88+7.274666666666665d-1*t34*t35*
     5           t4*t87-5.836799999999998d-2*t4*t60*t61*t86+1.4745599999
     6           999992d-3*t4*t83*t84*t85-4.799999999999999d-1*gammabb*t
     7           3*t37*t65+2.879999999999999d-2*t34*t35*t36*t65+1.76d+0*
     8           gammabb*t3*t38*t64-2.5919999999999993d-1*t34*t35*t38*t6
     9           3+9.215999999999996d-3*t38*t60*t61*t62)*wght+5.0d-1*rho
     :           b*t22*t5*(6.0d+0*t14*t30*t56*t82-1.9298375398431045d+2*
     ;           t14*t54*t82/t11**5+2.0690405167709364d+3*t14*t82/(t11**
     <           6*t12**3)+1.1102230246251565d-16*t18*t23*t29*(-2.520426
     =           340996149d+0*t81-2.3079979182303428d+0*t80-1.5008036906
     >           238065d+0*t79-5.620753557770543d-1*t37)+1.0d+0*t14*t30*
     ?           t32*(-4.684972743248224d+0*t81-3.9871442462415524d+0*t8
     @           0-3.083875829189267d+0*t79-7.128507529742789d-1*t37)+9.
     1           490883560204437d-19*t17*t80+4.1099018897499934d-3*t13*t
     2           80+6.661338147750939d-16*t18*t23*t48*t78-1.071275035259
     3           8913d-14*t18*t46*t78/t15**5+5.742741051503565d-14*t18*t
     4           78/(t15**6*t16**3)-6.0d+0*t14*t30*t31*t57*t58+9.6491876
     5           99215522d+1*t14*t31*t54*t56*t58-1.274696188700087d-1*t2
     6           6*t30*t32*t58+2.549392377400174d-1*t26*t30*t55*t57-4.09
     7           99275947472624d+0*t26*t54*t55*t56-6.661338147750939d-16
     8           *t18*t23*t28*t49*t53+5.356375176299456d-15*t18*t28*t46*
     9           t48*t53-1.4718104502398274d-17*t23*t26*t29*t53+1.699594
     :           9182667827d-1*t30*t31*t32*t51+1.962413933653103d-17*t23
     ;           *t28*t29*t51+2.943620900479655d-17*t23*t26*t47*t49-2.36
     <           69625486718335d-16*t26*t46*t47*t48)*wght-2.5d-1*gammabb
     =           *t19*t5*t77*wght+1.5d+0*rhob*t22*t33*t66*wght+1.5d+0*t1
     >           9*t22*t66*wght+2.5d-1*gammabb*t19*t21*t66*wght+1.5d+0*t
     ?           22*t5*t59*wght+2.5d-1*gammabb*t21*t5*t59*wght+1.5d+0*rh
     @           ob*t22*t39*t59*wght+2.5d-1*gammabb*t33*t45*t5*wght+2.5d
     1           -1*gammabb*t19*t39*t45*wght+3.0d+0*t22*t33*t39*wght+5.0
     2           d-1*gammabb*t21*t33*t39*wght)+t20*t21*(1.25d-1*gammabb*
     3           t19*t66*wght+1.25d-1*gammabb*t5*t59*wght+2.5d-1*gammabb
     4           *t33*t39*wght)+t20*t45*(-2.5d-1*gammabb*t33*t5*wght-2.5
     5           d-1*gammabb*t19*t39*wght)+2.5d-1*gammabb*t19*t20*t5*t77
     6           *wght+Amat3(iq,D3_RB_RB_RB)
              Cmat3(iq,D3_RB_RB_GBB) = t20*(5.0d-1*rhob*t19*t22*(6.0d-2*
     1           gammabb*t1*t3*(-1.2294398177279994d-3*t60*t84*t92+1.304
     2           3825226666664d+0*t3*t64-4.624628943999999d-1*gammabb*t3
     3           5*t63+4.3542660211199985d-2*t34*t61*t62)-5.529599999999
     4           998d-4*t4*t60*t84*t92-3.1999999999999995d-1*gammabb*t3*
     5           t37*t69+1.9199999999999995d-2*t34*t35*t36*t69-2.3039999
     6           99999999d-3*t34*t38*t61*t68-3.6d-3*gammabb*t35*t41*t65+
     7           6.0d-2*t1*t3*t65+5.866666666666666d-1*gammabb*t3*t42*t6
     8           4+5.866666666666666d-1*t3*t4*t64-8.639999999999998d-2*t
     9           34*t35*t42*t63-2.0799999999999996d-1*gammabb*t35*t4*t63
     :           +3.0719999999999986d-3*t42*t60*t61*t62+1.95839999999999
     ;           93d-2*t34*t4*t61*t62-3.1999999999999995d-1*t3*t37*t38+5
     <           .759999999999998d-2*gammabb*t35*t36*t38)*wght+1.0d+0*rh
     =           ob*t22*t33*t70*wght+1.0d+0*t19*t22*t70*wght+1.25d-1*gam
     >           mabb*t19*t21*t70*wght-1.25d-1*t19*t66*wght-1.25d-1*t5*t
     ?           59*wght+5.0d-1*rhob*t22*t43*t59*wght+1.25d-1*t19*t45*t5
     @           *wght-1.25d-1*t21*t33*t5*wght+1.25d-1*gammabb*t19*t43*t
     1           45*wght+1.0d+0*t22*t33*t43*wght+1.25d-1*gammabb*t21*t33
     2           *t43*wght-2.5d-1*t33*t39*wght-1.25d-1*t19*t21*t39*wght)
     3           +t20*t21*(1.25d-1*gammabb*t19*t70*wght+1.25d-1*gammabb*
     4           t33*t43*wght+t90+t89)+t20*t45*t91+Cmat3(iq,D3_RB_RB_GBB
     5           )
              Cmat3(iq,D3_RB_GBB_GBB) = t20*(5.0d-1*rhob*t19*t22*(6.0d-2
     1           *gammabb*t1*t3*(4.6103993164799983d-4*t34*t84*t94-1.280
     2           6664767999995d-2*gammabb*t61*t68+8.537776511999997d-2*t
     3           35*t36)+2.073599999999999d-4*t34*t4*t84*t94-1.599999999
     4           9999998d-1*gammabb*t3*t37*t72+9.599999999999997d-3*t34*
     5           t35*t36*t72+4.32d-4*gammabb*t38*t61*t71-7.2d-3*gammabb*
     6           t35*t41*t69+1.2d-1*t1*t3*t69-2.303999999999999d-3*t34*t
     7           42*t61*t68-5.759999999999997d-3*gammabb*t4*t61*t68-3.19
     8           99999999999995d-1*t3*t37*t42+5.759999999999998d-2*gamma
     9           bb*t35*t36*t42-7.2d-3*t35*t38*t41+3.839999999999999d-2*
     :           t35*t36*t4)*wght+5.0d-1*rhob*t22*t33*t73*wght+5.0d-1*t1
     ;           9*t22*t73*wght-2.5d-1*t19*t70*wght-2.5d-1*t33*t43*wght-
     <           2.5d-1*t19*t21*t43*wght)+t20*t21*(1.25d-1*gammabb*t19*t
     =           73*wght+t93)+Cmat3(iq,D3_RB_GBB_GBB)
              Cmat3(iq,D3_GBB_GBB_GBB) = t20*(5.0d-1*rhob*t19*t22*(6.0d-
     1           2*gammabb*t1*t3*(2.881499572799999d-3*t61*t71-1.7288997
     2           436799997d-4*gammabb*t84*t95)-7.776d-5*gammabb*t4*t84*t
     3           95-1.0800000000000001d-2*gammabb*t35*t41*t72+1.8d-1*t1*
     4           t3*t72+1.296d-3*gammabb*t42*t61*t71+1.296d-3*t4*t61*t71
     5           -2.1600000000000003d-2*t35*t41*t42)*wght-3.75d-1*t19*t7
     6           3*wght)+Cmat3(iq,D3_GBB_GBB_GBB)
              Mmat3(iq,D3_RB_RB_TA) = Mmat3(iq,D3_RB_RB_TA)
              Mmat3(iq,D3_RB_RB_TB) = t44*(-5.0d-1*rhob*t19*t22*t66*wght
     1           -5.0d-1*rhob*t22*t5*t59*wght-1.25d-1*gammabb*t19*t45*t5
     2           *wght-1.0d+0*t22*t33*t5*wght-1.25d-1*gammabb*t21*t33*t5
     3           *wght-1.0d+0*rhob*t22*t33*t39*wght-1.0d+0*t19*t22*t39*w
     4           ght-1.25d-1*gammabb*t19*t21*t39*wght)+t20*(1.0d+0*rhob*
     5           t19*t66*wght+1.0d+0*rhob*t5*t59*wght+2.0d+0*t33*t5*wght
     6           +2.0d+0*rhob*t33*t39*wght+2.0d+0*t19*t39*wght)+t21*t44*
     7           (-1.25d-1*gammabb*t33*t5*wght-1.25d-1*gammabb*t19*t39*w
     8           ght)+1.25d-1*gammabb*t19*t44*t45*t5*wght+Mmat3(iq,D3_RB
     9           _RB_TB)
              Mmat3(iq,D3_RB_GBB_TA) = Mmat3(iq,D3_RB_GBB_TA)
              Mmat3(iq,D3_RB_GBB_TB) = t44*(-5.0d-1*rhob*t19*t22*t70*wgh
     1           t+1.25d-1*t19*t21*t5*wght-5.0d-1*rhob*t22*t33*t43*wght-
     2           5.0d-1*t19*t22*t43*wght+t90+t89)+t20*(1.0d+0*rhob*t19*t
     3           70*wght+1.0d+0*rhob*t33*t43*wght+1.0d+0*t19*t43*wght)+t
     4           21*t44*t91+Mmat3(iq,D3_RB_GBB_TB)
              Mmat3(iq,D3_GBB_GBB_TA) = Mmat3(iq,D3_GBB_GBB_TA)
              Mmat3(iq,D3_GBB_GBB_TB) = t44*(t93-5.0d-1*rhob*t19*t22*t73
     1           *wght)+1.0d+0*rhob*t19*t20*t73*wght+Mmat3(iq,D3_GBB_GBB
     2           _TB)
              Mmat3(iq,D3_RB_TA_TA) = Mmat3(iq,D3_RB_TA_TA)
              Mmat3(iq,D3_RB_TA_TB) = Mmat3(iq,D3_RB_TA_TB)
              Mmat3(iq,D3_RB_TB_TB) = t44*(-2.0d+0*rhob*t33*t5*wght-2.0d
     1           +0*t19*t5*wght-2.0d+0*rhob*t19*t39*wght)+2.5d-1*gammabb
     2           *t19*t21*t5*t76*wght-2*t74*t76+Mmat3(iq,D3_RB_TB_TB)
              Mmat3(iq,D3_GBB_TA_TA) = Mmat3(iq,D3_GBB_TA_TA)
              Mmat3(iq,D3_GBB_TA_TB) = Mmat3(iq,D3_GBB_TA_TB)
              Mmat3(iq,D3_GBB_TB_TB) = -2.0d+0*rhob*t19*t43*t44*wght-2*t
     1           75*t76+Mmat3(iq,D3_GBB_TB_TB)
              Mmat3(iq,D3_TA_TA_TA) = Mmat3(iq,D3_TA_TA_TA)
              Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
              Mmat3(iq,D3_TA_TB_TB) = Mmat3(iq,D3_TA_TB_TB)
              Mmat3(iq,D3_TB_TB_TB) = -3.0d+0*rhob*t19*t22*t5*wght/taub*
     1           *4+6.0d+0*rhob*t19*t5*t76*wght+Mmat3(iq,D3_TB_TB_TB)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = 1/rhob**1.6666666666666669d+0
              t2 = 2.4d-51*t1+1.0d+0
              t3 = 1/t2
              t4 = 5.336110319999999d-51*t1*t3-2.5960897d+0
              t5 = 2.4d-51*t1*t3*t4+1.0d+0
              t6 = 1/rhob**6.666666666666666d-1
              t7 = rhob**5.0d-1
              t8 = 1/t7
              t9 = 1/rhob**3.333333333333333d-1
              t10 = 1/rhob**1.6666666666666666d-1
              t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.4
     1           058712912881916d-1*t6+1.1120374863094686d+1*t10
              t12 = 3.216395899738507d+1/t11+1.0d+0
              t13 = log(t12)
              t14 = 1.274696188700087d-1*t9+1.0d+0
              t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.8
     1           970043257475583d-1*t6+5.982550435771079d+0*t10
              t16 = 1.6081979498692536d+1/t15+1.0d+0
              t17 = log(t16)
              t18 = 1.3256889990520176d-1*t9+1.0d+0
              t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2
     1           *t13*t14
              t20 = 1/t16
              t21 = 1/t7**3
              t22 = 1/rhob**1.3333333333333333d+0
              t23 = 1/rhob**1.1666666666666667d+0
              t24 = -9.970917392951799d-1*t23-7.418564737168958d-1*t22-4
     1           .002143174996817d-1*t21-1.264669550498372d-1*t1
              t25 = 1/t15**2
              t26 = 1/t12
              t27 = -1.8533958105157808d+0*t23-1.2815820791490704d+0*t22
     1           -8.223668877838045d-1*t21-1.6039141941921276d-1*t1
              t28 = 1/t11**2
              t29 = 1.0d+0*t14*t26*t27*t28+1.1102230246251565d-16*t18*t2
     1           0*t24*t25+3.0506411443514264d-19*t17*t22+1.321039893133
     2           9265d-3*t13*t22
              t30 = 1/t2**2
              t31 = 1/rhob**4.333333333333333d+0
              t32 = 1/rhob**2.6666666666666666d+0
              t33 = 2.134444128d-101*t30*t31-8.8935172d-51*t3*t32
              t34 = -4.0d-51*t3*t32*t4+9.6d-102*t30*t31*t4+2.4d-51*t1*t3
     1           *t33
              t35 = 1/t16**2
              t36 = t24**2
              t37 = 1/t15**4
              t38 = 1/t15**3
              t39 = 1/t7**5
              t40 = 1/rhob**2.3333333333333334d+0
              t41 = 1/rhob**2.1666666666666665d+0
              t42 = 1.1632736958443765d+0*t41+9.89141964955861d-1*t40+6.
     1           003214762495226d-1*t39+2.1077825841639536d-1*t32
              t43 = 1/t12**2
              t44 = t27**2
              t45 = 1/t11**4
              t46 = 1/t11**3
              t47 = 2.1622951122684114d+0*t41+1.7087761055320938d+0*t40+
     1           1.2335503316757068d+0*t39+2.673190323653546d-1*t32
              t48 = 1.0d+0*t14*t26*t28*t47-2.0d+0*t14*t26*t44*t46+3.2163
     1           95899738507d+1*t14*t43*t44*t45+1.1102230246251565d-16*t
     2           18*t20*t25*t42-4.0675215258019015d-19*t17*t40-1.7613865
     3           241785684d-3*t13*t40-2.220446049250313d-16*t18*t20*t36*
     4           t38+1.7854583920998188d-15*t18*t35*t36*t37-8.4979745913
     5           33913d-2*t22*t26*t27*t28-9.812069668265515d-18*t20*t22*
     6           t24*t25
              t49 = 1/t2**3
              t50 = 1/rhob**7
              t51 = 1/rhob**5.333333333333333d+0
              t52 = 1/rhob**3.6666666666666664d+0
              t53 = 2.3716045866666666d-50*t3*t52-1.2806664767999998d-10
     1           0*t30*t51+1.7075553024d-151*t49*t50
              t54 = 2.4d-51*t1*t3*t53+1.0666666666666666d-50*t3*t4*t52-5
     1           .76d-101*t30*t4*t51+7.68d-152*t4*t49*t50-8.0d-51*t3*t32
     2           *t33+1.92d-101*t30*t31*t33
              t55 = t24**3
              t56 = 1/t7**7
              t57 = 1/rhob**3.3333333333333337d+0
              t58 = 1/rhob**3.1666666666666665d+0
              t59 = t27**3
              t60 = 1/t2**4
              t61 = 1/rhob**9.666666666666666d+0
              t62 = 1/rhob**8
              t63 = 1/rhob**6.333333333333333d+0
              t64 = 1/rhob**4.666666666666667d+0
              fnc(iq) = 5.0d-1*rhob*t19*t5*wght+fnc(iq)
              Amat(iq,D1_RB) = 5.0d-1*rhob*t29*t5*wght+5.0d-1*t19*t5*wgh
     1           t+5.0d-1*rhob*t19*t34*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RB_RB) = 5.0d-1*rhob*t19*t54*wght+5.0d-1*rhob*
     1           t48*t5*wght+1.0d+0*t29*t5*wght+1.0d+0*rhob*t29*t34*wght
     2           +1.0d+0*t19*t34*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
              Amat3(iq,D3_RB_RB_RB) = 5.0d-1*rhob*t19*(2.4d-51*t1*t3*(-8
     1           .695883484444443d-50*t3*t64+7.778863044266666d-100*t30*
     2           t63-2.2198218931199998d-150*t49*t62+2.04906636288d-201*
     3           t60*t61)-3.911111111111111d-50*t3*t4*t64+3.498666666666
     4           6666d-100*t30*t4*t63-9.984000000000001d-151*t4*t49*t62+
     5           9.216000000000001d-202*t4*t60*t61-1.2d-50*t3*t32*t53+2.
     6           88d-101*t30*t31*t53+3.2d-50*t3*t33*t52-1.72799999999999
     7           98d-100*t30*t33*t51+2.3040000000000002d-151*t33*t49*t50
     8           )*wght+5.0d-1*rhob*t5*(6.0d+0*t14*t26*t45*t59-1.9298375
     9           398431045d+2*t14*t43*t59/t11**5+2.0690405167709364d+3*t
     :           14*t59/(t11**6*t12**3)+1.1102230246251565d-16*t18*t20*t
     ;           25*(-2.520426340996149d+0*t58-2.3079979182303428d+0*t57
     <           -1.5008036906238065d+0*t56-5.620753557770543d-1*t52)+1.
     =           0d+0*t14*t26*t28*(-4.684972743248224d+0*t58-3.987144246
     >           2415524d+0*t57-3.083875829189267d+0*t56-7.1285075297427
     ?           89d-1*t52)+9.490883560204437d-19*t17*t57+4.109901889749
     @           9934d-3*t13*t57+6.661338147750939d-16*t18*t20*t37*t55-1
     1           .0712750352598913d-14*t18*t35*t55/t15**5+5.742741051503
     2           565d-14*t18*t55/(t15**6*t16**3)-6.0d+0*t14*t26*t27*t46*
     3           t47+9.649187699215522d+1*t14*t27*t43*t45*t47-1.27469618
     4           8700087d-1*t22*t26*t28*t47+2.549392377400174d-1*t22*t26
     5           *t44*t46-4.0999275947472624d+0*t22*t43*t44*t45-6.661338
     6           147750939d-16*t18*t20*t24*t38*t42+5.356375176299456d-15
     7           *t18*t24*t35*t37*t42-1.4718104502398274d-17*t20*t22*t25
     8           *t42+1.6995949182667827d-1*t26*t27*t28*t40+1.9624139336
     9           53103d-17*t20*t24*t25*t40+2.943620900479655d-17*t20*t22
     :           *t36*t38-2.3669625486718335d-16*t22*t35*t36*t37)*wght+1
     ;           .5d+0*rhob*t29*t54*wght+1.5d+0*t19*t54*wght+1.5d+0*t48*
     <           t5*wght+1.5d+0*rhob*t34*t48*wght+3.0d+0*t29*t34*wght+Am
     =           at3(iq,D3_RB_RB_RB)
              Cmat3(iq,D3_RB_RB_GBB) = Cmat3(iq,D3_RB_RB_GBB)
              Cmat3(iq,D3_RB_GBB_GBB) = Cmat3(iq,D3_RB_GBB_GBB)
              Cmat3(iq,D3_GBB_GBB_GBB) = Cmat3(iq,D3_GBB_GBB_GBB)
              Mmat3(iq,D3_RB_RB_TA) = Mmat3(iq,D3_RB_RB_TA)
              Mmat3(iq,D3_RB_RB_TB) = Mmat3(iq,D3_RB_RB_TB)
              Mmat3(iq,D3_RB_GBB_TA) = Mmat3(iq,D3_RB_GBB_TA)
              Mmat3(iq,D3_RB_GBB_TB) = Mmat3(iq,D3_RB_GBB_TB)
              Mmat3(iq,D3_GBB_GBB_TA) = Mmat3(iq,D3_GBB_GBB_TA)
              Mmat3(iq,D3_GBB_GBB_TB) = Mmat3(iq,D3_GBB_GBB_TB)
              Mmat3(iq,D3_RB_TA_TA) = Mmat3(iq,D3_RB_TA_TA)
              Mmat3(iq,D3_RB_TA_TB) = Mmat3(iq,D3_RB_TA_TB)
              Mmat3(iq,D3_RB_TB_TB) = Mmat3(iq,D3_RB_TB_TB)
              Mmat3(iq,D3_GBB_TA_TA) = Mmat3(iq,D3_GBB_TA_TA)
              Mmat3(iq,D3_GBB_TA_TB) = Mmat3(iq,D3_GBB_TA_TB)
              Mmat3(iq,D3_GBB_TB_TB) = Mmat3(iq,D3_GBB_TB_TB)
              Mmat3(iq,D3_TA_TA_TA) = Mmat3(iq,D3_TA_TA_TA)
              Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
              Mmat3(iq,D3_TA_TB_TB) = Mmat3(iq,D3_TA_TB_TB)
              Mmat3(iq,D3_TB_TB_TB) = Mmat3(iq,D3_TB_TB_TB)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhob**2.6666666666666666d+0
              t2 = 6.0d-2*gammabb*t1+1.0d+0
              t3 = 1/t2
              t4 = 1.3340275799999998d-1*gammabb*t1*t3-2.5960897d+0
              t5 = 6.0d-2*gammabb*t1*t3*t4+1.0d+0
              t6 = 1/rhob**6.666666666666666d-1
              t7 = rhob**5.0d-1
              t8 = 1/t7
              t9 = 1/rhob**3.333333333333333d-1
              t10 = 1/rhob**1.6666666666666666d-1
              t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.4
     1           058712912881916d-1*t6+1.1120374863094686d+1*t10
              t12 = 3.216395899738507d+1/t11+1.0d+0
              t13 = log(t12)
              t14 = 1.274696188700087d-1*t9+1.0d+0
              t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.8
     1           970043257475583d-1*t6+5.982550435771079d+0*t10
              t16 = 1.6081979498692536d+1/t15+1.0d+0
              t17 = log(t16)
              t18 = 1.3256889990520176d-1*t9+1.0d+0
              t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2
     1           *t13*t14
              t20 = 1/taub
              t21 = 1/rhob
              t22 = 2.0d+0*taub-2.5d-1*gammabb*t21
              t23 = 1/t16
              t24 = 1/rhob**1.6666666666666669d+0
              t25 = 1/t7**3
              t26 = 1/rhob**1.3333333333333333d+0
              t27 = 1/rhob**1.1666666666666667d+0
              t28 = -9.970917392951799d-1*t27-7.418564737168958d-1*t26-4
     1           .002143174996817d-1*t25-1.264669550498372d-1*t24
              t29 = 1/t15**2
              t30 = 1/t12
              t31 = -1.8533958105157808d+0*t27-1.2815820791490704d+0*t26
     1           -8.223668877838045d-1*t25-1.6039141941921276d-1*t24
              t32 = 1/t11**2
              t33 = 1.0d+0*t14*t30*t31*t32+1.1102230246251565d-16*t18*t2
     1           3*t28*t29+3.0506411443514264d-19*t17*t26+1.321039893133
     2           9265d-3*t13*t26
              t34 = gammabb**2
              t35 = 1/t2**2
              t36 = 1/rhob**6.333333333333333d+0
              t37 = 1/rhob**3.6666666666666664d+0
              t38 = 2.1344441279999993d-2*t34*t35*t36-3.557406879999999d
     1           -1*gammabb*t3*t37
              t39 = -1.5999999999999998d-1*gammabb*t3*t37*t4+9.599999999
     1           999997d-3*t34*t35*t36*t4+6.0d-2*gammabb*t1*t3*t38
              t40 = -1.25d-1*t19*t5*wght
              t41 = 1/rhob**5.333333333333333d+0
              t42 = 1.3340275799999998d-1*t1*t3-8.004165479999998d-3*gam
     1           mabb*t35*t41
              t43 = 6.0d-2*gammabb*t1*t3*t42-3.6d-3*gammabb*t35*t4*t41+6
     1           .0d-2*t1*t3*t4
              t44 = 1/taub**2
              t45 = 1/rhob**2
              t46 = 1/t16**2
              t47 = t28**2
              t48 = 1/t15**4
              t49 = 1/t15**3
              t50 = 1/t7**5
              t51 = 1/rhob**2.3333333333333334d+0
              t52 = 1/rhob**2.1666666666666665d+0
              t53 = 1.1632736958443765d+0*t52+9.89141964955861d-1*t51+6.
     1           003214762495226d-1*t50+2.1077825841639536d-1*t1
              t54 = 1/t12**2
              t55 = t31**2
              t56 = 1/t11**4
              t57 = 1/t11**3
              t58 = 2.1622951122684114d+0*t52+1.7087761055320938d+0*t51+
     1           1.2335503316757068d+0*t50+2.673190323653546d-1*t1
              t59 = 1.0d+0*t14*t30*t32*t58-2.0d+0*t14*t30*t55*t57+3.2163
     1           95899738507d+1*t14*t54*t55*t56+1.1102230246251565d-16*t
     2           18*t23*t29*t53-4.0675215258019015d-19*t17*t51-1.7613865
     3           241785684d-3*t13*t51-2.220446049250313d-16*t18*t23*t47*
     4           t49+1.7854583920998188d-15*t18*t46*t47*t48-8.4979745913
     5           33913d-2*t26*t30*t31*t32-9.812069668265515d-18*t23*t26*
     6           t28*t29
              t60 = gammabb**3
              t61 = 1/t2**3
              t62 = 1/rhob**10
              t63 = 1/rhob**7.333333333333333d+0
              t64 = 1/rhob**4.666666666666667d+0
              t65 = 1.3043825226666664d+0*gammabb*t3*t64-1.9209997151999
     1           994d-1*t34*t35*t63+6.830221209599997d-3*t60*t61*t62
              t66 = 6.0d-2*gammabb*t1*t3*t65+5.866666666666666d-1*gammab
     1           b*t3*t4*t64-8.639999999999998d-2*t34*t35*t4*t63+3.07199
     2           99999999986d-3*t4*t60*t61*t62-3.1999999999999995d-1*gam
     3           mabb*t3*t37*t38+1.9199999999999995d-2*t34*t35*t36*t38
              t67 = 1.25d-1*t19*t5*wght
              t68 = 1/rhob**9
              t69 = -2.561332953599999d-3*t34*t61*t68-3.557406879999999d
     1           -1*t3*t37+6.403332383999999d-2*gammabb*t35*t36
              t70 = 6.0d-2*gammabb*t1*t3*t69-1.1519999999999996d-3*t34*t
     1           4*t61*t68-1.5999999999999998d-1*gammabb*t3*t37*t42+9.59
     2           9999999999997d-3*t34*t35*t36*t42-3.6d-3*gammabb*t35*t38
     3           *t41-1.5999999999999998d-1*t3*t37*t4+2.879999999999999d
     4           -2*gammabb*t35*t36*t4+6.0d-2*t1*t3*t38
              t71 = 1/rhob**8
              t72 = 9.604998575999998d-4*gammabb*t61*t71-1.6008330959999
     1           997d-2*t35*t41
              t73 = 6.0d-2*gammabb*t1*t3*t72+4.32d-4*gammabb*t4*t61*t71-
     1           7.2d-3*gammabb*t35*t41*t42+1.2d-1*t1*t3*t42-7.2d-3*t35*
     2           t4*t41
              t74 = -5.0d-1*rhob*t22*t33*t5*wght-5.0d-1*t19*t22*t5*wght-
     1           5.0d-1*rhob*t19*t22*t39*wght
              t75 = t67-5.0d-1*rhob*t19*t22*t43*wght
              t76 = 1/taub**3
              t77 = 1/rhob**3
              t78 = t28**3
              t79 = 1/t7**7
              t80 = 1/rhob**3.3333333333333337d+0
              t81 = 1/rhob**3.1666666666666665d+0
              t82 = t31**3
              t83 = gammabb**4
              t84 = 1/t2**4
              t85 = 1/rhob**1.3666666666666666d+1
              t86 = 1/rhob**11
              t87 = 1/rhob**8.333333333333334d+0
              t88 = 1/rhob**5.666666666666667d+0
              t89 = 1.25d-1*t33*t5*wght
              t90 = 1.25d-1*t19*t39*wght
              t91 = t40-1.25d-1*gammabb*t19*t43*wght
              t92 = 1/rhob**1.2666666666666665d+1
              t93 = 2.5d-1*t19*t43*wght
              t94 = 1/rhob**1.1666666666666665d+1
              t95 = 1/rhob**1.0666666666666666d+1
              fnc(iq) = 5.0d-1*rhob*t19*t20*t22*t5*wght+fnc(iq)
              Amat(iq,D1_RB) = t20*(5.0d-1*rhob*t22*t33*t5*wght+5.0d-1*t
     1           19*t22*t5*wght+5.0d-1*rhob*t19*t22*t39*wght)+1.25d-1*ga
     2           mmabb*t19*t20*t21*t5*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = t20*(5.0d-1*rhob*t19*t22*t43*wght+t40)+C
     1           mat(iq,D1_GBB)
              Mmat(iq,D1_TB) = -5.0d-1*rhob*t19*t22*t44*t5*wght+1.0d+0*r
     1           hob*t19*t20*t5*wght+Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RB_RB) = t20*(5.0d-1*rhob*t19*t22*t66*wght+5.0
     1           d-1*rhob*t22*t5*t59*wght+1.25d-1*gammabb*t19*t45*t5*wgh
     2           t+1.0d+0*t22*t33*t5*wght+1.25d-1*gammabb*t21*t33*t5*wgh
     3           t+1.0d+0*rhob*t22*t33*t39*wght+1.0d+0*t19*t22*t39*wght+
     4           1.25d-1*gammabb*t19*t21*t39*wght)+t20*t21*(1.25d-1*gamm
     5           abb*t33*t5*wght+1.25d-1*gammabb*t19*t39*wght)-1.25d-1*g
     6           ammabb*t19*t20*t45*t5*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RB_GBB) = t20*(5.0d-1*rhob*t19*t22*t70*wght-1.
     1           25d-1*t33*t5*wght-1.25d-1*t19*t21*t5*wght+5.0d-1*rhob*t
     2           22*t33*t43*wght+5.0d-1*t19*t22*t43*wght-1.25d-1*t19*t39
     3           *wght)+t20*t21*(1.25d-1*gammabb*t19*t43*wght+t67)+Cmat2
     4           (iq,D2_RB_GBB)
              Cmat2(iq,D2_GBB_GBB) = t20*(5.0d-1*rhob*t19*t22*t73*wght-2
     1           .5d-1*t19*t43*wght)+Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = t20*(1.0d+0*rhob*t33*t5*wght+1.0d+0*t
     1           19*t5*wght+1.0d+0*rhob*t19*t39*wght)-1.25d-1*gammabb*t1
     2           9*t21*t44*t5*wght+t44*t74+Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = 1.0d+0*rhob*t19*t20*t43*wght+t44*t75
     1           +Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = 1.0d+0*rhob*t19*t22*t5*t76*wght-2.0d+
     1           0*rhob*t19*t44*t5*wght+Mmat2(iq,D2_TB_TB)
              Amat3(iq,D3_RB_RB_RB) = t20*(5.0d-1*rhob*t19*t22*(6.0d-2*g
     1           ammabb*t1*t3*(-6.08711843911111d+0*gammabb*t3*t88+1.617
     2           434328106666d+0*t34*t35*t87-1.2977420298239994d-1*t60*t
     3           61*t86+3.2785061806079985d-3*t83*t84*t85)-2.73777777777
     4           7778d+0*gammabb*t3*t4*t88+7.274666666666665d-1*t34*t35*
     5           t4*t87-5.836799999999998d-2*t4*t60*t61*t86+1.4745599999
     6           999992d-3*t4*t83*t84*t85-4.799999999999999d-1*gammabb*t
     7           3*t37*t65+2.879999999999999d-2*t34*t35*t36*t65+1.76d+0*
     8           gammabb*t3*t38*t64-2.5919999999999993d-1*t34*t35*t38*t6
     9           3+9.215999999999996d-3*t38*t60*t61*t62)*wght+5.0d-1*rho
     :           b*t22*t5*(6.0d+0*t14*t30*t56*t82-1.9298375398431045d+2*
     ;           t14*t54*t82/t11**5+2.0690405167709364d+3*t14*t82/(t11**
     <           6*t12**3)+1.1102230246251565d-16*t18*t23*t29*(-2.520426
     =           340996149d+0*t81-2.3079979182303428d+0*t80-1.5008036906
     >           238065d+0*t79-5.620753557770543d-1*t37)+1.0d+0*t14*t30*
     ?           t32*(-4.684972743248224d+0*t81-3.9871442462415524d+0*t8
     @           0-3.083875829189267d+0*t79-7.128507529742789d-1*t37)+9.
     1           490883560204437d-19*t17*t80+4.1099018897499934d-3*t13*t
     2           80+6.661338147750939d-16*t18*t23*t48*t78-1.071275035259
     3           8913d-14*t18*t46*t78/t15**5+5.742741051503565d-14*t18*t
     4           78/(t15**6*t16**3)-6.0d+0*t14*t30*t31*t57*t58+9.6491876
     5           99215522d+1*t14*t31*t54*t56*t58-1.274696188700087d-1*t2
     6           6*t30*t32*t58+2.549392377400174d-1*t26*t30*t55*t57-4.09
     7           99275947472624d+0*t26*t54*t55*t56-6.661338147750939d-16
     8           *t18*t23*t28*t49*t53+5.356375176299456d-15*t18*t28*t46*
     9           t48*t53-1.4718104502398274d-17*t23*t26*t29*t53+1.699594
     :           9182667827d-1*t30*t31*t32*t51+1.962413933653103d-17*t23
     ;           *t28*t29*t51+2.943620900479655d-17*t23*t26*t47*t49-2.36
     <           69625486718335d-16*t26*t46*t47*t48)*wght-2.5d-1*gammabb
     =           *t19*t5*t77*wght+1.5d+0*rhob*t22*t33*t66*wght+1.5d+0*t1
     >           9*t22*t66*wght+2.5d-1*gammabb*t19*t21*t66*wght+1.5d+0*t
     ?           22*t5*t59*wght+2.5d-1*gammabb*t21*t5*t59*wght+1.5d+0*rh
     @           ob*t22*t39*t59*wght+2.5d-1*gammabb*t33*t45*t5*wght+2.5d
     1           -1*gammabb*t19*t39*t45*wght+3.0d+0*t22*t33*t39*wght+5.0
     2           d-1*gammabb*t21*t33*t39*wght)+t20*t21*(1.25d-1*gammabb*
     3           t19*t66*wght+1.25d-1*gammabb*t5*t59*wght+2.5d-1*gammabb
     4           *t33*t39*wght)+t20*t45*(-2.5d-1*gammabb*t33*t5*wght-2.5
     5           d-1*gammabb*t19*t39*wght)+2.5d-1*gammabb*t19*t20*t5*t77
     6           *wght+Amat3(iq,D3_RB_RB_RB)
              Cmat3(iq,D3_RB_RB_GBB) = t20*(5.0d-1*rhob*t19*t22*(6.0d-2*
     1           gammabb*t1*t3*(-1.2294398177279994d-3*t60*t84*t92+1.304
     2           3825226666664d+0*t3*t64-4.624628943999999d-1*gammabb*t3
     3           5*t63+4.3542660211199985d-2*t34*t61*t62)-5.529599999999
     4           998d-4*t4*t60*t84*t92-3.1999999999999995d-1*gammabb*t3*
     5           t37*t69+1.9199999999999995d-2*t34*t35*t36*t69-2.3039999
     6           99999999d-3*t34*t38*t61*t68-3.6d-3*gammabb*t35*t41*t65+
     7           6.0d-2*t1*t3*t65+5.866666666666666d-1*gammabb*t3*t42*t6
     8           4+5.866666666666666d-1*t3*t4*t64-8.639999999999998d-2*t
     9           34*t35*t42*t63-2.0799999999999996d-1*gammabb*t35*t4*t63
     :           +3.0719999999999986d-3*t42*t60*t61*t62+1.95839999999999
     ;           93d-2*t34*t4*t61*t62-3.1999999999999995d-1*t3*t37*t38+5
     <           .759999999999998d-2*gammabb*t35*t36*t38)*wght+1.0d+0*rh
     =           ob*t22*t33*t70*wght+1.0d+0*t19*t22*t70*wght+1.25d-1*gam
     >           mabb*t19*t21*t70*wght-1.25d-1*t19*t66*wght-1.25d-1*t5*t
     ?           59*wght+5.0d-1*rhob*t22*t43*t59*wght+1.25d-1*t19*t45*t5
     @           *wght-1.25d-1*t21*t33*t5*wght+1.25d-1*gammabb*t19*t43*t
     1           45*wght+1.0d+0*t22*t33*t43*wght+1.25d-1*gammabb*t21*t33
     2           *t43*wght-2.5d-1*t33*t39*wght-1.25d-1*t19*t21*t39*wght)
     3           +t20*t21*(1.25d-1*gammabb*t19*t70*wght+1.25d-1*gammabb*
     4           t33*t43*wght+t90+t89)+t20*t45*t91+Cmat3(iq,D3_RB_RB_GBB
     5           )
              Cmat3(iq,D3_RB_GBB_GBB) = t20*(5.0d-1*rhob*t19*t22*(6.0d-2
     1           *gammabb*t1*t3*(4.6103993164799983d-4*t34*t84*t94-1.280
     2           6664767999995d-2*gammabb*t61*t68+8.537776511999997d-2*t
     3           35*t36)+2.073599999999999d-4*t34*t4*t84*t94-1.599999999
     4           9999998d-1*gammabb*t3*t37*t72+9.599999999999997d-3*t34*
     5           t35*t36*t72+4.32d-4*gammabb*t38*t61*t71-7.2d-3*gammabb*
     6           t35*t41*t69+1.2d-1*t1*t3*t69-2.303999999999999d-3*t34*t
     7           42*t61*t68-5.759999999999997d-3*gammabb*t4*t61*t68-3.19
     8           99999999999995d-1*t3*t37*t42+5.759999999999998d-2*gamma
     9           bb*t35*t36*t42-7.2d-3*t35*t38*t41+3.839999999999999d-2*
     :           t35*t36*t4)*wght+5.0d-1*rhob*t22*t33*t73*wght+5.0d-1*t1
     ;           9*t22*t73*wght-2.5d-1*t19*t70*wght-2.5d-1*t33*t43*wght-
     <           2.5d-1*t19*t21*t43*wght)+t20*t21*(1.25d-1*gammabb*t19*t
     =           73*wght+t93)+Cmat3(iq,D3_RB_GBB_GBB)
              Cmat3(iq,D3_GBB_GBB_GBB) = t20*(5.0d-1*rhob*t19*t22*(6.0d-
     1           2*gammabb*t1*t3*(2.881499572799999d-3*t61*t71-1.7288997
     2           436799997d-4*gammabb*t84*t95)-7.776d-5*gammabb*t4*t84*t
     3           95-1.0800000000000001d-2*gammabb*t35*t41*t72+1.8d-1*t1*
     4           t3*t72+1.296d-3*gammabb*t42*t61*t71+1.296d-3*t4*t61*t71
     5           -2.1600000000000003d-2*t35*t41*t42)*wght-3.75d-1*t19*t7
     6           3*wght)+Cmat3(iq,D3_GBB_GBB_GBB)
              Mmat3(iq,D3_RB_RB_TA) = Mmat3(iq,D3_RB_RB_TA)
              Mmat3(iq,D3_RB_RB_TB) = t44*(-5.0d-1*rhob*t19*t22*t66*wght
     1           -5.0d-1*rhob*t22*t5*t59*wght-1.25d-1*gammabb*t19*t45*t5
     2           *wght-1.0d+0*t22*t33*t5*wght-1.25d-1*gammabb*t21*t33*t5
     3           *wght-1.0d+0*rhob*t22*t33*t39*wght-1.0d+0*t19*t22*t39*w
     4           ght-1.25d-1*gammabb*t19*t21*t39*wght)+t20*(1.0d+0*rhob*
     5           t19*t66*wght+1.0d+0*rhob*t5*t59*wght+2.0d+0*t33*t5*wght
     6           +2.0d+0*rhob*t33*t39*wght+2.0d+0*t19*t39*wght)+t21*t44*
     7           (-1.25d-1*gammabb*t33*t5*wght-1.25d-1*gammabb*t19*t39*w
     8           ght)+1.25d-1*gammabb*t19*t44*t45*t5*wght+Mmat3(iq,D3_RB
     9           _RB_TB)
              Mmat3(iq,D3_RB_GBB_TA) = Mmat3(iq,D3_RB_GBB_TA)
              Mmat3(iq,D3_RB_GBB_TB) = t44*(-5.0d-1*rhob*t19*t22*t70*wgh
     1           t+1.25d-1*t19*t21*t5*wght-5.0d-1*rhob*t22*t33*t43*wght-
     2           5.0d-1*t19*t22*t43*wght+t90+t89)+t20*(1.0d+0*rhob*t19*t
     3           70*wght+1.0d+0*rhob*t33*t43*wght+1.0d+0*t19*t43*wght)+t
     4           21*t44*t91+Mmat3(iq,D3_RB_GBB_TB)
              Mmat3(iq,D3_GBB_GBB_TA) = Mmat3(iq,D3_GBB_GBB_TA)
              Mmat3(iq,D3_GBB_GBB_TB) = t44*(t93-5.0d-1*rhob*t19*t22*t73
     1           *wght)+1.0d+0*rhob*t19*t20*t73*wght+Mmat3(iq,D3_GBB_GBB
     2           _TB)
              Mmat3(iq,D3_RB_TA_TA) = Mmat3(iq,D3_RB_TA_TA)
              Mmat3(iq,D3_RB_TA_TB) = Mmat3(iq,D3_RB_TA_TB)
              Mmat3(iq,D3_RB_TB_TB) = t44*(-2.0d+0*rhob*t33*t5*wght-2.0d
     1           +0*t19*t5*wght-2.0d+0*rhob*t19*t39*wght)+2.5d-1*gammabb
     2           *t19*t21*t5*t76*wght-2*t74*t76+Mmat3(iq,D3_RB_TB_TB)
              Mmat3(iq,D3_GBB_TA_TA) = Mmat3(iq,D3_GBB_TA_TA)
              Mmat3(iq,D3_GBB_TA_TB) = Mmat3(iq,D3_GBB_TA_TB)
              Mmat3(iq,D3_GBB_TB_TB) = -2.0d+0*rhob*t19*t43*t44*wght-2*t
     1           75*t76+Mmat3(iq,D3_GBB_TB_TB)
              Mmat3(iq,D3_TA_TA_TA) = Mmat3(iq,D3_TA_TA_TA)
              Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
              Mmat3(iq,D3_TA_TB_TB) = Mmat3(iq,D3_TA_TB_TB)
              Mmat3(iq,D3_TB_TB_TB) = -3.0d+0*rhob*t19*t22*t5*wght/taub*
     1           *4+6.0d+0*rhob*t19*t5*t76*wght+Mmat3(iq,D3_TB_TB_TB)
            else 
              t1 = 1/rhob**1.6666666666666669d+0
              t2 = 2.4d-51*t1+1.0d+0
              t3 = 1/t2
              t4 = 5.336110319999999d-51*t1*t3-2.5960897d+0
              t5 = 2.4d-51*t1*t3*t4+1.0d+0
              t6 = 1/rhob**6.666666666666666d-1
              t7 = rhob**5.0d-1
              t8 = 1/t7
              t9 = 1/rhob**3.333333333333333d-1
              t10 = 1/rhob**1.6666666666666666d-1
              t11 = 3.8447462374472113d+0*t9+1.644733775567609d+0*t8+2.4
     1           058712912881916d-1*t6+1.1120374863094686d+1*t10
              t12 = 3.216395899738507d+1/t11+1.0d+0
              t13 = log(t12)
              t14 = 1.274696188700087d-1*t9+1.0d+0
              t15 = 2.2255694211506874d+0*t9+8.004286349993635d-1*t8+1.8
     1           970043257475583d-1*t6+5.982550435771079d+0*t10
              t16 = 1.6081979498692536d+1/t15+1.0d+0
              t17 = log(t16)
              t18 = 1.3256889990520176d-1*t9+1.0d+0
              t19 = -6.903522198342671d-18*t17*t18-3.1090699999999993d-2
     1           *t13*t14
              t20 = 1/t16
              t21 = 1/t7**3
              t22 = 1/rhob**1.3333333333333333d+0
              t23 = 1/rhob**1.1666666666666667d+0
              t24 = -9.970917392951799d-1*t23-7.418564737168958d-1*t22-4
     1           .002143174996817d-1*t21-1.264669550498372d-1*t1
              t25 = 1/t15**2
              t26 = 1/t12
              t27 = -1.8533958105157808d+0*t23-1.2815820791490704d+0*t22
     1           -8.223668877838045d-1*t21-1.6039141941921276d-1*t1
              t28 = 1/t11**2
              t29 = 1.0d+0*t14*t26*t27*t28+1.1102230246251565d-16*t18*t2
     1           0*t24*t25+3.0506411443514264d-19*t17*t22+1.321039893133
     2           9265d-3*t13*t22
              t30 = 1/t2**2
              t31 = 1/rhob**4.333333333333333d+0
              t32 = 1/rhob**2.6666666666666666d+0
              t33 = 2.134444128d-101*t30*t31-8.8935172d-51*t3*t32
              t34 = -4.0d-51*t3*t32*t4+9.6d-102*t30*t31*t4+2.4d-51*t1*t3
     1           *t33
              t35 = 1/t16**2
              t36 = t24**2
              t37 = 1/t15**4
              t38 = 1/t15**3
              t39 = 1/t7**5
              t40 = 1/rhob**2.3333333333333334d+0
              t41 = 1/rhob**2.1666666666666665d+0
              t42 = 1.1632736958443765d+0*t41+9.89141964955861d-1*t40+6.
     1           003214762495226d-1*t39+2.1077825841639536d-1*t32
              t43 = 1/t12**2
              t44 = t27**2
              t45 = 1/t11**4
              t46 = 1/t11**3
              t47 = 2.1622951122684114d+0*t41+1.7087761055320938d+0*t40+
     1           1.2335503316757068d+0*t39+2.673190323653546d-1*t32
              t48 = 1.0d+0*t14*t26*t28*t47-2.0d+0*t14*t26*t44*t46+3.2163
     1           95899738507d+1*t14*t43*t44*t45+1.1102230246251565d-16*t
     2           18*t20*t25*t42-4.0675215258019015d-19*t17*t40-1.7613865
     3           241785684d-3*t13*t40-2.220446049250313d-16*t18*t20*t36*
     4           t38+1.7854583920998188d-15*t18*t35*t36*t37-8.4979745913
     5           33913d-2*t22*t26*t27*t28-9.812069668265515d-18*t20*t22*
     6           t24*t25
              t49 = 1/t2**3
              t50 = 1/rhob**7
              t51 = 1/rhob**5.333333333333333d+0
              t52 = 1/rhob**3.6666666666666664d+0
              t53 = 2.3716045866666666d-50*t3*t52-1.2806664767999998d-10
     1           0*t30*t51+1.7075553024d-151*t49*t50
              t54 = 2.4d-51*t1*t3*t53+1.0666666666666666d-50*t3*t4*t52-5
     1           .76d-101*t30*t4*t51+7.68d-152*t4*t49*t50-8.0d-51*t3*t32
     2           *t33+1.92d-101*t30*t31*t33
              t55 = t24**3
              t56 = 1/t7**7
              t57 = 1/rhob**3.3333333333333337d+0
              t58 = 1/rhob**3.1666666666666665d+0
              t59 = t27**3
              t60 = 1/t2**4
              t61 = 1/rhob**9.666666666666666d+0
              t62 = 1/rhob**8
              t63 = 1/rhob**6.333333333333333d+0
              t64 = 1/rhob**4.666666666666667d+0
              fnc(iq) = 5.0d-1*rhob*t19*t5*wght+fnc(iq)
              Amat(iq,D1_RB) = 5.0d-1*rhob*t29*t5*wght+5.0d-1*t19*t5*wgh
     1           t+5.0d-1*rhob*t19*t34*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RB_RB) = 5.0d-1*rhob*t19*t54*wght+5.0d-1*rhob*
     1           t48*t5*wght+1.0d+0*t29*t5*wght+1.0d+0*rhob*t29*t34*wght
     2           +1.0d+0*t19*t34*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
              Amat3(iq,D3_RB_RB_RB) = 5.0d-1*rhob*t19*(2.4d-51*t1*t3*(-8
     1           .695883484444443d-50*t3*t64+7.778863044266666d-100*t30*
     2           t63-2.2198218931199998d-150*t49*t62+2.04906636288d-201*
     3           t60*t61)-3.911111111111111d-50*t3*t4*t64+3.498666666666
     4           6666d-100*t30*t4*t63-9.984000000000001d-151*t4*t49*t62+
     5           9.216000000000001d-202*t4*t60*t61-1.2d-50*t3*t32*t53+2.
     6           88d-101*t30*t31*t53+3.2d-50*t3*t33*t52-1.72799999999999
     7           98d-100*t30*t33*t51+2.3040000000000002d-151*t33*t49*t50
     8           )*wght+5.0d-1*rhob*t5*(6.0d+0*t14*t26*t45*t59-1.9298375
     9           398431045d+2*t14*t43*t59/t11**5+2.0690405167709364d+3*t
     :           14*t59/(t11**6*t12**3)+1.1102230246251565d-16*t18*t20*t
     ;           25*(-2.520426340996149d+0*t58-2.3079979182303428d+0*t57
     <           -1.5008036906238065d+0*t56-5.620753557770543d-1*t52)+1.
     =           0d+0*t14*t26*t28*(-4.684972743248224d+0*t58-3.987144246
     >           2415524d+0*t57-3.083875829189267d+0*t56-7.1285075297427
     ?           89d-1*t52)+9.490883560204437d-19*t17*t57+4.109901889749
     @           9934d-3*t13*t57+6.661338147750939d-16*t18*t20*t37*t55-1
     1           .0712750352598913d-14*t18*t35*t55/t15**5+5.742741051503
     2           565d-14*t18*t55/(t15**6*t16**3)-6.0d+0*t14*t26*t27*t46*
     3           t47+9.649187699215522d+1*t14*t27*t43*t45*t47-1.27469618
     4           8700087d-1*t22*t26*t28*t47+2.549392377400174d-1*t22*t26
     5           *t44*t46-4.0999275947472624d+0*t22*t43*t44*t45-6.661338
     6           147750939d-16*t18*t20*t24*t38*t42+5.356375176299456d-15
     7           *t18*t24*t35*t37*t42-1.4718104502398274d-17*t20*t22*t25
     8           *t42+1.6995949182667827d-1*t26*t27*t28*t40+1.9624139336
     9           53103d-17*t20*t24*t25*t40+2.943620900479655d-17*t20*t22
     :           *t36*t38-2.3669625486718335d-16*t22*t35*t36*t37)*wght+1
     ;           .5d+0*rhob*t29*t54*wght+1.5d+0*t19*t54*wght+1.5d+0*t48*
     <           t5*wght+1.5d+0*rhob*t34*t48*wght+3.0d+0*t29*t34*wght+Am
     =           at3(iq,D3_RB_RB_RB)
              Cmat3(iq,D3_RB_RB_GBB) = Cmat3(iq,D3_RB_RB_GBB)
              Cmat3(iq,D3_RB_GBB_GBB) = Cmat3(iq,D3_RB_GBB_GBB)
              Cmat3(iq,D3_GBB_GBB_GBB) = Cmat3(iq,D3_GBB_GBB_GBB)
              Mmat3(iq,D3_RB_RB_TA) = Mmat3(iq,D3_RB_RB_TA)
              Mmat3(iq,D3_RB_RB_TB) = Mmat3(iq,D3_RB_RB_TB)
              Mmat3(iq,D3_RB_GBB_TA) = Mmat3(iq,D3_RB_GBB_TA)
              Mmat3(iq,D3_RB_GBB_TB) = Mmat3(iq,D3_RB_GBB_TB)
              Mmat3(iq,D3_GBB_GBB_TA) = Mmat3(iq,D3_GBB_GBB_TA)
              Mmat3(iq,D3_GBB_GBB_TB) = Mmat3(iq,D3_GBB_GBB_TB)
              Mmat3(iq,D3_RB_TA_TA) = Mmat3(iq,D3_RB_TA_TA)
              Mmat3(iq,D3_RB_TA_TB) = Mmat3(iq,D3_RB_TA_TB)
              Mmat3(iq,D3_RB_TB_TB) = Mmat3(iq,D3_RB_TB_TB)
              Mmat3(iq,D3_GBB_TA_TA) = Mmat3(iq,D3_GBB_TA_TA)
              Mmat3(iq,D3_GBB_TA_TB) = Mmat3(iq,D3_GBB_TA_TB)
              Mmat3(iq,D3_GBB_TB_TB) = Mmat3(iq,D3_GBB_TB_TB)
              Mmat3(iq,D3_TA_TA_TA) = Mmat3(iq,D3_TA_TA_TA)
              Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
              Mmat3(iq,D3_TA_TB_TB) = Mmat3(iq,D3_TA_TB_TB)
              Mmat3(iq,D3_TB_TB_TB) = Mmat3(iq,D3_TB_TB_TB)
            endif 
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> @} 
