# Plugin Documentation

This documents all the plugins that ship with in the open
source OpenTimelineIO distribution.


This document is automatically generated by running the
`autogen_plugin_documentation` command, or by running `make plugin-model`.  It
is part of the unit tests suite and should be updated whenever the schema
changes.  If it needs to be updated, run: `make doc-plugins-update` and this
file should be regenerated.

# Manifests

The manifests describe plugins that are visible to OpenTimelineIO.  The core
manifest is listed first, then any user-defined local plugins.

- `opentimelineio/adapters/builtin_adapters.plugin_manifest.json`

# Core Plugins

Manifest path: `opentimelineio/adapters/builtin_adapters.plugin_manifest.json`



## Adapter Plugins

Adapter plugins convert to and from OpenTimelineIO.

[Adapters documentation page for more information](./adapters).

[Tutorial on how to write an adapter](write-an-adapter).


### otio_json

```
Adapter for reading and writing native .otio json files.
```

*source*: `opentimelineio/adapters/otio_json.py`


*Supported Features (with arguments)*:

- read_from_file: 
```
De-serializes an OpenTimelineIO object from a file

  Args:
      filepath (str): The path to an otio file to read from

  Returns:
      OpenTimeline: An OpenTimeline object
```
  - filepath
- read_from_string: 
```
De-serializes an OpenTimelineIO object from a json string

  Args:
      input_str (str): A string containing json serialized otio contents

  Returns:
      OpenTimeline: An OpenTimeline object
```
  - input_str
- write_to_file: 
```
Serializes an OpenTimelineIO object into a file

  Args:

      input_otio (OpenTimeline): An OpenTimeline object
      filepath (str): The name of an otio file to write to
      indent (int): number of spaces for each json indentation level.
  Use -1 for no indentation or newlines.

  If target_schema_versions is None and the environment variable
  "OTIO_DEFAULT_TARGET_VERSION_FAMILY_LABEL" is set, will read a map out of
  that for downgrade target.  The variable should be of the form
  FAMILY:LABEL, for example "MYSTUDIO:JUNE2022".

  Returns:
      bool: Write success

  Raises:
      ValueError: on write error
      otio.exceptions.InvalidEnvironmentVariableError: if there is a problem
      with the default environment variable
      "OTIO_DEFAULT_TARGET_VERSION_FAMILY_LABEL".
```
  - input_otio
  - filepath
  - target_schema_versions
  - indent
- write_to_string: 
```
Serializes an OpenTimelineIO object into a string

  Args:
      input_otio (OpenTimeline): An OpenTimeline object
      indent (int): number of spaces for each json indentation level. Use
  -1 for no indentation or newlines.

  If target_schema_versions is None and the environment variable
  "OTIO_DEFAULT_TARGET_VERSION_FAMILY_LABEL" is set, will read a map out of
  that for downgrade target.  The variable should be of the form
  FAMILY:LABEL, for example "MYSTUDIO:JUNE2022".

  Returns:
      str: A json serialized string representation

  Raises:
      otio.exceptions.InvalidEnvironmentVariableError: if there is a problem
      with the default environment variable
      "OTIO_DEFAULT_TARGET_VERSION_FAMILY_LABEL".
```
  - input_otio
  - target_schema_versions
  - indent





### otiod

```
OTIOD adapter - bundles otio files linked to local media in a directory

Takes as input an OTIO file that has media references which are all
ExternalReferences with target_urls to files with unique basenames that are
accessible through the file system and bundles those files and the otio file
into a single directory named with a suffix of .otiod.
```

*source*: `opentimelineio/adapters/otiod.py`


*Supported Features (with arguments)*:

- read_from_file:
  - filepath
  - absolute_media_reference_paths
- write_to_file:
  - input_otio
  - filepath
  - media_policy
  - dryrun





### otioz

```
OTIOZ adapter - bundles otio files linked to local media

Takes as input an OTIO file that has media references which are all
ExternalReferences with target_urls to files with unique basenames that are
accessible through the file system and bundles those files and the otio file
into a single zip file with the suffix .otioz.  Can error out if files aren't
locally referenced or provide missing references

Can also extract the content.otio file from an otioz bundle for processing.

Note that OTIOZ files _always_ use the unix style path separator ('/'). This
ensures that regardless of which platform a bundle was created on, it can be
read on unix and windows platforms.
```

*source*: `opentimelineio/adapters/otioz.py`


*Supported Features (with arguments)*:

- read_from_file:
  - filepath
  - extract_to_directory
- write_to_file:
  - input_otio
  - filepath
  - media_policy
  - dryrun





## Media Linkers

Media Linkers run after the adapter has read in the file and convert the media
references into valid references where appropriate.

[Tutorial on how to write a Media Linker](write-a-media-linker).



## SchemaDefs

SchemaDef plugins define new external schema.

[Tutorial on how to write a schemadef](write-a-schemadef).



## HookScripts

HookScripts are extra plugins that run on _hooks_.

[Tutorial on how to write a hookscript](write-a-hookscript).



## Hooks

Hooks are the points at which hookscripts will run.






