# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.workloadorchestration.aio import WorkloadOrchestrationMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestWorkloadOrchestrationMgmtSolutionTemplatesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(WorkloadOrchestrationMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_solution_templates_get(self, resource_group):
        response = await self.client.solution_templates.get(
            resource_group_name=resource_group.name,
            solution_template_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_solution_templates_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.solution_templates.begin_create_or_update(
                resource_group_name=resource_group.name,
                solution_template_name="str",
                resource={
                    "location": "str",
                    "eTag": "str",
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "capabilities": ["str"],
                        "description": "str",
                        "enableExternalValidation": bool,
                        "latestVersion": "str",
                        "provisioningState": "str",
                        "state": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_solution_templates_update(self, resource_group):
        response = await self.client.solution_templates.update(
            resource_group_name=resource_group.name,
            solution_template_name="str",
            properties={
                "location": "str",
                "eTag": "str",
                "id": "str",
                "name": "str",
                "properties": {
                    "capabilities": ["str"],
                    "description": "str",
                    "enableExternalValidation": bool,
                    "latestVersion": "str",
                    "provisioningState": "str",
                    "state": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_solution_templates_begin_create_version(self, resource_group):
        response = await (
            await self.client.solution_templates.begin_create_version(
                resource_group_name=resource_group.name,
                solution_template_name="str",
                body={
                    "solutionTemplateVersion": {
                        "eTag": "str",
                        "id": "str",
                        "name": "str",
                        "properties": {
                            "configurations": "str",
                            "specification": {"str": {}},
                            "orchestratorType": "str",
                            "provisioningState": "str",
                        },
                        "systemData": {
                            "createdAt": "2020-02-20 00:00:00",
                            "createdBy": "str",
                            "createdByType": "str",
                            "lastModifiedAt": "2020-02-20 00:00:00",
                            "lastModifiedBy": "str",
                            "lastModifiedByType": "str",
                        },
                        "type": "str",
                    },
                    "updateType": "str",
                    "version": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_solution_templates_begin_remove_version(self, resource_group):
        response = await (
            await self.client.solution_templates.begin_remove_version(
                resource_group_name=resource_group.name,
                solution_template_name="str",
                body={"version": "str"},
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_solution_templates_begin_delete(self, resource_group):
        response = await (
            await self.client.solution_templates.begin_delete(
                resource_group_name=resource_group.name,
                solution_template_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_solution_templates_list_by_resource_group(self, resource_group):
        response = self.client.solution_templates.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_solution_templates_list_by_subscription(self, resource_group):
        response = self.client.solution_templates.list_by_subscription()
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
