% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chunkutil.R
\name{vecseq}
\alias{vecseq}
\title{Vectorized Sequences}
\usage{
vecseq(x, y = NULL, concat = TRUE, eval = TRUE)
}
\arguments{
\item{x}{vector of sequence start points}

\item{y}{vector of sequence end points (if \code{is.null(y)} then \code{x}
are taken as endpoints, all starting at 1)}

\item{concat}{vector of sequence end points (if \code{is.null(y)} then
\code{x} are taken as endpoints, all starting at 1)}

\item{eval}{vector of sequence end points (if \code{is.null(y)} then
\code{x} are taken as endpoints, all starting at 1)}
}
\value{
\itemize{
\item if \code{concat == FALSE} and \code{eval == FALSE} a list with n calls that generate sequences
\item if \code{concat == FALSE} and \code{eval == TRUE } a list with n sequences
\item if \code{concat == TRUE } and \code{eval == FALSE} a single call generating the concatenated
sequences
\item if \code{concat == TRUE} and \code{eval == TRUE } an integer vector of concatentated sequences
}
}
\description{
\code{vecseq} returns concatenated multiple sequences
}
\details{
This is a generalization of \code{\link[=sequence]{sequence()}} in that you can choose
sequence starts other than 1 and also have options to no concat and/or
return a call instead of the evaluated sequence.
}
\examples{

  sequence(c(3, 4))
  vecseq(c(3, 4))
  vecseq(c(1, 11), c(5, 15))
  vecseq(c(1, 11), c(5, 15), concat=FALSE, eval=FALSE)
  vecseq(c(1, 11), c(5, 15), concat=FALSE, eval=TRUE)
  vecseq(c(1, 11), c(5, 15), concat=TRUE, eval=FALSE)
  vecseq(c(1, 11), c(5, 15), concat=TRUE, eval=TRUE)

}
\seealso{
\code{\link{:}}, \code{\link[=seq]{seq()}}, \code{\link[=sequence]{sequence()}}
}
\author{
Angelo Canty, Jens Oehlschlägel
}
\keyword{manip}
