## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(calculus)

## -----------------------------------------------------------------------------
gradient("x*y*z", var = c("x", "y", "z"))

## -----------------------------------------------------------------------------
gradient("x*y*z", var = c("x","y","z"), coordinates = "spherical")

## -----------------------------------------------------------------------------
gradient("x*y*z", var = c("x","y","z"), coordinates = c(1,"x","x*sin(y)"))

## -----------------------------------------------------------------------------
f <- function(x, y, z) x*y*z
gradient(f, var = c(x = 1, y = pi/2, z = 0), coordinates = "spherical")

## -----------------------------------------------------------------------------
f <- function(x) x[1]*x[2]*x[3]
gradient(f, var = c(1, pi/2, 0), coordinates = "spherical")

## -----------------------------------------------------------------------------
f <- function(x) c(prod(x), sum(x))
gradient(f, var = c(3, 2, 1))

## -----------------------------------------------------------------------------
f <- function(x) c(prod(x), sum(x))
gradient(f, var = c(3, 2, 1), coordinates = "cylindrical")

## -----------------------------------------------------------------------------
f <- function(x) x^2
jacobian(f, var = c(1))

## -----------------------------------------------------------------------------
f <- function(x, y, z) x*y*z
hessian(f, var = c(x = 3, y = 2, z = 1))

## -----------------------------------------------------------------------------
f <- function(x, y, z) c(x*y*z, x+y+z)
h <- hessian(f, var = c(x = 3, y = 2, z = 1))

## -----------------------------------------------------------------------------
h[1,,]
h[2,,]

## -----------------------------------------------------------------------------
f <- c("x^2", "y^2", "z^2")
divergence(f, var = c("x","y","z"))

## -----------------------------------------------------------------------------
f <- c("sqrt(r)/10", "sqrt(r)")
divergence(f, var = c("r","phi"), coordinates = "polar")

## -----------------------------------------------------------------------------
f <- matrix(c("x^2","y^2","z^2","x","y","z"), nrow = 2, byrow = TRUE)
divergence(f, var = c("x","y","z"))

## -----------------------------------------------------------------------------
f <- function(x,y,z) matrix(c(x^2,y^2,z^2,x,y,z), nrow = 2, byrow = TRUE)
divergence(f, var = c(x = 0, y = 0, z = 0))

## -----------------------------------------------------------------------------
f <- c("x^3*y^2","x")
curl(f, var = c("x","y"))

## -----------------------------------------------------------------------------
f <- c("x","-y","z")
curl(f, var = c("x","y","z"))

## -----------------------------------------------------------------------------
f <- matrix(c("x","-y","z","x^3*y^2","x","0"), nrow = 2, byrow = TRUE)
curl(f, var = c("x","y","z"))

## -----------------------------------------------------------------------------
f <- "x^3+y^3+z^3"
laplacian(f, var = c("x","y","z"))

## -----------------------------------------------------------------------------
f <- array(c("x^3+y^3+z^3", "x^2+y^2+z^2", "y^2", "z*x^2"), dim = c(2,2))
laplacian(f, var = c("x","y","z"))

