% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate.R
\name{evaluate}
\alias{evaluate}
\title{Evaluate Characters and Expressions}
\usage{
evaluate(f, var, params = list(), vectorize = TRUE)
}
\arguments{
\item{f}{array of \code{characters} or \code{expressions} to be evaluated.}

\item{var}{named vector or \code{data.frame} in which \code{f} is to be evaluated.}

\item{params}{\code{list} of additional parameters passed to \code{f}.}

\item{vectorize}{\code{logical}. Use vectorization? If \code{TRUE}, it can significantly boost performance but \code{f} needs to handle the vector of inputs appropriately.}
}
\value{
Evaluated object. When \code{var} is a named vector, the return is an array 
with the same dimensions of \code{f}. When \code{var} is a \code{data.frame}, the
return is a \code{matrix} with columns corresponding to the entries of \code{f} and 
rows corresponding to the rows of \code{var}.
}
\description{
Evaluates an array of \code{characters} or \code{expressions}.
}
\examples{
### single evaluation
f <- array(letters[1:4], dim = c(2,2))
var <- c(a = 1, b = 2, c = 3, d = 4)
evaluate(f, var)

### multiple evaluation
f <- array(letters[1:4], dim = c(2,2))
var <- data.frame(a = 1:3, b = 2:4, c = 3:5, d = 4:6)
evaluate(f, var)

### multiple evaluation with additional parameters
f <- "a*sum(x)"
var <- data.frame(a = 1:3)
params <- list(x = 1:3)
evaluate(f, var, params)

### multiple evaluation of non-vectorized expressions
f <- "a*myf(x)"
myf <- function(x) if(x>0) 1 else -1
var <- data.frame(a = 1:3, x = -1:1)
evaluate(f, var, params = list(myf = myf), vectorize = FALSE)

}
\references{
Guidotti E (2022). "calculus: High-Dimensional Numerical and Symbolic Calculus in R." Journal of Statistical Software, 104(5), 1-37. \doi{10.18637/jss.v104.i05}
}
\seealso{
Other utilities: 
\code{\link{c2e}()},
\code{\link{e2c}()},
\code{\link{wrap}()}
}
\concept{utilities}
