% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nobars.R
\name{nobars}
\alias{nobars}
\alias{nobars_}
\title{Omit terms separated by vertical bars in a formula}
\usage{
nobars(term)

nobars_(term)
}
\arguments{
\item{term}{the right-hand side of a mixed-model formula}
}
\value{
the fixed-effects part of the formula
}
\description{
Remove the random-effects terms from a mixed-effects formula,
thereby producing the fixed-effects formula.
}
\section{Note}{
 This function is called recursively on individual
terms in the model, which is why the argument is called \code{term} and not
a name like \code{form}, indicating a formula.
}

\examples{
nobars(Reaction ~ Days + (Days|Subject)) ## => Reaction ~ Days
}
\seealso{
\code{\link{formula}}, \code{\link{model.frame}}, \code{\link{model.matrix}}.

Other utilities: 
\code{\link{expandDoubleVerts}()},
\code{\link{mkReTrms}()},
\code{\link{subbars}()}
}
\concept{utilities}
\keyword{models}
\keyword{utilities}
