/* automatically generated by rust-bindgen 0.69.4 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub const StdVideoH264ChromaFormatIdc_STD_VIDEO_H264_CHROMA_FORMAT_IDC_MONOCHROME:
    StdVideoH264ChromaFormatIdc = 0;
pub const StdVideoH264ChromaFormatIdc_STD_VIDEO_H264_CHROMA_FORMAT_IDC_420:
    StdVideoH264ChromaFormatIdc = 1;
pub const StdVideoH264ChromaFormatIdc_STD_VIDEO_H264_CHROMA_FORMAT_IDC_422:
    StdVideoH264ChromaFormatIdc = 2;
pub const StdVideoH264ChromaFormatIdc_STD_VIDEO_H264_CHROMA_FORMAT_IDC_444:
    StdVideoH264ChromaFormatIdc = 3;
pub const StdVideoH264ChromaFormatIdc_STD_VIDEO_H264_CHROMA_FORMAT_IDC_INVALID:
    StdVideoH264ChromaFormatIdc = 2147483647;
pub type StdVideoH264ChromaFormatIdc = ::core::ffi::c_uint;
pub const StdVideoH264ProfileIdc_STD_VIDEO_H264_PROFILE_IDC_BASELINE: StdVideoH264ProfileIdc = 66;
pub const StdVideoH264ProfileIdc_STD_VIDEO_H264_PROFILE_IDC_MAIN: StdVideoH264ProfileIdc = 77;
pub const StdVideoH264ProfileIdc_STD_VIDEO_H264_PROFILE_IDC_HIGH: StdVideoH264ProfileIdc = 100;
pub const StdVideoH264ProfileIdc_STD_VIDEO_H264_PROFILE_IDC_HIGH_444_PREDICTIVE:
    StdVideoH264ProfileIdc = 244;
pub const StdVideoH264ProfileIdc_STD_VIDEO_H264_PROFILE_IDC_INVALID: StdVideoH264ProfileIdc =
    2147483647;
pub type StdVideoH264ProfileIdc = ::core::ffi::c_uint;
pub const StdVideoH264LevelIdc_STD_VIDEO_H264_LEVEL_IDC_1_0: StdVideoH264LevelIdc = 0;
pub const StdVideoH264LevelIdc_STD_VIDEO_H264_LEVEL_IDC_1_1: StdVideoH264LevelIdc = 1;
pub const StdVideoH264LevelIdc_STD_VIDEO_H264_LEVEL_IDC_1_2: StdVideoH264LevelIdc = 2;
pub const StdVideoH264LevelIdc_STD_VIDEO_H264_LEVEL_IDC_1_3: StdVideoH264LevelIdc = 3;
pub const StdVideoH264LevelIdc_STD_VIDEO_H264_LEVEL_IDC_2_0: StdVideoH264LevelIdc = 4;
pub const StdVideoH264LevelIdc_STD_VIDEO_H264_LEVEL_IDC_2_1: StdVideoH264LevelIdc = 5;
pub const StdVideoH264LevelIdc_STD_VIDEO_H264_LEVEL_IDC_2_2: StdVideoH264LevelIdc = 6;
pub const StdVideoH264LevelIdc_STD_VIDEO_H264_LEVEL_IDC_3_0: StdVideoH264LevelIdc = 7;
pub const StdVideoH264LevelIdc_STD_VIDEO_H264_LEVEL_IDC_3_1: StdVideoH264LevelIdc = 8;
pub const StdVideoH264LevelIdc_STD_VIDEO_H264_LEVEL_IDC_3_2: StdVideoH264LevelIdc = 9;
pub const StdVideoH264LevelIdc_STD_VIDEO_H264_LEVEL_IDC_4_0: StdVideoH264LevelIdc = 10;
pub const StdVideoH264LevelIdc_STD_VIDEO_H264_LEVEL_IDC_4_1: StdVideoH264LevelIdc = 11;
pub const StdVideoH264LevelIdc_STD_VIDEO_H264_LEVEL_IDC_4_2: StdVideoH264LevelIdc = 12;
pub const StdVideoH264LevelIdc_STD_VIDEO_H264_LEVEL_IDC_5_0: StdVideoH264LevelIdc = 13;
pub const StdVideoH264LevelIdc_STD_VIDEO_H264_LEVEL_IDC_5_1: StdVideoH264LevelIdc = 14;
pub const StdVideoH264LevelIdc_STD_VIDEO_H264_LEVEL_IDC_5_2: StdVideoH264LevelIdc = 15;
pub const StdVideoH264LevelIdc_STD_VIDEO_H264_LEVEL_IDC_6_0: StdVideoH264LevelIdc = 16;
pub const StdVideoH264LevelIdc_STD_VIDEO_H264_LEVEL_IDC_6_1: StdVideoH264LevelIdc = 17;
pub const StdVideoH264LevelIdc_STD_VIDEO_H264_LEVEL_IDC_6_2: StdVideoH264LevelIdc = 18;
pub const StdVideoH264LevelIdc_STD_VIDEO_H264_LEVEL_IDC_INVALID: StdVideoH264LevelIdc = 2147483647;
pub type StdVideoH264LevelIdc = ::core::ffi::c_uint;
pub const StdVideoH264PocType_STD_VIDEO_H264_POC_TYPE_0: StdVideoH264PocType = 0;
pub const StdVideoH264PocType_STD_VIDEO_H264_POC_TYPE_1: StdVideoH264PocType = 1;
pub const StdVideoH264PocType_STD_VIDEO_H264_POC_TYPE_2: StdVideoH264PocType = 2;
pub const StdVideoH264PocType_STD_VIDEO_H264_POC_TYPE_INVALID: StdVideoH264PocType = 2147483647;
pub type StdVideoH264PocType = ::core::ffi::c_uint;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_UNSPECIFIED:
    StdVideoH264AspectRatioIdc = 0;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_SQUARE:
    StdVideoH264AspectRatioIdc = 1;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_12_11:
    StdVideoH264AspectRatioIdc = 2;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_10_11:
    StdVideoH264AspectRatioIdc = 3;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_16_11:
    StdVideoH264AspectRatioIdc = 4;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_40_33:
    StdVideoH264AspectRatioIdc = 5;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_24_11:
    StdVideoH264AspectRatioIdc = 6;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_20_11:
    StdVideoH264AspectRatioIdc = 7;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_32_11:
    StdVideoH264AspectRatioIdc = 8;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_80_33:
    StdVideoH264AspectRatioIdc = 9;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_18_11:
    StdVideoH264AspectRatioIdc = 10;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_15_11:
    StdVideoH264AspectRatioIdc = 11;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_64_33:
    StdVideoH264AspectRatioIdc = 12;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_160_99:
    StdVideoH264AspectRatioIdc = 13;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_4_3:
    StdVideoH264AspectRatioIdc = 14;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_3_2:
    StdVideoH264AspectRatioIdc = 15;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_2_1:
    StdVideoH264AspectRatioIdc = 16;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_EXTENDED_SAR:
    StdVideoH264AspectRatioIdc = 255;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_INVALID:
    StdVideoH264AspectRatioIdc = 2147483647;
pub type StdVideoH264AspectRatioIdc = ::core::ffi::c_uint;
pub const StdVideoH264WeightedBipredIdc_STD_VIDEO_H264_WEIGHTED_BIPRED_IDC_DEFAULT:
    StdVideoH264WeightedBipredIdc = 0;
pub const StdVideoH264WeightedBipredIdc_STD_VIDEO_H264_WEIGHTED_BIPRED_IDC_EXPLICIT:
    StdVideoH264WeightedBipredIdc = 1;
pub const StdVideoH264WeightedBipredIdc_STD_VIDEO_H264_WEIGHTED_BIPRED_IDC_IMPLICIT:
    StdVideoH264WeightedBipredIdc = 2;
pub const StdVideoH264WeightedBipredIdc_STD_VIDEO_H264_WEIGHTED_BIPRED_IDC_INVALID:
    StdVideoH264WeightedBipredIdc = 2147483647;
pub type StdVideoH264WeightedBipredIdc = ::core::ffi::c_uint;
pub const StdVideoH264ModificationOfPicNumsIdc_STD_VIDEO_H264_MODIFICATION_OF_PIC_NUMS_IDC_SHORT_TERM_SUBTRACT : StdVideoH264ModificationOfPicNumsIdc = 0 ;
pub const StdVideoH264ModificationOfPicNumsIdc_STD_VIDEO_H264_MODIFICATION_OF_PIC_NUMS_IDC_SHORT_TERM_ADD : StdVideoH264ModificationOfPicNumsIdc = 1 ;
pub const StdVideoH264ModificationOfPicNumsIdc_STD_VIDEO_H264_MODIFICATION_OF_PIC_NUMS_IDC_LONG_TERM : StdVideoH264ModificationOfPicNumsIdc = 2 ;
pub const StdVideoH264ModificationOfPicNumsIdc_STD_VIDEO_H264_MODIFICATION_OF_PIC_NUMS_IDC_END:
    StdVideoH264ModificationOfPicNumsIdc = 3;
pub const StdVideoH264ModificationOfPicNumsIdc_STD_VIDEO_H264_MODIFICATION_OF_PIC_NUMS_IDC_INVALID : StdVideoH264ModificationOfPicNumsIdc = 2147483647 ;
pub type StdVideoH264ModificationOfPicNumsIdc = ::core::ffi::c_uint;
pub const StdVideoH264MemMgmtControlOp_STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_END:
    StdVideoH264MemMgmtControlOp = 0;
pub const StdVideoH264MemMgmtControlOp_STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_UNMARK_SHORT_TERM:
    StdVideoH264MemMgmtControlOp = 1;
pub const StdVideoH264MemMgmtControlOp_STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_UNMARK_LONG_TERM:
    StdVideoH264MemMgmtControlOp = 2;
pub const StdVideoH264MemMgmtControlOp_STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_MARK_LONG_TERM:
    StdVideoH264MemMgmtControlOp = 3;
pub const StdVideoH264MemMgmtControlOp_STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_SET_MAX_LONG_TERM_INDEX : StdVideoH264MemMgmtControlOp = 4 ;
pub const StdVideoH264MemMgmtControlOp_STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_UNMARK_ALL:
    StdVideoH264MemMgmtControlOp = 5;
pub const StdVideoH264MemMgmtControlOp_STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_MARK_CURRENT_AS_LONG_TERM : StdVideoH264MemMgmtControlOp = 6 ;
pub const StdVideoH264MemMgmtControlOp_STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_INVALID:
    StdVideoH264MemMgmtControlOp = 2147483647;
pub type StdVideoH264MemMgmtControlOp = ::core::ffi::c_uint;
pub const StdVideoH264CabacInitIdc_STD_VIDEO_H264_CABAC_INIT_IDC_0: StdVideoH264CabacInitIdc = 0;
pub const StdVideoH264CabacInitIdc_STD_VIDEO_H264_CABAC_INIT_IDC_1: StdVideoH264CabacInitIdc = 1;
pub const StdVideoH264CabacInitIdc_STD_VIDEO_H264_CABAC_INIT_IDC_2: StdVideoH264CabacInitIdc = 2;
pub const StdVideoH264CabacInitIdc_STD_VIDEO_H264_CABAC_INIT_IDC_INVALID: StdVideoH264CabacInitIdc =
    2147483647;
pub type StdVideoH264CabacInitIdc = ::core::ffi::c_uint;
pub const StdVideoH264DisableDeblockingFilterIdc_STD_VIDEO_H264_DISABLE_DEBLOCKING_FILTER_IDC_DISABLED : StdVideoH264DisableDeblockingFilterIdc = 0 ;
pub const StdVideoH264DisableDeblockingFilterIdc_STD_VIDEO_H264_DISABLE_DEBLOCKING_FILTER_IDC_ENABLED : StdVideoH264DisableDeblockingFilterIdc = 1 ;
pub const StdVideoH264DisableDeblockingFilterIdc_STD_VIDEO_H264_DISABLE_DEBLOCKING_FILTER_IDC_PARTIAL : StdVideoH264DisableDeblockingFilterIdc = 2 ;
pub const StdVideoH264DisableDeblockingFilterIdc_STD_VIDEO_H264_DISABLE_DEBLOCKING_FILTER_IDC_INVALID : StdVideoH264DisableDeblockingFilterIdc = 2147483647 ;
pub type StdVideoH264DisableDeblockingFilterIdc = ::core::ffi::c_uint;
pub const StdVideoH264SliceType_STD_VIDEO_H264_SLICE_TYPE_P: StdVideoH264SliceType = 0;
pub const StdVideoH264SliceType_STD_VIDEO_H264_SLICE_TYPE_B: StdVideoH264SliceType = 1;
pub const StdVideoH264SliceType_STD_VIDEO_H264_SLICE_TYPE_I: StdVideoH264SliceType = 2;
pub const StdVideoH264SliceType_STD_VIDEO_H264_SLICE_TYPE_INVALID: StdVideoH264SliceType =
    2147483647;
pub type StdVideoH264SliceType = ::core::ffi::c_uint;
pub const StdVideoH264PictureType_STD_VIDEO_H264_PICTURE_TYPE_P: StdVideoH264PictureType = 0;
pub const StdVideoH264PictureType_STD_VIDEO_H264_PICTURE_TYPE_B: StdVideoH264PictureType = 1;
pub const StdVideoH264PictureType_STD_VIDEO_H264_PICTURE_TYPE_I: StdVideoH264PictureType = 2;
pub const StdVideoH264PictureType_STD_VIDEO_H264_PICTURE_TYPE_IDR: StdVideoH264PictureType = 5;
pub const StdVideoH264PictureType_STD_VIDEO_H264_PICTURE_TYPE_INVALID: StdVideoH264PictureType =
    2147483647;
pub type StdVideoH264PictureType = ::core::ffi::c_uint;
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH264SpsVuiFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub __bindgen_padding_0: u16,
}
#[test]
fn bindgen_test_layout_StdVideoH264SpsVuiFlags() {
    assert_eq!(
        ::core::mem::size_of::<StdVideoH264SpsVuiFlags>(),
        4usize,
        concat!("Size of: ", stringify!(StdVideoH264SpsVuiFlags))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoH264SpsVuiFlags>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoH264SpsVuiFlags))
    );
}
impl StdVideoH264SpsVuiFlags {
    #[inline]
    pub fn aspect_ratio_info_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_aspect_ratio_info_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn overscan_info_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_overscan_info_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn overscan_appropriate_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_overscan_appropriate_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn video_signal_type_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_video_signal_type_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn video_full_range_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_video_full_range_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn color_description_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_color_description_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn chroma_loc_info_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_chroma_loc_info_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn timing_info_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_timing_info_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fixed_frame_rate_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fixed_frame_rate_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn bitstream_restriction_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_bitstream_restriction_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn nal_hrd_parameters_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_nal_hrd_parameters_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn vcl_hrd_parameters_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_vcl_hrd_parameters_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        aspect_ratio_info_present_flag: u32,
        overscan_info_present_flag: u32,
        overscan_appropriate_flag: u32,
        video_signal_type_present_flag: u32,
        video_full_range_flag: u32,
        color_description_present_flag: u32,
        chroma_loc_info_present_flag: u32,
        timing_info_present_flag: u32,
        fixed_frame_rate_flag: u32,
        bitstream_restriction_flag: u32,
        nal_hrd_parameters_present_flag: u32,
        vcl_hrd_parameters_present_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let aspect_ratio_info_present_flag: u32 =
                unsafe { ::core::mem::transmute(aspect_ratio_info_present_flag) };
            aspect_ratio_info_present_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let overscan_info_present_flag: u32 =
                unsafe { ::core::mem::transmute(overscan_info_present_flag) };
            overscan_info_present_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let overscan_appropriate_flag: u32 =
                unsafe { ::core::mem::transmute(overscan_appropriate_flag) };
            overscan_appropriate_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let video_signal_type_present_flag: u32 =
                unsafe { ::core::mem::transmute(video_signal_type_present_flag) };
            video_signal_type_present_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let video_full_range_flag: u32 =
                unsafe { ::core::mem::transmute(video_full_range_flag) };
            video_full_range_flag as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let color_description_present_flag: u32 =
                unsafe { ::core::mem::transmute(color_description_present_flag) };
            color_description_present_flag as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let chroma_loc_info_present_flag: u32 =
                unsafe { ::core::mem::transmute(chroma_loc_info_present_flag) };
            chroma_loc_info_present_flag as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let timing_info_present_flag: u32 =
                unsafe { ::core::mem::transmute(timing_info_present_flag) };
            timing_info_present_flag as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let fixed_frame_rate_flag: u32 =
                unsafe { ::core::mem::transmute(fixed_frame_rate_flag) };
            fixed_frame_rate_flag as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let bitstream_restriction_flag: u32 =
                unsafe { ::core::mem::transmute(bitstream_restriction_flag) };
            bitstream_restriction_flag as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let nal_hrd_parameters_present_flag: u32 =
                unsafe { ::core::mem::transmute(nal_hrd_parameters_present_flag) };
            nal_hrd_parameters_present_flag as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let vcl_hrd_parameters_present_flag: u32 =
                unsafe { ::core::mem::transmute(vcl_hrd_parameters_present_flag) };
            vcl_hrd_parameters_present_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH264HrdParameters {
    pub cpb_cnt_minus1: u8,
    pub bit_rate_scale: u8,
    pub cpb_size_scale: u8,
    pub reserved1: u8,
    pub bit_rate_value_minus1: [u32; 32usize],
    pub cpb_size_value_minus1: [u32; 32usize],
    pub cbr_flag: [u8; 32usize],
    pub initial_cpb_removal_delay_length_minus1: u32,
    pub cpb_removal_delay_length_minus1: u32,
    pub dpb_output_delay_length_minus1: u32,
    pub time_offset_length: u32,
}
#[test]
fn bindgen_test_layout_StdVideoH264HrdParameters() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoH264HrdParameters> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoH264HrdParameters>(),
        308usize,
        concat!("Size of: ", stringify!(StdVideoH264HrdParameters))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoH264HrdParameters>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoH264HrdParameters))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cpb_cnt_minus1) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264HrdParameters),
            "::",
            stringify!(cpb_cnt_minus1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).bit_rate_scale) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264HrdParameters),
            "::",
            stringify!(bit_rate_scale)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cpb_size_scale) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264HrdParameters),
            "::",
            stringify!(cpb_size_scale)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved1) as usize - ptr as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264HrdParameters),
            "::",
            stringify!(reserved1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).bit_rate_value_minus1) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264HrdParameters),
            "::",
            stringify!(bit_rate_value_minus1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cpb_size_value_minus1) as usize - ptr as usize },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264HrdParameters),
            "::",
            stringify!(cpb_size_value_minus1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cbr_flag) as usize - ptr as usize },
        260usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264HrdParameters),
            "::",
            stringify!(cbr_flag)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).initial_cpb_removal_delay_length_minus1) as usize
                - ptr as usize
        },
        292usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264HrdParameters),
            "::",
            stringify!(initial_cpb_removal_delay_length_minus1)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).cpb_removal_delay_length_minus1) as usize - ptr as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264HrdParameters),
            "::",
            stringify!(cpb_removal_delay_length_minus1)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).dpb_output_delay_length_minus1) as usize - ptr as usize
        },
        300usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264HrdParameters),
            "::",
            stringify!(dpb_output_delay_length_minus1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).time_offset_length) as usize - ptr as usize },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264HrdParameters),
            "::",
            stringify!(time_offset_length)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH264SequenceParameterSetVui {
    pub flags: StdVideoH264SpsVuiFlags,
    pub aspect_ratio_idc: StdVideoH264AspectRatioIdc,
    pub sar_width: u16,
    pub sar_height: u16,
    pub video_format: u8,
    pub colour_primaries: u8,
    pub transfer_characteristics: u8,
    pub matrix_coefficients: u8,
    pub num_units_in_tick: u32,
    pub time_scale: u32,
    pub max_num_reorder_frames: u8,
    pub max_dec_frame_buffering: u8,
    pub chroma_sample_loc_type_top_field: u8,
    pub chroma_sample_loc_type_bottom_field: u8,
    pub reserved1: u32,
    pub pHrdParameters: *const StdVideoH264HrdParameters,
}
#[test]
fn bindgen_test_layout_StdVideoH264SequenceParameterSetVui() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoH264SequenceParameterSetVui> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoH264SequenceParameterSetVui>(),
        40usize,
        concat!("Size of: ", stringify!(StdVideoH264SequenceParameterSetVui))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoH264SequenceParameterSetVui>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoH264SequenceParameterSetVui)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSetVui),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).aspect_ratio_idc) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSetVui),
            "::",
            stringify!(aspect_ratio_idc)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).sar_width) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSetVui),
            "::",
            stringify!(sar_width)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).sar_height) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSetVui),
            "::",
            stringify!(sar_height)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).video_format) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSetVui),
            "::",
            stringify!(video_format)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).colour_primaries) as usize - ptr as usize },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSetVui),
            "::",
            stringify!(colour_primaries)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).transfer_characteristics) as usize - ptr as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSetVui),
            "::",
            stringify!(transfer_characteristics)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).matrix_coefficients) as usize - ptr as usize },
        15usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSetVui),
            "::",
            stringify!(matrix_coefficients)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).num_units_in_tick) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSetVui),
            "::",
            stringify!(num_units_in_tick)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).time_scale) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSetVui),
            "::",
            stringify!(time_scale)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).max_num_reorder_frames) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSetVui),
            "::",
            stringify!(max_num_reorder_frames)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).max_dec_frame_buffering) as usize - ptr as usize },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSetVui),
            "::",
            stringify!(max_dec_frame_buffering)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).chroma_sample_loc_type_top_field) as usize - ptr as usize
        },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSetVui),
            "::",
            stringify!(chroma_sample_loc_type_top_field)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).chroma_sample_loc_type_bottom_field) as usize
                - ptr as usize
        },
        27usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSetVui),
            "::",
            stringify!(chroma_sample_loc_type_bottom_field)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved1) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSetVui),
            "::",
            stringify!(reserved1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pHrdParameters) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSetVui),
            "::",
            stringify!(pHrdParameters)
        )
    );
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH264SpsFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub __bindgen_padding_0: u16,
}
#[test]
fn bindgen_test_layout_StdVideoH264SpsFlags() {
    assert_eq!(
        ::core::mem::size_of::<StdVideoH264SpsFlags>(),
        4usize,
        concat!("Size of: ", stringify!(StdVideoH264SpsFlags))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoH264SpsFlags>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoH264SpsFlags))
    );
}
impl StdVideoH264SpsFlags {
    #[inline]
    pub fn constraint_set0_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_constraint_set0_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn constraint_set1_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_constraint_set1_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn constraint_set2_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_constraint_set2_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn constraint_set3_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_constraint_set3_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn constraint_set4_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_constraint_set4_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn constraint_set5_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_constraint_set5_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn direct_8x8_inference_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_direct_8x8_inference_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn mb_adaptive_frame_field_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_mb_adaptive_frame_field_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn frame_mbs_only_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_frame_mbs_only_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn delta_pic_order_always_zero_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_delta_pic_order_always_zero_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn separate_colour_plane_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_separate_colour_plane_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn gaps_in_frame_num_value_allowed_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_gaps_in_frame_num_value_allowed_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn qpprime_y_zero_transform_bypass_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_qpprime_y_zero_transform_bypass_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn frame_cropping_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_frame_cropping_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn seq_scaling_matrix_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_seq_scaling_matrix_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn vui_parameters_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_vui_parameters_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        constraint_set0_flag: u32,
        constraint_set1_flag: u32,
        constraint_set2_flag: u32,
        constraint_set3_flag: u32,
        constraint_set4_flag: u32,
        constraint_set5_flag: u32,
        direct_8x8_inference_flag: u32,
        mb_adaptive_frame_field_flag: u32,
        frame_mbs_only_flag: u32,
        delta_pic_order_always_zero_flag: u32,
        separate_colour_plane_flag: u32,
        gaps_in_frame_num_value_allowed_flag: u32,
        qpprime_y_zero_transform_bypass_flag: u32,
        frame_cropping_flag: u32,
        seq_scaling_matrix_present_flag: u32,
        vui_parameters_present_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let constraint_set0_flag: u32 = unsafe { ::core::mem::transmute(constraint_set0_flag) };
            constraint_set0_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let constraint_set1_flag: u32 = unsafe { ::core::mem::transmute(constraint_set1_flag) };
            constraint_set1_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let constraint_set2_flag: u32 = unsafe { ::core::mem::transmute(constraint_set2_flag) };
            constraint_set2_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let constraint_set3_flag: u32 = unsafe { ::core::mem::transmute(constraint_set3_flag) };
            constraint_set3_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let constraint_set4_flag: u32 = unsafe { ::core::mem::transmute(constraint_set4_flag) };
            constraint_set4_flag as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let constraint_set5_flag: u32 = unsafe { ::core::mem::transmute(constraint_set5_flag) };
            constraint_set5_flag as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let direct_8x8_inference_flag: u32 =
                unsafe { ::core::mem::transmute(direct_8x8_inference_flag) };
            direct_8x8_inference_flag as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let mb_adaptive_frame_field_flag: u32 =
                unsafe { ::core::mem::transmute(mb_adaptive_frame_field_flag) };
            mb_adaptive_frame_field_flag as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let frame_mbs_only_flag: u32 = unsafe { ::core::mem::transmute(frame_mbs_only_flag) };
            frame_mbs_only_flag as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let delta_pic_order_always_zero_flag: u32 =
                unsafe { ::core::mem::transmute(delta_pic_order_always_zero_flag) };
            delta_pic_order_always_zero_flag as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let separate_colour_plane_flag: u32 =
                unsafe { ::core::mem::transmute(separate_colour_plane_flag) };
            separate_colour_plane_flag as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let gaps_in_frame_num_value_allowed_flag: u32 =
                unsafe { ::core::mem::transmute(gaps_in_frame_num_value_allowed_flag) };
            gaps_in_frame_num_value_allowed_flag as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let qpprime_y_zero_transform_bypass_flag: u32 =
                unsafe { ::core::mem::transmute(qpprime_y_zero_transform_bypass_flag) };
            qpprime_y_zero_transform_bypass_flag as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let frame_cropping_flag: u32 = unsafe { ::core::mem::transmute(frame_cropping_flag) };
            frame_cropping_flag as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let seq_scaling_matrix_present_flag: u32 =
                unsafe { ::core::mem::transmute(seq_scaling_matrix_present_flag) };
            seq_scaling_matrix_present_flag as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let vui_parameters_present_flag: u32 =
                unsafe { ::core::mem::transmute(vui_parameters_present_flag) };
            vui_parameters_present_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH264ScalingLists {
    pub scaling_list_present_mask: u16,
    pub use_default_scaling_matrix_mask: u16,
    pub ScalingList4x4: [[u8; 16usize]; 6usize],
    pub ScalingList8x8: [[u8; 64usize]; 6usize],
}
#[test]
fn bindgen_test_layout_StdVideoH264ScalingLists() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoH264ScalingLists> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoH264ScalingLists>(),
        484usize,
        concat!("Size of: ", stringify!(StdVideoH264ScalingLists))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoH264ScalingLists>(),
        2usize,
        concat!("Alignment of ", stringify!(StdVideoH264ScalingLists))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).scaling_list_present_mask) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264ScalingLists),
            "::",
            stringify!(scaling_list_present_mask)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).use_default_scaling_matrix_mask) as usize - ptr as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264ScalingLists),
            "::",
            stringify!(use_default_scaling_matrix_mask)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ScalingList4x4) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264ScalingLists),
            "::",
            stringify!(ScalingList4x4)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ScalingList8x8) as usize - ptr as usize },
        100usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264ScalingLists),
            "::",
            stringify!(ScalingList8x8)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH264SequenceParameterSet {
    pub flags: StdVideoH264SpsFlags,
    pub profile_idc: StdVideoH264ProfileIdc,
    pub level_idc: StdVideoH264LevelIdc,
    pub chroma_format_idc: StdVideoH264ChromaFormatIdc,
    pub seq_parameter_set_id: u8,
    pub bit_depth_luma_minus8: u8,
    pub bit_depth_chroma_minus8: u8,
    pub log2_max_frame_num_minus4: u8,
    pub pic_order_cnt_type: StdVideoH264PocType,
    pub offset_for_non_ref_pic: i32,
    pub offset_for_top_to_bottom_field: i32,
    pub log2_max_pic_order_cnt_lsb_minus4: u8,
    pub num_ref_frames_in_pic_order_cnt_cycle: u8,
    pub max_num_ref_frames: u8,
    pub reserved1: u8,
    pub pic_width_in_mbs_minus1: u32,
    pub pic_height_in_map_units_minus1: u32,
    pub frame_crop_left_offset: u32,
    pub frame_crop_right_offset: u32,
    pub frame_crop_top_offset: u32,
    pub frame_crop_bottom_offset: u32,
    pub reserved2: u32,
    pub pOffsetForRefFrame: *const i32,
    pub pScalingLists: *const StdVideoH264ScalingLists,
    pub pSequenceParameterSetVui: *const StdVideoH264SequenceParameterSetVui,
}
#[test]
fn bindgen_test_layout_StdVideoH264SequenceParameterSet() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoH264SequenceParameterSet> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoH264SequenceParameterSet>(),
        88usize,
        concat!("Size of: ", stringify!(StdVideoH264SequenceParameterSet))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoH264SequenceParameterSet>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoH264SequenceParameterSet)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).profile_idc) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(profile_idc)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).level_idc) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(level_idc)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).chroma_format_idc) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(chroma_format_idc)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).seq_parameter_set_id) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(seq_parameter_set_id)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).bit_depth_luma_minus8) as usize - ptr as usize },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(bit_depth_luma_minus8)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).bit_depth_chroma_minus8) as usize - ptr as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(bit_depth_chroma_minus8)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).log2_max_frame_num_minus4) as usize - ptr as usize },
        19usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(log2_max_frame_num_minus4)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pic_order_cnt_type) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(pic_order_cnt_type)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).offset_for_non_ref_pic) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(offset_for_non_ref_pic)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).offset_for_top_to_bottom_field) as usize - ptr as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(offset_for_top_to_bottom_field)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).log2_max_pic_order_cnt_lsb_minus4) as usize - ptr as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(log2_max_pic_order_cnt_lsb_minus4)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).num_ref_frames_in_pic_order_cnt_cycle) as usize
                - ptr as usize
        },
        33usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(num_ref_frames_in_pic_order_cnt_cycle)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).max_num_ref_frames) as usize - ptr as usize },
        34usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(max_num_ref_frames)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved1) as usize - ptr as usize },
        35usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(reserved1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pic_width_in_mbs_minus1) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(pic_width_in_mbs_minus1)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).pic_height_in_map_units_minus1) as usize - ptr as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(pic_height_in_map_units_minus1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).frame_crop_left_offset) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(frame_crop_left_offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).frame_crop_right_offset) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(frame_crop_right_offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).frame_crop_top_offset) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(frame_crop_top_offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).frame_crop_bottom_offset) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(frame_crop_bottom_offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved2) as usize - ptr as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(reserved2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pOffsetForRefFrame) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(pOffsetForRefFrame)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pScalingLists) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(pScalingLists)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pSequenceParameterSetVui) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(pSequenceParameterSetVui)
        )
    );
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH264PpsFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[test]
fn bindgen_test_layout_StdVideoH264PpsFlags() {
    assert_eq!(
        ::core::mem::size_of::<StdVideoH264PpsFlags>(),
        4usize,
        concat!("Size of: ", stringify!(StdVideoH264PpsFlags))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoH264PpsFlags>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoH264PpsFlags))
    );
}
impl StdVideoH264PpsFlags {
    #[inline]
    pub fn transform_8x8_mode_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_transform_8x8_mode_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn redundant_pic_cnt_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_redundant_pic_cnt_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn constrained_intra_pred_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_constrained_intra_pred_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn deblocking_filter_control_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_deblocking_filter_control_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn weighted_pred_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_weighted_pred_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn bottom_field_pic_order_in_frame_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_bottom_field_pic_order_in_frame_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn entropy_coding_mode_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_entropy_coding_mode_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pic_scaling_matrix_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pic_scaling_matrix_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        transform_8x8_mode_flag: u32,
        redundant_pic_cnt_present_flag: u32,
        constrained_intra_pred_flag: u32,
        deblocking_filter_control_present_flag: u32,
        weighted_pred_flag: u32,
        bottom_field_pic_order_in_frame_present_flag: u32,
        entropy_coding_mode_flag: u32,
        pic_scaling_matrix_present_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let transform_8x8_mode_flag: u32 =
                unsafe { ::core::mem::transmute(transform_8x8_mode_flag) };
            transform_8x8_mode_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let redundant_pic_cnt_present_flag: u32 =
                unsafe { ::core::mem::transmute(redundant_pic_cnt_present_flag) };
            redundant_pic_cnt_present_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let constrained_intra_pred_flag: u32 =
                unsafe { ::core::mem::transmute(constrained_intra_pred_flag) };
            constrained_intra_pred_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let deblocking_filter_control_present_flag: u32 =
                unsafe { ::core::mem::transmute(deblocking_filter_control_present_flag) };
            deblocking_filter_control_present_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let weighted_pred_flag: u32 = unsafe { ::core::mem::transmute(weighted_pred_flag) };
            weighted_pred_flag as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let bottom_field_pic_order_in_frame_present_flag: u32 =
                unsafe { ::core::mem::transmute(bottom_field_pic_order_in_frame_present_flag) };
            bottom_field_pic_order_in_frame_present_flag as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let entropy_coding_mode_flag: u32 =
                unsafe { ::core::mem::transmute(entropy_coding_mode_flag) };
            entropy_coding_mode_flag as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let pic_scaling_matrix_present_flag: u32 =
                unsafe { ::core::mem::transmute(pic_scaling_matrix_present_flag) };
            pic_scaling_matrix_present_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH264PictureParameterSet {
    pub flags: StdVideoH264PpsFlags,
    pub seq_parameter_set_id: u8,
    pub pic_parameter_set_id: u8,
    pub num_ref_idx_l0_default_active_minus1: u8,
    pub num_ref_idx_l1_default_active_minus1: u8,
    pub weighted_bipred_idc: StdVideoH264WeightedBipredIdc,
    pub pic_init_qp_minus26: i8,
    pub pic_init_qs_minus26: i8,
    pub chroma_qp_index_offset: i8,
    pub second_chroma_qp_index_offset: i8,
    pub pScalingLists: *const StdVideoH264ScalingLists,
}
#[test]
fn bindgen_test_layout_StdVideoH264PictureParameterSet() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoH264PictureParameterSet> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoH264PictureParameterSet>(),
        24usize,
        concat!("Size of: ", stringify!(StdVideoH264PictureParameterSet))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoH264PictureParameterSet>(),
        8usize,
        concat!("Alignment of ", stringify!(StdVideoH264PictureParameterSet))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264PictureParameterSet),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).seq_parameter_set_id) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264PictureParameterSet),
            "::",
            stringify!(seq_parameter_set_id)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pic_parameter_set_id) as usize - ptr as usize },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264PictureParameterSet),
            "::",
            stringify!(pic_parameter_set_id)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).num_ref_idx_l0_default_active_minus1) as usize
                - ptr as usize
        },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264PictureParameterSet),
            "::",
            stringify!(num_ref_idx_l0_default_active_minus1)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).num_ref_idx_l1_default_active_minus1) as usize
                - ptr as usize
        },
        7usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264PictureParameterSet),
            "::",
            stringify!(num_ref_idx_l1_default_active_minus1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).weighted_bipred_idc) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264PictureParameterSet),
            "::",
            stringify!(weighted_bipred_idc)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pic_init_qp_minus26) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264PictureParameterSet),
            "::",
            stringify!(pic_init_qp_minus26)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pic_init_qs_minus26) as usize - ptr as usize },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264PictureParameterSet),
            "::",
            stringify!(pic_init_qs_minus26)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).chroma_qp_index_offset) as usize - ptr as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264PictureParameterSet),
            "::",
            stringify!(chroma_qp_index_offset)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).second_chroma_qp_index_offset) as usize - ptr as usize
        },
        15usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264PictureParameterSet),
            "::",
            stringify!(second_chroma_qp_index_offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pScalingLists) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264PictureParameterSet),
            "::",
            stringify!(pScalingLists)
        )
    );
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoDecodeH264PictureInfoFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[test]
fn bindgen_test_layout_StdVideoDecodeH264PictureInfoFlags() {
    assert_eq!(
        ::core::mem::size_of::<StdVideoDecodeH264PictureInfoFlags>(),
        4usize,
        concat!("Size of: ", stringify!(StdVideoDecodeH264PictureInfoFlags))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoDecodeH264PictureInfoFlags>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoDecodeH264PictureInfoFlags)
        )
    );
}
impl StdVideoDecodeH264PictureInfoFlags {
    #[inline]
    pub fn field_pic_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_field_pic_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_intra(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_intra(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn IdrPicFlag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_IdrPicFlag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn bottom_field_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_bottom_field_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_reference(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_reference(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn complementary_field_pair(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_complementary_field_pair(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        field_pic_flag: u32,
        is_intra: u32,
        IdrPicFlag: u32,
        bottom_field_flag: u32,
        is_reference: u32,
        complementary_field_pair: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let field_pic_flag: u32 = unsafe { ::core::mem::transmute(field_pic_flag) };
            field_pic_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let is_intra: u32 = unsafe { ::core::mem::transmute(is_intra) };
            is_intra as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let IdrPicFlag: u32 = unsafe { ::core::mem::transmute(IdrPicFlag) };
            IdrPicFlag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let bottom_field_flag: u32 = unsafe { ::core::mem::transmute(bottom_field_flag) };
            bottom_field_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let is_reference: u32 = unsafe { ::core::mem::transmute(is_reference) };
            is_reference as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let complementary_field_pair: u32 =
                unsafe { ::core::mem::transmute(complementary_field_pair) };
            complementary_field_pair as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoDecodeH264PictureInfo {
    pub flags: StdVideoDecodeH264PictureInfoFlags,
    pub seq_parameter_set_id: u8,
    pub pic_parameter_set_id: u8,
    pub reserved1: u8,
    pub reserved2: u8,
    pub frame_num: u16,
    pub idr_pic_id: u16,
    pub PicOrderCnt: [i32; 2usize],
}
#[test]
fn bindgen_test_layout_StdVideoDecodeH264PictureInfo() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoDecodeH264PictureInfo> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoDecodeH264PictureInfo>(),
        20usize,
        concat!("Size of: ", stringify!(StdVideoDecodeH264PictureInfo))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoDecodeH264PictureInfo>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoDecodeH264PictureInfo))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH264PictureInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).seq_parameter_set_id) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH264PictureInfo),
            "::",
            stringify!(seq_parameter_set_id)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pic_parameter_set_id) as usize - ptr as usize },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH264PictureInfo),
            "::",
            stringify!(pic_parameter_set_id)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved1) as usize - ptr as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH264PictureInfo),
            "::",
            stringify!(reserved1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved2) as usize - ptr as usize },
        7usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH264PictureInfo),
            "::",
            stringify!(reserved2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).frame_num) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH264PictureInfo),
            "::",
            stringify!(frame_num)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).idr_pic_id) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH264PictureInfo),
            "::",
            stringify!(idr_pic_id)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).PicOrderCnt) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH264PictureInfo),
            "::",
            stringify!(PicOrderCnt)
        )
    );
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoDecodeH264ReferenceInfoFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[test]
fn bindgen_test_layout_StdVideoDecodeH264ReferenceInfoFlags() {
    assert_eq!(
        ::core::mem::size_of::<StdVideoDecodeH264ReferenceInfoFlags>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(StdVideoDecodeH264ReferenceInfoFlags)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoDecodeH264ReferenceInfoFlags>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoDecodeH264ReferenceInfoFlags)
        )
    );
}
impl StdVideoDecodeH264ReferenceInfoFlags {
    #[inline]
    pub fn top_field_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_top_field_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn bottom_field_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_bottom_field_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn used_for_long_term_reference(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_used_for_long_term_reference(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_non_existing(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_non_existing(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        top_field_flag: u32,
        bottom_field_flag: u32,
        used_for_long_term_reference: u32,
        is_non_existing: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let top_field_flag: u32 = unsafe { ::core::mem::transmute(top_field_flag) };
            top_field_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let bottom_field_flag: u32 = unsafe { ::core::mem::transmute(bottom_field_flag) };
            bottom_field_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let used_for_long_term_reference: u32 =
                unsafe { ::core::mem::transmute(used_for_long_term_reference) };
            used_for_long_term_reference as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let is_non_existing: u32 = unsafe { ::core::mem::transmute(is_non_existing) };
            is_non_existing as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoDecodeH264ReferenceInfo {
    pub flags: StdVideoDecodeH264ReferenceInfoFlags,
    pub FrameNum: u16,
    pub reserved: u16,
    pub PicOrderCnt: [i32; 2usize],
}
#[test]
fn bindgen_test_layout_StdVideoDecodeH264ReferenceInfo() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoDecodeH264ReferenceInfo> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoDecodeH264ReferenceInfo>(),
        16usize,
        concat!("Size of: ", stringify!(StdVideoDecodeH264ReferenceInfo))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoDecodeH264ReferenceInfo>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoDecodeH264ReferenceInfo))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH264ReferenceInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).FrameNum) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH264ReferenceInfo),
            "::",
            stringify!(FrameNum)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved) as usize - ptr as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH264ReferenceInfo),
            "::",
            stringify!(reserved)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).PicOrderCnt) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH264ReferenceInfo),
            "::",
            stringify!(PicOrderCnt)
        )
    );
}
pub const StdVideoH265ChromaFormatIdc_STD_VIDEO_H265_CHROMA_FORMAT_IDC_MONOCHROME:
    StdVideoH265ChromaFormatIdc = 0;
pub const StdVideoH265ChromaFormatIdc_STD_VIDEO_H265_CHROMA_FORMAT_IDC_420:
    StdVideoH265ChromaFormatIdc = 1;
pub const StdVideoH265ChromaFormatIdc_STD_VIDEO_H265_CHROMA_FORMAT_IDC_422:
    StdVideoH265ChromaFormatIdc = 2;
pub const StdVideoH265ChromaFormatIdc_STD_VIDEO_H265_CHROMA_FORMAT_IDC_444:
    StdVideoH265ChromaFormatIdc = 3;
pub const StdVideoH265ChromaFormatIdc_STD_VIDEO_H265_CHROMA_FORMAT_IDC_INVALID:
    StdVideoH265ChromaFormatIdc = 2147483647;
pub type StdVideoH265ChromaFormatIdc = ::core::ffi::c_uint;
pub const StdVideoH265ProfileIdc_STD_VIDEO_H265_PROFILE_IDC_MAIN: StdVideoH265ProfileIdc = 1;
pub const StdVideoH265ProfileIdc_STD_VIDEO_H265_PROFILE_IDC_MAIN_10: StdVideoH265ProfileIdc = 2;
pub const StdVideoH265ProfileIdc_STD_VIDEO_H265_PROFILE_IDC_MAIN_STILL_PICTURE:
    StdVideoH265ProfileIdc = 3;
pub const StdVideoH265ProfileIdc_STD_VIDEO_H265_PROFILE_IDC_FORMAT_RANGE_EXTENSIONS:
    StdVideoH265ProfileIdc = 4;
pub const StdVideoH265ProfileIdc_STD_VIDEO_H265_PROFILE_IDC_SCC_EXTENSIONS: StdVideoH265ProfileIdc =
    9;
pub const StdVideoH265ProfileIdc_STD_VIDEO_H265_PROFILE_IDC_INVALID: StdVideoH265ProfileIdc =
    2147483647;
pub type StdVideoH265ProfileIdc = ::core::ffi::c_uint;
pub const StdVideoH265LevelIdc_STD_VIDEO_H265_LEVEL_IDC_1_0: StdVideoH265LevelIdc = 0;
pub const StdVideoH265LevelIdc_STD_VIDEO_H265_LEVEL_IDC_2_0: StdVideoH265LevelIdc = 1;
pub const StdVideoH265LevelIdc_STD_VIDEO_H265_LEVEL_IDC_2_1: StdVideoH265LevelIdc = 2;
pub const StdVideoH265LevelIdc_STD_VIDEO_H265_LEVEL_IDC_3_0: StdVideoH265LevelIdc = 3;
pub const StdVideoH265LevelIdc_STD_VIDEO_H265_LEVEL_IDC_3_1: StdVideoH265LevelIdc = 4;
pub const StdVideoH265LevelIdc_STD_VIDEO_H265_LEVEL_IDC_4_0: StdVideoH265LevelIdc = 5;
pub const StdVideoH265LevelIdc_STD_VIDEO_H265_LEVEL_IDC_4_1: StdVideoH265LevelIdc = 6;
pub const StdVideoH265LevelIdc_STD_VIDEO_H265_LEVEL_IDC_5_0: StdVideoH265LevelIdc = 7;
pub const StdVideoH265LevelIdc_STD_VIDEO_H265_LEVEL_IDC_5_1: StdVideoH265LevelIdc = 8;
pub const StdVideoH265LevelIdc_STD_VIDEO_H265_LEVEL_IDC_5_2: StdVideoH265LevelIdc = 9;
pub const StdVideoH265LevelIdc_STD_VIDEO_H265_LEVEL_IDC_6_0: StdVideoH265LevelIdc = 10;
pub const StdVideoH265LevelIdc_STD_VIDEO_H265_LEVEL_IDC_6_1: StdVideoH265LevelIdc = 11;
pub const StdVideoH265LevelIdc_STD_VIDEO_H265_LEVEL_IDC_6_2: StdVideoH265LevelIdc = 12;
pub const StdVideoH265LevelIdc_STD_VIDEO_H265_LEVEL_IDC_INVALID: StdVideoH265LevelIdc = 2147483647;
pub type StdVideoH265LevelIdc = ::core::ffi::c_uint;
pub const StdVideoH265SliceType_STD_VIDEO_H265_SLICE_TYPE_B: StdVideoH265SliceType = 0;
pub const StdVideoH265SliceType_STD_VIDEO_H265_SLICE_TYPE_P: StdVideoH265SliceType = 1;
pub const StdVideoH265SliceType_STD_VIDEO_H265_SLICE_TYPE_I: StdVideoH265SliceType = 2;
pub const StdVideoH265SliceType_STD_VIDEO_H265_SLICE_TYPE_INVALID: StdVideoH265SliceType =
    2147483647;
pub type StdVideoH265SliceType = ::core::ffi::c_uint;
pub const StdVideoH265PictureType_STD_VIDEO_H265_PICTURE_TYPE_P: StdVideoH265PictureType = 0;
pub const StdVideoH265PictureType_STD_VIDEO_H265_PICTURE_TYPE_B: StdVideoH265PictureType = 1;
pub const StdVideoH265PictureType_STD_VIDEO_H265_PICTURE_TYPE_I: StdVideoH265PictureType = 2;
pub const StdVideoH265PictureType_STD_VIDEO_H265_PICTURE_TYPE_IDR: StdVideoH265PictureType = 3;
pub const StdVideoH265PictureType_STD_VIDEO_H265_PICTURE_TYPE_INVALID: StdVideoH265PictureType =
    2147483647;
pub type StdVideoH265PictureType = ::core::ffi::c_uint;
pub const StdVideoH265AspectRatioIdc_STD_VIDEO_H265_ASPECT_RATIO_IDC_UNSPECIFIED:
    StdVideoH265AspectRatioIdc = 0;
pub const StdVideoH265AspectRatioIdc_STD_VIDEO_H265_ASPECT_RATIO_IDC_SQUARE:
    StdVideoH265AspectRatioIdc = 1;
pub const StdVideoH265AspectRatioIdc_STD_VIDEO_H265_ASPECT_RATIO_IDC_12_11:
    StdVideoH265AspectRatioIdc = 2;
pub const StdVideoH265AspectRatioIdc_STD_VIDEO_H265_ASPECT_RATIO_IDC_10_11:
    StdVideoH265AspectRatioIdc = 3;
pub const StdVideoH265AspectRatioIdc_STD_VIDEO_H265_ASPECT_RATIO_IDC_16_11:
    StdVideoH265AspectRatioIdc = 4;
pub const StdVideoH265AspectRatioIdc_STD_VIDEO_H265_ASPECT_RATIO_IDC_40_33:
    StdVideoH265AspectRatioIdc = 5;
pub const StdVideoH265AspectRatioIdc_STD_VIDEO_H265_ASPECT_RATIO_IDC_24_11:
    StdVideoH265AspectRatioIdc = 6;
pub const StdVideoH265AspectRatioIdc_STD_VIDEO_H265_ASPECT_RATIO_IDC_20_11:
    StdVideoH265AspectRatioIdc = 7;
pub const StdVideoH265AspectRatioIdc_STD_VIDEO_H265_ASPECT_RATIO_IDC_32_11:
    StdVideoH265AspectRatioIdc = 8;
pub const StdVideoH265AspectRatioIdc_STD_VIDEO_H265_ASPECT_RATIO_IDC_80_33:
    StdVideoH265AspectRatioIdc = 9;
pub const StdVideoH265AspectRatioIdc_STD_VIDEO_H265_ASPECT_RATIO_IDC_18_11:
    StdVideoH265AspectRatioIdc = 10;
pub const StdVideoH265AspectRatioIdc_STD_VIDEO_H265_ASPECT_RATIO_IDC_15_11:
    StdVideoH265AspectRatioIdc = 11;
pub const StdVideoH265AspectRatioIdc_STD_VIDEO_H265_ASPECT_RATIO_IDC_64_33:
    StdVideoH265AspectRatioIdc = 12;
pub const StdVideoH265AspectRatioIdc_STD_VIDEO_H265_ASPECT_RATIO_IDC_160_99:
    StdVideoH265AspectRatioIdc = 13;
pub const StdVideoH265AspectRatioIdc_STD_VIDEO_H265_ASPECT_RATIO_IDC_4_3:
    StdVideoH265AspectRatioIdc = 14;
pub const StdVideoH265AspectRatioIdc_STD_VIDEO_H265_ASPECT_RATIO_IDC_3_2:
    StdVideoH265AspectRatioIdc = 15;
pub const StdVideoH265AspectRatioIdc_STD_VIDEO_H265_ASPECT_RATIO_IDC_2_1:
    StdVideoH265AspectRatioIdc = 16;
pub const StdVideoH265AspectRatioIdc_STD_VIDEO_H265_ASPECT_RATIO_IDC_EXTENDED_SAR:
    StdVideoH265AspectRatioIdc = 255;
pub const StdVideoH265AspectRatioIdc_STD_VIDEO_H265_ASPECT_RATIO_IDC_INVALID:
    StdVideoH265AspectRatioIdc = 2147483647;
pub type StdVideoH265AspectRatioIdc = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265DecPicBufMgr {
    pub max_latency_increase_plus1: [u32; 7usize],
    pub max_dec_pic_buffering_minus1: [u8; 7usize],
    pub max_num_reorder_pics: [u8; 7usize],
}
#[test]
fn bindgen_test_layout_StdVideoH265DecPicBufMgr() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoH265DecPicBufMgr> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoH265DecPicBufMgr>(),
        44usize,
        concat!("Size of: ", stringify!(StdVideoH265DecPicBufMgr))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoH265DecPicBufMgr>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoH265DecPicBufMgr))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).max_latency_increase_plus1) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265DecPicBufMgr),
            "::",
            stringify!(max_latency_increase_plus1)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).max_dec_pic_buffering_minus1) as usize - ptr as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265DecPicBufMgr),
            "::",
            stringify!(max_dec_pic_buffering_minus1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).max_num_reorder_pics) as usize - ptr as usize },
        35usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265DecPicBufMgr),
            "::",
            stringify!(max_num_reorder_pics)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265SubLayerHrdParameters {
    pub bit_rate_value_minus1: [u32; 32usize],
    pub cpb_size_value_minus1: [u32; 32usize],
    pub cpb_size_du_value_minus1: [u32; 32usize],
    pub bit_rate_du_value_minus1: [u32; 32usize],
    pub cbr_flag: u32,
}
#[test]
fn bindgen_test_layout_StdVideoH265SubLayerHrdParameters() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoH265SubLayerHrdParameters> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoH265SubLayerHrdParameters>(),
        516usize,
        concat!("Size of: ", stringify!(StdVideoH265SubLayerHrdParameters))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoH265SubLayerHrdParameters>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoH265SubLayerHrdParameters)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).bit_rate_value_minus1) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SubLayerHrdParameters),
            "::",
            stringify!(bit_rate_value_minus1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cpb_size_value_minus1) as usize - ptr as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SubLayerHrdParameters),
            "::",
            stringify!(cpb_size_value_minus1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cpb_size_du_value_minus1) as usize - ptr as usize },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SubLayerHrdParameters),
            "::",
            stringify!(cpb_size_du_value_minus1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).bit_rate_du_value_minus1) as usize - ptr as usize },
        384usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SubLayerHrdParameters),
            "::",
            stringify!(bit_rate_du_value_minus1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cbr_flag) as usize - ptr as usize },
        512usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SubLayerHrdParameters),
            "::",
            stringify!(cbr_flag)
        )
    );
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265HrdFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_StdVideoH265HrdFlags() {
    assert_eq!(
        ::core::mem::size_of::<StdVideoH265HrdFlags>(),
        4usize,
        concat!("Size of: ", stringify!(StdVideoH265HrdFlags))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoH265HrdFlags>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoH265HrdFlags))
    );
}
impl StdVideoH265HrdFlags {
    #[inline]
    pub fn nal_hrd_parameters_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_nal_hrd_parameters_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn vcl_hrd_parameters_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_vcl_hrd_parameters_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sub_pic_hrd_params_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sub_pic_hrd_params_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sub_pic_cpb_params_in_pic_timing_sei_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sub_pic_cpb_params_in_pic_timing_sei_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fixed_pic_rate_general_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(4usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_fixed_pic_rate_general_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(4usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn fixed_pic_rate_within_cvs_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(12usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_fixed_pic_rate_within_cvs_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(12usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn low_delay_hrd_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(20usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_low_delay_hrd_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(20usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        nal_hrd_parameters_present_flag: u32,
        vcl_hrd_parameters_present_flag: u32,
        sub_pic_hrd_params_present_flag: u32,
        sub_pic_cpb_params_in_pic_timing_sei_flag: u32,
        fixed_pic_rate_general_flag: u32,
        fixed_pic_rate_within_cvs_flag: u32,
        low_delay_hrd_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let nal_hrd_parameters_present_flag: u32 =
                unsafe { ::core::mem::transmute(nal_hrd_parameters_present_flag) };
            nal_hrd_parameters_present_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let vcl_hrd_parameters_present_flag: u32 =
                unsafe { ::core::mem::transmute(vcl_hrd_parameters_present_flag) };
            vcl_hrd_parameters_present_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let sub_pic_hrd_params_present_flag: u32 =
                unsafe { ::core::mem::transmute(sub_pic_hrd_params_present_flag) };
            sub_pic_hrd_params_present_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let sub_pic_cpb_params_in_pic_timing_sei_flag: u32 =
                unsafe { ::core::mem::transmute(sub_pic_cpb_params_in_pic_timing_sei_flag) };
            sub_pic_cpb_params_in_pic_timing_sei_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 8u8, {
            let fixed_pic_rate_general_flag: u32 =
                unsafe { ::core::mem::transmute(fixed_pic_rate_general_flag) };
            fixed_pic_rate_general_flag as u64
        });
        __bindgen_bitfield_unit.set(12usize, 8u8, {
            let fixed_pic_rate_within_cvs_flag: u32 =
                unsafe { ::core::mem::transmute(fixed_pic_rate_within_cvs_flag) };
            fixed_pic_rate_within_cvs_flag as u64
        });
        __bindgen_bitfield_unit.set(20usize, 8u8, {
            let low_delay_hrd_flag: u32 = unsafe { ::core::mem::transmute(low_delay_hrd_flag) };
            low_delay_hrd_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265HrdParameters {
    pub flags: StdVideoH265HrdFlags,
    pub tick_divisor_minus2: u8,
    pub du_cpb_removal_delay_increment_length_minus1: u8,
    pub dpb_output_delay_du_length_minus1: u8,
    pub bit_rate_scale: u8,
    pub cpb_size_scale: u8,
    pub cpb_size_du_scale: u8,
    pub initial_cpb_removal_delay_length_minus1: u8,
    pub au_cpb_removal_delay_length_minus1: u8,
    pub dpb_output_delay_length_minus1: u8,
    pub cpb_cnt_minus1: [u8; 7usize],
    pub elemental_duration_in_tc_minus1: [u16; 7usize],
    pub reserved: [u16; 3usize],
    pub pSubLayerHrdParametersNal: *const StdVideoH265SubLayerHrdParameters,
    pub pSubLayerHrdParametersVcl: *const StdVideoH265SubLayerHrdParameters,
}
#[test]
fn bindgen_test_layout_StdVideoH265HrdParameters() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoH265HrdParameters> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoH265HrdParameters>(),
        56usize,
        concat!("Size of: ", stringify!(StdVideoH265HrdParameters))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoH265HrdParameters>(),
        8usize,
        concat!("Alignment of ", stringify!(StdVideoH265HrdParameters))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265HrdParameters),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).tick_divisor_minus2) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265HrdParameters),
            "::",
            stringify!(tick_divisor_minus2)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).du_cpb_removal_delay_increment_length_minus1) as usize
                - ptr as usize
        },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265HrdParameters),
            "::",
            stringify!(du_cpb_removal_delay_increment_length_minus1)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).dpb_output_delay_du_length_minus1) as usize - ptr as usize
        },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265HrdParameters),
            "::",
            stringify!(dpb_output_delay_du_length_minus1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).bit_rate_scale) as usize - ptr as usize },
        7usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265HrdParameters),
            "::",
            stringify!(bit_rate_scale)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cpb_size_scale) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265HrdParameters),
            "::",
            stringify!(cpb_size_scale)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cpb_size_du_scale) as usize - ptr as usize },
        9usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265HrdParameters),
            "::",
            stringify!(cpb_size_du_scale)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).initial_cpb_removal_delay_length_minus1) as usize
                - ptr as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265HrdParameters),
            "::",
            stringify!(initial_cpb_removal_delay_length_minus1)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).au_cpb_removal_delay_length_minus1) as usize - ptr as usize
        },
        11usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265HrdParameters),
            "::",
            stringify!(au_cpb_removal_delay_length_minus1)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).dpb_output_delay_length_minus1) as usize - ptr as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265HrdParameters),
            "::",
            stringify!(dpb_output_delay_length_minus1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cpb_cnt_minus1) as usize - ptr as usize },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265HrdParameters),
            "::",
            stringify!(cpb_cnt_minus1)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).elemental_duration_in_tc_minus1) as usize - ptr as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265HrdParameters),
            "::",
            stringify!(elemental_duration_in_tc_minus1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved) as usize - ptr as usize },
        34usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265HrdParameters),
            "::",
            stringify!(reserved)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pSubLayerHrdParametersNal) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265HrdParameters),
            "::",
            stringify!(pSubLayerHrdParametersNal)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pSubLayerHrdParametersVcl) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265HrdParameters),
            "::",
            stringify!(pSubLayerHrdParametersVcl)
        )
    );
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265VpsFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[test]
fn bindgen_test_layout_StdVideoH265VpsFlags() {
    assert_eq!(
        ::core::mem::size_of::<StdVideoH265VpsFlags>(),
        4usize,
        concat!("Size of: ", stringify!(StdVideoH265VpsFlags))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoH265VpsFlags>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoH265VpsFlags))
    );
}
impl StdVideoH265VpsFlags {
    #[inline]
    pub fn vps_temporal_id_nesting_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_vps_temporal_id_nesting_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn vps_sub_layer_ordering_info_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_vps_sub_layer_ordering_info_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn vps_timing_info_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_vps_timing_info_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn vps_poc_proportional_to_timing_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_vps_poc_proportional_to_timing_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        vps_temporal_id_nesting_flag: u32,
        vps_sub_layer_ordering_info_present_flag: u32,
        vps_timing_info_present_flag: u32,
        vps_poc_proportional_to_timing_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let vps_temporal_id_nesting_flag: u32 =
                unsafe { ::core::mem::transmute(vps_temporal_id_nesting_flag) };
            vps_temporal_id_nesting_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let vps_sub_layer_ordering_info_present_flag: u32 =
                unsafe { ::core::mem::transmute(vps_sub_layer_ordering_info_present_flag) };
            vps_sub_layer_ordering_info_present_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let vps_timing_info_present_flag: u32 =
                unsafe { ::core::mem::transmute(vps_timing_info_present_flag) };
            vps_timing_info_present_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let vps_poc_proportional_to_timing_flag: u32 =
                unsafe { ::core::mem::transmute(vps_poc_proportional_to_timing_flag) };
            vps_poc_proportional_to_timing_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265ProfileTierLevelFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[test]
fn bindgen_test_layout_StdVideoH265ProfileTierLevelFlags() {
    assert_eq!(
        ::core::mem::size_of::<StdVideoH265ProfileTierLevelFlags>(),
        4usize,
        concat!("Size of: ", stringify!(StdVideoH265ProfileTierLevelFlags))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoH265ProfileTierLevelFlags>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoH265ProfileTierLevelFlags)
        )
    );
}
impl StdVideoH265ProfileTierLevelFlags {
    #[inline]
    pub fn general_tier_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_general_tier_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn general_progressive_source_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_general_progressive_source_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn general_interlaced_source_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_general_interlaced_source_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn general_non_packed_constraint_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_general_non_packed_constraint_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn general_frame_only_constraint_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_general_frame_only_constraint_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        general_tier_flag: u32,
        general_progressive_source_flag: u32,
        general_interlaced_source_flag: u32,
        general_non_packed_constraint_flag: u32,
        general_frame_only_constraint_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let general_tier_flag: u32 = unsafe { ::core::mem::transmute(general_tier_flag) };
            general_tier_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let general_progressive_source_flag: u32 =
                unsafe { ::core::mem::transmute(general_progressive_source_flag) };
            general_progressive_source_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let general_interlaced_source_flag: u32 =
                unsafe { ::core::mem::transmute(general_interlaced_source_flag) };
            general_interlaced_source_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let general_non_packed_constraint_flag: u32 =
                unsafe { ::core::mem::transmute(general_non_packed_constraint_flag) };
            general_non_packed_constraint_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let general_frame_only_constraint_flag: u32 =
                unsafe { ::core::mem::transmute(general_frame_only_constraint_flag) };
            general_frame_only_constraint_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265ProfileTierLevel {
    pub flags: StdVideoH265ProfileTierLevelFlags,
    pub general_profile_idc: StdVideoH265ProfileIdc,
    pub general_level_idc: StdVideoH265LevelIdc,
}
#[test]
fn bindgen_test_layout_StdVideoH265ProfileTierLevel() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoH265ProfileTierLevel> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoH265ProfileTierLevel>(),
        12usize,
        concat!("Size of: ", stringify!(StdVideoH265ProfileTierLevel))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoH265ProfileTierLevel>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoH265ProfileTierLevel))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265ProfileTierLevel),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).general_profile_idc) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265ProfileTierLevel),
            "::",
            stringify!(general_profile_idc)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).general_level_idc) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265ProfileTierLevel),
            "::",
            stringify!(general_level_idc)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265VideoParameterSet {
    pub flags: StdVideoH265VpsFlags,
    pub vps_video_parameter_set_id: u8,
    pub vps_max_sub_layers_minus1: u8,
    pub reserved1: u8,
    pub reserved2: u8,
    pub vps_num_units_in_tick: u32,
    pub vps_time_scale: u32,
    pub vps_num_ticks_poc_diff_one_minus1: u32,
    pub reserved3: u32,
    pub pDecPicBufMgr: *const StdVideoH265DecPicBufMgr,
    pub pHrdParameters: *const StdVideoH265HrdParameters,
    pub pProfileTierLevel: *const StdVideoH265ProfileTierLevel,
}
#[test]
fn bindgen_test_layout_StdVideoH265VideoParameterSet() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoH265VideoParameterSet> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoH265VideoParameterSet>(),
        48usize,
        concat!("Size of: ", stringify!(StdVideoH265VideoParameterSet))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoH265VideoParameterSet>(),
        8usize,
        concat!("Alignment of ", stringify!(StdVideoH265VideoParameterSet))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265VideoParameterSet),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vps_video_parameter_set_id) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265VideoParameterSet),
            "::",
            stringify!(vps_video_parameter_set_id)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vps_max_sub_layers_minus1) as usize - ptr as usize },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265VideoParameterSet),
            "::",
            stringify!(vps_max_sub_layers_minus1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved1) as usize - ptr as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265VideoParameterSet),
            "::",
            stringify!(reserved1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved2) as usize - ptr as usize },
        7usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265VideoParameterSet),
            "::",
            stringify!(reserved2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vps_num_units_in_tick) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265VideoParameterSet),
            "::",
            stringify!(vps_num_units_in_tick)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vps_time_scale) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265VideoParameterSet),
            "::",
            stringify!(vps_time_scale)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).vps_num_ticks_poc_diff_one_minus1) as usize - ptr as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265VideoParameterSet),
            "::",
            stringify!(vps_num_ticks_poc_diff_one_minus1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved3) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265VideoParameterSet),
            "::",
            stringify!(reserved3)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pDecPicBufMgr) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265VideoParameterSet),
            "::",
            stringify!(pDecPicBufMgr)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pHrdParameters) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265VideoParameterSet),
            "::",
            stringify!(pHrdParameters)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pProfileTierLevel) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265VideoParameterSet),
            "::",
            stringify!(pProfileTierLevel)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265ScalingLists {
    pub ScalingList4x4: [[u8; 16usize]; 6usize],
    pub ScalingList8x8: [[u8; 64usize]; 6usize],
    pub ScalingList16x16: [[u8; 64usize]; 6usize],
    pub ScalingList32x32: [[u8; 64usize]; 2usize],
    pub ScalingListDCCoef16x16: [u8; 6usize],
    pub ScalingListDCCoef32x32: [u8; 2usize],
}
#[test]
fn bindgen_test_layout_StdVideoH265ScalingLists() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoH265ScalingLists> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoH265ScalingLists>(),
        1000usize,
        concat!("Size of: ", stringify!(StdVideoH265ScalingLists))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoH265ScalingLists>(),
        1usize,
        concat!("Alignment of ", stringify!(StdVideoH265ScalingLists))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ScalingList4x4) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265ScalingLists),
            "::",
            stringify!(ScalingList4x4)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ScalingList8x8) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265ScalingLists),
            "::",
            stringify!(ScalingList8x8)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ScalingList16x16) as usize - ptr as usize },
        480usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265ScalingLists),
            "::",
            stringify!(ScalingList16x16)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ScalingList32x32) as usize - ptr as usize },
        864usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265ScalingLists),
            "::",
            stringify!(ScalingList32x32)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ScalingListDCCoef16x16) as usize - ptr as usize },
        992usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265ScalingLists),
            "::",
            stringify!(ScalingListDCCoef16x16)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ScalingListDCCoef32x32) as usize - ptr as usize },
        998usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265ScalingLists),
            "::",
            stringify!(ScalingListDCCoef32x32)
        )
    );
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265SpsVuiFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 3usize]>,
    pub __bindgen_padding_0: u8,
}
#[test]
fn bindgen_test_layout_StdVideoH265SpsVuiFlags() {
    assert_eq!(
        ::core::mem::size_of::<StdVideoH265SpsVuiFlags>(),
        4usize,
        concat!("Size of: ", stringify!(StdVideoH265SpsVuiFlags))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoH265SpsVuiFlags>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoH265SpsVuiFlags))
    );
}
impl StdVideoH265SpsVuiFlags {
    #[inline]
    pub fn aspect_ratio_info_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_aspect_ratio_info_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn overscan_info_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_overscan_info_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn overscan_appropriate_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_overscan_appropriate_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn video_signal_type_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_video_signal_type_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn video_full_range_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_video_full_range_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn colour_description_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_colour_description_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn chroma_loc_info_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_chroma_loc_info_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn neutral_chroma_indication_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_neutral_chroma_indication_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn field_seq_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_field_seq_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn frame_field_info_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_frame_field_info_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn default_display_window_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_default_display_window_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn vui_timing_info_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_vui_timing_info_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn vui_poc_proportional_to_timing_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_vui_poc_proportional_to_timing_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn vui_hrd_parameters_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_vui_hrd_parameters_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn bitstream_restriction_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_bitstream_restriction_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn tiles_fixed_structure_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_tiles_fixed_structure_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn motion_vectors_over_pic_boundaries_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_motion_vectors_over_pic_boundaries_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn restricted_ref_pic_lists_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(17usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_restricted_ref_pic_lists_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(17usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        aspect_ratio_info_present_flag: u32,
        overscan_info_present_flag: u32,
        overscan_appropriate_flag: u32,
        video_signal_type_present_flag: u32,
        video_full_range_flag: u32,
        colour_description_present_flag: u32,
        chroma_loc_info_present_flag: u32,
        neutral_chroma_indication_flag: u32,
        field_seq_flag: u32,
        frame_field_info_present_flag: u32,
        default_display_window_flag: u32,
        vui_timing_info_present_flag: u32,
        vui_poc_proportional_to_timing_flag: u32,
        vui_hrd_parameters_present_flag: u32,
        bitstream_restriction_flag: u32,
        tiles_fixed_structure_flag: u32,
        motion_vectors_over_pic_boundaries_flag: u32,
        restricted_ref_pic_lists_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 3usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 3usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let aspect_ratio_info_present_flag: u32 =
                unsafe { ::core::mem::transmute(aspect_ratio_info_present_flag) };
            aspect_ratio_info_present_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let overscan_info_present_flag: u32 =
                unsafe { ::core::mem::transmute(overscan_info_present_flag) };
            overscan_info_present_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let overscan_appropriate_flag: u32 =
                unsafe { ::core::mem::transmute(overscan_appropriate_flag) };
            overscan_appropriate_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let video_signal_type_present_flag: u32 =
                unsafe { ::core::mem::transmute(video_signal_type_present_flag) };
            video_signal_type_present_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let video_full_range_flag: u32 =
                unsafe { ::core::mem::transmute(video_full_range_flag) };
            video_full_range_flag as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let colour_description_present_flag: u32 =
                unsafe { ::core::mem::transmute(colour_description_present_flag) };
            colour_description_present_flag as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let chroma_loc_info_present_flag: u32 =
                unsafe { ::core::mem::transmute(chroma_loc_info_present_flag) };
            chroma_loc_info_present_flag as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let neutral_chroma_indication_flag: u32 =
                unsafe { ::core::mem::transmute(neutral_chroma_indication_flag) };
            neutral_chroma_indication_flag as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let field_seq_flag: u32 = unsafe { ::core::mem::transmute(field_seq_flag) };
            field_seq_flag as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let frame_field_info_present_flag: u32 =
                unsafe { ::core::mem::transmute(frame_field_info_present_flag) };
            frame_field_info_present_flag as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let default_display_window_flag: u32 =
                unsafe { ::core::mem::transmute(default_display_window_flag) };
            default_display_window_flag as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let vui_timing_info_present_flag: u32 =
                unsafe { ::core::mem::transmute(vui_timing_info_present_flag) };
            vui_timing_info_present_flag as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let vui_poc_proportional_to_timing_flag: u32 =
                unsafe { ::core::mem::transmute(vui_poc_proportional_to_timing_flag) };
            vui_poc_proportional_to_timing_flag as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let vui_hrd_parameters_present_flag: u32 =
                unsafe { ::core::mem::transmute(vui_hrd_parameters_present_flag) };
            vui_hrd_parameters_present_flag as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let bitstream_restriction_flag: u32 =
                unsafe { ::core::mem::transmute(bitstream_restriction_flag) };
            bitstream_restriction_flag as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let tiles_fixed_structure_flag: u32 =
                unsafe { ::core::mem::transmute(tiles_fixed_structure_flag) };
            tiles_fixed_structure_flag as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let motion_vectors_over_pic_boundaries_flag: u32 =
                unsafe { ::core::mem::transmute(motion_vectors_over_pic_boundaries_flag) };
            motion_vectors_over_pic_boundaries_flag as u64
        });
        __bindgen_bitfield_unit.set(17usize, 1u8, {
            let restricted_ref_pic_lists_flag: u32 =
                unsafe { ::core::mem::transmute(restricted_ref_pic_lists_flag) };
            restricted_ref_pic_lists_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265SequenceParameterSetVui {
    pub flags: StdVideoH265SpsVuiFlags,
    pub aspect_ratio_idc: StdVideoH265AspectRatioIdc,
    pub sar_width: u16,
    pub sar_height: u16,
    pub video_format: u8,
    pub colour_primaries: u8,
    pub transfer_characteristics: u8,
    pub matrix_coeffs: u8,
    pub chroma_sample_loc_type_top_field: u8,
    pub chroma_sample_loc_type_bottom_field: u8,
    pub reserved1: u8,
    pub reserved2: u8,
    pub def_disp_win_left_offset: u16,
    pub def_disp_win_right_offset: u16,
    pub def_disp_win_top_offset: u16,
    pub def_disp_win_bottom_offset: u16,
    pub vui_num_units_in_tick: u32,
    pub vui_time_scale: u32,
    pub vui_num_ticks_poc_diff_one_minus1: u32,
    pub min_spatial_segmentation_idc: u16,
    pub reserved3: u16,
    pub max_bytes_per_pic_denom: u8,
    pub max_bits_per_min_cu_denom: u8,
    pub log2_max_mv_length_horizontal: u8,
    pub log2_max_mv_length_vertical: u8,
    pub pHrdParameters: *const StdVideoH265HrdParameters,
}
#[test]
fn bindgen_test_layout_StdVideoH265SequenceParameterSetVui() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoH265SequenceParameterSetVui> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoH265SequenceParameterSetVui>(),
        56usize,
        concat!("Size of: ", stringify!(StdVideoH265SequenceParameterSetVui))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoH265SequenceParameterSetVui>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoH265SequenceParameterSetVui)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).aspect_ratio_idc) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(aspect_ratio_idc)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).sar_width) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(sar_width)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).sar_height) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(sar_height)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).video_format) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(video_format)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).colour_primaries) as usize - ptr as usize },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(colour_primaries)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).transfer_characteristics) as usize - ptr as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(transfer_characteristics)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).matrix_coeffs) as usize - ptr as usize },
        15usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(matrix_coeffs)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).chroma_sample_loc_type_top_field) as usize - ptr as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(chroma_sample_loc_type_top_field)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).chroma_sample_loc_type_bottom_field) as usize
                - ptr as usize
        },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(chroma_sample_loc_type_bottom_field)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved1) as usize - ptr as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(reserved1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved2) as usize - ptr as usize },
        19usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(reserved2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).def_disp_win_left_offset) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(def_disp_win_left_offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).def_disp_win_right_offset) as usize - ptr as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(def_disp_win_right_offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).def_disp_win_top_offset) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(def_disp_win_top_offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).def_disp_win_bottom_offset) as usize - ptr as usize },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(def_disp_win_bottom_offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vui_num_units_in_tick) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(vui_num_units_in_tick)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vui_time_scale) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(vui_time_scale)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).vui_num_ticks_poc_diff_one_minus1) as usize - ptr as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(vui_num_ticks_poc_diff_one_minus1)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).min_spatial_segmentation_idc) as usize - ptr as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(min_spatial_segmentation_idc)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved3) as usize - ptr as usize },
        42usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(reserved3)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).max_bytes_per_pic_denom) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(max_bytes_per_pic_denom)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).max_bits_per_min_cu_denom) as usize - ptr as usize },
        45usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(max_bits_per_min_cu_denom)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).log2_max_mv_length_horizontal) as usize - ptr as usize
        },
        46usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(log2_max_mv_length_horizontal)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).log2_max_mv_length_vertical) as usize - ptr as usize
        },
        47usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(log2_max_mv_length_vertical)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pHrdParameters) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(pHrdParameters)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265PredictorPaletteEntries {
    pub PredictorPaletteEntries: [[u16; 128usize]; 3usize],
}
#[test]
fn bindgen_test_layout_StdVideoH265PredictorPaletteEntries() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoH265PredictorPaletteEntries> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoH265PredictorPaletteEntries>(),
        768usize,
        concat!("Size of: ", stringify!(StdVideoH265PredictorPaletteEntries))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoH265PredictorPaletteEntries>(),
        2usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoH265PredictorPaletteEntries)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).PredictorPaletteEntries) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PredictorPaletteEntries),
            "::",
            stringify!(PredictorPaletteEntries)
        )
    );
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265SpsFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_StdVideoH265SpsFlags() {
    assert_eq!(
        ::core::mem::size_of::<StdVideoH265SpsFlags>(),
        4usize,
        concat!("Size of: ", stringify!(StdVideoH265SpsFlags))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoH265SpsFlags>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoH265SpsFlags))
    );
}
impl StdVideoH265SpsFlags {
    #[inline]
    pub fn sps_temporal_id_nesting_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sps_temporal_id_nesting_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn separate_colour_plane_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_separate_colour_plane_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn conformance_window_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_conformance_window_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sps_sub_layer_ordering_info_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sps_sub_layer_ordering_info_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn scaling_list_enabled_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_scaling_list_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sps_scaling_list_data_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sps_scaling_list_data_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn amp_enabled_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_amp_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sample_adaptive_offset_enabled_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sample_adaptive_offset_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pcm_enabled_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pcm_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pcm_loop_filter_disabled_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pcm_loop_filter_disabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn long_term_ref_pics_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_long_term_ref_pics_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sps_temporal_mvp_enabled_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sps_temporal_mvp_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn strong_intra_smoothing_enabled_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_strong_intra_smoothing_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn vui_parameters_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_vui_parameters_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sps_extension_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sps_extension_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sps_range_extension_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sps_range_extension_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn transform_skip_rotation_enabled_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_transform_skip_rotation_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn transform_skip_context_enabled_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(17usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_transform_skip_context_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(17usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn implicit_rdpcm_enabled_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(18usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_implicit_rdpcm_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(18usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn explicit_rdpcm_enabled_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(19usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_explicit_rdpcm_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(19usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn extended_precision_processing_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(20usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_extended_precision_processing_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(20usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn intra_smoothing_disabled_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(21usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_intra_smoothing_disabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(21usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn high_precision_offsets_enabled_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(22usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_high_precision_offsets_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(22usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn persistent_rice_adaptation_enabled_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(23usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_persistent_rice_adaptation_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(23usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cabac_bypass_alignment_enabled_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cabac_bypass_alignment_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sps_scc_extension_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(25usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sps_scc_extension_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(25usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sps_curr_pic_ref_enabled_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(26usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sps_curr_pic_ref_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(26usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn palette_mode_enabled_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(27usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_palette_mode_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(27usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sps_palette_predictor_initializers_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(28usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sps_palette_predictor_initializers_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(28usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn intra_boundary_filtering_disabled_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(29usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_intra_boundary_filtering_disabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(29usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        sps_temporal_id_nesting_flag: u32,
        separate_colour_plane_flag: u32,
        conformance_window_flag: u32,
        sps_sub_layer_ordering_info_present_flag: u32,
        scaling_list_enabled_flag: u32,
        sps_scaling_list_data_present_flag: u32,
        amp_enabled_flag: u32,
        sample_adaptive_offset_enabled_flag: u32,
        pcm_enabled_flag: u32,
        pcm_loop_filter_disabled_flag: u32,
        long_term_ref_pics_present_flag: u32,
        sps_temporal_mvp_enabled_flag: u32,
        strong_intra_smoothing_enabled_flag: u32,
        vui_parameters_present_flag: u32,
        sps_extension_present_flag: u32,
        sps_range_extension_flag: u32,
        transform_skip_rotation_enabled_flag: u32,
        transform_skip_context_enabled_flag: u32,
        implicit_rdpcm_enabled_flag: u32,
        explicit_rdpcm_enabled_flag: u32,
        extended_precision_processing_flag: u32,
        intra_smoothing_disabled_flag: u32,
        high_precision_offsets_enabled_flag: u32,
        persistent_rice_adaptation_enabled_flag: u32,
        cabac_bypass_alignment_enabled_flag: u32,
        sps_scc_extension_flag: u32,
        sps_curr_pic_ref_enabled_flag: u32,
        palette_mode_enabled_flag: u32,
        sps_palette_predictor_initializers_present_flag: u32,
        intra_boundary_filtering_disabled_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let sps_temporal_id_nesting_flag: u32 =
                unsafe { ::core::mem::transmute(sps_temporal_id_nesting_flag) };
            sps_temporal_id_nesting_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let separate_colour_plane_flag: u32 =
                unsafe { ::core::mem::transmute(separate_colour_plane_flag) };
            separate_colour_plane_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let conformance_window_flag: u32 =
                unsafe { ::core::mem::transmute(conformance_window_flag) };
            conformance_window_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let sps_sub_layer_ordering_info_present_flag: u32 =
                unsafe { ::core::mem::transmute(sps_sub_layer_ordering_info_present_flag) };
            sps_sub_layer_ordering_info_present_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let scaling_list_enabled_flag: u32 =
                unsafe { ::core::mem::transmute(scaling_list_enabled_flag) };
            scaling_list_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let sps_scaling_list_data_present_flag: u32 =
                unsafe { ::core::mem::transmute(sps_scaling_list_data_present_flag) };
            sps_scaling_list_data_present_flag as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let amp_enabled_flag: u32 = unsafe { ::core::mem::transmute(amp_enabled_flag) };
            amp_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let sample_adaptive_offset_enabled_flag: u32 =
                unsafe { ::core::mem::transmute(sample_adaptive_offset_enabled_flag) };
            sample_adaptive_offset_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let pcm_enabled_flag: u32 = unsafe { ::core::mem::transmute(pcm_enabled_flag) };
            pcm_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let pcm_loop_filter_disabled_flag: u32 =
                unsafe { ::core::mem::transmute(pcm_loop_filter_disabled_flag) };
            pcm_loop_filter_disabled_flag as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let long_term_ref_pics_present_flag: u32 =
                unsafe { ::core::mem::transmute(long_term_ref_pics_present_flag) };
            long_term_ref_pics_present_flag as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let sps_temporal_mvp_enabled_flag: u32 =
                unsafe { ::core::mem::transmute(sps_temporal_mvp_enabled_flag) };
            sps_temporal_mvp_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let strong_intra_smoothing_enabled_flag: u32 =
                unsafe { ::core::mem::transmute(strong_intra_smoothing_enabled_flag) };
            strong_intra_smoothing_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let vui_parameters_present_flag: u32 =
                unsafe { ::core::mem::transmute(vui_parameters_present_flag) };
            vui_parameters_present_flag as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let sps_extension_present_flag: u32 =
                unsafe { ::core::mem::transmute(sps_extension_present_flag) };
            sps_extension_present_flag as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let sps_range_extension_flag: u32 =
                unsafe { ::core::mem::transmute(sps_range_extension_flag) };
            sps_range_extension_flag as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let transform_skip_rotation_enabled_flag: u32 =
                unsafe { ::core::mem::transmute(transform_skip_rotation_enabled_flag) };
            transform_skip_rotation_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(17usize, 1u8, {
            let transform_skip_context_enabled_flag: u32 =
                unsafe { ::core::mem::transmute(transform_skip_context_enabled_flag) };
            transform_skip_context_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(18usize, 1u8, {
            let implicit_rdpcm_enabled_flag: u32 =
                unsafe { ::core::mem::transmute(implicit_rdpcm_enabled_flag) };
            implicit_rdpcm_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(19usize, 1u8, {
            let explicit_rdpcm_enabled_flag: u32 =
                unsafe { ::core::mem::transmute(explicit_rdpcm_enabled_flag) };
            explicit_rdpcm_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(20usize, 1u8, {
            let extended_precision_processing_flag: u32 =
                unsafe { ::core::mem::transmute(extended_precision_processing_flag) };
            extended_precision_processing_flag as u64
        });
        __bindgen_bitfield_unit.set(21usize, 1u8, {
            let intra_smoothing_disabled_flag: u32 =
                unsafe { ::core::mem::transmute(intra_smoothing_disabled_flag) };
            intra_smoothing_disabled_flag as u64
        });
        __bindgen_bitfield_unit.set(22usize, 1u8, {
            let high_precision_offsets_enabled_flag: u32 =
                unsafe { ::core::mem::transmute(high_precision_offsets_enabled_flag) };
            high_precision_offsets_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(23usize, 1u8, {
            let persistent_rice_adaptation_enabled_flag: u32 =
                unsafe { ::core::mem::transmute(persistent_rice_adaptation_enabled_flag) };
            persistent_rice_adaptation_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(24usize, 1u8, {
            let cabac_bypass_alignment_enabled_flag: u32 =
                unsafe { ::core::mem::transmute(cabac_bypass_alignment_enabled_flag) };
            cabac_bypass_alignment_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(25usize, 1u8, {
            let sps_scc_extension_flag: u32 =
                unsafe { ::core::mem::transmute(sps_scc_extension_flag) };
            sps_scc_extension_flag as u64
        });
        __bindgen_bitfield_unit.set(26usize, 1u8, {
            let sps_curr_pic_ref_enabled_flag: u32 =
                unsafe { ::core::mem::transmute(sps_curr_pic_ref_enabled_flag) };
            sps_curr_pic_ref_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(27usize, 1u8, {
            let palette_mode_enabled_flag: u32 =
                unsafe { ::core::mem::transmute(palette_mode_enabled_flag) };
            palette_mode_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(28usize, 1u8, {
            let sps_palette_predictor_initializers_present_flag: u32 =
                unsafe { ::core::mem::transmute(sps_palette_predictor_initializers_present_flag) };
            sps_palette_predictor_initializers_present_flag as u64
        });
        __bindgen_bitfield_unit.set(29usize, 1u8, {
            let intra_boundary_filtering_disabled_flag: u32 =
                unsafe { ::core::mem::transmute(intra_boundary_filtering_disabled_flag) };
            intra_boundary_filtering_disabled_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265ShortTermRefPicSetFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[test]
fn bindgen_test_layout_StdVideoH265ShortTermRefPicSetFlags() {
    assert_eq!(
        ::core::mem::size_of::<StdVideoH265ShortTermRefPicSetFlags>(),
        4usize,
        concat!("Size of: ", stringify!(StdVideoH265ShortTermRefPicSetFlags))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoH265ShortTermRefPicSetFlags>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoH265ShortTermRefPicSetFlags)
        )
    );
}
impl StdVideoH265ShortTermRefPicSetFlags {
    #[inline]
    pub fn inter_ref_pic_set_prediction_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_inter_ref_pic_set_prediction_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn delta_rps_sign(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_delta_rps_sign(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        inter_ref_pic_set_prediction_flag: u32,
        delta_rps_sign: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let inter_ref_pic_set_prediction_flag: u32 =
                unsafe { ::core::mem::transmute(inter_ref_pic_set_prediction_flag) };
            inter_ref_pic_set_prediction_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let delta_rps_sign: u32 = unsafe { ::core::mem::transmute(delta_rps_sign) };
            delta_rps_sign as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265ShortTermRefPicSet {
    pub flags: StdVideoH265ShortTermRefPicSetFlags,
    pub delta_idx_minus1: u32,
    pub use_delta_flag: u16,
    pub abs_delta_rps_minus1: u16,
    pub used_by_curr_pic_flag: u16,
    pub used_by_curr_pic_s0_flag: u16,
    pub used_by_curr_pic_s1_flag: u16,
    pub reserved1: u16,
    pub reserved2: u8,
    pub reserved3: u8,
    pub num_negative_pics: u8,
    pub num_positive_pics: u8,
    pub delta_poc_s0_minus1: [u16; 16usize],
    pub delta_poc_s1_minus1: [u16; 16usize],
}
#[test]
fn bindgen_test_layout_StdVideoH265ShortTermRefPicSet() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoH265ShortTermRefPicSet> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoH265ShortTermRefPicSet>(),
        88usize,
        concat!("Size of: ", stringify!(StdVideoH265ShortTermRefPicSet))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoH265ShortTermRefPicSet>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoH265ShortTermRefPicSet))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265ShortTermRefPicSet),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).delta_idx_minus1) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265ShortTermRefPicSet),
            "::",
            stringify!(delta_idx_minus1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).use_delta_flag) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265ShortTermRefPicSet),
            "::",
            stringify!(use_delta_flag)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).abs_delta_rps_minus1) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265ShortTermRefPicSet),
            "::",
            stringify!(abs_delta_rps_minus1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).used_by_curr_pic_flag) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265ShortTermRefPicSet),
            "::",
            stringify!(used_by_curr_pic_flag)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).used_by_curr_pic_s0_flag) as usize - ptr as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265ShortTermRefPicSet),
            "::",
            stringify!(used_by_curr_pic_s0_flag)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).used_by_curr_pic_s1_flag) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265ShortTermRefPicSet),
            "::",
            stringify!(used_by_curr_pic_s1_flag)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved1) as usize - ptr as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265ShortTermRefPicSet),
            "::",
            stringify!(reserved1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved2) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265ShortTermRefPicSet),
            "::",
            stringify!(reserved2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved3) as usize - ptr as usize },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265ShortTermRefPicSet),
            "::",
            stringify!(reserved3)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).num_negative_pics) as usize - ptr as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265ShortTermRefPicSet),
            "::",
            stringify!(num_negative_pics)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).num_positive_pics) as usize - ptr as usize },
        23usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265ShortTermRefPicSet),
            "::",
            stringify!(num_positive_pics)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).delta_poc_s0_minus1) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265ShortTermRefPicSet),
            "::",
            stringify!(delta_poc_s0_minus1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).delta_poc_s1_minus1) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265ShortTermRefPicSet),
            "::",
            stringify!(delta_poc_s1_minus1)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265LongTermRefPicsSps {
    pub used_by_curr_pic_lt_sps_flag: u32,
    pub lt_ref_pic_poc_lsb_sps: [u32; 32usize],
}
#[test]
fn bindgen_test_layout_StdVideoH265LongTermRefPicsSps() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoH265LongTermRefPicsSps> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoH265LongTermRefPicsSps>(),
        132usize,
        concat!("Size of: ", stringify!(StdVideoH265LongTermRefPicsSps))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoH265LongTermRefPicsSps>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoH265LongTermRefPicsSps))
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).used_by_curr_pic_lt_sps_flag) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265LongTermRefPicsSps),
            "::",
            stringify!(used_by_curr_pic_lt_sps_flag)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).lt_ref_pic_poc_lsb_sps) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265LongTermRefPicsSps),
            "::",
            stringify!(lt_ref_pic_poc_lsb_sps)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265SequenceParameterSet {
    pub flags: StdVideoH265SpsFlags,
    pub chroma_format_idc: StdVideoH265ChromaFormatIdc,
    pub pic_width_in_luma_samples: u32,
    pub pic_height_in_luma_samples: u32,
    pub sps_video_parameter_set_id: u8,
    pub sps_max_sub_layers_minus1: u8,
    pub sps_seq_parameter_set_id: u8,
    pub bit_depth_luma_minus8: u8,
    pub bit_depth_chroma_minus8: u8,
    pub log2_max_pic_order_cnt_lsb_minus4: u8,
    pub log2_min_luma_coding_block_size_minus3: u8,
    pub log2_diff_max_min_luma_coding_block_size: u8,
    pub log2_min_luma_transform_block_size_minus2: u8,
    pub log2_diff_max_min_luma_transform_block_size: u8,
    pub max_transform_hierarchy_depth_inter: u8,
    pub max_transform_hierarchy_depth_intra: u8,
    pub num_short_term_ref_pic_sets: u8,
    pub num_long_term_ref_pics_sps: u8,
    pub pcm_sample_bit_depth_luma_minus1: u8,
    pub pcm_sample_bit_depth_chroma_minus1: u8,
    pub log2_min_pcm_luma_coding_block_size_minus3: u8,
    pub log2_diff_max_min_pcm_luma_coding_block_size: u8,
    pub reserved1: u8,
    pub reserved2: u8,
    pub palette_max_size: u8,
    pub delta_palette_max_predictor_size: u8,
    pub motion_vector_resolution_control_idc: u8,
    pub sps_num_palette_predictor_initializers_minus1: u8,
    pub conf_win_left_offset: u32,
    pub conf_win_right_offset: u32,
    pub conf_win_top_offset: u32,
    pub conf_win_bottom_offset: u32,
    pub pProfileTierLevel: *const StdVideoH265ProfileTierLevel,
    pub pDecPicBufMgr: *const StdVideoH265DecPicBufMgr,
    pub pScalingLists: *const StdVideoH265ScalingLists,
    pub pShortTermRefPicSet: *const StdVideoH265ShortTermRefPicSet,
    pub pLongTermRefPicsSps: *const StdVideoH265LongTermRefPicsSps,
    pub pSequenceParameterSetVui: *const StdVideoH265SequenceParameterSetVui,
    pub pPredictorPaletteEntries: *const StdVideoH265PredictorPaletteEntries,
}
#[test]
fn bindgen_test_layout_StdVideoH265SequenceParameterSet() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoH265SequenceParameterSet> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoH265SequenceParameterSet>(),
        112usize,
        concat!("Size of: ", stringify!(StdVideoH265SequenceParameterSet))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoH265SequenceParameterSet>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoH265SequenceParameterSet)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).chroma_format_idc) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(chroma_format_idc)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pic_width_in_luma_samples) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(pic_width_in_luma_samples)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pic_height_in_luma_samples) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(pic_height_in_luma_samples)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).sps_video_parameter_set_id) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(sps_video_parameter_set_id)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).sps_max_sub_layers_minus1) as usize - ptr as usize },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(sps_max_sub_layers_minus1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).sps_seq_parameter_set_id) as usize - ptr as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(sps_seq_parameter_set_id)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).bit_depth_luma_minus8) as usize - ptr as usize },
        19usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(bit_depth_luma_minus8)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).bit_depth_chroma_minus8) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(bit_depth_chroma_minus8)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).log2_max_pic_order_cnt_lsb_minus4) as usize - ptr as usize
        },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(log2_max_pic_order_cnt_lsb_minus4)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).log2_min_luma_coding_block_size_minus3) as usize
                - ptr as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(log2_min_luma_coding_block_size_minus3)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).log2_diff_max_min_luma_coding_block_size) as usize
                - ptr as usize
        },
        23usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(log2_diff_max_min_luma_coding_block_size)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).log2_min_luma_transform_block_size_minus2) as usize
                - ptr as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(log2_min_luma_transform_block_size_minus2)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).log2_diff_max_min_luma_transform_block_size) as usize
                - ptr as usize
        },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(log2_diff_max_min_luma_transform_block_size)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).max_transform_hierarchy_depth_inter) as usize
                - ptr as usize
        },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(max_transform_hierarchy_depth_inter)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).max_transform_hierarchy_depth_intra) as usize
                - ptr as usize
        },
        27usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(max_transform_hierarchy_depth_intra)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).num_short_term_ref_pic_sets) as usize - ptr as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(num_short_term_ref_pic_sets)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).num_long_term_ref_pics_sps) as usize - ptr as usize },
        29usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(num_long_term_ref_pics_sps)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).pcm_sample_bit_depth_luma_minus1) as usize - ptr as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(pcm_sample_bit_depth_luma_minus1)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).pcm_sample_bit_depth_chroma_minus1) as usize - ptr as usize
        },
        31usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(pcm_sample_bit_depth_chroma_minus1)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).log2_min_pcm_luma_coding_block_size_minus3) as usize
                - ptr as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(log2_min_pcm_luma_coding_block_size_minus3)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).log2_diff_max_min_pcm_luma_coding_block_size) as usize
                - ptr as usize
        },
        33usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(log2_diff_max_min_pcm_luma_coding_block_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved1) as usize - ptr as usize },
        34usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(reserved1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved2) as usize - ptr as usize },
        35usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(reserved2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).palette_max_size) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(palette_max_size)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).delta_palette_max_predictor_size) as usize - ptr as usize
        },
        37usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(delta_palette_max_predictor_size)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).motion_vector_resolution_control_idc) as usize
                - ptr as usize
        },
        38usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(motion_vector_resolution_control_idc)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).sps_num_palette_predictor_initializers_minus1) as usize
                - ptr as usize
        },
        39usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(sps_num_palette_predictor_initializers_minus1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).conf_win_left_offset) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(conf_win_left_offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).conf_win_right_offset) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(conf_win_right_offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).conf_win_top_offset) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(conf_win_top_offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).conf_win_bottom_offset) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(conf_win_bottom_offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pProfileTierLevel) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(pProfileTierLevel)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pDecPicBufMgr) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(pDecPicBufMgr)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pScalingLists) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(pScalingLists)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pShortTermRefPicSet) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(pShortTermRefPicSet)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pLongTermRefPicsSps) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(pLongTermRefPicsSps)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pSequenceParameterSetVui) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(pSequenceParameterSetVui)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pPredictorPaletteEntries) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(pPredictorPaletteEntries)
        )
    );
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265PpsFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_StdVideoH265PpsFlags() {
    assert_eq!(
        ::core::mem::size_of::<StdVideoH265PpsFlags>(),
        4usize,
        concat!("Size of: ", stringify!(StdVideoH265PpsFlags))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoH265PpsFlags>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoH265PpsFlags))
    );
}
impl StdVideoH265PpsFlags {
    #[inline]
    pub fn dependent_slice_segments_enabled_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_dependent_slice_segments_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn output_flag_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_output_flag_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sign_data_hiding_enabled_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sign_data_hiding_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cabac_init_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cabac_init_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn constrained_intra_pred_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_constrained_intra_pred_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn transform_skip_enabled_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_transform_skip_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cu_qp_delta_enabled_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cu_qp_delta_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pps_slice_chroma_qp_offsets_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pps_slice_chroma_qp_offsets_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn weighted_pred_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_weighted_pred_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn weighted_bipred_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_weighted_bipred_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn transquant_bypass_enabled_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_transquant_bypass_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn tiles_enabled_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_tiles_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn entropy_coding_sync_enabled_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_entropy_coding_sync_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn uniform_spacing_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_uniform_spacing_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn loop_filter_across_tiles_enabled_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_loop_filter_across_tiles_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pps_loop_filter_across_slices_enabled_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pps_loop_filter_across_slices_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn deblocking_filter_control_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_deblocking_filter_control_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn deblocking_filter_override_enabled_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(17usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_deblocking_filter_override_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(17usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pps_deblocking_filter_disabled_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(18usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pps_deblocking_filter_disabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(18usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pps_scaling_list_data_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(19usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pps_scaling_list_data_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(19usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn lists_modification_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(20usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_lists_modification_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(20usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn slice_segment_header_extension_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(21usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_slice_segment_header_extension_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(21usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pps_extension_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(22usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pps_extension_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(22usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cross_component_prediction_enabled_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(23usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cross_component_prediction_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(23usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn chroma_qp_offset_list_enabled_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_chroma_qp_offset_list_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pps_curr_pic_ref_enabled_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(25usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pps_curr_pic_ref_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(25usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn residual_adaptive_colour_transform_enabled_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(26usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_residual_adaptive_colour_transform_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(26usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pps_slice_act_qp_offsets_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(27usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pps_slice_act_qp_offsets_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(27usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pps_palette_predictor_initializers_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(28usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pps_palette_predictor_initializers_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(28usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn monochrome_palette_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(29usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_monochrome_palette_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(29usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pps_range_extension_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(30usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pps_range_extension_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(30usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        dependent_slice_segments_enabled_flag: u32,
        output_flag_present_flag: u32,
        sign_data_hiding_enabled_flag: u32,
        cabac_init_present_flag: u32,
        constrained_intra_pred_flag: u32,
        transform_skip_enabled_flag: u32,
        cu_qp_delta_enabled_flag: u32,
        pps_slice_chroma_qp_offsets_present_flag: u32,
        weighted_pred_flag: u32,
        weighted_bipred_flag: u32,
        transquant_bypass_enabled_flag: u32,
        tiles_enabled_flag: u32,
        entropy_coding_sync_enabled_flag: u32,
        uniform_spacing_flag: u32,
        loop_filter_across_tiles_enabled_flag: u32,
        pps_loop_filter_across_slices_enabled_flag: u32,
        deblocking_filter_control_present_flag: u32,
        deblocking_filter_override_enabled_flag: u32,
        pps_deblocking_filter_disabled_flag: u32,
        pps_scaling_list_data_present_flag: u32,
        lists_modification_present_flag: u32,
        slice_segment_header_extension_present_flag: u32,
        pps_extension_present_flag: u32,
        cross_component_prediction_enabled_flag: u32,
        chroma_qp_offset_list_enabled_flag: u32,
        pps_curr_pic_ref_enabled_flag: u32,
        residual_adaptive_colour_transform_enabled_flag: u32,
        pps_slice_act_qp_offsets_present_flag: u32,
        pps_palette_predictor_initializers_present_flag: u32,
        monochrome_palette_flag: u32,
        pps_range_extension_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let dependent_slice_segments_enabled_flag: u32 =
                unsafe { ::core::mem::transmute(dependent_slice_segments_enabled_flag) };
            dependent_slice_segments_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let output_flag_present_flag: u32 =
                unsafe { ::core::mem::transmute(output_flag_present_flag) };
            output_flag_present_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let sign_data_hiding_enabled_flag: u32 =
                unsafe { ::core::mem::transmute(sign_data_hiding_enabled_flag) };
            sign_data_hiding_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let cabac_init_present_flag: u32 =
                unsafe { ::core::mem::transmute(cabac_init_present_flag) };
            cabac_init_present_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let constrained_intra_pred_flag: u32 =
                unsafe { ::core::mem::transmute(constrained_intra_pred_flag) };
            constrained_intra_pred_flag as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let transform_skip_enabled_flag: u32 =
                unsafe { ::core::mem::transmute(transform_skip_enabled_flag) };
            transform_skip_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let cu_qp_delta_enabled_flag: u32 =
                unsafe { ::core::mem::transmute(cu_qp_delta_enabled_flag) };
            cu_qp_delta_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let pps_slice_chroma_qp_offsets_present_flag: u32 =
                unsafe { ::core::mem::transmute(pps_slice_chroma_qp_offsets_present_flag) };
            pps_slice_chroma_qp_offsets_present_flag as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let weighted_pred_flag: u32 = unsafe { ::core::mem::transmute(weighted_pred_flag) };
            weighted_pred_flag as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let weighted_bipred_flag: u32 = unsafe { ::core::mem::transmute(weighted_bipred_flag) };
            weighted_bipred_flag as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let transquant_bypass_enabled_flag: u32 =
                unsafe { ::core::mem::transmute(transquant_bypass_enabled_flag) };
            transquant_bypass_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let tiles_enabled_flag: u32 = unsafe { ::core::mem::transmute(tiles_enabled_flag) };
            tiles_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let entropy_coding_sync_enabled_flag: u32 =
                unsafe { ::core::mem::transmute(entropy_coding_sync_enabled_flag) };
            entropy_coding_sync_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let uniform_spacing_flag: u32 = unsafe { ::core::mem::transmute(uniform_spacing_flag) };
            uniform_spacing_flag as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let loop_filter_across_tiles_enabled_flag: u32 =
                unsafe { ::core::mem::transmute(loop_filter_across_tiles_enabled_flag) };
            loop_filter_across_tiles_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let pps_loop_filter_across_slices_enabled_flag: u32 =
                unsafe { ::core::mem::transmute(pps_loop_filter_across_slices_enabled_flag) };
            pps_loop_filter_across_slices_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let deblocking_filter_control_present_flag: u32 =
                unsafe { ::core::mem::transmute(deblocking_filter_control_present_flag) };
            deblocking_filter_control_present_flag as u64
        });
        __bindgen_bitfield_unit.set(17usize, 1u8, {
            let deblocking_filter_override_enabled_flag: u32 =
                unsafe { ::core::mem::transmute(deblocking_filter_override_enabled_flag) };
            deblocking_filter_override_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(18usize, 1u8, {
            let pps_deblocking_filter_disabled_flag: u32 =
                unsafe { ::core::mem::transmute(pps_deblocking_filter_disabled_flag) };
            pps_deblocking_filter_disabled_flag as u64
        });
        __bindgen_bitfield_unit.set(19usize, 1u8, {
            let pps_scaling_list_data_present_flag: u32 =
                unsafe { ::core::mem::transmute(pps_scaling_list_data_present_flag) };
            pps_scaling_list_data_present_flag as u64
        });
        __bindgen_bitfield_unit.set(20usize, 1u8, {
            let lists_modification_present_flag: u32 =
                unsafe { ::core::mem::transmute(lists_modification_present_flag) };
            lists_modification_present_flag as u64
        });
        __bindgen_bitfield_unit.set(21usize, 1u8, {
            let slice_segment_header_extension_present_flag: u32 =
                unsafe { ::core::mem::transmute(slice_segment_header_extension_present_flag) };
            slice_segment_header_extension_present_flag as u64
        });
        __bindgen_bitfield_unit.set(22usize, 1u8, {
            let pps_extension_present_flag: u32 =
                unsafe { ::core::mem::transmute(pps_extension_present_flag) };
            pps_extension_present_flag as u64
        });
        __bindgen_bitfield_unit.set(23usize, 1u8, {
            let cross_component_prediction_enabled_flag: u32 =
                unsafe { ::core::mem::transmute(cross_component_prediction_enabled_flag) };
            cross_component_prediction_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(24usize, 1u8, {
            let chroma_qp_offset_list_enabled_flag: u32 =
                unsafe { ::core::mem::transmute(chroma_qp_offset_list_enabled_flag) };
            chroma_qp_offset_list_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(25usize, 1u8, {
            let pps_curr_pic_ref_enabled_flag: u32 =
                unsafe { ::core::mem::transmute(pps_curr_pic_ref_enabled_flag) };
            pps_curr_pic_ref_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(26usize, 1u8, {
            let residual_adaptive_colour_transform_enabled_flag: u32 =
                unsafe { ::core::mem::transmute(residual_adaptive_colour_transform_enabled_flag) };
            residual_adaptive_colour_transform_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(27usize, 1u8, {
            let pps_slice_act_qp_offsets_present_flag: u32 =
                unsafe { ::core::mem::transmute(pps_slice_act_qp_offsets_present_flag) };
            pps_slice_act_qp_offsets_present_flag as u64
        });
        __bindgen_bitfield_unit.set(28usize, 1u8, {
            let pps_palette_predictor_initializers_present_flag: u32 =
                unsafe { ::core::mem::transmute(pps_palette_predictor_initializers_present_flag) };
            pps_palette_predictor_initializers_present_flag as u64
        });
        __bindgen_bitfield_unit.set(29usize, 1u8, {
            let monochrome_palette_flag: u32 =
                unsafe { ::core::mem::transmute(monochrome_palette_flag) };
            monochrome_palette_flag as u64
        });
        __bindgen_bitfield_unit.set(30usize, 1u8, {
            let pps_range_extension_flag: u32 =
                unsafe { ::core::mem::transmute(pps_range_extension_flag) };
            pps_range_extension_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265PictureParameterSet {
    pub flags: StdVideoH265PpsFlags,
    pub pps_pic_parameter_set_id: u8,
    pub pps_seq_parameter_set_id: u8,
    pub sps_video_parameter_set_id: u8,
    pub num_extra_slice_header_bits: u8,
    pub num_ref_idx_l0_default_active_minus1: u8,
    pub num_ref_idx_l1_default_active_minus1: u8,
    pub init_qp_minus26: i8,
    pub diff_cu_qp_delta_depth: u8,
    pub pps_cb_qp_offset: i8,
    pub pps_cr_qp_offset: i8,
    pub pps_beta_offset_div2: i8,
    pub pps_tc_offset_div2: i8,
    pub log2_parallel_merge_level_minus2: u8,
    pub log2_max_transform_skip_block_size_minus2: u8,
    pub diff_cu_chroma_qp_offset_depth: u8,
    pub chroma_qp_offset_list_len_minus1: u8,
    pub cb_qp_offset_list: [i8; 6usize],
    pub cr_qp_offset_list: [i8; 6usize],
    pub log2_sao_offset_scale_luma: u8,
    pub log2_sao_offset_scale_chroma: u8,
    pub pps_act_y_qp_offset_plus5: i8,
    pub pps_act_cb_qp_offset_plus5: i8,
    pub pps_act_cr_qp_offset_plus3: i8,
    pub pps_num_palette_predictor_initializers: u8,
    pub luma_bit_depth_entry_minus8: u8,
    pub chroma_bit_depth_entry_minus8: u8,
    pub num_tile_columns_minus1: u8,
    pub num_tile_rows_minus1: u8,
    pub reserved1: u8,
    pub reserved2: u8,
    pub column_width_minus1: [u16; 19usize],
    pub row_height_minus1: [u16; 21usize],
    pub reserved3: u32,
    pub pScalingLists: *const StdVideoH265ScalingLists,
    pub pPredictorPaletteEntries: *const StdVideoH265PredictorPaletteEntries,
}
#[test]
fn bindgen_test_layout_StdVideoH265PictureParameterSet() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoH265PictureParameterSet> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoH265PictureParameterSet>(),
        144usize,
        concat!("Size of: ", stringify!(StdVideoH265PictureParameterSet))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoH265PictureParameterSet>(),
        8usize,
        concat!("Alignment of ", stringify!(StdVideoH265PictureParameterSet))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pps_pic_parameter_set_id) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(pps_pic_parameter_set_id)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pps_seq_parameter_set_id) as usize - ptr as usize },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(pps_seq_parameter_set_id)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).sps_video_parameter_set_id) as usize - ptr as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(sps_video_parameter_set_id)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).num_extra_slice_header_bits) as usize - ptr as usize
        },
        7usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(num_extra_slice_header_bits)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).num_ref_idx_l0_default_active_minus1) as usize
                - ptr as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(num_ref_idx_l0_default_active_minus1)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).num_ref_idx_l1_default_active_minus1) as usize
                - ptr as usize
        },
        9usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(num_ref_idx_l1_default_active_minus1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).init_qp_minus26) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(init_qp_minus26)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).diff_cu_qp_delta_depth) as usize - ptr as usize },
        11usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(diff_cu_qp_delta_depth)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pps_cb_qp_offset) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(pps_cb_qp_offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pps_cr_qp_offset) as usize - ptr as usize },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(pps_cr_qp_offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pps_beta_offset_div2) as usize - ptr as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(pps_beta_offset_div2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pps_tc_offset_div2) as usize - ptr as usize },
        15usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(pps_tc_offset_div2)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).log2_parallel_merge_level_minus2) as usize - ptr as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(log2_parallel_merge_level_minus2)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).log2_max_transform_skip_block_size_minus2) as usize
                - ptr as usize
        },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(log2_max_transform_skip_block_size_minus2)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).diff_cu_chroma_qp_offset_depth) as usize - ptr as usize
        },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(diff_cu_chroma_qp_offset_depth)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).chroma_qp_offset_list_len_minus1) as usize - ptr as usize
        },
        19usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(chroma_qp_offset_list_len_minus1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cb_qp_offset_list) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(cb_qp_offset_list)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cr_qp_offset_list) as usize - ptr as usize },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(cr_qp_offset_list)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).log2_sao_offset_scale_luma) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(log2_sao_offset_scale_luma)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).log2_sao_offset_scale_chroma) as usize - ptr as usize
        },
        33usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(log2_sao_offset_scale_chroma)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pps_act_y_qp_offset_plus5) as usize - ptr as usize },
        34usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(pps_act_y_qp_offset_plus5)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pps_act_cb_qp_offset_plus5) as usize - ptr as usize },
        35usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(pps_act_cb_qp_offset_plus5)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pps_act_cr_qp_offset_plus3) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(pps_act_cr_qp_offset_plus3)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).pps_num_palette_predictor_initializers) as usize
                - ptr as usize
        },
        37usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(pps_num_palette_predictor_initializers)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).luma_bit_depth_entry_minus8) as usize - ptr as usize
        },
        38usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(luma_bit_depth_entry_minus8)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).chroma_bit_depth_entry_minus8) as usize - ptr as usize
        },
        39usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(chroma_bit_depth_entry_minus8)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).num_tile_columns_minus1) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(num_tile_columns_minus1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).num_tile_rows_minus1) as usize - ptr as usize },
        41usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(num_tile_rows_minus1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved1) as usize - ptr as usize },
        42usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(reserved1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved2) as usize - ptr as usize },
        43usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(reserved2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).column_width_minus1) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(column_width_minus1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).row_height_minus1) as usize - ptr as usize },
        82usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(row_height_minus1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved3) as usize - ptr as usize },
        124usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(reserved3)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pScalingLists) as usize - ptr as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(pScalingLists)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pPredictorPaletteEntries) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(pPredictorPaletteEntries)
        )
    );
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoDecodeH265PictureInfoFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[test]
fn bindgen_test_layout_StdVideoDecodeH265PictureInfoFlags() {
    assert_eq!(
        ::core::mem::size_of::<StdVideoDecodeH265PictureInfoFlags>(),
        4usize,
        concat!("Size of: ", stringify!(StdVideoDecodeH265PictureInfoFlags))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoDecodeH265PictureInfoFlags>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoDecodeH265PictureInfoFlags)
        )
    );
}
impl StdVideoDecodeH265PictureInfoFlags {
    #[inline]
    pub fn IrapPicFlag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_IrapPicFlag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn IdrPicFlag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_IdrPicFlag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn IsReference(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_IsReference(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn short_term_ref_pic_set_sps_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_short_term_ref_pic_set_sps_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        IrapPicFlag: u32,
        IdrPicFlag: u32,
        IsReference: u32,
        short_term_ref_pic_set_sps_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let IrapPicFlag: u32 = unsafe { ::core::mem::transmute(IrapPicFlag) };
            IrapPicFlag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let IdrPicFlag: u32 = unsafe { ::core::mem::transmute(IdrPicFlag) };
            IdrPicFlag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let IsReference: u32 = unsafe { ::core::mem::transmute(IsReference) };
            IsReference as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let short_term_ref_pic_set_sps_flag: u32 =
                unsafe { ::core::mem::transmute(short_term_ref_pic_set_sps_flag) };
            short_term_ref_pic_set_sps_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoDecodeH265PictureInfo {
    pub flags: StdVideoDecodeH265PictureInfoFlags,
    pub sps_video_parameter_set_id: u8,
    pub pps_seq_parameter_set_id: u8,
    pub pps_pic_parameter_set_id: u8,
    pub NumDeltaPocsOfRefRpsIdx: u8,
    pub PicOrderCntVal: i32,
    pub NumBitsForSTRefPicSetInSlice: u16,
    pub reserved: u16,
    pub RefPicSetStCurrBefore: [u8; 8usize],
    pub RefPicSetStCurrAfter: [u8; 8usize],
    pub RefPicSetLtCurr: [u8; 8usize],
}
#[test]
fn bindgen_test_layout_StdVideoDecodeH265PictureInfo() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoDecodeH265PictureInfo> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoDecodeH265PictureInfo>(),
        40usize,
        concat!("Size of: ", stringify!(StdVideoDecodeH265PictureInfo))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoDecodeH265PictureInfo>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoDecodeH265PictureInfo))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH265PictureInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).sps_video_parameter_set_id) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH265PictureInfo),
            "::",
            stringify!(sps_video_parameter_set_id)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pps_seq_parameter_set_id) as usize - ptr as usize },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH265PictureInfo),
            "::",
            stringify!(pps_seq_parameter_set_id)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pps_pic_parameter_set_id) as usize - ptr as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH265PictureInfo),
            "::",
            stringify!(pps_pic_parameter_set_id)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NumDeltaPocsOfRefRpsIdx) as usize - ptr as usize },
        7usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH265PictureInfo),
            "::",
            stringify!(NumDeltaPocsOfRefRpsIdx)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).PicOrderCntVal) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH265PictureInfo),
            "::",
            stringify!(PicOrderCntVal)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).NumBitsForSTRefPicSetInSlice) as usize - ptr as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH265PictureInfo),
            "::",
            stringify!(NumBitsForSTRefPicSetInSlice)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved) as usize - ptr as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH265PictureInfo),
            "::",
            stringify!(reserved)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RefPicSetStCurrBefore) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH265PictureInfo),
            "::",
            stringify!(RefPicSetStCurrBefore)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RefPicSetStCurrAfter) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH265PictureInfo),
            "::",
            stringify!(RefPicSetStCurrAfter)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RefPicSetLtCurr) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH265PictureInfo),
            "::",
            stringify!(RefPicSetLtCurr)
        )
    );
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoDecodeH265ReferenceInfoFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[test]
fn bindgen_test_layout_StdVideoDecodeH265ReferenceInfoFlags() {
    assert_eq!(
        ::core::mem::size_of::<StdVideoDecodeH265ReferenceInfoFlags>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(StdVideoDecodeH265ReferenceInfoFlags)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoDecodeH265ReferenceInfoFlags>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoDecodeH265ReferenceInfoFlags)
        )
    );
}
impl StdVideoDecodeH265ReferenceInfoFlags {
    #[inline]
    pub fn used_for_long_term_reference(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_used_for_long_term_reference(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn unused_for_reference(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_unused_for_reference(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        used_for_long_term_reference: u32,
        unused_for_reference: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let used_for_long_term_reference: u32 =
                unsafe { ::core::mem::transmute(used_for_long_term_reference) };
            used_for_long_term_reference as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let unused_for_reference: u32 = unsafe { ::core::mem::transmute(unused_for_reference) };
            unused_for_reference as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoDecodeH265ReferenceInfo {
    pub flags: StdVideoDecodeH265ReferenceInfoFlags,
    pub PicOrderCntVal: i32,
}
#[test]
fn bindgen_test_layout_StdVideoDecodeH265ReferenceInfo() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoDecodeH265ReferenceInfo> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoDecodeH265ReferenceInfo>(),
        8usize,
        concat!("Size of: ", stringify!(StdVideoDecodeH265ReferenceInfo))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoDecodeH265ReferenceInfo>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoDecodeH265ReferenceInfo))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH265ReferenceInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).PicOrderCntVal) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH265ReferenceInfo),
            "::",
            stringify!(PicOrderCntVal)
        )
    );
}
pub const StdVideoAV1Profile_STD_VIDEO_AV1_PROFILE_MAIN: StdVideoAV1Profile = 0;
pub const StdVideoAV1Profile_STD_VIDEO_AV1_PROFILE_HIGH: StdVideoAV1Profile = 1;
pub const StdVideoAV1Profile_STD_VIDEO_AV1_PROFILE_PROFESSIONAL: StdVideoAV1Profile = 2;
pub const StdVideoAV1Profile_STD_VIDEO_AV1_PROFILE_INVALID: StdVideoAV1Profile = 2147483647;
pub type StdVideoAV1Profile = ::core::ffi::c_uint;
pub const StdVideoAV1Level_STD_VIDEO_AV1_LEVEL_2_0: StdVideoAV1Level = 0;
pub const StdVideoAV1Level_STD_VIDEO_AV1_LEVEL_2_1: StdVideoAV1Level = 1;
pub const StdVideoAV1Level_STD_VIDEO_AV1_LEVEL_2_2: StdVideoAV1Level = 2;
pub const StdVideoAV1Level_STD_VIDEO_AV1_LEVEL_2_3: StdVideoAV1Level = 3;
pub const StdVideoAV1Level_STD_VIDEO_AV1_LEVEL_3_0: StdVideoAV1Level = 4;
pub const StdVideoAV1Level_STD_VIDEO_AV1_LEVEL_3_1: StdVideoAV1Level = 5;
pub const StdVideoAV1Level_STD_VIDEO_AV1_LEVEL_3_2: StdVideoAV1Level = 6;
pub const StdVideoAV1Level_STD_VIDEO_AV1_LEVEL_3_3: StdVideoAV1Level = 7;
pub const StdVideoAV1Level_STD_VIDEO_AV1_LEVEL_4_0: StdVideoAV1Level = 8;
pub const StdVideoAV1Level_STD_VIDEO_AV1_LEVEL_4_1: StdVideoAV1Level = 9;
pub const StdVideoAV1Level_STD_VIDEO_AV1_LEVEL_4_2: StdVideoAV1Level = 10;
pub const StdVideoAV1Level_STD_VIDEO_AV1_LEVEL_4_3: StdVideoAV1Level = 11;
pub const StdVideoAV1Level_STD_VIDEO_AV1_LEVEL_5_0: StdVideoAV1Level = 12;
pub const StdVideoAV1Level_STD_VIDEO_AV1_LEVEL_5_1: StdVideoAV1Level = 13;
pub const StdVideoAV1Level_STD_VIDEO_AV1_LEVEL_5_2: StdVideoAV1Level = 14;
pub const StdVideoAV1Level_STD_VIDEO_AV1_LEVEL_5_3: StdVideoAV1Level = 15;
pub const StdVideoAV1Level_STD_VIDEO_AV1_LEVEL_6_0: StdVideoAV1Level = 16;
pub const StdVideoAV1Level_STD_VIDEO_AV1_LEVEL_6_1: StdVideoAV1Level = 17;
pub const StdVideoAV1Level_STD_VIDEO_AV1_LEVEL_6_2: StdVideoAV1Level = 18;
pub const StdVideoAV1Level_STD_VIDEO_AV1_LEVEL_6_3: StdVideoAV1Level = 19;
pub const StdVideoAV1Level_STD_VIDEO_AV1_LEVEL_7_0: StdVideoAV1Level = 20;
pub const StdVideoAV1Level_STD_VIDEO_AV1_LEVEL_7_1: StdVideoAV1Level = 21;
pub const StdVideoAV1Level_STD_VIDEO_AV1_LEVEL_7_2: StdVideoAV1Level = 22;
pub const StdVideoAV1Level_STD_VIDEO_AV1_LEVEL_7_3: StdVideoAV1Level = 23;
pub const StdVideoAV1Level_STD_VIDEO_AV1_LEVEL_INVALID: StdVideoAV1Level = 2147483647;
pub type StdVideoAV1Level = ::core::ffi::c_uint;
pub const StdVideoAV1FrameType_STD_VIDEO_AV1_FRAME_TYPE_KEY: StdVideoAV1FrameType = 0;
pub const StdVideoAV1FrameType_STD_VIDEO_AV1_FRAME_TYPE_INTER: StdVideoAV1FrameType = 1;
pub const StdVideoAV1FrameType_STD_VIDEO_AV1_FRAME_TYPE_INTRA_ONLY: StdVideoAV1FrameType = 2;
pub const StdVideoAV1FrameType_STD_VIDEO_AV1_FRAME_TYPE_SWITCH: StdVideoAV1FrameType = 3;
pub const StdVideoAV1FrameType_STD_VIDEO_AV1_FRAME_TYPE_INVALID: StdVideoAV1FrameType = 2147483647;
pub type StdVideoAV1FrameType = ::core::ffi::c_uint;
pub const StdVideoAV1InterpolationFilter_STD_VIDEO_AV1_INTERPOLATION_FILTER_EIGHTTAP:
    StdVideoAV1InterpolationFilter = 0;
pub const StdVideoAV1InterpolationFilter_STD_VIDEO_AV1_INTERPOLATION_FILTER_EIGHTTAP_SMOOTH:
    StdVideoAV1InterpolationFilter = 1;
pub const StdVideoAV1InterpolationFilter_STD_VIDEO_AV1_INTERPOLATION_FILTER_EIGHTTAP_SHARP:
    StdVideoAV1InterpolationFilter = 2;
pub const StdVideoAV1InterpolationFilter_STD_VIDEO_AV1_INTERPOLATION_FILTER_BILINEAR:
    StdVideoAV1InterpolationFilter = 3;
pub const StdVideoAV1InterpolationFilter_STD_VIDEO_AV1_INTERPOLATION_FILTER_SWITCHABLE:
    StdVideoAV1InterpolationFilter = 4;
pub const StdVideoAV1InterpolationFilter_STD_VIDEO_AV1_INTERPOLATION_FILTER_INVALID:
    StdVideoAV1InterpolationFilter = 2147483647;
pub type StdVideoAV1InterpolationFilter = ::core::ffi::c_uint;
pub const StdVideoAV1TxMode_STD_VIDEO_AV1_TX_MODE_ONLY_4X4: StdVideoAV1TxMode = 0;
pub const StdVideoAV1TxMode_STD_VIDEO_AV1_TX_MODE_LARGEST: StdVideoAV1TxMode = 1;
pub const StdVideoAV1TxMode_STD_VIDEO_AV1_TX_MODE_SELECT: StdVideoAV1TxMode = 2;
pub const StdVideoAV1TxMode_STD_VIDEO_AV1_TX_MODE_INVALID: StdVideoAV1TxMode = 2147483647;
pub type StdVideoAV1TxMode = ::core::ffi::c_uint;
pub const StdVideoAV1FrameRestorationType_STD_VIDEO_AV1_FRAME_RESTORATION_TYPE_NONE:
    StdVideoAV1FrameRestorationType = 0;
pub const StdVideoAV1FrameRestorationType_STD_VIDEO_AV1_FRAME_RESTORATION_TYPE_WIENER:
    StdVideoAV1FrameRestorationType = 1;
pub const StdVideoAV1FrameRestorationType_STD_VIDEO_AV1_FRAME_RESTORATION_TYPE_SGRPROJ:
    StdVideoAV1FrameRestorationType = 2;
pub const StdVideoAV1FrameRestorationType_STD_VIDEO_AV1_FRAME_RESTORATION_TYPE_SWITCHABLE:
    StdVideoAV1FrameRestorationType = 3;
pub const StdVideoAV1FrameRestorationType_STD_VIDEO_AV1_FRAME_RESTORATION_TYPE_INVALID:
    StdVideoAV1FrameRestorationType = 2147483647;
pub type StdVideoAV1FrameRestorationType = ::core::ffi::c_uint;
pub const StdVideoAV1ColorPrimaries_STD_VIDEO_AV1_COLOR_PRIMARIES_BT_709:
    StdVideoAV1ColorPrimaries = 1;
pub const StdVideoAV1ColorPrimaries_STD_VIDEO_AV1_COLOR_PRIMARIES_BT_UNSPECIFIED:
    StdVideoAV1ColorPrimaries = 2;
pub const StdVideoAV1ColorPrimaries_STD_VIDEO_AV1_COLOR_PRIMARIES_BT_470_M:
    StdVideoAV1ColorPrimaries = 4;
pub const StdVideoAV1ColorPrimaries_STD_VIDEO_AV1_COLOR_PRIMARIES_BT_470_B_G:
    StdVideoAV1ColorPrimaries = 5;
pub const StdVideoAV1ColorPrimaries_STD_VIDEO_AV1_COLOR_PRIMARIES_BT_601:
    StdVideoAV1ColorPrimaries = 6;
pub const StdVideoAV1ColorPrimaries_STD_VIDEO_AV1_COLOR_PRIMARIES_SMPTE_240:
    StdVideoAV1ColorPrimaries = 7;
pub const StdVideoAV1ColorPrimaries_STD_VIDEO_AV1_COLOR_PRIMARIES_GENERIC_FILM:
    StdVideoAV1ColorPrimaries = 8;
pub const StdVideoAV1ColorPrimaries_STD_VIDEO_AV1_COLOR_PRIMARIES_BT_2020:
    StdVideoAV1ColorPrimaries = 9;
pub const StdVideoAV1ColorPrimaries_STD_VIDEO_AV1_COLOR_PRIMARIES_XYZ: StdVideoAV1ColorPrimaries =
    10;
pub const StdVideoAV1ColorPrimaries_STD_VIDEO_AV1_COLOR_PRIMARIES_SMPTE_431:
    StdVideoAV1ColorPrimaries = 11;
pub const StdVideoAV1ColorPrimaries_STD_VIDEO_AV1_COLOR_PRIMARIES_SMPTE_432:
    StdVideoAV1ColorPrimaries = 12;
pub const StdVideoAV1ColorPrimaries_STD_VIDEO_AV1_COLOR_PRIMARIES_EBU_3213:
    StdVideoAV1ColorPrimaries = 22;
pub const StdVideoAV1ColorPrimaries_STD_VIDEO_AV1_COLOR_PRIMARIES_INVALID:
    StdVideoAV1ColorPrimaries = 2147483647;
pub type StdVideoAV1ColorPrimaries = ::core::ffi::c_uint;
pub const StdVideoAV1TransferCharacteristics_STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_RESERVED_0:
    StdVideoAV1TransferCharacteristics = 0;
pub const StdVideoAV1TransferCharacteristics_STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_BT_709:
    StdVideoAV1TransferCharacteristics = 1;
pub const StdVideoAV1TransferCharacteristics_STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_UNSPECIFIED:
    StdVideoAV1TransferCharacteristics = 2;
pub const StdVideoAV1TransferCharacteristics_STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_RESERVED_3:
    StdVideoAV1TransferCharacteristics = 3;
pub const StdVideoAV1TransferCharacteristics_STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_BT_470_M:
    StdVideoAV1TransferCharacteristics = 4;
pub const StdVideoAV1TransferCharacteristics_STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_BT_470_B_G:
    StdVideoAV1TransferCharacteristics = 5;
pub const StdVideoAV1TransferCharacteristics_STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_BT_601:
    StdVideoAV1TransferCharacteristics = 6;
pub const StdVideoAV1TransferCharacteristics_STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_SMPTE_240:
    StdVideoAV1TransferCharacteristics = 7;
pub const StdVideoAV1TransferCharacteristics_STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_LINEAR:
    StdVideoAV1TransferCharacteristics = 8;
pub const StdVideoAV1TransferCharacteristics_STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_LOG_100:
    StdVideoAV1TransferCharacteristics = 9;
pub const StdVideoAV1TransferCharacteristics_STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_LOG_100_SQRT10 : StdVideoAV1TransferCharacteristics = 10 ;
pub const StdVideoAV1TransferCharacteristics_STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_IEC_61966:
    StdVideoAV1TransferCharacteristics = 11;
pub const StdVideoAV1TransferCharacteristics_STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_BT_1361:
    StdVideoAV1TransferCharacteristics = 12;
pub const StdVideoAV1TransferCharacteristics_STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_SRGB:
    StdVideoAV1TransferCharacteristics = 13;
pub const StdVideoAV1TransferCharacteristics_STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_BT_2020_10_BIT : StdVideoAV1TransferCharacteristics = 14 ;
pub const StdVideoAV1TransferCharacteristics_STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_BT_2020_12_BIT : StdVideoAV1TransferCharacteristics = 15 ;
pub const StdVideoAV1TransferCharacteristics_STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_SMPTE_2084:
    StdVideoAV1TransferCharacteristics = 16;
pub const StdVideoAV1TransferCharacteristics_STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_SMPTE_428:
    StdVideoAV1TransferCharacteristics = 17;
pub const StdVideoAV1TransferCharacteristics_STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_HLG:
    StdVideoAV1TransferCharacteristics = 18;
pub const StdVideoAV1TransferCharacteristics_STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_INVALID:
    StdVideoAV1TransferCharacteristics = 2147483647;
pub type StdVideoAV1TransferCharacteristics = ::core::ffi::c_uint;
pub const StdVideoAV1MatrixCoefficients_STD_VIDEO_AV1_MATRIX_COEFFICIENTS_IDENTITY:
    StdVideoAV1MatrixCoefficients = 0;
pub const StdVideoAV1MatrixCoefficients_STD_VIDEO_AV1_MATRIX_COEFFICIENTS_BT_709:
    StdVideoAV1MatrixCoefficients = 1;
pub const StdVideoAV1MatrixCoefficients_STD_VIDEO_AV1_MATRIX_COEFFICIENTS_UNSPECIFIED:
    StdVideoAV1MatrixCoefficients = 2;
pub const StdVideoAV1MatrixCoefficients_STD_VIDEO_AV1_MATRIX_COEFFICIENTS_RESERVED_3:
    StdVideoAV1MatrixCoefficients = 3;
pub const StdVideoAV1MatrixCoefficients_STD_VIDEO_AV1_MATRIX_COEFFICIENTS_FCC:
    StdVideoAV1MatrixCoefficients = 4;
pub const StdVideoAV1MatrixCoefficients_STD_VIDEO_AV1_MATRIX_COEFFICIENTS_BT_470_B_G:
    StdVideoAV1MatrixCoefficients = 5;
pub const StdVideoAV1MatrixCoefficients_STD_VIDEO_AV1_MATRIX_COEFFICIENTS_BT_601:
    StdVideoAV1MatrixCoefficients = 6;
pub const StdVideoAV1MatrixCoefficients_STD_VIDEO_AV1_MATRIX_COEFFICIENTS_SMPTE_240:
    StdVideoAV1MatrixCoefficients = 7;
pub const StdVideoAV1MatrixCoefficients_STD_VIDEO_AV1_MATRIX_COEFFICIENTS_SMPTE_YCGCO:
    StdVideoAV1MatrixCoefficients = 8;
pub const StdVideoAV1MatrixCoefficients_STD_VIDEO_AV1_MATRIX_COEFFICIENTS_BT_2020_NCL:
    StdVideoAV1MatrixCoefficients = 9;
pub const StdVideoAV1MatrixCoefficients_STD_VIDEO_AV1_MATRIX_COEFFICIENTS_BT_2020_CL:
    StdVideoAV1MatrixCoefficients = 10;
pub const StdVideoAV1MatrixCoefficients_STD_VIDEO_AV1_MATRIX_COEFFICIENTS_SMPTE_2085:
    StdVideoAV1MatrixCoefficients = 11;
pub const StdVideoAV1MatrixCoefficients_STD_VIDEO_AV1_MATRIX_COEFFICIENTS_CHROMAT_NCL:
    StdVideoAV1MatrixCoefficients = 12;
pub const StdVideoAV1MatrixCoefficients_STD_VIDEO_AV1_MATRIX_COEFFICIENTS_CHROMAT_CL:
    StdVideoAV1MatrixCoefficients = 13;
pub const StdVideoAV1MatrixCoefficients_STD_VIDEO_AV1_MATRIX_COEFFICIENTS_ICTCP:
    StdVideoAV1MatrixCoefficients = 14;
pub const StdVideoAV1MatrixCoefficients_STD_VIDEO_AV1_MATRIX_COEFFICIENTS_INVALID:
    StdVideoAV1MatrixCoefficients = 2147483647;
pub type StdVideoAV1MatrixCoefficients = ::core::ffi::c_uint;
pub const StdVideoAV1ChromaSamplePosition_STD_VIDEO_AV1_CHROMA_SAMPLE_POSITION_UNKNOWN:
    StdVideoAV1ChromaSamplePosition = 0;
pub const StdVideoAV1ChromaSamplePosition_STD_VIDEO_AV1_CHROMA_SAMPLE_POSITION_VERTICAL:
    StdVideoAV1ChromaSamplePosition = 1;
pub const StdVideoAV1ChromaSamplePosition_STD_VIDEO_AV1_CHROMA_SAMPLE_POSITION_COLOCATED:
    StdVideoAV1ChromaSamplePosition = 2;
pub const StdVideoAV1ChromaSamplePosition_STD_VIDEO_AV1_CHROMA_SAMPLE_POSITION_RESERVED:
    StdVideoAV1ChromaSamplePosition = 3;
pub const StdVideoAV1ChromaSamplePosition_STD_VIDEO_AV1_CHROMA_SAMPLE_POSITION_INVALID:
    StdVideoAV1ChromaSamplePosition = 2147483647;
pub type StdVideoAV1ChromaSamplePosition = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoAV1ColorConfigFlags {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_StdVideoAV1ColorConfigFlags() {
    assert_eq!(
        ::core::mem::size_of::<StdVideoAV1ColorConfigFlags>(),
        4usize,
        concat!("Size of: ", stringify!(StdVideoAV1ColorConfigFlags))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoAV1ColorConfigFlags>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoAV1ColorConfigFlags))
    );
}
impl StdVideoAV1ColorConfigFlags {
    #[inline]
    pub fn mono_chrome(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_mono_chrome(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn color_range(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_color_range(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn separate_uv_delta_q(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_separate_uv_delta_q(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn color_description_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_color_description_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(4usize, 28u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(4usize, 28u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        mono_chrome: u32,
        color_range: u32,
        separate_uv_delta_q: u32,
        color_description_present_flag: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let mono_chrome: u32 = unsafe { ::core::mem::transmute(mono_chrome) };
            mono_chrome as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let color_range: u32 = unsafe { ::core::mem::transmute(color_range) };
            color_range as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let separate_uv_delta_q: u32 = unsafe { ::core::mem::transmute(separate_uv_delta_q) };
            separate_uv_delta_q as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let color_description_present_flag: u32 =
                unsafe { ::core::mem::transmute(color_description_present_flag) };
            color_description_present_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 28u8, {
            let reserved: u32 = unsafe { ::core::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoAV1ColorConfig {
    pub flags: StdVideoAV1ColorConfigFlags,
    pub BitDepth: u8,
    pub subsampling_x: u8,
    pub subsampling_y: u8,
    pub reserved1: u8,
    pub color_primaries: StdVideoAV1ColorPrimaries,
    pub transfer_characteristics: StdVideoAV1TransferCharacteristics,
    pub matrix_coefficients: StdVideoAV1MatrixCoefficients,
    pub chroma_sample_position: StdVideoAV1ChromaSamplePosition,
}
#[test]
fn bindgen_test_layout_StdVideoAV1ColorConfig() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoAV1ColorConfig> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoAV1ColorConfig>(),
        24usize,
        concat!("Size of: ", stringify!(StdVideoAV1ColorConfig))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoAV1ColorConfig>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoAV1ColorConfig))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1ColorConfig),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).BitDepth) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1ColorConfig),
            "::",
            stringify!(BitDepth)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).subsampling_x) as usize - ptr as usize },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1ColorConfig),
            "::",
            stringify!(subsampling_x)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).subsampling_y) as usize - ptr as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1ColorConfig),
            "::",
            stringify!(subsampling_y)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved1) as usize - ptr as usize },
        7usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1ColorConfig),
            "::",
            stringify!(reserved1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).color_primaries) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1ColorConfig),
            "::",
            stringify!(color_primaries)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).transfer_characteristics) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1ColorConfig),
            "::",
            stringify!(transfer_characteristics)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).matrix_coefficients) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1ColorConfig),
            "::",
            stringify!(matrix_coefficients)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).chroma_sample_position) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1ColorConfig),
            "::",
            stringify!(chroma_sample_position)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoAV1TimingInfoFlags {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_StdVideoAV1TimingInfoFlags() {
    assert_eq!(
        ::core::mem::size_of::<StdVideoAV1TimingInfoFlags>(),
        4usize,
        concat!("Size of: ", stringify!(StdVideoAV1TimingInfoFlags))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoAV1TimingInfoFlags>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoAV1TimingInfoFlags))
    );
}
impl StdVideoAV1TimingInfoFlags {
    #[inline]
    pub fn equal_picture_interval(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_equal_picture_interval(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 31u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 31u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        equal_picture_interval: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let equal_picture_interval: u32 =
                unsafe { ::core::mem::transmute(equal_picture_interval) };
            equal_picture_interval as u64
        });
        __bindgen_bitfield_unit.set(1usize, 31u8, {
            let reserved: u32 = unsafe { ::core::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoAV1TimingInfo {
    pub flags: StdVideoAV1TimingInfoFlags,
    pub num_units_in_display_tick: u32,
    pub time_scale: u32,
    pub num_ticks_per_picture_minus_1: u32,
}
#[test]
fn bindgen_test_layout_StdVideoAV1TimingInfo() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoAV1TimingInfo> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoAV1TimingInfo>(),
        16usize,
        concat!("Size of: ", stringify!(StdVideoAV1TimingInfo))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoAV1TimingInfo>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoAV1TimingInfo))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1TimingInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).num_units_in_display_tick) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1TimingInfo),
            "::",
            stringify!(num_units_in_display_tick)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).time_scale) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1TimingInfo),
            "::",
            stringify!(time_scale)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).num_ticks_per_picture_minus_1) as usize - ptr as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1TimingInfo),
            "::",
            stringify!(num_ticks_per_picture_minus_1)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoAV1LoopFilterFlags {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_StdVideoAV1LoopFilterFlags() {
    assert_eq!(
        ::core::mem::size_of::<StdVideoAV1LoopFilterFlags>(),
        4usize,
        concat!("Size of: ", stringify!(StdVideoAV1LoopFilterFlags))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoAV1LoopFilterFlags>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoAV1LoopFilterFlags))
    );
}
impl StdVideoAV1LoopFilterFlags {
    #[inline]
    pub fn loop_filter_delta_enabled(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_loop_filter_delta_enabled(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn loop_filter_delta_update(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_loop_filter_delta_update(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 30u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 30u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        loop_filter_delta_enabled: u32,
        loop_filter_delta_update: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let loop_filter_delta_enabled: u32 =
                unsafe { ::core::mem::transmute(loop_filter_delta_enabled) };
            loop_filter_delta_enabled as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let loop_filter_delta_update: u32 =
                unsafe { ::core::mem::transmute(loop_filter_delta_update) };
            loop_filter_delta_update as u64
        });
        __bindgen_bitfield_unit.set(2usize, 30u8, {
            let reserved: u32 = unsafe { ::core::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoAV1LoopFilter {
    pub flags: StdVideoAV1LoopFilterFlags,
    pub loop_filter_level: [u8; 4usize],
    pub loop_filter_sharpness: u8,
    pub update_ref_delta: u8,
    pub loop_filter_ref_deltas: [i8; 8usize],
    pub update_mode_delta: u8,
    pub loop_filter_mode_deltas: [i8; 2usize],
}
#[test]
fn bindgen_test_layout_StdVideoAV1LoopFilter() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoAV1LoopFilter> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoAV1LoopFilter>(),
        24usize,
        concat!("Size of: ", stringify!(StdVideoAV1LoopFilter))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoAV1LoopFilter>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoAV1LoopFilter))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1LoopFilter),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).loop_filter_level) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1LoopFilter),
            "::",
            stringify!(loop_filter_level)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).loop_filter_sharpness) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1LoopFilter),
            "::",
            stringify!(loop_filter_sharpness)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).update_ref_delta) as usize - ptr as usize },
        9usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1LoopFilter),
            "::",
            stringify!(update_ref_delta)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).loop_filter_ref_deltas) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1LoopFilter),
            "::",
            stringify!(loop_filter_ref_deltas)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).update_mode_delta) as usize - ptr as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1LoopFilter),
            "::",
            stringify!(update_mode_delta)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).loop_filter_mode_deltas) as usize - ptr as usize },
        19usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1LoopFilter),
            "::",
            stringify!(loop_filter_mode_deltas)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoAV1QuantizationFlags {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_StdVideoAV1QuantizationFlags() {
    assert_eq!(
        ::core::mem::size_of::<StdVideoAV1QuantizationFlags>(),
        4usize,
        concat!("Size of: ", stringify!(StdVideoAV1QuantizationFlags))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoAV1QuantizationFlags>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoAV1QuantizationFlags))
    );
}
impl StdVideoAV1QuantizationFlags {
    #[inline]
    pub fn using_qmatrix(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_using_qmatrix(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn diff_uv_delta(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_diff_uv_delta(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 30u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 30u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        using_qmatrix: u32,
        diff_uv_delta: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let using_qmatrix: u32 = unsafe { ::core::mem::transmute(using_qmatrix) };
            using_qmatrix as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let diff_uv_delta: u32 = unsafe { ::core::mem::transmute(diff_uv_delta) };
            diff_uv_delta as u64
        });
        __bindgen_bitfield_unit.set(2usize, 30u8, {
            let reserved: u32 = unsafe { ::core::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoAV1Quantization {
    pub flags: StdVideoAV1QuantizationFlags,
    pub base_q_idx: u8,
    pub DeltaQYDc: i8,
    pub DeltaQUDc: i8,
    pub DeltaQUAc: i8,
    pub DeltaQVDc: i8,
    pub DeltaQVAc: i8,
    pub qm_y: u8,
    pub qm_u: u8,
    pub qm_v: u8,
}
#[test]
fn bindgen_test_layout_StdVideoAV1Quantization() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoAV1Quantization> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoAV1Quantization>(),
        16usize,
        concat!("Size of: ", stringify!(StdVideoAV1Quantization))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoAV1Quantization>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoAV1Quantization))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1Quantization),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).base_q_idx) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1Quantization),
            "::",
            stringify!(base_q_idx)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).DeltaQYDc) as usize - ptr as usize },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1Quantization),
            "::",
            stringify!(DeltaQYDc)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).DeltaQUDc) as usize - ptr as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1Quantization),
            "::",
            stringify!(DeltaQUDc)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).DeltaQUAc) as usize - ptr as usize },
        7usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1Quantization),
            "::",
            stringify!(DeltaQUAc)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).DeltaQVDc) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1Quantization),
            "::",
            stringify!(DeltaQVDc)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).DeltaQVAc) as usize - ptr as usize },
        9usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1Quantization),
            "::",
            stringify!(DeltaQVAc)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).qm_y) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1Quantization),
            "::",
            stringify!(qm_y)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).qm_u) as usize - ptr as usize },
        11usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1Quantization),
            "::",
            stringify!(qm_u)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).qm_v) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1Quantization),
            "::",
            stringify!(qm_v)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoAV1Segmentation {
    pub FeatureEnabled: [u8; 8usize],
    pub FeatureData: [[i16; 8usize]; 8usize],
}
#[test]
fn bindgen_test_layout_StdVideoAV1Segmentation() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoAV1Segmentation> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoAV1Segmentation>(),
        136usize,
        concat!("Size of: ", stringify!(StdVideoAV1Segmentation))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoAV1Segmentation>(),
        2usize,
        concat!("Alignment of ", stringify!(StdVideoAV1Segmentation))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).FeatureEnabled) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1Segmentation),
            "::",
            stringify!(FeatureEnabled)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).FeatureData) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1Segmentation),
            "::",
            stringify!(FeatureData)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoAV1TileInfoFlags {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_StdVideoAV1TileInfoFlags() {
    assert_eq!(
        ::core::mem::size_of::<StdVideoAV1TileInfoFlags>(),
        4usize,
        concat!("Size of: ", stringify!(StdVideoAV1TileInfoFlags))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoAV1TileInfoFlags>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoAV1TileInfoFlags))
    );
}
impl StdVideoAV1TileInfoFlags {
    #[inline]
    pub fn uniform_tile_spacing_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_uniform_tile_spacing_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 31u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 31u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        uniform_tile_spacing_flag: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let uniform_tile_spacing_flag: u32 =
                unsafe { ::core::mem::transmute(uniform_tile_spacing_flag) };
            uniform_tile_spacing_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 31u8, {
            let reserved: u32 = unsafe { ::core::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoAV1TileInfo {
    pub flags: StdVideoAV1TileInfoFlags,
    pub TileCols: u8,
    pub TileRows: u8,
    pub context_update_tile_id: u16,
    pub tile_size_bytes_minus_1: u8,
    pub reserved1: [u8; 7usize],
    pub pMiColStarts: *const u16,
    pub pMiRowStarts: *const u16,
    pub pWidthInSbsMinus1: *const u16,
    pub pHeightInSbsMinus1: *const u16,
}
#[test]
fn bindgen_test_layout_StdVideoAV1TileInfo() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoAV1TileInfo> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoAV1TileInfo>(),
        48usize,
        concat!("Size of: ", stringify!(StdVideoAV1TileInfo))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoAV1TileInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(StdVideoAV1TileInfo))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1TileInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).TileCols) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1TileInfo),
            "::",
            stringify!(TileCols)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).TileRows) as usize - ptr as usize },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1TileInfo),
            "::",
            stringify!(TileRows)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).context_update_tile_id) as usize - ptr as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1TileInfo),
            "::",
            stringify!(context_update_tile_id)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).tile_size_bytes_minus_1) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1TileInfo),
            "::",
            stringify!(tile_size_bytes_minus_1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved1) as usize - ptr as usize },
        9usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1TileInfo),
            "::",
            stringify!(reserved1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pMiColStarts) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1TileInfo),
            "::",
            stringify!(pMiColStarts)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pMiRowStarts) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1TileInfo),
            "::",
            stringify!(pMiRowStarts)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pWidthInSbsMinus1) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1TileInfo),
            "::",
            stringify!(pWidthInSbsMinus1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pHeightInSbsMinus1) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1TileInfo),
            "::",
            stringify!(pHeightInSbsMinus1)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoAV1CDEF {
    pub cdef_damping_minus_3: u8,
    pub cdef_bits: u8,
    pub cdef_y_pri_strength: [u8; 8usize],
    pub cdef_y_sec_strength: [u8; 8usize],
    pub cdef_uv_pri_strength: [u8; 8usize],
    pub cdef_uv_sec_strength: [u8; 8usize],
}
#[test]
fn bindgen_test_layout_StdVideoAV1CDEF() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoAV1CDEF> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoAV1CDEF>(),
        34usize,
        concat!("Size of: ", stringify!(StdVideoAV1CDEF))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoAV1CDEF>(),
        1usize,
        concat!("Alignment of ", stringify!(StdVideoAV1CDEF))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cdef_damping_minus_3) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1CDEF),
            "::",
            stringify!(cdef_damping_minus_3)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cdef_bits) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1CDEF),
            "::",
            stringify!(cdef_bits)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cdef_y_pri_strength) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1CDEF),
            "::",
            stringify!(cdef_y_pri_strength)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cdef_y_sec_strength) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1CDEF),
            "::",
            stringify!(cdef_y_sec_strength)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cdef_uv_pri_strength) as usize - ptr as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1CDEF),
            "::",
            stringify!(cdef_uv_pri_strength)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cdef_uv_sec_strength) as usize - ptr as usize },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1CDEF),
            "::",
            stringify!(cdef_uv_sec_strength)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoAV1LoopRestoration {
    pub FrameRestorationType: [StdVideoAV1FrameRestorationType; 3usize],
    pub LoopRestorationSize: [u16; 3usize],
}
#[test]
fn bindgen_test_layout_StdVideoAV1LoopRestoration() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoAV1LoopRestoration> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoAV1LoopRestoration>(),
        20usize,
        concat!("Size of: ", stringify!(StdVideoAV1LoopRestoration))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoAV1LoopRestoration>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoAV1LoopRestoration))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).FrameRestorationType) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1LoopRestoration),
            "::",
            stringify!(FrameRestorationType)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).LoopRestorationSize) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1LoopRestoration),
            "::",
            stringify!(LoopRestorationSize)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoAV1GlobalMotion {
    pub GmType: [u8; 8usize],
    pub gm_params: [[i32; 6usize]; 8usize],
}
#[test]
fn bindgen_test_layout_StdVideoAV1GlobalMotion() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoAV1GlobalMotion> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoAV1GlobalMotion>(),
        200usize,
        concat!("Size of: ", stringify!(StdVideoAV1GlobalMotion))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoAV1GlobalMotion>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoAV1GlobalMotion))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).GmType) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1GlobalMotion),
            "::",
            stringify!(GmType)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).gm_params) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1GlobalMotion),
            "::",
            stringify!(gm_params)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoAV1FilmGrainFlags {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_StdVideoAV1FilmGrainFlags() {
    assert_eq!(
        ::core::mem::size_of::<StdVideoAV1FilmGrainFlags>(),
        4usize,
        concat!("Size of: ", stringify!(StdVideoAV1FilmGrainFlags))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoAV1FilmGrainFlags>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoAV1FilmGrainFlags))
    );
}
impl StdVideoAV1FilmGrainFlags {
    #[inline]
    pub fn chroma_scaling_from_luma(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_chroma_scaling_from_luma(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn overlap_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_overlap_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn clip_to_restricted_range(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_clip_to_restricted_range(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn update_grain(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_update_grain(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(4usize, 28u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(4usize, 28u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        chroma_scaling_from_luma: u32,
        overlap_flag: u32,
        clip_to_restricted_range: u32,
        update_grain: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let chroma_scaling_from_luma: u32 =
                unsafe { ::core::mem::transmute(chroma_scaling_from_luma) };
            chroma_scaling_from_luma as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let overlap_flag: u32 = unsafe { ::core::mem::transmute(overlap_flag) };
            overlap_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let clip_to_restricted_range: u32 =
                unsafe { ::core::mem::transmute(clip_to_restricted_range) };
            clip_to_restricted_range as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let update_grain: u32 = unsafe { ::core::mem::transmute(update_grain) };
            update_grain as u64
        });
        __bindgen_bitfield_unit.set(4usize, 28u8, {
            let reserved: u32 = unsafe { ::core::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoAV1FilmGrain {
    pub flags: StdVideoAV1FilmGrainFlags,
    pub grain_scaling_minus_8: u8,
    pub ar_coeff_lag: u8,
    pub ar_coeff_shift_minus_6: u8,
    pub grain_scale_shift: u8,
    pub grain_seed: u16,
    pub film_grain_params_ref_idx: u8,
    pub num_y_points: u8,
    pub point_y_value: [u8; 14usize],
    pub point_y_scaling: [u8; 14usize],
    pub num_cb_points: u8,
    pub point_cb_value: [u8; 10usize],
    pub point_cb_scaling: [u8; 10usize],
    pub num_cr_points: u8,
    pub point_cr_value: [u8; 10usize],
    pub point_cr_scaling: [u8; 10usize],
    pub ar_coeffs_y_plus_128: [i8; 24usize],
    pub ar_coeffs_cb_plus_128: [i8; 25usize],
    pub ar_coeffs_cr_plus_128: [i8; 25usize],
    pub cb_mult: u8,
    pub cb_luma_mult: u8,
    pub cb_offset: u16,
    pub cr_mult: u8,
    pub cr_luma_mult: u8,
    pub cr_offset: u16,
}
#[test]
fn bindgen_test_layout_StdVideoAV1FilmGrain() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoAV1FilmGrain> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoAV1FilmGrain>(),
        164usize,
        concat!("Size of: ", stringify!(StdVideoAV1FilmGrain))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoAV1FilmGrain>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoAV1FilmGrain))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1FilmGrain),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).grain_scaling_minus_8) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1FilmGrain),
            "::",
            stringify!(grain_scaling_minus_8)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ar_coeff_lag) as usize - ptr as usize },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1FilmGrain),
            "::",
            stringify!(ar_coeff_lag)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ar_coeff_shift_minus_6) as usize - ptr as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1FilmGrain),
            "::",
            stringify!(ar_coeff_shift_minus_6)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).grain_scale_shift) as usize - ptr as usize },
        7usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1FilmGrain),
            "::",
            stringify!(grain_scale_shift)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).grain_seed) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1FilmGrain),
            "::",
            stringify!(grain_seed)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).film_grain_params_ref_idx) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1FilmGrain),
            "::",
            stringify!(film_grain_params_ref_idx)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).num_y_points) as usize - ptr as usize },
        11usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1FilmGrain),
            "::",
            stringify!(num_y_points)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).point_y_value) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1FilmGrain),
            "::",
            stringify!(point_y_value)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).point_y_scaling) as usize - ptr as usize },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1FilmGrain),
            "::",
            stringify!(point_y_scaling)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).num_cb_points) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1FilmGrain),
            "::",
            stringify!(num_cb_points)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).point_cb_value) as usize - ptr as usize },
        41usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1FilmGrain),
            "::",
            stringify!(point_cb_value)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).point_cb_scaling) as usize - ptr as usize },
        51usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1FilmGrain),
            "::",
            stringify!(point_cb_scaling)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).num_cr_points) as usize - ptr as usize },
        61usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1FilmGrain),
            "::",
            stringify!(num_cr_points)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).point_cr_value) as usize - ptr as usize },
        62usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1FilmGrain),
            "::",
            stringify!(point_cr_value)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).point_cr_scaling) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1FilmGrain),
            "::",
            stringify!(point_cr_scaling)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ar_coeffs_y_plus_128) as usize - ptr as usize },
        82usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1FilmGrain),
            "::",
            stringify!(ar_coeffs_y_plus_128)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ar_coeffs_cb_plus_128) as usize - ptr as usize },
        106usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1FilmGrain),
            "::",
            stringify!(ar_coeffs_cb_plus_128)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ar_coeffs_cr_plus_128) as usize - ptr as usize },
        131usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1FilmGrain),
            "::",
            stringify!(ar_coeffs_cr_plus_128)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cb_mult) as usize - ptr as usize },
        156usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1FilmGrain),
            "::",
            stringify!(cb_mult)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cb_luma_mult) as usize - ptr as usize },
        157usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1FilmGrain),
            "::",
            stringify!(cb_luma_mult)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cb_offset) as usize - ptr as usize },
        158usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1FilmGrain),
            "::",
            stringify!(cb_offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cr_mult) as usize - ptr as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1FilmGrain),
            "::",
            stringify!(cr_mult)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cr_luma_mult) as usize - ptr as usize },
        161usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1FilmGrain),
            "::",
            stringify!(cr_luma_mult)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cr_offset) as usize - ptr as usize },
        162usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1FilmGrain),
            "::",
            stringify!(cr_offset)
        )
    );
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoAV1SequenceHeaderFlags {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_StdVideoAV1SequenceHeaderFlags() {
    assert_eq!(
        ::core::mem::size_of::<StdVideoAV1SequenceHeaderFlags>(),
        4usize,
        concat!("Size of: ", stringify!(StdVideoAV1SequenceHeaderFlags))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoAV1SequenceHeaderFlags>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoAV1SequenceHeaderFlags))
    );
}
impl StdVideoAV1SequenceHeaderFlags {
    #[inline]
    pub fn still_picture(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_still_picture(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reduced_still_picture_header(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_reduced_still_picture_header(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn use_128x128_superblock(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_use_128x128_superblock(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn enable_filter_intra(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_enable_filter_intra(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn enable_intra_edge_filter(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_enable_intra_edge_filter(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn enable_interintra_compound(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_enable_interintra_compound(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn enable_masked_compound(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_enable_masked_compound(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn enable_warped_motion(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_enable_warped_motion(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn enable_dual_filter(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_enable_dual_filter(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn enable_order_hint(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_enable_order_hint(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn enable_jnt_comp(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_enable_jnt_comp(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn enable_ref_frame_mvs(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_enable_ref_frame_mvs(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn frame_id_numbers_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_frame_id_numbers_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn enable_superres(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_enable_superres(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn enable_cdef(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_enable_cdef(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn enable_restoration(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_enable_restoration(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn film_grain_params_present(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_film_grain_params_present(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn timing_info_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(17usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_timing_info_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(17usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn initial_display_delay_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(18usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_initial_display_delay_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(18usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(19usize, 13u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(19usize, 13u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        still_picture: u32,
        reduced_still_picture_header: u32,
        use_128x128_superblock: u32,
        enable_filter_intra: u32,
        enable_intra_edge_filter: u32,
        enable_interintra_compound: u32,
        enable_masked_compound: u32,
        enable_warped_motion: u32,
        enable_dual_filter: u32,
        enable_order_hint: u32,
        enable_jnt_comp: u32,
        enable_ref_frame_mvs: u32,
        frame_id_numbers_present_flag: u32,
        enable_superres: u32,
        enable_cdef: u32,
        enable_restoration: u32,
        film_grain_params_present: u32,
        timing_info_present_flag: u32,
        initial_display_delay_present_flag: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let still_picture: u32 = unsafe { ::core::mem::transmute(still_picture) };
            still_picture as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let reduced_still_picture_header: u32 =
                unsafe { ::core::mem::transmute(reduced_still_picture_header) };
            reduced_still_picture_header as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let use_128x128_superblock: u32 =
                unsafe { ::core::mem::transmute(use_128x128_superblock) };
            use_128x128_superblock as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let enable_filter_intra: u32 = unsafe { ::core::mem::transmute(enable_filter_intra) };
            enable_filter_intra as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let enable_intra_edge_filter: u32 =
                unsafe { ::core::mem::transmute(enable_intra_edge_filter) };
            enable_intra_edge_filter as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let enable_interintra_compound: u32 =
                unsafe { ::core::mem::transmute(enable_interintra_compound) };
            enable_interintra_compound as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let enable_masked_compound: u32 =
                unsafe { ::core::mem::transmute(enable_masked_compound) };
            enable_masked_compound as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let enable_warped_motion: u32 = unsafe { ::core::mem::transmute(enable_warped_motion) };
            enable_warped_motion as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let enable_dual_filter: u32 = unsafe { ::core::mem::transmute(enable_dual_filter) };
            enable_dual_filter as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let enable_order_hint: u32 = unsafe { ::core::mem::transmute(enable_order_hint) };
            enable_order_hint as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let enable_jnt_comp: u32 = unsafe { ::core::mem::transmute(enable_jnt_comp) };
            enable_jnt_comp as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let enable_ref_frame_mvs: u32 = unsafe { ::core::mem::transmute(enable_ref_frame_mvs) };
            enable_ref_frame_mvs as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let frame_id_numbers_present_flag: u32 =
                unsafe { ::core::mem::transmute(frame_id_numbers_present_flag) };
            frame_id_numbers_present_flag as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let enable_superres: u32 = unsafe { ::core::mem::transmute(enable_superres) };
            enable_superres as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let enable_cdef: u32 = unsafe { ::core::mem::transmute(enable_cdef) };
            enable_cdef as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let enable_restoration: u32 = unsafe { ::core::mem::transmute(enable_restoration) };
            enable_restoration as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let film_grain_params_present: u32 =
                unsafe { ::core::mem::transmute(film_grain_params_present) };
            film_grain_params_present as u64
        });
        __bindgen_bitfield_unit.set(17usize, 1u8, {
            let timing_info_present_flag: u32 =
                unsafe { ::core::mem::transmute(timing_info_present_flag) };
            timing_info_present_flag as u64
        });
        __bindgen_bitfield_unit.set(18usize, 1u8, {
            let initial_display_delay_present_flag: u32 =
                unsafe { ::core::mem::transmute(initial_display_delay_present_flag) };
            initial_display_delay_present_flag as u64
        });
        __bindgen_bitfield_unit.set(19usize, 13u8, {
            let reserved: u32 = unsafe { ::core::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoAV1SequenceHeader {
    pub flags: StdVideoAV1SequenceHeaderFlags,
    pub seq_profile: StdVideoAV1Profile,
    pub frame_width_bits_minus_1: u8,
    pub frame_height_bits_minus_1: u8,
    pub max_frame_width_minus_1: u16,
    pub max_frame_height_minus_1: u16,
    pub delta_frame_id_length_minus_2: u8,
    pub additional_frame_id_length_minus_1: u8,
    pub order_hint_bits_minus_1: u8,
    pub seq_force_integer_mv: u8,
    pub seq_force_screen_content_tools: u8,
    pub reserved1: [u8; 5usize],
    pub pColorConfig: *const StdVideoAV1ColorConfig,
    pub pTimingInfo: *const StdVideoAV1TimingInfo,
}
#[test]
fn bindgen_test_layout_StdVideoAV1SequenceHeader() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoAV1SequenceHeader> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoAV1SequenceHeader>(),
        40usize,
        concat!("Size of: ", stringify!(StdVideoAV1SequenceHeader))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoAV1SequenceHeader>(),
        8usize,
        concat!("Alignment of ", stringify!(StdVideoAV1SequenceHeader))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1SequenceHeader),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).seq_profile) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1SequenceHeader),
            "::",
            stringify!(seq_profile)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).frame_width_bits_minus_1) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1SequenceHeader),
            "::",
            stringify!(frame_width_bits_minus_1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).frame_height_bits_minus_1) as usize - ptr as usize },
        9usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1SequenceHeader),
            "::",
            stringify!(frame_height_bits_minus_1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).max_frame_width_minus_1) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1SequenceHeader),
            "::",
            stringify!(max_frame_width_minus_1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).max_frame_height_minus_1) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1SequenceHeader),
            "::",
            stringify!(max_frame_height_minus_1)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).delta_frame_id_length_minus_2) as usize - ptr as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1SequenceHeader),
            "::",
            stringify!(delta_frame_id_length_minus_2)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).additional_frame_id_length_minus_1) as usize - ptr as usize
        },
        15usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1SequenceHeader),
            "::",
            stringify!(additional_frame_id_length_minus_1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).order_hint_bits_minus_1) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1SequenceHeader),
            "::",
            stringify!(order_hint_bits_minus_1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).seq_force_integer_mv) as usize - ptr as usize },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1SequenceHeader),
            "::",
            stringify!(seq_force_integer_mv)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).seq_force_screen_content_tools) as usize - ptr as usize
        },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1SequenceHeader),
            "::",
            stringify!(seq_force_screen_content_tools)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved1) as usize - ptr as usize },
        19usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1SequenceHeader),
            "::",
            stringify!(reserved1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pColorConfig) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1SequenceHeader),
            "::",
            stringify!(pColorConfig)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pTimingInfo) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoAV1SequenceHeader),
            "::",
            stringify!(pTimingInfo)
        )
    );
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoDecodeAV1PictureInfoFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_StdVideoDecodeAV1PictureInfoFlags() {
    assert_eq!(
        ::core::mem::size_of::<StdVideoDecodeAV1PictureInfoFlags>(),
        4usize,
        concat!("Size of: ", stringify!(StdVideoDecodeAV1PictureInfoFlags))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoDecodeAV1PictureInfoFlags>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoDecodeAV1PictureInfoFlags)
        )
    );
}
impl StdVideoDecodeAV1PictureInfoFlags {
    #[inline]
    pub fn error_resilient_mode(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_error_resilient_mode(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn disable_cdf_update(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_disable_cdf_update(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn use_superres(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_use_superres(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn render_and_frame_size_different(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_render_and_frame_size_different(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn allow_screen_content_tools(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_allow_screen_content_tools(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_filter_switchable(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_filter_switchable(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn force_integer_mv(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_force_integer_mv(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn frame_size_override_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_frame_size_override_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn buffer_removal_time_present_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_buffer_removal_time_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn allow_intrabc(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_allow_intrabc(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn frame_refs_short_signaling(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_frame_refs_short_signaling(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn allow_high_precision_mv(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_allow_high_precision_mv(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_motion_mode_switchable(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_motion_mode_switchable(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn use_ref_frame_mvs(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_use_ref_frame_mvs(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn disable_frame_end_update_cdf(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_disable_frame_end_update_cdf(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn allow_warped_motion(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_allow_warped_motion(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reduced_tx_set(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_reduced_tx_set(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reference_select(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(17usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_reference_select(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(17usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn skip_mode_present(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(18usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_skip_mode_present(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(18usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn delta_q_present(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(19usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_delta_q_present(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(19usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn delta_lf_present(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(20usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_delta_lf_present(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(20usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn delta_lf_multi(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(21usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_delta_lf_multi(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(21usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn segmentation_enabled(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(22usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_segmentation_enabled(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(22usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn segmentation_update_map(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(23usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_segmentation_update_map(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(23usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn segmentation_temporal_update(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_segmentation_temporal_update(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn segmentation_update_data(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(25usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_segmentation_update_data(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(25usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn UsesLr(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(26usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_UsesLr(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(26usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn usesChromaLr(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(27usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_usesChromaLr(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(27usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn apply_grain(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(28usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_apply_grain(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(28usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(29usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(29usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        error_resilient_mode: u32,
        disable_cdf_update: u32,
        use_superres: u32,
        render_and_frame_size_different: u32,
        allow_screen_content_tools: u32,
        is_filter_switchable: u32,
        force_integer_mv: u32,
        frame_size_override_flag: u32,
        buffer_removal_time_present_flag: u32,
        allow_intrabc: u32,
        frame_refs_short_signaling: u32,
        allow_high_precision_mv: u32,
        is_motion_mode_switchable: u32,
        use_ref_frame_mvs: u32,
        disable_frame_end_update_cdf: u32,
        allow_warped_motion: u32,
        reduced_tx_set: u32,
        reference_select: u32,
        skip_mode_present: u32,
        delta_q_present: u32,
        delta_lf_present: u32,
        delta_lf_multi: u32,
        segmentation_enabled: u32,
        segmentation_update_map: u32,
        segmentation_temporal_update: u32,
        segmentation_update_data: u32,
        UsesLr: u32,
        usesChromaLr: u32,
        apply_grain: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let error_resilient_mode: u32 = unsafe { ::core::mem::transmute(error_resilient_mode) };
            error_resilient_mode as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let disable_cdf_update: u32 = unsafe { ::core::mem::transmute(disable_cdf_update) };
            disable_cdf_update as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let use_superres: u32 = unsafe { ::core::mem::transmute(use_superres) };
            use_superres as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let render_and_frame_size_different: u32 =
                unsafe { ::core::mem::transmute(render_and_frame_size_different) };
            render_and_frame_size_different as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let allow_screen_content_tools: u32 =
                unsafe { ::core::mem::transmute(allow_screen_content_tools) };
            allow_screen_content_tools as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let is_filter_switchable: u32 = unsafe { ::core::mem::transmute(is_filter_switchable) };
            is_filter_switchable as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let force_integer_mv: u32 = unsafe { ::core::mem::transmute(force_integer_mv) };
            force_integer_mv as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let frame_size_override_flag: u32 =
                unsafe { ::core::mem::transmute(frame_size_override_flag) };
            frame_size_override_flag as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let buffer_removal_time_present_flag: u32 =
                unsafe { ::core::mem::transmute(buffer_removal_time_present_flag) };
            buffer_removal_time_present_flag as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let allow_intrabc: u32 = unsafe { ::core::mem::transmute(allow_intrabc) };
            allow_intrabc as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let frame_refs_short_signaling: u32 =
                unsafe { ::core::mem::transmute(frame_refs_short_signaling) };
            frame_refs_short_signaling as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let allow_high_precision_mv: u32 =
                unsafe { ::core::mem::transmute(allow_high_precision_mv) };
            allow_high_precision_mv as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let is_motion_mode_switchable: u32 =
                unsafe { ::core::mem::transmute(is_motion_mode_switchable) };
            is_motion_mode_switchable as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let use_ref_frame_mvs: u32 = unsafe { ::core::mem::transmute(use_ref_frame_mvs) };
            use_ref_frame_mvs as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let disable_frame_end_update_cdf: u32 =
                unsafe { ::core::mem::transmute(disable_frame_end_update_cdf) };
            disable_frame_end_update_cdf as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let allow_warped_motion: u32 = unsafe { ::core::mem::transmute(allow_warped_motion) };
            allow_warped_motion as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let reduced_tx_set: u32 = unsafe { ::core::mem::transmute(reduced_tx_set) };
            reduced_tx_set as u64
        });
        __bindgen_bitfield_unit.set(17usize, 1u8, {
            let reference_select: u32 = unsafe { ::core::mem::transmute(reference_select) };
            reference_select as u64
        });
        __bindgen_bitfield_unit.set(18usize, 1u8, {
            let skip_mode_present: u32 = unsafe { ::core::mem::transmute(skip_mode_present) };
            skip_mode_present as u64
        });
        __bindgen_bitfield_unit.set(19usize, 1u8, {
            let delta_q_present: u32 = unsafe { ::core::mem::transmute(delta_q_present) };
            delta_q_present as u64
        });
        __bindgen_bitfield_unit.set(20usize, 1u8, {
            let delta_lf_present: u32 = unsafe { ::core::mem::transmute(delta_lf_present) };
            delta_lf_present as u64
        });
        __bindgen_bitfield_unit.set(21usize, 1u8, {
            let delta_lf_multi: u32 = unsafe { ::core::mem::transmute(delta_lf_multi) };
            delta_lf_multi as u64
        });
        __bindgen_bitfield_unit.set(22usize, 1u8, {
            let segmentation_enabled: u32 = unsafe { ::core::mem::transmute(segmentation_enabled) };
            segmentation_enabled as u64
        });
        __bindgen_bitfield_unit.set(23usize, 1u8, {
            let segmentation_update_map: u32 =
                unsafe { ::core::mem::transmute(segmentation_update_map) };
            segmentation_update_map as u64
        });
        __bindgen_bitfield_unit.set(24usize, 1u8, {
            let segmentation_temporal_update: u32 =
                unsafe { ::core::mem::transmute(segmentation_temporal_update) };
            segmentation_temporal_update as u64
        });
        __bindgen_bitfield_unit.set(25usize, 1u8, {
            let segmentation_update_data: u32 =
                unsafe { ::core::mem::transmute(segmentation_update_data) };
            segmentation_update_data as u64
        });
        __bindgen_bitfield_unit.set(26usize, 1u8, {
            let UsesLr: u32 = unsafe { ::core::mem::transmute(UsesLr) };
            UsesLr as u64
        });
        __bindgen_bitfield_unit.set(27usize, 1u8, {
            let usesChromaLr: u32 = unsafe { ::core::mem::transmute(usesChromaLr) };
            usesChromaLr as u64
        });
        __bindgen_bitfield_unit.set(28usize, 1u8, {
            let apply_grain: u32 = unsafe { ::core::mem::transmute(apply_grain) };
            apply_grain as u64
        });
        __bindgen_bitfield_unit.set(29usize, 3u8, {
            let reserved: u32 = unsafe { ::core::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoDecodeAV1PictureInfo {
    pub flags: StdVideoDecodeAV1PictureInfoFlags,
    pub frame_type: StdVideoAV1FrameType,
    pub current_frame_id: u32,
    pub OrderHint: u8,
    pub primary_ref_frame: u8,
    pub refresh_frame_flags: u8,
    pub reserved1: u8,
    pub interpolation_filter: StdVideoAV1InterpolationFilter,
    pub TxMode: StdVideoAV1TxMode,
    pub delta_q_res: u8,
    pub delta_lf_res: u8,
    pub SkipModeFrame: [u8; 2usize],
    pub coded_denom: u8,
    pub reserved2: [u8; 3usize],
    pub OrderHints: [u8; 8usize],
    pub expectedFrameId: [u32; 8usize],
    pub pTileInfo: *const StdVideoAV1TileInfo,
    pub pQuantization: *const StdVideoAV1Quantization,
    pub pSegmentation: *const StdVideoAV1Segmentation,
    pub pLoopFilter: *const StdVideoAV1LoopFilter,
    pub pCDEF: *const StdVideoAV1CDEF,
    pub pLoopRestoration: *const StdVideoAV1LoopRestoration,
    pub pGlobalMotion: *const StdVideoAV1GlobalMotion,
    pub pFilmGrain: *const StdVideoAV1FilmGrain,
}
#[test]
fn bindgen_test_layout_StdVideoDecodeAV1PictureInfo() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoDecodeAV1PictureInfo> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoDecodeAV1PictureInfo>(),
        136usize,
        concat!("Size of: ", stringify!(StdVideoDecodeAV1PictureInfo))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoDecodeAV1PictureInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(StdVideoDecodeAV1PictureInfo))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeAV1PictureInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).frame_type) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeAV1PictureInfo),
            "::",
            stringify!(frame_type)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).current_frame_id) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeAV1PictureInfo),
            "::",
            stringify!(current_frame_id)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).OrderHint) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeAV1PictureInfo),
            "::",
            stringify!(OrderHint)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).primary_ref_frame) as usize - ptr as usize },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeAV1PictureInfo),
            "::",
            stringify!(primary_ref_frame)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).refresh_frame_flags) as usize - ptr as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeAV1PictureInfo),
            "::",
            stringify!(refresh_frame_flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved1) as usize - ptr as usize },
        15usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeAV1PictureInfo),
            "::",
            stringify!(reserved1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).interpolation_filter) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeAV1PictureInfo),
            "::",
            stringify!(interpolation_filter)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).TxMode) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeAV1PictureInfo),
            "::",
            stringify!(TxMode)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).delta_q_res) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeAV1PictureInfo),
            "::",
            stringify!(delta_q_res)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).delta_lf_res) as usize - ptr as usize },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeAV1PictureInfo),
            "::",
            stringify!(delta_lf_res)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).SkipModeFrame) as usize - ptr as usize },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeAV1PictureInfo),
            "::",
            stringify!(SkipModeFrame)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).coded_denom) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeAV1PictureInfo),
            "::",
            stringify!(coded_denom)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved2) as usize - ptr as usize },
        29usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeAV1PictureInfo),
            "::",
            stringify!(reserved2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).OrderHints) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeAV1PictureInfo),
            "::",
            stringify!(OrderHints)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).expectedFrameId) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeAV1PictureInfo),
            "::",
            stringify!(expectedFrameId)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pTileInfo) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeAV1PictureInfo),
            "::",
            stringify!(pTileInfo)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pQuantization) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeAV1PictureInfo),
            "::",
            stringify!(pQuantization)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pSegmentation) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeAV1PictureInfo),
            "::",
            stringify!(pSegmentation)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pLoopFilter) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeAV1PictureInfo),
            "::",
            stringify!(pLoopFilter)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pCDEF) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeAV1PictureInfo),
            "::",
            stringify!(pCDEF)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pLoopRestoration) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeAV1PictureInfo),
            "::",
            stringify!(pLoopRestoration)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pGlobalMotion) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeAV1PictureInfo),
            "::",
            stringify!(pGlobalMotion)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pFilmGrain) as usize - ptr as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeAV1PictureInfo),
            "::",
            stringify!(pFilmGrain)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoDecodeAV1ReferenceInfoFlags {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_StdVideoDecodeAV1ReferenceInfoFlags() {
    assert_eq!(
        ::core::mem::size_of::<StdVideoDecodeAV1ReferenceInfoFlags>(),
        4usize,
        concat!("Size of: ", stringify!(StdVideoDecodeAV1ReferenceInfoFlags))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoDecodeAV1ReferenceInfoFlags>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoDecodeAV1ReferenceInfoFlags)
        )
    );
}
impl StdVideoDecodeAV1ReferenceInfoFlags {
    #[inline]
    pub fn disable_frame_end_update_cdf(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_disable_frame_end_update_cdf(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn segmentation_enabled(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_segmentation_enabled(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 30u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 30u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        disable_frame_end_update_cdf: u32,
        segmentation_enabled: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let disable_frame_end_update_cdf: u32 =
                unsafe { ::core::mem::transmute(disable_frame_end_update_cdf) };
            disable_frame_end_update_cdf as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let segmentation_enabled: u32 = unsafe { ::core::mem::transmute(segmentation_enabled) };
            segmentation_enabled as u64
        });
        __bindgen_bitfield_unit.set(2usize, 30u8, {
            let reserved: u32 = unsafe { ::core::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoDecodeAV1ReferenceInfo {
    pub flags: StdVideoDecodeAV1ReferenceInfoFlags,
    pub frame_type: u8,
    pub RefFrameSignBias: u8,
    pub OrderHint: u8,
    pub SavedOrderHints: [u8; 8usize],
}
#[test]
fn bindgen_test_layout_StdVideoDecodeAV1ReferenceInfo() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoDecodeAV1ReferenceInfo> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoDecodeAV1ReferenceInfo>(),
        16usize,
        concat!("Size of: ", stringify!(StdVideoDecodeAV1ReferenceInfo))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoDecodeAV1ReferenceInfo>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoDecodeAV1ReferenceInfo))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeAV1ReferenceInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).frame_type) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeAV1ReferenceInfo),
            "::",
            stringify!(frame_type)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RefFrameSignBias) as usize - ptr as usize },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeAV1ReferenceInfo),
            "::",
            stringify!(RefFrameSignBias)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).OrderHint) as usize - ptr as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeAV1ReferenceInfo),
            "::",
            stringify!(OrderHint)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).SavedOrderHints) as usize - ptr as usize },
        7usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeAV1ReferenceInfo),
            "::",
            stringify!(SavedOrderHints)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH264WeightTableFlags {
    pub luma_weight_l0_flag: u32,
    pub chroma_weight_l0_flag: u32,
    pub luma_weight_l1_flag: u32,
    pub chroma_weight_l1_flag: u32,
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH264WeightTableFlags() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoEncodeH264WeightTableFlags> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoEncodeH264WeightTableFlags>(),
        16usize,
        concat!("Size of: ", stringify!(StdVideoEncodeH264WeightTableFlags))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoEncodeH264WeightTableFlags>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoEncodeH264WeightTableFlags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).luma_weight_l0_flag) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264WeightTableFlags),
            "::",
            stringify!(luma_weight_l0_flag)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).chroma_weight_l0_flag) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264WeightTableFlags),
            "::",
            stringify!(chroma_weight_l0_flag)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).luma_weight_l1_flag) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264WeightTableFlags),
            "::",
            stringify!(luma_weight_l1_flag)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).chroma_weight_l1_flag) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264WeightTableFlags),
            "::",
            stringify!(chroma_weight_l1_flag)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH264WeightTable {
    pub flags: StdVideoEncodeH264WeightTableFlags,
    pub luma_log2_weight_denom: u8,
    pub chroma_log2_weight_denom: u8,
    pub luma_weight_l0: [i8; 32usize],
    pub luma_offset_l0: [i8; 32usize],
    pub chroma_weight_l0: [[i8; 2usize]; 32usize],
    pub chroma_offset_l0: [[i8; 2usize]; 32usize],
    pub luma_weight_l1: [i8; 32usize],
    pub luma_offset_l1: [i8; 32usize],
    pub chroma_weight_l1: [[i8; 2usize]; 32usize],
    pub chroma_offset_l1: [[i8; 2usize]; 32usize],
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH264WeightTable() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoEncodeH264WeightTable> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoEncodeH264WeightTable>(),
        404usize,
        concat!("Size of: ", stringify!(StdVideoEncodeH264WeightTable))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoEncodeH264WeightTable>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoEncodeH264WeightTable))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264WeightTable),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).luma_log2_weight_denom) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264WeightTable),
            "::",
            stringify!(luma_log2_weight_denom)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).chroma_log2_weight_denom) as usize - ptr as usize },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264WeightTable),
            "::",
            stringify!(chroma_log2_weight_denom)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).luma_weight_l0) as usize - ptr as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264WeightTable),
            "::",
            stringify!(luma_weight_l0)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).luma_offset_l0) as usize - ptr as usize },
        50usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264WeightTable),
            "::",
            stringify!(luma_offset_l0)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).chroma_weight_l0) as usize - ptr as usize },
        82usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264WeightTable),
            "::",
            stringify!(chroma_weight_l0)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).chroma_offset_l0) as usize - ptr as usize },
        146usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264WeightTable),
            "::",
            stringify!(chroma_offset_l0)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).luma_weight_l1) as usize - ptr as usize },
        210usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264WeightTable),
            "::",
            stringify!(luma_weight_l1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).luma_offset_l1) as usize - ptr as usize },
        242usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264WeightTable),
            "::",
            stringify!(luma_offset_l1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).chroma_weight_l1) as usize - ptr as usize },
        274usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264WeightTable),
            "::",
            stringify!(chroma_weight_l1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).chroma_offset_l1) as usize - ptr as usize },
        338usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264WeightTable),
            "::",
            stringify!(chroma_offset_l1)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH264SliceHeaderFlags {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH264SliceHeaderFlags() {
    assert_eq!(
        ::core::mem::size_of::<StdVideoEncodeH264SliceHeaderFlags>(),
        4usize,
        concat!("Size of: ", stringify!(StdVideoEncodeH264SliceHeaderFlags))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoEncodeH264SliceHeaderFlags>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoEncodeH264SliceHeaderFlags)
        )
    );
}
impl StdVideoEncodeH264SliceHeaderFlags {
    #[inline]
    pub fn direct_spatial_mv_pred_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_direct_spatial_mv_pred_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn num_ref_idx_active_override_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_num_ref_idx_active_override_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 30u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 30u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        direct_spatial_mv_pred_flag: u32,
        num_ref_idx_active_override_flag: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let direct_spatial_mv_pred_flag: u32 =
                unsafe { ::core::mem::transmute(direct_spatial_mv_pred_flag) };
            direct_spatial_mv_pred_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let num_ref_idx_active_override_flag: u32 =
                unsafe { ::core::mem::transmute(num_ref_idx_active_override_flag) };
            num_ref_idx_active_override_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 30u8, {
            let reserved: u32 = unsafe { ::core::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH264PictureInfoFlags {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH264PictureInfoFlags() {
    assert_eq!(
        ::core::mem::size_of::<StdVideoEncodeH264PictureInfoFlags>(),
        4usize,
        concat!("Size of: ", stringify!(StdVideoEncodeH264PictureInfoFlags))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoEncodeH264PictureInfoFlags>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoEncodeH264PictureInfoFlags)
        )
    );
}
impl StdVideoEncodeH264PictureInfoFlags {
    #[inline]
    pub fn IdrPicFlag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_IdrPicFlag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_reference(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_reference(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn no_output_of_prior_pics_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_no_output_of_prior_pics_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn long_term_reference_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_long_term_reference_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn adaptive_ref_pic_marking_mode_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_adaptive_ref_pic_marking_mode_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(5usize, 27u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(5usize, 27u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        IdrPicFlag: u32,
        is_reference: u32,
        no_output_of_prior_pics_flag: u32,
        long_term_reference_flag: u32,
        adaptive_ref_pic_marking_mode_flag: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let IdrPicFlag: u32 = unsafe { ::core::mem::transmute(IdrPicFlag) };
            IdrPicFlag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let is_reference: u32 = unsafe { ::core::mem::transmute(is_reference) };
            is_reference as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let no_output_of_prior_pics_flag: u32 =
                unsafe { ::core::mem::transmute(no_output_of_prior_pics_flag) };
            no_output_of_prior_pics_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let long_term_reference_flag: u32 =
                unsafe { ::core::mem::transmute(long_term_reference_flag) };
            long_term_reference_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let adaptive_ref_pic_marking_mode_flag: u32 =
                unsafe { ::core::mem::transmute(adaptive_ref_pic_marking_mode_flag) };
            adaptive_ref_pic_marking_mode_flag as u64
        });
        __bindgen_bitfield_unit.set(5usize, 27u8, {
            let reserved: u32 = unsafe { ::core::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH264ReferenceInfoFlags {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH264ReferenceInfoFlags() {
    assert_eq!(
        ::core::mem::size_of::<StdVideoEncodeH264ReferenceInfoFlags>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(StdVideoEncodeH264ReferenceInfoFlags)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoEncodeH264ReferenceInfoFlags>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoEncodeH264ReferenceInfoFlags)
        )
    );
}
impl StdVideoEncodeH264ReferenceInfoFlags {
    #[inline]
    pub fn used_for_long_term_reference(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_used_for_long_term_reference(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 31u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 31u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        used_for_long_term_reference: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let used_for_long_term_reference: u32 =
                unsafe { ::core::mem::transmute(used_for_long_term_reference) };
            used_for_long_term_reference as u64
        });
        __bindgen_bitfield_unit.set(1usize, 31u8, {
            let reserved: u32 = unsafe { ::core::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH264ReferenceListsInfoFlags {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH264ReferenceListsInfoFlags() {
    assert_eq!(
        ::core::mem::size_of::<StdVideoEncodeH264ReferenceListsInfoFlags>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(StdVideoEncodeH264ReferenceListsInfoFlags)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoEncodeH264ReferenceListsInfoFlags>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoEncodeH264ReferenceListsInfoFlags)
        )
    );
}
impl StdVideoEncodeH264ReferenceListsInfoFlags {
    #[inline]
    pub fn ref_pic_list_modification_flag_l0(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_ref_pic_list_modification_flag_l0(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn ref_pic_list_modification_flag_l1(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_ref_pic_list_modification_flag_l1(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 30u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 30u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        ref_pic_list_modification_flag_l0: u32,
        ref_pic_list_modification_flag_l1: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let ref_pic_list_modification_flag_l0: u32 =
                unsafe { ::core::mem::transmute(ref_pic_list_modification_flag_l0) };
            ref_pic_list_modification_flag_l0 as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let ref_pic_list_modification_flag_l1: u32 =
                unsafe { ::core::mem::transmute(ref_pic_list_modification_flag_l1) };
            ref_pic_list_modification_flag_l1 as u64
        });
        __bindgen_bitfield_unit.set(2usize, 30u8, {
            let reserved: u32 = unsafe { ::core::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH264RefListModEntry {
    pub modification_of_pic_nums_idc: StdVideoH264ModificationOfPicNumsIdc,
    pub abs_diff_pic_num_minus1: u16,
    pub long_term_pic_num: u16,
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH264RefListModEntry() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoEncodeH264RefListModEntry> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoEncodeH264RefListModEntry>(),
        8usize,
        concat!("Size of: ", stringify!(StdVideoEncodeH264RefListModEntry))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoEncodeH264RefListModEntry>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoEncodeH264RefListModEntry)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).modification_of_pic_nums_idc) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264RefListModEntry),
            "::",
            stringify!(modification_of_pic_nums_idc)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).abs_diff_pic_num_minus1) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264RefListModEntry),
            "::",
            stringify!(abs_diff_pic_num_minus1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).long_term_pic_num) as usize - ptr as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264RefListModEntry),
            "::",
            stringify!(long_term_pic_num)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH264RefPicMarkingEntry {
    pub memory_management_control_operation: StdVideoH264MemMgmtControlOp,
    pub difference_of_pic_nums_minus1: u16,
    pub long_term_pic_num: u16,
    pub long_term_frame_idx: u16,
    pub max_long_term_frame_idx_plus1: u16,
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH264RefPicMarkingEntry() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoEncodeH264RefPicMarkingEntry> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoEncodeH264RefPicMarkingEntry>(),
        12usize,
        concat!(
            "Size of: ",
            stringify!(StdVideoEncodeH264RefPicMarkingEntry)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoEncodeH264RefPicMarkingEntry>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoEncodeH264RefPicMarkingEntry)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).memory_management_control_operation) as usize
                - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264RefPicMarkingEntry),
            "::",
            stringify!(memory_management_control_operation)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).difference_of_pic_nums_minus1) as usize - ptr as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264RefPicMarkingEntry),
            "::",
            stringify!(difference_of_pic_nums_minus1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).long_term_pic_num) as usize - ptr as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264RefPicMarkingEntry),
            "::",
            stringify!(long_term_pic_num)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).long_term_frame_idx) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264RefPicMarkingEntry),
            "::",
            stringify!(long_term_frame_idx)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).max_long_term_frame_idx_plus1) as usize - ptr as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264RefPicMarkingEntry),
            "::",
            stringify!(max_long_term_frame_idx_plus1)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH264ReferenceListsInfo {
    pub flags: StdVideoEncodeH264ReferenceListsInfoFlags,
    pub num_ref_idx_l0_active_minus1: u8,
    pub num_ref_idx_l1_active_minus1: u8,
    pub RefPicList0: [u8; 32usize],
    pub RefPicList1: [u8; 32usize],
    pub refList0ModOpCount: u8,
    pub refList1ModOpCount: u8,
    pub refPicMarkingOpCount: u8,
    pub reserved1: [u8; 7usize],
    pub pRefList0ModOperations: *const StdVideoEncodeH264RefListModEntry,
    pub pRefList1ModOperations: *const StdVideoEncodeH264RefListModEntry,
    pub pRefPicMarkingOperations: *const StdVideoEncodeH264RefPicMarkingEntry,
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH264ReferenceListsInfo() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoEncodeH264ReferenceListsInfo> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoEncodeH264ReferenceListsInfo>(),
        104usize,
        concat!(
            "Size of: ",
            stringify!(StdVideoEncodeH264ReferenceListsInfo)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoEncodeH264ReferenceListsInfo>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoEncodeH264ReferenceListsInfo)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264ReferenceListsInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).num_ref_idx_l0_active_minus1) as usize - ptr as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264ReferenceListsInfo),
            "::",
            stringify!(num_ref_idx_l0_active_minus1)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).num_ref_idx_l1_active_minus1) as usize - ptr as usize
        },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264ReferenceListsInfo),
            "::",
            stringify!(num_ref_idx_l1_active_minus1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RefPicList0) as usize - ptr as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264ReferenceListsInfo),
            "::",
            stringify!(RefPicList0)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RefPicList1) as usize - ptr as usize },
        38usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264ReferenceListsInfo),
            "::",
            stringify!(RefPicList1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).refList0ModOpCount) as usize - ptr as usize },
        70usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264ReferenceListsInfo),
            "::",
            stringify!(refList0ModOpCount)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).refList1ModOpCount) as usize - ptr as usize },
        71usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264ReferenceListsInfo),
            "::",
            stringify!(refList1ModOpCount)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).refPicMarkingOpCount) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264ReferenceListsInfo),
            "::",
            stringify!(refPicMarkingOpCount)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved1) as usize - ptr as usize },
        73usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264ReferenceListsInfo),
            "::",
            stringify!(reserved1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pRefList0ModOperations) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264ReferenceListsInfo),
            "::",
            stringify!(pRefList0ModOperations)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pRefList1ModOperations) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264ReferenceListsInfo),
            "::",
            stringify!(pRefList1ModOperations)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pRefPicMarkingOperations) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264ReferenceListsInfo),
            "::",
            stringify!(pRefPicMarkingOperations)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH264PictureInfo {
    pub flags: StdVideoEncodeH264PictureInfoFlags,
    pub seq_parameter_set_id: u8,
    pub pic_parameter_set_id: u8,
    pub idr_pic_id: u16,
    pub primary_pic_type: StdVideoH264PictureType,
    pub frame_num: u32,
    pub PicOrderCnt: i32,
    pub temporal_id: u8,
    pub reserved1: [u8; 3usize],
    pub pRefLists: *const StdVideoEncodeH264ReferenceListsInfo,
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH264PictureInfo() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoEncodeH264PictureInfo> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoEncodeH264PictureInfo>(),
        32usize,
        concat!("Size of: ", stringify!(StdVideoEncodeH264PictureInfo))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoEncodeH264PictureInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(StdVideoEncodeH264PictureInfo))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264PictureInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).seq_parameter_set_id) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264PictureInfo),
            "::",
            stringify!(seq_parameter_set_id)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pic_parameter_set_id) as usize - ptr as usize },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264PictureInfo),
            "::",
            stringify!(pic_parameter_set_id)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).idr_pic_id) as usize - ptr as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264PictureInfo),
            "::",
            stringify!(idr_pic_id)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).primary_pic_type) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264PictureInfo),
            "::",
            stringify!(primary_pic_type)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).frame_num) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264PictureInfo),
            "::",
            stringify!(frame_num)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).PicOrderCnt) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264PictureInfo),
            "::",
            stringify!(PicOrderCnt)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).temporal_id) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264PictureInfo),
            "::",
            stringify!(temporal_id)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved1) as usize - ptr as usize },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264PictureInfo),
            "::",
            stringify!(reserved1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pRefLists) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264PictureInfo),
            "::",
            stringify!(pRefLists)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH264ReferenceInfo {
    pub flags: StdVideoEncodeH264ReferenceInfoFlags,
    pub primary_pic_type: StdVideoH264PictureType,
    pub FrameNum: u32,
    pub PicOrderCnt: i32,
    pub long_term_pic_num: u16,
    pub long_term_frame_idx: u16,
    pub temporal_id: u8,
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH264ReferenceInfo() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoEncodeH264ReferenceInfo> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoEncodeH264ReferenceInfo>(),
        24usize,
        concat!("Size of: ", stringify!(StdVideoEncodeH264ReferenceInfo))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoEncodeH264ReferenceInfo>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoEncodeH264ReferenceInfo))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264ReferenceInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).primary_pic_type) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264ReferenceInfo),
            "::",
            stringify!(primary_pic_type)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).FrameNum) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264ReferenceInfo),
            "::",
            stringify!(FrameNum)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).PicOrderCnt) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264ReferenceInfo),
            "::",
            stringify!(PicOrderCnt)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).long_term_pic_num) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264ReferenceInfo),
            "::",
            stringify!(long_term_pic_num)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).long_term_frame_idx) as usize - ptr as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264ReferenceInfo),
            "::",
            stringify!(long_term_frame_idx)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).temporal_id) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264ReferenceInfo),
            "::",
            stringify!(temporal_id)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH264SliceHeader {
    pub flags: StdVideoEncodeH264SliceHeaderFlags,
    pub first_mb_in_slice: u32,
    pub slice_type: StdVideoH264SliceType,
    pub slice_alpha_c0_offset_div2: i8,
    pub slice_beta_offset_div2: i8,
    pub slice_qp_delta: i8,
    pub reserved1: u8,
    pub cabac_init_idc: StdVideoH264CabacInitIdc,
    pub disable_deblocking_filter_idc: StdVideoH264DisableDeblockingFilterIdc,
    pub pWeightTable: *const StdVideoEncodeH264WeightTable,
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH264SliceHeader() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoEncodeH264SliceHeader> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoEncodeH264SliceHeader>(),
        32usize,
        concat!("Size of: ", stringify!(StdVideoEncodeH264SliceHeader))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoEncodeH264SliceHeader>(),
        8usize,
        concat!("Alignment of ", stringify!(StdVideoEncodeH264SliceHeader))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264SliceHeader),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).first_mb_in_slice) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264SliceHeader),
            "::",
            stringify!(first_mb_in_slice)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).slice_type) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264SliceHeader),
            "::",
            stringify!(slice_type)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).slice_alpha_c0_offset_div2) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264SliceHeader),
            "::",
            stringify!(slice_alpha_c0_offset_div2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).slice_beta_offset_div2) as usize - ptr as usize },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264SliceHeader),
            "::",
            stringify!(slice_beta_offset_div2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).slice_qp_delta) as usize - ptr as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264SliceHeader),
            "::",
            stringify!(slice_qp_delta)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved1) as usize - ptr as usize },
        15usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264SliceHeader),
            "::",
            stringify!(reserved1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cabac_init_idc) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264SliceHeader),
            "::",
            stringify!(cabac_init_idc)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).disable_deblocking_filter_idc) as usize - ptr as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264SliceHeader),
            "::",
            stringify!(disable_deblocking_filter_idc)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pWeightTable) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264SliceHeader),
            "::",
            stringify!(pWeightTable)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH265WeightTableFlags {
    pub luma_weight_l0_flag: u16,
    pub chroma_weight_l0_flag: u16,
    pub luma_weight_l1_flag: u16,
    pub chroma_weight_l1_flag: u16,
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH265WeightTableFlags() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoEncodeH265WeightTableFlags> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoEncodeH265WeightTableFlags>(),
        8usize,
        concat!("Size of: ", stringify!(StdVideoEncodeH265WeightTableFlags))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoEncodeH265WeightTableFlags>(),
        2usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoEncodeH265WeightTableFlags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).luma_weight_l0_flag) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265WeightTableFlags),
            "::",
            stringify!(luma_weight_l0_flag)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).chroma_weight_l0_flag) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265WeightTableFlags),
            "::",
            stringify!(chroma_weight_l0_flag)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).luma_weight_l1_flag) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265WeightTableFlags),
            "::",
            stringify!(luma_weight_l1_flag)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).chroma_weight_l1_flag) as usize - ptr as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265WeightTableFlags),
            "::",
            stringify!(chroma_weight_l1_flag)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH265WeightTable {
    pub flags: StdVideoEncodeH265WeightTableFlags,
    pub luma_log2_weight_denom: u8,
    pub delta_chroma_log2_weight_denom: i8,
    pub delta_luma_weight_l0: [i8; 15usize],
    pub luma_offset_l0: [i8; 15usize],
    pub delta_chroma_weight_l0: [[i8; 2usize]; 15usize],
    pub delta_chroma_offset_l0: [[i8; 2usize]; 15usize],
    pub delta_luma_weight_l1: [i8; 15usize],
    pub luma_offset_l1: [i8; 15usize],
    pub delta_chroma_weight_l1: [[i8; 2usize]; 15usize],
    pub delta_chroma_offset_l1: [[i8; 2usize]; 15usize],
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH265WeightTable() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoEncodeH265WeightTable> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoEncodeH265WeightTable>(),
        190usize,
        concat!("Size of: ", stringify!(StdVideoEncodeH265WeightTable))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoEncodeH265WeightTable>(),
        2usize,
        concat!("Alignment of ", stringify!(StdVideoEncodeH265WeightTable))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265WeightTable),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).luma_log2_weight_denom) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265WeightTable),
            "::",
            stringify!(luma_log2_weight_denom)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).delta_chroma_log2_weight_denom) as usize - ptr as usize
        },
        9usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265WeightTable),
            "::",
            stringify!(delta_chroma_log2_weight_denom)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).delta_luma_weight_l0) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265WeightTable),
            "::",
            stringify!(delta_luma_weight_l0)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).luma_offset_l0) as usize - ptr as usize },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265WeightTable),
            "::",
            stringify!(luma_offset_l0)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).delta_chroma_weight_l0) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265WeightTable),
            "::",
            stringify!(delta_chroma_weight_l0)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).delta_chroma_offset_l0) as usize - ptr as usize },
        70usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265WeightTable),
            "::",
            stringify!(delta_chroma_offset_l0)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).delta_luma_weight_l1) as usize - ptr as usize },
        100usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265WeightTable),
            "::",
            stringify!(delta_luma_weight_l1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).luma_offset_l1) as usize - ptr as usize },
        115usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265WeightTable),
            "::",
            stringify!(luma_offset_l1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).delta_chroma_weight_l1) as usize - ptr as usize },
        130usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265WeightTable),
            "::",
            stringify!(delta_chroma_weight_l1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).delta_chroma_offset_l1) as usize - ptr as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265WeightTable),
            "::",
            stringify!(delta_chroma_offset_l1)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH265SliceSegmentHeaderFlags {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH265SliceSegmentHeaderFlags() {
    assert_eq!(
        ::core::mem::size_of::<StdVideoEncodeH265SliceSegmentHeaderFlags>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(StdVideoEncodeH265SliceSegmentHeaderFlags)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoEncodeH265SliceSegmentHeaderFlags>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoEncodeH265SliceSegmentHeaderFlags)
        )
    );
}
impl StdVideoEncodeH265SliceSegmentHeaderFlags {
    #[inline]
    pub fn first_slice_segment_in_pic_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_first_slice_segment_in_pic_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn dependent_slice_segment_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_dependent_slice_segment_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn slice_sao_luma_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_slice_sao_luma_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn slice_sao_chroma_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_slice_sao_chroma_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn num_ref_idx_active_override_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_num_ref_idx_active_override_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn mvd_l1_zero_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_mvd_l1_zero_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cabac_init_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cabac_init_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cu_chroma_qp_offset_enabled_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cu_chroma_qp_offset_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn deblocking_filter_override_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_deblocking_filter_override_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn slice_deblocking_filter_disabled_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_slice_deblocking_filter_disabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn collocated_from_l0_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_collocated_from_l0_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn slice_loop_filter_across_slices_enabled_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_slice_loop_filter_across_slices_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(12usize, 20u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(12usize, 20u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        first_slice_segment_in_pic_flag: u32,
        dependent_slice_segment_flag: u32,
        slice_sao_luma_flag: u32,
        slice_sao_chroma_flag: u32,
        num_ref_idx_active_override_flag: u32,
        mvd_l1_zero_flag: u32,
        cabac_init_flag: u32,
        cu_chroma_qp_offset_enabled_flag: u32,
        deblocking_filter_override_flag: u32,
        slice_deblocking_filter_disabled_flag: u32,
        collocated_from_l0_flag: u32,
        slice_loop_filter_across_slices_enabled_flag: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let first_slice_segment_in_pic_flag: u32 =
                unsafe { ::core::mem::transmute(first_slice_segment_in_pic_flag) };
            first_slice_segment_in_pic_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let dependent_slice_segment_flag: u32 =
                unsafe { ::core::mem::transmute(dependent_slice_segment_flag) };
            dependent_slice_segment_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let slice_sao_luma_flag: u32 = unsafe { ::core::mem::transmute(slice_sao_luma_flag) };
            slice_sao_luma_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let slice_sao_chroma_flag: u32 =
                unsafe { ::core::mem::transmute(slice_sao_chroma_flag) };
            slice_sao_chroma_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let num_ref_idx_active_override_flag: u32 =
                unsafe { ::core::mem::transmute(num_ref_idx_active_override_flag) };
            num_ref_idx_active_override_flag as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let mvd_l1_zero_flag: u32 = unsafe { ::core::mem::transmute(mvd_l1_zero_flag) };
            mvd_l1_zero_flag as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let cabac_init_flag: u32 = unsafe { ::core::mem::transmute(cabac_init_flag) };
            cabac_init_flag as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let cu_chroma_qp_offset_enabled_flag: u32 =
                unsafe { ::core::mem::transmute(cu_chroma_qp_offset_enabled_flag) };
            cu_chroma_qp_offset_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let deblocking_filter_override_flag: u32 =
                unsafe { ::core::mem::transmute(deblocking_filter_override_flag) };
            deblocking_filter_override_flag as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let slice_deblocking_filter_disabled_flag: u32 =
                unsafe { ::core::mem::transmute(slice_deblocking_filter_disabled_flag) };
            slice_deblocking_filter_disabled_flag as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let collocated_from_l0_flag: u32 =
                unsafe { ::core::mem::transmute(collocated_from_l0_flag) };
            collocated_from_l0_flag as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let slice_loop_filter_across_slices_enabled_flag: u32 =
                unsafe { ::core::mem::transmute(slice_loop_filter_across_slices_enabled_flag) };
            slice_loop_filter_across_slices_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(12usize, 20u8, {
            let reserved: u32 = unsafe { ::core::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH265SliceSegmentHeader {
    pub flags: StdVideoEncodeH265SliceSegmentHeaderFlags,
    pub slice_type: StdVideoH265SliceType,
    pub slice_segment_address: u32,
    pub collocated_ref_idx: u8,
    pub MaxNumMergeCand: u8,
    pub slice_cb_qp_offset: i8,
    pub slice_cr_qp_offset: i8,
    pub slice_beta_offset_div2: i8,
    pub slice_tc_offset_div2: i8,
    pub slice_act_y_qp_offset: i8,
    pub slice_act_cb_qp_offset: i8,
    pub slice_act_cr_qp_offset: i8,
    pub slice_qp_delta: i8,
    pub reserved1: u16,
    pub pWeightTable: *const StdVideoEncodeH265WeightTable,
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH265SliceSegmentHeader() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoEncodeH265SliceSegmentHeader> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoEncodeH265SliceSegmentHeader>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(StdVideoEncodeH265SliceSegmentHeader)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoEncodeH265SliceSegmentHeader>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoEncodeH265SliceSegmentHeader)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265SliceSegmentHeader),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).slice_type) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265SliceSegmentHeader),
            "::",
            stringify!(slice_type)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).slice_segment_address) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265SliceSegmentHeader),
            "::",
            stringify!(slice_segment_address)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).collocated_ref_idx) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265SliceSegmentHeader),
            "::",
            stringify!(collocated_ref_idx)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).MaxNumMergeCand) as usize - ptr as usize },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265SliceSegmentHeader),
            "::",
            stringify!(MaxNumMergeCand)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).slice_cb_qp_offset) as usize - ptr as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265SliceSegmentHeader),
            "::",
            stringify!(slice_cb_qp_offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).slice_cr_qp_offset) as usize - ptr as usize },
        15usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265SliceSegmentHeader),
            "::",
            stringify!(slice_cr_qp_offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).slice_beta_offset_div2) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265SliceSegmentHeader),
            "::",
            stringify!(slice_beta_offset_div2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).slice_tc_offset_div2) as usize - ptr as usize },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265SliceSegmentHeader),
            "::",
            stringify!(slice_tc_offset_div2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).slice_act_y_qp_offset) as usize - ptr as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265SliceSegmentHeader),
            "::",
            stringify!(slice_act_y_qp_offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).slice_act_cb_qp_offset) as usize - ptr as usize },
        19usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265SliceSegmentHeader),
            "::",
            stringify!(slice_act_cb_qp_offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).slice_act_cr_qp_offset) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265SliceSegmentHeader),
            "::",
            stringify!(slice_act_cr_qp_offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).slice_qp_delta) as usize - ptr as usize },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265SliceSegmentHeader),
            "::",
            stringify!(slice_qp_delta)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved1) as usize - ptr as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265SliceSegmentHeader),
            "::",
            stringify!(reserved1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pWeightTable) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265SliceSegmentHeader),
            "::",
            stringify!(pWeightTable)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH265ReferenceListsInfoFlags {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH265ReferenceListsInfoFlags() {
    assert_eq!(
        ::core::mem::size_of::<StdVideoEncodeH265ReferenceListsInfoFlags>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(StdVideoEncodeH265ReferenceListsInfoFlags)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoEncodeH265ReferenceListsInfoFlags>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoEncodeH265ReferenceListsInfoFlags)
        )
    );
}
impl StdVideoEncodeH265ReferenceListsInfoFlags {
    #[inline]
    pub fn ref_pic_list_modification_flag_l0(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_ref_pic_list_modification_flag_l0(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn ref_pic_list_modification_flag_l1(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_ref_pic_list_modification_flag_l1(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 30u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 30u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        ref_pic_list_modification_flag_l0: u32,
        ref_pic_list_modification_flag_l1: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let ref_pic_list_modification_flag_l0: u32 =
                unsafe { ::core::mem::transmute(ref_pic_list_modification_flag_l0) };
            ref_pic_list_modification_flag_l0 as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let ref_pic_list_modification_flag_l1: u32 =
                unsafe { ::core::mem::transmute(ref_pic_list_modification_flag_l1) };
            ref_pic_list_modification_flag_l1 as u64
        });
        __bindgen_bitfield_unit.set(2usize, 30u8, {
            let reserved: u32 = unsafe { ::core::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH265ReferenceListsInfo {
    pub flags: StdVideoEncodeH265ReferenceListsInfoFlags,
    pub num_ref_idx_l0_active_minus1: u8,
    pub num_ref_idx_l1_active_minus1: u8,
    pub RefPicList0: [u8; 15usize],
    pub RefPicList1: [u8; 15usize],
    pub list_entry_l0: [u8; 15usize],
    pub list_entry_l1: [u8; 15usize],
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH265ReferenceListsInfo() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoEncodeH265ReferenceListsInfo> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoEncodeH265ReferenceListsInfo>(),
        68usize,
        concat!(
            "Size of: ",
            stringify!(StdVideoEncodeH265ReferenceListsInfo)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoEncodeH265ReferenceListsInfo>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoEncodeH265ReferenceListsInfo)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265ReferenceListsInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).num_ref_idx_l0_active_minus1) as usize - ptr as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265ReferenceListsInfo),
            "::",
            stringify!(num_ref_idx_l0_active_minus1)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).num_ref_idx_l1_active_minus1) as usize - ptr as usize
        },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265ReferenceListsInfo),
            "::",
            stringify!(num_ref_idx_l1_active_minus1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RefPicList0) as usize - ptr as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265ReferenceListsInfo),
            "::",
            stringify!(RefPicList0)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RefPicList1) as usize - ptr as usize },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265ReferenceListsInfo),
            "::",
            stringify!(RefPicList1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).list_entry_l0) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265ReferenceListsInfo),
            "::",
            stringify!(list_entry_l0)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).list_entry_l1) as usize - ptr as usize },
        51usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265ReferenceListsInfo),
            "::",
            stringify!(list_entry_l1)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH265PictureInfoFlags {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH265PictureInfoFlags() {
    assert_eq!(
        ::core::mem::size_of::<StdVideoEncodeH265PictureInfoFlags>(),
        4usize,
        concat!("Size of: ", stringify!(StdVideoEncodeH265PictureInfoFlags))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoEncodeH265PictureInfoFlags>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoEncodeH265PictureInfoFlags)
        )
    );
}
impl StdVideoEncodeH265PictureInfoFlags {
    #[inline]
    pub fn is_reference(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_reference(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn IrapPicFlag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_IrapPicFlag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn used_for_long_term_reference(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_used_for_long_term_reference(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn discardable_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_discardable_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cross_layer_bla_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cross_layer_bla_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pic_output_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pic_output_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn no_output_of_prior_pics_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_no_output_of_prior_pics_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn short_term_ref_pic_set_sps_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_short_term_ref_pic_set_sps_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn slice_temporal_mvp_enabled_flag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_slice_temporal_mvp_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(9usize, 23u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(9usize, 23u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        is_reference: u32,
        IrapPicFlag: u32,
        used_for_long_term_reference: u32,
        discardable_flag: u32,
        cross_layer_bla_flag: u32,
        pic_output_flag: u32,
        no_output_of_prior_pics_flag: u32,
        short_term_ref_pic_set_sps_flag: u32,
        slice_temporal_mvp_enabled_flag: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let is_reference: u32 = unsafe { ::core::mem::transmute(is_reference) };
            is_reference as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let IrapPicFlag: u32 = unsafe { ::core::mem::transmute(IrapPicFlag) };
            IrapPicFlag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let used_for_long_term_reference: u32 =
                unsafe { ::core::mem::transmute(used_for_long_term_reference) };
            used_for_long_term_reference as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let discardable_flag: u32 = unsafe { ::core::mem::transmute(discardable_flag) };
            discardable_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let cross_layer_bla_flag: u32 = unsafe { ::core::mem::transmute(cross_layer_bla_flag) };
            cross_layer_bla_flag as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let pic_output_flag: u32 = unsafe { ::core::mem::transmute(pic_output_flag) };
            pic_output_flag as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let no_output_of_prior_pics_flag: u32 =
                unsafe { ::core::mem::transmute(no_output_of_prior_pics_flag) };
            no_output_of_prior_pics_flag as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let short_term_ref_pic_set_sps_flag: u32 =
                unsafe { ::core::mem::transmute(short_term_ref_pic_set_sps_flag) };
            short_term_ref_pic_set_sps_flag as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let slice_temporal_mvp_enabled_flag: u32 =
                unsafe { ::core::mem::transmute(slice_temporal_mvp_enabled_flag) };
            slice_temporal_mvp_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(9usize, 23u8, {
            let reserved: u32 = unsafe { ::core::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH265LongTermRefPics {
    pub num_long_term_sps: u8,
    pub num_long_term_pics: u8,
    pub lt_idx_sps: [u8; 32usize],
    pub poc_lsb_lt: [u8; 16usize],
    pub used_by_curr_pic_lt_flag: u16,
    pub delta_poc_msb_present_flag: [u8; 48usize],
    pub delta_poc_msb_cycle_lt: [u8; 48usize],
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH265LongTermRefPics() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoEncodeH265LongTermRefPics> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoEncodeH265LongTermRefPics>(),
        148usize,
        concat!("Size of: ", stringify!(StdVideoEncodeH265LongTermRefPics))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoEncodeH265LongTermRefPics>(),
        2usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoEncodeH265LongTermRefPics)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).num_long_term_sps) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265LongTermRefPics),
            "::",
            stringify!(num_long_term_sps)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).num_long_term_pics) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265LongTermRefPics),
            "::",
            stringify!(num_long_term_pics)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).lt_idx_sps) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265LongTermRefPics),
            "::",
            stringify!(lt_idx_sps)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).poc_lsb_lt) as usize - ptr as usize },
        34usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265LongTermRefPics),
            "::",
            stringify!(poc_lsb_lt)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).used_by_curr_pic_lt_flag) as usize - ptr as usize },
        50usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265LongTermRefPics),
            "::",
            stringify!(used_by_curr_pic_lt_flag)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).delta_poc_msb_present_flag) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265LongTermRefPics),
            "::",
            stringify!(delta_poc_msb_present_flag)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).delta_poc_msb_cycle_lt) as usize - ptr as usize },
        100usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265LongTermRefPics),
            "::",
            stringify!(delta_poc_msb_cycle_lt)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH265PictureInfo {
    pub flags: StdVideoEncodeH265PictureInfoFlags,
    pub pic_type: StdVideoH265PictureType,
    pub sps_video_parameter_set_id: u8,
    pub pps_seq_parameter_set_id: u8,
    pub pps_pic_parameter_set_id: u8,
    pub short_term_ref_pic_set_idx: u8,
    pub PicOrderCntVal: i32,
    pub TemporalId: u8,
    pub reserved1: [u8; 7usize],
    pub pRefLists: *const StdVideoEncodeH265ReferenceListsInfo,
    pub pShortTermRefPicSet: *const StdVideoH265ShortTermRefPicSet,
    pub pLongTermRefPics: *const StdVideoEncodeH265LongTermRefPics,
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH265PictureInfo() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoEncodeH265PictureInfo> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoEncodeH265PictureInfo>(),
        48usize,
        concat!("Size of: ", stringify!(StdVideoEncodeH265PictureInfo))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoEncodeH265PictureInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(StdVideoEncodeH265PictureInfo))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265PictureInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pic_type) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265PictureInfo),
            "::",
            stringify!(pic_type)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).sps_video_parameter_set_id) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265PictureInfo),
            "::",
            stringify!(sps_video_parameter_set_id)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pps_seq_parameter_set_id) as usize - ptr as usize },
        9usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265PictureInfo),
            "::",
            stringify!(pps_seq_parameter_set_id)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pps_pic_parameter_set_id) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265PictureInfo),
            "::",
            stringify!(pps_pic_parameter_set_id)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).short_term_ref_pic_set_idx) as usize - ptr as usize },
        11usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265PictureInfo),
            "::",
            stringify!(short_term_ref_pic_set_idx)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).PicOrderCntVal) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265PictureInfo),
            "::",
            stringify!(PicOrderCntVal)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).TemporalId) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265PictureInfo),
            "::",
            stringify!(TemporalId)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved1) as usize - ptr as usize },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265PictureInfo),
            "::",
            stringify!(reserved1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pRefLists) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265PictureInfo),
            "::",
            stringify!(pRefLists)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pShortTermRefPicSet) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265PictureInfo),
            "::",
            stringify!(pShortTermRefPicSet)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pLongTermRefPics) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265PictureInfo),
            "::",
            stringify!(pLongTermRefPics)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH265ReferenceInfoFlags {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH265ReferenceInfoFlags() {
    assert_eq!(
        ::core::mem::size_of::<StdVideoEncodeH265ReferenceInfoFlags>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(StdVideoEncodeH265ReferenceInfoFlags)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoEncodeH265ReferenceInfoFlags>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoEncodeH265ReferenceInfoFlags)
        )
    );
}
impl StdVideoEncodeH265ReferenceInfoFlags {
    #[inline]
    pub fn used_for_long_term_reference(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_used_for_long_term_reference(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn unused_for_reference(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_unused_for_reference(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 30u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 30u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        used_for_long_term_reference: u32,
        unused_for_reference: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let used_for_long_term_reference: u32 =
                unsafe { ::core::mem::transmute(used_for_long_term_reference) };
            used_for_long_term_reference as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let unused_for_reference: u32 = unsafe { ::core::mem::transmute(unused_for_reference) };
            unused_for_reference as u64
        });
        __bindgen_bitfield_unit.set(2usize, 30u8, {
            let reserved: u32 = unsafe { ::core::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH265ReferenceInfo {
    pub flags: StdVideoEncodeH265ReferenceInfoFlags,
    pub pic_type: StdVideoH265PictureType,
    pub PicOrderCntVal: i32,
    pub TemporalId: u8,
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH265ReferenceInfo() {
    const UNINIT: ::core::mem::MaybeUninit<StdVideoEncodeH265ReferenceInfo> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<StdVideoEncodeH265ReferenceInfo>(),
        16usize,
        concat!("Size of: ", stringify!(StdVideoEncodeH265ReferenceInfo))
    );
    assert_eq!(
        ::core::mem::align_of::<StdVideoEncodeH265ReferenceInfo>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoEncodeH265ReferenceInfo))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265ReferenceInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pic_type) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265ReferenceInfo),
            "::",
            stringify!(pic_type)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).PicOrderCntVal) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265ReferenceInfo),
            "::",
            stringify!(PicOrderCntVal)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).TemporalId) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265ReferenceInfo),
            "::",
            stringify!(TemporalId)
        )
    );
}
