Found `staticlib` `..` instead of `rlib` or `dylib`.

Consider the following two files:

`a.rs`
```ignore (cannot-link-with-other-tests)
#![crate_type = "staticlib"]

fn foo() {}
```

`main.rs`
```ignore (cannot-link-with-other-tests)
extern crate a;

fn main() {
    a::foo();
}
```

Crate `a` is compiled as a `staticlib`. A `staticlib` is a system-dependant
library only intended for linking with non-Rust applications (C programs). Note
that `staticlib`s include all upstream dependencies (`core`, `std`, other user
dependencies, etc) which makes them significantly larger than `dylib`s:
prefer `staticlib` for linking with C programs. Learn more about different
`crate_type`s in [this section of the Reference](../reference/linkage.html).

This error can be fixed by:
 * Using [Cargo](../cargo/index.html), the Rust package manager, automatically
   fixing this issue.
 * Recompiling the crate as a `rlib` or `dylib`; formats suitable for Rust
   linking.
