#ifndef INCLUDED_CRONENTRY_
#define INCLUDED_CRONENTRY_

#include <iosfwd>
#include <set>
#include <vector>
#include <string>

class CronEntry
{
    using SizeSet = std::set<size_t>;

    friend std::ostream &operator<<(std::ostream &out, CronEntry const &entry);

    size_t              d_begin  = 0;
    size_t              d_end = 0;
    std::vector<std::string> const *d_environment;

    SizeSet    d_minutes;
    SizeSet    d_hours;
    SizeSet    d_dayOfMonth;
    SizeSet    d_monthOfYear;
    SizeSet    d_dayOfWeek;

    std::string         d_command;

    public:
        enum
        {
            STAR = 100                  // * used to specify time
        };

        void setEnvironment(size_t begin, size_t end, 
                          std::vector<std::string> const *environment);

        void setCommand(std::string const &src);                        // .f
        void setMinutes(SizeSet &&src);                                 // .f
        void setHours(SizeSet &&src);                                   // .f
        void setDayOfMonth(SizeSet &&src);                              // .f
        void setMonthOfYear(SizeSet &&src);                             // .f
        void setDayOfWeek(SizeSet &&src);                               // .f

        size_t nSettings() const;                                       // .f
        std::string const &command() const;                             // .f

        SizeSet const &minutes() const;                                 // .f
        SizeSet const &hours() const;                                   // .f
        SizeSet const &dayOfMonth() const;                              // .f
        SizeSet const &monthOfYear() const;                             // .f
        SizeSet const &dayOfWeek() const;                               // .f

        std::ostream &insert(std::ostream &out) const;

    private:
        static void showSet(std::ostream &out, SizeSet const &nrSet);
};

#include "cronentry.f"

#endif







