/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.CreationTool;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FloatingTextField;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.util.ResourceBundleUtil;

public class TextCreationTool
extends CreationTool
implements ActionListener {
    private FloatingTextField textField;
    private TextHolderFigure typingTarget;

    public TextCreationTool(TextHolderFigure textHolderFigure) {
        super(textHolderFigure);
    }

    public TextCreationTool(TextHolderFigure textHolderFigure, Map<AttributeKey, Object> map) {
        super(textHolderFigure, map);
    }

    @Override
    public void deactivate(DrawingEditor drawingEditor) {
        this.endEdit();
        super.deactivate(drawingEditor);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        TextHolderFigure textHolderFigure = null;
        DrawingView drawingView = this.getView();
        Point2D.Double double_ = drawingView.viewToDrawing(mouseEvent.getPoint());
        Figure figure = null;
        for (Figure figure2 : drawingView.getSelectedFigures()) {
            if (!figure2.contains(double_)) continue;
            figure = figure2;
            break;
        }
        if (figure == null) {
            figure = this.getDrawing().findFigureInside(double_);
        }
        if (figure instanceof TextHolderFigure) {
            textHolderFigure = ((TextHolderFigure)figure).getLabelFor();
            textHolderFigure = null;
        }
        if (textHolderFigure != null) {
            this.beginEdit(textHolderFigure);
            this.updateCursor(this.getView(), mouseEvent.getPoint());
            return;
        }
        if (this.typingTarget != null) {
            this.endEdit();
            if (this.isToolDoneAfterCreation()) {
                this.fireToolDone();
            }
        } else {
            super.mousePressed(mouseEvent);
            textHolderFigure = (TextHolderFigure)this.getCreatedFigure();
            this.getView().clearSelection();
            this.getView().addToSelection(textHolderFigure);
            this.beginEdit(textHolderFigure);
            this.updateCursor(this.getView(), mouseEvent.getPoint());
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    protected void beginEdit(TextHolderFigure textHolderFigure) {
        if (this.textField == null) {
            this.textField = new FloatingTextField();
            this.textField.addActionListener(this);
        }
        if (textHolderFigure != this.typingTarget && this.typingTarget != null) {
            this.endEdit();
        }
        this.textField.createOverlay(this.getView(), textHolderFigure);
        this.textField.requestFocus();
        this.typingTarget = textHolderFigure;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    protected void endEdit() {
        if (this.typingTarget != null) {
            this.typingTarget.willChange();
            final TextHolderFigure textHolderFigure = this.typingTarget;
            final String string = this.typingTarget.getText();
            final String string2 = this.textField.getText();
            if (string2.length() > 0) {
                this.typingTarget.setText(string2);
            } else if (this.createdFigure != null) {
                this.getDrawing().remove(this.getAddedFigure());
            } else {
                this.typingTarget.setText("");
                this.typingTarget.changed();
            }
            AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                @Override
                public String getPresentationName() {
                    ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
                    return resourceBundleUtil.getString("attribute.text.text");
                }

                @Override
                public void undo() {
                    super.undo();
                    textHolderFigure.willChange();
                    textHolderFigure.setText(string);
                    textHolderFigure.changed();
                }

                @Override
                public void redo() {
                    super.redo();
                    textHolderFigure.willChange();
                    textHolderFigure.setText(string2);
                    textHolderFigure.changed();
                }
            };
            this.getDrawing().fireUndoableEditHappened(abstractUndoableEdit);
            this.typingTarget.changed();
            this.typingTarget = null;
            this.textField.endOverlay();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27 || this.isToolDoneAfterCreation()) {
            this.fireToolDone();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.endEdit();
        if (this.isToolDoneAfterCreation()) {
            this.fireToolDone();
        }
    }

    @Override
    protected void creationFinished(Figure figure) {
        this.beginEdit((TextHolderFigure)figure);
        this.updateCursor(this.getView(), new Point(0, 0));
    }

    public boolean isEditing() {
        return this.typingTarget != null;
    }

    @Override
    public void updateCursor(DrawingView drawingView, Point point) {
        if (drawingView.isEnabled()) {
            drawingView.setCursor(Cursor.getPredefinedCursor(this.isEditing() ? 0 : 1));
        } else {
            drawingView.setCursor(Cursor.getPredefinedCursor(3));
        }
    }
}

